<?php

/**
 * This is the model class for table "{{mas_vendor_mode}}".
 *
 * The followings are the available columns in table '{{mas_vendor_mode}}':
 * @property integer $id
 * @property integer $vendor_id
 * @property string $mode_name
 * @property string $isActive
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class MasVendorMode extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{mas_vendor_mode}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('vendor_id,isDefault, mode_name, transit_time', 'required'),
            array('vendor_id, created_by, updated_by', 'numerical', 'integerOnly' => true),
            array('mode_name', 'length', 'max' => 50),
            array('isActive', 'length', 'max' => 1),
            array('vendor_id', 'checkUniqueMode'),
           
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, vendor_id, mode_name, isActive, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'vendor_ref' => array(self::BELONGS_TO, 'Vendor', 'vendor_id'),
        );
    }

    public function checkUniqueMode() {

        if ($this->vendor_id>0 && $this->mode_name !== "") {
            $condition = "vendor_id = '".$this->vendor_id."' AND mode_name = '" . $this->mode_name . "'";
            if ($this->id != '') {
                $condition .= " AND id!= '" . $this->id . "'";
            }
            $model = MasVendorMode::model()->findAll(array('condition' => $condition));
            if (!empty($model)) {
                $this->addError('vendor_id', 'Vendor Id is already exist');
            } else {
                return true;
            }
        }
    }


    

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'vendor_id' => 'Vendor',
            'mode_name' => 'Mode Name',
            'isActive' => 'Is Active',
            'created_by' => 'Created By',
            'created_date_time' => 'Created Date Time',
            'updated_by' => 'Updated By',
            'updated_date_time' => 'Updated Date Time',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('vendor_id', $this->vendor_id);
        $criteria->compare('mode_name', $this->mode_name, true);
        $criteria->compare('isActive', $this->isActive, true);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('created_date_time', $this->created_date_time, true);
        $criteria->compare('updated_by', $this->updated_by);
        $criteria->compare('updated_date_time', $this->updated_date_time, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasVendorMode the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
    
    public static function getVendorMode($vendor_id=0)
	{
		$condition = 'vendor_id='.$vendor_id.' AND isActive =  "Y"';
		$model = self::model()->findAll(array('condition' => $condition,'order'=>'mode_name'));
		return CHtml::listData($model, 'id', 'mode_name');
	}

}
