<?php

/**
 * This is the model class for table "{{mas_sales_group}}".
 *
 * The followings are the available columns in table '{{mas_sales_group}}':
 * @property integer $id
 * @property string $group_name
 * @property string $isActive
 */
class MasSalesGroup extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{mas_sales_group}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('group_name', 'required'),
            
            array('group_name', 'length', 'max' => 255),
            array('group_name','filter', 'filter'=>'trim'),
            array('group_name', 'unique'),
            
            array('isActive', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, group_name, isActive,created_by,updated_by,created_datetime,updated_datetime', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'group_name' => 'Group Name',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */

        public function search() {
        $criteria = new CDbCriteria;
        $searchterm = trim(Yii::app()->request->getParam('sales_group_name'));
        //$criteria->addCondition('isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id, 'AND');
        $criteria->addCondition('isActive =  "Y"', 'AND');
        if (!empty($searchterm))
            $criteria->addCondition('group_name like "%' . $searchterm . '%"', 'AND');
        return new CActiveDataProvider($this, array(
            'pagination' => array(
                'pageSize' => 5,
            ),
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.group_name ASC',
            ),
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasSalesGroup the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getSalesGroups() {

        //$condition = 'isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id;
         $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'group_name'));
        return CHtml::listData($model, 'id', 'group_name');
    }
    
     public static function getSalesGroup() {
        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'group_name');
    }
    public static function getServiceSalesGroup() {
        $condition = 'isActive =  "Y" AND type="R"';
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'group_name');
    }
    public static function getNonHiringSalesGroup() {
        $condition = 'isActive =  "Y"  AND type!="R"';
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'group_name');
    }
}
