<?php

/**
 * This is the model class for table "{{mas_job_order_status}}".
 *
 * The followings are the available columns in table '{{mas_job_order_status}}':
 * @property integer $id
 * @property string $job_status
 * @property string $isActive
 */
class MasJobOrderStatus extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{mas_job_order_status}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('job_status,forwarder_id', 'required'),
			array('job_status', 'length', 'max'=>255),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, job_status, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'vendor' => array(self::BELONGS_TO, 'Vendor', 'forwarder_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'job_status' => 'Job Status',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('job_status',$this->job_status,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasJobOrderStatus the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public static function GetJobOrderStatus($forwarder_id=0)
	{
		$condition = 'isActive =  "Y"';
		$model = self::model()->findAll(array('condition' => $condition,'order'=>'job_status'));
		return CHtml::listData($model, 'id', 'job_status');
	}
	
	public static function getStatusOfJobOrder($status_id=0) {
	    
		$model = self::model()->findByPk($status_id);
		return $model->job_status;
	}
	
	public static function getStatusOfJobOrderByApiStatus($forwarder_id=0,$api_status="") {
	    
	    if($forwarder_id > 0 && $api_status!=""){
    		$condition = 'forwarder_id='.$forwarder_id.' AND LOWER(job_status)="'.strtolower($api_status).'"';
    		$model = self::model()->find(array('condition' => $condition));
    		
    		return $model->id;
	    }
	}
}
