<?php
class MasBrand extends CActiveRecord
{
	public function tableName()
	{
		return '{{mas_brand}}';
	}

	public function rules()
	{
		return array(
			array('brand_name', 'required'),
			array('created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('brand_name', 'length', 'max'=>50),
			array('active,is_default', 'length', 'max'=>1),
			array('created_time, updated_time', 'safe'),
			array('id, brand_name, created_by, created_time, updated_by, updated_time, active', 'safe', 'on'=>'search'),
			array('brand_name', 'checkUniqueness'),
		);
	}
	public function checkUniqueness($attribute,$params)
    {
			if($this->id>0)
			{
			$model = MasBrand::model()->find('brand_name = "'.$this->brand_name.'" AND id!='.$this->id);
			}
            else {
			$model = MasBrand::model()->find('brand_name = "'.$this->brand_name.'"');	
			}
			if(count($model)>0)	
			{
			$this->addError('id','This Brand already exist'); 
			}
    }

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'brand_name' => 'Brand Name',
			'created_by' => 'Created By',
			'created_time' => 'Created Time',
			'updated_by' => 'Updated By',
			'updated_time' => 'Updated Time',
			'active' => 'N : No, Y: Yes'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('brand_name',$this->brand_name,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_time',$this->created_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_time',$this->updated_time,true);
		$criteria->compare('active',$this->active,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Brand the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	public static function getAllBrands(){
	return CHtml::listData(self::model()->findAll( array( 'condition' => 'active="Y"', 'order' => 'is_default ASC, brand_name ASC' ) ), 'id', 'brand_name');
	}
}
