<?php

/**
 * This is the model class for table "{{customers}}".
 *
 * The followings are the available columns in table '{{customers}}':
 * @property string $id
 * @property integer $bank_id
 * @property string $bank_name
 *
 */
class MasBank extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{mas_bank}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('bank_name', 'required'),
			//array('', 'integerOnly'=>true),
                        array('bank_name', 'unique'),
			array('bank_name', 'length', 'max'=>255),
                        array('bank_code,routing_code', 'length', 'max'=>100),                         
                        array('bank_name', 'filter', 'filter'=>'trim'),
                        array('bank_name,bank_code,routing_code', 'unique'),
			//array('', 'length', 'max'=>15),
			//array('', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('bank_name,created_by,updated_by,created_datetime,updated_datetime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',			
			'bank_name' => 'Bank Name',
			
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);		
		$criteria->compare('bank_name',$this->bank_name);
		

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Customers the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        
        public static function getBanks()
        {
                 //$condition = 'isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id;
                 $condition = 'isActive =  "Y"';
                 $model = self::model()->findAll(array('condition' => $condition,'order'=>'bank_name'));
                 return CHtml::listData($model, 'id', 'bank_name');
        }
}

