<?php

/**
 * This is the model class for table "{{job_order_mail_status}}".
 *
 * The followings are the available columns in table '{{job_order_mail_status}}':
 * @property integer $id
 * @property integer $job_order_id
 * @property integer $job_order_agent_id
 * @property integer $job_order_agent_shipper_id
 * @property string $status_updated_date
 * @property integer $status_updated_count
 * @property string $status_mail_send
 * @property string $last_status
 */
class JobOrderMailStatus extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{job_order_mail_status}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			//array('job_order_id, job_order_agent_id, job_order_agent_shipper_id, status_updated_date, status_updated_count, last_status', 'required'),
			array('job_order_id, job_order_agent_id, job_order_agent_shipper_id, status_updated_count', 'numerical', 'integerOnly'=>true),
			array('status_mail_send', 'length', 'max'=>1),
			array('last_status,shipper_awb_no', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, job_order_id, job_order_agent_id, job_order_agent_shipper_id, status_updated_date, status_updated_count, status_mail_send, last_status', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'job_order_id' => 'Job Order',
			'job_order_agent_id' => 'Job Order Agent',
			'job_order_agent_shipper_id' => 'Job Order Agent Shipper',
			'status_updated_date' => 'Status Updated Date',
			'status_updated_count' => 'Status Updated Count',
			'status_mail_send' => 'Status Mail Send',
			'last_status' => 'Last Status',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('job_order_id',$this->job_order_id);
		$criteria->compare('job_order_agent_id',$this->job_order_agent_id);
		$criteria->compare('job_order_agent_shipper_id',$this->job_order_agent_shipper_id);
		$criteria->compare('status_updated_date',$this->status_updated_date,true);
		$criteria->compare('status_updated_count',$this->status_updated_count);
		$criteria->compare('status_mail_send',$this->status_mail_send,true);
		$criteria->compare('last_status',$this->last_status,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return JobOrderMailStatus the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
