<?php

/**
 * This is the model class for table "{{job_order_calculator_sub}}".
 *
 * The followings are the available columns in table '{{job_order_calculator_sub}}':
 * @property integer $id
 * @property integer $main_id
 * @property string $item_name
 * @property string $item_price
 * @property string $isActive
 */
class JobOrderCalculatorSub extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{job_order_calculator_sub}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('item_name, item_price', 'required'),
			array('main_id', 'numerical', 'integerOnly'=>true),
			array('item_name', 'length', 'max'=>255),
			array('item_price', 'length', 'max'=>10),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, main_id, item_name, item_price, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'main' => array(self::BELONGS_TO, 'JobOrderCalculatorMain', 'main_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'main_id' => 'Main',
			'item_name' => 'Item Name',
			'item_price' => 'Item Price',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('main_id',$this->main_id);
		$criteria->compare('item_name',$this->item_name,true);
		$criteria->compare('item_price',$this->item_price,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return JobOrderCalculatorSub the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public static function getJobOrderTransportTypesByItemPrice($main_id=0)
	{
	    $condition = 'isActive =  "Y"';
	    if($main_id>0){
		    $condition = ' AND main_id='.$main_id;
	    }
		$model = self::model()->findAll(array('condition' => $condition,'order'=>'item_name'));
		return CHtml::listData($model, 'item_price', 'item_name');
	}
}
