<?php

/**
 * This is the model class for table "{{job_order_agent_details}}".
 *
 * The followings are the available columns in table '{{job_order_agent_details}}':
 * @property integer $id
 * @property integer $job_order_id
 * @property integer $shipper_id
 * @property integer $cost
 * @property integer $actual_cost
 * @property integer $status
 * @property string $notes
 */
class JobOrderAgentDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public $invoice_item_id; 
	public $update_actual_cost;
	public function tableName()
	{
		return '{{job_order_agent_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('shipper_id,activity_type', 'required'),
			//array('shipper_id, cost', 'required'),
			array('job_order_id, shipper_id, status,activity_type', 'numerical', 'integerOnly'=>true),
			array('awb_no, planned_weight, planned_volume,planned_cost,actual_weight, actual_volume, actual_cost,planned_selling_price', 'length', 'max'=>100),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, job_order_id, shipper_id, awb_no, planned_weight, planned_volume,planned_cost,actual_weight, actual_volume, actual_cost, status, notes', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'joborder' => array(self::BELONGS_TO, 'JobOrder', 'job_order_id'),
            'shipper' => array(self::BELONGS_TO, 'Vendor', 'shipper_id'),
            'activitytype' => array(self::BELONGS_TO, 'MasJobOrderActivityType', 'activity_type'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'job_order_id' => 'Job Order',
			'shipper_id' => 'Shipper',
			'planned_weight' => 'Planned Weight',
			'planned_volume' => 'Planned Volume',
			'planned_cost' => 'Planned Cost',
			'actual_weight' => 'Actual Weight',
			'actual_volume' => 'Actual Volume',
			'actual_cost' => 'Auto Cost',
			'status' => 'Status',
			'notes' => 'Notes',
			'activity_type' => 'Agent Type'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('job_order_id',$this->job_order_id);
		$criteria->compare('shipper_id',$this->shipper_id);
		$criteria->compare('cost',$this->cost);
		$criteria->compare('actual_cost',$this->actual_cost);
		$criteria->compare('status',$this->status);
		$criteria->compare('notes',$this->notes,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return JobOrderAgentDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
