<?php

/**
 * This is the model class for table "{{job_order}}".
 *
 * The followings are the available columns in table '{{job_order}}':
 * @property integer $id
 * @property integer $file_id
 * @property integer $quote_id
 * @property string $job_no
 * @property string $job_date
 * @property string $origin
 * @property string $destination
 * @property string $consignee_id
 * @property string $weight
 * @property string $booking_reference
 * @property string $selling_price
 * @property string $job_order_remarks
 * @property string $terms_and_conditions
 * @property integer $lead_owner_id
 * @property string $isActive
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class JobOrder extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public $terms_id;
	public $customer_name;
	public $shipper_name;
	public $consignee_name;
	public function tableName()
	{
		return '{{job_order}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('job_date, origin, destination,lead_owner_id,customer_id,payment_terms_id,contact_ids,job_awb_no', 'required'),
			array('file_id, quote_id, lead_owner_id, created_by, updated_by,currency_id,customer_id', 'numerical', 'integerOnly'=>true),
			array('origin, destination, consignee_id,shipper_id, weight, booking_reference,exchange_rate,volume,customer_reference_no,booking_reference', 'length', 'max'=>255),
			array('selling_price,exchange_rate,transport_type,job_order_status,job_priority', 'length', 'max'=>15),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, file_id, quote_id, job_date, origin, destination, consignee_id, weight, booking_reference, selling_price, job_order_remarks, terms_and_conditions, lead_owner_id, isActive, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
            'leadowner' => array(self::BELONGS_TO, 'User', 'lead_owner_id'),
            'file' => array(self::BELONGS_TO, 'MasterFile', 'file_id'),
            'customer' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
            'currency' => array(self::BELONGS_TO, 'MasCurrency', 'currency_id'),
            'leadowner' => array(self::BELONGS_TO, 'User', 'lead_owner_id'),
            'transporttype' => array(self::BELONGS_TO, 'MasTransportType', 'transport_type'),
            'shipper' => array(self::BELONGS_TO, 'Customer', 'shipper_id'),
            'consignee' => array(self::BELONGS_TO, 'Customer', 'consignee_id'),
            'invoice' => array(self::HAS_ONE, 'Invoice', 'order_id'),
            'dest' => array(self::BELONGS_TO, 'MasCountry', 'destination'),
            'org' => array(self::BELONGS_TO, 'MasCountry', 'origin'),
            'paymentmethod' => array(self::BELONGS_TO, 'MasPaymentTerm','payment_terms_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'file_id' => 'File',
			'quote_id' => 'Quotes',
			'job_date' => 'Job Date',
			'origin' => 'Origin',
			'destination' => 'Destination',
			'consignee_id' => 'consignee_id',
			'weight' => 'Weight',
			'booking_reference' => 'Booking Reference',
			'selling_price' => 'Selling Price',
			'job_order_remarks' => 'job_order_remarks',
			'terms_and_conditions' => 'Terms And Conditions',
			'lead_owner_id' => 'Lead Owner',
			'isActive' => 'Is Active',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
			'customer_id' => 'Customer',
			'contact_ids' => 'Contact',
			'job_awb_no' => 'AWB#'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('file_id',$this->file_id);
		$criteria->compare('quote_id',$this->quote_id);
		$criteria->compare('job_date',$this->job_date,true);
		$criteria->compare('origin',$this->origin,true);
		$criteria->compare('destination',$this->destination,true);
		$criteria->compare('consignee_id',$this->consignee_id,true);
		$criteria->compare('weight',$this->weight,true);
		$criteria->compare('booking_reference',$this->booking_reference,true);
		$criteria->compare('selling_price',$this->selling_price,true);
		$criteria->compare('job_order_remarks',$this->job_order_remarks,true);
		$criteria->compare('terms_and_conditions',$this->terms_and_conditions,true);
		$criteria->compare('lead_owner_id',$this->lead_owner_id);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return JobOrder the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public static function getJobOrders()
	{
		$condition = 'isActive =  "Y"';
		$model = self::model()->findAll(array('condition' => $condition,'order'=>'id'));
		return CHtml::listData($model, 'id', 'id');
	}
	public static function updateActualCost($id)
	{
		if((int)$id>0){
		    $model_job_Agent = JobOrderAgentDetails::model()->find(array('select'=>'SUM(actual_volume) AS actual_volume,SUM(actual_weight) AS actual_weight,SUM(actual_cost) AS actual_cost','condition'=>'job_order_id='.(int)$id));
		    $modelJobOrder=new JobOrder();
            $modelJobOrder->updateByPk($id, array('total_actual_weight' => $model_job_Agent->actual_weight,'total_actual_volume' => $model_job_Agent->actual_volume,'total_actual_cost' => $model_job_Agent->actual_cost));
		}
	}
	
	public static function getJobOrderPriorityList()
	{
		$arr_job_order_priority = array(
		    
        'AF' => 'Air Freight',
        'A' => 'AWB Link Pending',
        'CL' => 'Clearance',
        'F2' => 'Collection Pending',
        'F' => 'Escalations',
        'F1' => 'Escalations 2',
        'N' => 'Normal',
        'PC' => 'Prealert - Clearance',
        'SF' => 'Sea Freight',
        );
        return $arr_job_order_priority;
	}
}
