<?php
class Inventory extends CActiveRecord
{
public $cost;
public $available_qty;
public $value;
public $customer_name;
	public function tableName()
	{
		return '{{inventory}}';
	}
	public function rules()
	{
		return array(
           array('part_number', 'filter', 'filter'=>'trim'),
           array('description', 'filter', 'filter'=>'trim'),
           array('barcode', 'filter', 'filter'=>'trim'),
			array('part_number,description,unit,type,tax_code,customer_id', 'required'),
			array('brand,unit,generic_id,created_by,updated_by,hs_code', 'numerical', 'integerOnly'=>true),
			array('rate,excise_tax,height,weight,volume,reorder_level,length,width,thickness', 'numerical'),
			array('part_number,barcode,image,material,finished', 'length', 'max'=>100),
			array('description', 'length', 'max'=>255),
			array('default_service', 'length', 'max'=>1),
			array('part_number,description,unit,type,tax_code,tax', 'safe', 'on'=>'search'),
			array('part_number', 'checkUniqueness'),
            //array('barcode', 'barcodeUniqueness'),
			array('have_expiry_date,have_serial_no', 'length', 'max' => 1),
		);
	}
	public function checkUniqueness($attribute,$params)
                                {
			if($this->id>0)
			{
			$model = Inventory::model()->find('part_number = "'.$this->part_number.'" AND customer_id ='.(int)$this->customer_id.' AND id!='.(int)$this->id);
			}
            else {
			$model = Inventory::model()->find('part_number = "'.$this->part_number.'" AND customer_id ='.(int)$this->customer_id);	
			}
			// if(count($model)>0)	
			// {
			// $this->addError('id','This Part Number already exist for Customer'); 
			// }
			if ($model !== null && is_array($model) &&  count($model) > 0) {
				$this->addError('id', 'This Part Number already exists for Customer');
			}
			
                            }
                            	public function barcodeUniqueness($attribute,$params)
                                                            {
			if($this->id>0)
			{
			$model = Inventory::model()->find('barcode = "'.$this->barcode.'" AND id!='.$this->id);
			}
                                else {
			$model = Inventory::model()->find('barcode = "'.$this->barcode.'"');	
			}
			if(is_array($model) && count($model)>0)	
			{
			$this->addError('id','This barcode already exist'); 
			}
                                                            }

	public function relations()
	{
		return array(
		'generic' => array(self::BELONGS_TO, 'MasGeneric', 'generic_id'),
		'units' => array(self::BELONGS_TO, 'MasUnit', 'unit'),
		'customer' => array(self::BELONGS_TO, 'Customer','customer_id'),
		'brands' => array(self::BELONGS_TO, 'MasBrand', 'brand'),
		'taxDetails'=> array(self::BELONGS_TO, 'MasInvTax', 'tax_code'),
                                          'totalQuantityIn' => array(self::STAT, 'StockLedger', 'product_id', 'select' => 'SUM(quantity*unit_exchange_rate)','condition' => 'transaction_type="IN" AND stock_updated="Y"'),
                                          'totalQuantityOut' => array(self::STAT, 'StockLedger', 'product_id', 'select' => 'SUM(quantity*unit_exchange_rate)','condition' => 'transaction_type="OUT" AND stock_updated="Y"'),
		);
	}

	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'part_number' => 'Part Number',
			'description' => 'Description',
			'created_by' => 'Created By',
			'created_time' => 'Created Time',
			'updated_by' => 'Updated By',
			'updated_time' => 'Updated Time',
			'active' => 'N: No, Y: Yes',
			'customer_id' =>'Customer',
		);
	}
	public function search()
	{
		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	public function getunit_exchange_rate()
	{
		return $this->units->unit_exchange_rate;
	}
	public function getUnit_symbol()

    {

        return $this->units->label;
    }
    
     public function findByPartno($part_no = NULL) {
        $model = new self;
        if (strtoupper(trim($part_no)) != NULL) {
        $part_no=strtoupper(trim($part_no));    
        $model = self::model()->find(array('condition' => 't.part_number="' . trim($part_no) . '" AND t.active="Y"'));
        }
        return $model;
    }
    public function findByPartnoCustomer($part_no = NULL,$customer_id=0) {
        $model = new self;
        if (strtoupper(trim($part_no)) != NULL && $customer_id!=0) {
            $part_no=strtoupper(trim($part_no));    
            $model = self::model()->find(array('condition' => 't.part_number="' . trim($part_no) . '" AND t.active="Y" AND customer_id='.$customer_id));
        }
        return $model;
    }
}
