<?php
class GoodsReceiptItems extends CActiveRecord {
public $product_name;
    public function tableName() {
        return '{{goods_receipt_items}}';
    }
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('product_id, description, unit, quantity', 'required'),
            array('header_id,product_id,unit', 'numerical', 'integerOnly' => true),
            array('quantity,rate', 'numerical', 'integerOnly' => true),
            array('description, unit,rate', 'length', 'max' => 100),
            array('id, product_id, description,quantity,unit', 'safe', 'on' => 'search'),
        );
    }
    
    public function relations() {
        return array(
            'product' => array(self::BELONGS_TO, 'Inventory', 'product_id'),
            'unitdetails' => array(self::BELONGS_TO, 'MasUnit', 'unit'),
            'goodsreceipt' => array(self::BELONGS_TO, 'GoodsReceipt', 'header_id'),
        );
    }
    
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'header_id' => 'Goods Receipt ID',
            'product_id' => 'Product',
            'description' => 'Description',
            'unit' => 'Unit',
            'rate' => 'Rate',
            'quantity' => 'Quantity',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'updated_time' => 'Updated Time',
            'created_time' => 'Created Time',
        );
    }

    public function search() {
        $criteria = new CDbCriteria;
        $criteria->compare('id', $this->id);
        $criteria->compare('header_id', $this->header_id);
        $criteria->compare('product_id', $this->product_id);
        $criteria->compare('description', $this->description, true);
        $criteria->compare('unit', $this->unit, true);
        $criteria->compare('quantity', $this->quantity);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
}
