<?php

/**
 * This is the model class for table "{{customer}}".
 *
 * The followings are the available columns in table '{{customer}}':
 * @property string $id
 * @property integer $lead_owner_id
 * @property integer $default_pricing_group_id
 * @property string $customer_name
 * @property string $customer_credit_limit
 * @property integer $customer_currency_id
 * @property string $customer_address
 * @property string $customer_city
 * @property string $customer_postal_code
 * @property string $customer_state
 * @property string $customer_country
 * @property integer $customer_emirates_name
 * @property string $customer_phone_no
 * @property string $customer_email_id
 * @property string $customer_location
 * @property string $customer_payment_term
 * @property string $customer_fax
 * @property string $customer_web
 * @property string $customer_industry
 * @property string $customer_trn_no
 * @property string $customer_shj_imp_code
 * @property string $is_approved
 * @property string $isActive
 * @property string $created_date_time
 * @property integer $created_by
 * @property string $updated_date_time
 * @property integer $updated_by
 */
class Customer extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public $file_title;
	public $contract_no;
	public $type_of_contract;
	public $contract_date_to;
	public $contract_date_from;
	public $shipping_address_same_as_billing;
	
	public function tableName()
	{
		return '{{customer}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('customer_name,customer_country,customer_currency_id,customer_payment_term,lead_owner_id', 'required'),
			array('lead_owner_id, default_pricing_group_id, customer_currency_id, customer_emirates_name, created_by, updated_by,lead_id', 'numerical', 'integerOnly'=>true),
			array('customer_name, customer_city, customer_postal_code, customer_state, customer_country,  customer_phone_no, customer_email_id, customer_location, customer_payment_term, customer_fax, customer_web, customer_industry, customer_trn_no, customer_shj_imp_code,nick_name,old_account_no', 'length', 'max'=>255),
			array('customer_credit_limit,cost_per_cbm', 'length', 'max'=>15),
			array('is_approved, isActive', 'length', 'max'=>1),
			array('customer_name','checkUniqueApplication'),
                        array('customer_address', 'length', 'max'=>5000),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, lead_owner_id, default_pricing_group_id, customer_name, customer_credit_limit, customer_currency_id, customer_address, customer_city, customer_postal_code, customer_state, customer_country, customer_emirates_name,  customer_phone_no, customer_email_id, customer_location, customer_payment_term, customer_fax, customer_web, customer_industry, customer_trn_no, customer_shj_imp_code, is_approved, isActive, created_date_time, created_by, updated_date_time, updated_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'country' => array(self::BELONGS_TO, 'MasCountry','customer_country'),
                    'currency_detail' => array(self::BELONGS_TO, 'MasCurrency','customer_currency_id'),
                    'contractdetails' => array(self::HAS_MANY, 'Contract','customer_id'),
                    'registrationdetails' => array(self::HAS_MANY, 'Registration','customer_id'),
                    'customercontact' => array(self::HAS_ONE, 'CustomerContact','customer_id'),
                    'user' => array(self::BELONGS_TO, 'User','lead_owner_id'),
                    'industry_details' => array(self::BELONGS_TO, 'MasIndustry','customer_industry'),
                    'pricinggroup' => array(self::BELONGS_TO, 'SalesPriceGroupName','default_pricing_group_id'),
                    'paymentmethod' => array(self::BELONGS_TO, 'MasPaymentTerm','customer_payment_term'),
					'cust_category' => array(self::BELONGS_TO, 'MasCustomerCategory','cust_category_id'),
					'client_type' => array(self::BELONGS_TO, 'MasClientType','client_type_id'),
		);
	}
	
	
	public function checkUniqueApplication($attribute, $params)
    {        if($this->id <= 0){
        if ($this->customer_name !== "") {
            $model = Customer::model()->find('customer_name = ?', array($this->customer_name));
            if ($model != null) {
                $this->addError('id', 'Customer name is already exist');
            }

        }
    }
    }

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'lead_owner_id' => 'Salesman',
			'default_pricing_group_id' => 'Default Pricing Group',
			'customer_name' => 'Customer Name',
			'customer_credit_limit' => 'Customer Credit Limit',
			'customer_currency_id' => 'Customer Currency',
			'customer_address' => 'Customer Address',
			'customer_city' => 'Customer City',
			'customer_postal_code' => 'Customer Postal Code',
			'customer_state' => 'Customer State',
			'customer_country' => 'Customer Country',
			'customer_emirates_name' => 'primary key of masemirateslist',
			'customer_phone_no' => 'Customer Phone No',
			'customer_email_id' => 'Customer Email',
			'customer_location' => 'Customer Location',
			'customer_payment_term' => 'Customer Payment Term',
			'customer_fax' => 'Customer Fax',
			'customer_web' => 'Customer Web',
			'customer_industry' => 'Customer Industry',
			'customer_trn_no' => 'Customer Trn No',
			'customer_shj_imp_code' => 'Customer Shj Imp Code',
			'is_approved' => 'Is Approved',
			'isActive' => 'Is Active',
			'created_date_time' => 'Created Date Time',
			'created_by' => 'Created By',
			'updated_date_time' => 'Updated Date Time',
			'updated_by' => 'Updated By',
			'nick_name' => 'Nick Name',
			'old_account_no' => 'Old Account No',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('lead_owner_id',$this->lead_owner_id);
		$criteria->compare('default_pricing_group_id',$this->default_pricing_group_id);
		$criteria->compare('customer_name',$this->customer_name,true);
		$criteria->compare('customer_credit_limit',$this->customer_credit_limit,true);
		$criteria->compare('customer_currency_id',$this->customer_currency_id);
		$criteria->compare('customer_address',$this->customer_address,true);
		$criteria->compare('customer_city',$this->customer_city,true);
		$criteria->compare('customer_postal_code',$this->customer_postal_code,true);
		$criteria->compare('customer_state',$this->customer_state,true);
		$criteria->compare('customer_country',$this->customer_country,true);
		$criteria->compare('customer_emirates_name',$this->customer_emirates_name);
		$criteria->compare('customer_phone_no',$this->customer_phone_no,true);
		$criteria->compare('customer_email_id',$this->customer_email_id,true);
		$criteria->compare('customer_location',$this->customer_location,true);
		$criteria->compare('customer_payment_term',$this->customer_payment_term,true);
		$criteria->compare('customer_fax',$this->customer_fax,true);
		$criteria->compare('customer_web',$this->customer_web,true);
		$criteria->compare('customer_industry',$this->customer_industry,true);
		$criteria->compare('customer_trn_no',$this->customer_trn_no,true);
		$criteria->compare('customer_shj_imp_code',$this->customer_shj_imp_code,true);
		$criteria->compare('is_approved',$this->is_approved,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Customer the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public static function getCustomers()
	{
		$condition = 'isActive =  "Y"';
		$model = self::model()->findAll(array('condition' => $condition,'order'=>'customer_name'));
		return CHtml::listData($model, 'id', 'customer_name');
	}

	public function saveSublegder()
    {
        if (isset(Yii::app()->modules['finance'])) {
            Yii::import('application.modules.finance.models.*');
            $existence = FinanceSubledger::model()->find(array('condition' => 'subledger_type_id=1 AND parent_id=' . $this->id));
            if ($existence->id > 0) {
                FinanceSubledger::model()->updateBypk(
                    $existence->id,
                    array(
                        'description' => $this->customer_name,
                        'address' => $this->customer_address,
                        'phone' => $this->customer_phone_no,
                    )
                );
            } else {
                $newItem = new FinanceSubledger;
                $newItem->description = $this->customer_name;
				$newItem->account_no = $this->id;
				$newItem->address = $this->customer_address;
				$newItem->phone = $this->customer_phone_no;
				$newItem->subledger_type_id = 1; //debtor
                $newItem->parent_id = $this->id;
				$newItem->save(false);
				
				$this->subledger_added = 'Y';
				$this->save(false);
            }
        }
    }
    public static function GetCustomerName($customer_id=0)
	{
		$model = self::model()->findByPk($customer_id);
		return $model->customer_name;
	}
	
	 public function get_generate_token()
    {
        $this->token = $this->id . '-' . time();
        $this->update();
    }
     public function findBytoken($token = NULL)
    {
        $model = new Customer;
        if (trim($token) != NULL) {
            $model = Customer::model()->find(array('condition' => 't.token="' . trim($token) . '" AND t.isActive="Y"'));
        }
        return $model;

    }
}
