<?php

/**
 * This is the model class for table "{{creditnote}}".
 *
 * The followings are the available columns in table '{{creditnote}}':
 * @property string $id
 * @property string $file_id
 * @property string $job_order_id
 * @property string $invoice_id
 * @property integer $lead_owner_id
 * @property string $customer_id
 * @property string $contact_id
 * @property string $credited_date
 * @property integer $currency_id
 * @property string $exchange_rate
 * @property string $credited_amount
 * @property string $reference
 * @property string $reason
 * @property integer $tax_type
 * @property string $total_tax_amount
 * @property string $notes
 * @property string $terms_and_conditions
 * @property string $remarks
 * @property string $isActive
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $created_date_time
 * @property string $updated_date_time
 * @property string $posted
 */
class Creditnote extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public $customer_name;
	public function tableName()
	{
		return '{{creditnote}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('file_id, job_order_id, invoice_id, lead_owner_id, customer_id, credited_date,reason', 'required'),
			array('lead_owner_id, currency_id, tax_type, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('file_id, job_order_id, invoice_id, customer_id', 'length', 'max'=>20),
			array('exchange_rate, credited_amount, total_tax_amount', 'length', 'max'=>15),
			array('reference,contact_id', 'length', 'max'=>255),
			array('isActive, posted', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, file_id, job_order_id, invoice_id, lead_owner_id, customer_id, contact_id, credited_date, currency_id, exchange_rate, credited_amount, reference, reason, tax_type, total_tax_amount, notes, terms_and_conditions, remarks, isActive, created_by, updated_by, created_date_time, updated_date_time, posted', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		 return array(
            'contact' => array(self::BELONGS_TO, 'CustomerContact', 'contact_id'),
            'file' => array(self::BELONGS_TO, 'MasterFile', 'file_id'),
            'items' => array(self::HAS_MANY, 'CreditnoteItem', 'creditnote_id'),
            'customer' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
            'currencyname' => array(self::BELONGS_TO, 'MasCurrency', 'currency_id'),
            'netAmount' => array(self::STAT, 'CreditnoteItem', 'creditnote_id', 'select' => 'SUM(net_amount)'),
            'netSales' => array(self::STAT, 'CreditnoteItem', 'creditnote_id', 'select' => 'SUM(net_amount+tax_vat_amount)'),
            'netVat' => array(self::STAT, 'CreditnoteItem', 'creditnote_id', 'select' => 'SUM(tax_vat_amount)'),
            'adItems' => array(self::HAS_MANY, 'CreditnoteAddition', 'creditnote_id'),
            'dedItems' => array(self::HAS_MANY, 'CreditnoteDeduction', 'creditnote_id'),
            'adTotal' => array(self::STAT, 'CreditnoteAddition', 'creditnote_id', 'select' => 'SUM(calculated_value)'),
            'dedTotal' => array(self::STAT, 'CreditnoteDeduction', 'creditnote_id', 'select' => 'SUM(calculated_value)'),
            //'salesgroup' => array(self::BELONGS_TO, 'MasSalesGroup', 'sales_group'),
            'invoice' => array(self::BELONGS_TO, 'Invoice', 'invoice_id'),
            'customer_details' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
        );
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'file_id' => 'File',
			'job_order_id' => 'Job Order',
			'invoice_id' => 'Invoice',
			'lead_owner_id' => 'Lead Owner',
			'customer_id' => 'Customer',
			'contact_id' => 'Contact',
			'credited_date' => 'Credited Date',
			'currency_id' => 'Currency',
			'exchange_rate' => 'Exchange Rate',
			'credited_amount' => 'Credited Amount',
			'reference' => 'Reference',
			'reason' => 'Reason',
			'tax_type' => 'Tax Type',
			'total_tax_amount' => 'Total Tax Amount',
			'notes' => 'Notes',
			'terms_and_conditions' => 'Terms And Conditions',
			'remarks' => 'Remarks',
			'isActive' => 'Is Active',
			'created_by' => 'Created By',
			'updated_by' => 'Updated By',
			'created_date_time' => 'Created Datetime',
			'updated_date_time' => 'Updated Datetime',
			'posted' => 'Posted',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('file_id',$this->file_id,true);
		$criteria->compare('job_order_id',$this->job_order_id,true);
		$criteria->compare('invoice_id',$this->invoice_id,true);
		$criteria->compare('lead_owner_id',$this->lead_owner_id);
		$criteria->compare('customer_id',$this->customer_id,true);
		$criteria->compare('contact_id',$this->contact_id,true);
		$criteria->compare('credited_date',$this->credited_date,true);
		$criteria->compare('currency_id',$this->currency_id);
		$criteria->compare('exchange_rate',$this->exchange_rate,true);
		$criteria->compare('credited_amount',$this->credited_amount,true);
		$criteria->compare('reference',$this->reference,true);
		$criteria->compare('reason',$this->reason,true);
		$criteria->compare('tax_type',$this->tax_type);
		$criteria->compare('total_tax_amount',$this->total_tax_amount,true);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('terms_and_conditions',$this->terms_and_conditions,true);
		$criteria->compare('remarks',$this->remarks,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);
		$criteria->compare('posted',$this->posted,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Creditnote the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        
    public function getFullcurrency(){
        return $this->currencyname->currency_code;
    }
}
