<?php
class CheckinItems extends CActiveRecord {
public $product_name;
    public function tableName() {
        return '{{checkin_items}}';
    }
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('product_id, description, unit, quantity', 'required'),
            array('transaction_id,product_id,unit', 'numerical', 'integerOnly' => true),
            array('quantity,rate', 'numerical', 'integerOnly' => true),
            array('description, unit,rate', 'length', 'max' => 100),
            array('id, product_id, description,quantity,unit', 'safe', 'on' => 'search'),
        );
    }
    
    public function relations() {
        return array(
            'product' => array(self::BELONGS_TO, 'Inventory', 'product_id'),
            'unitdetails' => array(self::BELONGS_TO, 'MasUnit', 'unit'),
            'goodsreceipt' => array(self::BELONGS_TO, 'GoodsReceipt', 'transaction_id'),
        );
    }
    
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'transaction_id' => 'Transaction ID',
            'product_id' => 'Product',
            'description' => 'Description',
            'unit' => 'Unit',
            'rate' => 'Rate',
            'quantity' => 'Quantity'
        );
    }

    public function search() {
        $criteria = new CDbCriteria;
        $criteria->compare('id', $this->id);
        $criteria->compare('transaction_id', $this->transaction_id);
        $criteria->compare('product_id', $this->product_id);
        $criteria->compare('description', $this->description, true);
        $criteria->compare('unit', $this->unit, true);
        $criteria->compare('quantity', $this->quantity);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
}
