<?php

class QuotationController extends Controller
{
	 public $layout = 'layout';
    public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                        'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover','PrintTermsandConditionsPDFnew'),
                        'users' => array('*'),
                ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                        'actions' => array('Index','GetQuotationList','Create','SaveQuotation','GetStatusHistoryList','PrintQuotationReportPDF','PrintTermsandConditionsPDFnew','AddToFavourite','PrintQuotationReportPDF1','Documentupload','DeleteDocument', 
                        'UploadCustomerDocuments', 'GetDocumentList','GetOtherCalculator','ChangeJobAgentStatus','UpdateJobAgentStatus','Screenshot','SaveScreenshot','GetScreenshotHistoryList',
                        'SendScreenshotMail','GetTracking','GetShipment','UpdateAPIStatus','UpdateBulkTracking','SendeMailToCustomer','LoadCustomersEmail','SendMailToCustomerSubmit','GetConsigneeDetails',
                        'GetQuotationDetails','UpdateDHLBulkTracking','DeleteQuotationItem','GetTermsnCondtns','GetVendorCostByCountryWeight','GetQuotationItemDetails','GetVendorMode','PrintQuotationReportPDFnew','AppendQtnItemData','DeleteVendorTabPane'),
                        'expression' => '$user->isMember()',

                ),

                array('deny', // deny all users

                                'users' => array('*'),
                ),
            );
    }
    public function filters() {
            return array('accessControl'); // perform access control for CRUD operations
    }

    public function actionIndex()
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        
        $this->render('index');
    }
    /*
     * function to getlist for Quotation datatable
     * modified by jisha on 17-9-18. 
     */
    public function actionGetQuotationList()
    {
            $model=new Quotation();
            $draw   = $_POST['draw'];
            $offset = $_POST['start'];
            $limit  = $_POST['length'];
            
            
            $frm  = $_POST['frm'];
            $columns = array(
                            // datatable column index  => database column name

                            0=>'file_id',
                            1=>'t.id',
                            2=>'quotation_date',
                            3=>'customer_name',
                            4=>'origin_id',
                            5=>'consignee_name',
                            6=>'destination_id',
                            7=>'transport_type_name',
            );

            $filterColumn = $columns[$_POST['order'][0]['column']];
            $filterOrder  = $_POST['order'][0]['dir'];
            
            if($_POST['order'][0]['column']==0){
                $filterColumn='t.id';
                $filterOrder='DESC';
            }
            $orderBy      = $filterColumn." ".$filterOrder;
            
            
            
            $condition="(1=1";
            //$condition="quotation_status!='CN'";
            if(isset($_POST['filter_quotation_status']) && $_POST['filter_quotation_status']!="")
            {
            	$condition =" (quotation_status='".$_POST['filter_quotation_status']."'";
            }
            
            
            if(((int) Yii::app()->user->havePermissionOn["quotes_view_all"]) == 0){
                $condition.= ' AND t.lead_owner_id= "'.Yii::app()->user->id.'"';
            }
            
            
           /* else{
                $condition  ="quotation_status IN('O','PD')";
            }*/
            if(isset($_POST['filter_quotation_transport_type']) && $_POST['filter_quotation_transport_type']!="")
            {
            	$condition.=" AND t.transport_type='".$_POST['filter_quotation_transport_type']."'";
            }
            if(isset($_POST['filter_quotation_priority']) && $_POST['filter_quotation_priority']!="")
            {
            	$condition.=" AND job_priority='".$_POST['filter_quotation_priority']."'";
            }
            if(isset($_POST['filter_quotation_no']) && $_POST['filter_quotation_no']!="")
            {
            	$condition.=" AND t.id LIKE '%".$_POST['filter_quotation_no']."%'";
            }
            if(isset($_POST['filter_quotation_shipper']) && $_POST['filter_quotation_shipper']!="")
            {
            	$condition.=" AND t.customer_id='".$_POST['filter_quotation_shipper']."'";
            }
            if(isset($_POST['filter_created_by']) && $_POST['filter_created_by']!="")
            {
            	$condition.=" AND t.created_by='".(int) $_POST['filter_created_by']."'";
            }
          
            
            if(isset($_POST['filter_quotation_date']) && $_POST['filter_quotation_date']!="")
            {
            	
            	
            	
            	$filter_quotation_date       = str_replace('/', '-', $_POST['filter_quotation_date']);
                $filter_quotation_date       = date("Y-m-d", strtotime($filter_quotation_date));
                $condition.=" AND DATE(quotation_date) LIKE'%".$filter_quotation_date."%'";   
                //$condition.= ' AND DATE(quotation_date)="'.$filter_quotation_date.'"';
            	
            	
            }
            
            //echo $condition;
            
          
            if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
            {
                $condition="(1=1 ";
                $searchString = $_POST['search']['value'];
                //$condition=" (t.id LIKE '%".$searchString."%' OR customer_name LIKE '%".$searchString."%' OR file_id LIKE '%".$searchString."%' OR origin_id LIKE '%".$searchString."%'  OR destination_id LIKE '%".$searchString."%' OR t.transport_type LIKE '%".$searchString."%' OR t.job_order_id LIKE '%".$searchString."%')";
                $condition .=" AND (t.id LIKE '%".$searchString."%' OR customer.customer_name LIKE '%".$searchString."%' OR t.job_order_id LIKE '%".$searchString."%')";
                //echo $condition;
                if(((int) Yii::app()->user->havePermissionOn["quotation_view_all"]) == 0 && Yii::app()->user->authorised_user != 1){
                    $condition.= ' AND t.lead_owner_id= "'.Yii::app()->user->id.'"';
                }
                
            }
             $condition.= ') OR (customer.accounts_manager_id="'.Yii::app()->user->id.'")';
            
           // echo $condition;
            $count = $model->with('file','leadowner','customer','transporttype')->count(array('condition'=>$condition));
            $model = $model->with('file','leadowner','customer','transporttype')->findAll(array('condition'=>$condition,'order' => 't.id DESC','limit'=>$limit,'offset'=>$offset));

            $recordsTotal = $count;
            $recordsFiltered = $count;
            $data['draw'] = $draw;
            $data['recordsTotal'] = $recordsTotal;
            $data['recordsFiltered'] = $recordsFiltered;
            $rowData=array();
            $m=1;
            foreach ($model as $j=>$row)
            {
                
        
        $forwarder_name = $modelForwarder_name->vendor_name;


                $div = '';
                $destination_id='';
                if((int)$row['destination_id']>0)
                {
                $destination_id=MasCountry::model()->findByPk($row['destination_id'])->country_name;
                }
                $origin_id='';
                if((int)$row['origin_id']>0)
                {
                $origin_id=MasCountry::model()->findByPk($row['origin_id'])->country_name;
                }
                
                switch($row['quotation_status']){
                    
                    case 'CL':
                        $row_quotation_status="Closed";
                        break;
                    case 'A':
                        $row_quotation_status="Awaiting";
                        break;
                    case 'CO':
                        $row_quotation_status="Confirmed";
                        break;
                        break;
                    case 'CA':
                        $row_quotation_status="Cancel";
                        break;
                    default:
                        $row_quotation_status="Open";
                        break;
                }
                
                $condition              = 't.isActive="Y" AND header_id='.$row['id'].' AND added_from="QN"';
                $modalActivity          = new Activity();
                $modalActivity          = $modalActivity->findAll(array('condition' => $condition));
                
                
                $status_div='';
                if(count($modalActivity) > 0){
                    $status_div = ' <a href="#" class="quotationStatusOver" id="activityhelper_'.$m.'_'.$row['id'].'"><i class="fa fa-info-circle"><div class="triangle-right"></div></i></a>'; 
                }
                $rowData[]=array($m.$status_div,
                $row['id'],
                date("d/m/Y",strtotime($row['quotation_date'])),
                $row['customer']['customer_name'],
                $origin_id,
                $row['consignee_id'],
                $destination_id,
                $row['transporttype']['transport_type'],
                $row_quotation_status,
                ($row['job_order_id'] > 0)?$row['job_order_id']:"",
                $row['createdby']['fullName'],
                array($row['quotation_status'],$row['customer_id'],$row['file_id'],$row['quotation_priority'],$row['file']['current_process_status'])
                );
                $m++;
            }
            $data['data'] = $rowData;

            echo json_encode($data);

    }
    /*
     * function to create Quotation
     * modified by jisha on 17-9-18. 
     */
    public function actionCreate()
    {
        $model              =   new Quotation();
        $modelQuotationItems  =   array(new QuotationItems);
        
        $id         = (int) Yii::app()->request->getParam('id');
        $file_id    = (int) Yii::app()->request->getParam('file_id');
        $type        = Yii::app()->request->getParam('type');
        $duplicate=(int) Yii::app()->request->getParam('duplicate');
        //echo $id;
        
        $model->file_id     = $file_id;
        
        
        if($id>0)
        {
            $model = $model->findByPk($id);
            
            $modelQuotationItems = QuotationItems::model()->findAll(array('condition'=>'quotation_id="'.$id.'"','order' => 'id ASC')); 
            if(empty($modelQuotationItems)){
                     $modelQuotationItems = array(new QuotationItems);
            }
            
            if($duplicate==1){
                $model->id='';
                $model->file_id='';
                $duplicate_qtn_id=$id;
            }
            
        }
    
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false,'jquery-2.1.4.min.js' => false);
        $this->render('create', array('model' => $model,'modelQuotationItems'=>$modelQuotationItems,'duplicate'=>$duplicate,'duplicate_qtn_id'=>$duplicate_qtn_id,'type'=>$type,'quotation_id'=>$id));
    }
    
     public function actionSaveQuotation() {
        $valid=TRUE;
        $model = new Quotation();
        $modelMaster=new MasterFile();
        //$modelQuotationStatusHistory = array(new QuotationStatusHistory());
        if (isset($_POST['Quotation'])) {         
            $scenario='';
            if ((int) @$_POST['Quotation']['id'] > 0) {
                    $model->id = (int) $_POST['Quotation']['id'];
                    $model->updated_by = Yii::app()->user->id;
                    $model->updated_date_time =date('Y-m-d h:i:s'); 
                    $model = $model->findByPK($model->id);
                    $model->scenario = 'update';
                    $scenario='update';
                    $Quotation_type = 'UPDATED';

            } else {
                    $model->created_by = Yii::app()->user->id;
                    $model->created_date_time =date('Y-m-d h:i:s');
                    $model->scenario = 'add';
                    $scenario='add';
                    $Quotation_type = 'CREATED';
            }
            $model->attributes = $_POST['Quotation'];
            $model->selling_price=str_replace(',', '', $_POST['Quotation']['selling_price']);;
            $model->remarks=$_POST['Quotation']['remarks'];
            if(is_array($_POST['Quotation']['contact_ids'])){
                $model->contact_ids=implode(",", $_POST['Quotation']['contact_ids']);
            }else{
                $model->contact_ids= $_POST['Quotation']['contact_ids'];
            }
            //$model->terms_and_conditions = $_POST['Quotation']['terms_and_conditions'];
            $model->terms_and_conditions = $_POST['terms_and_conditions'];
            $model->terms_id = $_POST['Quotation']['terms_id'];
            $model->priority_agent_id = $_POST['Quotation']['priority_agent_id'];
            
            
            if($_POST['Quotation']['quotation_date']!=''){
                $model->quotation_date = str_replace('/', '-', $_POST['Quotation']['quotation_date']);
                $model->quotation_date= date("Y-m-d", strtotime($model->quotation_date));
            }
            $valid = $valid && $model->validate();
            
            // echo '<pre>';
            // print_r($_POST['QuotationItems']);
            // exit;
            
            $p=0;
            if (is_array($_POST['QuotationItems'])) {
                $prod_id=0;
                foreach ($_POST['QuotationItems'] as $i => $item) {                    
                    foreach ($item as $innerArr) {
                    
                        if ($innerArr['id'] > 0) {
                            $modelQuotationItems[$p] = QuotationItems::model()->findByPK($innerArr['id']); 
                        } else {
                            $modelQuotationItems[$p] = new QuotationItems; 
                        }
                        //$modelQuotationItems[$p]->attributes  =   $item[$i];
                        $modelQuotationItems[$p]->forwarder_id=   $innerArr['forwarder_id'];
                        $modelQuotationItems[$p]->profit_val=   $innerArr['profit_val'];
                        $modelQuotationItems[$p]->mode_id=   $innerArr['mode_id'];
                        $modelQuotationItems[$p]->mode_transit_time=   $innerArr['mode_transit_time'];
                        $modelQuotationItems[$p]->activity_type    =   $innerArr['activity_type'];
                        $modelQuotationItems[$p]->planned_weight    =   $innerArr['planned_weight'];
                        $modelQuotationItems[$p]->planned_volume    =   $innerArr['planned_volume'];
                        $modelQuotationItems[$p]->planned_cost   =   $innerArr['planned_cost'];
                        $modelQuotationItems[$p]->planned_selling_price = $innerArr['planned_selling_price'];
                        $modelQuotationItems[$p]->notes =   $innerArr['notes'];
                        if($model->priority_agent_id==$innerArr['forwarder_id']){
                                $modelQuotationItems[$p]->priority_agent  =   'Y';
                        }else{
                                $modelQuotationItems[$p]->priority_agent  =   'N';
                        }
                        $valid = $modelQuotationItems[$p]->validate() && $valid;
                        $p++;
                    }
                    //code ends 
                        
                        /* if ($item['id'] > 0) {
                            $modelQuotationItems[$p] = QuotationItems::model()->findByPK($item['id']); 
                        } else {
                            $modelQuotationItems[$p] = new QuotationItems; 
                        }
                        
                            $modelQuotationItems[$p]->attributes              =   $_POST['QuotationItems'][$i];
                            $modelQuotationItems[$p]->activity_type          =   $item['activity_type'];
                            $modelQuotationItems[$p]->planned_weight          =   $item['planned_weight'];
                            $modelQuotationItems[$p]->planned_volume          =   $item['planned_volume'];
                            $modelQuotationItems[$p]->planned_cost            =   $item['planned_cost'];
                            $modelQuotationItems[$p]->planned_selling_price   =   $item['planned_selling_price'];
                            $modelQuotationItems[$p]->notes                   =   $item['notes'];
                            if($model->priority_agent_id==$item['forwarder_id']){
                                $modelQuotationItems[$p]->priority_agent          =   'Y';
                            }else{
                                $modelQuotationItems[$p]->priority_agent          =   'N';
                            }
                          
                            
                            $valid = $modelQuotationItems[$p]->validate() && $valid;
                            $p++;
                    */
                }
            }  
           /* echo '<pre>';
            print_r($modelQuotationStatusHistory);
           exit;  */    
            if ($valid) {	
                
               
                if ((int) @$_POST['Quotation']['file_id'] > 0) {
                    $file_id = (int) @$_POST['Quotation']['file_id'];
                    $modelMaster = $modelMaster->findByPk($file_id);
                } else {
                    $modelMaster->customer_id = 0;
                    $modelMaster->current_process_status = "Q";
                    $modelMaster->crm_user_id = Yii::app()->user->id;
                    $modelMaster->created_by = Yii::app()->user->id;
                    $modelMaster->created_datetime = date('Y-m-d h:i:s');
                    $modelMaster->file_title = "";
                    $modelMaster->lead_owner_id =  $_POST['Quotation']['lead_owner_id'];
                    $modelMaster->save(false);
                }	
                if((int) $_POST['Quotation']['file_id']==0)
                {
                    $model->file_id = $modelMaster->id;
                }else{
                    $model->file_id = $_POST['Quotation']['file_id'];
                }
                $model->save();
                
                $total_planned_weight   =   0;
                $total_planned_volume   =   0;
                $total_planned_cost     =   0;
                $total_actual_weight    =   0;
                $total_actual_volume    =   0;
                $total_actual_cost      =   0;
                $total_planned_selling_price      =   0;
                if(!empty($modelQuotationItems)){
                    $status_delivered_count=0;
                    foreach ($modelQuotationItems as $eachModel) {
                        $eachModel->quotation_id = $model->id;
                        $eachModel->save(false);
                        
                        $total_planned_weight+=$eachModel->planned_weight;
                        $total_planned_volume+=$eachModel->planned_volume;
                        $total_planned_cost+=$eachModel->planned_cost;
                        $total_planned_selling_price+=$eachModel->planned_selling_price;
                        
                        
                    }
                }
                
                
                $quotation_status = $_POST['Quotation']['quotation_status'];
                
                $model->updateByPk($model->id, array('total_planned_weight' => $total_planned_weight,'total_planned_volume' => $total_planned_volume,'total_planned_cost' => $total_planned_cost,'quotation_status'=>$quotation_status,'selling_price'=>$total_planned_selling_price));
                
                
                
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'QUOTATION',
                    Yii::app()->user->id,
                    $Quotation_type,
                    " with Quotation No - {$model->id}  "
                );
                // end audit log 
                
                echo CJSON::encode( array('status' => 'success' ));
                
              
                            
            }
            else {                    
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if ($modelQuotationItems[0]->forwarder_id > 0)
                    $error2 = json_decode(CActiveForm::validateTabular($modelQuotationItems, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";
                $error = CJSON::encode(array_merge_recursive($error1, $error2));
                if ($error != '[]')
                    echo $error;
            }              
        }
    }
    
    
    
    public function actionPrintQuotationReportPDF(){
        $id         = (int) Yii::app()->request->getParam('id');
        $modelQuotation = Quotation::model()->findByPk($id);
        $model = new Quotation();
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
                  
        $mPDF1->WriteHTML($this->renderPartial('application.modules.logistics.views.pdf.quotation_list_individual', array('model' => $model, 'id' => $id, 'title' => $title, 'title' => $title,'type'=>$type),true));
        //$mPDF1->Output("Quotation123.pdf", 'I');
        $mPDF1->Output("Quotation_".$id."_".$modelQuotation->customer->customer_name.".pdf", 'I');
        
    }

    public function actionPrintQuotationReportPDFnew(){
        $id         = (int) Yii::app()->request->getParam('id');
        $modelQuotation = Quotation::model()->findByPk($id);

        $model = new Quotation();
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
                  
        $mPDF1->WriteHTML($this->renderPartial('application.modules.logistics.views.pdf.quotation_list_individual_new', array('model' => $model, 'id' => $id, 'title' => $title, 'title' => $title,'type'=>$type),true));

        //$mPDF1->Output("Quotation123.pdf", 'I');

        //$mPDF1->Output("Quotation_".date('d/m/Y').".pdf", 'I');
        //code added sarika6-09-2023
          $mPDF1->Output("Quotation_".$id."_".$modelQuotation->customer->customer_name.".pdf", 'I');
        //endoce
        
    }

    public function actionPrintTermsandConditionsPDFnew(){
        
        $agentid         =  Yii::app()->request->getParam('agent');
        
        
        if((int) $agentid > 0){
            $Quote_id         =  Yii::app()->request->getParam('id');
            $company         =  Yii::app()->request->getParam('company');
           // echo $encodedJSON = base64_decode($encodedJ
            $agentid = base64_decode($agentid);
            $company = base64_decode($company);
            $modelVendor = Vendor::model()->findByPk($id);
            $model = new Vendor();
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
            
    
    
            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
            $mPDF1->WriteHTML($stylesheet, 1);
                      
            $mPDF1->WriteHTML($this->renderPartial('application.modules.logistics.views.pdf.agent_terms_and_conditions_new', array('model' => $model, 'agentid' => $agentid,'Quote_id'=>$Quote_id,'company'=>$company),true));
            //$mPDF1->Output("Quotation123.pdf", 'I');
            $mPDF1->Output("TermsandConditions_".date('d/m/Y').".pdf", 'D');
        }
        else{
            if ($error = Yii::app()->errorHandler->error) {

            if (Yii::app()->request->isAjaxRequest)

                echo $error['message'];

            else

                $this->render('error', $error);

        }

        }
        
    }

public function actionPrintQuotationReportPDF1(){
        $id         = (int) Yii::app()->request->getParam('id');
        $modelQuotation = Quotation::model()->findByPk($id);
        $model = new Quotation();
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
                  
        $mPDF1->WriteHTML($this->renderPartial('application.modules.logistics.views.pdf.quotation_list_individual_1', array('model' => $model, 'id' => $id, 'title' => $title, 'title' => $title,'type'=>$type),true));
        //$mPDF1->Output("Quotation123.pdf", 'I');
        $mPDF1->Output("Quotation_".$id."_".$modelQuotation->customer->customer_name.".pdf", 'I');
        
    }

    
    public function actionAddToFavourite(){
        $id         = (int) Yii::app()->request->getParam('quotation_id');
        $model = new Quotation();
        $model->updateByPk($id, array('job_priority' => 'F'));
        echo CJSON::encode( array('status' => 'success' ));
    }
    
    public function actionDeleteQuotationItem(){
        $id = $_POST['id'];

        $model = new QuotationItems();

        $model->deleteByPk($id);

        $jsonData['status'] = 'success';

        $jsonData['id'] = $id;

        echo CJSON::encode($jsonData);
    }
    
    
    
    public function actionGetTermsnCondtns()
    {
        $id = $_POST['vendor_id'];
        $modelVendor = Vendor::model()->findByPk($id);
        $vendor_termsnconditions = $modelVendor->vendor_termsnconditions;
        echo $vendor_termsnconditions;
    }
    
    public function actionGetVendorCostByCountryWeight(){
        $model = new QuotationPriceList();
        $quotation_date = $_POST['quotation_date'];
        $country_id = $_POST['origin'];
        
        $destination_country_id = $_POST['destination'];
        $weight = $_POST['weight'];
        $whole = floor($weight); 
        $decimal = fmod($weight, 1);
        
        
        
        $modelPriceTagAgents = new Vendor();
        
        $modelPriceTagAgents = $modelPriceTagAgents->findAll(array('condition'=>'isActive="Y" AND price_tag="Y"','order'=>'vendor_name'));
        $html = '<table class="table"><tr><th>
                <select id="vendorDropdown">';
        $html .= '<option value="" disabled selected>Select Vendor</option>';
        foreach($modelPriceTagAgents as $i=>$eachVendorList){
            
            
            $fuel_charge_percentage = 0;
            if($quotation_date!=''){
                $quotation_date = str_replace("/","-",$quotation_date);
                $quotation_date = date('Y-m-d', strtotime($quotation_date));
                $modelFuelSubCharges = new FuelSubCharges();
                $modelFuelSubCharges = $modelFuelSubCharges->find(array('condition'=>'agent_id='.$eachVendorList->id.' AND "'.$quotation_date.'" BETWEEN from_date AND to_date'));
                $fuel_charge_percentage = $modelFuelSubCharges->fuel_sur_charge;
                //echo $fuel_charge_percentage;
            }
            
            $condition= 'isActive="Y"  AND agent_id='.$eachVendorList->id;
            
            if($country_id==143){
                $condition.= ' AND country_id="'.$country_id.'"';
            }
            else{
                $condition.= ' AND destination_country_id="'.$destination_country_id.'"';
            }
            
            
            if($whole >70){
                $weight = -70;
                $condition.= ' AND price_type="O"  AND weight >="'.$weight.'"';
            }
            else{
               $condition.= ' AND weight >="'.$weight.'"'; 
            }
           //echo $condition."<br>";
            $modelQuotationPriceList = $model->find(array('condition' => $condition,'order'=>'abs(weight-'.$weight.')')); 
            
            //echo $modelQuotationPriceList->price;
            
            
           
            
            if($whole >70){
                $unit_price = $modelQuotationPriceList->price;
                $price = $unit_price * $_POST['weight'];
            }
            else{
                $price = $modelQuotationPriceList->price;
            }
            
            
            if((int) $fuel_charge_percentage > 0){
                $added_price = ($price*$fuel_charge_percentage)/100;
                $price = $price + $added_price;
            }else{
               $price = $price; 
            }
            $price = number_format( $price, 2, '.', '' );
            
            //  $html .= '
            // <th>
            // <button type="button" class="btn btn-theme btn-in-li" onclick="setForwarderPrice('.$eachVendorList->id.','.$price.')">'.$eachVendorList->vendor_name.'</button>
            // <br/><input type="hidden" name="hid_price_'.$i.'" id="hid_price_'.$i.'" value="'.$price.'">'.$price.'</th>';
            
            /*$html.= '<tr id="price_table_data">';
            $price = number_format( $price, 2, '.', '' );
            $html .= '<td id="price_val_'.$i.'"><input type="hidden" name="hid_price_'.$i.'" id="hid_price_'.$i.'" value="'.$price.'">'.$price.'</td>';*/
            $image = !empty($eachVendorList->vendor_logo) ? 'uploads/forwarder/'.$eachVendorList->vendor_logo : 'images/flight.jpg';

            $html .= '
            <option 
                value="' . $eachVendorList->id . '" 
                data-imagesrc="'.$image.'" 
                data-description="' . $price . '"
            >
                ' . $eachVendorList->vendor_name . '
            </option>';
            
           
        }
        $html .= '</select>
        </th></tr></table>';
        //$vendor_array = array('UPS1','UPS2');
        
            /*if($whole >70){
                $weight = -70;
                
                $condition = 'isActive="Y"';
                //$condition .= ' AND agent="'.$row.'"';
                $condition .= ' AND country_id="'.$country_id.'"';
                $condition .= ' AND weight ="'.$weight.'"';
                $condition .= ' AND price_type="O"';
                $modelQuotationPriceList = $model->findAll(array('condition' => $condition,'limit'=>2));
                foreach($modelQuotationPriceList as $eachpricelist){
                    $unit_price = $eachpricelist->price;
                    $price = $unit_price*$_POST['weight'];
                    $price_data[] = $price; 
                }
               
                
            }else{
                
                $condition = 'isActive="Y"';
                //$condition .= ' AND agent="'.$row.'"';
                $condition .= ' AND country_id="'.$country_id.'"';
                $condition .= ' AND weight >="'.$weight.'"';
                
                $arr_agent_ids = '1,4,15,78,157';//1-DHL,4-UPS1,15-UPS2,78-DHL - Eternity,157-DHL3
                
                $condition.=' AND agent_id IN('.$arr_agent_ids.')';
                //$modelQuotationPriceList = $model->findAll(array('condition' => $condition,'order'=>'abs(weight-'.$weight.')','limit'=>2));
                $modelQuotationPriceList = $model->findAll(array('condition' => $condition,'order'=>'abs(weight-'.$weight.')'));
                foreach($modelQuotationPriceList as $eachpricelist){
                    $price_data[] = $eachpricelist->price;
                }
                
                
               
                
            }
            
            
            
            $html = '';
             //As per the team meeting pass onclick argument value manually 23-03-2023 11954-Infinity
            $html .= '<table class="table"><tr><th>
            <button type="button" class="btn btn-theme btn-in-li" onclick="setForwarderPrice(4)">UPS1</button>
            </th>
            <th>
            <button type="button" class="btn btn-theme btn-in-li" onclick="setForwarderPrice(15)">UPS2</button>
            </th>
            <th>
            <button type="button" class="btn btn-theme btn-in-li" onclick="setForwarderPrice(1);">DHL</button>
            </th>
            <th>
            <button type="button" class="btn btn-theme btn-in-li" onclick="setForwarderPrice(78);">DHL - Eternity</button>
            </th>
            <th>
            <button type="button" class="btn btn-theme btn-in-li" onclick="setForwarderPrice(157);">DHL3</button>
            </th>
            </tr>
            
            <tr id="price_table_data">';
            $i=1;
            foreach($price_data as $price){
                if($price){
                    $quotation_date = str_replace("/","-",$quotation_date);
                    $quotation_date = date('Y-m-d', strtotime($quotation_date));
                    $model = new FuelSubCharges();
                    $sql = "SELECT fuel_sur_charge FROM erp_fuel_sub_charges WHERE '".$quotation_date."' BETWEEN from_date AND to_date";
                    $rawData = Yii::app()->db->createCommand($sql)->queryAll();
                    $fuel_charge = $rawData[0]['fuel_sur_charge'];
                    if($fuel_charge){
                        $added_price = ($price*$fuel_charge)/100;
                        $price = $price + $added_price;
                    }else{
                       $price = $price; 
                    }
                    $price = number_format( $price, 2, '.', '' );
                    $html .= '<td id="price_val_'.$i.'"><input type="hidden" name="hid_price_'.$i.'" id="hid_price_'.$i.'" value="'.$price.'">'.$price.'</td>';
                    $i++;
                }
            }
            $html .= '</tr></table>';*/
           //echo '<pre>';print_r($html);exit;
       
        $jsonData['status'] = 'success';
        $jsonData['price_data'] = $html;
        echo CJSON::encode($jsonData); 
    }
    
    /*public function actionGetVendorCostByCountryWeight(){
        $model = new QuotationPriceList();
        $quotation_date = $_POST['quotation_date'];
        $country_id = $_POST['origin'];
        $weight = $_POST['weight'];
        $whole = floor($weight); 
        $decimal = fmod($weight, 1);
        
        
        //$vendor_array = array('UPS1','UPS2');
        
            if($whole >70){
                $weight = -70;
                
                $condition = 'isActive="Y"';
                //$condition .= ' AND agent="'.$row.'"';
                $condition .= ' AND country_id="'.$country_id.'"';
                $condition .= ' AND weight ="'.$weight.'"';
                $condition .= ' AND price_type="O"';
                $modelQuotationPriceList = $model->findAll(array('condition' => $condition,'limit'=>2));
                foreach($modelQuotationPriceList as $eachpricelist){
                    $unit_price = $eachpricelist->price;
                    $price = $unit_price*$_POST['weight'];
                    $price_data[] = $price; 
                }
               
                
            }else{
                
                $condition = 'isActive="Y"';
                //$condition .= ' AND agent="'.$row.'"';
                $condition .= ' AND country_id="'.$country_id.'"';
                $condition .= ' AND weight >="'.$weight.'"';
                
                $arr_agent_ids = '1,4,15,78,157';//1-DHL,4-UPS1,15-UPS2,78-DHL - Eternity,157-DHL3
                
                $condition.=' AND agent_id IN('.$arr_agent_ids.')';
                //$modelQuotationPriceList = $model->findAll(array('condition' => $condition,'order'=>'abs(weight-'.$weight.')','limit'=>2));
                $modelQuotationPriceList = $model->findAll(array('condition' => $condition,'order'=>'abs(weight-'.$weight.')'));
                foreach($modelQuotationPriceList as $eachpricelist){
                    $price_data[] = $eachpricelist->price;
                }
                
                
               
                
            }
            
            
            
            $html = '';
             //As per the team meeting pass onclick argument value manually 23-03-2023 11954-Infinity
            $html .= '<table class="table"><tr><th>
            <button type="button" class="btn btn-theme btn-in-li" onclick="setForwarderPrice(4)">UPS1</button>
            </th>
            <th>
            <button type="button" class="btn btn-theme btn-in-li" onclick="setForwarderPrice(15)">UPS2</button>
            </th>
            <th>
            <button type="button" class="btn btn-theme btn-in-li" onclick="setForwarderPrice(1);">DHL</button>
            </th>
            <th>
            <button type="button" class="btn btn-theme btn-in-li" onclick="setForwarderPrice(78);">DHL - Eternity</button>
            </th>
            <th>
            <button type="button" class="btn btn-theme btn-in-li" onclick="setForwarderPrice(157);">DHL3</button>
            </th>
            </tr>
            
            <tr id="price_table_data">';
            $i=1;
            foreach($price_data as $price){
                if($price){
                    $quotation_date = str_replace("/","-",$quotation_date);
                    $quotation_date = date('Y-m-d', strtotime($quotation_date));
                    $model = new FuelSubCharges();
                    $sql = "SELECT fuel_sur_charge FROM erp_fuel_sub_charges WHERE '".$quotation_date."' BETWEEN from_date AND to_date";
                    $rawData = Yii::app()->db->createCommand($sql)->queryAll();
                    $fuel_charge = $rawData[0]['fuel_sur_charge'];
                    if($fuel_charge){
                        $added_price = ($price*$fuel_charge)/100;
                        $price = $price + $added_price;
                    }else{
                       $price = $price; 
                    }
                    $price = number_format( $price, 2, '.', '' );
                    $html .= '<td id="price_val_'.$i.'"><input type="hidden" name="hid_price_'.$i.'" id="hid_price_'.$i.'" value="'.$price.'">'.$price.'</td>';
                    $i++;
                }
            }
            $html .= '</tr></table>';
           //echo '<pre>';print_r($html);exit;
       
        $jsonData['status'] = 'success';
        $jsonData['price_data'] = $html;
        echo CJSON::encode($jsonData); 
    }*/
    
    public function actionGetQuotationItemDetails(){
        $agent_id               =   (int) Yii::app()->request->getParam('agent_id');
        $new_chk_box_id         =   (int) Yii::app()->request->getParam('new_chk_box_id');
        $frm                    =   Yii::app()->request->getParam('frm');
        $price                    =   Yii::app()->request->getParam('price');
        $model                  =   new Quotation();
        $modelQuotationItems    =   array(new QuotationItems);
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false,'jquery-2.1.4.min.js' => false);
        $this->render('ajax_quotation_item', array('model' => $model,'modelQuotationItems'=>$modelQuotationItems,'agent_id'=>$agent_id,'new_chk_box_id'=>$new_chk_box_id,'frm'=>$frm,'price'=>$price));
    }
    
    public function actionGetVendorMode(){
        $agent_id         = (int) Yii::app()->request->getParam('agent_id');
        $new_id         = (int) Yii::app()->request->getParam('newId');
        $model = new QuotationItems();
        $drop= CHtml::activedropDownList($model,  "[" . $new_id . "]mode_id", MasVendorMode::getVendorMode($agent_id),  array('class' => 'tooltipster go','prompt'=>'--Select--'));
        
       $modelVendor = Vendor::model()->with('vendormode')->findByPk($agent_id);
      
       $agent_default_mode_id=$modelVendor->vendormode->id;
       $transit_time = $modelVendor->vendormode->transit_time;
        
        
        $data['agent_default_mode_id']  = $agent_default_mode_id;
        $data['transit_time']  = $transit_time;
        $data['mode']  = $drop;
         echo CJSON::encode($data);
    }
     // code added to apend data qtn ite
    public function actionAppendQtnItemData(){
        $agent_id = (int)Yii::app()->request->getParam('agent_id');
        $agent_name = Yii::app()->request->getParam('agent_name');
        $agent_price = Yii::app()->request->getParam('price');
        $last_j_value = Yii::app()->request->getParam('last_j_value');
        $model              =   new Quotation();
        $modelQuotationItems  =   array(new QuotationItems);   
        $this->renderPartial('ajax_qtn_item', array('model' => $model,'modelQuotationItems'=>$modelQuotationItems,'agent_name'=>$agent_name,'agent_id'=>$agent_id,'last_j_value'=>$last_j_value,'agent_price'=>$agent_price)); 
    }
    public function actionDeleteVendorTabPane(){
        $forwarderId = (int)Yii::app()->request->getParam('forwarderId');
        $id = (int)Yii::app()->request->getParam('id');
        $model = new QuotationItems();
        $model->deleteAll('quotation_id = :quotationId AND forwarder_id = :forwarderId', array(':quotationId' => $id, ':forwarderId' => $forwarderId));
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    //end code
    public function actionGetConsigneeDetails() {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = 'consignee_id LIKE "%' . $searchTerm . '%"';
 
        $model = new Quotation();
        $model = $model->findAll(array('select' => 'consignee_id', 'condition' => $condition, 'limit' => 200,'group'=>'consignee_id'));
        $i = 0;
        $data = array();
        foreach ($model as $eachModel) {
             
            $data[$i]['value'] = trim($eachModel->consignee_id);
            $data[$i]['label'] = trim($eachModel->consignee_id);
             $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }  
}