<?php

class PackagingController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetList', 'Create', 'Save', 'PackageConversion', 'Receiptitemsdetail', 'UpdatePackage', 'SavePackaging', 'GoodsReceiptConversion', 'PackageGoodsReceiptConversion',
                    'SavePackagingConversionGoodsReceipt', 'GetBins', 'GetRacks', 'PackageGoodsIssueConversion', 'SaveGoodsIssuePackaging', 'SaveGoodsReceiptPackaging', 'PackageGoodsReceipt',
                    'PackageGoodsIssue', 'Issueitemsdetail', 'UpdateIssuePackage', 'SavePackagingConversionGoodsIssue'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $frm = Yii::app()->request->getParam('frm');
        $hire = Yii::app()->request->getParam('hire');
        $this->render('index', array('frm' => $frm, 'hire' => $hire));
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionGetList() {
        $model = new Packaging();

        $frm = Yii::app()->request->getParam('frm');
        $hire = Yii::app()->request->getParam('hire');
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.transaction_id',
            2 => 't.transaction_date',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';
        if (!empty($frm)) {
            switch ($frm) {
                case 'GR' :
                    $condition = 't.transaction_type="' . $frm . '" AND t.active="Y" AND transaction.state="PACKAGING"';
                    break;
                case 'GI' :
                    $condition = 't.transaction_type="' . $frm . '" AND t.active="Y" AND goodsissue.state="PACKAGING"';
                    break;
            }
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" AND (t.transaction_id LIKE '%" . $searchString . "%' OR t.transaction_type LIKE '%" . $searchString . "%')";
        }
        switch ($frm) {
            case 'GR' :
                $count = $model->with('transaction')->count(array('condition' => $condition));
                $model = $model->with('transaction')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.transaction_date desc'));
                $no = $row->transaction->receipt_no;
                $customer_name = $row->transaction->customer->customer_name;
                break;
            case 'GI' :
                $count = $model->with('goodsissue')->count(array('condition' => $condition));
                $model = $model->with('goodsissue')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.transaction_date desc'));
                $no = $row->transaction->issue_no;
                $customer_name = $row->goodsissue->customer->customer_name;
                break;
        }

        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $transaction_date = date("d/m/Y", strtotime($row['transaction_date']));
            switch ($frm) {
                case 'GR' :
                    $no = $row->transaction->receipt_no;
                    $customer_name = $row->transaction->customer->customer_name;
                    break;
                case 'GI' :
                    $no = $row->goodsissue->issue_no;
                    $customer_name = $row->goodsissue->customer->customer_name;
                    break;
            }
            $rowData[] = array($no, $transaction_date, $customer_name, $row->transaction->reference, $row->transaction->id, $row->transaction_type, $row->id);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionPackageGoodsReceiptConversion() {
        $model = new Checkin();
        $modelItems = new CheckinItems();
        $transaction_id = (int) Yii::app()->request->getParam('id');
        $status = Yii::app()->request->getParam('status');
        
        $data_exist=0;
        if($status=='GR'){
            $modelGoodsReceipt = new GoodsReceipt();
            
            $modelGoodsReceipt = $modelGoodsReceipt->findByPk($transaction_id);
            
            if($modelGoodsReceipt->state=="PACKAGING" || $modelGoodsReceipt->state=="COMPLETED"){
                $data_exist=1;
            }
            
        }
        
        $checkin = $model->find(array('condition' => 'transaction_id=' . $transaction_id . ' AND transaction_type="' . $status . '"'))->id;
        $model = $model->findByPk($checkin);
        $CheckinItems = CheckinItems::model()->findAll(array('condition' => 'checkin_id=' . $checkin));
        
        if($data_exist==0){
            //delete data from temp table
            $DEL_SQL='DELETE FROM temp_packaging_items WHERE transaction_id=' . $transaction_id . ' AND transaction_type="' . $status . '"';
            Yii::app()->db->createCommand($DEL_SQL)->execute();
             //insert data into temp table
            $SQL = 'INSERT INTO temp_packaging_items (transaction_type,checkin_id,checkin_item_id,transaction_id,transaction_item_id,product_id,description,quantity,unit,default_product_unit,unit_exchange_rate,rate,bill_of_entry_exit,length,breadth,height) 
            SELECT transaction_type,checkin_id,id,transaction_id,transaction_item_id,product_id,description,quantity,unit,default_product_unit,unit_exchange_rate,rate,bill_of_entry_exit,length,breadth,height FROM erp_checkin_items WHERE transaction_id=' . $transaction_id . ' AND transaction_type="' . $status . '"';
            Yii::app()->db->createCommand($SQL)->execute();
        }
        
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('packaging_goods_receipt_form', array('transaction_id' => $transaction_id, 'checkin_id' => $checkin, 'model' => $model, 'status' => $status, 'items' => $CheckinItems,'data_exist'=>$data_exist));
    }

    public function actionReceiptitemsdetail() {
        $checkin_item_id = (int) Yii::app()->request->getParam('id');
        $checkin_items = CheckinItems::model()->findByPk($checkin_item_id);
        $data_exist=0;
        if((int) $checkin_items['transaction_id'] > 0 && $checkin_items['transaction_type']=='GR'){
            $modelGoodsReceipt = new GoodsReceipt();
            
            $modelGoodsReceipt = $modelGoodsReceipt->findByPk($checkin_items['transaction_id']);
            
            if($modelGoodsReceipt->state=="PACKAGING" || $modelGoodsReceipt->state=="COMPLETED"){
                $data_exist=1;
            }
            
        }
        $html = "<div class='table-responsive' id='packaging_items'>";
        if($data_exist==0){
            
            $html.=CHtml::hiddenField('checkin_id', $checkin_items->checkin_id);
            $html.=CHtml::hiddenField('checkin_item_id', $checkin_item_id);
            $html.=CHtml::hiddenField('checkin_qty', $checkin_items->quantity);
            $html.=CHtml::hiddenField('checkin_unit', $checkin_items->unit);
            $html.=CHtml::hiddenField('checkin_default_product_unit', $checkin_items->default_product_unit);
            $html.=CHtml::hiddenField('unit_exchange_rate', $checkin_items->unit_exchange_rate);
            $html.="<table class='table table-hover table-bordered personal-task' id='packaging_item_table'>
       <tr><th>No</th><th>Product</th><th>Qty</th><th>Unit</th><th>Rate</th><th>Bill of Entry</th><th class='text-center'>" . CHtml::link('<i class="fa fa-plus"></i>', 'javascript:void(0);', array('class' => 'btn btn-sm btn-danger', 'onclick' => 'AddPackagingTableRow($(\'#packaging_item_table\'))', 'title' => 'Add Items')) . "</th></tr>";
            $items = array(new PackagingItems);
            foreach ($items as $model) {
                $html.="<tr><td><label>1</label></td><td>" . CHtml::activeHiddenField($model, '[1]product_id', array('value' => $checkin_items->product_id)) . CHtml::activeHiddenField($model, '[1]description', array('value' => $checkin_items->description)) . $checkin_items->description . "</td>
       <td>" . CHtml::activeTextField($model, '[1]quantity', array('class' => 'qty go cell-center text-right', 'onkeypress' => 'return isNumberKey(event)', 'data-label' => 'Quantity', 'value' => $checkin_items->quantity)) . "</td>
       <td>" . CHtml::activeDropdownList($model, '[1]unit', MasUnit::getSimilarUnits($checkin_items->unit), array('class' => 'qty go')) . "</td><td>" . CHtml::activeTextField($model, '[1]rate', array('class' => 'rate go cell-center text-right', 'data-label' => 'Rate', 'value' => $checkin_items->rate, 'readonly' => true)) . "</td>
       <td>" . CHtml::activeTextField($model, '[1]bill_of_entry_exit', array('data-label' => 'Bill of Entry', 'class' => 'go', 'value' => $checkin_items->bill_of_entry_exit)) . "</td><td class='text-center'>" . CHtml::link('<i class="fa fa-close"></i>', 'javascript:void(0);', array('class' => 'btn btn-sm btn-danger', 'onclick' => 'removeTableRowitempackaging($(\'#packaging_item_table\'),this)', 'title' => 'Remove this item')) . "</td></tr>";
            }
            $html.="</table>";
            
        }
        else{
            $html.="<table class='table table-hover table-bordered personal-task' id='packaging_item_table'>
                    <tr>
                    <th>No</th>
                    <th>Product</th>
                    <th>Qty</th>
                    <th>Unit</th>
                    <th>Rate</th>
                    <th>Bill of Entry</th>
                    </tr>";
           $html.="<tr><td colspan='6' align='center'><b>No Data Exist</b></td></tr>";         
                    
        }
        $html.="</div>";
            $data['div'] = $html;
        echo json_encode($data);
    }

    public function actionUpdatePackage() {
        $checkin_id = $_POST['checkin_id'];
        $checkin_item_id = $_POST['checkin_item_id'];
        $item_qty = $_POST['checkin_qty'];
        $item_qty_exchange_rate = $_POST['unit_exchange_rate'];
        $total_qty = $item_qty * $item_qty_exchange_rate;
        if (is_array($_POST['PackagingItems'])) {
            $qty = 0;
            foreach ($_POST['PackagingItems'] as $eachRow) {
                $unit = $eachRow['unit'];
                if ($unit > 0) {
                    $MasUnit = MasUnit::model()->findByPk($unit);
                    $qty+=$eachRow['quantity'] * $MasUnit->unit_exchange_rate;
                }
            }
            if ($total_qty != $qty) {
                $data['data'] = array('status' => 'error');
            } else {
                $checkin_items = CheckinItems::model()->findByPk($checkin_item_id);
                Yii::app()->db->createCommand('DELETE FROM temp_packaging_items WHERE checkin_item_id=' . $checkin_item_id.' ')->execute();
                foreach ($_POST['PackagingItems'] as $eachRow) {
                    $item_quantity = $eachRow['quantity'];
                    $item_unit = $eachRow['unit'];
                    $bill_of_entry = $eachRow['bill_of_entry_exit'];
                    if ($item_quantity > 0 && $item_unit > 0) {
                        $MasUnit = MasUnit::model()->findByPk($item_unit);
                        $SQL = 'INSERT INTO temp_packaging_items (transaction_type,checkin_id,checkin_item_id,transaction_id,transaction_item_id,product_id,description,quantity,unit,default_product_unit,unit_exchange_rate,rate,bill_of_entry_exit) 
        VALUES ("' . $checkin_items->transaction_type . '",' . $checkin_items->checkin_id . ',' . $checkin_items->id . ',' . $checkin_items->transaction_id . ',' . $checkin_items->transaction_item_id . ',' . $checkin_items->product_id . ',"' . $checkin_items->description . '",' . $item_quantity . ',' . $item_unit . ',' . $MasUnit->base_unit_id . ',' . $MasUnit->unit_exchange_rate . ',' . $checkin_items->rate . ',"' . $bill_of_entry . '")';
                        Yii::app()->db->createCommand($SQL)->execute();
                    }
                }
                $data['status'] = 'success';
            }
        } else {
            $data['status'] = 'error';
        }
        echo json_encode($data);
    }

    public function actionSaveGoodsReceiptPackaging() {
        $model = new Packaging();
        $other=array();
        if (isset($_POST['GoodsReceipt'])) {
            $model->transaction_type = 'GR';
            $model->transaction_id = $_POST['GoodsReceipt']['id'];
            $model->customer_id = $_POST['GoodsReceipt']['customer_id'];
            $model->created_by = Yii::app()->user->id;
            $model->created_time = date('Y-m-d h:i:s');
            if ($_POST['GoodsReceipt']['transaction_date'] != '00/00/0000') {
                $model->transaction_date = str_replace('/', '-', $_POST['GoodsReceipt']['transaction_date']);
                $model->transaction_date = date("Y-m-d", strtotime($model->transaction_date));
            }
            $valid = $model->validate();
            
            if($model->transaction_type=='GR'){
                $modelGoodsReceipt = new GoodsReceipt();
                
                $modelGoodsReceipt = $modelGoodsReceipt->findByPk($model->transaction_id);
                if($modelGoodsReceipt->state=="PACKAGING" || $modelGoodsReceipt->state=="COMPLETED"){
                    $other[]='Checkin already completed';
                    $valid=false;
                }
                
            }
            $i = 0;
            if (is_array($_POST['CheckinItems'])) {
                foreach ($_POST['CheckinItems'] as $k => $rowItem) {
                    $checkin_id = $rowItem['checkin_id'];
                    $checkin_item_id = $rowItem['id'];
                    $packages = Yii::app()->db->createCommand('select * from temp_packaging_items where checkin_item_id=' . $checkin_item_id)->queryAll();
                    if (!empty($packages)) {
                        foreach ($packages as $eachPackage) {
                            $model_item[$i] = new PackagingItems;
                            $model_item[$i]->transaction_type = $eachPackage['transaction_type'];
                            $model_item[$i]->checkin_id = $eachPackage['checkin_id'];
                            $model_item[$i]->checkin_item_id = $eachPackage['checkin_item_id'];
                            $model_item[$i]->transaction_id = $eachPackage['transaction_id'];
                            $model_item[$i]->transaction_item_id = $eachPackage['transaction_item_id'];
                            $model_item[$i]->product_id = $eachPackage['product_id'];
                            $model_item[$i]->description = $eachPackage['description'];
                            $model_item[$i]->quantity = $eachPackage['quantity'];
                            $model_item[$i]->unit = $eachPackage['unit'];
                            $model_item[$i]->default_product_unit = $eachPackage['default_product_unit'];
                            $model_item[$i]->unit_exchange_rate = $eachPackage['unit_exchange_rate'];
                            $model_item[$i]->rate = $eachPackage['rate'];
                            $model_item[$i]->bill_of_entry_exit = $eachPackage['bill_of_entry_exit'];
                            $model_item[$i]->length = $eachPackage['length'];
                            $model_item[$i]->breadth = $eachPackage['breadth'];
                            $model_item[$i]->height = $eachPackage['height'];
                            $valid = $model_item[$i]->validate() && $valid;
                            $i++;
                        }
                    }
                }
            }
            if ($valid) {
                Packaging::model()->deleteAll(array('condition' => 'transaction_type="GR" AND transaction_id=' . $model->transaction_id));
                PackagingItems::model()->deleteAll(array('condition' => 'transaction_type="GR" AND transaction_id=' . $model->transaction_id));
                Yii::app()->db->createCommand('delete from temp_packaging_items where transaction_type="GR" AND transaction_id=' . $model->transaction_id)->execute();
                $model->save(false);
                $receipt = GoodsReceipt::model()->findByPk($model->transaction_id);
                $receipt->state = 'PACKAGING';
                $receipt->save(false);
                // inserting to audit log
                AuditLog::saveAuditLogs(
                        'RECEIPTS', Yii::app()->user->id, $audit_type, " with Packaging No: - {$model->id}  "
                );
                // end audit log 

                foreach ($model_item as $eachitem) {
                    $eachitem->package_id = $model->id;
                    $eachitem->save(false);
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if ($model_item[0]->product_id > 0)
                    $error2 = json_decode(CActiveForm::validateTabular($model_item, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";
                    
                $error = CJSON::encode(array_merge_recursive($error1, $error2, $other));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionGoodsReceiptConversion() {
        $model = new Checkin();
        $modelItems = new CheckinItems();
        $transaction_id = (int) Yii::app()->request->getParam('id');
        $status = Yii::app()->request->getParam('status');
        $checkin = $model->find(array('condition' => 'transaction_id=' . $transaction_id . ' AND transaction_type="' . $status . '"'))->id;
        $model = $model->findByPk($checkin);
        $CheckinItems = CheckinItems::model()->findAll(array('condition' => 'checkin_id=' . $checkin));
        Yii::app()->db->createCommand('delete from temp_packaging_items where transaction_id=' . $transaction_id . ' AND transaction_type="' . $status . '"')->execute();

        $SQL = 'INSERT INTO temp_packaging_items (transaction_type,checkin_id,checkin_item_id,transaction_id,transaction_item_id,product_id,description,quantity,unit,default_product_unit,unit_exchange_rate,rate,bill_of_entry_exit,length,breadth,height) 
        SELECT transaction_type,checkin_id,id,transaction_id,transaction_item_id,product_id,description,quantity,unit,default_product_unit,unit_exchange_rate,rate,bill_of_entry_exit,length,breadth,height FROM erp_checkin_items WHERE transaction_id=' . $transaction_id . ' AND transaction_type="' . $status . '"';

        Yii::app()->db->createCommand($SQL)->execute();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('packaging_form', array('transaction_id' => $transaction_id, 'checkin_id' => $checkin, 'model' => $model, 'status' => $status, 'items' => $CheckinItems));
    }

    public function actionPackageGoodsReceipt() {
        $model = new Packaging();
        $id = (int) Yii::app()->request->getParam('id');
        $status = Yii::app()->request->getParam('status');
        $model = $model->findByPk($id);
        $modelItems = PackagingItems::model()->findAll(array('condition' => 'package_id=' . $id));
        $data_exist=0;
        if($status=='GR'){
            $modelGoodsReceipt = new GoodsReceipt();
            
            $modelGoodsReceipt = $modelGoodsReceipt->findByPk($model->transaction_id);
            
            if($modelGoodsReceipt->state=="COMPLETED"){
                $data_exist=1;
            }
            
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('packaging_goods_receipt_conversion_form', array('id' => $id, 'model' => $model, 'items' => $modelItems,'data_exist'=>$data_exist));
    }

//   public function actionReceiptitemsdetail()
//   {
//   $checkin_item_id = (int) Yii::app()->request->getParam('id');    
//   $checkin_items = CheckinItems::model()->findByPk($checkin_item_id);
//   $html="<div class='table-responsive' id='packaging_items'>";
//   $html.=CHtml::hiddenField('checkin_id',$checkin_items->checkin_id);
//   $html.=CHtml::hiddenField('checkin_item_id',$checkin_item_id);
//   $html.=CHtml::hiddenField('checkin_qty',$checkin_items->quantity);
//   $html.=CHtml::hiddenField('checkin_unit',$checkin_items->unit);
//   $html.=CHtml::hiddenField('checkin_default_product_unit',$checkin_items->default_product_unit);
//   $html.=CHtml::hiddenField('unit_exchange_rate',$checkin_items->unit_exchange_rate);
//   $html.="<table class='table table-hover table-bordered personal-task' id='packaging_item_table'>
//   <tr><th>No</th><th>Product</th><th>Qty</th><th>Unit</th><th>Rate</th><th>Bill of Entry</th><th class='text-center'>".CHtml::link('<i class="fa fa-plus"></i>', 'javascript:void(0);', array('class'=>'btn btn-sm btn-danger','onclick' => 'AddPackagingTableRow($(\'#packaging_item_table\'))', 'title' => 'Add Items'))."</th></tr>";
//   $items= array(new PackagingItems);
//   foreach ($items as $model)
//   {
//   $html.="<tr><td><label>1</label></td><td>".CHtml::activeHiddenField($model,'[1]product_id', array('value'=>$checkin_items->product_id)).CHtml::activeHiddenField($model,'[1]description',array('value'=>$checkin_items->description)).$checkin_items->description."</td>
//   <td>".CHtml::activeTextField($model,'[1]quantity',array('class' => 'qty go cell-center text-right','onkeypress' => 'return isNumberKey(event)','data-label'=>'Quantity','value'=>$checkin_items->quantity))."</td>
//   <td>".CHtml::activeDropdownList($model,'[1]unit',MasUnit::getSimilarUnits($checkin_items->unit),array('class'=>'qty go'))."</td><td>".CHtml::activeTextField($model,'[1]rate',array('class' => 'rate go cell-center text-right','data-label'=>'Rate','value'=>$checkin_items->rate,'readonly'=>true))."</td>
//   <td>".CHtml::activeTextField($model,'[1]bill_of_entry',array('data-label'=>'Bill of Entry','class'=>'go','value'=>$checkin_items->bill_of_entry))."</td><td class='text-center'>".CHtml::link('<i class="fa fa-close"></i>', 'javascript:void(0);', array('class'=>'btn btn-sm btn-danger', 'onclick' => 'removeTableRowitempackaging($(\'#packaging_item_table\'),this)', 'title' => 'Remove this item'))."</td></tr>";
//   }
//   $html.="</table>";
//   $html.="</div>";
//   $data['div'] = $html;
//   echo json_encode($data);
//   }
//    public function actionUpdatePackage()
//    {
//        $checkin_id=$_POST['checkin_id'];
//        $checkin_item_id=$_POST['checkin_item_id'];
//        $item_qty=$_POST['checkin_qty'];
//        $item_qty_exchange_rate=$_POST['unit_exchange_rate'];
//        $total_qty=$item_qty*$item_qty_exchange_rate;
//        if (is_array($_POST['PackagingItems'])) {
//        $qty= 0;
//        foreach ($_POST['PackagingItems'] as $eachRow)
//        {
//        $unit=$eachRow['unit']; 
//        if($unit>0)
//        {
//        $MasUnit=MasUnit::model()->findByPk($unit);
//        $qty+=$eachRow['quantity']*$MasUnit->unit_exchange_rate;  
//        }
//        }
//        if($total_qty!=$qty)
//        {
//        $data['data'] = array('status'=>'error');    
//        }
//        else {
//        $checkin_items = CheckinItems::model()->findByPk($checkin_item_id); 
//        Yii::app()->db->createCommand('delete from temp_packaging_items where checkin_item_id='.$checkin_item_id)->execute();
//       foreach ($_POST['PackagingItems'] as $eachRow)
//        {
//        $item_quantity=$eachRow['quantity'];
//        $item_unit=$eachRow['unit'];
//        $bill_of_entry=$eachRow['bill_of_entry'];
//        if($item_quantity>0 && $item_unit>0)
//        {
//        $MasUnit=MasUnit::model()->findByPk($item_unit);
//        $SQL='INSERT INTO temp_packaging_items (transaction_type,checkin_id,checkin_item_id,transaction_id,transaction_item_id,product_id,description,quantity,unit,default_product_unit,unit_exchange_rate,rate,bill_of_entry) 
//        VALUES ("'.$checkin_items->transaction_type.'",'.$checkin_items->checkin_id.','.$checkin_items->id.','.$checkin_items->transaction_id.','.$checkin_items->transaction_item_id.','.$checkin_items->product_id.',"'.$checkin_items->description.'",'.$item_quantity.','.$item_unit.','.$MasUnit->base_unit_id.','.$MasUnit->unit_exchange_rate.','.$checkin_items->rate.',"'.$bill_of_entry.'")';
//        Yii::app()->db->createCommand($SQL)->execute(); 
//        }
//        }   
//        $data['status'] = 'success';
//        }
//        }
//        else {
//        $data['status'] = 'error';    
//        }
//        echo json_encode($data);
//    }
    public function actionSavePackagingConversionGoodsReceipt() {
        $model = new Packaging();
        if (isset($_POST['Packaging'])) {
            
            $countStockLedger = 0;
            if((int) $_POST['Packaging']['transaction_id'] > 0 && $_POST['Packaging']['transaction_type'] == 'GR'){
                $modelStockLedger = new StockLedger;
                
                $countStockLedger = $modelStockLedger->count(array('condition' => 'header_id='.(int) $_POST['Packaging']['transaction_id']. ' AND type="GR"'));
            }
            
            
            if ($_POST['Packaging']['id'] > 0) {
                $model = $model->findByPk($_POST['Packaging']['id']);
                if ($_POST['Packaging']['transaction_date'] != '00/00/0000') {
                    $model->transaction_date = str_replace('/', '-', $_POST['Packaging']['transaction_date']);
                    $model->transaction_date = date("Y-m-d", strtotime($model->transaction_date));
                }
            }
            $other = array();
            $valid = $model->validate();
            $groups=[];
            if (is_array($_POST['PackagingItems'])) {
                Yii::app()->db->createCommand('DELETE FROM temp_stock_center WHERE type="' . $model->transaction_type . '" AND type_id=' . $model->id)->execute();
                foreach ($_POST['PackagingItems'] as $i => $rowItem) {
                    $model_item[$i] = new PackagingItems;
                    $model_item[$i]->transaction_type = $rowItem['transaction_type'];
                    $model_item[$i]->checkin_id = $rowItem['checkin_id'];
                    $model_item[$i]->checkin_item_id = $rowItem['checkin_item_id'];
                    $model_item[$i]->transaction_id = $model->transaction_id;
                    $model_item[$i]->transaction_item_id = $rowItem['transaction_item_id'];
                    $model_item[$i]->product_id = $rowItem['product_id'];
                    $model_item[$i]->description = $rowItem['description'];
                    $model_item[$i]->quantity = $rowItem['quantity'];
                    $model_item[$i]->unit = $rowItem['unit'];
                    $model_item[$i]->default_product_unit = $rowItem['default_product_unit'];
                    $model_item[$i]->unit_exchange_rate = $rowItem['unit_exchange_rate'];
                    $model_item[$i]->rate = $rowItem['rate'];
                    $model_item[$i]->bill_of_entry_exit = $rowItem['bill_of_entry_exit'];
                    $model_item[$i]->warehouse_id = $rowItem['warehouse_id'];
                    $model_item[$i]->rack_id = $rowItem['rack_id'];
                    $model_item[$i]->bin_id = $rowItem['bin_id'];
                    $modelGR = GoodsReceiptItems::model()->findByPk($rowItem['transaction_item_id']);
                    $model_item[$i]->length = $modelGR->length;
                    $model_item[$i]->breadth = $modelGR->breadth;
                    $model_item[$i]->height = $modelGR->height;
                    $model_item[$i]->weight = $rowItem['weight'];
                    $model_item[$i]->volume = $rowItem['volume'];
                    if ($rowItem['warehouse_id'] > 0 && $rowItem['rack_id'] > 0 && $rowItem['bin_id'] > 0) {
                        if ($model_item[$i]->mas_bin->maximum_weight < $rowItem['weight']) {
                            $other[] = $model_item[$i]->product->part_number . ' weight(' . $rowItem['weight'] . ') exceed the bin weight(' . $model_item[$i]->mas_bin->maximum_weight . ')';
                            $valid = false;
                        }
                        if ($model_item[$i]->mas_bin->maximum_volume < $rowItem['volume']) {
                            $other[] = $model_item[$i]->product->part_number . ' volume(' . $rowItem['volume'] . ') exceed the bin volume(' . $model_item[$i]->mas_bin->maximum_volume . ')';
                            $valid = false;
                        }
                        /*$check_bin = "select * from temp_stock_center where type='" . $model->transaction_type . "' AND type_id=" . $model->id . " AND warehouse=" . $rowItem['warehouse_id'] . " AND rack=" . $rowItem['rack_id'] . " AND bin=" . $rowItem['bin_id'];
                        $check_bin_qty = Yii::app()->db->createCommand($check_bin)->queryAll();
                        if (!empty($check_bin_qty)) {
                            $other[] = $model_item[$i]->product->part_number . ' : ' . $model_item[$i]->mas_bin->name . ' Bin Duplicated';
                            $valid = false;
                        }
                        if ($model_item[$i]->mas_bin->is_free == 'N') {
                            $other[] = $model_item[$i]->product->part_number . ' : ' . $model_item[$i]->mas_bin->name . ' Bin already occupied';
                            $valid = false;
                        }*/
                    } else {
                        if ((int) $rowItem['warehouse_id'] == 0) {
                            $other[] = $model_item[$i]->product->part_number . ' : please choose warehouse';
                            $valid = false;
                        }
                        if ((int) $rowItem['rack_id'] == 0) {
                            $other[] = $model_item[$i]->product->part_number . ' : please choose rack';
                            $valid = false;
                        }
                        if ((int) $rowItem['bin_id'] == 0) {
                            $other[] = $model_item[$i]->product->part_number . ' : please choose bin';
                            $valid = false;
                        }
                    }
                    $valid = $model_item[$i]->validate() && $valid;
                    if ($valid) {
                        $SQL = 'INSERT INTO temp_stock_center (type,type_id,warehouse,rack,bin,product_id) VALUES ("' . $model->transaction_type . '",' . $model->id . ',' . $rowItem['warehouse_id'] . ',' . $rowItem['rack_id'] . ',' . $rowItem['bin_id'] . ','.$model_item[$i]->product->id.')';
                        Yii::app()->db->createCommand($SQL)->execute();
                    }
                }
            }
            if ($valid && $countStockLedger==0) {
                Yii::app()->db->createCommand('delete from temp_stock_center where type="' . $model->transaction_type . '" AND type_id=' . $model->id)->execute();
                PackagingItems::model()->deleteAll(array('condition' => 'package_id=' . $model->id));
                $model->save(false);
                $receipt = GoodsReceipt::model()->findByPk($model->transaction_id);
                $receipt->state = 'COMPLETED';
                $receipt->save(false);
                // inserting to audit log
                AuditLog::saveAuditLogs(
                        'RECEIPTS', Yii::app()->user->id, $audit_type, " with Packaging No: - {$model->id}  "
                );
                // end audit log 
                foreach ($model_item as $eachitem) {
                    $eachitem->package_id = $model->id;
                    $eachitem->save(false);
                    $StockLedger = new StockLedger;
                    $StockLedger->transaction_date = $model->transaction_date;
                    $StockLedger->transaction_type = 'IN';
                    $StockLedger->type = 'GR';
                    $StockLedger->customer_vendor_id = $model->transaction->customer_id;
                    $StockLedger->file_id = 0;
                    $StockLedger->header_id = $model->transaction_id;
                    $StockLedger->item_id = $eachitem->transaction_item_id;
                    $StockLedger->product_id = $eachitem->product_id;
                    $inventory = Inventory::model()->findByPk($eachitem->product_id);
                    $StockLedger->brand_id = $inventory->brand;
                    $StockLedger->rate = $eachitem->rate;
                    $StockLedger->currency = 1;
                    $StockLedger->exchange_rate = 1;
                    $StockLedger->quantity = $eachitem->quantity;
                    $StockLedger->unit = $eachitem->unit;
                    $StockLedger->default_product_unit = $eachitem->default_product_unit;
                    $StockLedger->unit_exchange_rate = $eachitem->unit_exchange_rate;
                    $StockLedger->warehouse_id = $eachitem->warehouse_id;
                    $StockLedger->rack_id = $eachitem->rack_id;
                    $StockLedger->bin_id = $eachitem->bin_id;
                    $StockLedger->batch_no = $eachitem->batch_no;
                    $StockLedger->serial_no = $eachitem->serial_no;
                    $StockLedger->manufacturing_date = $eachitem->manufacturing_date;
                    $StockLedger->expiry_date = $eachitem->expiry_date;
                    $StockLedger->bill_of_entry_exit = $eachitem->bill_of_entry_exit;
                    $StockLedger->hs_code = $inventory->hs_code;
                    $StockLedger->stock_updated= 'Y';
                    $modelGR = GoodsReceiptItems::model()->findByPk($eachitem->transaction_item_id);
                    $StockLedger->length = $modelGR->length;
                    $StockLedger->breadth = $modelGR->breadth;
                    $StockLedger->height = $modelGR->height;
                    $StockLedger->created_by = Yii::app()->user->id;
                    $StockLedger->created_time = date('Y-m-d h:i:s');
                    $StockLedger->save(false);
                    $bin = MasInvBin::model()->findByPk($eachitem->bin_id);
                    $bin->is_free = "N";
                    $bin->save(false);
                    $raks = MasInvBin::model()->findAll(array('condition' => 'is_free="N" AND rack_id=' . $rack_id));
                    if ((int) $eachitem->mas_rack->total_bins == count($raks)) {
                        $rak = MasInvRack::model()->findByPk($eachitem->rack_id);
                        $rak->is_free = "N";
                        $rak->save(false);
                    }
                }

                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                
                if($countStockLedger > 0){
                    $other[] = "Packaging already completed";
                }
                
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error2 = json_decode(CActiveForm::validateTabular($model_item, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1, $error2, $other));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionGetRacks() {
        $warehouse = (int) Yii::app()->request->getParam('val');
        $racks = MasInvRack::model()->findAll(array('condition' => ' warehouse_id=' . $warehouse));//is_free="Y" AND
        $row = Yii::app()->request->getParam('row_field');
        $arr_racks = CHtml::listData($racks, 'id', 'name');
        $drop = array();
        $PackagingItems = new PackagingItems;
        $drop['drop'] = CHtml::activedropdownlist($PackagingItems, "[" . $row . "]rack_id", $arr_racks, array('prompt' => '-select-', 'onchange' => 'getBins(this.id,this.value)'));
        echo CJSON::encode($drop);
    }

    public function actionGetBins() {
        $rack = (int) Yii::app()->request->getParam('val');
        $weight = (float) Yii::app()->request->getParam('weight');
        $volume = (float) Yii::app()->request->getParam('volume');
        $bins = MasInvBin::model()->findAll(array('condition' => 'rack_id=' . $rack . ' AND maximum_weight>=' . $weight . ' AND maximum_volume>=' . $volume));
        //is_free="Y" AND 
        $row = Yii::app()->request->getParam('row_field');
        $rack_id = (int) Yii::app()->request->getParam('val');
        $arr_bins = CHtml::listData($bins, 'id', 'name');
        $drop = array();
        $PackagingItems = new PackagingItems;
        $drop['drop'] = CHtml::activedropdownlist($PackagingItems, "[" . $row . "]bin_id", $arr_bins, array('prompt' => '-select-'));
        echo CJSON::encode($drop);
    }

    public function actionPackageGoodsIssueConversion() {
        $model = new GoodsIssue();
        $modelItems = new PackagingItems();
        $transaction_id = (int) Yii::app()->request->getParam('id');
        $status = Yii::app()->request->getParam('status');
        $data_exist=0;
        if((int) $transaction_id > 0 && $status=='GI'){
            $modelGoodsIssue = new GoodsIssue();
            
            $modelGoodsIssue = $modelGoodsIssue->findByPk($transaction_id);
            
            if($modelGoodsIssue->state=="PACKAGING" || $modelGoodsIssue->state=="COMPLETED"){
                $data_exist=1;
            }
            
        }
        $model = $model->findByPk($transaction_id);
        $PackagingItems = CheckinItems::model()->findAll(array('condition' => 'transaction_type="GI" AND transaction_id=' . $transaction_id));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('packaging_goods_issue_form', array('transaction_id' => $transaction_id, 'model' => $model, 'status' => $status, 'items' => $PackagingItems,'data_exist'=>$data_exist));
    }

    public function actionSaveGoodsIssuePackaging() {

        $model = new Packaging();

        if (isset($_POST['GoodsIssue'])) {
            $model->transaction_type = 'GI';
            $model->transaction_id = $_POST['GoodsIssue']['id'];
            $model->customer_id = $_POST['GoodsIssue']['customer_id'];
            $model->created_by = Yii::app()->user->id;
            $model->created_time = date('Y-m-d h:i:s');
            if ($_POST['GoodsIssue']['transaction_date'] != '00/00/0000') {
                $model->transaction_date = str_replace('/', '-', $_POST['GoodsIssue']['transaction_date']);
                $model->transaction_date = date("Y-m-d", strtotime($model->transaction_date));
            }
            $other = array();
            $valid = $model->validate();
            $transaction_date = $model->transaction_date;
            
             if($model->transaction_type=='GI'){
                $modelGoodsIssue = new GoodsIssue();
                
                $modelGoodsIssue = $modelGoodsIssue->findByPk($model->transaction_id);
                if($modelGoodsIssue->state=="PACKAGING" || $modelGoodsIssue->state=="COMPLETED"){
                    $other[]='Checkin already completed';
                    $valid=false;
                }
                
            }
            
            if (is_array($_POST['CheckinItems'])) {
                foreach ($_POST['CheckinItems'] as $i => $rowItem) {
                    $model_item[$i] = new PackagingItems;
                    $model_item[$i]->transaction_type = 'GI';
                    $model_item[$i]->checkin_id = $rowItem['checkin_id'];
                    $model_item[$i]->checkin_item_id = $rowItem['id'];
                    $model_item[$i]->transaction_id = $rowItem['transaction_id'];
                    $model_item[$i]->transaction_item_id = $rowItem['transaction_item_id'];
                    $model_item[$i]->product_id = $rowItem['product_id'];
                    $model_item[$i]->description = $rowItem['description'];
                    $model_item[$i]->quantity = $rowItem['quantity'];
                    $model_item[$i]->unit = $rowItem['unit'];
                    $MasUnit = MasUnit::model()->findByPk($rowItem['unit']);
                    $model_item[$i]->default_product_unit = $MasUnit->base_unit_id;
                    $model_item[$i]->unit_exchange_rate = $MasUnit->unit_exchange_rate;
                    $model_item[$i]->rate = $rowItem['rate'];
                    $model_item[$i]->bill_of_entry_exit = $rowItem['bill_of_entry_exit'];
                    $valid = $model_item[$i]->validate() && $valid;
                    $SQL_IN = "select SUM(quantity*unit_exchange_rate) from erp_stock_ledger where product_id=" . $model_item[$i]->product_id . " AND customer_vendor_id=" . $model->goodsissue->customer_id . " AND transaction_type='IN' AND transaction_date<='$transaction_date'";
                    $stocks_in = Yii::app()->db->createCommand($SQL_IN)->queryScalar();
                    $SQL_OUT = "select SUM(quantity*unit_exchange_rate) from erp_stock_ledger where product_id=" . $model_item[$i]->product_id . " AND customer_vendor_id=" . $model->goodsissue->customer_id . " AND transaction_type='OUT' AND transaction_date<='$transaction_date'";
                    $stocks_out = Yii::app()->db->createCommand($SQL_OUT)->queryScalar();
                    $stock = $stocks_in - $stocks_out;
                    $qty = $model_item[$i]->quantity * $model_item[$i]->unit_exchange_rate;
                    /*if ($qty > $stock) {
                        $other[] = $model_item[$i]->product->part_number . ' available quantity : ' . $stock . $model_item[$i]->product->units->label;
                        $valid = false;
                    }*/
                }
            }
            if ($valid) {
                Packaging::model()->deleteAll(array('condition' => 'transaction_type="GI" AND transaction_id=' . $model->transaction_id));
                PackagingItems::model()->deleteAll(array('condition' => 'transaction_type="GI" AND transaction_id=' . $model->transaction_id));
                $model->save(false);
                $issue = GoodsIssue::model()->findByPk($model->transaction_id);
                $issue->state = 'PACKAGING';
                $issue->save(false);
                // inserting to audit log
                AuditLog::saveAuditLogs(
                        'ISSUE', Yii::app()->user->id, $audit_type, " with Packaging No: - {$model->id}  "
                );
                // end audit log 
                foreach ($model_item as $eachitem) {
                    $eachitem->package_id = $model->id;
                    $eachitem->save(false);
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if ($model_item[0]->product_id > 0)
                    $error2 = json_decode(CActiveForm::validateTabular($model_item, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";
                $error = CJSON::encode(array_merge_recursive($error1, $error2, $other));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionPackageGoodsIssue() {
        $model = new Packaging();
        $id = (int) Yii::app()->request->getParam('id');
        $status =  Yii::app()->request->getParam('status');
        $model = $model->findByPk($id);
        $modelItems = PackagingItems::model()->findAll(array('condition' => 'package_id=' . $id));
        $data_exist=0;
        if($status=='GI'){
            $modelGoodsIssue = new GoodsIssue();
            
            $modelGoodsIssue = $modelGoodsIssue->findByPk($model->transaction_id);
            
            if($modelGoodsIssue->state=="COMPLETED"){
                $data_exist=1;
            }
            
        }
        
        Yii::app()->db->createCommand('delete from temp_packaging_items where transaction_type="' . $model->transaction_type . '" AND transaction_id=' . $model->transaction_id)->execute();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('packaging_goods_issue_conversion_form', array('id' => $id, 'model' => $model, 'items' => $modelItems,'data_exist'=>$data_exist));
    }

    public function actionIssueitemsdetail() {
        $product_qty = (int) Yii::app()->request->getParam('qty');
        $unit_ex_rate = (int) Yii::app()->request->getParam('unit_ex_rate');
        $product_id = (int) Yii::app()->request->getParam('id');
        $customer_id = (int) Yii::app()->request->getParam('customer_id');
        $checkin_id = (int) Yii::app()->request->getParam('checkin_id');
        $checkin_item_id = (int) Yii::app()->request->getParam('checkin_item_id');
        $SQL_IN = "select SUM(quantity*unit_exchange_rate) from erp_stock_ledger where product_id=" . $product_id . " AND customer_vendor_id=" . $customer_id . " AND transaction_type='IN' AND transaction_date<='$transaction_date'";
        $stocks_in = Yii::app()->db->createCommand($SQL_IN)->queryScalar();
        $SQL_OUT = "select SUM(quantity*unit_exchange_rate) from erp_stock_ledger where product_id=" . $product_id . " AND customer_vendor_id=" . $customer_id . " AND transaction_type='OUT' AND transaction_date<='$transaction_date'";
        $stocks_out = Yii::app()->db->createCommand($SQL_OUT)->queryScalar();
        $stock = $stocks_in - $stocks_out;
        $qty = $model_item[$i]->quantity * $model_item[$i]->unit_exchange_rate;

        $items = StockLedger::model()->findAll(array('condition' => 'transaction_type="IN" AND customer_vendor_id=' . $customer_id . ' AND quantity>0 AND product_id=' . $product_id));
        $html = "<div class='table-responsive' id='packaging_items'>";
        if((int)$model->default_product_unit>0)
        $arr_sim_units =MasUnit::getSimilarUnits($model->default_product_unit);
        else
        $arr_sim_units =MasUnit::getSimilarUnits($model->unit);
        $html.="<table class='table table-hover table-bordered personal-task' id='packaging_item_table'>
   <tr><th>No</th><th>Product</th><th>Qty</th><th>Unit</th><th>Rate</th><th>Bill of Entry</th><th>Warehouse</th><th>Rack</th><th>Bin</th></tr>";
        $item = array(new StockLedger);
        foreach ($items as $i => $model) {
            $out_qty = Yii::app()->db->createCommand("select SUM(quantity) from erp_stock_ledger where transaction_type='OUT' AND in_stockledger_id=" . $model->id)->queryScalar();
            $quantity = $model->quantity - $out_qty;
            $html.="<tr>
   <td><label>" . ($i + 1) . "</label></td><td>" . CHtml::activeHiddenField($model, '[' . $i . ']product_id', array('value' => $model->product_id)) . $model->product_det->description . "</td>
   <td>" . CHtml::activeTextField($model, '[' . $i . ']quantity', array('value' => $quantity)) . "</td>
   <td>" . CHtml::activeDropdownList($model, '[' . $i . ']unit', $arr_sim_units, array('class' => 'qty go', 'value' => $model->unit)) . "</td><td>" . $model->rate . "</td>
   <td>" . $model->bill_of_entry_exit . "</td>
   <td>" . $model->warehouse->warehouse_name . "</td>
   <td>" . $model->rack->name . "</td>
   <td>" . $model->bin->name . "</td></tr>";
            $html.=CHtml::activeHiddenField($model, '[' . $i . ']id', array('value' => $model->id));
        }
        $html.="</table>";
        $html.=CHtml::hiddenField('checkin_id', $checkin_id);
        $html.=CHtml::hiddenField('checkin_item_id', $checkin_item_id);
        $html.=CHtml::hiddenField('tot_qty', $product_qty * $unit_ex_rate);
        $html.="</div>";
        $data['div'] = $html;
        echo json_encode($data);
    }

    public function actionUpdateIssuePackage() {
        $checkin_id = $_POST['checkin_id'];
        $checkin_item_id = $_POST['checkin_item_id'];
        $total_qty = $_POST['tot_qty'];
        $qty = 0;
        if (is_array($_POST['StockLedger'])) {
            $checkin_items = CheckinItems::model()->findByPk($checkin_item_id);
            Yii::app()->db->createCommand('delete from temp_packaging_items where checkin_item_id=' . $checkin_item_id)->execute();
            foreach ($_POST['StockLedger'] as $eachRow) {
                $item_quantity = $eachRow['quantity'];
                $item_unit = $eachRow['unit'];
                if ($item_quantity > 0 && $item_unit > 0) {
                    $MasUnit = MasUnit::model()->findByPk($item_unit);
                    $qty+=$item_quantity * $MasUnit->unit_exchange_rate;
                }
            }
            if ($qty != $total_qty) {
                $data['status'] = 'error';
            } else {
                foreach ($_POST['StockLedger'] as $eachRow) {
                    $item_quantity = $eachRow['quantity'];
                    $item_unit = $eachRow['unit'];
                    $in_stockledger_id = $eachRow['id'];
                    if ($item_quantity > 0 && $item_unit > 0) {
                        $MasUnit = MasUnit::model()->findByPk($item_unit);
                        $SQL = 'INSERT INTO temp_packaging_items (transaction_type,checkin_id,checkin_item_id,transaction_id,transaction_item_id,product_id,description,quantity,unit,default_product_unit,unit_exchange_rate,rate,bill_of_entry_exit,in_stockledger_id) 
        VALUES ("GI",' . $checkin_id . ',' . $checkin_item_id . ',' . $checkin_items->transaction_id . ',' . $checkin_items->transaction_item_id . ',' . $checkin_items->product_id . ',"' . $checkin_items->description . '",' . $item_quantity . ',' . $item_unit . ',' . $MasUnit->base_unit_id . ',' . $MasUnit->unit_exchange_rate . ',' . $checkin_items->rate . ',"' . $checkin_items->bill_of_entry_exit . '",' . $in_stockledger_id . ')';
                        Yii::app()->db->createCommand($SQL)->execute();
                    }
                }
                $data['status'] = 'success';
            }
        } else {
            $data['status'] = 'error';
        }
        echo json_encode($data);
    }

    public function actionSavePackagingConversionGoodsIssue() {
        $model = new Packaging();
        if (isset($_POST['Packaging'])) {
            if ($_POST['Packaging']['id'] > 0) {
                $model = $model->findByPk($_POST['Packaging']['id']);
                if ($_POST['Packaging']['transaction_date'] != '00/00/0000') {
                    $model->transaction_date = str_replace('/', '-', $_POST['Packaging']['transaction_date']);
                    $model->transaction_date = date("Y-m-d", strtotime($model->transaction_date));
                }
            }
            
            
            
            $other = array();
            $valid = $model->validate();
            if (is_array($_POST['PackagingItems'])) {
                Yii::app()->db->createCommand('delete from temp_stock_center where type="' . $model->transaction_type . '" AND type_id=' . $model->id)->execute();
                foreach ($_POST['PackagingItems'] as $i => $rowItem) {
                    $model_item[$i] = new PackagingItems;
                    $model_item[$i]->transaction_type = $rowItem['transaction_type'];
                    $model_item[$i]->checkin_id = $rowItem['checkin_id'];
                    $model_item[$i]->checkin_item_id = $rowItem['checkin_item_id'];
                    $model_item[$i]->transaction_id = $_POST['Packaging']['transaction_id'];
                    $model_item[$i]->transaction_item_id = $rowItem['transaction_item_id'];
                    $model_item[$i]->product_id = $rowItem['product_id'];
                    $model_item[$i]->description = $rowItem['description'];
                    $model_item[$i]->quantity = $rowItem['quantity'];
                    $model_item[$i]->unit = $rowItem['unit'];
                    $model_item[$i]->default_product_unit = $rowItem['default_product_unit'];
                    $model_item[$i]->unit_exchange_rate = $rowItem['unit_exchange_rate'];
                    $model_item[$i]->rate = $rowItem['rate'];
                    $model_item[$i]->bill_of_entry_exit = $rowItem['bill_of_entry_exit'];
                    $model_item[$i]->warehouse_id = 0;
                    $model_item[$i]->rack_id = 0;
                    $model_item[$i]->bin_id = 0;
                    $model_item[$i]->weight = $rowItem['weight'];
                    $model_item[$i]->volume = $rowItem['volume'];
                    $temp_tbl = Yii::app()->db->createCommand("select * from temp_packaging_items where checkin_item_id=" . $rowItem['checkin_item_id'])->queryAll();
                    if (!empty($temp_tbl)) {
                        foreach ($temp_tbl as $eachtemp) {
                            $temp_item_qty = $eachtemp['quantity'] * $eachtemp['unit_exchange_rate'];
                            if ($eachtemp['in_stockledger_id'] > 0) {
                                $in_stockledger_id = $eachtemp['in_stockledger_id'];
                                $Stockledger = StockLedger::model()->findByPk($in_stockledger_id);
                                $check_bin = "SELECT SUM(quantity) from temp_stock_center WHERE type='" . $model->transaction_type . "' AND type_id=" . $model->id . " AND warehouse=" . $Stockledger->warehouse_id . " AND rack=" . $Stockledger->rack_id . " AND bin=" . $Stockledger->bin_id." AND product_id=".$model_item[$i]->product->id;
                                $check_bin_qty = Yii::app()->db->createCommand($check_bin)->queryScalar();
                                $stockledger_qty = $Stockledger->quantity * $Stockledger->unit_exchange_rate;
                                //if ($check_bin_qty + $temp_item_qty > $stockledger_qty) {
                                if ($check_bin_qty  > $stockledger_qty) {
                                    $other[] = $model_item[$i]->product->description.'['.$model_item[$i]->product->part_number.']' . ' : ' . $model_item[$i]->mas_bin->name . ' Bin Qty(' . $stockledger_qty . ')';
                                    $valid = false;
                                } else {
                                    $SQL = 'INSERT INTO temp_stock_center (type,type_id,warehouse,rack,bin,quantity,product_id) VALUES ("' . $model->transaction_type . '",' . $model->id . ',' . $Stockledger->warehouse_id . ',' . $Stockledger->rack_id . ',' . $Stockledger->bin_id . ',' . $temp_item_qty . ','.$model_item[$i]->product->id.')';
                                    Yii::app()->db->createCommand($SQL)->execute();
                                }
                            } else {
                                $other[] = "Please choose location for ".$model_item[$i]->product->description.'['.$model_item[$i]->product->part_number.']';
                                $valid = false;
                            }
                        }
                    } else {
                        $other[] = "Please choose location for ".$model_item[$i]->product->description.'['.$model_item[$i]->product->part_number.']';/*$model_item[$i]->product->part_number . ' : please choose location';*/
                        $valid = false;
                    }
                    $valid = $model_item[$i]->validate() && $valid;
                }
            }
            
            $countStockLedger = 0;
            if((int) $_POST['Packaging']['transaction_id'] > 0 && $_POST['Packaging']['transaction_type'] == 'GI'){
                $modelStockLedger = new StockLedger;
                
                $countStockLedger = $modelStockLedger->count(array('condition' => 'header_id='.(int) $_POST['Packaging']['transaction_id']. ' AND type="GI"'));
                if($countStockLedger > 0){
                    $other[]='Packaging already completed';
                    $valid=false;
                }
            }
           
            if ($valid) {
                Yii::app()->db->createCommand('delete from temp_stock_center where type="' . $model->transaction_type . '" AND type_id=' . $model->id)->execute();
                PackagingItems::model()->deleteAll(array('condition' => 'package_id=' . $model->id));
                $model->save(false);
                $receipt = GoodsIssue::model()->findByPk($model->transaction_id);
                $receipt->state = 'COMPLETED';
                $receipt->save(false);
                // inserting to audit log
                AuditLog::saveAuditLogs(
                        'ISSUE', Yii::app()->user->id, $audit_type, " with Packaging No: - {$model->id}  "
                );
                // end audit log 
                foreach ($model_item as $eachitem) {
                    $eachitem->package_id = $model->id;
                    $eachitem->save(false);
                    $temp_tbl = Yii::app()->db->createCommand("select * from temp_packaging_items where transaction_type='GI' AND checkin_item_id=" . $eachitem['checkin_item_id'])->queryAll();
                    foreach ($temp_tbl as $eachtemp) {
                        $StockledgerIn = StockLedger::model()->findByPk($eachtemp['in_stockledger_id']);
                        $StockLedger = new StockLedger;
                        $StockLedger->transaction_date = $model->transaction_date;
                        $StockLedger->transaction_type = 'OUT';
                        $StockLedger->type = 'GI';
                        $modelGI = GoodsIssueItems::model()->findByPk($eachitem->transaction_item_id);
                        $StockLedger->customer_vendor_id = $model->goodsissue->customer_id;
                        $StockLedger->file_id = 0;
                        $StockLedger->header_id = $model->transaction_id;
                        $StockLedger->item_id = $eachitem->transaction_item_id;
                        $StockLedger->product_id = $eachitem->product_id;
                        $inventory = Inventory::model()->findByPk($eachitem->product_id);
                        $StockLedger->brand_id = $inventory->brand;
                        $StockLedger->rate = $eachitem->rate;
                        $StockLedger->currency = 1;
                        $StockLedger->exchange_rate = 1;
                        $StockLedger->quantity = $eachtemp['quantity'];
                        $StockLedger->unit = $eachtemp['unit'];
                        $StockLedger->default_product_unit = $eachtemp['default_product_unit'];
                        $StockLedger->unit_exchange_rate = $eachtemp['unit_exchange_rate'];
                        $StockLedger->warehouse_id = $StockledgerIn->warehouse_id;
                        $StockLedger->rack_id = $StockledgerIn->rack_id;
                        $StockLedger->bin_id = $StockledgerIn->bin_id;
                        $StockLedger->batch_no = $StockledgerIn->batch_no;
                        $StockLedger->serial_no = $StockledgerIn->serial_no;
                        $StockLedger->manufacturing_date = $StockledgerIn->manufacturing_date;
                        $StockLedger->expiry_date = $StockledgerIn->expiry_date;
                        $StockLedger->bill_of_entry_exit = $eachitem->bill_of_entry_exit;
                        $StockLedger->hs_code = $inventory->hs_code;
                        $StockLedger->in_stockledger_id = $StockledgerIn->id;
                        $StockLedger->stock_updated= 'Y';
                        $StockLedger->length = $modelGI->length;
                        $StockLedger->breadth = $modelGI->breadth;
                        $StockLedger->height = $modelGI->height;
                        $StockLedger->created_by = Yii::app()->user->id;
                        $StockLedger->created_time = date('Y-m-d h:i:s');
                        //Get Current stock of product
                        $SQL_IN = "SELECT SUM(quantity*unit_exchange_rate) FROM erp_stock_ledger WHERE product_id=" . $eachitem->product_id . " AND  transaction_type='IN'";// AND transaction_date<='".date('Y-m-d')."'
                        $stocks_in = Yii::app()->db->createCommand($SQL_IN)->queryScalar();
                        $SQL_OUT = "SELECT SUM(quantity*unit_exchange_rate) FROM erp_stock_ledger WHERE product_id=" .$eachitem->product_id . " AND transaction_type='OUT'";// AND transaction_date<='".date('Y-m-d')." '
                        $stocks_out = Yii::app()->db->createCommand($SQL_OUT)->queryScalar();
                        $free_quantity = ($stocks_in - $stocks_out) - $eachtemp['quantity'];
                        //end
                        $StockLedger->current_stock = $free_quantity;
                        $StockLedger->save(false);
                        $stockledgerOut = Yii::app()->db->createCommand("select SUM(quantity*unit_exchange_rate) AS qty from erp_stock_ledger where in_stockledger_id=" . $StockledgerIn->id)->queryScalar();
                        $bal = ($StockledgerIn->quantity * $StockledgerIn->unit_exchange_rate) - $stockledgerOut;
                        if ($bal < 0.1) {
                            if ($StockledgerIn->bin_id > 0) {
                                $bin = MasInvBin::model()->findByPk($StockledgerIn->bin_id);
                                $bin->is_free = "Y";
                                $bin->save(false);
                            }
                        }
                        $raks = MasInvBin::model()->findAll(array('condition' => 'is_free="N" AND rack_id=' . $StockledgerIn->rack_id));
                        if ((int) $StockledgerIn->rack->total_bins == count($raks)) {
                            if ($StockledgerIn->rack_id > 0) {
                                $rak = MasInvRack::model()->findByPk($StockledgerIn->rack_id);
                                $rak->is_free = "N";
                                $rak->save(false);
                            }
                        } else {
                            if ($StockledgerIn->rack_id > 0) {
                                $rak = MasInvRack::model()->findByPk($StockledgerIn->rack_id);
                                $rak->is_free = "Y";
                                $rak->save(false);
                            }
                        }
                    }
                }

                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error2 = json_decode(CActiveForm::validateTabular($model_item, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1, $error2, $other));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

}
