<?php

class ModeController extends Controller
{
	 public $layout = 'layout';
    public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                        'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover'),
                        'users' => array('*'),
                ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                        'actions' => array('Index','GetList','Create','Disable','SaveMode','GetStatusHistoryList','PrintMasVendorModeReportPDF','Getmodetransitime','AddToFavourite','Documentupload','DeleteDocument', 
                        'UploadCustomerDocuments', 'GetDocumentList','Downloaddocument','GetOtherCalculator','ChangeJobAgentStatus','UpdateJobAgentStatus','Screenshot','SaveScreenshot','GetScreenshotHistoryList',
                        'SendScreenshotMail','GetTracking','GetShipment','UpdateAPIStatus','UpdateBulkTracking','SendeMailToCustomer','LoadCustomersEmail','SendMailToCustomerSubmit','GetMasVendorModeDetails','UpdateDHLBulkTracking','GetMasVendorModeLastUpdatedStatus'
                        ,'DeleteAgentDetails','GetTermsnCondtn'),
                        'expression' => '$user->isMember()',

                ),

                array('deny', // deny all users

                                'users' => array('*'),
                ),
            );
    }
    public function filters() {
            return array('accessControl'); // perform access control for CRUD operations
    }

    public function actionIndex()
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        
        $this->render('index');
    }


    
    public function actionCreate()
    {
        $model=new MasVendorMode(); 

        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false,'jquery-2.1.4.min.js' => false);
      // Yii::app()->clientScript->scriptMap = array('*jquery.js' => false,'*jquery-2.1.4.min.js' => false);
        $this->render('create', array('model' => $model));
    }
    
 public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasVendorMode();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }

    public function actionSaveMode()
    {
        $model = new MasVendorMode();
        if (isset($_POST['MasVendorMode'])) {
            if ((int) @$_POST['MasVendorMode']['id'] > 0) {
                $id = (int) @$_POST['MasVendorMode']['id'];
                $vendor_id = (int) @$_POST['MasVendorMode']['vendor_id'];
                $isDefault = (int) @$_POST['MasVendorMode']['isDefault'];
                if($isDefault == 'Y' ){
                    MasVendorMode::model()->updateAll(array('isDefault' =>'N'), 'vendor_id="'.$vendor_id.'" and id!="'.$id.'"');
                }
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');

            } else {
                

                $vendor_id = (int) @$_POST['MasVendorMode']['vendor_id'];
                $isDefault = (int) @$_POST['MasVendorMode']['isDefault'];
                if($isDefault == 'Y' ){
                    MasVendorMode::model()->updateAll(array('isDefault' =>'N'), 'vendor_id="'.$vendor_id.'"');
                }
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
                $model->scenario = 'add';
                $audit_type = 'CREATED';
            }
            $model->attributes = $_POST['MasVendorMode'];
            if ($model->save()) {
                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    

public function actionGetmodetransitime(){
        $modeid = (int) Yii::app()->request->getParam('modeid'); 
        $model = new MasVendorMode();
        $model = $model->findByPk($modeid);
        $data['transit_time']   = $model->transit_time;
        echo CJSON::encode($data);
    }

public function actionGetList() {
        $model = new MasVendorMode();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'vendor_id',
            1 => 'mode_name',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition  = "  (mode_name LIKE '%" . $searchString . "%' OR vendor_id LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = '';
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["master_mode_edit"])) {
                 
            }
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_mode_delete"])) {
                 
            }
            $rowData[] = array($m,
                $row->vendor_ref->vendor_name,
                $row['mode_name'],
                $row['transit_time'],
                '<div class="btn-wrap text-center">' . $div . '</div>',
               
                array('id' => $row['id'],'code'=>$row['mode_name'], 'status' => $row->isActive,'isDefault' => $row->isDefault),);

            $m++;
        }
 $data['data'] = $rowData;
        echo json_encode($data);

              }
       
    





















    
    public function actionUpdateAPIStatus(){
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('update_api_status');
    }
    
    public function actionUpdateBulkTracking(){
        $shipper_id             = (int) Yii::app()->request->getParam('shipper_id');
        $job_order_id           = 0;
        $job_order_agent_id     = 0;
        $modelMasVendorModeAgent = new MasVendorModeAgentDetails();
        
        if($shipper_id > 0){
            $arr_job_order_agent_details = $modelMasVendorModeAgent->with('MasVendorMode')->findAll(array('condition'=>'t.shipper_id='.$shipper_id.' AND (job_order_status="O" || job_order_status="PD")'));
            
            
            if(count($arr_job_order_agent_details) > 0){
                
                $arr_error_tracking_response=array();
                $arr_success_tracking_response=array();
              foreach($arr_job_order_agent_details as $key=>$job_order_agent_details){
                  $tracking_id = $job_order_agent_details->awb_no;
                  $job_order_id = $job_order_agent_details->job_order_id;
                  $job_order_agent_id = $job_order_agent_details->id;
                  
                  if($tracking_id!=""){
                        $post_url = "https://onlinetools.ups.com/track/v1/details/".$tracking_id;//live
                
                        $curl = curl_init($post_url);
                        
                        $headers = array(
                                        'Content-Type: application/json',
                                        'Accept: application/json',
                                        //'transactionSrc: TestTrack',
                                        //'transId: 12345',
                                        'Username: INFINITYLOG',
                                        'Password: Aramex3003767',
                                        'AccessLicenseNumber: 9D99FF9A45E789BD'
                                        );
                        //curl_setopt($curl, CURLOPT_USERPWD, "username":"Password");
                        curl_setopt($curl, CURLOPT_URL, $post_url);
                        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
                        //curl_setopt($curl, CURLOPT_POST, true);
                        //curl_setopt($curl, CURLOPT_POSTFIELDS,json_encode($post_data) );
                        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                        //curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE); 
                        
                        $responses = curl_exec($curl); 
                         $arr_return_response = json_decode($responses);
                         
              
                         
                        // echo '<pre>';
                        // print_r($arr_return_response);
                                    
                         $jsonData=array();
                         $arr_status = array();
                         $error_flag=0;
                         $arr_errors = array();
                         foreach($arr_return_response as $key=>$eachResponse){
                                if(count($eachResponse->errors)==0){
                                     foreach($eachResponse as $eachItem){
                                         foreach($eachItem as $key1=>$each){
                                             //if(isset($each->message;
                                             foreach($each->package as $item){
                                                 $k=0;
                                                 foreach($item->activity as $key3=>$itemContent){
                                                     
                                                     
                                                     $arr_status[$k]['location'] = $itemContent->location;
                                                     $arr_status[$k]['status'] = $itemContent->status;
                                                     $arr_status[$k]['date'] = $itemContent->date;
                                                     $arr_status[$k]['time'] = $itemContent->time;
                                                     
                                                     $k++;
                                                 }
                                             }
                                         }
                                     }
                                }
                                else{
                                    $error_flag=0;
                                    foreach($eachResponse as $eachItem){
                                         foreach($eachItem as $key1=>$eachErrors){
                                             $arr_errors['message'] = $eachErrors->message;
                                             $error_flag=1;
                                         }
                                    }
                                }
                            }
                            
                            
                            
                        if($error_flag==0){
                            
                            if($job_order_id > 0 && $job_order_agent_id > 0 && $shipper_id >0){                   
                                $current_status_id = $this->getTrackResponse($arr_status,$job_order_id,$job_order_agent_id,$shipper_id,$tracking_id);    
                                $arr_success_tracking_response[]=$tracking_id;
                            }
                            
                            
                        }
                        else{
                            $arr_error_tracking_response[] = $tracking_id;
                        }
                        
                        //print_r($jsonData);
                    }
                    else{
                        //$jsonData['status']     = "failed";
                        //$jsonData['message']    = 'Invalid Enquiry Number';
                    }
                    
                    
                    //echo json_encode($jsonData);
                    
                  
              }
              if(count($arr_success_tracking_response) > 0){
              $jsonData['success']     = "The following AWB# <b>".implode(",",$arr_success_tracking_response).'</b> updated successfully';
              }
              else{
                  $jsonData['success']     = "No data updated";
              }
              if(count($arr_error_tracking_response) > 0){
                $jsonData['error']     = "The following AWB# <b>".implode(",",$arr_error_tracking_response).'</b> showing as invalid enquiry number';
              }
              else{
                  $jsonData['error']     = "";
              }
              
              
            }
            else{
                $jsonData['error']     = "Invalid Enquiry Number";
            }
        }
        
        echo json_encode($jsonData);
    }
    
    public function actionSendeMailToCustomer(){
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('send_mail_to_customer');
    }
    
    public function actionLoadCustomersEmail(){
        $shipper_id                     =   (int) Yii::app()->request->getParam('shipper_id');
        $modelMasVendorModeAgent             =   new MasVendorModeAgentDetails();
        $arr_error_tracking_response    =   array();
        $arr_success_tracking_response  =   array();
        if($shipper_id > 0){
            $arr_job_order_agent_details = $modelMasVendorModeAgent->with('MasVendorMode')->findAll(array('condition'=>'t.shipper_id='.$shipper_id.' AND (job_order_status="O" || job_order_status="PD") AND activity_type=3'/*,'limit'=>10*/));
            
            $count_email=0;
            if(count($arr_job_order_agent_details) > 0){
            
                $data ='<table class="table table-hover table-bordered personal-task" id="tbl_customer_contact">
                <thead>
                    <th><input type="checkbox" id="chk_all_contacts" onclick="checkAllContacts();"></th>
                    <th>Job Order</th>
                    <th>AWB</th>
                    <th>Customer</th>
                    <th>Contact</th>
                    <th>Email</th>
                </thead>
                <tbody>';
                 $i=1;
                 
                    $str_awb_no="";
                    $str_email_ids = "";
                    foreach($arr_job_order_agent_details as $key=>$job_order_agent_details){
                        
                        $job_order_id       = $job_order_agent_details->job_order_id;
                        $job_order_agent_id = $job_order_agent_details->id;
                        
                        $modelMasVendorModeMailStatus = new MasVendorModeMailStatus();
                        
                        $SQL="SELECT MAX(status_updated_date) AS status_updated_date,status_mail_send FROM `erp_job_order_mail_status` WHERE job_order_id=".$job_order_id." AND job_order_agent_id=".$job_order_agent_id." AND job_order_agent_shipper_id=".$shipper_id."  GROUP BY id ORDER BY status_updated_date DESC LIMIT 0,1";
                        $arr_job_order_mail_status = Yii::app()->db->createCommand($SQL)->queryRow();
            
                        $status_mail_send       = $arr_job_order_mail_status['status_mail_send'];
                        
                        if($status_mail_send=='N'){
                        
                                        $customer_id = $job_order_agent_details->MasVendorMode->customer_id;
                                        $job_order_id = $job_order_agent_details->job_order_id;
                                        
                                        $customer_contact_ids = $job_order_agent_details->MasVendorMode->contact_ids;
                                        
                                        //$arr_customer_contact_details = CustomerContact::model()->with('customer','department')->findAll(array('condition'=>'customer_id='.$customer_id.' AND department.department_code="SU"'));//status update
                                        $arr_customer_contact_details = CustomerContact::model()->findAll(array('condition'=>'id IN('.$customer_contact_ids.')'));
                                        if(count($arr_customer_contact_details) > 0){
                                           
                                            foreach($arr_customer_contact_details as $eachContact){
                                                $data.='<tr>';
                                                if(!empty($eachContact->contact_email_id)){
                                                    
                                                    if($str_awb_no!=$job_order_agent_details->awb_no || $str_email_ids!=$eachContact->contact_email_id){
                                                        $str_awb_no=$job_order_agent_details->awb_no;
                                                        $str_email_ids = $eachContact->contact_email_id;
                                                        $count_email++;
                                                        $data.='<td><input type="checkbox" id="chkMasVendorModeid_'.$i.'" name="chkMasVendorModeid[]" value="'.$job_order_id.'" class="check_contact_ids"></td>';
                                                        $data.='<td>'.$job_order_id.'</td>';
                                                        $data.='<td>'.$job_order_agent_details->awb_no.'</td>';
                                                        $data.='<td>'.$eachContact->customer->customer_name.'</td>';
                                                        $data.='<td>'.$eachContact->person_name.'</td>';
                                                        $data.='<td>'.$eachContact->contact_email_id;
                                                        $data.='<input type="hidden" id="hidMasVendorModeagentid_'.$i.'" name="hidMasVendorModeagentid[]" value="'.$job_order_agent_id.'">';
                                                        $data.='<input type="hidden" id="hidcustomercontactid_'.$i.'" name="hidcustomercontactid[]" value="'.$eachContact->id.'">';
                                                        $data.='</td>';
                                                        $i++;
                                                    }
                                                }
                                                $data.='</tr>';
                                                
                                            }
                                           
                                        }
                                        
                                    
                            
                        }
                        
                        
                    }
                    
                    if($count_email==0){
                         $data.='<tr>';
                            $data.='<td colspan="5" align="center">No result found</td>';
                            $data.='</tr>';
                    }
                   
                $data.='</tbody>';
                $data.='</table>';
                $jsonData['success'] = $data;
                //$arr_success_tracking_response = $this->renderPartial('list_send_mail',array('arr_job_order_agent_details'=>$arr_job_order_agent_details));
                
                
              
            }
            else{
                
                $arr_error_tracking_response[]="There is no Job order against the selected Shipper";
            }
            
        }
        else{
            $arr_error_tracking_response[]="Please select a valid Shipper";
        }
        
        
         $jsonData['error'] = $arr_error_tracking_response;
        
        echo json_encode($jsonData);
    }
    
    public function actionSendMailToCustomerSubmit(){
        
        $shipper_id                 =   Yii::app()->request->getParam('shipper_id');
        $job_order_ids              =   Yii::app()->request->getParam('job_order_ids');
        $job_order_agent_ids        =   Yii::app()->request->getParam('agent_ids');
        $customer_contact_ids       =   Yii::app()->request->getParam('contact_ids');
        $arr_job_order_ids          =   explode(",",$job_order_ids);
        $arr_job_order_agent_ids    =   explode(",",$job_order_agent_ids);
        $arr_contact_ids            =   explode(",",$customer_contact_ids);
       //foreach($arr_job_order_ids as $job_order_id){
       $arr_error_tracking_response    =   array();
        $arr_success_tracking_response  =   array();
        $valid_email=0;
       for($cnt=0;$cnt<count($arr_job_order_ids);$cnt++){
           
           $job_order_id        = $arr_job_order_ids[$cnt];
           
           $job_order_agent_id  = $arr_job_order_agent_ids[$cnt];
           
           $customer_contact_id = $arr_contact_ids[$cnt];
           
           
           $modelMasVendorModeAgentDetails       =   new MasVendorModeAgentDetails();
           $modelMasVendorModeAgentDetails       =   $modelMasVendorModeAgentDetails->findBypk($job_order_agent_id);
            
            $modelMasVendorMode      =   new MasVendorMode();
            
            $modelMasVendorMode      =   $modelMasVendorMode->findBypk($job_order_id);
            
            $lead_owner_id = (int) $modelMasVendorMode->lead_owner_id;
            $arr_lead_owner_details = User::model()->findByPk($lead_owner_id);
            
            $lead_owner_email = trim($arr_lead_owner_details->email);
            
            $arr_customer_contact_details = CustomerContact::model()->findByPk($customer_contact_id); 
            
            
            $modelStatusHistory =  new MasVendorModeStatusHistory();
            
            //$arr_status_history = $modelStatusHistory->with('MasVendorMode','owner')->findAll(array('condition'=>'job_order_id='.$job_order_id.' AND job_order_agent_id='.$job_order_agent_id,'order' => 't.id DESC'));
            $arr_status_history = $modelStatusHistory->with('MasVendorMode','owner')->findAll(array('condition'=>'job_order_id='.$job_order_id.' AND job_order_agent_id='.$job_order_agent_id,'order' => 't.status_date DESC'));
            
            if(!empty($arr_customer_contact_details->contact_email_id) && count($arr_status_history) > 0){
                
                $email_id = trim($arr_customer_contact_details->contact_email_id);
                
                
                            
                $mailContent['company_name']    = Yii::app()->user->master_company_name;
                
                $mailContent['salutation'] =  'Customer';
                
                
               /* if(!empty($lead_owner_email)){
                    $mailContent['salutation']  = $arr_lead_owner_details->first_name." ".$arr_lead_owner_details->last_name;
                }
                else{
                    $mailContent['salutation']      = $arr_customer_contact_details->person_name;
                }*/
                $mailContent['content']         = $screenshot;
                $mailContent['job_order_id']    = $job_order_id;
                $mailContent['status_history']  = $arr_status_history;
                
                $message = new YiiMailMessage;
                $message->view = 'email_status_history';
                $message->setBody(array('mailContent' => $mailContent), 'text/html');
                $message->subject ='Tracking History - AWB: '.$modelMasVendorModeAgentDetails->awb_no." | Job#: ".$job_order_id; 
                $message->from ='updates@infinitylogisticsme.com';
                
                 if (filter_var($email_id, FILTER_VALIDATE_EMAIL)) {
                     $message->addTo($email_id);
                     $valid_email++;
                 }
                
                if(!empty($lead_owner_email)){
                    if (filter_var($lead_owner_email, FILTER_VALIDATE_EMAIL)) {
                        $message->addTo($lead_owner_email);
                        $valid_email++;
                    }
                    
                }
                if($valid_email==0){
                    $message->addTo("updates@infinitylogisticsme.com");
                    $message->subject ='Mail Sending Error: Tracking History - AWB: '.$modelMasVendorModeAgentDetails->awb_no." | Job#: ".$job_order_id; 
                }
                else{
                    $message->addBcc('updates@infinitylogisticsme.com');
                }
                //$message->addBcc('mereena.vinod@mailbluesky.com');
                $message->addBcc('aswanth@infinitylogisticsme.com');
                //$message->addBcc('arun@mailbluesky.com');
                
                //$message->addTo('mereena.hannah@gmail.com');
                Yii::app()->mail->send($message); 
                 $jsonData['status'] = "success";
                 $modelMasVendorModeMailStatus = new MasVendorModeMailStatus();
                $modelMasVendorModeMailStatus->updateAll(array('status_mail_send' => 'Y'), 'job_order_id ='.$job_order_id.' AND job_order_agent_id='.$job_order_agent_id.' AND job_order_agent_shipper_id='.$shipper_id);
                $arr_success_tracking_response[]=$email_id;
                
                
            }
            
            
        }
        
        if(count($arr_success_tracking_response) > 0){
            $jsonData['success']     = "Mail sent successfully to this email id(s) <b>".implode(",",$arr_success_tracking_response).'</b>';
            $jsonData['error'] = "";
        }
        else{
            $jsonData['success']="";
            $jsonData['error'] = "There is no email send";
        }
        
       
        
         echo json_encode($jsonData);
        
    }
    
    
    public function actionGetMasVendorModeDetails(){
        $job_order_id           = (int) Yii::app()->request->getParam('job_order_id');
        $modelMasVendorMode          = MasVendorMode::model()->findByPk($job_order_id);
        
        $data ='<table class="table table-hover table-bordered personal-task" id="tbl_customer_contact">
               
                <tbody>
                 <tr>
                        <th colspan="5"><span style="background-color: orange;color:white;width:250px;text-align:center;border-radius:5px;"><b>Job Order Details</b></span></th>
                    </tr>
                    <tr>
                        <td>Customer</td>
                        <th>'.$modelMasVendorMode->customer->customer_name.'</th>
                        <td>Job Date</td>
                        <th>'.date('d/m/Y',strtotime($modelMasVendorMode->job_date)).'</th>
                        <td>Shipper</td>
                        <th>'.$modelMasVendorMode->shipper_id.'</th>
                    </tr>
                    
                    <tr>
                        <td>Consignee</td>
                        <th>'.$modelMasVendorMode->consignee_id.'</th>
                        <td>Origin</td>
                        <th>'.$modelMasVendorMode->org->country_name.'</th>
                        <td>Destination</td>
                        <th>'.$modelMasVendorMode->dest->country_name.'</th>
                    </tr>
                    
                    <tr>
                        <td>Assign Job</td>
                        <th>'.$modelMasVendorMode->leadowner->fullName.'</th>
                        <td>Weignt(KG)</td>
                        <th>'.$modelMasVendorMode->weight.'</th>
                        <td>Volume(CBM)</td>
                        <th>'.$modelMasVendorMode->volume.'</th>
                    </tr>
                    <tr>
                        <td>Customer Reference</td>
                        <th>'.$modelMasVendorMode->customer_reference_no.'</th>
                        <td>Selling Price</td>
                        <th style="text-align:right">'.$modelMasVendorMode->selling_price.'</th>
                        <td>Payment Terms</td>
                        <th>'.$modelMasVendorMode->paymentmethod->payment_terms.'</th>
                    </tr>
                </tbody>
                </table>
                ';
                $jsonData['success'] = $data;
                
                echo json_encode($jsonData);
                
    }
    
    
    public function actionUpdateDHLBulkTracking(){
        
        $auth_string = '{"userId":"dikson@bluesky","key":"3LGqZDjvUGNQGj121xlqyFP5VtCwyp1C"}';
        
        //f36abdfa- 9894-4d1f-bb6e-e471a953c04d
        
        //curl -X POST "https://api-gw.dhlparcel.nl/authenticate/api-key" -H "Accept:application/json" -H "Content-Type: application/json" -d "{\"userId\": \"f36abdfa- 9894-4d1f-bb6e-e471a953c04d\", \"key\": \"1c8545e1-767f-4531-9c6b-5f5f80737562\"}"
        
        $arr_auth['userId'] = "dikson@bluesky";
        $arr_auth['key'] = "3LGqZDjvUGNQGj121xlqyFP5VtCwyp1C";
        
        //$auth_string=json_encode($arr_auth);
        
        $ch = curl_init('https://api-gw.dhlparcel.nl/authenticate/api-key/3LGqZDjvUGNQGj121xlqyFP5VtCwyp1C');
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $auth_string);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json','Accept:application/json'));
        $auth_response = curl_exec($ch);
        $api_key = json_decode($auth_response);
        $accessToken = $api_key->{'accessToken'};
        
        
        echo '<pre>';
        print_r($auth_response);
        
        echo '<pre>';
        print_r($accessToken);
        
        echo "success";
        
        
        
        /*$mode        = 'sandbox'; // sandbox or production
        $username    = 'dikson@bluesky'; // dhl developer account name, not email
        $password    = 'Dikson@bluesky1'; // dhl developer account pass
        $appname     = 'zt12345'; // sandbox app
        $apppass     = 'geheim'; // sandbox app
        $endpoint    = 'https://cig.dhl.de/services/' . $mode . '/rest/sendungsverfolgung';
        $payload     = simplexml_load_string( '<?xml version="1.0" encoding="UTF-8" standalone="no"?><data appname="' . $appname . '" language-code="de" password="' . $apppass . '" piece-code="" request="d-get-piece-detail"/>' );
        $shipmentids = array(
            '00340434161094015902' // in sandbox only special numbers are allowed
        );
        
        
        $opts = array(
            'http' => array(
                'method' => "GET",
                'header' => "Authorization: Basic " . base64_encode( "$username:$password" )
            )
        );
        
        $context = stream_context_create( $opts );
        
        
        foreach ( $shipmentids as $shipmentid ) {
            $payload->attributes()->{'piece-code'} = $shipmentid;
            $response                              = file_get_contents( $endpoint . '?' . http_build_query( array( 'xml' => $payload->saveXML() ) ), false, $context );
            $responseXml                           = simplexml_load_string( $response );
            $status                                = null;
        
            // get last state
            foreach ( $responseXml->data->data->data as $event ) {
                $status = $event->attributes()->{'event-short-status'};
            }
        
            echo "Shipment " . $shipmentid . " is in state: " . $status . "\n";
        }*/
        //$tracking_number = "4047228441123";
        //print_r($this->dhl_tracking($tracking_number));
        
    }
    
    function dhl_tracking($trackingnumber)
    {
       $data  = '<?xml version="1.0" encoding="ISO-8859-1" ?>';
       $data .= '<data appname="nol-public" password="anfang" request="get-status-for-public-user" language-code="de">';
       $data .= '  <data piece-code="'.$trackingnumber.'"></data>';
       $data .= '</data>';
    
       // URL bauen und File hohlen
       $xml = simplexml_load_file(sprintf(
          'http://nolp.dhl.de/nextt-online-public/direct/nexttjlibpublicservlet?xml=%s', $data
       ));
    
       // FALSE, wenn Syntax oder HTTP Error
       if ($xml === false) return false;
    
       // Wandelt das SimpleXML Objekt in ein Array um
       foreach ($xml->data->data->attributes() as $key => $value) {
          $return[$key] = (string) $value;
       }
       return $return;
    }
    
    
    public function actionGetMasVendorModeLastUpdatedStatus(){
        $job_order_id           = (int) Yii::app()->request->getParam('job_order_id');
        $SQL="SELECT status_description,date_format(concat(`status_date`,'',`status_time`),'%m/%d/%Y %h:%i:%s') AS date_time FROM `erp_job_order_status_history` WHERE job_order_id=".$job_order_id.' ORDER By id DESC LIMIT 0,1';
        $arr_status_details = Yii::app()->db->createCommand($SQL)->queryAll();
        
        $data='<table class="table table-hover table-bordered personal-task">';
        $data.='<tr>';
        $data.='<th>Status</th>';
        $data.='<th>Date/Time</th>';
        $data.='</tr>';
        if($arr_status_details[0]['status_description']!="" || $arr_status_details[0]['date_time']!=""){
            $data.='<tr>';
            $data.='<td>'.$arr_status_details[0]['status_description'].'</td>';
            $data.='<td>'.$arr_status_details[0]['date_time'].'</td>';
            $data.='</tr>';
        }
        else{
            $data.='<tr>';
            $data.='<td colspan="2" align="center">No Data Found</td>';
            $data.='</tr>'; 
        }
        $data.='</table>';
        
        echo $data;
        
    }

    
   
    
    
    public function actionDeleteAgentDetails(){
         $agent_details_id          =   (int) Yii::app()->request->getParam('agent_id');
         $modelPurchaseInvoiceItem  = new PurchasingInvoiceItem();
         $count_purchase            = (int) $modelPurchaseInvoiceItem->count(array('condition'=>'job_order_agent_id='.$agent_details_id));
         $modelInvoiceItem          = new InvoiceItem();
         $count_invoice             = (int) $modelInvoiceItem->count(array('condition'=>'order_item_id='.$agent_details_id));
         
         if($count_purchase==0 && $count_invoice==0){
             $modelAgentDetails = new MasVendorModeAgentDetails();
             $modelAgentDetails->deleteByPk($agent_details_id);
             $jsonData['status'] = "success";
         }
         else{
             if($count_invoice > 0 && $count_purchase > 0){
                 $msg="Error while delete. Details used in both Purchase Invoice and Invoice";
             }
             elseif($count_purchase > 0){
                 $msg="Error while delete. Details used in Purchase Invoice";
             }
             elseif($count_invoice > 0){
                 $msg="Error while delete. Details used in Invoice";
             }
             
             $jsonData['message']   = $msg;
             $jsonData['status']    = 'failed';
         }
         echo json_encode($jsonData);
    }
    
    
    public function actionGetTermsnCondtn()
    {
        $id = $_POST['vendor_id'];
        $modelVendor = Vendor::model()->findByPk($id);
        $vendor_termsnconditions = $modelVendor->vendor_termsnconditions;
        echo $vendor_termsnconditions;
    }
   
}