<?php

class MigrationsController extends Controller
{

    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index','GetJobOrderList','Create','savejoborder','DeleteAgentDetails',
                    
                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

 public function actionIndex()
     {
     	$this->render('index');
     }

    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }


    public function actionGetJobOrderList()
    {
            $model=new JobOrder();
            $draw   = $_POST['draw'];
            $offset = $_POST['start'];
            $limit  = $_POST['length'];
            
            
            $frm  = $_POST['frm'];
            $columns = array(
                            // datatable column index  => database column name

                            0=>'file_id',
                            1=>'job_order_id',
                            2=>'job_date',
                            3=>'customer_name',
                            4=>'agent',                           
                            5=>'awb_no',
                            6=>'status_description',
                                               
            );

            $filterColumn = $columns[$_POST['order'][0]['column']];
            $filterOrder  = $_POST['order'][0]['dir'];
            
            if($_POST['order'][0]['column']==0){
                $filterColumn='job_order_id';
                $filterOrder='DESC';
            }
            $orderBy      = $filterColumn." ".$filterOrder;
            
            
            
            //$condition="1=1";
            $condition="(job_order_status!='CN' AND job_order_status!='I')";
            if(isset($_POST['filter_job_order_status']) && $_POST['filter_job_order_status']!="")
            {
            	$condition =" job_order_status='".$_POST['filter_job_order_status']."'";
            }
            
            
            if(((int) Yii::app()->user->havePermissionOn["job_order_view_all"]) == 0){
                $condition.= ' AND lead_owner_id= "'.Yii::app()->user->id.'"';
            }
            
            
           /* else{
                $condition  ="job_order_status IN('O','PD')";
            }*/
            if(isset($_POST['filter_job_order_transport_type']) && $_POST['filter_job_order_transport_type']!="")
            {
            	$condition.=" AND transport_type='".$_POST['filter_job_order_transport_type']."'";
            }
            if(isset($_POST['filter_job_order_priority']) && $_POST['filter_job_order_priority']!="")
            {
            	$condition.=" AND job_priority='".$_POST['filter_job_order_priority']."'";
            }
            if(isset($_POST['filter_job_order_no']) && $_POST['filter_job_order_no']!="")
            {
            	$condition.=" AND job_order_id LIKE '%".$_POST['filter_job_order_no']."%'";
            }
            if(isset($_POST['filter_job_order_shipper']) && $_POST['filter_job_order_shipper']!="")
            {
            	$condition.=" AND customer_id='".$_POST['filter_job_order_shipper']."'";
            }
            if(isset($_POST['filter_job_order_agent']) && $_POST['filter_job_order_agent']!="")
            {
            	$condition.=" AND FIND_IN_SET(".$_POST['filter_job_order_agent'].",agent_ids)";
            }
            if(isset($_POST['filter_job_order_awb_no']) && $_POST['filter_job_order_awb_no']!="")
            {
            	$condition.=" AND awb_no LIKE'%".$_POST['filter_job_order_awb_no']."%'";
            }
            if(isset($_POST['filter_job_order_last_updated_status']) && $_POST['filter_job_order_last_updated_status']!="")
            {
            	$condition.=" AND current_status='".$_POST['filter_job_order_status']."'";
            }
            
            if(isset($_POST['filter_job_order_date']) && $_POST['filter_job_order_date']!="")
            {
            	
            	
            	
            	$filter_job_date       = str_replace('/', '-', $_POST['filter_job_order_date']);
                $filter_job_date       = date("Y-m-d", strtotime($filter_job_date));
                $condition.=" AND DATE(job_date) LIKE'%".$filter_job_date."%'";   
           
            	
            	
            }
            
          
            
          
            if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
            {
               
                $searchString = $_POST['search']['value'];
                $condition=" (job_order_id LIKE '%".$searchString."%' OR customer_name LIKE '%".$searchString."%' OR file_id LIKE '%".$searchString."%' OR origin LIKE '%".$searchString."%'  OR destination LIKE '%".$searchString."%' OR transport_type LIKE '%".$searchString."%')";
                
                if(((int) Yii::app()->user->havePermissionOn["job_order_view_all"]) == 0){
                    $condition.= ' AND lead_owner_id= "'.Yii::app()->user->id.'"';
                }
                
            }
            
          
            
            $SQL1="SELECT * FROM view_job_order_list WHERE $condition ORDER BY ".$orderBy." LIMIT $offset,$limit";
            $model = Yii::app()->db->createCommand($SQL1)->queryAll();
            
            
            $SQL_CNT = "SELECT COUNT(*) as clients FROM view_job_order_list WHERE $condition";
            $count = Yii::app()->db->createCommand($SQL_CNT)->queryScalar();
            
         
            $recordsTotal = $count;
            $recordsFiltered = $count;
            $data['draw'] = $draw;
            $data['recordsTotal'] = $recordsTotal;
            $data['recordsFiltered'] = $recordsFiltered;
            $rowData=array();
            $m=1;
            foreach ($model as $j=>$row)
            {
                $SQL_JOA = "SELECT COUNT(id) FROM erp_job_order_agent_details WHERE activity_type=0 AND job_order_id=".(int) $row['job_order_id'];
                $count_agent_type = (int) Yii::app()->db->createCommand($SQL_JOA)->queryScalar();
                
                
                $div = '';
                
                $modelJobOrderAgent = new JobOrderAgentDetails();
                $destination='';
                if((int)$row['destination']>0)
                {
                $destination=MasCountry::model()->findByPk($row['destination'])->country_name;
                }
                $origin='';
                if((int)$row['origin']>0)
                {
                $origin=MasCountry::model()->findByPk($row['origin'])->country_name;
                }
                
                switch($row['job_order_status']){
                    case 'PD':
                        $row_job_order_status="Partially Delivered";
                        break;
                    case 'D':
                        $row_job_order_status="Delivered";
                        break;
                    case 'C':
                        $row_job_order_status="Completed";
                        break;
                    case 'I':
                        $row_job_order_status="Invoiced";
                        break;
                    case 'CN':
                        $row_job_order_status="Cancel";
                        break;
                    default:
                        $row_job_order_status="Open";
                        break;
                }
                
                  $date_today = date('Ymd');
                  $job_today= $row['job_date'];
                  $current_today = date('Y-m-d');
                  $modelStatusHistory = new JobOrderStatusHistory();
                 $count_request_exist = (int) $modelStatusHistory->count(array('condition' =>'job_order_id="'.$row['job_order_id'].'"AND current_status>0 AND  t.status_date ="' . $date_today . '"'));
            
               if($count_request_exist==0 &&  $job_today== $current_today){
               
                  $status_div = ' <a href="#" class="jobOrderStatusOver" id="locationhelper_'.$m.'_'.$row['job_order_id'].'"><i class="fa fa-info-circle"style="color:red"><div class="triangle-right"></div></i></a>';      
                }
                else if($count_request_exist >0 ||  $job_today== $current_today || $row['job_order_status']=='C'){
                 $status_div = ' <a href="#" class="jobOrderStatusOver" id="locationhelper_'.$m.'_'.$row['job_order_id'].'"><i class="fa fa-info-circle"style="color:yellow"><div class="triangle-right"></div></i></a>';      
                }
                else {
                     $status_div = ' <a href="#" class="jobOrderStatusOver" id="locationhelper_'.$m.'_'.$row['job_order_id'].'"><i class="fa fa-info-circle"><div class="triangle-right"></div></i></a>';      
                }
              
                $rowData[]=array($m.$status_div,$row['job_order_id'],date("d/m/Y",strtotime($row['job_date'])),$row['customer_name'],$row['agent'],$row['awb_no'],$row_job_order_status,$row['job_order_status'],$row['customer_id'],$row['file_id']);
                $m++;
            }
            $data['data'] = $rowData;

            echo json_encode($data);

    }



    public function actionCreate()
    {
        $model              =   new JobOrder();
        $modelQuotes        =   new Quotation();
        
        $id         = (int) Yii::app()->request->getParam('id');
        //$forwarderid         = (int) Yii::app()->request->getParam('forwarderid');
          $forwarderid         =  Yii::app()->request->getParam('forwarderid');
        $file_id    = (int) Yii::app()->request->getParam('file_id');
        $quote_id   = (int) Yii::app()->request->getParam('quote_id');
        $frm        = Yii::app()->request->getParam('frm');
        //echo $id;
        
        $model->file_id     = $file_id;
        $model->quote_id    = $quote_id;
        
        if($quote_id > 0){
            
            $modelQuotes = $modelQuotes->findByPk($quote_id);
            $model->attributes = $modelQuotes;
            $model->customer_id = $modelQuotes->customer_id;
            $model->lead_owner_id = $modelQuotes->lead_owner_id;
            $model->shipper_id = $modelQuotes->shipper_id;
            $model->consignee_id = $modelQuotes->consignee_id;
            $model->origin = $modelQuotes->origin_id;
            $model->destination = $modelQuotes->destination_id;
            $model->currency_id = $modelQuotes->currency_id;
            $model->exchange_rate = $modelQuotes->exchange_rate;
            $model->lead_owner_id = $modelQuotes->lead_owner_id;
            $model->weight = $modelQuotes->weight;    
            $model->volume = $modelQuotes->volume;   
            $model->booking_reference = $modelQuotes->booking_reference;                     
            $model->transport_type = $modelQuotes->transport_type;                     
            $model->customer_reference_no = $modelQuotes->customer_reference_no;                     
            $model->payment_terms_id = $modelQuotes->payment_terms_id;                     
            $model->selling_price = $modelQuotes->selling_price;         
            $model->contact_ids = $modelQuotes->contact_ids;
            
             
             if($forwarderid!=''){
                //$arr_forwarderid = explode(",", $forwarderid);
                //$forwarderid=implode(",",$arr_forwarderid);
                //$condition_forwarder = "quotation_id= '".$quote_id."' AND forwarder_id = '".$forwarderid."'";
                 $condition_forwarder = "quotation_id= '".$quote_id."' AND forwarder_id IN(".$forwarderid.")";
            }else if($forwarderid==''){

               $condition_forwarder = "quotation_id= '".$quote_id."'";
            }
           
            
           /* $str_forwarder_id='';
            for($arr_forwarderid as $agent_id){
                if($str_forwarder_id==''){
                $str_forwarder_id=
            }*/
            


            $modelQuotesItems = QuotationItems::model()->findAll(array('condition' =>  $condition_forwarder,'order'=>'t.id asc'));
            if (!empty($modelQuotesItems)) {
                $k=0;
                foreach ($modelQuotesItems as $eachItem) {
                    $modelAgentDetails[$k] = new JobOrderAgentDetails();
                    $modelAgentDetails[$k]->attributes = $eachItem->attributes;
                    $modelAgentDetails[$k]->shipper_id = $eachItem->forwarder_id;
                    $k++;
                }
            }
            
            /*echo '<pre>';
            print_r($modelAgentDetails);*/
        }
        else{
            $modelAgentDetails  =   array(new JobOrderAgentDetails);
        }
        
        
        if($id>0)
        {
            $model = $model->findByPk($id);
            
            $modelAgentDetails = JobOrderAgentDetails::model()->findAll(array('condition'=>'job_order_id="'.$id.'"','order' => 'id ASC')); 
            if(empty($modelAgentDetails)){
                     $modelAgentDetails = array(new JobOrderAgentDetails);
            }
            
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false,'jquery-2.1.4.min.js' => false);
      // Yii::app()->clientScript->scriptMap = array('*jquery.js' => false,'*jquery-2.1.4.min.js' => false);
        $this->render('create', array('model' => $model,'modelAgentDetails'=>$modelAgentDetails,'modelQuotes'=>$modelQuotes,'quote_id'=>$quote_id,'frm'=>$frm));
    }
    


public function actionCreate_joborder()
    {
        $model              =   new QuotationItems();

        $id         = (int) Yii::app()->request->getParam('id');
        $file_id    = (int) Yii::app()->request->getParam('file_id');
        $quote_id   = (int) Yii::app()->request->getParam('quote_id');
        $frm        = Yii::app()->request->getParam('frm');
          $condition ="quotation_id= '".$quote_id."' GROUP BY forwarder_id";
       $modelQuotesItems = QuotationItems::model()->findAll(array('condition' =>  $condition,'order'=>'t.id asc'));
       foreach ($modelQuotesItems as $eachItem) {
        $forwarder_id=$eachItem->forwarder_id;
        $forwarder_ids []= $forwarder_id;
       }
        $forwarderids = implode(', ',$forwarder_ids);

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false,'jquery-2.1.4.min.js' => false);
      // Yii::app()->clientScript->scriptMap = array('*jquery.js' => false,'*jquery-2.1.4.min.js' => false);
        $this->render('create_joborder', array('model' => $model,'quote_id'=>$quote_id,'forwarderids'=>$forwarderids,'id'=>$id,'file_id'=>$file_id));
    }



    public function actionSaveJobOrder() {
        $valid=TRUE;
        $model = new JobOrder();
        //$modelMaster=new MasterFile();
        $other = array();
        //$modelJobOrderStatusHistory = array(new JobOrderStatusHistory());
        if (isset($_POST['JobOrder'])) {         
            $scenario='';
            if ((int) @$_POST['JobOrder']['id'] > 0) {
                    $model->id = (int) $_POST['JobOrder']['id'];
                    $model->updated_by = Yii::app()->user->id;
                    $model->updated_date_time =date('Y-m-d h:i:s'); 
                    $model = $model->findByPK($model->id);
                    $model->scenario = 'update';
                    $scenario='update';
                    $JobOrder_type = 'UPDATED';
                    
                    
                    /***************** code added by mereena on 24/06/2022 ***********/
                    if($model->job_order_status=='I'){
                        $other[]="Job order already converted to invoice. Please refresh page";
                        $valid=false;
                    }
                    
                    /****************************** End **************************/

            } else {
                    $model->created_by = Yii::app()->user->id;
                    $model->created_date_time =date('Y-m-d h:i:s');
                    $model->scenario = 'add';
                    $scenario='add';
                    $JobOrder_type = 'CREATED';
            }
            $model->attributes = $_POST['JobOrder'];
            // $model->job_priority=$_POST['JobOrder']['job_priority'];

            $model->selling_price=str_replace(',', '', $_POST['JobOrder']['selling_price']);;
            $model->job_order_remarks=$_POST['JobOrder']['job_order_remarks'];
            
            if(!empty($_POST['JobOrder']['contact_ids'])){
                $model->contact_ids=implode(",", $_POST['JobOrder']['contact_ids']);
            }
            
            $model->terms_and_conditions = $_POST['terms_and_conditions'];
            
            
            if($_POST['JobOrder']['job_date']!=''){
                $model->job_date = str_replace('/', '-', $_POST['JobOrder']['job_date']);
                $model->job_date= date("Y-m-d", strtotime($model->job_date));
            }
            $valid = $valid && $model->validate();
            
            $p=0;
            if (is_array($_POST['JobOrderAgentDetails'])) {
                $prod_id=0;
                
                foreach ($_POST['JobOrderAgentDetails'] as $i => $item) {                    
                    
                    //if ($item['shipper_id'] > 0) {
                        
                         if ($item['id'] > 0) {
                            $modelJobOrderAgentDetails[$p] = JobOrderAgentDetails::model()->findByPK($item['id']); 
                        } else {
                            $modelJobOrderAgentDetails[$p] = new JobOrderAgentDetails; 
                        }
                        
                        
                            // if($modelJobOrderAgentDetails[$p]->status!=$item['status'] && $item['id']>0){
                                
                            //     $existing_status    =   MasJobOrderStatus::getStatusOfJobOrder($modelJobOrderAgentDetails[$p]->status);
                            //     $new_status         =   MasJobOrderStatus::getStatusOfJobOrder($item['status']);
                                
                            //     $status_description     =   "Status ".$existing_status." changed to ".$new_status;
                                
                            //     $modelJobOrderStatusHistory[$c]                         =   new JobOrderStatusHistory; 
                            //     $modelJobOrderStatusHistory[$c]->job_order_agent_id     =   $item['id'];
                            //     $modelJobOrderStatusHistory[$c]->current_status         =   $item['status'];
                            //     $modelJobOrderStatusHistory[$c]->status_description         =   $new_status;
                            //     $modelJobOrderStatusHistory[$c]->updated_by             =   Yii::app()->user->id;
                            //     $modelJobOrderStatusHistory[$c]->updated_date_time      =   date('Y-m-d h:i:s');
                            //     $modelJobOrderStatusHistory[$c]->status_updation        =   "M";
                            //     $modelJobOrderStatusHistory[$c]->status_date            =   date('Ymd');
                            //     $modelJobOrderStatusHistory[$c]->status_time            =   date('his');
                            //     $modelJobOrderStatusHistory[$c]->updated_date_time      =   date('Y-m-d h:i:s');
                            //     $c++;
                            // }
                            
                            $modelJobOrderAgentDetails[$p]->attributes              =   $_POST['JobOrderAgentDetails'][$i];
                            $modelJobOrderAgentDetails[$p]->shipper_id              =   $item['shipper_id'];
                            $modelJobOrderAgentDetails[$p]->awb_no                  =   $item['awb_no'];
                            $modelJobOrderAgentDetails[$p]->planned_weight          =   $item['planned_weight'];
                            $modelJobOrderAgentDetails[$p]->planned_volume          =   $item['planned_volume'];
                            $modelJobOrderAgentDetails[$p]->planned_cost            =   $item['planned_cost'];
                            $modelJobOrderAgentDetails[$p]->planned_selling_price   =   $item['planned_selling_price'];
                            $modelJobOrderAgentDetails[$p]->actual_weight           =   $item['actual_weight'];
                            $modelJobOrderAgentDetails[$p]->actual_volume           =   $item['actual_volume'];
                            $modelJobOrderAgentDetails[$p]->actual_cost             =   $item['actual_cost'];
                            $modelJobOrderAgentDetails[$p]->status                  =   $item['status'];
                            $modelJobOrderAgentDetails[$p]->notes                   =   $item['notes'];
                            
                            
                            $valid = $modelJobOrderAgentDetails[$p]->validate() && $valid;
                            $p++;
                    //}
                }
            }  
           /* echo '<pre>';
            print_r($modelJobOrderStatusHistory);
           exit;  */    
            if ($valid) {	
                
               
                // if ((int) @$_POST['JobOrder']['file_id'] > 0) {
                //     $file_id = (int) @$_POST['JobOrder']['file_id'];
                //     $modelMaster = $modelMaster->findByPk($file_id);
                // } else {
                //     $modelMaster->customer_id = 0;
                //     $modelMaster->current_process_status = "O";
                //     $modelMaster->crm_user_id = Yii::app()->user->id;
                //     $modelMaster->created_by = Yii::app()->user->id;
                //     $modelMaster->created_datetime = date('Y-m-d h:i:s');
                //     $modelMaster->file_title = "";
                //     $modelMaster->lead_owner_id =  $_POST['JobOrder']['lead_owner_id'];
                //     $modelMaster->save(false);
                // }	
                // if((int) $_POST['JobOrder']['file_id']==0)
                // {
                //     $model->file_id = $modelMaster->id;
                // }else{
                //     $model->file_id = $_POST['JobOrder']['file_id'];
                // }

                $model->save();
                //echo $model->job_priority;exit;
                //JobOrderAgentDetails::model()->deleteAll('job_order_id=:refer_id', array(':refer_id' => $model->id));
                
                $total_planned_weight   =   0;
                $total_planned_volume   =   0;
                $total_planned_cost     =   0;
                $total_actual_weight    =   0;
                $total_actual_volume    =   0;
                $total_actual_cost      =   0;
                $total_planned_selling_price      =   0;
                if(!empty($modelJobOrderAgentDetails)){
                    $agent_details_count=0;
                    $status_delivered_count=0;
                    foreach ($modelJobOrderAgentDetails as $eachModel) {
                        $eachModel->job_order_id = $model->id;
                        
                        /*if($eachModel->status>=5){//if delivered or completed
                            $status_delivered_count++;
                        }*/
                        $eachModel->save(false);
                        
                        /*$total_planned_weight+=$eachModel->planned_weight;
                        $total_planned_volume+=$eachModel->planned_volume;
                        $total_planned_cost+=$eachModel->planned_cost;
                        $total_planned_selling_price+=$eachModel->planned_selling_price;*/
                        $total_planned_weight += floatval($eachModel->planned_weight);
                        $total_planned_volume += floatval($eachModel->planned_volume);
                        $total_planned_cost += floatval($eachModel->planned_cost);
                        $total_planned_selling_price += floatval($eachModel->planned_selling_price);
                        
                        if(!empty($eachModel->actual_weight)){
                            $total_actual_weight+=$eachModel->actual_weight;
                        }
                        if(!empty($eachModel->actual_volume)){
                            $total_actual_volume+=$eachModel->actual_volume;
                        }
                        if(!empty($eachModel->actual_cost)){
                            $total_actual_cost+=$eachModel->actual_cost;
                        }
                        
                        $agent_details_count++;
                        
                    }
                }
                
                //echo "hi".$status_delivered_count;
                
                /*if($status_delivered_count==0){
                   $job_order_status = 'O';
                }
                elseif($status_delivered_count==$agent_details_count){
                    $job_order_status = "D";
                }
                elseif($status_delivered_count < $agent_details_count){
                    $job_order_status = "PD";
                }*/
                
                $job_order_status = $_POST['JobOrder']['job_order_status'];
                
                $model->updateByPk($model->id, array('total_planned_weight' => $total_planned_weight,'total_planned_volume' => $total_planned_volume,'total_planned_cost' => $total_planned_cost,'total_actual_weight' => $total_actual_weight,'total_actual_volume' => $total_actual_volume,'total_actual_cost' => $total_actual_cost,'job_order_status'=>$job_order_status,'selling_price'=>$total_planned_selling_price));
                
                if((int) @$_POST['JobOrder']['quote_id'] > 0){
                    Quotation::model()->updateByPk((int) @$_POST['JobOrder']['quote_id'],array('job_order_id' => $model->id)); 
                }
               
                // if(!empty($modelJobOrderStatusHistory)){
                //     foreach ($modelJobOrderStatusHistory as $eachModelHistory) {
                        
                //         $eachModelHistory->job_order_id = $model->id;
                //         $eachModelHistory->save(false);
                //     }
                // }
                
                
                // if (isset($_POST['Icon']['file']) && $_POST['Icon']['file'] != '') {
                //     $doc_test = Document::model()->find(array('condition' => 'file_id=' . $model->file_id . ' AND document_name="' . $_POST['Icon']['file'] . '"'));
                //     if (empty($doc_test)) {
                //         $modelDocument = new Document;
                //         $modelDocument->uploaded_from = "JO";
                //         $modelDocument->file_id = $model->file_id;
                //         $modelDocument->created_by = Yii::app()->user->id;
                //         $modelDocument->created_datetime = date('Y-m-d h:i:s');
                //         $modelDocument->document_name = $_POST['Icon']['file'];
                //         $modelDocument->save(false);
                //     }
                // }
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'JOB_ORDERS',
                    Yii::app()->user->id,
                    $JobOrder_type,
                    " with JobOrder No - {$model->id}  "
                );
                // end audit log 
                
                echo CJSON::encode( array('status' => 'success' ));

                
                            
            }
            else {                    
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if ($modelJobOrderAgentDetails[0]->shipper_id > 0)
                    $error2 = json_decode(CActiveForm::validateTabular($modelJobOrderAgentDetails, '', false), true);
                else
                    $error2[] = "Please select a shipper";
                $error = CJSON::encode(array_merge_recursive($error1, $error2,$other));
                if ($error != '[]')
                    echo $error;
            }              
        }
    }



    public function actionDeleteAgentDetails(){
        $agent_details_id          =   (int) Yii::app()->request->getParam('agent_id');
        $modelPurchaseInvoiceItem  = new PurchasingInvoiceItem();
        $count_purchase            = (int) $modelPurchaseInvoiceItem->count(array('condition'=>'job_order_agent_id='.$agent_details_id));
        $modelInvoiceItem          = new InvoiceItem();
        $count_invoice             = (int) $modelInvoiceItem->count(array('condition'=>'order_item_id='.$agent_details_id));
        
        if($count_purchase==0 && $count_invoice==0){
            $modelAgentDetails = new JobOrderAgentDetails();
            $modelAgentDetails->deleteByPk($agent_details_id);
            $jsonData['status'] = "success";
        }
        else{
            if($count_invoice > 0 && $count_purchase > 0){
                $msg="Error while delete. Details used in both Purchase Invoice and Invoice";
            }
            elseif($count_purchase > 0){
                $msg="Error while delete. Details used in Purchase Invoice";
            }
            elseif($count_invoice > 0){
                $msg="Error while delete. Details used in Invoice";
            }
            
            $jsonData['message']   = $msg;
            $jsonData['status']    = 'failed';
        }
        echo json_encode($jsonData);
   }




}