<?php

class MasjobordercouriertypeController extends Controller
{
	public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','DeleteMasJobOrderCourierType','SaveJobOrderCourierType','GetList'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
         }
    
        public function filters()
        {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
        }
        
        public function actionIndex() {
            $this->render('index');
        }
         
        public function actionGetList()
         {
 
                $model=new MasJobOrderCourierType();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'courier_type',
                  
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition ="  (courier_type LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'courier_type'));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                
                foreach ($model as $row)
                {
                    $div = '';
                       
                    
                    //if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_job_order_status_edit"])){
                        $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'MasJobOrderCourierType/create&id='.$row['id'].'\',\'Edit Item\',\'lg\')"><i class="fa fa-pencil"></i></button>';
                    //}
                    //if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_job_order_status_delete"])){
                    //    $div .=  '<a href ="#" class="btn btn-danger btn-xs" onclick="deleteMasJobOrderCourierType('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
                    //}
                        $rowData[]=array($m,$row['courier_type'],'<div class="btn-wrap text-center">'.$div.'</div>',
                          array('id' => $row['id'],'code'=>$row['courier_type'], 'status' => $row->isActive));
   
                
                    $m++;
                    
                }

                $data['data'] = $rowData;
                echo json_encode($data);
    }
    public function actionCreate()
    {
        $model=new MasJobOrderCourierType(); 
        $id=(int) Yii::app()->request->getParam('id');
        if($id>0){
            $model=$model->findByPk($id);
        }
         Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('create', array('model' => $model,'from' => $from), false, true);
    }
    public function actionSaveJobOrderCourierType()
        {
            $model = new MasJobOrderCourierType();
            if (isset($_POST['MasJobOrderCourierType']))
            {   
    		
    		if ((int) @$_POST['MasJobOrderCourierType']['id'] > 0)
                {   
                    $id= (int) @$_POST['MasJobOrderCourierType']['id'];
                    $model=$model->findByPk($id); 
                    $audit_type = 'UPDATED';
                    $edit_flag=1;
                }else{
                    $audit_type = 'CREATED';
                }
                $model->attributes=$_POST['MasJobOrderCourierType'];
                $model->courier_type=trim($_POST['MasJobOrderCourierType']['courier_type']);
                if($model->save())
                {
                   
                        // inserting to audit log
                        AuditLog::saveAuditLogs(
                            'MasJobOrderCourierType_MASTER',
                            Yii::app()->user->id,
                            $audit_type
                        );
                        // end audit log
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['MasJobOrderCourierType_form'];
                        $jsonData['from'] = $_POST['from'];
                        $jsonData['id'] = $model->id;
	                echo CJSON::encode($jsonData);
                       // $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('index'));
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
               // $this->render('bank_form', array('model' => $model), false, true);

            }
        }
}