<?php

class JoborderController extends Controller
{
	 public $layout = 'layout';
    public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                        'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover'),
                        'users' => array('*'),
                ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                        'actions' => array('Index','GetJobOrderList','Create','SaveJobOrder','GetStatusHistoryList','PrintJobOrderReportPDF','AddToFavourite','Documentupload','DeleteDocument', 
                        'UploadCustomerDocuments', 'GetDocumentList','Downloaddocument','GetOtherCalculator','ChangeJobAgentStatus','UpdateJobAgentStatus','Screenshot','Create_joborder','SaveScreenshot','GetScreenshotHistoryList',
                        'SendScreenshotMail','GetTracking','GetShipment','UpdateAPIStatus','UpdateBulkTracking','SendeMailToCustomer','LoadCustomersEmail','SendMailToCustomerSubmit','GetJobOrderDetails','UpdateDHLBulkTracking','GetJobOrderLastUpdatedStatus'
                        ,'DeleteAgentDetails','GetTermsnCondtn'),
                        'expression' => '$user->isMember()',

                ),

                array('deny', // deny all users

                                'users' => array('*'),
                ),
            );
    }
    public function filters() {
            return array('accessControl'); // perform access control for CRUD operations
    }

    public function actionIndex()
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        
        $this->render('index');
    }


    public function actionDownloaddocument()
    {
        $id = (int) Yii::app()->request->getParam('id'); 
        $arr_employee_doc = Document::model()->findByPk($id);
        $file = $arr_employee_doc->document_name;
        $arr_doc_val = explode(',', $arr_employee_doc->document_name);
        if (count($arr_doc_val) > 1) {
            $zip = new ZipArchive();
            $zip_file_path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $arr_employee_doc->document_name . "_" . date('d-m-Y') . ".zip";
            if ($zip->open($zip_file_path, 1 ? ZIPARCHIVE::OVERWRITE : ZIPARCHIVE::CREATE) === TRUE) {
                for ($i = 0; $i < count($arr_doc_val); $i++) {
                    $path = "images/attachment/" . $arr_doc_val[$i];
                    // Add the files to the .zip file
                    $zip->addFile($path, $arr_doc_val[$i]);
                }
                // Closing the zip file
                $zip->close();
            }
            header("Content-type:application/zip"); //for pdf file
            //if you want to read text file using text/plain header
            header('Content-Disposition: attachment; filename="' . basename($zip_file_path) . '"');
            header('Content-Length: ' . filesize($zip_file_path));
            readfile($zip_file_path);
            Yii::app()->end();
        } else {
            $file = $arr_employee_doc->document_name;
            //$file="Purchase Order-20210606-050221.pdf";
            $path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $file;
            header("Content-type:application/octet-stream"); //for txt file
            header("Content-Type: application/download");
            //header('Content-Type:text/plain; charset=ISO-8859-15');
            //if you want to read text file using text/plain header
            header('Content-Disposition: attachment; filename="' . basename($path) . '"');
            header('Content-Length: ' . filesize($path));
            readfile($path);
            Yii::app()->end();
        }
        
       /* $path = Yii::getPathOfAlias('webroot') . "/uploads/quotationpdf/" . $file;
      
        header("Content-type:application/octet-stream"); //for txt file
        header("Content-Type: application/download");
        header('Content-Disposition: attachment; filename="' . basename($path) . '"');
        header('Content-Length: ' . filesize($path));
        flush(); // Flush system output buffer
        readfile($path);
        Yii::app()->end();*/
        


        
    }


    /*
     * function to getlist for JobOrder datatable
     * modified by jisha on 17-9-18. 
     */
    public function actionGetJobOrderList()
    {
            $model=new JobOrder();
            $draw   = $_POST['draw'];
            $offset = $_POST['start'];
            $limit  = $_POST['length'];
            
            
            $frm  = $_POST['frm'];
            $columns = array(
                            // datatable column index  => database column name

                            0=>'file_id',
                            1=>'job_order_id',
                            2=>'job_date',
                            3=>'customer_name',
                            4=>'origin',
                            5=>'consignee_name',
                            6=>'destination',
                            7=>'agent',                           
                            8=>'awb_no',
                            9=>'transport_type_name',
                            10=>'status_description',
                            11=>'status_last_updated_date',                           
            );

            $filterColumn = $columns[$_POST['order'][0]['column']];
            $filterOrder  = $_POST['order'][0]['dir'];
            
            if($_POST['order'][0]['column']==0){
                $filterColumn='job_order_id';
                $filterOrder='DESC';
            }
            $orderBy      = $filterColumn." ".$filterOrder;
            
            
            
            //$condition="1=1";
            $condition="(job_order_status!='CN' AND job_order_status!='I'";
            if(isset($_POST['filter_job_order_status']) && $_POST['filter_job_order_status']!="")
            {
            	$condition =" (job_order_status='".$_POST['filter_job_order_status']."'";
            }
            
            
            if(((int) Yii::app()->user->havePermissionOn["job_order_view_all"]) == 0){
                $condition.= ' AND lead_owner_id= "'.Yii::app()->user->id.'"';
            }
            
            
           /* else{
                $condition  ="job_order_status IN('O','PD')";
            }*/
            if(isset($_POST['filter_job_order_transport_type']) && $_POST['filter_job_order_transport_type']!="")
            {
            	$condition.=" AND transport_type='".$_POST['filter_job_order_transport_type']."'";
            }
            if(isset($_POST['filter_job_order_priority']) && $_POST['filter_job_order_priority']!="")
            {
            	$condition.=" AND job_priority='".$_POST['filter_job_order_priority']."'";
            }
            if(isset($_POST['filter_job_order_no']) && $_POST['filter_job_order_no']!="")
            {
            	$condition.=" AND job_order_id LIKE '%".$_POST['filter_job_order_no']."%'";
            }
            if(isset($_POST['filter_job_order_shipper']) && $_POST['filter_job_order_shipper']!="")
            {
            	$condition.=" AND customer_id='".$_POST['filter_job_order_shipper']."'";
            }
            if(isset($_POST['filter_job_order_agent']) && $_POST['filter_job_order_agent']!="")
            {
            	$condition.=" AND FIND_IN_SET(".$_POST['filter_job_order_agent'].",agent_ids)";
            }
            if(isset($_POST['filter_job_order_awb_no']) && $_POST['filter_job_order_awb_no']!="")
            {
            	$condition.=" AND awb_no LIKE'%".$_POST['filter_job_order_awb_no']."%'";
            }
            if(isset($_POST['filter_job_order_last_updated_status']) && $_POST['filter_job_order_last_updated_status']!="")
            {
            	$condition.=" AND current_status='".$_POST['filter_job_order_status']."'";
            }
            
            if(isset($_POST['filter_job_order_date']) && $_POST['filter_job_order_date']!="")
            {
            	
            	
            	
            	$filter_job_date       = str_replace('/', '-', $_POST['filter_job_order_date']);
                $filter_job_date       = date("Y-m-d", strtotime($filter_job_date));
                $condition.=" AND DATE(job_date) LIKE'%".$filter_job_date."%'";   
                //$condition.= ' AND DATE(job_date)="'.$filter_job_date.'"';
            	
            	
            }
            
            //echo $condition;
            
          
            if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
            {
               
                $searchString = $_POST['search']['value'];
                $condition=" (job_order_id LIKE '%".$searchString."%' OR customer_name LIKE '%".$searchString."%' OR file_id LIKE '%".$searchString."%' OR origin LIKE '%".$searchString."%'  OR destination LIKE '%".$searchString."%' OR transport_type LIKE '%".$searchString."%'";
                
                if(((int) Yii::app()->user->havePermissionOn["job_order_view_all"]) == 0){
                    $condition.= ' AND lead_owner_id= "'.Yii::app()->user->id.'"';
                }
                
            }
             $condition.= ') OR ( accounts_manager_id="'.Yii::app()->user->id.'")';
            
            /*$SQL ="CREATE OR REPLACE VIEW `view_job_order_list`  AS  select `JO`.`id` AS `job_order_id`,`JO`.`customer_id` AS `customer_id`,
            `JO`.`file_id` AS `file_id`,`JO`.`job_priority` AS `job_priority`,`JO`.`job_date` AS `job_date`,`JO`.`origin` AS `origin`,
            `JO`.`destination` AS `destination`,`JO`.`consignee_id` AS `consignee_name`,`JO`.`shipper_id` AS `shipper_name`,
            `JO`.`lead_owner_id` AS `lead_owner_id`,`JO`.`transport_type` AS `transport_type`,`TR`.`transport_type` AS `transport_type_name`,
            `JO`.`selling_price` AS `selling_price`,`customer`.`customer_name` AS `customer_name`,`customer`.`customer_emirates_name` AS `emirates_id`,`JO`.job_awb_no AS awb_no,
            `JO`.`job_order_status` AS `job_order_status`,`JO`.consignee_id AS consignee_id,
            (select group_concat(distinct `vendor`.`vendor_name` separator ',') from (`erp_job_order_agent_details` `agent` join `erp_vendor` `vendor` on((`vendor`.`id` = `agent`.`shipper_id`))) where (`agent`.`job_order_id` = `JO`.`id`)) AS `agent`,
             (select group_concat(`agentids`.`shipper_id` separator ',') from `erp_job_order_agent_details` `agentids` where (`agentids`.`job_order_id` = `JO`.`id`)) AS `agent_ids`,
            (select max(date_format(concat(`ST`.`status_date`,'',`ST`.`status_time`),'%m/%d/%Y %h:%i:%s')) from `erp_job_order_status_history` `ST` where (`ST`.`job_order_id` = `JO`.`id`)) AS `status_last_updated_date`,
            (select `CST`.`status_description` from `erp_job_order_status_history` `CST` where (`CST`.`job_order_id` = `JO`.`id`) order by CST.status_date DESC,CST.status_time DESC  limit 0,1) AS `status_description`,
            (select `CST`.`current_status` from `erp_job_order_status_history` `CST` where (`CST`.`job_order_id` = `JO`.`id`) order by CASE WHEN status_updation='A' THEN `CST`.`id` WHEN status_updation='M' THEN `CST`.`id` END DESC  limit 0,1) AS `current_status` 
            FROM `erp_job_order` `JO` left join `erp_mas_transport_type` `TR` on `JO`.`transport_type` = `TR`.`id` 
            inner join `erp_customer` `customer` on `JO`.`customer_id` = `customer`.`id`";
            Yii::app()->db->createCommand($SQL)->execute();*/
            
            /*$SQL ="CREATE OR REPLACE VIEW `view_job_order_list`  AS  select `JO`.`id` AS `job_order_id`,`JO`.`customer_id` AS `customer_id`,
            `JO`.`file_id` AS `file_id`,`JO`.`job_priority` AS `job_priority`,`JO`.`job_date` AS `job_date`,`JO`.`origin` AS `origin`,
            `JO`.`destination` AS `destination`,`JO`.`consignee_id` AS `consignee_name`,`JO`.`shipper_id` AS `shipper_name`,
            `JO`.`lead_owner_id` AS `lead_owner_id`,`JO`.`transport_type` AS `transport_type`,`TR`.`transport_type` AS `transport_type_name`,
            `JO`.`selling_price` AS `selling_price`,`customer`.`customer_name` AS `customer_name`,`customer`.`customer_emirates_name` AS `emirates_id`,`JO`.job_awb_no AS awb_no,
            `JO`.`job_order_status` AS `job_order_status`,`JO`.consignee_id AS consignee_id,
            (select group_concat(distinct `vendor`.`vendor_name` separator ',') from (`erp_job_order_agent_details` `agent` join `erp_vendor` `vendor` on((`vendor`.`id` = `agent`.`shipper_id`))) where (`agent`.`job_order_id` = `JO`.`id`)) AS `agent`,
             (select group_concat(`agentids`.`shipper_id` separator ',') from `erp_job_order_agent_details` `agentids` where (`agentids`.`job_order_id` = `JO`.`id`)) AS `agent_ids`
            
            FROM `erp_job_order` `JO` left join `erp_mas_transport_type` `TR` on `JO`.`transport_type` = `TR`.`id` 
            inner join `erp_customer` `customer` on `JO`.`customer_id` = `customer`.`id`";
            Yii::app()->db->createCommand($SQL)->execute();*/
            
            $SQL1="SELECT * FROM view_job_order_list WHERE $condition ORDER BY ".$orderBy." LIMIT $offset,$limit";
            //echo $SQL1;
            $model = Yii::app()->db->createCommand($SQL1)->queryAll();
            
            //print_r($model);
            
            $SQL_CNT = "SELECT COUNT(*) as clients FROM view_job_order_list WHERE $condition";
            $count = Yii::app()->db->createCommand($SQL_CNT)->queryScalar();
            
            //$count = $model->with('file','leadowner','customer','transporttype')->count(array('condition'=>$condition));
            //$model = $model->with('file','leadowner','customer','transporttype')->findAll(array('condition'=>$condition,'order' => 't.id DESC','limit'=>$limit,'offset'=>$offset));

            $recordsTotal = $count;
            $recordsFiltered = $count;
            $data['draw'] = $draw;
            $data['recordsTotal'] = $recordsTotal;
            $data['recordsFiltered'] = $recordsFiltered;
            $rowData=array();
            $m=1;
            foreach ($model as $j=>$row)
            {
                $SQL_JOA = "SELECT COUNT(id) FROM erp_job_order_agent_details WHERE activity_type=0 AND job_order_id=".(int) $row['job_order_id'];
                $count_agent_type = (int) Yii::app()->db->createCommand($SQL_JOA)->queryScalar();
                
                
                $div = '';
                
                $modelJobOrderAgent = new JobOrderAgentDetails();
                $destination='';
                if((int)$row['destination']>0)
                {
                $destination=MasCountry::model()->findByPk($row['destination'])->country_name;
                }
                $origin='';
                if((int)$row['origin']>0)
                {
                $origin=MasCountry::model()->findByPk($row['origin'])->country_name;
                }
                
                switch($row['job_order_status']){
                    case 'PD':
                        $row_job_order_status="Partially Delivered";
                        break;
                    case 'D':
                        $row_job_order_status="Delivered";
                        break;
                    case 'C':
                        $row_job_order_status="Completed";
                        break;
                    case 'I':
                        $row_job_order_status="Invoiced";
                        break;
                    case 'CN':
                        $row_job_order_status="Cancel";
                        break;
                    default:
                        $row_job_order_status="Open";
                        break;
                }
                
                  $date_today = date('Ymd');
                  $job_today= $row['job_date'];
                  $current_today = date('Y-m-d');
                  $modelStatusHistory = new JobOrderStatusHistory();
                 $count_request_exist = (int) $modelStatusHistory->count(array('condition' =>'job_order_id="'.$row['job_order_id'].'"AND current_status>0 AND  t.status_date ="' . $date_today . '"'));
            
               if($count_request_exist==0 &&  $job_today== $current_today){
               
                  $status_div = ' <a href="#" class="jobOrderStatusOver" id="locationhelper_'.$m.'_'.$row['job_order_id'].'"><i class="fa fa-info-circle"style="color:red"><div class="triangle-right"></div></i></a>';      
                }
                else if($count_request_exist >0 ||  $job_today== $current_today || $row['job_order_status']=='C'){
                 $status_div = ' <a href="#" class="jobOrderStatusOver" id="locationhelper_'.$m.'_'.$row['job_order_id'].'"><i class="fa fa-info-circle"style="color:yellow"><div class="triangle-right"></div></i></a>';      
                }
                else {
                     $status_div = ' <a href="#" class="jobOrderStatusOver" id="locationhelper_'.$m.'_'.$row['job_order_id'].'"><i class="fa fa-info-circle"><div class="triangle-right"></div></i></a>';      
                }
                //JobOrder::model()->updateActualCost($row['job_order_id']);
                //$rowData[]=array($m,$row['job_order_id'],date("d/m/Y",strtotime($row['job_date'])),$row['customer_name'],$origin,$row['consignee_id'],$destination,$row['agent'],$row['awb_no'],$row['transport_type_name'],$row_job_order_status,'<div title="'.$row['status_description'].'">'.$row['status_description'].'</div>',($row['status_last_updated_date']!="0000-00-00 00:00:00")?$row['status_last_updated_date']:"",$row['job_order_status'],$row['customer_id'],$row['file_id'],$row['job_priority']);
                $rowData[]=array($m.$status_div,$row['job_order_id'],date("d/m/Y",strtotime($row['job_date'])),$row['customer_name'],$origin,$row['consignee_id'],$destination,$row['agent'],$row['awb_no'],$row['transport_type_name'],$row_job_order_status,$row['job_order_status'],$row['customer_id'],$row['file_id'],$row['job_priority'],$count_agent_type);
                $m++;
            }
            $data['data'] = $rowData;

            echo json_encode($data);

    }
    /*
     * function to create JobOrder
     * modified by jisha on 17-9-18. 
     */
    public function actionCreate()
    {
        $model              =   new JobOrder();
        $modelQuotes        =   new Quotation();
        
        $id         = (int) Yii::app()->request->getParam('id');
        //$forwarderid         = (int) Yii::app()->request->getParam('forwarderid');
          $forwarderid         =  Yii::app()->request->getParam('forwarderid');
        $file_id    = (int) Yii::app()->request->getParam('file_id');
        $quote_id   = (int) Yii::app()->request->getParam('quote_id');
        $frm        = Yii::app()->request->getParam('frm');
        //echo $id;
        
        $model->file_id     = $file_id;
        $model->quote_id    = $quote_id;
        
        if($quote_id > 0){
            
            $modelQuotes = $modelQuotes->findByPk($quote_id);
            $model->attributes = $modelQuotes;
            $model->customer_id = $modelQuotes->customer_id;
            $model->lead_owner_id = $modelQuotes->lead_owner_id;
            $model->shipper_id = $modelQuotes->shipper_id;
            $model->consignee_id = $modelQuotes->consignee_id;
            $model->origin = $modelQuotes->origin_id;
            $model->destination = $modelQuotes->destination_id;
            $model->currency_id = $modelQuotes->currency_id;
            $model->exchange_rate = $modelQuotes->exchange_rate;
            $model->lead_owner_id = $modelQuotes->lead_owner_id;
            $model->weight = $modelQuotes->weight;    
            $model->volume = $modelQuotes->volume;   
            $model->booking_reference = $modelQuotes->booking_reference;                     
            $model->transport_type = $modelQuotes->transport_type;                     
            $model->customer_reference_no = $modelQuotes->customer_reference_no;                     
            $model->payment_terms_id = $modelQuotes->payment_terms_id;                     
            $model->selling_price = $modelQuotes->selling_price;         
            $model->contact_ids = $modelQuotes->contact_ids;
            
             
             if($forwarderid!=''){
                //$arr_forwarderid = explode(",", $forwarderid);
                //$forwarderid=implode(",",$arr_forwarderid);
                //$condition_forwarder = "quotation_id= '".$quote_id."' AND forwarder_id = '".$forwarderid."'";
                 $condition_forwarder = "quotation_id= '".$quote_id."' AND forwarder_id IN(".$forwarderid.")";
            }else if($forwarderid==''){

               $condition_forwarder = "quotation_id= '".$quote_id."'";
            }
           
            
           /* $str_forwarder_id='';
            for($arr_forwarderid as $agent_id){
                if($str_forwarder_id==''){
                $str_forwarder_id=
            }*/
            


            $modelQuotesItems = QuotationItems::model()->findAll(array('condition' =>  $condition_forwarder,'order'=>'t.id asc'));
            if (!empty($modelQuotesItems)) {
                $k=0;
                foreach ($modelQuotesItems as $eachItem) {
                    $modelAgentDetails[$k] = new JobOrderAgentDetails();
                    $modelAgentDetails[$k]->attributes = $eachItem->attributes;
                    $modelAgentDetails[$k]->shipper_id = $eachItem->forwarder_id;
                    $k++;
                }
            }
            
            /*echo '<pre>';
            print_r($modelAgentDetails);*/
        }
        else{
            $modelAgentDetails  =   array(new JobOrderAgentDetails);
        }
        
        
        if($id>0)
        {
            $model = $model->findByPk($id);
            
            $modelAgentDetails = JobOrderAgentDetails::model()->findAll(array('condition'=>'job_order_id="'.$id.'"','order' => 'id ASC')); 
            if(empty($modelAgentDetails)){
                     $modelAgentDetails = array(new JobOrderAgentDetails);
            }
            
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false,'jquery-2.1.4.min.js' => false);
      // Yii::app()->clientScript->scriptMap = array('*jquery.js' => false,'*jquery-2.1.4.min.js' => false);
        $this->render('create', array('model' => $model,'modelAgentDetails'=>$modelAgentDetails,'modelQuotes'=>$modelQuotes,'quote_id'=>$quote_id,'frm'=>$frm));
    }
    


public function actionCreate_joborder()
    {
        $model              =   new QuotationItems();

        $id         = (int) Yii::app()->request->getParam('id');
        $file_id    = (int) Yii::app()->request->getParam('file_id');
        $quote_id   = (int) Yii::app()->request->getParam('quote_id');
        $frm        = Yii::app()->request->getParam('frm');
          $condition ="quotation_id= '".$quote_id."' GROUP BY forwarder_id";
       $modelQuotesItems = QuotationItems::model()->findAll(array('condition' =>  $condition,'order'=>'t.id asc'));
       foreach ($modelQuotesItems as $eachItem) {
        $forwarder_id=$eachItem->forwarder_id;
        $forwarder_ids []= $forwarder_id;
       }
        $forwarderids = implode(', ',$forwarder_ids);

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false,'jquery-2.1.4.min.js' => false);
      // Yii::app()->clientScript->scriptMap = array('*jquery.js' => false,'*jquery-2.1.4.min.js' => false);
        $this->render('create_joborder', array('model' => $model,'quote_id'=>$quote_id,'forwarderids'=>$forwarderids,'id'=>$id,'file_id'=>$file_id));
    }



     public function actionSaveJobOrder() {
        $valid=TRUE;
        $model = new JobOrder();
        $modelMaster=new MasterFile();
        $other = array();
        //$modelJobOrderStatusHistory = array(new JobOrderStatusHistory());
        if (isset($_POST['JobOrder'])) {         
            $scenario='';
            if ((int) @$_POST['JobOrder']['id'] > 0) {
                    $model->id = (int) $_POST['JobOrder']['id'];
                    $model->updated_by = Yii::app()->user->id;
                    $model->updated_date_time =date('Y-m-d h:i:s'); 
                    $model = $model->findByPK($model->id);
                    $model->scenario = 'update';
                    $scenario='update';
                    $JobOrder_type = 'UPDATED';
                    
                    
                    /***************** code added by mereena on 24/06/2022 ***********/
                    if($model->job_order_status=='I'){
                        $other[]="Job order already converted to invoice. Please refresh page";
                        $valid=false;
                    }
                    
                    /****************************** End **************************/

            } else {
                    $model->created_by = Yii::app()->user->id;
                    $model->created_date_time =date('Y-m-d h:i:s');
                    $model->scenario = 'add';
                    $scenario='add';
                    $JobOrder_type = 'CREATED';
            }
            $model->attributes = $_POST['JobOrder'];
            // $model->job_priority=$_POST['JobOrder']['job_priority'];

            $model->selling_price=str_replace(',', '', $_POST['JobOrder']['selling_price']);;
            $model->job_order_remarks=$_POST['JobOrder']['job_order_remarks'];
            
            if(!empty($_POST['JobOrder']['contact_ids'])){
                $model->contact_ids=implode(",", $_POST['JobOrder']['contact_ids']);
            }
            
            $model->terms_and_conditions = $_POST['terms_and_conditions'];
            
            
            if($_POST['JobOrder']['job_date']!=''){
                $model->job_date = str_replace('/', '-', $_POST['JobOrder']['job_date']);
                $model->job_date= date("Y-m-d", strtotime($model->job_date));
            }
            $valid = $valid && $model->validate();
            
            $p=0;
            if (is_array($_POST['JobOrderAgentDetails'])) {
                $prod_id=0;
                
                foreach ($_POST['JobOrderAgentDetails'] as $i => $item) {                    
                    
                    //if ($item['shipper_id'] > 0) {
                        
                         if ($item['id'] > 0) {
                            $modelJobOrderAgentDetails[$p] = JobOrderAgentDetails::model()->findByPK($item['id']); 
                        } else {
                            $modelJobOrderAgentDetails[$p] = new JobOrderAgentDetails; 
                        }
                        
                        
                            if($modelJobOrderAgentDetails[$p]->status!=$item['status'] && $item['id']>0){
                                
                                $existing_status    =   MasJobOrderStatus::getStatusOfJobOrder($modelJobOrderAgentDetails[$p]->status);
                                $new_status         =   MasJobOrderStatus::getStatusOfJobOrder($item['status']);
                                
                                $status_description     =   "Status ".$existing_status." changed to ".$new_status;
                                
                                $modelJobOrderStatusHistory[$c]                         =   new JobOrderStatusHistory; 
                                $modelJobOrderStatusHistory[$c]->job_order_agent_id     =   $item['id'];
                                $modelJobOrderStatusHistory[$c]->current_status         =   $item['status'];
                                $modelJobOrderStatusHistory[$c]->status_description         =   $new_status;
                                $modelJobOrderStatusHistory[$c]->updated_by             =   Yii::app()->user->id;
                                $modelJobOrderStatusHistory[$c]->updated_date_time      =   date('Y-m-d h:i:s');
                                $modelJobOrderStatusHistory[$c]->status_updation        =   "M";
                                $modelJobOrderStatusHistory[$c]->status_date            =   date('Ymd');
                                $modelJobOrderStatusHistory[$c]->status_time            =   date('his');
                                $modelJobOrderStatusHistory[$c]->updated_date_time      =   date('Y-m-d h:i:s');
                                $c++;
                            }
                            
                            $modelJobOrderAgentDetails[$p]->attributes              =   $_POST['JobOrderAgentDetails'][$i];
                            $modelJobOrderAgentDetails[$p]->shipper_id              =   $item['shipper_id'];
                            $modelJobOrderAgentDetails[$p]->awb_no                  =   $item['awb_no'];
                            $modelJobOrderAgentDetails[$p]->planned_weight          =   $item['planned_weight'];
                            $modelJobOrderAgentDetails[$p]->planned_volume          =   $item['planned_volume'];
                            $modelJobOrderAgentDetails[$p]->planned_cost            =   $item['planned_cost'];
                            $modelJobOrderAgentDetails[$p]->planned_selling_price   =   $item['planned_selling_price'];
                            $modelJobOrderAgentDetails[$p]->actual_weight           =   $item['actual_weight'];
                            $modelJobOrderAgentDetails[$p]->actual_volume           =   $item['actual_volume'];
                            $modelJobOrderAgentDetails[$p]->actual_cost             =   $item['actual_cost'];
                            $modelJobOrderAgentDetails[$p]->status                  =   $item['status'];
                            $modelJobOrderAgentDetails[$p]->notes                   =   $item['notes'];
                            
                            
                            $valid = $modelJobOrderAgentDetails[$p]->validate() && $valid;
                            $p++;
                    //}
                }
            }  
           /* echo '<pre>';
            print_r($modelJobOrderStatusHistory);
           exit;  */    
            if ($valid) {	
                
               
                if ((int) @$_POST['JobOrder']['file_id'] > 0) {
                    $file_id = (int) @$_POST['JobOrder']['file_id'];
                    $modelMaster = $modelMaster->findByPk($file_id);
                } else {
                    $modelMaster->customer_id = 0;
                    $modelMaster->current_process_status = "O";
                    $modelMaster->crm_user_id = Yii::app()->user->id;
                    $modelMaster->created_by = Yii::app()->user->id;
                    $modelMaster->created_datetime = date('Y-m-d h:i:s');
                    $modelMaster->file_title = "";
                    $modelMaster->lead_owner_id =  $_POST['JobOrder']['lead_owner_id'];
                    $modelMaster->save(false);
                }	
                if((int) $_POST['JobOrder']['file_id']==0)
                {
                    $model->file_id = $modelMaster->id;
                }else{
                    $model->file_id = $_POST['JobOrder']['file_id'];
                }

                $model->save();
                //echo $model->job_priority;exit;
                //JobOrderAgentDetails::model()->deleteAll('job_order_id=:refer_id', array(':refer_id' => $model->id));
                
                $total_planned_weight   =   0;
                $total_planned_volume   =   0;
                $total_planned_cost     =   0;
                $total_actual_weight    =   0;
                $total_actual_volume    =   0;
                $total_actual_cost      =   0;
                $total_planned_selling_price      =   0;
                if(!empty($modelJobOrderAgentDetails)){
                    $agent_details_count=0;
                    $status_delivered_count=0;
                    foreach ($modelJobOrderAgentDetails as $eachModel) {
                        $eachModel->job_order_id = $model->id;
                        
                        /*if($eachModel->status>=5){//if delivered or completed
                            $status_delivered_count++;
                        }*/
                        $eachModel->save(false);
                        
                        /*$total_planned_weight+=$eachModel->planned_weight;
                        $total_planned_volume+=$eachModel->planned_volume;
                        $total_planned_cost+=$eachModel->planned_cost;
                        $total_planned_selling_price+=$eachModel->planned_selling_price;*/
                        $total_planned_weight += floatval($eachModel->planned_weight);
                        $total_planned_volume += floatval($eachModel->planned_volume);
                        $total_planned_cost += floatval($eachModel->planned_cost);
                        $total_planned_selling_price += floatval($eachModel->planned_selling_price);
                        
                        if(!empty($eachModel->actual_weight)){
                            $total_actual_weight+=$eachModel->actual_weight;
                        }
                        if(!empty($eachModel->actual_volume)){
                            $total_actual_volume+=$eachModel->actual_volume;
                        }
                        if(!empty($eachModel->actual_cost)){
                            $total_actual_cost+=$eachModel->actual_cost;
                        }
                        
                        $agent_details_count++;
                        
                    }
                }
                
                //echo "hi".$status_delivered_count;
                
                /*if($status_delivered_count==0){
                   $job_order_status = 'O';
                }
                elseif($status_delivered_count==$agent_details_count){
                    $job_order_status = "D";
                }
                elseif($status_delivered_count < $agent_details_count){
                    $job_order_status = "PD";
                }*/
                
                $job_order_status = $_POST['JobOrder']['job_order_status'];
                
                $model->updateByPk($model->id, array('total_planned_weight' => $total_planned_weight,'total_planned_volume' => $total_planned_volume,'total_planned_cost' => $total_planned_cost,'total_actual_weight' => $total_actual_weight,'total_actual_volume' => $total_actual_volume,'total_actual_cost' => $total_actual_cost,'job_order_status'=>$job_order_status,'selling_price'=>$total_planned_selling_price));
                
                if((int) @$_POST['JobOrder']['quote_id'] > 0){
                    Quotation::model()->updateByPk((int) @$_POST['JobOrder']['quote_id'],array('job_order_id' => $model->id)); 
                }
               
                if(!empty($modelJobOrderStatusHistory)){
                    foreach ($modelJobOrderStatusHistory as $eachModelHistory) {
                        
                        $eachModelHistory->job_order_id = $model->id;
                        $eachModelHistory->save(false);
                    }
                }
                
                
                if (isset($_POST['Icon']['file']) && $_POST['Icon']['file'] != '') {
                    $doc_test = Document::model()->find(array('condition' => 'file_id=' . $model->file_id . ' AND document_name="' . $_POST['Icon']['file'] . '"'));
                    if (empty($doc_test)) {
                        $modelDocument = new Document;
                        $modelDocument->uploaded_from = "JO";
                        $modelDocument->file_id = $model->file_id;
                        $modelDocument->created_by = Yii::app()->user->id;
                        $modelDocument->created_datetime = date('Y-m-d h:i:s');
                        $modelDocument->document_name = $_POST['Icon']['file'];
                        $modelDocument->save(false);
                    }
                }
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'JOB_ORDERS',
                    Yii::app()->user->id,
                    $JobOrder_type,
                    " with JobOrder No - {$model->id}  "
                );
                // end audit log 
                
                echo CJSON::encode( array('status' => 'success' ));

                
                            
            }
            else {                    
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if ($modelJobOrderAgentDetails[0]->shipper_id > 0)
                    $error2 = json_decode(CActiveForm::validateTabular($modelJobOrderAgentDetails, '', false), true);
                else
                    $error2[] = "Please select a shipper";
                $error = CJSON::encode(array_merge_recursive($error1, $error2,$other));
                if ($error != '[]')
                    echo $error;
            }              
        }
    }
    
    public function actionGetStatusHistoryList()
    {
            $model=new JobOrderStatusHistory();
            $draw   = $_POST['draw'];
            $offset = $_POST['start'];
            $limit  = $_POST['length'];
            
            
            $job_order_id  = $_POST['job_order_id'];
            $columns = array(
                            // datatable column index  => database column name
                            0=>'t.id',
                            1=>'t.job_order_id',
                            2=>'updated_by'
            );

            $filterColumn = $columns[$_POST['order'][0]['column']];
            $filterOrder  = $_POST['order'][0]['dir'];
            $orderBy      = $filterColumn." ".$filterOrder;
            $condition    = "job_order_id=".$job_order_id;
            if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
            {
               
                $searchString = $_POST['search']['value'];
                $condition.=" AND (status_description LIKE '%".$searchString."%' OR status_city LIKE '%".$searchString."%' OR status_country LIKE '%".$searchString."%')";
            }
           
            $count = $model->with('joborder','owner')->count(array('condition'=>$condition));
            $model = $model->with('joborder','owner')->findAll(array('condition'=>$condition,'order' => 't.status_date DESC,t.status_time DESC','limit'=>$limit,'offset'=>$offset));
            //CASE WHEN status_updation="A" THEN `t`.`id` WHEN status_updation="M" THEN `t`.`id` END DESC

            $recordsTotal = $count;
            $recordsFiltered = $count;
            $data['draw'] = $draw;
            $data['recordsTotal'] = $recordsTotal;
            $data['recordsFiltered'] = $recordsFiltered;
            $rowData=array();
            $m=1;
            foreach ($model as $row)
            {
                
                $div = '';
                $status_date = ($row['status_date']!="")?date("d/m/Y",strtotime($row['status_date'])):"";
                
                /*$status_hour = substr($row['status_time'],0,2);
                $status_minute = substr($row['status_time'],2,3);
                $status_second = substr($row['status_time'],3,5);*/
                
                
                $status_time = ($row['status_time']!="")?date("h:i a",strtotime($row['status_time'])):"";
                //$status_time = $status_hour.":".$status_minute.":".$status_second;
                $rowData[]=array($m,$row['status_description'],$row['status_city'],$row['status_country'],$row['status_note'],$status_date,$status_time);
                $m++;
            }
            $data['data'] = $rowData;

            echo json_encode($data);

    }
    
    public function actionPrintjoborderReportPDF(){
        $id         = (int) Yii::app()->request->getParam('id');
        
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
                  
        $mPDF1->WriteHTML($this->renderPartial('application.modules.logistics.views.pdf.print_job_order', array('model' => $model, 'id' => $id, 'title' => $title, 'title' => $title,'type'=>$type),true));
        $mPDF1->Output("Quotation.pdf", 'I');
        
    }
    
    public function actionAddToFavourite(){
        $id         = (int) Yii::app()->request->getParam('job_order_id');
        $model = new JobOrder();
        $model->updateByPk($id, array('job_priority' => 'F'));
        echo CJSON::encode( array('status' => 'success' ));
    }
    
     public function actionDocumentupload() {
        $file_id = Yii::app()->request->getparam("file_id");
        $modelDocument = Document::model()->find(array('condition' => 'file_id = "' . $file_id . '"'));
        if (empty($modelDocument)) {
            $modelDocument = new Document();
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->renderPartial('document_index', array('modelDocument' => $modelDocument, 'file_id' => $file_id), false, true);
    }
    public function actionGetDocumentList() {

        $model = new Document();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.file_id',
            1 => 't.document_name',
            2 => 't.created_by',
            3 => 't.created_datetime',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.file_id > 0 AND t.isActive="Y" and t.file_id = "' . $_POST['file_id'] . '"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (document_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            $model2 = User::model()->find(array('condition' => 't.id = "' . $row['created_by'] . '"'));
            if (isset(Yii::app()->user->havePermissionOn['allow_delete_document'])) {
                $button_string .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteDocument(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a> &nbsp;';
            }
            //$button_string .= ' <a href ="' . Yii::app()->createUrl('logistics/lead/downloaddocument&id=' . $row['id']) . '" class=" btn btn-primary btn-xs"><i class="fa fa-download"></i></a>';
            $button_string .= ' <a href ="' . Yii::app()->createUrl('logistics/joborder/Downloaddocument&id=' . $row['id']) . '" class=" btn btn-primary btn-xs"><i class="fa fa-download"></i></a>';

            $rowData[] = array($m, $row['document_name'], $model2->username, date("d/m/Y h:i:s", strtotime($row['created_datetime'])), '<div class="btn-wrap text-center">' . $button_string . '</div>');
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionDeleteDocument() {
        $id = $_POST['id'];
        $modelDocument = new Document();
        $model_doc =Document::model()->findbyPK($id);
        $document_details=explode(',',$model_doc->document_name);      
        foreach ($document_details as $value) {
           $path = Yii::getPathOfAlias('webroot')."/uploads/documents/".$value;
            unlink($path);
        }
        $modelDocument->deleteByPk($id);
        echo "success";
    }
    
    public function actionGetOtherCalculator(){
        $courier_type = (int) Yii::app()->request->getParam('courier_type');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->renderPartial('other_calculator',array('courier_type'=>$courier_type));
    }
    
    public function actionChangeJobAgentStatus(){
        $job_order_id = (int) Yii::app()->request->getParam('id');
        $model=new JobOrderAgentDetails();
        
        $model->job_order_id = $job_order_id;
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('change_job_status',array('model'=>$model));
    }
    
    public function actionUpdateJobAgentStatus(){
        $modelAgentDetails  =   new JobOrderAgentDetails();
        
        $job_order_id   = $_POST['JobOrderAgentDetails']['job_order_id'];
        $status         = (int) $_POST['JobOrderAgentDetails']['status'];
        $shipper_id     = $_POST['JobOrderAgentDetails']['shipper_id'];
        $notes          = $_POST['JobOrderAgentDetails']['notes'];
        if($status > 0){
            $arr_job_order_details = JobOrderAgentDetails::model()->find(array('condition'=>'job_order_id='.$job_order_id.' AND shipper_id='.$shipper_id));
            
            $existing_status    =   MasJobOrderStatus::getStatusOfJobOrder($arr_job_order_details['status']);
            $new_status         =   MasJobOrderStatus::getStatusOfJobOrder($status);
            
            
            $status_description     =   "Status ".$existing_status." changed to ".$new_status;
            
            $modelJobOrderStatusHistory                         =   new JobOrderStatusHistory; 
            $modelJobOrderStatusHistory->job_order_id           =   $job_order_id;
            $modelJobOrderStatusHistory->job_order_agent_id     =   $arr_job_order_details['id'];
            $modelJobOrderStatusHistory->status_description         =   $new_status;
            $modelJobOrderStatusHistory->status_note         =   $notes;
            $modelJobOrderStatusHistory->current_status         =   $status;
            $modelJobOrderStatusHistory->updated_by             =   Yii::app()->user->id;
            $modelJobOrderStatusHistory->updated_date_time      =   date('Y-m-d h:i:s');
            $modelJobOrderStatusHistory->status_updation         =   "M";
            $modelJobOrderStatusHistory->status_date             =   date('Ymd');
            $modelJobOrderStatusHistory->status_time            =   date('his');
            $modelJobOrderStatusHistory->save(false);
        
            $modelAgentDetails->updateByPk($arr_job_order_details['id'], array('status' => $status,'notes' => $notes));
            
            $modelJobOrderMailStatus                = new JobOrderMailStatus();
            
            $modelJobOrderMailStatus->updateAll(array('status_mail_send' => 'Y'), 'job_order_id ='.$job_order_id.' AND job_order_agent_id='.$arr_job_order_details['id'].' AND job_order_agent_shipper_id='.$shipper_id);
            
            
            $modelMailStatus                                    = new JobOrderMailStatus();
                
            $modelMailStatus->job_order_id                      = $job_order_id;
            $modelMailStatus->job_order_agent_id                = $arr_job_order_details['id'];
            $modelMailStatus->job_order_agent_shipper_id        = $shipper_id;
            $modelMailStatus->shipper_awb_no                    = $arr_job_order_details['awb_no'];
            $modelMailStatus->status_updated_date               = date('Y-m-d H:i:s');
            $modelMailStatus->status_updated_count              = 1;
            $modelMailStatus->status_mail_send                  = "N";
            $modelMailStatus->last_status                       = $new_status;
            $modelMailStatus->save(false);
            
            
             $data['status'] = "success";
        }
        else{
        
            $data['status'] =  "fail";
        }
        
        
        echo json_encode($data);
    }
    
    public function actionScreenshot(){
        $job_order_id = (int) Yii::app()->request->getParam('id');
        $model=new JobOrderScreenshot();
        
        $model->job_order_id = $job_order_id;
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('screenshot_create',array('model'=>$model));
    }
    
    public function actionSaveScreenshot(){
            $model = new JobOrderScreenshot();
            if (isset($_POST['JobOrderScreenshot'])) {         
                $scenario='';
                if ((int) @$_POST['JobOrderScreenshot']['id'] > 0) {
                        $model->id = (int) $_POST['JobOrderScreenshot']['id'];
                        $model->updated_by = Yii::app()->user->id;
                        $model->updated_date_time =date('Y-m-d h:i:s'); 
                        $model = $model->findByPK($model->id);
                        $model->scenario = 'update';
                        $scenario='update';
                        $JobOrder_type = 'UPDATED';
    
                } else {
                        $model->created_by = Yii::app()->user->id;
                        $model->created_date_time =date('Y-m-d h:i:s');
                        $model->scenario = 'add';
                        $scenario='add';
                        $JobOrder_type = 'CREATED';
                }
                $model->attributes = $_POST['JobOrderScreenshot'];
                $model->job_order_id=$_POST['JobOrderScreenshot']['job_order_id'];
                
                $model->image_text=$_POST['JobOrderScreenshot']['image_text'];
                
          
                
                if($model->validate()){
                    
                    define('UPLOAD_DIR', 'uploads/screenshot/');
                    
                    $file_name='JO_'.$model->job_order_id."_".uniqid() . '.png';
                    $image_parts = explode(";base64,", $_POST['JobOrderScreenshot']['image_text']);
                    $image_type_aux = explode("image/", $image_parts[0]);
                    $image_type = $image_type_aux[1];
                    $image_base64 = base64_decode($image_parts[1]);
                    $file = UPLOAD_DIR . $file_name;
                    file_put_contents($file, $image_base64);
                    
                    $model->image_text=$file_name;
                    $model->save(false);
                    
                    $jsonData['status'] = "success";
                }
                else {    
                    $error = CActiveForm::validate($model, '', false);
                    if ($error != '[]')
                        echo $error;
                }    
                
               
        }
        else{
           $jsonData['status'] = "success";
        }
        
         echo json_encode($jsonData);
    }
    
    public function actionGetScreenshotHistoryList()
    {
            $model=new JobOrderScreenshot();
            $draw   = $_POST['draw'];
            $offset = $_POST['start'];
            $limit  = $_POST['length'];
            
            
            $job_order_id  = $_POST['job_order_id'];
            $columns = array(
                            // datatable column index  => database column name
                            0=>'t.id',
                            1=>'t.job_order_id',
                            2=>'updated_by'
            );

            $filterColumn = $columns[$_POST['order'][0]['column']];
            $filterOrder  = $_POST['order'][0]['dir'];
            $orderBy      = $filterColumn." ".$filterOrder;
            $condition    = "job_order_id=".$job_order_id;
            if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
            {
               
                $searchString = $_POST['search']['value'];
                $condition.=" AND (owner.first_name LIKE '%".$searchString."%' OR owner.last_name LIKE '%".$searchString."%' OR t.job_order_id LIKE '%".$searchString."%')";
            }
           
            $count = $model->with('joborder','owner')->count(array('condition'=>$condition));
            $model = $model->with('joborder','owner')->findAll(array('condition'=>$condition,'order' => 't.id DESC','limit'=>$limit,'offset'=>$offset));

            $recordsTotal = $count;
            $recordsFiltered = $count;
            $data['draw'] = $draw;
            $data['recordsTotal'] = $recordsTotal;
            $data['recordsFiltered'] = $recordsFiltered;
            $rowData=array();
            foreach ($model as $row)
            {
                
               $arr_customer_contact = CustomerContact::model()->findAll(array('condition'=>'department=6 AND contact_email_id!="" AND customer_id='.(int) $row["joborder"]["customer_id"]));//finance department
               
               
                //preg_match( '@src="([^"]+)"@' , $row['image_text'], $match );
                //$src = array_pop($match);
                $div = '<img src="uploads/screenshot/'.$row['image_text'].'" width="50" height="50">';
                $btn='';
                if(count($arr_customer_contact) > 0){
                    $btn='<button class="btn btn-sm btn-theme" onclick="SendScreenshotMail('.$row['id'].','.$row['job_order_id'].','.(int) $row['joborder']['customer_id'].');return false;"><i class="fa fa-send"></i> SEND MAIL</button>';
                }
                
                $rowData[]=array($row['id'],$div,$row->owner->first_name." ".$row->owner->last_name,date("d/m/Y h:i A",strtotime($row['created_date_time'])),$btn);

            }
            $data['data'] = $rowData;

            echo json_encode($data);

    }
    
    public function actionSendScreenshotMail(){
        $job_order_id           = (int) Yii::app()->request->getParam('job_order_id');
        $screenshot_id          = (int) Yii::app()->request->getParam('screenshot_id');
        $customer_id            = (int) Yii::app()->request->getParam('customer_id');
        $modelJobOrderScreenshot = JobOrderScreenshot::model()->findByPk($screenshot_id);
        
        $arr_customer_contact = CustomerContact::model()->findAll(array('condition'=>'department=6 AND contact_email_id!="" AND customer_id='.(int) $customer_id));//finance department
        
        
        foreach($arr_customer_contact as $eachCustomerContact) {
        
            //$arr_contacts = CustomerContact::model()->findByPk($customer_contact_id);
            $email_id = $eachCustomerContact['contact_email_id'];
            $contact_name = $eachCustomerContact['person_name'];
            //preg_match( '@src="([^"]+)"@' , $modelJobOrderScreenshot['image_text'], $match );
            //$src = array_pop($match);
           
            $screenshot = '<img src="https://blueskylogistics.me/logistics/uploads/screenshot/'.$modelJobOrderScreenshot['image_text'].'" width="100%">';
            
            $salutation='Dear '.$contact_name;
            
            if($email_id!=""){
            
                $mailContent['company_name']    = Yii::app()->user->master_company_name;
                $mailContent['salutation']      = $salutation;
                $mailContent['screenshot']      = $screenshot;
                $mailContent['job_order_id']      = $job_order_id;
            
            
                $message = new YiiMailMessage;
                $message->view = 'email_screenshot';
                $message->setBody(array('mailContent' => $mailContent), 'text/html');
                $message->subject ='Job Order Status'; 
                $message->from ='updates@infinitylogisticsme.com';
                $message->addTo($email_id);
                $message->addBcc('updates@infinitylogisticsme.com');
                //$message->addBcc('mereena.vinod@mailbluesky.com');
                //$message->addBcc('manu.varghese236@gmail.com');
                //$message->addBcc('dksnrajan@gmail.com');
                //$message->addBcc('arunjv@gmail.com');
                //$message->addBcc('arun@mailbluesky.com');
                Yii::app()->mail->send($message); 
                 $jsonData['status'] = "success";
            }
            else{
                 $jsonData['status'] = "failed";
            }
        }
        
        echo json_encode($jsonData);
    }
    
    public function actionGetTracking(){
        $job_order_id           =   (int) Yii::app()->request->getParam('job_order_id');
        $shipper_id             =   (int) Yii::app()->request->getParam('shipper_id');
        $tracking_id            =   Yii::app()->request->getParam('tracking_id');
        $job_order_agent_id     =   (int) Yii::app()->request->getParam('agent_id');
        
        //$tracking_id            = "1Z8A4F130469252507123";
        
        //$post_url = "https://wwwcie.ups.com/track/v1/details/1Z5338FF0107231059";//for testing purpose
        
        if($tracking_id!=""){
            $post_url = "https://onlinetools.ups.com/track/v1/details/".$tracking_id;//live
    
            $curl = curl_init($post_url);
            
            $headers = array(
                            'Content-Type: application/json',
                            'Accept: application/json',
                            //'transactionSrc: TestTrack',
                            //'transId: 12345',
                            'Username: INFINITYLOG',
                            'Password: Aramex3003767',
                            'AccessLicenseNumber: 9D99FF9A45E789BD'
                            );
            //curl_setopt($curl, CURLOPT_USERPWD, "username":"Password");
            curl_setopt($curl, CURLOPT_URL, $post_url);
            curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
            //curl_setopt($curl, CURLOPT_POST, true);
            //curl_setopt($curl, CURLOPT_POSTFIELDS,json_encode($post_data) );
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            //curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE); 
            
            $responses = curl_exec($curl); 
             $arr_return_response = json_decode($responses);
             
  
             
            // echo '<pre>';
            // print_r($arr_return_response);
                        
             $jsonData=array();
             $arr_status = array();
             $error_flag=0;
             foreach($arr_return_response as $key=>$eachResponse){
                    if(count($eachResponse->errors)==0){
                         foreach($eachResponse as $eachItem){
                             foreach($eachItem as $key1=>$each){
                                 //if(isset($each->message;
                                 foreach($each->package as $item){
                                     $k=0;
                                     foreach($item->activity as $key3=>$itemContent){
                                         
                                         
                                         $arr_status[$k]['location'] = $itemContent->location;
                                         $arr_status[$k]['status'] = $itemContent->status;
                                         $arr_status[$k]['date'] = $itemContent->date;
                                         $arr_status[$k]['time'] = $itemContent->time;
                                         
                                         $k++;
                                     }
                                 }
                             }
                         }
                    }
                    else{
                        foreach($eachResponse as $eachItem){
                             foreach($eachItem as $key1=>$eachErrors){
                                 $jsonData['status'] = 'failed';
                                 $jsonData['message'] = $eachErrors->message;
                                 $error_flag=1;
                             }
                        }
                    }
                }
             
            if($error_flag==0){
                                 
                $current_status_id = $this->getTrackResponse($arr_status,$job_order_id,$job_order_agent_id,$shipper_id,$tracking_id);     
                $jsonData['status']     = 'success';
                $jsonData['message']    = 'Updated';
                $jsonData['current_status_id']    = $current_status_id;
            }
            
            //print_r($jsonData);
        }
        else{
            $jsonData['status']     = "failed";
            $jsonData['message']    = 'Invalid Enquiry Number';
        }
        
        
        echo json_encode($jsonData);
        
    }
    
    function getTrackResponse($arr_status,$job_order_id,$job_order_agent_id,$shipper_id,$shipper_awb_no){
        
        
        $arr_track_response = array();
        $i=0;
        $last_updated_status="";
        $current_status_id=0;
        JobOrderStatusHistory::model()->deleteAll('job_order_agent_id=:refer_id', array(':refer_id' => $job_order_agent_id));
        
        $cnt_description=0;
        foreach($arr_status as $key=>$track_details){
            
            /*$arr_track_response[$i]['date']                     = $track_details['date'];
            $arr_track_response[$i]['time']                     = $track_details['time'];
            $arr_track_response[$i]['status_type']              = $track_details['status']->type;
            $arr_track_response[$i]['status_description']       = $track_details['status']->description;
            $arr_track_response[$i]['status_code']              = $track_details['status']->code;
            $arr_track_response[$i]['city']                     = $track_details['location']->address->city;
            $arr_track_response[$i]['state_province']           = $track_details['location']->address->stateProvince;
            $arr_track_response[$i]['postal_code']              = $track_details['location']->address->postalCode;
            $arr_track_response[$i]['country']                  = $track_details['location']->address->country;*/
            
            if(!empty($track_details['status']->description)){
                
                if($current_status_id==0){
                    $last_updated_status = $track_details['status']->description;
                   
                    $current_status_id = MasJobOrderStatus::getStatusOfJobOrderByApiStatus($shipper_id,$last_updated_status);
                     //echo "hi".$current_status_id;
                }
                
                if($cnt_description==0){
                    $last_update_status = $track_details['status']->description;
                }
                
                $model                          = new JobOrderStatusHistory();
                
                $model->job_order_id            = $job_order_id;
                $model->job_order_agent_id      = $job_order_agent_id;
                $model->current_status          = MasJobOrderStatus::getStatusOfJobOrderByApiStatus($shipper_id,$track_details['status']->description);;
                $model->status_description      = $track_details['status']->description;
                $model->status_type             = $track_details['status']->type;
                $model->status_code             = $track_details['status']->code;
                $model->status_city             = $track_details['location']->address->city;
                $model->status_state_province   = $track_details['location']->address->stateProvince;
                $model->status_postal_code      = $track_details['location']->address->postalCode;
                $model->status_country          = $track_details['location']->address->country;
                $model->status_date             = $track_details['date'];
                $model->status_time             = $track_details['time'];
                $model->updated_by              = Yii::app()->user->id;
                $model->updated_date_time       = date('Y-m-d H:i:s',strtotime($track_details['time']));
                
                $model->save(false);
                
                $cnt_description++;
            }
            
            
            $i++;
        }
        
        
        if($cnt_description > 0)
        {
            $modelJobOrderMailStatus = new JobOrderMailStatus();
            $SQL="SELECT MAX(status_updated_date) AS status_updated_date,status_updated_count FROM `erp_job_order_mail_status` WHERE job_order_id=".$job_order_id." AND job_order_agent_id=".$job_order_agent_id." AND job_order_agent_shipper_id=".$shipper_id;
            //echo $SQL;
            $arr_job_order_mail_status = Yii::app()->db->createCommand($SQL)->queryRow();
            
            //echo '<pre>';
            //print_r($arr_job_order_mail_status);
            
            $status_updated_count = (int) $arr_job_order_mail_status['status_updated_count'];
            
            //echo "job_order_id=".$job_order_id."<br>";
            //echo "job_order_agent_id=".$job_order_agent_id."<br>";
            //echo "shipper_id=".$shipper_id."<br>";
            
            //echo "cnt_description=".$cnt_description."<br>";
            
            //echo "status_updated_count=".$status_updated_count."<br>";
            if($cnt_description!=$status_updated_count){
                $modelMailStatus                = new JobOrderMailStatus();
                
                $modelMailStatus->job_order_id                      = $job_order_id;
                $modelMailStatus->job_order_agent_id                = $job_order_agent_id;
                $modelMailStatus->job_order_agent_shipper_id        = $shipper_id;
                $modelMailStatus->shipper_awb_no                    = $shipper_awb_no;
                $modelMailStatus->status_updated_date               = date('Y-m-d H:i:s');
                $modelMailStatus->status_updated_count              = $cnt_description;
                $modelMailStatus->status_mail_send                  = "N";
                $modelMailStatus->last_status                       = $last_update_status;
                $modelMailStatus->save(false);
            }
        }
        $modelJobOrderAgentDetails=new JobOrderAgentDetails();
        $modelJobOrderAgentDetails->updateByPk($job_order_agent_id, array('status' => $current_status_id));
        
        return $current_status_id;
        
    }
    
    
    
    public function actionUpdateAPIStatus(){
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('update_api_status');
    }
    
    public function actionUpdateBulkTracking(){
        $shipper_id             = (int) Yii::app()->request->getParam('shipper_id');
        $job_order_id           = 0;
        $job_order_agent_id     = 0;
        $modelJobOrderAgent = new JobOrderAgentDetails();
        
        if($shipper_id > 0){
            $arr_job_order_agent_details = $modelJobOrderAgent->with('joborder')->findAll(array('condition'=>'t.shipper_id='.$shipper_id.' AND (job_order_status="O" || job_order_status="PD")'));
            
            
            if(count($arr_job_order_agent_details) > 0){
                
                $arr_error_tracking_response=array();
                $arr_success_tracking_response=array();
              foreach($arr_job_order_agent_details as $key=>$job_order_agent_details){
                  $tracking_id = $job_order_agent_details->awb_no;
                  $job_order_id = $job_order_agent_details->job_order_id;
                  $job_order_agent_id = $job_order_agent_details->id;
                  
                  if($tracking_id!=""){
                        $post_url = "https://onlinetools.ups.com/track/v1/details/".$tracking_id;//live
                
                        $curl = curl_init($post_url);
                        
                        $headers = array(
                                        'Content-Type: application/json',
                                        'Accept: application/json',
                                        //'transactionSrc: TestTrack',
                                        //'transId: 12345',
                                        'Username: INFINITYLOG',
                                        'Password: Aramex3003767',
                                        'AccessLicenseNumber: 9D99FF9A45E789BD'
                                        );
                        //curl_setopt($curl, CURLOPT_USERPWD, "username":"Password");
                        curl_setopt($curl, CURLOPT_URL, $post_url);
                        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
                        //curl_setopt($curl, CURLOPT_POST, true);
                        //curl_setopt($curl, CURLOPT_POSTFIELDS,json_encode($post_data) );
                        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                        //curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE); 
                        
                        $responses = curl_exec($curl); 
                         $arr_return_response = json_decode($responses);
                         
              
                         
                        // echo '<pre>';
                        // print_r($arr_return_response);
                                    
                         $jsonData=array();
                         $arr_status = array();
                         $error_flag=0;
                         $arr_errors = array();
                         foreach($arr_return_response as $key=>$eachResponse){
                                if(count($eachResponse->errors)==0){
                                     foreach($eachResponse as $eachItem){
                                         foreach($eachItem as $key1=>$each){
                                             //if(isset($each->message;
                                             foreach($each->package as $item){
                                                 $k=0;
                                                 foreach($item->activity as $key3=>$itemContent){
                                                     
                                                     
                                                     $arr_status[$k]['location'] = $itemContent->location;
                                                     $arr_status[$k]['status'] = $itemContent->status;
                                                     $arr_status[$k]['date'] = $itemContent->date;
                                                     $arr_status[$k]['time'] = $itemContent->time;
                                                     
                                                     $k++;
                                                 }
                                             }
                                         }
                                     }
                                }
                                else{
                                    $error_flag=0;
                                    foreach($eachResponse as $eachItem){
                                         foreach($eachItem as $key1=>$eachErrors){
                                             $arr_errors['message'] = $eachErrors->message;
                                             $error_flag=1;
                                         }
                                    }
                                }
                            }
                            
                            
                            
                        if($error_flag==0){
                            
                            if($job_order_id > 0 && $job_order_agent_id > 0 && $shipper_id >0){                   
                                $current_status_id = $this->getTrackResponse($arr_status,$job_order_id,$job_order_agent_id,$shipper_id,$tracking_id);    
                                $arr_success_tracking_response[]=$tracking_id;
                            }
                            
                            
                        }
                        else{
                            $arr_error_tracking_response[] = $tracking_id;
                        }
                        
                        //print_r($jsonData);
                    }
                    else{
                        //$jsonData['status']     = "failed";
                        //$jsonData['message']    = 'Invalid Enquiry Number';
                    }
                    
                    
                    //echo json_encode($jsonData);
                    
                  
              }
              if(count($arr_success_tracking_response) > 0){
              $jsonData['success']     = "The following AWB# <b>".implode(",",$arr_success_tracking_response).'</b> updated successfully';
              }
              else{
                  $jsonData['success']     = "No data updated";
              }
              if(count($arr_error_tracking_response) > 0){
                $jsonData['error']     = "The following AWB# <b>".implode(",",$arr_error_tracking_response).'</b> showing as invalid enquiry number';
              }
              else{
                  $jsonData['error']     = "";
              }
              
              
            }
            else{
                $jsonData['error']     = "Invalid Enquiry Number";
            }
        }
        
        echo json_encode($jsonData);
    }
    
    public function actionSendeMailToCustomer(){
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('send_mail_to_customer');
    }
    
    public function actionLoadCustomersEmail(){
        $shipper_id                     =   (int) Yii::app()->request->getParam('shipper_id');
        $modelJobOrderAgent             =   new JobOrderAgentDetails();
        $arr_error_tracking_response    =   array();
        $arr_success_tracking_response  =   array();
        if($shipper_id > 0){
            $arr_job_order_agent_details = $modelJobOrderAgent->with('joborder')->findAll(array('condition'=>'t.shipper_id='.$shipper_id.' AND (job_order_status="O" || job_order_status="PD") AND activity_type=3'/*,'limit'=>10*/));
            
            $count_email=0;
            if(count($arr_job_order_agent_details) > 0){
            
                $data ='<table class="table table-hover table-bordered personal-task" id="tbl_customer_contact">
                <thead>
                    <th><input type="checkbox" id="chk_all_contacts" onclick="checkAllContacts();"></th>
                    <th>Job Order</th>
                    <th>AWB</th>
                    <th>Customer</th>
                    <th>Contact</th>
                    <th>Email</th>
                </thead>
                <tbody>';
                 $i=1;
                 
                    $str_awb_no="";
                    $str_email_ids = "";
                    foreach($arr_job_order_agent_details as $key=>$job_order_agent_details){
                        
                        $job_order_id       = $job_order_agent_details->job_order_id;
                        $job_order_agent_id = $job_order_agent_details->id;
                        
                        $modelJobOrderMailStatus = new JobOrderMailStatus();
                        
                        $SQL="SELECT MAX(status_updated_date) AS status_updated_date,status_mail_send FROM `erp_job_order_mail_status` WHERE job_order_id=".$job_order_id." AND job_order_agent_id=".$job_order_agent_id." AND job_order_agent_shipper_id=".$shipper_id."  GROUP BY id ORDER BY status_updated_date DESC LIMIT 0,1";
                        $arr_job_order_mail_status = Yii::app()->db->createCommand($SQL)->queryRow();
            
                        $status_mail_send       = $arr_job_order_mail_status['status_mail_send'];
                        
                        if($status_mail_send=='N'){
                        
                                        $customer_id = $job_order_agent_details->joborder->customer_id;
                                        $job_order_id = $job_order_agent_details->job_order_id;
                                        
                                        $customer_contact_ids = $job_order_agent_details->joborder->contact_ids;
                                        
                                        //$arr_customer_contact_details = CustomerContact::model()->with('customer','department')->findAll(array('condition'=>'customer_id='.$customer_id.' AND department.department_code="SU"'));//status update
                                        $arr_customer_contact_details = CustomerContact::model()->findAll(array('condition'=>'id IN('.$customer_contact_ids.')'));
                                        if(count($arr_customer_contact_details) > 0){
                                           
                                            foreach($arr_customer_contact_details as $eachContact){
                                                $data.='<tr>';
                                                if(!empty($eachContact->contact_email_id)){
                                                    
                                                    if($str_awb_no!=$job_order_agent_details->awb_no || $str_email_ids!=$eachContact->contact_email_id){
                                                        $str_awb_no=$job_order_agent_details->awb_no;
                                                        $str_email_ids = $eachContact->contact_email_id;
                                                        $count_email++;
                                                        $data.='<td><input type="checkbox" id="chkjoborderid_'.$i.'" name="chkjoborderid[]" value="'.$job_order_id.'" class="check_contact_ids"></td>';
                                                        $data.='<td>'.$job_order_id.'</td>';
                                                        $data.='<td>'.$job_order_agent_details->awb_no.'</td>';
                                                        $data.='<td>'.$eachContact->customer->customer_name.'</td>';
                                                        $data.='<td>'.$eachContact->person_name.'</td>';
                                                        $data.='<td>'.$eachContact->contact_email_id;
                                                        $data.='<input type="hidden" id="hidjoborderagentid_'.$i.'" name="hidjoborderagentid[]" value="'.$job_order_agent_id.'">';
                                                        $data.='<input type="hidden" id="hidcustomercontactid_'.$i.'" name="hidcustomercontactid[]" value="'.$eachContact->id.'">';
                                                        $data.='</td>';
                                                        $i++;
                                                    }
                                                }
                                                $data.='</tr>';
                                                
                                            }
                                           
                                        }
                                        
                                    
                            
                        }
                        
                        
                    }
                    
                    if($count_email==0){
                         $data.='<tr>';
                            $data.='<td colspan="5" align="center">No result found</td>';
                            $data.='</tr>';
                    }
                   
                $data.='</tbody>';
                $data.='</table>';
                $jsonData['success'] = $data;
                //$arr_success_tracking_response = $this->renderPartial('list_send_mail',array('arr_job_order_agent_details'=>$arr_job_order_agent_details));
                
                
              
            }
            else{
                
                $arr_error_tracking_response[]="There is no Job order against the selected Shipper";
            }
            
        }
        else{
            $arr_error_tracking_response[]="Please select a valid Shipper";
        }
        
        
         $jsonData['error'] = $arr_error_tracking_response;
        
        echo json_encode($jsonData);
    }
    
    public function actionSendMailToCustomerSubmit(){
        
        $shipper_id                 =   Yii::app()->request->getParam('shipper_id');
        $job_order_ids              =   Yii::app()->request->getParam('job_order_ids');
        $job_order_agent_ids        =   Yii::app()->request->getParam('agent_ids');
        $customer_contact_ids       =   Yii::app()->request->getParam('contact_ids');
        $arr_job_order_ids          =   explode(",",$job_order_ids);
        $arr_job_order_agent_ids    =   explode(",",$job_order_agent_ids);
        $arr_contact_ids            =   explode(",",$customer_contact_ids);
       //foreach($arr_job_order_ids as $job_order_id){
       $arr_error_tracking_response    =   array();
        $arr_success_tracking_response  =   array();
        $valid_email=0;
       for($cnt=0;$cnt<count($arr_job_order_ids);$cnt++){
           
           $job_order_id        = $arr_job_order_ids[$cnt];
           
           $job_order_agent_id  = $arr_job_order_agent_ids[$cnt];
           
           $customer_contact_id = $arr_contact_ids[$cnt];
           
           
           $modelJobOrderAgentDetails       =   new JobOrderAgentDetails();
           $modelJobOrderAgentDetails       =   $modelJobOrderAgentDetails->findBypk($job_order_agent_id);
            
            $modelJobOrder      =   new JobOrder();
            
            $modelJobOrder      =   $modelJobOrder->findBypk($job_order_id);
            
            $lead_owner_id = (int) $modelJobOrder->lead_owner_id;
            $arr_lead_owner_details = User::model()->findByPk($lead_owner_id);
            
            $lead_owner_email = trim($arr_lead_owner_details->email);
            
            $arr_customer_contact_details = CustomerContact::model()->findByPk($customer_contact_id); 
            
            
            $modelStatusHistory =  new JobOrderStatusHistory();
            
            //$arr_status_history = $modelStatusHistory->with('joborder','owner')->findAll(array('condition'=>'job_order_id='.$job_order_id.' AND job_order_agent_id='.$job_order_agent_id,'order' => 't.id DESC'));
            $arr_status_history = $modelStatusHistory->with('joborder','owner')->findAll(array('condition'=>'job_order_id='.$job_order_id.' AND job_order_agent_id='.$job_order_agent_id,'order' => 't.status_date DESC'));
            
            if(!empty($arr_customer_contact_details->contact_email_id) && count($arr_status_history) > 0){
                
                $email_id = trim($arr_customer_contact_details->contact_email_id);
                
                
                            
                $mailContent['company_name']    = Yii::app()->user->master_company_name;
                
                $mailContent['salutation'] =  'Customer';
                
                
               /* if(!empty($lead_owner_email)){
                    $mailContent['salutation']  = $arr_lead_owner_details->first_name." ".$arr_lead_owner_details->last_name;
                }
                else{
                    $mailContent['salutation']      = $arr_customer_contact_details->person_name;
                }*/
                $mailContent['content']         = $screenshot;
                $mailContent['job_order_id']    = $job_order_id;
                $mailContent['status_history']  = $arr_status_history;
                
                $message = new YiiMailMessage;
                $message->view = 'email_status_history';
                $message->setBody(array('mailContent' => $mailContent), 'text/html');
                $message->subject ='Tracking History - AWB: '.$modelJobOrderAgentDetails->awb_no." | Job#: ".$job_order_id; 
                $message->from ='updates@infinitylogisticsme.com';
                
                 if (filter_var($email_id, FILTER_VALIDATE_EMAIL)) {
                     $message->addTo($email_id);
                     $valid_email++;
                 }
                
                if(!empty($lead_owner_email)){
                    if (filter_var($lead_owner_email, FILTER_VALIDATE_EMAIL)) {
                        $message->addTo($lead_owner_email);
                        $valid_email++;
                    }
                    
                }
                if($valid_email==0){
                    $message->addTo("updates@infinitylogisticsme.com");
                    $message->subject ='Mail Sending Error: Tracking History - AWB: '.$modelJobOrderAgentDetails->awb_no." | Job#: ".$job_order_id; 
                }
                else{
                    $message->addBcc('updates@infinitylogisticsme.com');
                }
                //$message->addBcc('mereena.vinod@mailbluesky.com');
                $message->addBcc('aswanth@infinitylogisticsme.com');
                //$message->addBcc('arun@mailbluesky.com');
                
                //$message->addTo('mereena.hannah@gmail.com');
                Yii::app()->mail->send($message); 
                 $jsonData['status'] = "success";
                 $modelJobOrderMailStatus = new JobOrderMailStatus();
                $modelJobOrderMailStatus->updateAll(array('status_mail_send' => 'Y'), 'job_order_id ='.$job_order_id.' AND job_order_agent_id='.$job_order_agent_id.' AND job_order_agent_shipper_id='.$shipper_id);
                $arr_success_tracking_response[]=$email_id;
                
                
            }
            
            
        }
        
        if(count($arr_success_tracking_response) > 0){
            $jsonData['success']     = "Mail sent successfully to this email id(s) <b>".implode(",",$arr_success_tracking_response).'</b>';
            $jsonData['error'] = "";
        }
        else{
            $jsonData['success']="";
            $jsonData['error'] = "There is no email send";
        }
        
       
        
         echo json_encode($jsonData);
        
    }
    
    
    public function actionGetJobOrderDetails(){
        $job_order_id           = (int) Yii::app()->request->getParam('job_order_id');
        $modelJobOrder          = JobOrder::model()->findByPk($job_order_id);
        
        $data ='<table class="table table-hover table-bordered personal-task" id="tbl_customer_contact">
               
                <tbody>
                 <tr>
                        <th colspan="5"><span style="background-color: orange;color:white;width:250px;text-align:center;border-radius:5px;"><b>Job Order Details</b></span></th>
                    </tr>
                    <tr>
                        <td>Customer</td>
                        <th>'.$modelJobOrder->customer->customer_name.'</th>
                        <td>Job Date</td>
                        <th>'.date('d/m/Y',strtotime($modelJobOrder->job_date)).'</th>
                        <td>Shipper</td>
                        <th>'.$modelJobOrder->shipper_id.'</th>
                    </tr>
                    
                    <tr>
                        <td>Consignee</td>
                        <th>'.$modelJobOrder->consignee_id.'</th>
                        <td>Origin</td>
                        <th>'.$modelJobOrder->org->country_name.'</th>
                        <td>Destination</td>
                        <th>'.$modelJobOrder->dest->country_name.'</th>
                    </tr>
                    
                    <tr>
                        <td>Assign Job</td>
                        <th>'.$modelJobOrder->leadowner->fullName.'</th>
                        <td>Weignt(KG)</td>
                        <th>'.$modelJobOrder->weight.'</th>
                        <td>Volume(CBM)</td>
                        <th>'.$modelJobOrder->volume.'</th>
                    </tr>
                    <tr>
                        <td>Customer Reference</td>
                        <th>'.$modelJobOrder->customer_reference_no.'</th>
                        <td>Selling Price</td>
                        <th style="text-align:right">'.$modelJobOrder->selling_price.'</th>
                        <td>Payment Terms</td>
                        <th>'.$modelJobOrder->paymentmethod->payment_terms.'</th>
                    </tr>
                </tbody>
                </table>
                ';
                $jsonData['success'] = $data;
                
                echo json_encode($jsonData);
                
    }
    
    
    public function actionUpdateDHLBulkTracking(){
        
        $auth_string = '{"userId":"dikson@bluesky","key":"3LGqZDjvUGNQGj121xlqyFP5VtCwyp1C"}';
        
        //f36abdfa- 9894-4d1f-bb6e-e471a953c04d
        
        //curl -X POST "https://api-gw.dhlparcel.nl/authenticate/api-key" -H "Accept:application/json" -H "Content-Type: application/json" -d "{\"userId\": \"f36abdfa- 9894-4d1f-bb6e-e471a953c04d\", \"key\": \"1c8545e1-767f-4531-9c6b-5f5f80737562\"}"
        
        $arr_auth['userId'] = "dikson@bluesky";
        $arr_auth['key'] = "3LGqZDjvUGNQGj121xlqyFP5VtCwyp1C";
        
        //$auth_string=json_encode($arr_auth);
        
        $ch = curl_init('https://api-gw.dhlparcel.nl/authenticate/api-key/3LGqZDjvUGNQGj121xlqyFP5VtCwyp1C');
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $auth_string);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json','Accept:application/json'));
        $auth_response = curl_exec($ch);
        $api_key = json_decode($auth_response);
        $accessToken = $api_key->{'accessToken'};
        
        
        echo '<pre>';
        print_r($auth_response);
        
        echo '<pre>';
        print_r($accessToken);
        
        echo "success";
        
        
        
        /*$mode        = 'sandbox'; // sandbox or production
        $username    = 'dikson@bluesky'; // dhl developer account name, not email
        $password    = 'Dikson@bluesky1'; // dhl developer account pass
        $appname     = 'zt12345'; // sandbox app
        $apppass     = 'geheim'; // sandbox app
        $endpoint    = 'https://cig.dhl.de/services/' . $mode . '/rest/sendungsverfolgung';
        $payload     = simplexml_load_string( '<?xml version="1.0" encoding="UTF-8" standalone="no"?><data appname="' . $appname . '" language-code="de" password="' . $apppass . '" piece-code="" request="d-get-piece-detail"/>' );
        $shipmentids = array(
            '00340434161094015902' // in sandbox only special numbers are allowed
        );
        
        
        $opts = array(
            'http' => array(
                'method' => "GET",
                'header' => "Authorization: Basic " . base64_encode( "$username:$password" )
            )
        );
        
        $context = stream_context_create( $opts );
        
        
        foreach ( $shipmentids as $shipmentid ) {
            $payload->attributes()->{'piece-code'} = $shipmentid;
            $response                              = file_get_contents( $endpoint . '?' . http_build_query( array( 'xml' => $payload->saveXML() ) ), false, $context );
            $responseXml                           = simplexml_load_string( $response );
            $status                                = null;
        
            // get last state
            foreach ( $responseXml->data->data->data as $event ) {
                $status = $event->attributes()->{'event-short-status'};
            }
        
            echo "Shipment " . $shipmentid . " is in state: " . $status . "\n";
        }*/
        //$tracking_number = "4047228441123";
        //print_r($this->dhl_tracking($tracking_number));
        
    }
    
    function dhl_tracking($trackingnumber)
    {
       $data  = '<?xml version="1.0" encoding="ISO-8859-1" ?>';
       $data .= '<data appname="nol-public" password="anfang" request="get-status-for-public-user" language-code="de">';
       $data .= '  <data piece-code="'.$trackingnumber.'"></data>';
       $data .= '</data>';
    
       // URL bauen und File hohlen
       $xml = simplexml_load_file(sprintf(
          'http://nolp.dhl.de/nextt-online-public/direct/nexttjlibpublicservlet?xml=%s', $data
       ));
    
       // FALSE, wenn Syntax oder HTTP Error
       if ($xml === false) return false;
    
       // Wandelt das SimpleXML Objekt in ein Array um
       foreach ($xml->data->data->attributes() as $key => $value) {
          $return[$key] = (string) $value;
       }
       return $return;
    }
    
    
    public function actionGetJobOrderLastUpdatedStatus(){
        $job_order_id           = (int) Yii::app()->request->getParam('job_order_id');
        $SQL="SELECT status_description,date_format(concat(`status_date`,'',`status_time`),'%m/%d/%Y %h:%i:%s') AS date_time FROM `erp_job_order_status_history` WHERE job_order_id=".$job_order_id.' ORDER By id DESC LIMIT 0,1';
        $arr_status_details = Yii::app()->db->createCommand($SQL)->queryAll();
        
        $data='<table class="table table-hover table-bordered personal-task">';
        $data.='<tr>';
        $data.='<th>Status</th>';
        $data.='<th>Date/Time</th>';
        $data.='</tr>';
        if($arr_status_details[0]['status_description']!="" || $arr_status_details[0]['date_time']!=""){
            $data.='<tr>';
            $data.='<td>'.$arr_status_details[0]['status_description'].'</td>';
            $data.='<td>'.$arr_status_details[0]['date_time'].'</td>';
            $data.='</tr>';
        }
        else{
            $data.='<tr>';
            $data.='<td colspan="2" align="center">No Data Found</td>';
            $data.='</tr>'; 
        }
        $data.='</table>';
        
        echo $data;
        
    }

    
   
    
    
     /*public function actionGetShipment(){
        $job_order_id           = (int) Yii::app()->request->getParam('job_order_id');
        $shipper_id             = (int) Yii::app()->request->getParam('shipper_id');
        $tracking_id            =  Yii::app()->request->getParam('tracking_id');
        
        $tracking_id = "1Z8A4F130469252507";
        
        //$post_url = "https://wwwcie.ups.com/track/v1/details/1Z5338FF0107231059";//for testing purpose
        
        if($tracking_id!=""){
            $post_url = "https://onlinetools.ups.com/track/v1/details/".$tracking_id;//live
    
            $curl = curl_init($post_url);
            
            $headers = array(
                            'Content-Type: application/json',
                            'Accept: application/json',
                            //'transactionSrc: TestTrack',
                            //'transId: 12345',
                            'Username: INFINITYLOG',
                            'Password: Aramex3003767',
                            'AccessLicenseNumber: 9D99FF9A45E789BD'
                            );
            //curl_setopt($curl, CURLOPT_USERPWD, "username":"Password");
            curl_setopt($curl, CURLOPT_URL, $post_url);
            curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
            //curl_setopt($curl, CURLOPT_POST, true);
            //curl_setopt($curl, CURLOPT_POSTFIELDS,json_encode($post_data) );
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            //curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE); 
            
            $responses = curl_exec($curl); 
             $arr_return_response = json_decode($responses);
             
             $jsonData=array();
             foreach($arr_return_response as $key=>$eachResponse){
                 foreach($eachResponse as $eachItem){
                     //print_r($eachItem->activity);
                     foreach($eachItem as $key1=>$each){
                         foreach($each->package as $item){
                            // echo '<pre>';
                            
                             foreach($item->activity as $key3=>$itemContent){
                                 
                                  //print_r($itemContent->status);
                                
                                //echo $itemContent->time;
                                // print_r($itemContent->time);
                                 
                                 foreach($itemContent as $key4=>$itemContent1){
                                     //echo $itemContent1->address->city;
                                     //if($itemContent1->address->city!=""){
                                         
                                        
                                         
                                      $jsonData['city']=$itemContent1->address->city;
                                      $jsonData['country_code'] =$itemContent1->address->country;
                                     
                                      
                                     //}
                                     
                                      $jsonData['transport_status'] = $itemContent->status->description;
                                 $jsonData['datetime'] = date('d/m/Y h:i a',strtotime($itemContent->time));
                                 
                                 break;
                                     
                                 }
                             }
                         }
                     }
                 }
             }
           
            $jsonData['status'] = "success";
            
            //print_r($jsonData);
        }
        else{
            $jsonData['status'] = "failed";
        }
        
        
        echo json_encode($jsonData);
        
    }*/
    
    public function actionDeleteAgentDetails(){
         $agent_details_id          =   (int) Yii::app()->request->getParam('agent_id');
         $modelPurchaseInvoiceItem  = new PurchasingInvoiceItem();
         $count_purchase            = (int) $modelPurchaseInvoiceItem->count(array('condition'=>'job_order_agent_id='.$agent_details_id));
         $modelInvoiceItem          = new InvoiceItem();
         $count_invoice             = (int) $modelInvoiceItem->count(array('condition'=>'order_item_id='.$agent_details_id));
         
         if($count_purchase==0 && $count_invoice==0){
             $modelAgentDetails = new JobOrderAgentDetails();
             $modelAgentDetails->deleteByPk($agent_details_id);
             $jsonData['status'] = "success";
         }
         else{
             if($count_invoice > 0 && $count_purchase > 0){
                 $msg="Error while delete. Details used in both Purchase Invoice and Invoice";
             }
             elseif($count_purchase > 0){
                 $msg="Error while delete. Details used in Purchase Invoice";
             }
             elseif($count_invoice > 0){
                 $msg="Error while delete. Details used in Invoice";
             }
             
             $jsonData['message']   = $msg;
             $jsonData['status']    = 'failed';
         }
         echo json_encode($jsonData);
    }
    
    
    public function actionGetTermsnCondtn()
    {
        $id = $_POST['vendor_id'];
        $modelVendor = Vendor::model()->findByPk($id);
        $vendor_termsnconditions = $modelVendor->vendor_termsnconditions;
        echo $vendor_termsnconditions;
    }
   
}