<?php
class InvoiceController extends Controller
{
    public $layout = 'layout';
    public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                        'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails'),
                        'users' => array('*'),
                ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                        'actions' => array('Index','PrintInvoiceReportPDF','GetInvoiceList','Create','SaveInvoice','DeleteNotes','GetNotesList','UploadDocuments',
                        'GetDocumentList','DeleteDocument','GetDeliveryList','createInvoice','createMultiInvoice','SetFile','GetFileDetails','PrintInvoiceReportWoHPDF',
                        'GetFiles','Getfileno','FetchDeliveryNotes','SaveMultipleDeliveryInvoice','CreateReceipt',
                        'SaveReceipt','EditReceipt','GetInvoiceDetails','PrintVatInvoiceReportPDF','PrintInvoiceReportPDF_other','Getunitdrop','SaveHiringinvoice',
                        'createhiringInvoice','hiringdetails','getbilltypeamount','CreateadvanceInvoice','SaveadvanceInvoice',
                        'getadvanceamount','View','cancelinvoice','EditInvoice','UpdateInvoice','updatelpo','CreateOutforDelivery','checkInvoiceExists','checkInvoiceItemExists',
                        'SaveOutdeliveryInvoice','Documentupload','GetProducts','Getunitdrop','SendPostedInvoice','GetActivityType','UpdateJoborderItem','UpdateJoborderAgentDetails','UpdateCustomer','UpdateCustomerSubmit'
                        ),
                        'expression' => '$user->isMember()',
                ),
                array('deny', // deny all users
                        'users' => array('*'),
                ),
        );
    }
        public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }
    public function actionIndex()
    {
        $frm = (int) Yii::app()->request->getParam('frm');
        $this->render('index',array('frm'=>$frm));
    }
    public function actionGetInvoiceList()
    {
        $model=new Invoice();
        $draw   = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $frm  = $_POST['frm'];
        $columns = array(
                // datatable column index  => database column name
                0 => 't.file_id',
                1 => 't.sales_group',
                2 => 't.invoice_no',
                3 => 't.id',
                4 => 't.order_id',
                5 => 't.invoice_date',
                6 => 'customer.customer_name',
                7 => 'leadowner.first_name',
                8 => 'currencyname.currency_code',
                9 => 't.total_tax_amount',
                10 => 't.grand_total',
                11 => 'file.status',
                12 => 't.id',
                13 => 't.id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        //$orderBy = 't.id DESC';
        $orderBy        = $filterColumn." ".$filterOrder;
        $condition      = 't.isActive="Y"';
        
        if(((int) Yii::app()->user->havePermissionOn["invoice_view_all"]) == 0){
            $condition.= ' AND t.lead_owner_id= "'.Yii::app()->user->id.'"';
        }
        
        /*if(!isset(Yii::app()->user->havePermissionOn["invoice_view_all"]) &&  Yii::app()->user->authorised_user != 1)
        {
            $condition.= ' AND (t.lead_owner_id= "'.Yii::app()->user->id.'" OR file.lead_owner_id="'.Yii::app()->user->id.'")';
        }    */
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $searchString = $_POST['search']['value'];
            $condition.=" AND ( t.id LIKE '%".$searchString."%' OR t.custom_invoice_no LIKE '%".$searchString."%' OR customer.customer_name LIKE '%".$searchString."%' OR file.file_title LIKE '%".$searchString."%' OR t.file_id LIKE '%".$searchString."%' OR t.order_id LIKE '%".$searchString."%' OR t.awb_no LIKE '%".$searchString."%')";
        }
        
        $count = $model->with('customer','file','leadowner','currencyname')->count(array('condition'=>$condition));
        $model=$model->with('customer','file')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'t.id DESC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
                $status='';
        foreach ($model as $row)
        {
            
            $cnt_non_order_item = (int) InvoiceItem::model()->count(array('condition'=>'invoice_id='.$row['id'].' AND order_item_id=0'));
            
            $cnt_invoice_item = (int) InvoiceItem::model()->count(array('condition'=>'invoice_id='.$row['id']));
            
            $cnt_job_order_item = (int) JobOrderAgentDetails::model()->count(array('condition'=>'job_order_id='.$row['order_id']));
            $post_flag=0;
            if($cnt_invoice_item!=$cnt_job_order_item){
                $post_flag=1;
            }
            
            $div = '';
            if((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["invoice_print"]))){
                $div .= '<a class="btn btn-primary btn-xs" title="Print PDF" target="_blank" href="?r=invoice/PrintInvoiceReportPDF&id='.$row['id'].'&c_id='.$row['crm_user_id'].'&frm=tax"><i class="fa fa-file-pdf-o"></i></a>';
            }

            if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["customer_activity"])){
                $div .= ' <button class="btn btn-primary btn-xs" title ="Edit Activity" onclick="loadPopupModal(\'activity/create&customer_id='.$row['customer']['id'].'\',\''.$row['customer']['id'].' : '.$row['customer']['customer_name'].' - Activities '.'\',\'lg\')"><i class="fa fa-certificate"></i></button>';
            }
            //$creditnote = Creditnote::model()->find(array('condition' => 'invoice_id = '.$row['id']));
            //( $creditnote->id  > 0 ) ?  $cn_state = 'Yes' : $cn_state = 'No';
            $cn_state = 'No';
            //Max invoice id
            $model_max_invoice = Invoice::model()->find(array('select'=>'max(id) as id','condition' => 'order_id ="'.$row['order_id'].'"'));
            $show_invoice_cancel='N';
            if($model_max_invoice->id==$row['id']){
                $show_invoice_cancel='Y';
            }
            $status=$row['file']['status'];
            if($row['posted']=='Y')
            {
            $status.='/Posted';    
            $color='green';
            }
            else {
            $status.='/Unposted';      
            $color='red';
            }
            
            
            $status='<span title="'.$status.'" style="background-color:'.$color.'; color:#fff;">'.$status.'</span>';
            //if($cnt_non_order_item > 0){
            $rowData[]=array($row['file_id'], $row['id'], $row['order_id'],$row['awb_no'],date("d/m/Y",strtotime($row['invoice_date'])),$row['customer']['customer_name'], $row->leadowner->fullname,$row['currencyname']['currency_code'],Yii::app()->numberFormatter->formatCurrency($row['total_tax_amount'],""),Yii::app()->numberFormatter->formatCurrency($row['grand_total'],""),$status, $row['is_credit_note'],$row['customer']['id'],$row['invoice_status'],$row['posted'],$show_invoice_cancel,$cnt_non_order_item,$post_flag);
            //}
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

     public function actionGetfileno() {
        $searchTerm = trim($_GET['term']);
        $condition = 'ready_to_invoice = "Y" AND invoiced="N" AND status!="CN" AND ( file_id LIKE "%' . $searchTerm . '%" OR id LIKE "%' . $searchTerm . '%" OR order_id LIKE "%' . $searchTerm . '%") ';
        $model = DeliveryNote::model()->findAll(array('condition' => $condition, 'limit' => 200));
        foreach ($model as $i => $eachModel) {
            $data[$i]['value'] = $eachModel->file_id;
            $data[$i]['label'] = 'File : '.$eachModel->file_id.' DNote :'.$eachModel->id.' Order : '.$eachModel->order_id;
            $data[$i]['address'] = $eachModel->billing_address;
            $data[$i]['currency'] = $eachModel->order->currencyname->currency;
            $data[$i]['currency_id'] = $eachModel->order->currencyname->id;
            $data[$i]['exchangerate'] = $eachModel->order->currencyname->exchange_rate;
            $data[$i]['payment_term'] = $eachModel->order->payment_terms;
            $data[$i]['customer_id'] = $eachModel->customer_id;
            $data[$i]['customer_name'] = $eachModel->customer->customer_name;
            $data[$i]['contact_id'] = $eachModel->contact_id;
            $data[$i]['contact_name'] = $eachModel->order->customercontact->person_name;
            $data[$i]['customer_name'] = $eachModel->customer->customer_name;
            $data[$i]['sales_group'] = $eachModel->order->sales_group;
            $data[$i]['orderid'] = $eachModel->order_id;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    public function actionCreateInvoice()
    {
        $model=new Invoice();
        $id = (int) Yii::app()->request->getParam('id');
        $job_order_id=(int) Yii::app()->request->getParam('job_order_id');
        $file_id=(int) Yii::app()->request->getParam('file_id');
        $type= Yii::app()->request->getParam('type');
        $modelItems = array(new InvoiceItem);
        
        $posted_invoice="N";
        if($id > 0)
        {
            $model=$model->findByPk($id);
            $modelInvoiceItems = InvoiceItem::model()->findAll(array('condition'=>'invoice_id="'.$id.'"','order'=>'id ASC'));
            /*echo '<pre>';
            print_r($modelInvoiceItems);*/
            if(empty($modelInvoiceItems)){
                     $modelInvoiceItems = array(new InvoiceItem);
            }
            
            
            if($model->order_id > 0){
                 $modelJobOrder          = JobOrder::model()->findByPK($model->order_id);
            }
            
            $posted_invoice=$model->posted;
            
            
            
        }
        if($job_order_id > 0)
        {
            $modelJobOrder          = JobOrder::model()->findByPK($job_order_id);
            $modelJobOrderAgentDetails          = JobOrderAgentDetails::model()->with('activitytype')->findAll(array('condition'=>'job_order_id='.$job_order_id.' AND activitytype.to_show_invoice="Y"','order'=>'t.id ASC'));
            
            $model->file_id         = $modelJobOrder->file_id;
            $model->customer_id     = $modelJobOrder->customer_id;
            $model->order_id        = $job_order_id;
            $order_date             = $modelJobOrder->job_date;
            $order_date             = date("d/m/Y",strtotime($order_date));
            $model->order_date      = $order_date;
            $model->lead_owner_id   = $modelJobOrder->lead_owner_id;
            $model->currency        = $modelJobOrder->currency_id;
            $model->exchange_rate   = $modelJobOrder->exchange_rate;
            $model->reference       = $modelJobOrder->customer_reference_no;
            if((int) $model->customer_id > 0){
                $modelCustomer = Customer::model()->findByPk((int) $model->customer_id);
                $customer_address="";
                
                if(trim($modelCustomer->customer_postal_code)!=""){
                    $customer_address.="PO Box : ".trim($modelCustomer->customer_postal_code);
                }
                $customer_address = $modelCustomer->customer_address."\n";
                if(trim($modelCustomer->customer_city)!=""){
                    $customer_address.=trim($modelCustomer->customer_city).", ";
                }
                $customer_address.=$modelCustomer->country->country_name;
                $model->billing_address =$customer_address;
                $model->payment_terms   = $modelCustomer->customer_payment_term;
            }
            
            //$model->payment_terms   = $modelJobOrder->payment_terms_id;
            //To get transport charge details
            $modelInventory         = new Inventory(); 
            $modelInventory         = $modelInventory->find(array('condition'=>'default_service="Y"'));//get default Servcice
            
            $tax_percentage         = $modelInventory->tax;
            $unit_id                = $modelInventory->unit;
            //end
            $i=0;
            
            
            
            foreach($modelJobOrderAgentDetails as $eachJobOrderAgentDetails){
                
                //$description = $eachJobOrderAgentDetails->activitytype->activity_type."\nAgent: ".$eachJobOrderAgentDetails->shipper->vendor_name."\nAWB#: ".$eachJobOrderAgentDetails->awb_no."\nType: ".$eachJobOrderAgentDetails->activitytype->activity_type;
                
                $description = $eachJobOrderAgentDetails->activitytype->activity_type;
                $tax_percentage = $eachJobOrderAgentDetails->activitytype->tax_percentage;
                
                $modelInvoiceItems[$i] = new InvoiceItem;
                
                /*$modelInvoiceItems[$i]->product_id          =   $modelInventory['id'];
                $modelInvoiceItems[$i]->product_name        =   $modelInventory['part_number'];*/
                $modelInvoiceItems[$i]->product_id          =   $eachJobOrderAgentDetails->activitytype->id;
                $modelInvoiceItems[$i]->order_item_id       =   $eachJobOrderAgentDetails->id;
                $modelInvoiceItems[$i]->shipper_id          =   $eachJobOrderAgentDetails->shipper_id;
                $modelInvoiceItems[$i]->product_name        =   $eachJobOrderAgentDetails->activitytype->activity_type;
                //$modelInvoiceItems[$i]->description         =   $modelInventory['part_number']." for materials from ".$modelJobOrder->origin." to ".$modelJobOrder->destination." for ".$modelJobOrder->customer->customer_name." on ".date('d/m/Y',strtotime($modelJobOrder->job_date))." having Ref  ".$modelJobOrder->booking_reference;
                //$modelInvoiceItems[$i]->description         =   $modelInventory['description'];
                $modelInvoiceItems[$i]->description         =   $description;
                $modelInvoiceItems[$i]->quantity            =   1;
                $modelInvoiceItems[$i]->rate                =   $eachJobOrderAgentDetails->planned_selling_price;
                $modelInvoiceItems[$i]->unit_id             =   $unit_id;
                $modelInvoiceItems[$i]->amount              =   $eachJobOrderAgentDetails->planned_selling_price;
                $modelInvoiceItems[$i]->addition_percentage =   0;
                $modelInvoiceItems[$i]->addition_amount     =   0;
                $modelInvoiceItems[$i]->deduction_percentage =  0;
                $modelInvoiceItems[$i]->deduction_amount    =   0;
                $modelInvoiceItems[$i]->tax_vat_percentage  =   $tax_percentage;
                $modelInvoiceItems[$i]->tax_vat_amount      =   ($eachJobOrderAgentDetails->planned_selling_price * $tax_percentage)/100 ;
                $modelInvoiceItems[$i]->net_amount          =   $eachJobOrderAgentDetails->planned_selling_price;
                //$modelInvoiceItems[$i]->tax_vat_amount      =   ($modelJobOrder->selling_price * $tax_percentage)/100 ;
                //$modelInvoiceItems[$i]->net_amount          =   $modelJobOrder->selling_price;
                $i++;
            }
            
             $modelInvoice=new Invoice();
            $count_invoice =(int) $modelInvoice->count(array('condition' => 'order_id=' . $job_order_id));
                    
            
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false , 'jquery-2.1.4.min.js' => false);
        $this->render('create',array('model'=>$model,'file_id'=>$model->file_id,'modelInvoiceItems'=>$modelInvoiceItems,'modelJobOrder'=>$modelJobOrder,'type'=>$type,'count_invoice'=> $count_invoice,'posted_invoice'=>$posted_invoice));
    }
    
    public function actionSaveinvoice()
    {
            $modelInvoice = new Invoice;
            $tax_type = 1;
            $modelInvoice->scenario = 'add';
            $audit_type = 'CREATED';
            if ((int) @$_POST['Invoice']['id'] > 0){
                $audit_type = 'UPDATED';
                $modelInvoice->id = (int) $_POST['JobOrder']['id'];
                $modelInvoice->updated_by = Yii::app()->user->id;
                $modelInvoice->updated_datetime =date('Y-m-d h:i:s'); 
                $modelInvoice = $modelInvoice->findByPK((int) @$_POST['Invoice']['id']);
                $modelInvoice->scenario = 'update';
            } 
            $modelInvoice->scenario = 'update';
            $modelInvoice->attributes = $_POST['Invoice'];
            $modelInvoice->lpo = $_POST['Invoice']['lpo'];
            $modelInvoice->delivery_ids=$_POST['Invoice']['delivery_ids'];
            $modelInvoice->project_id=$_POST['Invoice']['project_id'];
            $modelInvoice->invoice_date= ( count( explode('/', $_POST['Invoice']['invoice_date']) ) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['Invoice']['invoice_date']))) : date('Y-m-d');
            $modelInvoice->crm_user_id = Yii::app()->user->id;
            $modelInvoice->order_lpo_no=$_POST['Invoice']['order_lpo_no'];
            $modelInvoice->order_lpo_date=$_POST['Invoice']['order_lpo_date'];
            $modelInvoice->created_by= Yii::app()->user->id;
            $modelInvoice->created_datetime = date('Y-m-d H:i:s');
            $modelInvoice->invoice_nature = "JO";
            $modelInvoice->contact_id=implode(",", $_POST['Invoice']['contact_id']);
            $modelInvoice->awb_no=$_POST['JobOrder']['job_awb_no'];
             //code added by mereena on 07/02/2020 for ckeditor content
            $modelInvoice->terms_and_conditions =  $_POST['Invoice']['terms_and_conditions'];
            
            
            //job order
            $count_invoice =0;
            if((int) $_POST['Invoice']['order_id'] > 0){
                    $modelJobOrder = new JobOrder();
                    $modelJobOrder= $modelJobOrder->findByPK((int) @$_POST['Invoice']['order_id']);
                    
                    $modelJobOrder->attributes = $_POST['JobOrder'];
                    //$modelJobOrder->shipper_id = $_POST['JobOrder']['shipper_id'];
                    
                    //$count_invoice = (int) Invoice::model()->count(array('condition' => 'order_id=' . $_POST['Invoice']['order_id']));
                    
            }
            //end
            
            
            $other_errors = $modelItem = $modelInvoiceAddition = $modelInvoiceDeduction = array();
            $grand_total = 0;
            $valid = $modelInvoice->validate();
            $i =0;
            
            
            foreach ($_POST['InvoiceItem'] as $item) {
                if ( $item['product_id'] > 0 ) {
                    
                    /*if ($item['id'] > 0) {
                        $modelItem[$i] = InvoiceItem::model()->findByPK($item['id']); 
                    } 
                    else 
                    {*/
                        $modelItem[$i] = new InvoiceItem;
                    //}
                    $modelItem[$i]->attributes = $item;
                    $modelItem[$i]->unit_id = $item['unit_id'];
                    $modelItem[$i]->invoice_item_nature ='S';
                    $modelItem[$i]->order_item_id =$item['order_item_id'];
                    $modelItem[$i]->shipper_id =$item['shipper_id'];
                    $modelItem[$i]->job_order_shipper_id =$item['job_order_shipper_id'];
                    //CODE ADDED BY MEREENA ON 24/02/2020
                    $modelItem[$i]->inventory_type = $item['inventory_type'];
                    //END
                    $valid = $modelItem[$i]->validate() && $valid;
                    $i++;
                    
                }
            }
            
            if((int) @$_POST['Invoice']['id'] == 0){
                
                $count_invoice = (int) Invoice::model()->count(array('condition' => 'order_id=' . $_POST['Invoice']['order_id']));
                if($count_invoice > 0){
                    $other_errors[] ="This job order already converted to invoice";
                }
            }
            
            

            if ( $valid && count($modelItem) > 0  && $count_invoice==0) {
                echo CJSON::encode(array('status'=>'success'));
     
                $modelInvoice->generateInvoice();
                $modelInvoice->save();
                
                if((int) $_POST['Invoice']['order_id'] > 0){
                    $modelJobOrder->save();
                }

                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'INVOICE',
                    Yii::app()->user->id,
                    $audit_type,
                    " with INV No: - {$modelInvoice->id}  "
                );
                // end audit log 
                
                $total_tax_amount=0;
                
                if(!empty($modelItem)){
                    InvoiceItem::model()->deleteAll('invoice_id=:refer_id', array(':refer_id' => $modelInvoice->id));
                    foreach ($modelItem as $eachItem) {
                        $eachItem->invoice_id = $modelInvoice->id;
                        $total_tax_amount+=$eachItem->tax_vat_amount;
                        //$eachItem->cost_rate = Store::model()->findBypk($eachItem->product_id)->rate;
                        //CODE ADDED BY MEREENA ON 24/02/2020
                        //$eachItem->inventory_type = $eachItem->inventory_type;
                        //END
                        $eachItem->save(false);
                        $grand_total += $eachItem->net_amount;
                        //To update job order agent details
                        if((int) $eachItem->order_item_id > 0 && $eachItem->job_order_shipper_id!=$eachItem->shipper_id){
                            JobOrderAgentDetails::model()->updateByPk($eachItem->order_item_id, array('shipper_id' => $eachItem->shipper_id)); 
                        }
                    }
                }
                
                $grand_total+=$total_tax_amount;
                $modelInvoice->updateByPk($modelInvoice->id, array('grand_total' => $grand_total,'total_tax_amount' => $total_tax_amount));
                JobOrder::model()->updateByPk($_POST['Invoice']['order_id'], array('job_order_status' => "I")); 
                MasterFile::model()->updateByPk($_POST['Invoice']['file_id'], array('current_process_status' => "I")); 
                
                
                
                
            } else {
                $error1 = json_decode(CActiveForm::validate($modelInvoice, '', false), true);
                if ( count($modelItem) > 0 )
                    $error2 = json_decode(CActiveForm::validateTabular($modelItem, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";
                //$error3 = json_decode(CActiveForm::validateTabular($modelInvoiceAddition, '', false), true);
                //$error4 = json_decode(CActiveForm::validateTabular($modelInvoiceDeduction, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1, $error2, $other_errors));
                if ($error != '[]')
                    echo $error;
            }
        
    }
    
    
     public function actionDocumentupload() {
        $file_id = Yii::app()->request->getparam("file_id");
        $modelDocument = Document::model()->find(array('condition' => 'file_id = "' . $file_id . '"'));
        if (empty($modelDocument)) {
            $modelDocument = new Document();
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->renderPartial('document_index', array('modelDocument' => $modelDocument, 'file_id' => $file_id), false, true);
    }
    
      public function actionPrintInvoiceReportPDF() {
        $model=new Invoice();
        $id = Yii::app()->request->getParam('id');
        $model_Invoice = Invoice::model()->findByPk($id);
        $c_id = Yii::app()->request->getParam('c_id');
        $frm = Yii::app()->request->getParam('frm');
        $barcode=Yii::app()->request->getParam('barcode');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        if($model_Invoice->invoice_status=='C'){
            $mPDF1->SetWatermarkText('CANCELLED');
            $mPDF1->showWatermarkText = true;
        }
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
       
        $mPDF1->WriteHTML($this->renderPartial('application.modules.logistics.views.pdf.invoice_list_individual_tax', array('model' => $model, 'id' => $id,'c_id'=>$c_id ,'title' => $title,'barcode'=>$barcode,'from'=>$frm),true));
        
        $pdf_file_name = $id.".pdf";
        if((int) $model_Invoice->customer_id > 0){
            $modelCustomer = Customer::model()->findByPk((int) $model_Invoice->customer_id);
            $pdf_file_name = $id."_".$modelCustomer->customer_name.".pdf";
            
        }
        $mPDF1->Output($pdf_file_name, 'I');
    }
    
     public function actionGetProducts() {
       
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = '(part_number LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%") AND type="S"';
       
        $model = new Inventory();
        
        $model = $model->with('taxDetails')->findAll(array('select' => 'id,part_number,description,unit,type,rate', 'condition' => $condition, 'limit' => 200));
       
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->part_number.' : '.$eachModel->description;
            $data[$i]['part_number'] = $eachModel->part_number;
            $data[$i]['description'] = $eachModel->description;
            $data[$i]['unit_id'] = $eachModel->units->id;
            $data[$i]['unit_name'] = $eachModel->units->unit_name;
            $data[$i]['tax_code'] = $eachModel->taxDetails;            
            $data[$i]['part_no'] = $eachModel->part_number;           
            $data[$i]['other'] = $eachModel->type;
            $data[$i]['rate']=$eachModel->rate;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    
    public function actionGetunitdrop(){
        $row = $_POST['row_field'];
        $product = $_POST['product_id'];
        $type = $_POST['type'];
        $item_type = $_POST['item_type'];
        $drop = array();
        $modelInvoiceItem = new InvoiceItem;
        if($product > 0){
                $unit_id = $_POST['unit_id'];
                $modelInvoiceItem->unit_id = $unit_id;
                $drop['drop'] = CHtml::activedropdownlist($modelInvoiceItem, "[" . $row . "]unit_id",MasUnit::getSimilarUnits($unit_id), array('class'=>'unit go'));
           
        }
        echo CJSON::encode($drop);
    }
    
    public function actionSendPostedInvoice(){
        $model=new Invoice();
        $id = (int) Yii::app()->request->getParam('id');
        $modelInvoice = Invoice::model()->findByPk($id);
        $customer_id = (int) $modelInvoice->customer_id;
        
        $SQL = "SELECT GROUP_CONCAT(DISTINCT(awb_no)) as awb_no FROM `erp_job_order_agent_details` WHERE job_order_id=".$modelInvoice->order_id;
        $arr_job_order_details = Yii::app()->db->createCommand($SQL)->queryRow();
      
        $c_id = "";
        $frm = "";
        $barcode="";
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $folder = Yii::getPathOfAlias('webroot') . '/upload/invoice/';
        
        $filename = $id.".pdf";
        if($customer_id > 0){
            $modelCustomer = Customer::model()->findByPk($customer_id);
            $filename = $id."_".$modelCustomer->customer_name.".pdf";
            
        }
        
        $mPDF1->WriteHTML($this->renderPartial('application.modules.logistics.views.pdf.invoice_list_individual_tax', array('model' => $model, 'id' => $id,'c_id'=>$c_id ,'title' => $title,'barcode'=>$barcode,'from'=>'mail'),true));
        $mPDF1->Output($folder.$filename,'F');
        
        //$mailContent['salutation']      = $eachContact->person_name;
        $mailContent['salutation']      = 'Customer';
        $mailContent['company_name']    = Yii::app()->user->master_company_name;
        $mailContent['awb_no']          = $arr_job_order_details['awb_no'];
        $message = new YiiMailMessage;
        $message->view = 'email_invoice';
        $message->setBody(array('mailContent' => $mailContent), 'text/html');
        $message->subject ='Invoice for AWB # '.$arr_job_order_details['awb_no']; 
        //$message->from ='updates@infinitylogisticsme.com';
        //$message->from ='invoicing@infinitylogisticsme.com';
        $message->from = 'Receivables@infinitylogisticsme.com';
                
        $count_email=0;
        if((int) $modelInvoice->lead_owner_id > 0){
            $lead_owner_id = (int) $modelInvoice->lead_owner_id;
            $arr_lead_owner_details = User::model()->findByPk($lead_owner_id);
            
            $lead_owner_email = $arr_lead_owner_details->email;
            
            $message->addTo($lead_owner_email);
            
            $count_email++;
        }
        
        
        $arr_customer_contact_details = CustomerContact::model()->findAll(array('condition'=>'id IN('.$modelInvoice->contact_id.')'));
        
        if(count($arr_customer_contact_details) > 0){
           
            foreach($arr_customer_contact_details as $eachContact){
                if(!empty($eachContact->contact_email_id)){
                    $message->addTo($eachContact->contact_email_id);
                    $count_email++;
                }
            }
        }
        
        if($count_email > 0){
            
            //$message->addTo('mereena.cumulus@gmail.com');
            //$message->addBcc('updates@infinitylogisticsme.com');
            $message->addBcc('invoicing@infinitylogisticsme.com');
            $message->addBcc('accounts@infinitylogisticsme.com');
            $file_path = Yii::getPathOfAlias('webroot') . '/upload/invoice/'.$filename;
            $swiftAttachment = Swift_Attachment::fromPath($file_path);              
            $message->attach($swiftAttachment);
            
            Yii::app()->mail->send($message); 
            echo "success";
        }
        else{
            echo "failed";
        }
        
        
        
        
       
        
    }
    
    
    public function actionGetActivityType() {
       
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = 'activity_type LIKE "%' . $searchTerm . '%"';
       
        $model = new MasJobOrderActivityType();
        
        $model = $model->findAll(array('select' => 'id,activity_type,tax_percentage', 'condition' => $condition, 'limit' => 200));
       
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->activity_type;
            $data[$i]['part_number'] = $eachModel->activity_type;
            $data[$i]['tax_code'] = $eachModel->tax_percentage;          
           
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    
    public function actionUpdateJoborderItem(){
        $id = (int) Yii::app()->request->getParam('id');
        $modelInvoiceItem       = new InvoiceItem();
        $modelInvoiceItem           = $modelInvoiceItem->with('invoice')->findAll(array('condition'=>'invoice_id='.$id.' AND order_item_id=0'));
        
        $i=0;
        foreach($modelInvoiceItem as $eachItem){
            $model[$i] = new JobOrderAgentDetails();
            
            $model[$i]->shipper_id          =   $eachItem->shipper_id;
            $model[$i]->job_order_id        =   $eachItem->invoice->order_id;
            $model[$i]->awb_no              =   $eachItem->invoice->awb_no;
            $model[$i]->activity_type       =   "";
            $model[$i]->planned_weight      =   '0.00';
            $model[$i]->planned_volume      =   '0.00';
            $model[$i]->planned_cost        =   '0.00';
            $model[$i]->planned_selling_price       =   $eachItem->rate;
            $model[$i]->actual_weight       =   '0.00';
            $model[$i]->actual_cost         =   '0.00';
            $model[$i]->status              =   16;//completed
            $model[$i]->notes               =   "Updated from invoice";
            
            //to update invoice item order item id
            $model[$i]->invoice_item_id          =   $eachItem->id;
            
            $i++;
        }
       /* echo '<pre>';
        print_r($model);*/
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->renderPartial('update_job_order_item', array('modelJobOrderAgentDetails' => $model), false, true);
        
    }
    
    public function actionUpdateJoborderAgentDetails(){
        
        foreach ($_POST['JobOrderAgentDetails'] as $eachItem) {
            
                if ( $eachItem['job_order_id'] > 0 ) {
                    $modelJobOrderAgentDetails = new JobOrderAgentDetails;
                    $modelJobOrderAgentDetails->shipper_id              =   $eachItem['shipper_id'];
                    $modelJobOrderAgentDetails->job_order_id            =   $eachItem['job_order_id'];
                    $modelJobOrderAgentDetails->awb_no                  =   $eachItem['awb_no'];
                    $modelJobOrderAgentDetails->activity_type           =   $eachItem['activity_type'];
                    $modelJobOrderAgentDetails->planned_weight          =   $eachItem['planned_weight'];
                    $modelJobOrderAgentDetails->planned_volume          =   $eachItem['planned_volume'];
                    $modelJobOrderAgentDetails->planned_cost            =   $eachItem['planned_cost'];
                    $modelJobOrderAgentDetails->planned_selling_price   =   $eachItem['planned_selling_price'];
                    $modelJobOrderAgentDetails->actual_weight           =   $eachItem['actual_weight'];
                    $modelJobOrderAgentDetails->actual_volume           =   $eachItem['actual_volume'];
                    $modelJobOrderAgentDetails->actual_cost             =   $eachItem['actual_cost'];
                    $modelJobOrderAgentDetails->status                  =   $eachItem['status'];
                    $modelJobOrderAgentDetails->notes                   =   $eachItem['notes'];
                    $modelJobOrderAgentDetails->save(false);
                    
                    
                    if((int) $modelJobOrderAgentDetails->id > 0){
                        InvoiceItem::model()->updateByPk($eachItem['invoice_item_id'], array('order_item_id' => (int) $modelJobOrderAgentDetails->id)); 
                    }
                    
                }
            }
            
            echo CJSON::encode(array('status'=>'success'));
    }
    
    public function actionUpdateCustomer(){
        $model=new Invoice();
        $id = (int) Yii::app()->request->getParam('id');
        if($id > 0)
        {
            $model=$model->findByPk($id);
            $model->customer_id=0;
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->renderPartial('update_customer_details', array('model' => $model), false, true);
    }
    
    public function actionUpdateCustomerSubmit(){
        
         $invoice_id    = (int) $_POST['Invoice']['id'];
         $customer_id   = (int) $_POST['Invoice']['customer_id'];
         $job_order_id  = (int) (int) $_POST['Invoice']['order_id']; 
         if($invoice_id > 0){
             $invoice_contact_id    =   implode(",", $_POST['Invoice']['contact_id']);
             $job_order_contact_id  =   implode(",", $_POST['JobOrder']['contact_ids']);
             JobOrder::model()->updateByPk($job_order_id, array('customer_id' => $customer_id,'contact_ids'=>$job_order_contact_id));
             Invoice::model()->updateByPk($invoice_id, array('customer_id' => $customer_id,'contact_id'=>$invoice_contact_id)); 
             $jsonData['status'] = "success";
        
         }
         else{
             $jsonData['status'] = "failed";
         }
         
         echo json_encode($jsonData);
    }
}
