<?php

class InventoryController extends Controller {

    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','GetList', 'GetListSalesman','Create','Save','GetProducts','EnableDisable','EditCostRate','SaveCostRate','Service'
                    ,'availabiltychart','AjaxChangeBin','resetAvailabilityContent','PrintCustomerProductStockTransactionExcel','GetServiceList','CreateService','SaveInventoryService'),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        
    $this->render('index');
    
    }
    /*public function actionGetListSalesman() {
        $draw   = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $type = $_POST['type'];
        $brand = $_POST['brand'];
        $stock = $_POST['stock'];
        $created_user = $_POST['created_user'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'part_number',
            1 => 'part_number',
            2 => 'description',
            3 => 'type',
            4 => 'brand_name',
            5 => 'qty',
            6 => 'unit_name',
            7 => 'rate',
            8 => 'tax',
            10=>'active'
        );
        $filterColumn   = $columns[$_POST['order'][0]['column']];
        $filterOrder    = $_POST['order'][0]['dir'];
        $orderBy        = $filterColumn . " " . $filterOrder;
        $condition      = '1=1 ';
        if($type!='')
        {
        $condition.=' AND I.type="'.$type.'"';    
        }
        if($brand>0)
        {
            $condition.=' AND I.brand='.$brand;    
        }
        if($created_user >0)
        {
            $condition.=' AND (S.created_by='.$created_user.' OR S.type="OB" )';    
        }
        else if(Yii::app()->user->user_access_type == 'SL')
        {
            $condition.=' AND (S.created_by='.Yii::app()->user->id.' OR S.type="OB" )';    
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" AND (I.part_number LIKE '%" . $searchString . "%' OR I.description LIKE '%" . $searchString . "%')";
        }
        if($stock==''){
            $stockcondition ='1=1';
        }else{
            if($stock==2){
                $stockcondition ='A.qty=0';
            }else{
                $stockcondition ='A.qty>0';
            }
        }
        $SQL="CREATE OR REPLACE VIEW erp_inventory_list AS
        (SELECT I.id,I.part_number,I.description,I.active,B.brand_name,I.type,SUM(S.quantity*S.unit_exchange_rate) AS in_qty,
        0 AS out_qty,U.unit_name,CASE
        WHEN SUM(S.quantity*S.unit_exchange_rate) > 0 THEN SUM(S.quantity*S.rate)/SUM(S.quantity*S.unit_exchange_rate) ELSE 0 END AS avg_purchase_rate,0 AS avg_sales_rate,tax,O.name,O.outlet_name
        ,I.rate 
        FROM erp_inventory I 
        LEFT JOIN erp_stock_ledger S ON I.id=S.product_id 
        LEFT JOIN erp_master_brand B ON I.brand=B.id 
        LEFT JOIN erp_master_unit U ON I.unit=U.id 
        LEFT JOIN bluesell_new_main.erp_outlets O ON I.outlet=O.id where $condition AND (S.transaction_type='IN' OR S.type='OB') group by I.id)
        UNION
        (SELECT I.id,I.part_number,I.description,I.active,B.brand_name,I.type,0 AS in_qty,SUM(S.quantity*S.unit_exchange_rate) AS out_qty,
        U.unit_name,0 AS avg_purchase_rate,CASE
        WHEN SUM(S.quantity*S.unit_exchange_rate) > 0 THEN SUM(S.quantity*S.rate)/SUM(S.quantity*S.unit_exchange_rate) ELSE 0 END AS avg_sales_rate,0 AS tax,O.name,O.outlet_name,I.rate 
        FROM erp_inventory I 
        LEFT JOIN erp_stock_ledger S ON I.id=S.product_id 
        LEFT JOIN erp_master_brand B ON I.brand=B.id 
        LEFT JOIN erp_master_unit U ON I.unit=U.id 
        LEFT JOIN bluesell_new_main.erp_outlets O ON I.outlet=O.id where $condition AND (S.transaction_type='OUT' OR S.type='OB')  group by I.id)";
        Yii::app()->db->createCommand($SQL)->execute();
        $model=Yii::app()->db->createCommand("SELECT * FROM(SELECT id,part_number,description,active,brand_name,type,SUM(in_qty) AS in_qty,SUM(out_qty) AS out_qty,SUM(in_qty)-SUM(out_qty) AS qty,
        unit_name,SUM(avg_purchase_rate) AS avg_purchase_rate,SUM(avg_sales_rate) AS avg_sales_rate,SUM(tax) AS tax,name,outlet_name,rate from erp_inventory_list group by id )A WHERE ".$stockcondition." order by $orderBy limit $limit offset $offset")->queryAll();
        $counts=Yii::app()->db->createCommand("SELECT * FROM(SELECT id,part_number,description,active,brand_name,type,SUM(in_qty) AS in_qty,SUM(out_qty) AS out_qty,SUM(in_qty)-SUM(out_qty) AS qty,
        unit_name,SUM(avg_purchase_rate) AS avg_purchase_rate,SUM(avg_sales_rate) AS avg_sales_rate,SUM(tax) AS tax,name,outlet_name,rate from erp_inventory_list group by id )A WHERE ".$stockcondition." order by $orderBy")->queryAll();
        
        $query = "select part_number,description,brand,unit,type,barcode,tax,generic_id,B.brand_name,U.unit_name from erp_inventory I INNER JOIN erp_mas_unit U ON I.unit=U.id INNER JOIN erp_mas_brand B ON I.brand=B.id where $condition limit $limit offset $offset";    

        $count          = count($counts);
        $rowData                = array();
        $recordsTotal   = $count;
        $recordsFiltered        = $count;
        $data['draw']   = $draw;
        $data['recordsTotal']   = $recordsTotal;
        $data['recordsFiltered']= $recordsFiltered;
        $rowData                = array();
        foreach ($model as $i=>$row)
        {
            
            $inv_type=($row['type']=='I')? "Inventory" : "Service";
            $cost='';
            $qty='';
            $avg_purchase_rate = StockLedger::getAvgPurchaseRate($row['id'],'',$outlet);//$avg_purchase_rate = $row['avg_purchase_rate']
            $div= '<div class="text-center">';
            if($row['active']=='Y'){
                $div .= '<button class="btn btn-primary btn-xs" title ="Edit" onclick="loadPopupModal(\'logistics/inventory/create&id='.$row['id'].'\',\'Edit - '.$row['part_number'].'\',\'lg\')"><i class="fa fa-edit" aria-hidden="true"></i></button>';
                $div.= ' <button class="btn btn-danger btn-xs" title ="Block" onclick="block('.$row['id'].',1)"><i class="fa fa-ban" aria-hidden="true"></i></button>';
            }else{
                $div.= ' <button class="btn btn-theme btn-xs" title ="UnBlock" onclick="block('.$row['id'].',2)"><i class="fa fa-unlock" aria-hidden="true"></i></button>';
            }
            $div.= '</div>';
            $rowData[]  = array(($i+1),$row['part_number'],$row['description'],$inv_type,$row['brand_name'],round($row['qty'],3),$row['unit_name'],Yii::app()->numberFormatter->formatCurrency($row['rate'], " "),Yii::app()->numberFormatter->formatCurrency($row['tax'], " ").'%',$div,$row['active']);
            
        } 
        $data['data'] = $rowData;
        echo json_encode($data);
    }*/
    public function actionGetList() {
        $draw   = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $customer_id    = $_POST['customer_id'];
        /*$ware_house_id  = $_POST['ware_house_id'];
        $rack_id        = $_POST['rack_id'];
        $bin_id         = $_POST['bin_id'];*/
        $inv_type       = $_POST['inv_type'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'part_number',
            
        );
        $filterColumn   = $columns[$_POST['order'][0]['column']];
        $filterOrder    = $_POST['order'][0]['dir'];
        $orderBy        = $filterColumn . " " . $filterOrder;
        
        $condition='inventory.type="'.$inv_type.'" AND inventory.isActive="Y"';
       
        if($customer_id>0)
        {
            $condition.=' AND customer_id='.$customer_id;    
        }
        
        /*if($ware_house_id>0)
        {
            $condition.=' AND SL.warehouse_id='.$ware_house_id;    
        }
        
        if($rack_id>0)
        {
            $condition.=' AND SL.rack_id='.$rack_id;    
        }
        
        if($bin_id>0)
        {
            $condition.=' AND bin_id='.$bin_id;    
        }*/
        
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" AND (part_number LIKE '%" . $searchString . "%' OR description LIKE '%" . $searchString . "%' OR customer_name LIKE '%" . $searchString . "%')";
        }
        
        //$model = Yii::app()->db->createCommand("select I.id,part_number,description,brand,unit,type,barcode,tax,generic_id,B.brand_name,U.unit_name,I.active from erp_inventory I INNER JOIN erp_mas_unit U ON I.unit=U.id INNER JOIN erp_mas_brand B ON I.brand=B.id where $condition limit $limit offset $offset")->queryAll();
        
        $SQL ="SELECT inventory.id,inventory.id as product_id,part_number,description,inventory.length,inventory.width,inventory.height,inventory.isActive as active,customer_name,
                inventory.customer_id,U.unit_name 
                FROM `erp_inventory` as inventory 
                LEFT JOIN erp_mas_unit U ON inventory.unit=U.id 
                LEFT JOIN erp_customer AS customer ON customer.id=inventory.customer_id 
                WHERE ".$condition." GROUP BY customer_id,product_id ORDER BY part_number  limit ".$limit." offset ".$offset;
        
        //echo $SQL;
        
        $SQL_COUNT = "SELECT inventory.id,inventory.id as product_id,part_number,description,inventory.length,inventory.width,inventory.height,inventory.isActive as active,customer_name,
                inventory.customer_id,U.unit_name 
                FROM `erp_inventory` as inventory 
                LEFT JOIN erp_mas_unit U ON inventory.unit=U.id 
                LEFT JOIN erp_customer AS customer ON customer.id=inventory.customer_id 
                WHERE ".$condition." GROUP BY customer_id,product_id ORDER BY part_number";
        
        $model = Yii::app()->db->createCommand($SQL)->queryAll(); 
        $modelCount = Yii::app()->db->createCommand($SQL_COUNT)->queryAll();
        $rowData                = array();
        $count                  = count($modelCount);
        $m=1;
        foreach ($model as $i=>$row)
        {
            
            $cbm_length  = $row['length'] / 100;
            $cbm_width   = $row['width'] / 100;
            $cbm_height  = $row['height'] / 100;
            $SQL_IN = "select SUM(quantity*unit_exchange_rate) from erp_stock_ledger where product_id=" . $row['id'] . " AND  transaction_type='IN'";// AND transaction_date<='".date('Y-m-d')."'
            $stocks_in = Yii::app()->db->createCommand($SQL_IN)->queryScalar();
            $SQL_OUT = "select SUM(quantity*unit_exchange_rate) from erp_stock_ledger where product_id=" .$row['id'] . " AND transaction_type='OUT'";// AND transaction_date<='".date('Y-m-d')." '
            $stocks_out = Yii::app()->db->createCommand($SQL_OUT)->queryScalar();
            $stock = $stocks_in - $stocks_out;
            
            $total_cbm =($cbm_length*$cbm_width*$cbm_height)*$stock;
            
            $div= '<div class="text-center">';
            
            if($row['active']=='Y'){
                $div .= '<button class="btn btn-primary btn-xs" title ="Edit" onclick="loadPopupModal(\'logistics/inventory/create&id='.$row['product_id'].'\',\'Edit - '.$row['part_number'].'\',\'lg\')"><i class="fa fa-edit" aria-hidden="true"></i></button>';
                    //$div.= ' <button class="btn btn-danger btn-xs" title ="Block" onclick="block('.$row['id'].',1)"><i class="fa fa-ban" aria-hidden="true"></i></button>';
            }else{
            //$div.= ' <button class="btn btn-theme btn-xs" title ="UnBlock" onclick="block('.$row['id'].',2)"><i class="fa fa-unlock" aria-hidden="true"></i></button>';
            }
            $div.= ' <button class="btn btn-primary btn-xs" title ="Stock Transaction List" onclick="GetStockTransactionList('.$row['customer_id'].','.$row['product_id'].')"><i class="fa fa-file-excel-o" aria-hidden="true"></i></button>';
            $div.= '</div>';
            $rowData[]  = array($m,$row['customer_name'],$row['part_number'],$row['description'],Yii::app()->numberFormatter->formatCurrency($stock,""),$row['unit_name'],Yii::app()->numberFormatter->formatCurrency($row['length'],""),Yii::app()->numberFormatter->formatCurrency($row['width'],""),Yii::app()->numberFormatter->formatCurrency($row['height'],""),Yii::app()->numberFormatter->formatCurrency($total_cbm,"")/*,$row['warehouse_name'],$row['rack_name'],$row['bin_name']*/,$div);
            $m++;
            
        } 
        $data['data'] = $rowData;
        $recordsTotal   = $count;
        $recordsFiltered  = $count;
        $data['draw']   = $draw;
        $data['recordsTotal']   = $recordsTotal;
        $data['recordsFiltered']= $recordsFiltered;
        echo json_encode($data);
    }
    public function actionCreate() {
       $id = (int) Yii::app()->request->getParam('id');
        $model = new Inventory;
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('create', array('model' => $model));
    }
    
    public function actionSave() {
        $model = new Inventory();
        if (isset($_POST['Inventory'])) {

            if ($_POST['Inventory']['id'] > 0) {
                $id =  $_POST['Inventory']['id'];
                $model = $model->findByPK($id);

                $model->updated_time =date('Y-m-d h:i:s');
                $scene = 'update';
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_time = date('Y-m-d H:i:s');
                $scene = 'new';
               
            }
            $model->attributes = $_POST['Inventory'];
            $model->customer_id = $_POST['Inventory']['customer_id'];
            if($model->barcode=='')
            {
            $model->barcode = $model->part_number;
            }
            $valid=$model->validate();   
            if($valid){
                $model->tax=MasInvTax::model()->findByPk($model->tax_code)->percentage;
                $model->part_number=strtoupper(trim($model->part_number));    
                $model->save();
                StockLedger::model()->deleteAll(array('condition'=>'product_id='.$model->id.' AND type="OB" AND transaction_type="IN"'));
                $stockledger = new StockLedger;
                $stockledger->transaction_date=date('Y-m-d');
                $stockledger->transaction_type='IN';
                $stockledger->type='OB';
                $stockledger->customer_vendor_id=$_POST['Inventory']['customer_id'];
                $stockledger->header_id=0;
                $stockledger->item_id=0;
                $stockledger->product_id=$model->id;
                $stockledger->rate=0;
                $stockledger->currency=1;
                $stockledger->exchange_rate=1;
                $stockledger->quantity=0;
                $stockledger->unit=$model->unit;
                $stockledger->default_product_unit=$model->units->base_unit_id;
                $stockledger->unit_exchange_rate=$model->units->unit_exchange_rate;
                $stockledger->created_by=Yii::app()->user->id;
                $stockledger->created_time=date('Y-m-d H:i:s');
                $stockledger->length = $_POST['Inventory']['length'];
                $stockledger->breadth = $_POST['Inventory']['width'];
                $stockledger->height = $_POST['Inventory']['height'];
                $stockledger->weight = $_POST['Inventory']['weight'];
                $stockledger->volume = $_POST['Inventory']['volume'];
                $stockledger->save(false);
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }
            else {
            $error1 = json_decode(CActiveForm::validate($model, '', false), true);
            $error = CJSON::encode(array_merge_recursive($error1));
            if ($error != '[]')
                echo $error;    
            }
        }
    }
    public function actionGetProducts() {
        $from = $_GET['frm'];
        $customer_id = $_GET['customer_id'];
        $vendor_id= $_GET['vendor_id'];
        $searchTerm = $_GET['term'];
        $outlet_id=Yii::app()->user->outlet_id;
        $consider_previous_sprice = MasOutlets::model()->findByPk($outlet_id)->consider_previous_sprice;
        if( Yii::app()->user->user_access_type == 'SU'||Yii::app()->user->user_access_type == 'DEV' ||  Yii::app()->user->user_access_type == 'SM' || Yii::app()->user->user_access_type == 'OM' ) {  
            $condition = '(part_number LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%")';
        }else
        $condition = '(part_number LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%" OR barcode LIKE "%' . $searchTerm . '%")  AND t. outlet='.$outlet_id;
        if($from=='PI' || $from=='GR' ){
            $condition .=' AND t.active="Y"';
        }
        $model = new Inventory();
        $model = $model->findAll(array('select' => 't.id,t.part_number,t.description,t.rate,t.tax,t.unit,t.excise_tax', 'condition' => $condition, 'limit' => 20));
        $i = 0;
        $data=array();
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->part_number.' : '.$eachModel->description;
            $data[$i]['part_number'] = $eachModel->part_number;
            $data[$i]['description'] = $eachModel->description;
            if($consider_previous_sprice=='Y' && $from=='SI'){
                $mod_pre_his = StockLedger::model()->with('sales_det')->find(array('condition'=>'t.type ="SI" and sales_det.customer_id ='.$customer_id.' AND product_id ='.$eachModel->id,'order'=>'t.id DESC'));
                if(empty($mod_pre_his))
                $data[$i]['rate'] = $eachModel->rate;
                else{
                    if($mod_pre_his->unit_exchange_rate *$eachModel->unit_exchange_rate>0)
                    {
                    $rate=$mod_pre_his->rate/$mod_pre_his->unit_exchange_rate *$eachModel->unit_exchange_rate;
                    }
                    else {
                    $rate=$eachModel->rate;    
                    }
                    $data[$i]['rate'] =$rate;
                }
            }else{
                if($from=='PI'){
                    $mod_pre_his = StockLedger::model()->with('pur_det')->find(array('condition'=>'t.type ="PI" and pur_det.vendor_id ='.$vendor_id.' AND product_id ='.$eachModel->id,'order'=>'t.id DESC'));
                    if(empty($mod_pre_his))
                        $data[$i]['rate'] = 0;
                    else{
                        if($mod_pre_his->unit_exchange_rate *$eachModel->unit_exchange_rate>0)
                        {
                        $data[$i]['rate'] =$mod_pre_his->rate/$mod_pre_his->unit_exchange_rate *$eachModel->unit_exchange_rate;
                        }
                        else {
                        $data[$i]['rate'] = 0;    
                        }
                    }
                }
                else               
                    $data[$i]['rate'] = $eachModel->rate;
            }
            //$data[$i]['cost'] = Yii::app()->db->createCommand("SELECT avg_purchase_rate from erp_inventory_list WHERE id=".$eachModel->id." AND in_qty>0")->queryScalar();
            $data[$i]['cost'] =StockLedger::getAvgPurchaseRate($eachModel->id,'',Yii::app()->user->outlet_id);
            $data[$i]['uom'] = $eachModel->unit;
            $data[$i]['uom_symbol'] = $eachModel->units->label;
            $data[$i]['tax'] = $eachModel->tax;
            $data[$i]['excise_tax'] = $eachModel->excise_tax;
            $data[$i]['unit_exchange']=$eachModel->unit_exchange_rate;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    public function actionEnableDisable(){
        $id    = $_POST['id'];
        $status    = $_POST['status'];
        $model = Inventory::model()->findByPk($id);
        if($status==1)
        $model->active ='N';
        else
        $model->active ='Y';
        $model->save(false);
        $data['status'] = 'success';
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    public function actionEditCostRate() {
       $id = (int) Yii::app()->request->getParam('id');
        $model = new Inventory;
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('edit_cost_rate', array('model' => $model));
    }
    public function actionSaveCostRate()
    {
    $cost=abs($_POST['Inventory']['cost']);
    $product_id=$_POST['Inventory']['id'];
    $outlet=Yii::app()->user->outlet_id;
     if($product_id>0)
     {
     $model=Inventory::model()->findByPk($product_id);
    // inserting to audit log
    $change_type = 'UPDATED';
    AuditLog::saveAuditLogs(3,Yii::app()->user->id,$change_type," Product ID : ".$product_id." Product : ".$model->description." Cost : ".$cost);
    // end audit log
    $SQL="update erp_stock_ledger SET rate=$cost where product_id=$product_id AND outlet=$outlet AND (type='GR' OR type='MTM')"; 
    Yii::app()->db->createCommand($SQL)->execute();
     }
    $data['status'] = 'success';
    echo CJSON::encode($data);
    Yii::app()->end();
    }
    
     public function actionService() {
        
    $this->render('service_index');
    
    }
    public function actionAvailabiltychart(){
        $this->render('availabiltychart');
    }
    public function actionresetAvailabilityContent(){
        $this->renderPartial('contentsavailability', array()); 
    }
    public function actionAjaxChangeBin(){
        $other          = array();$valid=true;        
        $origin_bin     = $_POST['origin_bin'];
        $destiny_bin    = $_POST['destiny_bin'];
        $model_destiny_bin = MasInvBin::model()->findByPk((int)$destiny_bin);
        $model_orgin_bin = MasInvBin::model()->findByPk((int)$origin_bin);
        
        if(empty($origin_bin)){
            $other[]='Origin Bin not Exist';
            $valid=false;
        }else if(empty($model_destiny_bin)){
            $other[]='Destination Bin not Exist';
            $valid=false;
        }else{
            $StockledgerIn = StockLedger::model()->find(array('condition' => 't.bin_id=' . $model_orgin_bin->id.' AND transaction_type="IN"', 'order' => 't.id DESC'));
            if($model_destiny_bin->maximum_weight<(int)$StockledgerIn->weight||$model_destiny_bin->maximum_volume<(int)$StockledgerIn->volume){
                $other[]='Maximum weight or volume exceeded';
                $valid=false;
            }else{
            
                $model=new HistoryChangeRackbin();
                $model->old_bin_id= $origin_bin;
                $model->new_bin_id =$destiny_bin;
                $model->old_stockledger_id =$StockledgerIn->id;
                $model->product_id =$StockledgerIn->product_id;
                $model->quantity =$StockledgerIn->quantity;
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
                $model->save();
                $StockLedger = new StockLedger;
                $StockLedger->transaction_date = date('Y-m-d');
                $StockLedger->transaction_type = 'OUT';
                $StockLedger->type = 'CRB';
                $StockLedger->customer_vendor_id = $StockledgerIn->customer_vendor_id;
                $StockLedger->file_id = 0;
                $StockLedger->header_id = $model->id;
                $StockLedger->item_id = 0;
                $StockLedger->product_id = $StockledgerIn->product_id;
                $inventory = Inventory::model()->findByPk($StockledgerIn->product_id);
                $StockLedger->brand_id = $inventory->brand;
                $StockLedger->rate = $StockledgerIn->rate;
                $StockLedger->currency = 1;
                $StockLedger->exchange_rate = 1;
                $StockLedger->quantity = $StockledgerIn->quantity;
                $StockLedger->unit = $StockledgerIn->unit;
                $StockLedger->default_product_unit = $StockledgerIn->default_product_unit;
                $StockLedger->unit_exchange_rate = $StockledgerIn->unit_exchange_rate;
                $StockLedger->warehouse_id = $StockledgerIn->warehouse_id;
                $StockLedger->rack_id = $StockledgerIn->rack_id;
                $StockLedger->bin_id = $StockledgerIn->bin_id;
                $StockLedger->batch_no = $StockledgerIn->batch_no;
                $StockLedger->serial_no = $StockledgerIn->serial_no;
                $StockLedger->manufacturing_date = $StockledgerIn->manufacturing_date;
                $StockLedger->expiry_date = $StockledgerIn->expiry_date;
                $StockLedger->bill_of_entry_exit = $StockledgerIn->bill_of_entry_exit;
                $StockLedger->hs_code = $StockledgerIn->hs_code;
                $StockLedger->in_stockledger_id = $StockledgerIn->id;
                $StockLedger->stock_updated= 'Y';
                $StockLedger->created_by= Yii::app()->user->id;
                $StockLedger->created_time= date('Y-m-d H:i:s');
                $StockLedger->save(false);

                $StockLedgerO = new StockLedger;
                $StockLedgerO->transaction_date = date('Y-m-d');
                $StockLedgerO->transaction_type = 'IN';
                $StockLedgerO->type = 'CRB';
                $StockLedgerO->customer_vendor_id = $StockledgerIn->customer_vendor_id;
                $StockLedgerO->file_id = 0;
                $StockLedgerO->header_id = $model->id;
                $StockLedgerO->item_id = 0;
                $StockLedgerO->product_id = $StockledgerIn->product_id;
                $inventory = Inventory::model()->findByPk($StockledgerIn->product_id);
                $StockLedgerO->brand_id = $inventory->brand;
                $StockLedgerO->rate = $StockledgerIn->rate;
                $StockLedgerO->currency = 1;
                $StockLedgerO->exchange_rate = 1;
                $StockLedgerO->quantity = $StockledgerIn->quantity;
                $StockLedgerO->unit = $StockledgerIn->unit;
                $StockLedgerO->default_product_unit = $StockledgerIn->default_product_unit;
                $StockLedgerO->unit_exchange_rate = $StockledgerIn->unit_exchange_rate;
                $StockLedgerO->warehouse_id = $model_destiny_bin->rack->warehouse_id;
                $StockLedgerO->rack_id = $model_destiny_bin->rack_id;
                $StockLedgerO->bin_id = $model_destiny_bin->id;
                $StockLedgerO->batch_no = $StockledgerIn->batch_no;
                $StockLedgerO->serial_no = $StockledgerIn->serial_no;
                $StockLedgerO->manufacturing_date = $StockledgerIn->manufacturing_date;
                $StockLedgerO->expiry_date = $StockledgerIn->expiry_date;
                $StockLedgerO->bill_of_entry_exit = $StockledgerIn->bill_of_entry_exit;
                $StockLedgerO->hs_code = $StockledgerIn->hs_code;
                $StockLedgerO->in_stockledger_id = 0;
                $StockLedgerO->stock_updated= 'Y';
                $StockLedgerO->created_by= Yii::app()->user->id;
                $StockLedgerO->created_time= date('Y-m-d H:i:s');
                $StockLedgerO->save(false);  
                if ($model_orgin_bin->id > 0) {
                    $bin = MasInvBin::model()->findByPk($model_orgin_bin->id);
                    $bin->is_free = "Y";
                    $bin->save(false);
                } 
                if ($model_destiny_bin->id > 0) {
                    $bin = MasInvBin::model()->findByPk($model_destiny_bin->id);
                    $bin->is_free = "N";
                    $bin->save(false);
                } 
                if ($model_orgin_bin->rack_id > 0) {
                    $model_origin_rack =MasInvRack::model()->findBYPK($model_orgin_bin->rack_id);            
                    $origin_bins = MasInvBin::model()->findAll(array('condition' => 'is_free="N" AND rack_id=' . $model_orgin_bin->rack_id));
                    if ((int) $model_origin_rack->total_bins == count($origin_bins)) {
                        $model_origin_rack->is_free = "N";
                        $model_origin_rack->save(false);
                    } else {
                        $model_origin_rack->is_free = "Y";
                        $model_origin_rack->save(false);
                    }
                }
                if ($model_destiny_bin->rack_id > 0) {
                    $model_destiny_rack =MasInvRack::model()->findBYPK($model_destiny_bin->rack_id);            
                    $destiny_bins = MasInvBin::model()->findAll(array('condition' => 'is_free="N" AND rack_id=' . $model_destiny_bin->rack_id));
                    if ((int) $model_destiny_rack->total_bins == count($destiny_bins)) {
                        $model_destiny_rack->is_free = "N";
                        $model_destiny_rack->save(false);
                    } else {
                        $model_destiny_rack->is_free = "Y";
                        $model_destiny_rack->save(false);
                    }
                }
            }
        }
        if($valid){
            $data['status'] = 'success';
            $data['msg'] = 'Items From '.$model_origin_rack->name.' - '.$model_orgin_bin->name.' moved to '.$model_destiny_rack->name.' - '.$model_destiny_bin->name;
            echo CJSON::encode($data);
        }else{
            $error = CJSON::encode($other);
            if ($error != '[]')
                echo $error;
        }
        Yii::app()->end();                        
    }
    
    
    public function actionPrintCustomerProductStockTransactionExcel(){
        $product_id     = (int) Yii::app()->request->getParam('product_id');
        $customer_id    = (int) Yii::app()->request->getParam('customer_id');
        
        //Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('stock_transaction_list', array('product_id' => $product_id,'customer_id'=>$customer_id));
    }
    
    
    
    /************** Code added By mereena on 19/05/2021 ******************************/
    
    public function actionGetServiceList() {
        $draw   = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $generic_id     = $_POST['generic_id'];
        $brand_id         = $_POST['brand_id'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'part_number',
            
        );
        $filterColumn   = $columns[$_POST['order'][0]['column']];
        $filterOrder    = $_POST['order'][0]['dir'];
        $orderBy        = $filterColumn . " " . $filterOrder;
        
        $condition      = 't.type="S" AND t.isActive="Y"';
       
        
        if($generic_id>0)
        {
            $condition.=' AND t.generic_id='.$generic_id;    
        }
        
        if($brand_id>0)
        {
            $condition.=' AND t.brand='.$brand_id;    
        }
        
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" AND (part_number LIKE '%" . $searchString . "%' OR description LIKE '%" . $searchString . "%')";
        }
        
        $model = new Inventory();
        
        $count = $model->with('generic','brands')->count(array('condition'=>$condition));
        $model = $model->with('generic','brands')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'part_number'));
       
        $rowData    = array();
        $m=1;
        foreach ($model as $i=>$row)
        {
            
            /*echo $row['generic']['generic_name'];
            exit;*/
            $div= '<div class="text-center">';
            
            if($row['active']=='Y'){
                    $div .= '<button class="btn btn-primary btn-xs" title ="Edit" onclick="loadPopupModal(\'logistics/inventory/createservice&id='.$row['id'].'\',\'Edit - '.$row['part_number'].'\',\'lg\')"><i class="fa fa-edit" aria-hidden="true"></i></button>';
            }
            else{
                $div.= ' <button class="btn btn-theme btn-xs" title ="UnBlock" onclick="block('.$row['id'].',2)"><i class="fa fa-unlock" aria-hidden="true"></i></button>';
            }
            $div.= '</div>';
            
            $rowData[]  = array($m,$row['part_number'],$row['description'],$row['generic']['generic_name'],$row['brands']['brand_name'],$row['units']['unit_name'],($row['taxDetails']['tax_code'].":".$row['taxDetails']['percentage']."%"),$div);
            $m++;
                
            
        } 
        $data['data'] = $rowData;
        $recordsTotal   = $count;
        $recordsFiltered  = $count;
        $data['draw']   = $draw;
        $data['recordsTotal']   = $recordsTotal;
        $data['recordsFiltered']= $recordsFiltered;
        echo json_encode($data);
    }
    
    
    
    public function actionCreateService() {
       $id = (int) Yii::app()->request->getParam('id');
        $model = new Inventory;
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('create_service', array('model' => $model));
    }
    
    public function actionSaveInventoryService(){
          $model = new Inventory();
            if (isset($_POST['Inventory'])) {
    
                if ($_POST['Inventory']['id'] > 0) {
                    $id =  $_POST['Inventory']['id'];
                    $model = $model->findByPK($id);
    
                    $model->updated_time =date('Y-m-d h:i:s');
                    $scene = 'update';
                } else {
                    $model->created_by = Yii::app()->user->id;
                    $model->created_time = date('Y-m-d H:i:s');
                    $scene = 'new';
                   
                }
                $model->attributes = $_POST['Inventory'];
                $model->customer_id = 0;
                    
                $valid=$model->validate();   
                if($valid){
                    $model->tax=MasInvTax::model()->findByPk($model->tax_code)->percentage;
                    $model->part_number=strtoupper(trim($model->part_number));    
                    
                    if($_POST['Inventory']['default_service']=='Y'){
                        
                	    Inventory::model()->updateAll(array( 'default_service' => 'N' ), 'default_service = "Y" AND type="S"');
                        
                    }
                    
                    $model->save();
                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);
                }
                else {
                    $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                    $error = CJSON::encode(array_merge_recursive($error1));
                    if ($error != '[]')
                        echo $error;    
                }
            }
    }
    
    
    
    /*************** END **********************************************************/
    
}