<?php

class GoodsreceiptsController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'SaveReceipt', 'Delete', 'GetProducts', 'DeleteReceiptItem', 'DeleteReceipt', 'Append',
                    'AddStock', 'GetRow', 'GetFactor', 'Getunitdrop', 'PrintReceiptPDF','PrintReceiptPackagingPDF', 'Upload', 'UploadReceipt','UploadDocuments', 'SaveUploadReceipt', 'UpdateGoodsreceiptUpload', 'SaveUploadedDetailsToReceipt'),
                'expression' => '$user->isMember()',
            ), /*             * copied by jisha from bouleward on 8-11-17* */
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    /*     * copied by jisha from bouleward on 8-11-17* */

    public function actionGetList() {
        $model = new GoodsReceipt();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'transaction_date',
            2 => 'customer_id',
            3 => 'reference_no',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.active="Y" AND t.state="COMPLETED"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" and (id LIKE '%" . $searchString . "%' OR transaction_date LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'id desc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $date_d = date("d/m/Y", strtotime($row->transaction_date));
            $rowData[] = array($row['id'], $date_d, $row->customer->customer_name, $row['reference']);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    /*     * copied by jisha from bouleward on 8-11-17* */

    public function actionCreate() {
        $model = new GoodsReceipt();
        $model_item = array(new GoodsReceiptItems());
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_item = GoodsReceiptItems::model()->findAll(array('condition' => 'transaction_id = ' . $model->id . ''));
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('receipts_form', array('model' => $model, 'model_item' => $model_item), false, false);
    }

    public function actionSaveReceipt() {
        $model = new GoodsReceipt();

        if (isset($_POST['GoodsReceipt'])) {
            $scenario = '';
            if ((int) @$_POST['GoodsReceipt']['id'] > 0) {
                $id = (int) @$_POST['GoodsReceipt']['id'];
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_time = date('Y-m-d h:i:s');
                $scenario = 'update';
                $audit_type = 'UPDATED';
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_time = date('Y-m-d h:i:s');
                $scenario = 'add';
                $audit_type = 'CREATED';
                $scene = 'new';
            }
            $modelformmaster = FormMaster::model()->findByPk(3);
            $model->attributes = $_POST['GoodsReceipt'];
            if ($_POST['GoodsReceipt']['transaction_date'] != '00/00/0000') {
                $model->transaction_date = str_replace('/', '-', $_POST['GoodsReceipt']['transaction_date']);
                $model->transaction_date = date("Y-m-d", strtotime($model->transaction_date));
            }
            if ($scene == 'new') {
                $model->receipt_no = $modelformmaster->next_number;
            }
            $model->state = 'CHECK_IN';
            $valid = $model->validate();
            $date = date("Y-m-d H:i:s");
            if (is_array($_POST['GoodsReceiptItems'])) {
                foreach ($_POST['GoodsReceiptItems'] as $k => $rowItem) {
                    $model_item[$k] = new GoodsReceiptItems;
                    if ($rowItem['id'] > 0) {
                        $model_item[$k] = GoodsReceiptItems::model()->findByPk($rowItem['id']);
                    }
                    $model_item[$k]->product_id = $rowItem['product_id'];
                    $model_item[$k]->description = $rowItem['description'];
                    $model_item[$k]->quantity = $rowItem['quantity'];
                    $model_item[$k]->unit = $rowItem['unit'];
                    $model_item[$k]->rate = $rowItem['rate'];
                    $model_item[$k]->length = $rowItem['length'];
                    $model_item[$k]->breadth = $rowItem['breadth'];
                    $model_item[$k]->height = $rowItem['height'];
                    $model_item[$k]->cbm = $rowItem['cbm'];
                    $model_item[$k]->bill_of_entry = $rowItem['bill_of_entry'];
                    $valid = $model_item[$k]->validate() && $valid;
                }
            }
            if ($valid) {
                $model->save(false);
                if ($scene == 'new') {
                    $next_no = $model->receipt_no + 1;
                    FormMaster::model()->updateByPk($modelformmaster->id, array('next_number' => $next_no));
                }
                Checkin::model()->deleteAll(array('condition' => 'transaction_type="GR" AND transaction_id=' . $model->id));
                CheckinItems::model()->deleteAll(array('condition' => 'transaction_type="GR" AND transaction_id=' . $model->id));
                GoodsReceiptItems::model()->deleteAll(array('condition' => 'header_id=' . $model->id));
                $Checkin = new Checkin;
                $Checkin->transaction_type = 'GR';
                $Checkin->transaction_date = $model->transaction_date;
                $Checkin->transaction_id = $model->id;
                $Checkin->created_by = $model->created_by;
                $Checkin->created_time = $model->created_time;
                $Checkin->customer_id = $model->customer_id;
                $Checkin->save(false);
                $Checkin->refresh();
                // inserting to audit log
                AuditLog::saveAuditLogs(
                        'RECEIPTS', Yii::app()->user->id, $audit_type, " with Checkin No: - {$model->id}  "
                );
                // end audit log 

                foreach ($model_item as $eachitem) {
                    $eachitem->header_id = $model->id;
                    $eachitem->save(false);

                    $CheckinItems = new CheckinItems;
                    $CheckinItems->transaction_type = 'GR';
                    $CheckinItems->checkin_id = $Checkin->id;
                    $CheckinItems->transaction_id = $model->id;
                    $CheckinItems->transaction_item_id = $eachitem->id;
                    $CheckinItems->product_id = $eachitem->product_id;
                    $CheckinItems->description = $eachitem->description;
                    $CheckinItems->quantity = $eachitem->quantity;
                    $CheckinItems->unit = $eachitem->unit;
                    $CheckinItems->length = $eachitem->length;
                    $CheckinItems->breadth = $eachitem->breadth;
                    $CheckinItems->height = $eachitem->height;
                    $CheckinItems->cbm = $eachitem->cbm;
                    $unit = MasUnit::model()->findByPk($CheckinItems->unit);
                    $CheckinItems->default_product_unit = $unit->base_unit_id;
                    $CheckinItems->unit_exchange_rate = $unit->unit_exchange_rate;
                    $CheckinItems->rate = $eachitem->rate;
                    $CheckinItems->bill_of_entry_exit = $eachitem->bill_of_entry;
                    $CheckinItems->save(false);
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if ($model_item[0]->product_id > 0)
                    $error2 = json_decode(CActiveForm::validateTabular($model_item, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";
                $error = CJSON::encode(array_merge_recursive($error1, $error2));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    /*     * copied by jisha from bouleward on 8-11-17* */

    public function actionDeleteReceipt() {
        $id = $_POST['id'];
        $model = new GoodsReceipt();
        $model->deleteByPk($id);
        echo "success";
    }

    /*     * copied by jisha from bouleward on 8-11-17* */

    public function actionDeleteReceiptItem() {

        $id = $_POST['id'];

        $model = new GoodsReceiptItem();

        $model->deleteByPk($id);

        $jsonData['status'] = 'success';

        $jsonData['id'] = $id;

        echo CJSON::encode($jsonData);
    }

    /* jo */

    public function actionGetunitdrop() {
        $row = $_POST['row_field'];
        $unit_id = $_POST['unit'];
        $arr_units = MasUnit::getSimilarUnits($unit_id);
        $drop = array();
        $modelOrder = new GoodsReceiptItems;
        $modelOrder->unit = $unit_id;
        $drop['drop'] = CHtml::activedropdownlist($modelOrder, "[" . $row . "]unit", $arr_units, array('class' => 'unit go', 'onchange' => 'getFactor(this.id,this.value)'));
        echo CJSON::encode($drop);
    }

    public function actionGetFactor() {
        $factor = 1;
        if ((int) $_POST['value'] > 0) {
            $factor = UnitOfMeasurement::getFactor($_POST['value']);
        }
        echo $factor;
    }

    public function actionPrintReceiptPDF() {

        //$model = new PurchasingRequisition();
        $id = Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = GoodsReceipt::model()->findByPk($id);
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.logistics.views.pdf.receipts_print', array('model' => $model, 'id' => $id, 'title' => $title), true));
        $mPDF1->Output("Receipts.pdf", 'I');
    }
    public function actionPrintReceiptPackagingPDF() {

        //$model = new PurchasingRequisition();
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.logistics.views.pdf.receipts_packaging_print', array('id' => $id, 'title' => $title), true));
        $mPDF1->Output("ReceiptPackage.pdf", 'I');
    }
    public function actionUploadReceipt() {
        $model = new GoodsReceipt();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('receipts_upload_form', array('model' => $model), false, false);
    }

    public function actionSaveUploadReceipt() {
        $model = new GoodsReceipt();
        $other = array();
        if (isset($_POST['GoodsReceipt'])) {
            $scenario = '';
            $model->created_by = Yii::app()->user->id;
            $model->created_time = date('Y-m-d h:i:s');
            $scenario = 'add';
            $audit_type = 'CREATED';
            $scene = 'new';

            $modelformmaster = FormMaster::model()->findByPk(3);
            $model->attributes = $_POST['GoodsReceipt'];
            if ($_POST['GoodsReceipt']['transaction_date'] != '00/00/0000') {
                $model->transaction_date = str_replace('/', '-', $_POST['GoodsReceipt']['transaction_date']);
                $model->transaction_date = date("Y-m-d", strtotime($model->transaction_date));
            }

            $model->state = 'CHECK_IN';
            $valid = $model->validate();
            $date = date("Y-m-d H:i:s");
            $warehouse = $_POST['warehouse'];
            if ($warehouse == '') {
                $valid = false;
                $other[] = 'Warehouse cannot be blank';
            }
            if ($valid) {
                $receipt_date = $model->transaction_date;
                $customer_id = $model->customer_id;
                $reference = $model->reference;
                $customer_name = $_POST['GoodsReceipt']['customer_name'];
                $notes = $model->notes;
                $warehouse_name = MasInventoryWarehouse::model()->findByPk($warehouse)->warehouse_name;
                Yii::app()->db->createCommand("truncate temp_goods_receipt_uploads")->execute();
                $file = $_POST['Icon']['file'];
                $default_exchange_unit_id = MasUnit::model()->find(array('condition' => 'is_default="Y"'))->id;
                if (($handle = fopen("uploads/documents/" . $file, "r")) !== FALSE) {
                    $n = 1;
                    while (($row = fgetcsv($handle)) !== FALSE) {
                        if ($n > 1) {
                            $row0 = $row[0];
                            $mod_inv =Inventory::model()->findByPartnoCustomer($row0,$customer_id);
                            if(!empty($mod_inv)){
                                $inventory  = $mod_inv->part_number;
                                $product_id = $mod_inv->id;
                            }else{
                                $inventory  = $row0;
                                $product_id = 0;
                            
                            }
                            $row1 = $row[1];
                            $row2 = $row[2];
                            $unit = MasUnit::model()->findByUnitname($row2)->unit_name;
                            $unit_id = MasUnit::model()->findByUnitname($row2)->id;
                            if ((int) $unit_id == 0 && $row3 > 0) {
                                $units = new MasUnit;
                                $units->unit_name = strtoupper(trim($row2));
                                $units->is_default = 'N';
                                $units->base_unit = 'N';
                                $units->base_unit_id = $default_exchange_unit_id;
                                $units->unit_exchange_rate = $row3;
                                $units->label = strtoupper(trim($row2));
                                $units->active = 'Y';
                                $units->save();
                                $unit_id = $units->id;
                                $unit = $units->unit_name;
                            }
                            $row3 = $row[3];
                            $row4 = $row[4];
                            $row5 = $row[5];
                            $row6 = $row[6];
                            $row7 = $row[7];
                            $rowl = $row[9];
                            $rowb = $row[10];
                            $rowh = $row[11];
                            $SQL = "INSERT INTO temp_goods_receipt_uploads (goods_receipt_date,reference,customer_id,customer_name,notes,product_id,products,quantity,unit_id,unit,unit_exchange_id,unit_exchange_rate,rate,bill_of_entry,weight,volume,warehouse,warehouse_name,length,breadth,height) 
                                    VALUES('$receipt_date','$reference','$customer_id','$customer_name','$notes','$product_id','$inventory','$row1','$unit_id','$unit','$default_exchange_unit_id','$row3','$row4','$row5','$row6','$row7','$warehouse','$warehouse_name','$rowl','$rowb','$rowh')";
                            Yii::app()->db->createCommand($SQL)->execute();
                        }
                        $n++;
                    }
                    fclose($handle);
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1, $other));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionSaveUploadedDetailsToReceipt() {
        $model = new GoodsReceipt();
        $other = array();
        $temp = Yii::app()->db->createCommand("select * from temp_goods_receipt_uploads")->queryAll();
        $model->created_by = Yii::app()->user->id;
        $model->created_time = date('Y-m-d h:i:s');
        $scenario = 'add';
        $audit_type = 'CREATED';
        $scene = 'new';
        $customer_id=$temp[0]['customer_id'];
        $model->transaction_date = $temp[0]['goods_receipt_date'];
        $model->reference = $temp[0]['reference'];
        $model->customer_id = $customer_id;
        $model->state = 'CHECK_IN';
        $model->notes = $temp[0]['notes'];
        $warehouse = $temp[0]['warehouse'];
        $modelformmaster = FormMaster::model()->findByPk(3);
        $model->receipt_no = $modelformmaster->next_number;
        $valid = $model->validate();

        foreach ($temp as $k => $rowItem) {
            $model_item[$k] = new GoodsReceiptItems;
            if($rowItem['product_id']>0){
                $model_inv = Inventory::model()->findByPk($rowItem['product_id']);
            }else{
                $model_inv=new Inventory();
                $model_inv->customer_id = $customer_id;
                $model_inv->tax=MasInvTax::model()->find()->percentage;
                $model_inv->tax_code=MasInvTax::model()->find()->id;
                $model_inv->type ='I';
                $model_inv->unit =$rowItem['unit_id'];
                $model_inv->length =$rowItem['length'];
                $model_inv->width =$rowItem['breadth'];
                $model_inv->height =$rowItem['height'];
                $model_inv->part_number = strtoupper(trim($rowItem['products']));
                $model_inv->description = $rowItem['products'];
                $model_inv->barcode =$model_inv->part_number;
                $model_inv->created_by = Yii::app()->user->id;
                $model_inv->created_time = date('Y-m-d H:i:s');
                $model_inv->save(false);
                $model_inv->refresh();
                StockLedger::model()->deleteAll(array('condition'=>'product_id='.$model_inv->id.' AND type="OB" AND transaction_type="IN"'));
                $stockledger = new StockLedger;
                $stockledger->transaction_date=date('Y-m-d');
                $stockledger->transaction_type='IN';
                $stockledger->type='OB';
                $stockledger->customer_vendor_id=$customer_id;
                $stockledger->header_id=0;
                $stockledger->item_id=0;
                $stockledger->product_id=$model_inv->id;
                $stockledger->rate=0;
                $stockledger->currency=1;
                $stockledger->exchange_rate=1;
                $stockledger->quantity=0;
                $stockledger->length =$rowItem['length'];
                $stockledger->breadth =$rowItem['breadth'];
                $stockledger->height =$rowItem['height'];
                $stockledger->unit=$model_inv->unit;
                $stockledger->default_product_unit=$model_inv->units->base_unit_id;
                $stockledger->unit_exchange_rate=$model_inv->units->unit_exchange_rate;
                $stockledger->created_by=Yii::app()->user->id;
                $stockledger->created_time=date('Y-m-d H:i:s');
                $stockledger->save(false);
            }
            $model_item[$k]->product_id = $model_inv->id;
            $model_item[$k]->description = $model_inv->description;;
            $model_item[$k]->quantity = (int)$rowItem['quantity'];
            $model_item[$k]->unit = $rowItem['unit_id'];
            $model_item[$k]->rate = (int)$rowItem['rate'];
            $model_item[$k]->bill_of_entry = $rowItem['bill_of_entry'];
            $model_item[$k]->length = $rowItem['length'];
            $model_item[$k]->breadth = $rowItem['breadth'];
            $model_item[$k]->height = $rowItem['height'];
            $model_item[$k]->cbm = $rowItem['length']*$rowItem['breadth']*$rowItem['height']/1000000;
            $weight=$rowItem['weight'];
            $volume=$rowItem['volume'];
            $valid = $model_item[$k]->validate() && $valid;
        }
        if ($valid) {
            $model->save();
            if ($scene == 'new') {
                $next_no = $model->receipt_no + 1;
                FormMaster::model()->updateByPk($modelformmaster->id, array('next_number' => $next_no));
            }
            Checkin::model()->deleteAll(array('condition' => 'transaction_type="GR" AND transaction_id=' . $model->id));
            CheckinItems::model()->deleteAll(array('condition' => 'transaction_type="GR" AND transaction_id=' . $model->id));
            GoodsReceiptItems::model()->deleteAll(array('condition' => 'header_id=' . $model->id));
            $Checkin = new Checkin;
            $Checkin->transaction_type = 'GR';
            $Checkin->transaction_date = $model->transaction_date;
            $Checkin->transaction_id = $model->id;
            $Checkin->created_by = $model->created_by;
            $Checkin->created_time = $model->created_time;
            $Checkin->customer_id = $customer_id;
            $Checkin->save();
            $Checkin->refresh();
            // inserting to audit log
            AuditLog::saveAuditLogs(
                    'RECEIPTS', Yii::app()->user->id, $audit_type, " with Checkin No: - {$Checkin->id}  "
            );
            // end audit log 

            foreach ($model_item as $eachitem) {
                $eachitem->header_id = $model->id;
                $eachitem->save(false);

                $CheckinItems = new CheckinItems;
                $CheckinItems->transaction_type = 'GR';
                $CheckinItems->checkin_id = $Checkin->id;
                $CheckinItems->transaction_id = $model->id;
                $CheckinItems->transaction_item_id = $eachitem->id;
                $CheckinItems->product_id = $eachitem->product_id;
                $CheckinItems->description = $eachitem->description;
                $CheckinItems->quantity = $eachitem->quantity;
                $CheckinItems->unit = $eachitem->unit;
                $unit = MasUnit::model()->findByPk($CheckinItems->unit);
                $CheckinItems->default_product_unit = $unit->base_unit_id;
                $CheckinItems->unit_exchange_rate = $unit->unit_exchange_rate;
                $CheckinItems->length = $eachitem->length;
                $CheckinItems->breadth = $eachitem->breadth;
                $CheckinItems->height = $eachitem->height;
                $CheckinItems->rate = $eachitem->rate;
                $CheckinItems->bill_of_entry_exit = $eachitem->bill_of_entry;
                $CheckinItems->save(false);
            }
            //goods receipt end
            //checkin started
            $checkin_id=$Checkin->id;
            $checkin_model=$Checkin;
            $CheckinItems=CheckinItems::model()->findAll(array('condition'=>'checkin_id='.$checkin_id,'order'=>'id ASC'));
            Yii::app()->db->createCommand('delete from temp_packaging_items where transaction_id='.$model->id.' AND transaction_type="GR"')->execute();
            $SQL='INSERT INTO temp_packaging_items (transaction_type,checkin_id,checkin_item_id,transaction_id,transaction_item_id,product_id,description,quantity,unit,default_product_unit,unit_exchange_rate,rate,bill_of_entry_exit,length,breadth,height) 
            SELECT transaction_type,checkin_id,id,transaction_id,transaction_item_id,product_id,description,quantity,unit,default_product_unit,unit_exchange_rate,rate,bill_of_entry_exit,length,breadth,height FROM erp_checkin_items WHERE transaction_id='.$model->id.' AND transaction_type="GR"';
            Yii::app()->db->createCommand($SQL)->execute();
            $packaging_model = new Packaging();
            $packaging_model->transaction_type='GR';
            $packaging_model->transaction_id=$model->id;
            $packaging_model->created_by = Yii::app()->user->id;
            $packaging_model->created_time =date('Y-m-d h:i:s');
            $packaging_model->transaction_date=$model->transaction_date;
            $packaging_model->customer_id = $customer_id;
            $i=0;
            $arr_used_bins=array();                
            foreach ($CheckinItems as $k => $rowItem) {
                $checkin_id = $rowItem['checkin_id'];
                $checkin_item_id = $rowItem['id'];
                $packages = Yii::app()->db->createCommand('select * from temp_packaging_items where checkin_item_id=' . $checkin_item_id)->queryAll();
                $bincond = 't.is_free="Y" AND rack.warehouse_id='.$warehouse;
                if (!empty($packages)) {
                    foreach ($packages as $eachPackage) {
                        $model_pitem[$i] = new PackagingItems;
                        $model_pitem[$i]->transaction_type = $eachPackage['transaction_type'];
                        $model_pitem[$i]->checkin_id = $eachPackage['checkin_id'];
                        $model_pitem[$i]->checkin_item_id = $eachPackage['checkin_item_id'];
                        $model_pitem[$i]->transaction_id = $model->id;
                        $model_pitem[$i]->transaction_item_id = $eachPackage['transaction_item_id'];
                        $model_pitem[$i]->product_id = $eachPackage['product_id'];
                        $model_pitem[$i]->description = $eachPackage['description'];
                        $model_pitem[$i]->quantity = $eachPackage['quantity'];
                        $model_pitem[$i]->unit = $eachPackage['unit'];
                        $model_pitem[$i]->default_product_unit = $eachPackage['default_product_unit'];
                        $model_pitem[$i]->unit_exchange_rate = $eachPackage['unit_exchange_rate'];
                        $model_pitem[$i]->rate = $eachPackage['rate'];
                        $model_pitem[$i]->bill_of_entry_exit = $eachPackage['bill_of_entry_exit'];
                        $model_pitem[$i]->package_id = $packaging_model->id;
                        $model_pitem[$i]->weight = $temp[$i]['weight'];
                        $model_pitem[$i]->volume = $temp[$i]['volume'];
                        $model_pitem[$i]->warehouse_id = $warehouse;
                        $model_pitem[$i]->length = $eachPackage['length'];
                        $model_pitem[$i]->breadth = $eachPackage['breadth'];
                        $model_pitem[$i]->height = $eachPackage['height'];
                        $each_bin_cond = $bincond.' AND t.maximum_weight >='.$temp[$i]['weight'].' AND t.maximum_volume >='.$temp[$i]['volume'];
                        if(!empty($arr_used_bins)){
                            $each_bin_cond .= 'AND t.id NOT IN ('.implode(',', $arr_used_bins).')';
                        }
                        $bin_model = MasInvBin::model()->with('rack')->find(array('condition'=>$each_bin_cond,'order'=>'t.maximum_volume ASC','limit'=>1));
                        $arr_used_bins[] =$bin_model->id;
                        $model_pitem[$i]->rack_id = $bin_model->rack->id;
                        $model_pitem[$i]->bin_id = $bin_model->id;                        
                        $i++;
                        $cnd=$each_bin_cond.' '.implode(',', $arr_used_bins);
                    }
                }
            }
            Yii::app()->db->createCommand('delete from temp_packaging_items where transaction_type="GR" AND transaction_id='.$model->id)->execute();
            $packaging_model->save(false);
            $packaging_model->refresh();
            $receipt=GoodsReceipt::model()->findByPk($model->id);
            $receipt->state='PACKAGING';
            $receipt->save(false);
            // inserting to audit log
            AuditLog::saveAuditLogs(
                'RECEIPTS',
                Yii::app()->user->id,
                $audit_type,
                " with Packaging No: - {$packaging_model->id}  "
            );
            // end audit log 
            foreach ($model_pitem as $eachitem){
                  $eachitem->package_id = $packaging_model->id;
                  $eachitem->save(false);  
                  /*

                   $StockLedger= new StockLedger;
                    $StockLedger->transaction_date=$packaging_model->transaction_date;
                    $StockLedger->transaction_type='IN';
                    $StockLedger->type='GR';
                    $StockLedger->customer_vendor_id=$packaging_model->transaction->customer_id;
                    $StockLedger->file_id=0;
                    $StockLedger->header_id=$packaging_model->id;
                    $StockLedger->item_id=$eachitem->id;
                    $StockLedger->product_id=$eachitem->product_id;
                    $inventory=Inventory::model()->findByPk($eachitem->product_id);
                    $StockLedger->brand_id=$inventory->brand;
                    $StockLedger->rate=$eachitem->rate;
                    $StockLedger->currency=1;
                    $StockLedger->exchange_rate=1;
                    $StockLedger->quantity=$eachitem->quantity;
                    $StockLedger->unit=$eachitem->unit;
                    $StockLedger->default_product_unit=$eachitem->default_product_unit;
                    $StockLedger->unit_exchange_rate=$eachitem->unit_exchange_rate;
                    $StockLedger->warehouse_id=$eachitem->warehouse_id;
                    $StockLedger->rack_id=$eachitem->rack_id;
                    $StockLedger->bin_id=$eachitem->bin_id;
                    $StockLedger->batch_no=$eachitem->batch_no;
                    $StockLedger->serial_no=$eachitem->serial_no;
                    $StockLedger->manufacturing_date=$eachitem->manufacturing_date;
                    $StockLedger->expiry_date=$eachitem->expiry_date;
                    $StockLedger->bill_of_entry_exit=$eachitem->bill_of_entry_exit;
                    $StockLedger->hs_code=$inventory->hs_code;
                    $StockLedger->save(false);
                    $bin=MasInvBin::model()->findByPk($eachitem->bin_id);
                    $bin->is_free="N";
                    $bin->save(false);
                    $raks=MasInvBin::model()->findAll(array('condition'=>'is_free="N" AND rack_id='.rack_id));
                    if((int)$eachitem->mas_rack->total_bins==count($raks))
                    {
                    $rak=MasInvRak::model()->findByPk($eachitem->rak_id);
                    $rak->is_free="N";
                    $rak->save(false);    
                    } 
                                  */
           }
           Yii::app()->db->createCommand('delete from temp_goods_receipt_uploads')->execute();
            
            $jsonData['status'] = 'success';
            $jsonData['id'] = $packaging_model->id;
            $jsonData['cnd'] =$cnd;
            echo CJSON::encode($jsonData);
        } else {
            $error1 = json_decode(CActiveForm::validate($model, '', false), true);
            if ($model_item[0]->product_id > 0)
                $error2 = json_decode(CActiveForm::validateTabular($model_item, '', false), true);
            else
                $error2[] = "Please add atleast one line item";
            $error = CJSON::encode(array_merge_recursive($error1, $error2));
            if ($error != '[]')
                echo $error;
        }
        
    }

    public function actionUpdateGoodsreceiptUpload() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('receipts_update_status_form', array(), false, false);
    }

    /* end */
}
