<?php

class DocumentController extends Controller
{    
 public $layout = 'main';
    public function accessRules() {
        return array(
                array('allow', 
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', 
                    'actions' => array('index','UpdateDocument','Upload','DownloadDocument','UploadERPDocument','SaveERPDocument','GetERPDocumentList','DownloadERPDocument','DeleteERPDocument','UploadDocuments'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', 
                    'users' => array('*'),
                    ),
                );
    }
 
    public function actionIndex() {
        $this->layout = 'main';
        $model=new Employee();          
        $model_documents=array(new EmployeeDocuments()); 
        $employee_id = Yii::app()->user->id; 
        $modelemployee = User::model()->findByPK($employee_id);	
        $model_settings = HrGenerelSettings::model()->find();	
        $id= $modelemployee->employee_id;	
        if($id>0){
            $model=$model->findByPk($id);              
            $model_documents= EmployeeDocuments::model()->findAll(array('condition' => 'employee_id="'. $id.'"'));
            if(empty($model_documents)){
                $model_documents=array(new EmployeeDocuments()); 
            }     
            
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index_document', array('model' => $model,'model_documents' => $model_documents,'model_settings'=>$model_settings), false, true);
    }
	    
    public function actionUpdateDocument() {
        if (isset($_POST['EmployeeDocuments'])) {            //print_r($_POST); die();
            $valid=true;
            date_default_timezone_set("Asia/Dubai");
            if ((isset($_POST['EmployeeDocuments'])) && ($_POST['EmployeeDocuments'][0]['document_id']!='')){			
                foreach ($_POST['EmployeeDocuments'] as $i => $items) {
                    if($items['id']>0){
                        $model_document[$i] = EmployeeDocuments::model()->findByPK($items['id']);   
                        $model_document[$i]->scenario = 'add';
                        $model_document[$i]->created_by= Yii::app()->user->id;
                        $model_document[$i]->created_date_time = date('Y-m-d h:i:s');
                    }else{
                        $model_document[$i] = new EmployeeDocuments();   
                        $model_document[$i]->scenario = 'update';
                        $model_document[$i]->updated_by= Yii::app()->user->id;
                        $model_document[$i]->updated_date_time = date('Y-m-d h:i:s');
                    }   
										
                    $model_document[$i]->document_id = $items['document_id'];
                    $model_document[$i]->document_number = $items['document_number'];
                    $model_document[$i]->employee_id = $items['employee_id'];
                    $model_document[$i]->document_file = $items['document_file'];
                    if ($items['validate_till_date'] != '' && $items['validate_till_date'] != '0000-00-00') {
                        $items['validate_till_date'] = str_replace('/', '-', $items['validate_till_date']);
                        $valid_date=date("Y-m-d", strtotime($items['validate_till_date']));
                        $model_document[$i]->validate_till_date = $valid_date;
                        $current_date=date("Y-m-d");
                        if (strtotime($valid_date)>strtotime($current_date)){
                            $model_document[$i]->status =0;
                            $model_document[$i]->expiry_notify =0;
                        }
                    }
                    if ($items['renew_on'] != '' && $items['renew_on'] != '0000-00-00') {
                        $items['renew_on'] = str_replace('/', '-', $items['renew_on']);
                        $model_document[$i]->renew_on = date("Y-m-d", strtotime($items['renew_on']));                   
                    }
					
                    $valid=$model_document[$i]->validate() && $valid;
                    
                }
            }
            if($valid){
                //SaveDocument
                if (!empty($model_document)) {
                    foreach ($model_document as $eachModel) {
                        $eachModel->save();
                    }
                }       
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
				Yii::app()->end();
            }else{
                $error1=array();
                if ($model_document[0]->document_id > 0){
                   $error1 = json_decode(CActiveForm::validateTabular($model_document, '', false), true);
                }
         
                $error = CJSON::encode($error1);
                if ($error != '[]')
                    echo $error;
            }
            
        }
    }	 
    
    public function actiondownloadDocument() {
        $id =Yii::app()->request->getParam('id');		
        $arr_employee_document = EmployeeDocuments::model()->findByPk($id);		
        $file = $arr_employee_document->document_file;
        $arr_doc_val = explode(',', $arr_employee_document->document_file);
        if (count($arr_doc_val) > 1) {
            $zip = new ZipArchive();
            $zip_file_path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" .$arr_employee_document->document->document_name . "_" . date('d-m-Y') . ".zip";
            if ($zip->open($zip_file_path, 1 ? ZIPARCHIVE::OVERWRITE : ZIPARCHIVE::CREATE) === TRUE) {
                for ($i = 0; $i < count($arr_doc_val); $i++) {
                    $path = "uploads/documents/" . $arr_doc_val[$i];
                    // Add the files to the .zip file
                    $zip->addFile($path, $arr_doc_val[$i]);
                }
                // Closing the zip file
                $zip->close();
            }
            header("Content-type:application/zip"); //for pdf file
            header('Content-Disposition: attachment; filename="' . basename($zip_file_path) . '"');
            header('Content-Length: ' . filesize($zip_file_path));
            readfile($zip_file_path);
            Yii::app()->end();
        } else {
            $file = $arr_employee_document->document_file;
            $path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $file;
            header("Content-type:application/octet-stream"); //for txt file
            header("Content-Type: application/download");
            header('Content-Disposition: attachment; filename="' . basename($path) . '"');
            header('Content-Length: ' . filesize($path));
            readfile($path);
            Yii::app()->end();
        }
    }
    
    public function actionUploadERPDocument(){
            $file_id = (int) Yii::app()->request->getParam('file_id');
            $upload_from = Yii::app()->request->getParam('frm');
            
            $model=new Document();
            $model->file_id         = $file_id;
            $model->uploaded_from   = $upload_from;
            
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
            $this->render('upload_document', array('model' => $model));
    }
    
    public function actionSaveERPDocument(){
        
        $modelDocument = new Document;
        
        $file_id        = $_POST['Document']['file_id'];
        $uploaded_from  = $_POST['Document']['uploaded_from'];
        
        if(isset($_POST['Icon']['file']) && $_POST['Icon']['file']!='')
        {
            $doc_exist=Document::model()->find(array('condition'=>'file_id='.$file_id.' AND document_name="'.$_POST['Icon']['file'].'"'));
            if(empty($doc_test))
            {
                $modelDocument = new Document;
                $modelDocument->uploaded_from =  $uploaded_from;
                $modelDocument->file_id = $file_id;
                $modelDocument->created_by = Yii::app()->user->id;
                $modelDocument->created_datetime = date('Y-m-d h:i:s');
                $modelDocument->document_name =$_POST['Icon']['file'];
                $modelDocument->save(false);
                
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
				Yii::app()->end();
            }
            else{
                $other[] = 'File already exist';
                $error = CJSON::encode($other);
                echo $error;
            }
        }
        else{
                 $other[] = 'Document name cannot be blank';
                 $error = CJSON::encode($other);
                echo $error;
        
            }
    }
    
    public function actionGetERPDocumentList(){
        $model=new Document();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $file_id = $_POST['file_id'];
        $columns = array(
                // datatable column index  => database column name
                   0=>'t.file_id',                 
                   1 =>'t.document_name',
                   2=>'t.created_by',
                   3=>'t.created_datetime',
                   
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = 't.isActive="Y" and (t.file_id = "'.$file_id.'" AND t.file_id > 0)';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition.=" and (document_name LIKE '%".$searchString."%' OR file_id LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                foreach ($model as $row)
                {
                    $model2 = User::model()->find(array('condition'=>'t.id = "'.$row['created_by'].'"'));
                    $rowData[]=array($m,$row['document_name'],$model2->username,date("d/m/Y h:i:s",strtotime($row['created_datetime'])),
              '<div class="btn-wrap text-center">'
              .'<a href ="#" class="btn btn-danger btn-xs" onclick="deleteERPDocument(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a>'
              .' <a href ="'.Yii::app()->createUrl("logistics/document/downloadeRPdocument").'&filename='.$row['document_name'] .' " class="btn btn-primary btn-xs"><i class="fa fa-download" title="Download"></i></a></div>');
                    $m++;
                }
                $data['data'] = $rowData;
                echo json_encode($data);
    }
    
     public function actionDownloadERPDocument(){
        $filename= Yii::app()->request->getparam('filename'); 
        $path = Yii::getPathOfAlias('webroot')."/uploads/documents/".$filename;
        if(!empty($path)){ 
                header("Content-type:application/force-download"); //for txt file
                header('Content-Disposition: attachment; filename="'.basename($path).'"'); 
                header('Content-Length: ' . filesize($path));
                readfile($path);
                Yii::app()->end();
        }
    }
    
    public function actionDeleteERPDocument(){
        $id = $_POST['id'];
        $modelDocument = new Document();
        $modelDocument->deleteByPk($id);
        echo "success";
    }

}