<?php

class CheckinController extends Controller
{
	
    public function accessRules() {
            return array(
                            array('allow', // allow all users to perform 'index' and 'view' actions
                                            'actions' => array('login', 'error', 'logout'),
                                            'users' => array('*'),
                            ),
                            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                                            'actions' => array('Index','GetList','Create','UpdateStockDetails','DivideItemForm'),
                                            'expression' => '$user->isMember()',
                            ),
                            array('deny', // deny all users
                                            'users' => array('*'),
                            ),
            );
    }
    public function actionIndex()
    {
        $frm = Yii::app()->request->getParam('frm');
        $this->render('index',array('frm'=>$frm,'hire'=>$hire));
    }

    public function filters()
    {
            return array(
                            'accessControl', // perform access control for CRUD operations
            );
    }
    public function actionGetList()
    {
        $model=new Checkin();
        
        $frm = Yii::app()->request->getParam('frm');
        $hire = Yii::app()->request->getParam('hire');
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
                        // datatable column index  => database column name
                        0 =>'t.transaction_id',
                        2 => 't.transaction_date',

        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $condition = '1=1';
        if(!empty($frm)){
        switch($frm)
        {
        case 'GR' :
        $condition='t.transaction_type="'.$frm.'" AND t.active="Y" AND transaction.state="CHECK_IN"';
        break;
        case 'GI' :
        $condition='t.transaction_type="'.$frm.'" AND t.active="Y" AND goodsissue.state="CHECK_IN"';
        break;
        }
        }
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
        $searchString = $_POST['search']['value'];
        $condition.=" AND (t.transaction_id LIKE '%".$searchString."%' OR t.customer_id LIKE '%".$searchString."%'/* OR t.checkin_frm LIKE '%".$searchString."%'*/)";
        }
        switch($frm)
        {
        case 'GR' :
        $count = $model->with('transaction')->count(array('condition'=>$condition));
        $model=$model->with('transaction')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'t.transaction_date desc'));
        break;
        case 'GI' :
        $count = $model->with('goodsissue')->count(array('condition'=>$condition));
        $model=$model->with('goodsissue')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'t.transaction_date desc'));
        break;
        }
        
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m = 1;
        foreach ($model as $row)
        {
        $transaction_date=date("d/m/Y", strtotime($row['transaction_date']));
        switch($frm)
        {
        case 'GR' :
        $no=$row->transaction->receipt_no;
        $customer_name=$row->transaction->customer->customer_name;
        $reference=$row->transaction->reference;
        $transaction_id=$row->transaction->id;
        break;
        case 'GI' :
        $no=$row->goodsissue->issue_no;
        $customer_name=$row->goodsissue->customer->customer_name;
        $reference=$row->goodsissue->reference;
        $transaction_id=$row->goodsissue->id;
        break;
        }
        $rowData[]=array($no,$transaction_date,$customer_name,$reference,$transaction_id,$row->transaction_type);
        $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    
    
    public function actionUpdateStockDetails()
    {
    	$transaction_id = $_POST['transaction_id'];
        $checkin_status = $_POST['checkin_status'];
        $file_id = 0;
        $customer_vendor_id=0;
        $customer_vendor_name="";
        if($checkin_status=='CN'){
            $model= new Creditnote();
            $transaction_from='CREDIT_NOTE';
            if($transaction_id>0){
            $modelmas = $model->findByPk($transaction_id);
            $file_id=$modelmas->file_id;
            $customer_vendor_id=$modelmas->customer_id;
            $customer_vendor_name=$modelmas->customer->customer_name;			
            } 
        }
        else if($checkin_status=='PGR'){
            $model= new ProductionGoodsReceipt();
            $transaction_from='PRODUCTION_GOODS_RECEIPT';
        }
        else if($checkin_status=='IGR'){
            $model= new InventoryGoodsReceipt();
            $transaction_from='INVENTORY_GOODS_RECEIPT'; 
            if($transaction_id>0){
    			$modelmas = $model->findByPk($transaction_id);
    			$file_id=$modelmas->file_id;
    			$customer_vendor_id=$modelmas->customer_id;
    			$customer_vendor_name=$modelmas->customer->customer_name;
    				
    				
            }
        }
        else if($checkin_status=='DTCK'){
            $model= new InventoryDirectTransfer();
            $transaction_from='DIRECT_TRANSFER_IN';
        }
        else if($checkin_status=='IDTCK'){
            $model= new InventoryIndirectTransfer();
            $transaction_from='INDIRECT_TRANSFER_IN';
        }
        $valid  = true;
        $other=array();
    	if (is_array($_POST['StockLedger'])) {
        		foreach ($_POST['StockLedger'] as $i => $item) {
        
        			if ( $item['product_id']>0 && $item['quantity'] >0 ) {
        			  
        				$modelStockLedger[$i]                       = new StockLedger;
        				$modelStockLedger[$i]->attributes           = $_POST['StockLedger'][$i];
        				$modelStockLedger[$i]->file_id              = $file_id;
                                                                                   $modelStockLedger[$i]->transaction_type              = $checkin_status;
        				$modelStockLedger[$i]->header_id            = $item['header_id'];
        				$modelStockLedger[$i]->item_id       = $item['item_id'];
        				$modelStockLedger[$i]->customer_vendor_id   = $customer_vendor_id;
        				$modelStockLedger[$i]->product_id           = $item['product_id'];
        				$modelStockLedger[$i]->brand_id             = $item['brand_id'];
        				$modelStockLedger[$i]->warehouse_id         = $item['warehouse_id'];
        				$modelStockLedger[$i]->rack_id              = $item['rack_id'];
        				$modelStockLedger[$i]->bin_id               = $item['bin_id'];
        				$modelStockLedger[$i]->batch_no             = $item['batch_no'];
        				$modelStockLedger[$i]->serial_no            = $item['serial_no'];
        				$modelStockLedger[$i]->quantity             = $item['quantity'];
        				$modelStockLedger[$i]->unit              = $item['unit'];
        				$modelStockLedger[$i]->rate          = $item['rate'];
        				$modelStockLedger[$i]->transaction_date     = $item['transaction_date'];
        				$modelStockLedger[$i]->created_by           = Yii::app()->user->id;
        				$modelStockLedger[$i]->created_time         = date('Y-m-d h:i:s');
        				$modelStockLedger[$i]->stock_updated        = "Y";
        				
        				if($checkin_status=='CN'){
        				    $model_stock_ledger_details    =   StockLedger::model()->find(array('condition' => 'file_id="'.$file_id.'" AND product_id='.$item['product_id'].' AND serial_no="'.$item['serial_no'].'" AND transaction_from="DELIVERY_NOTE"'));
        				    $modelStockLedger[$i]->manufacturing_date       =   $model_stock_ledger_details->manufacturing_date;
        				    $modelStockLedger[$i]->expiry_date              =   $model_stock_ledger_details->expiry_date;
        				    $modelStockLedger[$i]->master_stock_ledger_id   =   $model_stock_ledger_details->id;;
        				    $modelStockLedger[$i]->batch_no                 =   $model_stock_ledger_details->batch_no;
        				}
        				else if($checkin_status=='DTCK'){
        				    $model_stock_ledger_details   =   StockLedger::model()->find(array('condition' => 'header_id="'.$item['header_id'].'" AND product_id='.$item['product_id'].' AND serial_no="'.$item['serial_no'].'" AND transaction_from="DIRECT_TRANSFER_OUT"'));
        				    $modelStockLedger[$i]->master_stock_ledger_id   =   $model_stock_ledger_details->id;;
        				}
        				else{
        				    if($item['manufacturing_date']!='00/00/0000' AND $item['manufacturing_date']!='01/01/1970' AND $item['manufacturing_date'] !=''){
        				        $mf_date  = str_replace('/', '-', $item['manufacturing_date']);
        				        $modelStockLedger[$i]->manufacturing_date = date("Y-m-d", strtotime($mf_date));
        				    }
        				    else{
        				        $modelStockLedger[$i]->manufacturing_date = "0000-00-00";
        				    }
        				    if($item['expiry_date']!='00/00/0000' AND $item['expiry_date']!='01/01/1970' AND $item['expiry_date'] !=''){
        				        $expiry_date                                = str_replace('/', '-', $item['expiry_date']);
        				        $modelStockLedger[$i]->expiry_date          = date("Y-m-d", strtotime($expiry_date));
        				    }
        				    else{
        				        $modelStockLedger[$i]->expiry_date          = "0000-00-00";
        				    }
        				}
        				
        
        				
                        if(!empty($item['serial_no']))
                        {
    
                            //$checkItemSerialNo=$total_available_product = StockLedger::model()->find(array('select' => 'sum(quantity) as quantity','condition'=>'serial_no="'.$item['serial_no'].'" AND product_id="'.$item['product_id'].'"'))->quantity; 
                            $checkItemSerialNo=$total_available_product = StockLedger::model()->find(array('select' => 'sum(quantity) as quantity','condition'=>'serial_no="'.trim($item['serial_no']).'" AND product_id="'.$item['product_id'].'"'))->quantity; 
                            if($checkItemSerialNo>0)
                            {
                                $valid=false;
                                $repeated_item=Inventory::model()->findByPk($item['product_id'])->part_number;
                                $other[]="$repeated_item : Serial No (".$item['serial_no'].") Already Exist";        
                            }
                        
                        }
        				$valid = $modelStockLedger[$i]->validate() && $valid;
        				
        			}
        		}
    
    
    		if ($valid){
    			if($transaction_id>0){
    				$model = $model->findByPk($transaction_id);
    				if($checkin_status=='IGR'){
    					$model->stock_updated = "Y";
    				}
    				else if($checkin_status=='DTCK'){
                        $model->status = "C";
                    }
    				else{
    					$model->is_updated_store = "Y";
    				}
    		       
                    $model->save(false);
                }
                    $randomBatch = $checkin_status.rand(100,10000);
        			if(!empty($modelStockLedger)){
        				foreach ($modelStockLedger as $eachItem) {
        				    $arr_product_details = Inventory::model()->findbyPk($eachItem->product_id);
        				    $existing_store_rate = $arr_product_details->rate;
        				    if($checkin_status=='IGR'){
        				        
        				        
        				        $rate = $existing_store_rate;
                                $existing_qty = ($arr_product_details->totalQuantityIn-$arr_product_details->totalQuantityOut)-($eachItem->quantity * $eachItem->unit_exchange_rate);
        
                                $new_cost_price = $eachItem->rate * $eachItem->quantity;
                                $new_cost_price = round($new_cost_price, 6);
                                $quantity_with_unit_factor = $eachItem->quantity * $eachItem->unit_exchange_rate;
                                $variance_value = ($quantity_with_unit_factor > 0) ? $new_cost_price / $quantity_with_unit_factor : 0;
                                $variance_value = round($variance_value, 6);
                                $cost_with_variance = $variance_value;
        
                                $cur_total = $cost_with_variance * $quantity_with_unit_factor;
                                $existing_amount = $rate * $existing_qty;
                                $total_quantity = $existing_qty + $quantity_with_unit_factor;
                                $total_amount = $existing_amount + $cur_total;
                                $new_amount = ($total_quantity > 0) ? $total_amount / $total_quantity : 0;
                                $new_amount = round($new_amount, 6);
        				        
//        				        $eachItem->rate = $new_amount;
        				        
//        				        Inventory::model()->updateByPk($eachItem->product_id, array('rate' => $new_amount));
        				        
        				        
        				    }
        				    else if($checkin_status=='DTCK'){
        				        $SQL = "UPDATE erp_stock_ledger SET stock_updated='Y' WHERE header_id=".$eachItem->header_id." AND header_item_id=".$eachItem->header_item_id." AND product_id=".$eachItem->product_id." AND transaction_from='DIRECT_TRANSFER_OUT'";
        				        //echo $SQL;
        				         Yii::app()->db->createCommand($SQL)->execute();
        				    }
        				    else{
        				        $eachItem->cost_price = $existing_store_rate;
        				    }
        					if(empty($eachItem->batch_no)){
        						$eachItem->batch_no  = $randomBatch;
        					}
        					$eachItem->save(false);
        					
        				
        				}
                    }
    			echo CJSON::encode( array( 'status' => 'success' ));
    		}
    		else{
 
    			$error2 = array();
    			$error4 = array();
    			$error1 = array();
    			if (!empty($modelStockLedger))
    				$error2 = json_decode(CActiveForm::validateTabular($modelStockLedger, '', false), true);
    			$error = CJSON::encode(array_merge_recursive($error1,$error2,$other));
    			if ($error != '[]'||$error!='')
    				echo $error;
    		}
    	}
    
    
    }
       public function ChanageDB($database = MasCompany::DB_ACE){
        Yii::app()->db->setActive(false);
        Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=' . $database;
        Yii::app()->db->tablePrefix = 'erp_';
        Yii::app()->db->setActive(true);
    }
      public function actionDivideItemForm() 
    {
        $model=new CheckinList();
        $transaction_id = (int) Yii::app()->request->getParam('id');
        $status = Yii::app()->request->getParam('status');
        if ($status != '') {
            $cndn = 'transaction_id=' . $transaction_id . ' AND status="' . $status . '"';
        } else {
            $cndn = 'transaction_id=' . $transaction_id;
        }
        $model  = $model->find(array('condition'=>$cndn));
        $status = $model->status;
        $warehouse = 0;
        $transaction_date=date('Y-m-d');
        if($status=='CN'){
        	$transaction_from='CREDIT_NOTE';
            $model_master 	= Creditnote::model()->findByPk($transaction_id);
            $modelItems  	= CreditnoteItem::model()->findAll(array('condition'=>'creditnote_id ='.$transaction_id.' AND returned_quantity>0'));
            if($model_master->credited_date!="0000-00-00"){
                $transaction_date = $model_master->credited_date;
            }
            
        }else if($status=='PGR'){
        	$transaction_from='PRODUCTION_GOODS_RECEIPT';
            $model_master	= ProductionGoodsReceipt::model()->findByPk($transaction_id);           
            $modelItems  	= ProductionGoodsReceiptItem::model()->findAll(array('condition'=>'production_goods_receipt_id ='.$transaction_id));
            if($model_master->goods_receipt_date!="0000-00-00"){
                $transaction_date = $model_master->goods_receipt_date;
            }
        }
        else if($status=='IGR'){
        	$transaction_from='INVENTORY_GOODS_RECEIPT';
            $model_master	= InventoryGoodsReceipt::model()->findByPk($transaction_id);           
            $modelItems  	= InventoryGoodsReceiptItem::model()->findAll(array('condition'=>'inventory_goods_receipt_id ='.$transaction_id));
            
             if($model_master->goods_receipt_date!="0000-00-00"){
                $transaction_date = $model_master->goods_receipt_date;
            }
        } else if($status=='DTCK'){
        	$transaction_from='DIRECT_TRANSFER_IN';
            $model_master	= InventoryDirectTransfer::model()->findByPk($transaction_id);           
            $modelItems  	= InventoryDirectTransferItem::model()->findAll(array('condition'=>'direct_transfer_id ='.$transaction_id));
           
            $warehouse = $model_master->to_warehouse_id;
            
            if($model_master->transfer_date!="0000-00-00"){
                $transaction_date = $model_master->transfer_date;
            }
        }
        else if($status=='IDTCK'){
        	$transaction_from='INDIRECT_TRANSFER_IN';
            $model_master	= InventoryIndirectTransfer::model()->findByPk($transaction_id);           
            $modelItems  	= InventoryIndirectTransferItem::model()->findAll(array('condition'=>'indirect_transfer_id ='.$transaction_id,'order'=>'item_id'));
            $warehouse = $model_master->to_warehouse_id;
            
            if($model_master->transfer_date!="0000-00-00"){
                $transaction_date = $model_master->transfer_date;
            }
        }
        $k=0;
        if(!empty($modelItems)){
        	foreach ($modelItems as $eachItem) {
        	        $modelItems[$k] = new StockLedger;
        	        
        	        
                    $modelItems[$k]->rate   = "";

                    if($status=='DTCK' || $status=='IDTCK')
                    {
                            $modelItems[$k]->product_id =  $eachItem->item_id;   
                    }
                    else {
                            $modelItems[$k]->product_id =  $eachItem->product_id;       
                    }
                    if(isset($eachItem->quantity) && $status!='CN'){
                            $modelItems[$k]->quantity   = $eachItem->quantity;
                    }
                    elseif(isset($eachItem->picked_qty)){
                            $modelItems[$k]->quantity   = $eachItem->picked_qty;
                    }
                    elseif(isset($eachItem->returned_quantity) && $status=='CN'){
                            $modelItems[$k]->quantity   = $eachItem->returned_quantity+$eachItem->returned_bonus_qty;
                    }else if(isset($eachItem->transfer_qty) && ($status=='DTCK' || $status=='IDTCK')){
                        $modelItems[$k]->quantity   = $eachItem->transfer_qty;
                    }
                    
                    if(isset($eachItem->rate) && $status=='IGR'){
                            $modelItems[$k]->rate     = $eachItem->rate;
                            $modelItems[$k]->unit     = $eachItem->unit;
                            $modelItems[$k]->bill_of_entry_exit    = $eachItem->bill_of_entry;
                    }
                    elseif($status=='DTCK' && isset($eachItem->stock->rate)){
                        
                            $modelItems[$k]->rate     = $eachItem->stock->rate;
                            $modelItems[$k]->unit       = $eachItem->stock->unit_id;
                    }
                    else{
                            $arr_product_details =Inventory::model()->findByPk($eachItem->product_id);
                            $modelItems[$k]->rate     = $arr_product_details->rate;
                            $modelItems[$k]->unit       = $arr_product_details->unit_id;
                    }
                    
                    $modelItems[$k]->id   = $eachItem->id;
                    $modelItems[$k]->header_id   = $transaction_id;
                    $modelItems[$k]->item_id   = $eachItem->id;
                    $modelItems[$k]->customer_vendor_id   = 0;
                    
                    $k++;
        	}
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false , 'jquery-2.1.4.min.js' => false);
        $this->render('createdivideform',array('model'=>$model_master,'status'=>$status,'items'=>$modelItems, 'warehouse' => $warehouse,'transaction_date'=>$transaction_date));
    }
}