<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'voucher-form' . rand(),
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
));
$cs = Yii::app()->getClientScript();
$cs->registerScript("updatetextfield", "function updatetextfield(field_id,value){
            var arr_field_id = field_id.split('_');
            var no = arr_field_id[1];
            jQuery.ajax({
                'type': 'post',
                'url': '" . Yii::app()->createUrl('finance/core/havesubledger') . "',
                'data' : {'account' : value},
                'success': function(data) {
                    if( data == 'true' ){
                        $('#FinanceVoucherItems_'+no+'_subledger_name').attr( 'readonly', false );
                        $('#FinanceVoucherItems_'+no+'_subledger_name').removeAttr('tabindex');
                        $('#FinanceVoucherItems_'+no+'_subledger_id').val('');
                    }else{
                        $('#FinanceVoucherItems_'+no+'_subledger_name').attr( 'readonly', true );
                        $('#FinanceVoucherItems_'+no+'_subledger_name').val('');
                        $('#FinanceVoucherItems_'+no+'_subledger_id').val('');
                        $('#FinanceVoucherItems_'+no+'_subledger_name').attr( 'tabindex', '-1');
                    }
                }
            });
        }", CClientScript::POS_HEAD);
$cs->registerScript("loadtemplate", "function loadtemplate(){
            var voucher_type = $('#FinanceVoucherHead_voucher_type').val();
            var payment_method = $('#FinanceVoucherHead_payment_method').val();
           
                jQuery.ajax({
                    'type': 'post',
                    'url': '" . Yii::app()->createUrl('finance/vouchers/loadtemplate') . "',
                    'data' : {'voucher_type' : voucher_type, 'payment_method' : payment_method},
                    'success': function(data) {
                        $('#template_div').html(data);
                        calculateTotal();
                    }
                });

        }", CClientScript::POS_HEAD);
        $cs->registerScript("getExchange", "function getExchange(field_id, currency){
            var arr_field_id = field_id.split('_');
            var i = arr_field_id[1];
            jQuery.ajax({
                'type': 'post',
                'url': '" . Yii::app()->createUrl('finance/vouchers/getexchange_rate') . "',
                'data' : {'currency' : currency},
                'success': function(data) {
                    $('#FinanceVoucherItems_'+i+'_exchange_rate').val(data);
                    calculateTotal();
                }
            });

        }", CClientScript::POS_HEAD);
$cs->registerScript("getLegders", "function getLedgers(field_id)
        {
            var arr_field_id = field_id.split('_');
            var i = arr_field_id[1];

            $('#FinanceVoucherItems_'+i+'_ledger_id').val('');
            $('#FinanceVoucherItems_'+i+'_subledger_name').val('');
            $('#FinanceVoucherItems_'+i+'_subledger_id').val('');

                var url = '" . Yii::app()->createUrl('finance/vouchers/ledgerlist') . "';
                $('#'+field_id).autocomplete({
                    minLength   : 1,
                    source      : function (request, response) { autoCompleteSource(request, response, url) },
                    focus       : function( event, ui ) { $(this).val((ui.item.description)); return false; },
                    select          : function( event, ui ) {
                        event.preventDefault();
                        $('#FinanceVoucherItems_'+i+'_ledger_name').val(ui.item.description);
                        $('#FinanceVoucherItems_'+i+'_ledger_id').val(ui.item.value);
                        $('#FinanceVoucherItems_'+i+'_haveSubledger').val(ui.item.other);
                        updatetextfield('#\FinanceVoucherItems_'+i+'_ledger_id', ui.item.value);
                    }
                });
        }", CClientScript::POS_HEAD);
$cs->registerScript("getSublegders", "function getSublegders(field_id)
        {
            var arr_field_id = field_id.split('_');
            var i = arr_field_id[1];
            var account_id = $('#FinanceVoucherItems_'+i+'_ledger_id').val();

            if( account_id > 0 ){
                var url = '" . Yii::app()->createUrl('finance/vouchers/subledgerlist') . "&ledger='+account_id;
                $('#'+field_id).autocomplete({
                    minLength   : 1,
                    source      : function (request, response) { autoCompleteSource(request, response, url) },
                    focus       : function( event, ui ) { $(this).val((ui.item.label)); return false; },
                    select          : function( event, ui ) {
                        event.preventDefault();
                        $('#FinanceVoucherItems_'+i+'_subledger_name').val(ui.item.label);
                        $('#FinanceVoucherItems_'+i+'_subledger_id').val(ui.item.value);
                    }
                })
            }else{
                t8.error('Choose Ledger First!');
                $('#FinanceVoucherItems_'+i+'_subledger_name').val('');
                return false;
            }
        }", CClientScript::POS_HEAD);
        $cs->registerScript("getOrders", "function getOrders(field_id)
        {
            var arr_field_id = field_id.split('_');
            var i = arr_field_id[1];
            var subledger_id=$('#FinanceVoucherItems_'+i+'_subledger_id').val();
                var url = '" . Yii::app()->createUrl('finance/vouchers/getorders') . "'+'&subledger_id='+subledger_id;
                $('#'+field_id).autocomplete({
                    minLength   : 1,
                    source      : function (request, response) { autoCompleteSource(request, response, url) },
                    focus       : function( event, ui ) { $(this).val((ui.item.value)); return false; },
                    select          : function( event, ui ) {
                        event.preventDefault();
                        $('#FinanceVoucherItems_'+i+'_brand_id').val(ui.item.value);
                    }
                });
        }", CClientScript::POS_HEAD);
$cs->registerScript('calculateTotal', 'function calculateTotal(){
            var creditTotal = 0;
            var debitTotal = 0;
            var debit, credit, ex_rate;
            $("#voucher_entries").find("tr:gt(0)").each(function() {
                debit = parseFloat($(this).find("[id $=_debit]").val().replace(/,/g, "") );
                ex_rate = parseFloat($(this).find("[id $=_exchange_rate]").val() );
                if( parseFloat($(this).find("[id $=_debit]").val().replace(/,/g, "") ) > 0 )
                {
                    // debitTotal += roundToTwo(( debit * ex_rate));
                    debitTotal += debit*ex_rate.toFixed(2);
                }
                credit = parseFloat($(this).find("[id $=_credit]").val().replace(/,/g, "") );
                if( parseFloat($(this).find("[id $=_credit]").val().replace(/,/g, "") ) > 0 )
                {
                    // creditTotal += roundToTwo(( credit * ex_rate ));
                    creditTotal += credit*ex_rate.toFixed(2);
                }
            });
            var formatted_value_debit = debitTotal > 0 ? parseFloat(debitTotal)
            .toFixed(2)
            .toString()
            .replace(/\B(?=(\d{3})+(?!\d))/g, ",") : 0.00;
            
            var formatted_value_credit = creditTotal > 0 ? parseFloat(creditTotal)
            .toFixed(2)
            .toString()
            .replace(/\B(?=(\d{3})+(?!\d))/g, ",") : 0.00;

            var balance = Number(debitTotal) - Number(creditTotal);
            var formatted_balance = parseFloat(balance)
            .toFixed(2)
            .toString()
            .replace(/\B(?=(\d{3})+(?!\d))/g, ",");
            
            $("#debit_total").val( formatted_value_debit );
            $("#credit_total").val( formatted_value_credit );
            $("#difference_in_total").val( formatted_balance );
        }', CClientScript::POS_HEAD);
$cs->registerScript("nextline", "function nextline(event)
        {
            if (event.keyCode == 13) {
                event.preventDefault();
                newVoucher($('#voucher_entries'));
                return false;
            }
        }", CClientScript::POS_HEAD);
$cs->registerScript("newVoucher", " function newVoucher(jQtable) {
            formId              =   jQtable.attr('id');
            formIdStarter       =   jQtable.attr('id').split(/_(.+)?/)[0];
            lastId = jQtable.find('tr:last input:first').attr('id');
            thenum = lastId.match(/\d+/g);
            var narration = $('#FinanceVoucherItems_'+thenum+'_narration').val();
            var old_currency_id = $('#FinanceVoucherItems_'+thenum+'_currency_id').val();
            var old_exchange_rate = $('#FinanceVoucherItems_'+thenum+'_exchange_rate').val();
            newId = Number(thenum) + 1;
            newrow= jQtable.find('tr:last').clone();
            newrow.find('label:first').html(newId+1);
            newrow.attr('class',newId);
            newrow.find('.hasDatepicker').removeClass('hasDatepicker');
            newrow.find('.datetimepicker').siblings().remove();
            newrow.find('.datetimepicker').datetimepicker( 'destroy' );
            newrow.find('div,input,textarea,checkbox,td,select,.errorMessage,a').each(function() {
                this.id= this.id.replace(/\d+/,newId);
                if(!$(this).is(':checkbox'))
                    this.value  = '';
                else
                    $(this).prop('checked', false);
                (this.name!==undefined) ? this.name= this.name.replace(/\d+/,newId) : this.style = '';
            });
            jQtable.append(newrow);
            $('#FinanceVoucherItems_'+newId+'_narration').val(narration);
            $('#FinanceVoucherItems_'+newId+'_debit').attr( 'readonly', false );
            $('#FinanceVoucherItems_'+newId+'_credit').attr( 'readonly', false );
            $('#FinanceVoucherItems_'+newId+'_ledger_name').focus();
            $('#FinanceVoucherItems_'+newId+'_currency_id').val(old_currency_id); //AED
            $('#FinanceVoucherItems_'+newId+'_exchange_rate').val(old_exchange_rate); //AED
        }", CClientScript::POS_HEAD);
$cs->registerScript("changeDiv", "function changeDiv(value)
        {
            var payment_method = $('#FinanceVoucherHead_voucher_type').val();
            if( value == 2 || value == 13 ){
                $('#cheque_div').show();
                $('#card_div').hide();
                if( payment_method == 2 )
                    $('#bank_name_div').show();
                else
                    $('#bank_name_div').hide();
            }else if(value == 4 ){
                $('#cheque_div').hide();
                $('#card_div').show();
                $('#bank_name_div').hide();
            }else if( value == 3 ){
                if( payment_method == 2 )
                    $('#bank_name_div').show();
                else
                    $('#bank_name_div').hide();
                $('#cheque_div').hide();
                $('#card_div').hide();
            }else{
                $('#cheque_div').hide();
                $('#card_div').hide();
                $('#bank_name_div').hide();
            }
            loadtemplate();
            calculateTotal();
        }", CClientScript::POS_HEAD);
// $cs->registerScript("getRates" ,"function getRates(value)
// {
//     var conversionCode = value.concat('_');
//     conversionCode = conversionCode.concat('AED');

//     jQuery.ajax({
//         'type': 'GET',
//         'url': 'https://free.currencyconverterapi.com/api/v5/convert?q='+conversionCode+'&compact=y',
//         'success': function(data) {
//           var response = Object.values(data);
//           $('#FinanceVoucherHead_exchange_rate').val(Number(response[0]['val']).toFixed(8));
//         }
//     });
// }", CClientScript::POS_HEAD);
$cs->registerScript("format_currency", "function format_currency(field_id)
{
    var currency = $('#'+field_id).val().replace(/,/g, '') > 0 ?  $('#'+field_id).val().replace(/,/g, '') : 0;
    var formatted_value = currency > 0 ? parseFloat(currency.replace(/,/g, ''))
    .toFixed(2)
    .toString()
    .replace(/\B(?=(\d{3})+(?!\d))/g, ',') : 0.00;
    $('#'+field_id).val(formatted_value);
}", CClientScript::POS_HEAD);

$debitTotal = 0;
$creditTotal = 0;

?>

<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-2">
                <?php echo $form->dropdownlist($model, 'voucher_type', FinanceVoucherType::getTypes(false), array('data-label' => 'Voucher Type', 'onChange' => 'if( this.value == 1 || this.value == 2 || this.value == 12 || this.value == 13 ){ $("#voucherDifference_div").show();  if( this.value == 1 || this.value == 12 || this.value == 13 ){ $("#bank_name_div").hide(); } }else{ $("#voucherDifference_div").hide(); } loadtemplate();')); // receipt or Payment    ?>
                <?php echo $form->hiddenField($model, 'id'); ?>
            </li>
            <li class="col-sm-2">
                <?php echo $form->textField($model, 'voucher_date', array('data-label' => 'Voucher Date', 'class' => 'datepicker')); ?>
            </li>
            <li class="col-sm-2">
                    <?php echo $form->textField($model, 'reference_no', array('data-label' => 'Reference', 'class' => 'tooltipster')); ?>
                </li>
            <div id="voucherDifference_div" style="display:<?php echo (in_array($model->voucher_type, array(1, 2))) ? 'block' : 'none' ?>">
                <li class="col-sm-2">
                    <?php echo $form->textField($model, 'paid_or_received', array('data-label' => 'Paid to/ Received from', 'class' => 'tooltipster')); ?>
                </li>
                <li class="col-sm-3">
                    <?php echo $form->dropdownlist($model, 'payment_method', array(1 => 'Cash', 2 => 'Cheque', 3 => 'Bank', 4 => 'Card'), array('data-label' => 'Payment method', 'onChange' => 'changeDiv(this.value);')); ?>
                </li>
                <li class="col-sm-3" id="bank_name_div" style="display:<?php echo (in_array($model->payment_method, array(2, 3)) && $model->voucher_type == 2) ? 'block' : 'none' ?>">
                        <?php echo $form->textField($model, 'bank_name', array('data-label' => 'Bank', 'class' => 'tooltipster')); ?>
                </li>
                <div id="cheque_div" style="display:<?php echo (in_array($model->payment_method, array(2))) ? 'block' : 'none' ?>">

                    <li class="col-sm-2">
                        <?php echo $form->textField($model, 'cheque_no', array('data-label' => 'Cheque No', 'class' => 'tooltipster')); ?>
                    </li>
                    <li class="col-sm-2">
                        <?php $model->cheque_date = ($model->isNewRecord) ? date('d/m/Y') : date('d/m/Y', strtotime($model->cheque_date))?>
                        <?php echo $form->textField($model, 'cheque_date', array('data-label' => 'Cheque Date', 'class' => 'tooltipster datepicker')); ?>
                    </li>
                    <li class="col-sm-2">
                    <?php echo $form->dropdownlist($model, 'account_payee', array('Y' => 'YES', 'N' => 'NO'), array('data-label' => 'Account Payee')); ?>
                    </li>
                    <!-- <li class="col-sm-2">
                        <?php //$model->realisation_date = ( $model->isNewRecord ) ? date('d/m/Y') : date('d/m/Y', strtotime( $model->realisation_date )) ?>
                        <?php //echo $form->textField($model,'realisation_date',array('data-label'=>'Realisation date', 'class' => 'tooltipster datepicker' )); ?>
                    </li> -->
                </div>
                <div id="card_div" style="display:<?php echo (in_array($model->payment_method, array(4))) ? 'block' : 'none' ?>">
                    <li class="col-sm-3">
                        <?php echo $form->textField($model, 'card_no', array('data-label' => 'Card No', 'class' => 'tooltipster')); ?>
                    </li>
                    <li class="col-sm-3">
                        <?php echo $form->textField($model, 'cvv_no', array('data-label' => 'CVV', 'class' => 'tooltipster')); ?>
                    </li>
                </div>
            </div>
        </ul>

            <table class="table table-bordered" id="voucher_entries" >
                    <thead>
                        <tr>
                            <th style="width:1%">No</th>
                            <th style="width:18%">Ledger</th>
                            <th style="width:18%">Subledger</th>
                            <th style="width:10%">Dr</th>
                            <th style="width:10%">Cr</th>
                            <th style="width:12%">Currency</th>
                            <th style="width:15%">Narration</th>
                            <th style="width:1%"class="text-center"><a class="btn btn-xs btn-theme " href="javascript:void(0);" onclick="newVoucher($('#voucher_entries'));"><i class="fa fa-plus"></i></a></th>
                        </tr>
                    </thead>
                    <tbody id="template_div">
                        <?php foreach ((!$model->isNewrecord) ? $model->items : array(new FinanceVoucherItems) as $i => $each): ?>
                                <tr>
                                    <td><label><?php echo $i + 1; ?></label></td>
                                    <td>
                                        <?php echo $form->hiddenField($each, "[" . $i . "]id"); ?>
                                        <?php echo $form->hiddenField($each, "[" . $i . "]ledger_id"); ?>
                                        <?php 
                                            $each->haveSubledger = $each->ledger->haveSubledger;
                                            $each->ledger_name = $each->ledger->description; 
                                        ?>
                                        <?php echo $form->textField($each, "[" . $i . "]ledger_name", array('class' => 'form-control', 'onKeypress' => 'js:getLedgers(this.id);')); ?>
                                        <?php echo $form->hiddenField($each, "[" . $i . "]haveSubledger"); ?>
                                    </td>
                                    <td id="debit_<?php echo $i ?>">
                                        <?php echo $form->hiddenField($each, "[" . $i . "]subledger_id"); ?>
                                        <?php $each->subledger_name = ($each->subledger_id > 0) ? $each->subledger->description : '';?>
                                        <?php echo $form->textField($each, "[" . $i . "]subledger_name", array('data-label' => 'Subledger', 'class' => 'form-control', 'onKeyup' => 'js:getSublegders(this.id);', 'readonly' => (!$each->isNewRecord && !$each->haveSublegder()) ? true : false)); ?>
                                    </td>
                                    <?php
                                        if ($each->amount > 0) {
                                            $each->debit = Yii::app()->numberFormatter->formatCurrency($each->amount, " ");
                                            $debitTotal += round(( $each->amount * $each->exchange_rate ), 2);
                                        }

                                        if ($each->amount < 0) {
                                            $each->credit = Yii::app()->numberFormatter->formatCurrency(abs($each->amount), " ");
                                            $creditTotal += round(abs($each->amount* $each->exchange_rate), 2);
                                        }
                                        ?>
                                    <td>
                                        <?php echo $form->textField($each, "[" . $i . "]debit", array('data-label' => 'Debit', 'class' => 'form-control text-right', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculateTotal();', 'onBlur' => 'format_currency(this.id);', 'onkeydown' => 'nextline(event)')); ?>
                                    </td>
                                    <td>
                                        <?php echo $form->textField($each, "[" . $i . "]credit", array('data-label' => 'Credit', 'class' => 'form-control text-right', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculateTotal();', 'onBlur' => 'format_currency(this.id);', 'onkeydown' => 'nextline(event)')); ?>
                                    </td>
                                    <td class="nw">
                                        <?php echo $form->dropdownlist($each, "[" . $i . "]currency_id", MasCurrency::getCurrency_codes(), array('class' => 'txt-6 go exception', 'style' => 'width:100px', 'onChange' => 'getExchange(this.id, this.value);')) . ' ' . $form->textField($each, "[" . $i . "]exchange_rate", array('class' => 'txt-6 go exception text-right', 'onkeyup' => 'calculateTotal();')); ?>
                                    </td>
                                    <td>
                                        <?php echo $form->textArea($each, "[" . $i . "]narration", array('data-label' => 'Narration', 'class' => 'form-control', 'onkeydown' => 'nextline(event)')); ?>
                                    </td>
                                    <td class="text-center nw" width="1%"><?php echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('tabindex' => '-1', 'class' => 'btn btn-xs btn-danger', 'onclick' => 'removeTableRow($(\'#voucher_entries\'),this)', 'title' => 'Remove this item')); ?></td>
                                </tr>
                            <?php endforeach;?>
                        </tbody>
                </table>
                <table class="table table-hover table-bordered personal-task"  >
                    <tr>
                        <th colspan="4" class="text-right" style="width: 36.45%;"><b>Total (<?php echo FinanceLegder::baseCurrency(); ?>)</b></th>
                        <th style="width: 8.65%;text-align:right !important;"><?php echo CHtml::textfield('debit_total', Yii::app()->numberFormatter->formatCurrency($debitTotal, " "), array('tabindex' => '-1', 'class' => 'form-control text-bold', 'readonly' => true)); ?></th>
                        <th style="width: 8.85%;text-align:right !important;"><?php echo CHtml::textfield('credit_total', Yii::app()->numberFormatter->formatCurrency($creditTotal, " "), array('tabindex' => '-1', 'class' => 'form-control text-bold', 'readonly' => true)); ?></th>
                        <th style="width: 11.85%;text-align:right !important;"><?php echo CHtml::textfield('difference_in_total', Yii::app()->numberFormatter->formatCurrency(($debitTotal-$creditTotal), " "), array('tabindex' => '-1', 'class' => 'form-control text-bold', 'readonly' => true)); ?></th>
                        <th></th>
                    </tr>
                </table>
                <ul class="clearfix form-ul material">
                    <li class="col-sm-12">
                        <?php echo $form->textArea($model, 'general_narration', array('data-label' => 'Narration', 'class' => 'tooltipster')); ?>
                    </li>
                </ul>
            </div>
        </div>
        <div class="modal-footer">
    <button type="button" class="btn btn-danger" id="cust_close" data-dismiss="modal">Close</button>
    <?php

echo CHtml::ajaxSubmitButton('Save', Yii::app()->createUrl('finance/vouchers/savevoucher'), array(
    'dataType' => 'json',
    'type' => 'post',
    'success' => 'function(data) {
                            $("#loader").hide();
                            if(data.status=="success"){
                                t8.success("Done!");
                                if( data.scene == "new" )
                                    loadPopupModal("finance/vouchers/create&voucher_type="+$("#FinanceVoucherHead_voucher_type").val()+"&date="+$("#FinanceVoucherHead_voucher_date").val(),"New Voucher","xl");
                                else
                                    $(".x.close").click();
                                reloadTable("#fin_voucher_table");
                            }else{
                                $.each(data, function(key, val) {
                                    t8.error(""+val+"");
                                });
                            }
                        }',
                        'beforeSend' => 'function(){
                            var havesublegder = "N";
                            var subledger = 0;
                            var valid = true;
        
                            $("#voucher_entries").find("tr:gt(0)").each(function() {
                                havesublegder = $(this).find("[id $=_haveSubledger]").val();
                                subledger =  Number($(this).find("[id $=_subledger_id]").val());
                                if( havesublegder == "Y" && subledger == 0 ){
                                    $(this).find("[id $=_subledger_name]").css("border", "1px solid red");
                                    valid = false;
                                }
                            });
                            
                            var creditTotal = Number($("#credit_total").val().replace(/,/g, "") ) ;
                            var debitTotal = Number($("#debit_total").val().replace(/,/g, "") ) ;
                            // if( valid && ( debitTotal == creditTotal && debitTotal > 0 && creditTotal > 0 ) || ( $("#FinanceVoucherHead_voucher_type").val() == 5  && ( debitTotal > 0 || creditTotal > 0 ) ) )
                            if( valid && ( debitTotal == creditTotal && debitTotal > 0 && creditTotal > 0 ))
                            {
                                $("#loader").show();
                            }else{
                                if( !valid ){
                                    t8.error("Subledger cannot blank!");
                                }else
                                    t8.error("Totals are not matching!");
                                return false;
                            }
                    }',
), array('id' => 'mybtn' . rand(), 'class' => 'voucher-submit btn btn-theme'));

?>
    <?php
if( Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["finance_post_voucher"] ) 
{
echo CHtml::ajaxSubmitButton('Post', Yii::app()->createUrl('finance/vouchers/postvoucher'), array(
    'dataType' => 'json',
    'type' => 'post',
    'success' => 'function(data) {
                            $("#loader").hide();
                            if(data.status=="success"){
                                t8.success("Done!");
                                if( data.scene == "new" )
                                    loadPopupModal("finance/vouchers/create&voucher_type="+$("#FinanceVoucherHead_voucher_type").val()+"&date="+$("#FinanceVoucherHead_voucher_date").val(),"New Voucher","xl");
                                else
                                    $(".x.close").click();
                                reloadTable("#fin_voucher_table");
                            }else{
                                $.each(data, function(key, val) {
                                    t8.error(""+val+"");
                                });
                            }
                        }',
                        'beforeSend' => 'function(){
                            var havesublegder = "N";
                            var subledger = 0;
                            var valid = true;
        
                            $("#voucher_entries").find("tr:gt(0)").each(function() {
                                havesublegder = $(this).find("[id $=_haveSubledger]").val();
                                subledger =  Number($(this).find("[id $=_subledger_id]").val());
                                if( havesublegder == "Y" && subledger == 0 ){
                                    $(this).find("[id $=_subledger_name]").css("border", "1px solid red");
                                    valid = false;
                                }
                            });
                            
                            var creditTotal = Number($("#credit_total").val().replace(/,/g, "") ) ;
                            var debitTotal = Number($("#debit_total").val().replace(/,/g, "") ) ;
                            // if( valid && ( debitTotal == creditTotal && debitTotal > 0 && creditTotal > 0 ) || ( $("#FinanceVoucherHead_voucher_type").val() == 5  && ( debitTotal > 0 || creditTotal > 0 ) ) )
                            if( valid && ( debitTotal == creditTotal && debitTotal > 0 && creditTotal > 0 ))
                            {
                                $("#loader").show();
                            }else{
                                if( !valid ){
                                    t8.error("Subledger cannot blank!");
                                }else
                                    t8.error("Totals are not matching!");
                                return false;
                            }
                    }',
), array('id' => 'mybtn' . rand(), 'class' => 'voucher-submit btn btn-theme'));
}
?>
<?php
if( Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["finance_post_voucher"] && (int) Yii::app()->user->havePermissionOn["finance_allocation_add"])) 
{
echo CHtml::ajaxSubmitButton('Post & Allocation', Yii::app()->createUrl('finance/vouchers/postvoucher'), array(
    'dataType' => 'json',
    'type' => 'post',
    'success' => 'function(data) {
                            $("#loader").hide();
                            if(data.status=="success"){
                                t8.success("Done!");
                                if( data.scene == "new" )
                                    loadPopupModal("finance/vouchers/allocateVoucher","New Allocation","xl");
                                else
                                    $(".x.close").click();
                                reloadTable("#fin_voucher_table");
                            }else{
                                $.each(data, function(key, val) {
                                    t8.error(""+val+"");
                                });
                            }
                        }',
                        'beforeSend' => 'function(){
                            var havesublegder = "N";
                            var subledger = 0;
                            var valid = true;
        
                            $("#voucher_entries").find("tr:gt(0)").each(function() {
                                havesublegder = $(this).find("[id $=_haveSubledger]").val();
                                subledger =  Number($(this).find("[id $=_subledger_id]").val());
                                if( havesublegder == "Y" && subledger == 0 ){
                                    $(this).find("[id $=_subledger_name]").css("border", "1px solid red");
                                    valid = false;
                                }
                            });
                            
                            var creditTotal = Number($("#credit_total").val().replace(/,/g, "") ) ;
                            var debitTotal = Number($("#debit_total").val().replace(/,/g, "") ) ;
                            // if( valid && ( debitTotal == creditTotal && debitTotal > 0 && creditTotal > 0 ) || ( $("#FinanceVoucherHead_voucher_type").val() == 5  && ( debitTotal > 0 || creditTotal > 0 ) ) )
                            if( valid && ( debitTotal == creditTotal && debitTotal > 0 && creditTotal > 0 ))
                            {
                                $("#loader").show();
                            }else{
                                if( !valid ){
                                    t8.error("Subledger cannot blank!");
                                }else
                                    t8.error("Totals are not matching!");
                                return false;
                            }
                    }',
), array('id' => 'mybtn' . rand(), 'class' => 'voucher-submit btn btn-theme'));
}
?>
    </div>
<?php $this->endWidget();?>

    <script>

        $(function() {
            <?php if ($model->isNewrecord): ?>
                loadtemplate();
            <?php endif;?>
        });

        function roundToTwo(num) {    
            return +(Math.round(num + "e+2")  + "e-2");
        }
        // $(window).bind('keydown', function(event) {
        //     if (event.ctrlKey || event.metaKey) {
        //         if ( String.fromCharCode(event.which).toLowerCase() == 's' ) {
        //             event.stopImmediatePropagation();
        //             $(".voucher-submit").click();
        //             return false;
        //         }
        //     }
        // });
    </script>