<?php
     $form = $this->beginWidget('CActiveForm', array(
            'id' => 'voucher-form',
            'enableAjaxValidation' => false,
            'enableClientValidation' => false,
        ));
        $cs = Yii::app()->getClientScript();
        $cs->registerScript("updatetextfield", "function updatetextfield(value){
            
            jQuery.ajax({
                'type': 'post',
                'url': '" . Yii::app()->createUrl('finance/core/havesubledger') . "',
                'data' : {'account' : value},
                'success': function(data) { 
                    if( data == 'true' ){
                        $('#receipt_subledger_label').attr( 'disabled', false );
                        $('#receipt_subledger_id').val('');
                    }else{
                        $('#receipt_subledger_label').attr( 'disabled', true );
                        $('#receipt_subledger_label').val('');
                        $('#receipt_subledger_id').val('');
                    }
                }
            });
        }", CClientScript::POS_HEAD);
        $cs->registerScript("reloadPage", "function reloadPage(ledger, subledger){
            if( subledger > 0 && ledger > 0 ) {
                $('#loader').show();
                jQuery.ajax({
                    'type': 'post',
                    'dataType' : 'json',
                    'url': '" . Yii::app()->createUrl('finance/vouchers/getallocationdata_for_receipt') . "',
                    'data' : {'ledger' : ledger, 'subledger' : subledger},
                    'success': function(data) { 
                        $('#loader').hide();
                        $('#debit_table').html(data.debit);
                    }
                });
            }else{
                t8.error('Choose subledger!');
            }
        }", CClientScript::POS_HEAD);
        $cs->registerScript("getcustmer_Sublegders", "function getcustmer_Sublegders(field_id)
        {
            var account_id = ".FinanceSystemAccountsMapping::getSystemdefault('debtors').";
            $('#debit_table').empty();
            if( account_id > 0 ){
                var url = '" . Yii::app()->createUrl('finance/vouchers/subledgerlist') . "&ledger='+account_id;
                $('#'+field_id).autocomplete({
                    minLength   : 1,
                    source      : function (request, response) { autoCompleteSource(request, response, url) },
                    focus       : function( event, ui ) {},
                    select          : function( event, ui ) {
                        event.preventDefault();
                        $('#customer_subledger_name').val(ui.item.label);
                        $('#customer_subledger_id').val(ui.item.value);
                        reloadPage(account_id, ui.item.value);
                    }
                })
            }else{
                t8.error('Choose Ledger First!');
                $('#customer_subledger_name').val('');
                return false;
            }
        }", CClientScript::POS_HEAD); 
        $cs->registerScript("getSublegders", "function getSublegders(field_id)
        {
            var account_id = $('#receipt_ledger').val();
            if( account_id > 0 ){
                var url = '" . Yii::app()->createUrl('finance/vouchers/subledgerlist') . "&ledger='+account_id;
                $('#'+field_id).autocomplete({
                    minLength   : 1,
                    source      : function (request, response) { autoCompleteSource(request, response, url) },
                    focus       : function( event, ui ) {},
                    select          : function( event, ui ) {
                        event.preventDefault();
                        $('#receipt_subledger_label').val(ui.item.label);
                        $('#receipt_subledger_id').val(ui.item.value);
                    }
                })
            }else{
                t8.error('Choose Ledger First!');
                $('#receipt_subledger_label').val('');
                return false;
            }
        }", CClientScript::POS_HEAD); 
        $cs->registerScript("validateAmount", "function validateAmount(from, field_id, value){
            var arr_field_id = field_id.split('_');
            var i = arr_field_id[1];
            var limit = parseFloat($('#'+from+'_'+i+'_balance').val());
            if( parseFloat(value) > limit ){
                t8.error('Exceed limit!');
                $('#'+field_id).val('');
            }
        }", CClientScript::POS_HEAD);
        $cs->registerScript("copyValue", "function copyValue(from, evnt, field_id){
            var arr_field_id = field_id.split('_');
            var i = arr_field_id[1];
            if( $(evnt).prop('checked') ){
                $('#'+from+'_'+i+'_amount').val($('#'+from+'_'+i+'_balance').val());
            }else{
                $('#'+from+'_'+i+'_amount').val(0);
            }
        }", CClientScript::POS_HEAD);
        $cs->registerScript("calculateValue", "function calculateValue(){
            var total_debit = 0;
            $('#voucher_entries').find('tr:gt(0)').each(function() {
                if( $(this).find('[id $=_amount]').val() > 0 )
                    total_debit += parseFloat($(this).find('[id $=_amount]').val());
            });
            $('#total_debit').val(Number(total_debit).toFixed(2));
    
        }", CClientScript::POS_HEAD);

?>

<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-2">
                <?php 
                    $model->voucher_date = ( $model->isNewRecord ) ? date('d/m/Y') : date('d/m/Y', strtotime( $model->voucher_date ));
                    $model->voucher_type = 2; //Receipt Voucher
                ?>
                <?php echo $form->textField($model,'voucher_date',array('data-label'=>'Voucher Date *', 'class' => 'datepicker' )); ?>
                <?php echo $form->hiddenField($model, 'voucher_type' ); // receipt or Payment ?>
                <?php echo $form->hiddenField($model, 'id'); ?>
            </li>
            <li class="col-sm-6">
                <?php echo CHtml::textField('customer_subledger_name', '',array('data-label'=>'Customer *', 'class' => 'tooltipster', 'onKeyup' => 'js:getcustmer_Sublegders(this.id);' )); ?>
                <?php echo CHtml::hiddenField('customer_subledger_id'); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->textField($model,'reference_no',array('data-label'=>'Reference', 'class' => 'tooltipster' )); ?>
            </li>
            <li class="col-sm-2">
                <?php echo CHtml::textField('amount', '',array('data-label'=>'Amount *', 'onkeypress' => 'return isNumberKey(event)')); ?>
            </li>
            <li class="col-sm-5">
                <?php echo CHtml::dropdownlist('receipt_ledger', '', FinanceLegder::getCash_accounts(), array('data-label'=>'Receipt Ledger *', 'prompt' => 'Choose', 'onChange' => 'js:updatetextfield(this.value)')); ?>
            </li>
            <li class="col-sm-5">
                <?php echo CHtml::textField('receipt_subledger_label', '', array('data-label'=>'Receipt Subledger', 'onKeyup' => 'js:getSublegders(this.id);')); ?>
                <?php echo CHtml::hiddenField('receipt_subledger_id'); ?>
            </li>
            <li class="col-sm-12">
                <?php echo CHtml::textArea('general_narration','',array('data-label'=>'Narration *', 'class' => 'tooltipster' )); ?>
            </li>
        </ul>
            <table class="table table-bordered" id="voucher_entries" >        
                    <thead>
                        <tr>
                            <th></th>
                            <th style="width:20%">Voucher No</th>            
                            <th style="width:20%">Type</th>
                            <th style="width:20%">Date</th>
                            <th style="width:20%">Balance</th>     
                            <th style="width:20%">Amount</th>       
                        </tr>
                    </thead>
                    <tbody id="debit_table">
                        <tr><td colspan="6" class="text-center">No Data</td></tr>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="modal-footer">
    <button type="button" class="btn btn-danger" id="cust_close" data-dismiss="modal">Close</button>
    <?php
        
        echo CHtml::ajaxSubmitButton('Save', Yii::app()->createUrl('finance/vouchers/savereceiptvoucher'), array(
            'dataType' => 'json',
            'type' => 'post',
            'success' => 'function(data) {
                            $("#loader").hide();
                            if(data.status=="success"){  
                                t8.success("Done!");
                                if( data.scene == "new" )
                                    loadPopupModal("finance/vouchers/createreceipt","New Receipt","lg");
                                else
                                    $(".x.close").click();
                                reloadTable("#fin_voucher_table");
                            }else{ 
                                $.each(data, function(key, val) {
                                    t8.error(""+val+""); 
                                }); 
                            } 
                        }',
                        'beforeSend' => 'function(){
                            var maximum = $("#amount").val();
                            var total_debit = 0;
                            $("#voucher_entries").find("tr:gt(0)").each(function() {
                                if( $(this).find("[id $=_amount]").val() > 0 )
                                    total_debit += parseFloat($(this).find("[id $=_amount]").val());
                            });
                            if( total_debit > 0 && maximum != total_debit ){
                                t8.error("Amounts are not matching!");
                                return false;
                            }else{
                                $("#loader").show();
                            }
                        }',
            ), array('id' => 'mybtn' . rand(), 'class' => 'btn btn-theme'));
           
    ?>
    </div>
<?php $this->endWidget(); ?>