
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadPage", "function loadPage(){
                    $('#loader').show();
                    jQuery.ajax({
                        'type': 'post',
                        'url': '" . Yii::app()->createUrl('finance/reports/cashflow_finance_report_html') . "',
                        'data' : { 'from' : $('#fn_report_from').val(), 'to' : $('#fn_report_to').val() },
                        'success': function(data) {
                            $('#data_div').show();
                            $('.main-li-data').html(data);
                            $('#loader').hide();
                        }
                    });
                
        }", CClientScript::POS_HEAD);
        $cs->registerScript("loadExcel", "function loadExcel(){
            $('#loader').show();
            jQuery.ajax({
                'type': 'post',
                'url': '" . Yii::app()->createUrl('finance/reports/cashflow_finance_report_excel') . "',
                'data' : { 'from' : $('#fn_report_from').val(), 'to' : $('#fn_report_to').val() },
                'success': function(data) {
                    $('#loader').hide();
                }
            });
        
}", CClientScript::POS_HEAD);
        $cs->registerScript("load_details", "function load_details(from_date, to_date, subledger_id){
            $('#loader').show();
            jQuery.ajax({
                'type': 'post',
                'url': '" . Yii::app()->createUrl('finance/reports/pl_emp_detailed') . "',
                'data' : { 'to' : to_date, 'from' : from_date },
                'success': function(data) {
                    $('#pl_emp_li').removeClass('active');
                    $('#pl_emp_tab').removeClass('active');
                    $('#pl_emp_detailed_li').show();
                    $('#pl_emp_detailed_li').addClass('active');
                    $('#pl_emp_detailed_tab').addClass('active');
                    $('#pl_emp_detailed_tab').html(data);
                    $('#loader').hide();
                }
            });
        }", CClientScript::POS_HEAD);

?>

<style>
table {
  font-family: arial, sans-serif !important;
  border-collapse: collapse !important;
  width: 100% !important;
}

td, th {
  border: 1px solid #dddddd !important;
  text-align: left !important;
  padding: 8px !important;
}

table th{
	padding-top: 12px;
    padding-bottom: 12px;
    text-align: left;
    background-color: #1f67b2;
    color: white;
}

tr:nth-child(even) {
  background-color: #f2f2f2 !important;
}
</style>
<div class="row">
    <div class="col-sm-12">
        <section class="panel">
            <header class="panel-heading clearfix">
                <ul class="clearfix form-ul material">
                    <li class="col-sm-2">
                        <?php echo CHtml::textField('fn_report_from', date('d/m/Y'), array('class' => 'datepicker tooltipster', 'data-label' => 'From')); ?>
                    </li>
                    <li class="col-sm-2">
                        <?php echo CHtml::textField('fn_report_to', date('d/m/Y'), array('class' => 'datepicker tooltipster', 'data-label' => 'To')); ?>
                    </li>
                    <div class="btn-wrap text-center">
                        <a type="button" class="btn btn-sm btn-theme" onclick="loadPage();">HTML</a>
                        <a type="button" class="btn btn-sm btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/reports/cashflow_finance_report_excel&from='+$('#fn_report_from').val()+'&to='+$('#fn_report_to').val(), '_blank'); ">EXCEL</a>
                    </div>
                </ul>
            </header>
            <div class="panel-body" id="data_div" style="display:none;" >
                <div class="tab-content">
                    <div class="tab-pane main-li-data active" id="pl_emp_tab">
                    </div>
            </div>
        </section>
    </div>
</div>
