<?php
    $cs = Yii::app()->getClientScript();
    
    $cs->registerScript("getNextaccount", "function getNextaccount(parent_id){
        jQuery.ajax({
            'type': 'post',
            'dataType': 'json',
            'data' : {'parent_id' : parent_id},
            'url': '" . Yii::app()->createUrl('finance/core/getaccountno') . "',
            'success': function(data) { 
                $('#FinanceLegder_account_no').val(data.account_no);
                $('#FinanceLegder_account_no').addClass('filled');
            }
        });
    }", CClientScript::POS_HEAD);

    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'ledger-form',
        'enableAjaxValidation' => false,
        'enableClientValidation' => false,
    ));
?>
<ul class="clearfix form-ul material">   
    <li class="col-sm-5">   
        <?php 
        // echo $form->dropdownlist($model, 'parent_account', FinanceLegder::getParents(), array('class'=>'tooltipster', 'data-label' => 'Parent *', 'data-search' => true, 'onChange' => 'getNextaccount(this.value)', 'prompt' => '-select-', 'disabled' => ( !$model->isNewRecord && FinanceVoucherItems::no_of_entries((int) $model->id) > 0 ) ? true : false)); 
        echo $form->dropdownlist($model, 'parent_account', FinanceLegder::getParents(), array('class'=>'tooltipster', 'data-label' => 'Parent *', 'data-search' => true, 'onChange' => 'getNextaccount(this.value)', 'prompt' => '-select-')); 
        ?>
    </li>
    <li class="col-sm-2">   
        <?php echo $form->textfield($model, 'account_no', array('class'=>'tooltipster', 'data-label' => 'A/C No.', 'readonly' => true)); ?>
        <?php echo $form->hiddenfield($model, 'id'); ?>
    </li>
    <li class="col-sm-5">   
        <?php echo $form->textfield($model, 'description', array('class'=>'tooltipster', 'data-label' => 'Description *')); ?>
    </li>
    <li class="col-sm-3">   
        <?php echo $form->dropdownlist($model, 'classification', array( 'NORMAL' => 'Normal', 'VAT' => 'VAT A/C', 'RECEIVABLE' => 'Receivable', 'PAYABLE' => 'Payable', 'CASH' => 'Cash', 'BANK' => 'Bank', 'CHEQUE' => 'Cheque' ), array('class'=>'tooltipster', 'data-label' => 'Classification *')); ?>
    </li>
    <li class="col-sm-2">   
        <?php echo $form->dropdownlist($model, 'isParent', array( 'N' => 'No', 'Y' => 'Yes' ), array('class'=>'tooltipster', 'data-label' => 'Parent A/C *', 'disabled' => ( ( FinanceVoucherItems::no_of_entries((int) $model->id) > 0 || FinanceVoucherItems::no_of_childs((int) $model->id) > 0 ) && !$model->isNewRecord ) ? true : false )); ?>
    </li>
    <li class="col-sm-3">   
<?php echo $form->dropdownlist($model, 'haveSubledger', array( 'N' => 'No', 'Y' => 'Yes' ), array('class'=>'tooltipster', 'data-label' => 'Sublegder *', 'onChange' => 'if(this.value=="N"){ $("#sledger_type").hide(); }else{ $("#sledger_type").show(); }')); ?>
    </li>
    <li class="col-sm-4" style="display:<?php echo ( $model->subledger_types != NULL ) ? 'block' : 'none'; ?>" id="sledger_type">   
        <?php 
            $sublegertype_ids=  array();
            if( $model->subledger_types != NULL ){
                $sublegertype = explode(",", $model->subledger_types);
                foreach ($sublegertype as $eachValue){
                    $sublegertype_ids[$eachValue] = array('selected' => 'selected');
                }    
            }     
        ?>
        <?php echo $form->dropdownlist($model, 'subledger_types', FinanceSubledgerType::getSublegdertypes(true), array('class'=>'tooltipster', 'data-label' => 'Subledger Types *', 'data-search' => true, 'multiple' => true, 'options' => $sublegertype_ids)); ?>
    </li>
</ul>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="cust_close" data-dismiss="modal">Close</button>
    <?php
        
        echo CHtml::ajaxSubmitButton('Save', Yii::app()->createUrl('finance/core/saveledger'), array(
            'dataType' => 'json',
            'type' => 'post',
            'success' => 'function(data) {
                            $("#loader").hide();
                            if(data.status=="success"){  
                                t8.success("Done!");
                                $(".x.close").click();
                                reloadTable("#fin_ledgers");
                            }else{ 
                                $.each(data, function(key, val) {
                                    t8.error(""+val+""); 
                                }); 
                            } 
                        }',
                        'beforeSend' => 'function(){
                            $("#loader").show();
                        }',
            ), array('id' => 'mybtn' . rand(), 'class' => 'btn btn-theme'));
           
    ?>
    </div>
<?php $this->endWidget(); ?>