<?php

/**
 * This is the model class for table "{{finance_voucher_type_mappings}}".
 *
 * The followings are the available columns in table '{{finance_voucher_type_mappings}}':
 * @property integer $id
 * @property integer $voucher_type
 * @property integer $account_id
 * @property string $dynamic_subledger
 * @property string $subledger_id
 * @property string $credit_field
 * @property string $debit_field
 */
class FinanceVoucherTypeMappings extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{finance_voucher_type_mappings}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('voucher_type, account_id, subledger_id, credit_field, debit_field, rcm_comparison', 'required'),
			array('voucher_type, account_id, dynamic_subledger_type', 'numerical', 'integerOnly'=>true),
			array('dynamic_subledger', 'length', 'max'=>1),
			array('subledger_id', 'length', 'max'=>20),
			array('credit_field, debit_field, narration, dynamic_subledger_field', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, voucher_type, account_id, dynamic_subledger, subledger_id, credit_field, debit_field', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'ledger' => array(self::BELONGS_TO, 'FinanceLegder', 'account_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'voucher_type' => 'Voucher Type',
			'account_id' => 'Account',
			'dynamic_subledger' => 'Dynamic Subledger',
			'subledger_id' => 'Subledger',
			'credit_field' => 'Credit Field',
			'debit_field' => 'Debit Field',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('voucher_type',$this->voucher_type);
		$criteria->compare('account_id',$this->account_id);
		$criteria->compare('dynamic_subledger',$this->dynamic_subledger,true);
		$criteria->compare('subledger_id',$this->subledger_id,true);
		$criteria->compare('credit_field',$this->credit_field,true);
		$criteria->compare('debit_field',$this->debit_field,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return FinanceVoucherTypeMappings the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
