<?php

/**
 * This is the model class for table "{{finance_voucher_head}}".
 *
 * The followings are the available columns in table '{{finance_voucher_head}}':
 * @property integer $id
 * @property integer $voucher_type
 * @property string $voucher_no
 * @property string $voucher_date
 * @property string $header_table_id
 * @property string $paid_or_received
 * @property integer $payment_method
 * @property string $card_no
 * @property integer $cvv_no
 * @property string $cheque_no
 * @property string $cheque_date
 * @property string $realisation_date
 * @property string $cheque_cleared
 * @property string $total_voucher_amount
 * @property string $is_posted
 * @property string $is_allocated
 * @property integer $created_by
 * @property string $created_datetime
 */
class FinanceVoucherHead extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public $expense_id;

	public function tableName()
	{
		return '{{finance_voucher_head}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('voucher_type, voucher_date, total_voucher_amount', 'required'),
			array('bank_name', 'required', 'on' => 'bank'),
			array('cheque_no, cheque_date', 'required', 'on' => 'chequepaid'),
			array('cheque_no, cheque_date, bank_name', 'required', 'on' => 'chequereceived'),
			array(
				'cheque_no', 'length',
				'min' => 6
			),
			array(
				'cheque_no', 'length',
				'max' => 6
			),
			array('card_no', 'required', 'on' => 'card'),
			array('voucher_type, payment_method, related_subledger, emp_subledger, cvv_no, created_by', 'numerical', 'integerOnly' => true),
			array('voucher_no, header_table_id, total_voucher_amount', 'length', 'max' => 20),
			array('paid_or_received, card_no, reference_no, bank_name', 'length', 'max' => 255),
			array('cheque_cleared, is_posted, is_allocated,account_payee', 'length', 'max' => 1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, voucher_type, voucher_no, voucher_date, header_table_id, paid_or_received, reference_no, payment_method, card_no, cvv_no, cheque_no, cheque_date, realisation_date, cheque_cleared, total_voucher_amount, is_posted, is_allocated, created_by, created_datetime', 'safe', 'on' => 'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'vtype' => array(self::BELONGS_TO, 'FinanceVoucherType', 'voucher_type'),
			'items' => array(self::HAS_MANY, 'FinanceVoucherItems', 'header_id', 'order' => 'items.amount desc'),
			'debitItems' => array(self::HAS_MANY, 'FinanceVoucherItems', 'header_id', 'condition' => 'debitItems.amount > 0', 'order' => 'debitItems.id asc'),
			'creditItems' => array(self::HAS_MANY, 'FinanceVoucherItems', 'header_id', 'condition' => 'creditItems.amount < 0', 'order' => 'creditItems.id asc'),
			'balance' => array(self::STAT, 'FinanceVoucherItems', 'header_id', 'select' => 'SUM(amount)'),
			'created' => array(self::BELONGS_TO, 'User', 'created_by'),
			'debit_total' => array(self::STAT, 'FinanceVoucherItems', 'header_id', 'select' => 'SUM(amount)', 'condition' => 'amount > 0 '),
			'debit_total_base' => array(self::STAT, 'FinanceVoucherItems', 'header_id', 'select' => 'SUM(amount*exchange_rate)', 'condition' => 'amount > 0 '),
			'debit_total_having_sub' => array(self::STAT, 'FinanceVoucherItems', 'header_id', 'select' => 'SUM(amount)', 'condition' => 'amount > 0 AND subledger_id > 0 '),
			'salesinvoice' => array(self::BELONGS_TO, 'Invoice', 'header_table_id'),
			'purchaseinvoice' => array(self::BELONGS_TO, 'DirectPurchaseOrderGeneral', 'header_table_id'),
			'subledger' => array(self::BELONGS_TO, 'FinanceSubledger', 'related_subledger'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'voucher_type' => 'Voucher Type',
			'voucher_no' => 'Voucher No',
			'voucher_date' => 'Voucher Date',
			'header_table_id' => 'Header Table',
			'paid_or_received' => 'Paid to/ Received from',
			'payment_method' => 'Payment Method',
			'card_no' => 'Card No',
			'cvv_no' => 'Cvv No',
			'cheque_no' => 'Cheque No',
			'cheque_date' => 'Cheque Date',
			'realisation_date' => 'Realisation Date',
			'cheque_cleared' => 'Cheque Cleared',
			'total_voucher_amount' => 'Total Voucher Amount',
			'is_posted' => 'Is Posted',
			'is_allocated' => 'Is Allocated',
			'created_by' => 'Created By',
			'created_datetime' => 'Created Datetime',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('voucher_type', $this->voucher_type);
		$criteria->compare('voucher_no', $this->voucher_no, true);
		$criteria->compare('voucher_date', $this->voucher_date, true);
		$criteria->compare('header_table_id', $this->header_table_id, true);
		$criteria->compare('paid_or_received', $this->paid_or_received, true);
		$criteria->compare('payment_method', $this->payment_method);
		$criteria->compare('card_no', $this->card_no, true);
		$criteria->compare('cvv_no', $this->cvv_no);
		$criteria->compare('cheque_no', $this->cheque_no, true);
		$criteria->compare('cheque_date', $this->cheque_date, true);
		$criteria->compare('realisation_date', $this->realisation_date, true);
		$criteria->compare('cheque_cleared', $this->cheque_cleared, true);
		$criteria->compare('total_voucher_amount', $this->total_voucher_amount, true);
		$criteria->compare('is_posted', $this->is_posted, true);
		$criteria->compare('is_allocated', $this->is_allocated, true);
		$criteria->compare('created_by', $this->created_by);
		$criteria->compare('created_datetime', $this->created_datetime, true);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return FinanceVoucherHead the static model class
	 */
	public static function model($className = __CLASS__)
	{
		return parent::model($className);
	}

	public function getFullvoucher()
	{
		return $this->vtype->code . '/' . $this->voucher_no;
	}

	public function mode_of_payment()
	{
		$modes = array(0 => 'None', 1 => 'Cash', 2 => 'Cheque', 3 => 'Bank Transfer', 4 => 'Card', 5 => 'Cash Deposit');
		return $modes[$this->payment_method];
	}

	public function get_any_subledger()
	{
		$subledger_name = '';
		$model = FinanceVoucherItems::model()->find(array('condition' => 'amount > 0 AND subledger_id > 0 AND header_id=' . (int) $this->id));
		if ($model->id > 0)
			$subledger_name = $model->subledger->description;
		return $subledger_name;
	}

	public function generateSubledger_model()
	{
		$model = new FinanceSubledger;
		$subledger = Yii::app()->db->createCommand('SELECT VI.subledger_id AS subledger_id FROM {{finance_voucher_items}} VI LEFT JOIN {{finance_subledger}} SL ON VI.subledger_id = SL.id LEFT JOIN {{finance_subledger_type}} ST ON SL.subledger_type_id = ST.id WHERE ST.system_generated="Y" AND VI.header_id=' . $this->id . ' AND VI.subledger_id > 0 LIMIT 1')->queryAll();
		if ($subledger[0]['subledger_id'] > 0)
			$model = FinanceSubledger::model()->findBypk((int) $subledger[0]['subledger_id']);
		return $model;
	}

	public function is_postable_voucher()
	{
		$query_one = 'SELECT COUNT(I.id) AS one FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON H.id = I.header_id LEFT JOIN {{finance_legder}} L ON L.id = I.ledger_id WHERE H.id="' . $this->id . '" AND L.haveSubledger ="Y" AND I.subledger_id = 0';
		$count_one = Yii::app()->db->createCommand($query_one)->queryScalar();

		$query_two = 'SELECT COUNT(I.id) AS one FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON H.id = I.header_id LEFT JOIN {{finance_legder}} L ON L.id = I.ledger_id WHERE H.id="' . $this->id . '" AND L.haveSubledger ="N" AND I.subledger_id > 0';
		$count_two = Yii::app()->db->createCommand($query_two)->queryScalar();
		return ($count_one > 0 || $count_two > 0) ? false : true;
	}

	public function get_first_narration()
	{
		return FinanceVoucherItems::model()->find(array('condition' => 'header_id=' . $this->id, 'order' => 'id ASC'))->narration;
	}

	public function voucher_value()
	{
		return $this->total_voucher_amount;
	}

	public function haveReconcilation()
	{
		$count = FinanceVoucherItems::model()->count(array('condition' => 'reconciled="Y" AND header_id='.$this->id));
		return $count > 0 ? true : false;
	}

	public function count_system_generated_subledger()
	{
		$count = Yii::app()->db->createCommand('SELECT COUNT(DISTINCT VI.subledger_id) AS count FROM {{finance_voucher_items}} VI LEFT JOIN {{finance_subledger}} SL ON VI.subledger_id = SL.id LEFT JOIN {{finance_subledger_type}} ST ON SL.subledger_type_id=ST.id WHERE ST.system_generated="Y" AND VI.header_id="' . $this->id . '" ')->queryScalar();
		return $count;
	}

	public function payment_method_details()
	{
		$modes = array(0 => 'None', 1 => 'Cash', 2 => 'Cheque', 3 => 'Bank Transfer', 4 => 'Card', 5 => 'Cash Deposit');
		$response = '';
		if ($this->payment_method == 1|| $this->payment_method == 5) {
			$ref_no = ($this->reference_no != '') ? $this->reference_no : 'N/A';
			$response .= '&nbsp;&nbsp;&nbsp;&nbsp;<small>Ref No : ' . $ref_no . '</small>';
		} else if ($this->payment_method == 2) {
			$ref_no = ($this->reference_no != '') ? $this->reference_no : 'N/A';
			$chq_no = ($this->cheque_no != '') ? $this->cheque_no : 'N/A';
			$chq_date = date('d/m/Y', strtotime($this->cheque_date));
			$response .= '&nbsp;&nbsp;&nbsp;&nbsp;<small>Ref No : ' . $ref_no . '</small><br>';
			$response .= '&nbsp;&nbsp;&nbsp;&nbsp;<small>Cheque No : ' . $chq_no . '</small><br>';
			$response .= '&nbsp;&nbsp;&nbsp;&nbsp;<small>Cheque Date : ' . $chq_date . '</small><br>';
			$response .= '&nbsp;&nbsp;&nbsp;&nbsp;<small>Bank : ' . $this->bank_name . '</small>';
		} else if ($this->payment_method == 3) {
			$ref_no = ($this->reference_no != '') ? $this->reference_no : 'N/A';
			$response .= '&nbsp;&nbsp;&nbsp;&nbsp;<small>Ref No : ' . $ref_no . '</small><br>';
			$response .= '&nbsp;&nbsp;&nbsp;&nbsp;<small>Bank : ' . $this->bank_name . '</small>';
		} else if ($this->payment_method == 4) {
			$ref_no = ($this->reference_no != '') ? $this->reference_no : 'N/A';
			$card_no = ($this->card_no != '') ? $this->card_no : 'N/A';
			$response .= '&nbsp;&nbsp;&nbsp;&nbsp;<small>Ref No : ' . $ref_no . '</small><br>';
			$response .= '&nbsp;&nbsp;&nbsp;&nbsp;<small>Card No : ' . $card_no . '</small>';
		}
		return $response;
	}

	public static function generateUrl($code, $header_id, $haveVat,$hire)
	{
		$url = '#';
		if ($code == 'SI') {
			$taxType = $haveVat ? 'tax' : 'taxnil';
			$hire = $hire==true ? '&hiring=Y' : '';
			$url = "window.open($('#liveSite').val()+'index.php?r=invoice/PrintInvoiceReportPDF&id=" . $header_id .$hire."&frm=" . $taxType . "&type=1', '_blank');";
		} else if ($code == 'PI') {
			$url = "window.open($('#liveSite').val()+'index.php?r=purchaseinvoice/PrintInvoiceReportPDF&id=" . $header_id . "', '_blank');";
		} else if ($code == 'DN') {
			$url = "window.open($('#liveSite').val()+'index.php?r=debitnote/printfile&id=" . $header_id . "', '_blank');";
		} else if ($code == 'CN') {
			$url = "window.open($('#liveSite').val()+'index.php?r=creditnote/printfile&id=" . $header_id . "', '_blank');";
		} else if ($code == 'GI') { 
			$url = "window.open($('#liveSite').val()+'index.php?r=issues/PrintPDF&id=" . $header_id . "', '_blank');";
		} else if ($code == 'GR') { 
			$url = "window.open($('#liveSite').val()+'index.php?r=receipts/PrintReceiptPDF&id=" . $header_id . "', '_blank');";
		} else {
			$url = "window.open($('#liveSite').val()+'index.php?r=finance/core/print&id=" . $header_id . "', '_blank');";
		}
		return $url;
	}
}
