<?php

/**
 * This is the model class for table "{{finance_reconciliation}}".
 *
 * The followings are the available columns in table '{{finance_reconciliation}}':
 * @property integer $id
 * @property string $statement_date
 * @property integer $ledger_id
 * @property integer $subledger_id
 * @property string $funds_in_ids
 * @property integer $created_by
 * @property string $created_date_time
 */
class FinanceReconciliation extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{finance_reconciliation}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('statement_date, ledger_id, subledger_id, funds_in_ids, funds_out_ids, created_by, created_date_time', 'required'),
			array('ledger_id, subledger_id, created_by', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, statement_date, ledger_id, subledger_id, funds_in_ids, funds_out_ids, created_by, created_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'ledger' => array(self::BELONGS_TO, 'FinanceLegder', 'ledger_id'),
			'subledger' => array(self::BELONGS_TO, 'FinanceSubledger', 'subledger_id'),
			'createdUser' => array(self::BELONGS_TO, 'User', 'created_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'statement_date' => 'Statement Date',
			'ledger_id' => 'Ledger',
			'subledger_id' => 'Subledger',
			'funds_in_ids' => 'Voucher Item Ids',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('statement_date',$this->statement_date,true);
		$criteria->compare('ledger_id',$this->ledger_id);
		$criteria->compare('subledger_id',$this->subledger_id);
		$criteria->compare('funds_in_ids',$this->funds_in_ids,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return FinanceReconciliation the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	public function getItems(){
		$allouchers = array();
		if( $this->funds_in_ids != '' )
			$allouchers[] = $this->funds_in_ids;
		if( $this->funds_out_ids != '' )
			$allouchers[] = $this->funds_out_ids;

		$items = array(new FinanceVoucherItems);
		$all_voucher_items = implode(',', $allouchers);
		if( $all_voucher_items != '' ){
			$items = FinanceVoucherItems::model()->with('parent')->findAll( array( 'condition' => 't.id IN ('.$all_voucher_items.')', 'order' => 'parent.voucher_date ASC' ) );
		}
		return $items;
	}
}
