<?php

/**
 * This is the model class for table "{{finance_allocation_items}}".
 *
 * The followings are the available columns in table '{{finance_allocation_items}}':
 * @property integer $id
 * @property integer $header_id
 * @property integer $voucher_id
 * @property integer $voucher_item_id
 * @property string $amount
 */
class FinanceAllocationItems extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{finance_allocation_items}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('header_id, voucher_id, voucher_item_id, amount', 'required'),
			array('header_id, voucher_id, voucher_item_id', 'numerical', 'integerOnly'=>true),
			array('amount', 'length', 'max'=>20),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, header_id, voucher_id, voucher_item_id, amount', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'parent' => array(self::BELONGS_TO, 'FinanceAllocation', 'header_id'),
			'voucher' => array(self::BELONGS_TO, 'FinanceVoucherHead', 'voucher_id'),
			'voucherItems' => array(self::BELONGS_TO, 'FinanceVoucherItems', 'voucher_item_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'header_id' => 'Header',
			'voucher_id' => 'Voucher',
			'voucher_item_id' => 'Voucher Item',
			'amount' => 'Amount',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('header_id',$this->header_id);
		$criteria->compare('voucher_id',$this->voucher_id);
		$criteria->compare('voucher_item_id',$this->voucher_item_id);
		$criteria->compare('amount',$this->amount,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return FinanceAllocationItems the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
