<?php

/**
 * This is the model class for table "".
 *
 * The followings are the available columns in table
 * @property string $id
 * @property string $html
 * @property string $color_code
 * @property string $isActive
 */
class Template extends CActiveRecord {

    /**
     * @return string the associated database table html
     */
   


    public function tableName() {
        return '{{ch_template}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('html,name,bank_id', 'required'),
            array('bank_id', 'numerical', 'integerOnly'=>true),
            array('name', 'length', 'max'=>50),
             array('bank_id', 'unique'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('html,bank_id', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation html and the related
        // class html for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (html=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'html' => 'Name',
            'bank_id' => "Bank"
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);

        $criteria->compare('id', $this->id, true);
        $criteria->compare('html', $this->html, true);



        return new CActiveDataProvider($this, array(
            'pagination' => array(
                'pageSize' => 5,
            ),
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.html ASC',
            ),
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class html.
     * @return MasCompanyBranch the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function getEmptyTemplate() {
        $str = "<div class = 'item' >Payee_Name</div>";
        $str .= "<div class = 'item' >Date</div>";
        $str .= "<div class = 'item' >00.00</div>";
        $str .= "<div class = 'item' >Amount in word</div>";
        $str .='<div class="item" id="ch-accout-payye" style="border-color: black; border-style: solid none; border-width: 2px 0px; width: 98px;display: none; text-align: center">Account Payee</div>';
        return $str;
    }

}
