<?php

class DefaultController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'saveHtml', 'view', 'viewhtml', 'GetList', 'create', 'deleteItem', 'print','Paymentchequeprint'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

    public function actionsaveHtml() {
        $id = Yii::app()->request->getParam('id');
        $html = htmlentities($_POST['code']);
        $name = htmlentities($_POST['name']);
        $has_acc_payee = Yii::app()->request->getParam('has_acc_payee');
        $bank_id = Yii::app()->request->getParam('bank_id');
        $model = Template::model()->findByPk($id);
        if (empty($model)) {
            $model = new Template;

            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date('Y-m-d h:i:s');
        }
        $model->updated_by = Yii::app()->user->id;
        $model->updated_date_time = date('Y-m-d h:i:s');
        $model->html = trim($html);
        $model->bank_id = $bank_id;
        $model->has_acc_payee = $has_acc_payee;
        $model->name = $name;
        if ($model->save()) {
            echo json_encode([
                'id' => $model->id,
                'status' => 'success'
            ]);
        } else {
            echo json_encode($model->getErrors()
            );
        }
    }

    public function actionview() {
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/cheque-style-pdf.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('view', array('id' => $id), true));
        $mPDF1->Output("view.pdf", 'I');
        // $this->renderPartial('view', array('id' => $id));
    }

    public function actionviewhtml() {
        $id = Yii::app()->request->getParam('id');
        $this->renderPartial('view', array('id' => $id));
    }

    public function actionGetList() {
        $model = new Template();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'name',
            2 => 'name',
            3 => 'id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1 ';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (name LIKE '%" . $searchString . "%' )";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;

        foreach ($model as $row) {
            $div = '';
            $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'cheque/default/create&id=' . $row['id'] . '\',\'Templates\',\'lg\')"><i class="fa fa-pencil"></i></button>';
            $div .= ' <a href ="#" class="btn btn-primary btn-xs" onclick="viewTemplates(' . $row['id'] . ')"><i class="fa fa-eye "></i></a>';
            $div .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteTemplates(' . $row['id'] . ')"><i class="fa fa-trash "></i></a>';
            $rowData[] = array($m,
                $row['name'],
                '<div class="btn-wrap text-center">' . $div . '</div>',
            );
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new Template();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        } else {
            $model->html = $model->getEmptyTemplate();
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model), false, false);
    }

    public function actiondeleteItem() {
        $model = new Template();
        $id = (int) Yii::app()->request->getParam('id');
        $model->deleteByPk($id);
        echo json_encode(array("status" => 'success'));
    }

    public function actionprint() {
        $bank_id = $_GET['bank_id'];
        $id = $_GET['id'];
        $date = $_GET['ch_date'];
        $condtion = "t.bank_id = " . $bank_id;
        $template = Template::model()->find(array('condition' => $condtion));
        $condition = " sif_file_id={$id}  AND t.bank_id = {$bank_id}"  ;
        $model_sif_details = MonthlySalarySifDetails::model()->findAll(array('condition' =>$condition));

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4'); 
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/cheque-style-pdf.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $first = true;
        foreach ($model_sif_details as $value) {
            if (!$first) {
                $mPDF1->AddPage();
            }
            $first = false;
            $param = array(
                'html' => str_replace("relative", "fixed", html_entity_decode($template->html)),
                'amount' => number_format($value->total_salary_paid, 2)."/-",
                'word' => ucwords($this->numberTowords($value->total_salary_paid)) . " only.",
                'payee' => $this->ciphertext($value->employeedetail->first_name, "d") . ' ' . $this->ciphertext($value->employeedetail->middle_name, "d") . ' ' . $this->ciphertext($value->employeedetail->last_name, "d"),
                'date' => $date
            );
            $mPDF1->WriteHTML($this->renderPartial('print', $param, true));
        }

        $mPDF1->Output("view.pdf", 'I');
    }

    protected function numberTowords($num) {
        $ones = array(
            1 => "one",
            2 => "two",
            3 => "three",
            4 => "four",
            5 => "five",
            6 => "six",
            7 => "seven",
            8 => "eight",
            9 => "nine",
            10 => "ten",
            11 => "eleven",
            12 => "twelve",
            13 => "thirteen",
            14 => "fourteen",
            15 => "fifteen",
            16 => "sixteen",
            17 => "seventeen",
            18 => "eighteen",
            19 => "nineteen"
        );
        $tens = array(
            1 => "ten",
            2 => "twenty",
            3 => "thirty",
            4 => "forty",
            5 => "fifty",
            6 => "sixty",
            7 => "seventy",
            8 => "eighty",
            9 => "ninety"
        );
        $hundreds = array(
            "hundred",
            "thousand",
            "million",
            "billion",
            "trillion",
            "quadrillion"
        ); //limit t quadrillion 
        $num = number_format($num, 2, ".", ",");
        $num_arr = explode(".", $num);
        $wholenum = $num_arr[0];
        $decnum = $num_arr[1];
        $whole_arr = array_reverse(explode(",", $wholenum));
        krsort($whole_arr);
        $rettxt = "";
        foreach ($whole_arr as $key => $i) {
            if ($i < 20) {
                $rettxt .= $ones[$i];
            } elseif ($i < 100) {
                $rettxt .= $tens[substr($i, 0, 1)];
                $rettxt .= " " . $ones[substr($i, 1, 1)];
            } else {
                $rettxt .= $ones[substr($i, 0, 1)] . " " . $hundreds[0];
                $rettxt .= " " . $tens[substr($i, 1, 1)];
                $rettxt .= " " . $ones[substr($i, 2, 1)];
            }
            if ($key > 0) {
                $rettxt .= " " . $hundreds[$key] . " ";
            }
        }
        if ($decnum > 0) {
            $rettxt .= "  and ";
            if ($decnum < 20) {
                $rettxt .= $ones[$decnum];
            } elseif ($decnum < 100) {
                $rettxt .= $tens[substr($decnum, 0, 1)];
                $rettxt .= " " . $ones[substr($decnum, 1, 1)];
            }
            $rettxt .= " Fils ";
        }
        return $rettxt;
    }
    public function actionPaymentchequeprint() {
        $id = $_GET['id'];
        $pdc_i=FinanceSystemAccountsMapping::getSystemdefault('pdc_i');
        $bank=FinanceSystemAccountsMapping::getSystemdefault('bank');
        $condition = "header_id={$id}  AND (ledger_id = {$pdc_i} OR ledger_id = {$bank})"  ;
        $model_sif_details = FinanceVoucherItems::model()->findAll(array('condition' =>$condition));

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4-L');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/cheque-style-pdf.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $first = true;
        foreach ($model_sif_details as $value) {
        $condtion = "t.bank_id = " . $value->subledger_id;
        $template = Template::model()->find(array('condition' => $condtion));
        $vendor=FinanceVoucherItems::model()->find(array('condition' =>"header_id={$id}  AND amount>0"));
            if (!$first) {
                $mPDF1->AddPage();
            }
            $first = false;
            $param = array(
                'html' => str_replace("relative", "fixed", html_entity_decode($template->html)),
                'amount' => number_format(abs($value->amount), 2)."/-",
                'word' => ucwords($this->numberTowords(abs($value->amount))) . " only.",
                'payee' => $vendor->subledger->description,
                'date' => date("d-m-Y", strtotime($value->parent->voucher_date)),
                'payee_status'=>$value->parent->account_payee
            );
            $mPDF1->WriteHTML($this->renderPartial('payment_cheque_print', $param, true));
        }

        $mPDF1->Output("view.pdf", 'I');
    }
}
