<?php

/**
 * This is the model class for table "{{quotation_price_list}}".
 *
 * The followings are the available columns in table '{{quotation_price_list}}':
 * @property integer $id
 * @property string $agent
 * @property integer $country_id
 * @property string $weight
 * @property string $price
 * @property string $price_type
 * @property string $comment
 * @property string $isActive
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class QuotationPriceList extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{quotation_price_list}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('agent, country_id, destination_country_id,transport_type,weight, price, price_type', 'required'),
			array('created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('weight, price', 'numerical'),
		   // array('weight', 'checkNegativeWeight'),
		    //array('price', 'checkNegativePrice'),
			array('price_type, isActive', 'length', 'max'=>1),
			array('comment', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, agent, country_id, destination_country_id,transport_type,weight, price, price_type, comment, isActive, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		     'country_ref' => array(self::BELONGS_TO, 'MasCountry', 'country_id'),
			 'dest_country_ref' => array(self::BELONGS_TO, 'MasCountry', 'destination_country_id'),
		      'vendor_ref' => array(self::BELONGS_TO, 'Vendor', 'agent'),
		);
	}
	
	public function checkNegativeWeight(){
	    if(isset($this->weight) && $this->weight < 0){
	         $this->addError('weight', 'Weight should be grater than zero');
	    }
	}
	
	public function checkNegativePrice(){
	    if(isset($this->price) && $this->price < 0){
	         $this->addError('price', 'Price should be grater than zero');
	    }
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'agent' => 'Agent',
			'country_id' => ' Origin Country',
			'destination_country_id' => ' Destination Country',
			'weight' => 'Weight',
			'price' => 'Price',
			'price_type' => 'Price Type',
			'transport_type' => 'Transport Type',
			'comment' => 'Comment',
			'isActive' => 'Is Active',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('agent',$this->agent,true);
		$criteria->compare('country_id',$this->country_id);
		$criteria->compare('weight',$this->weight,true);
		$criteria->compare('price',$this->price,true);
		$criteria->compare('price_type',$this->price_type,true);
		$criteria->compare('comment',$this->comment,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return QuotationPriceList the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
