<?php

/**
 * This is the model class for table "{{company_settings}}".
 *
 * The followings are the available columns in table '{{company_settings}}':
 * @property string $id
 * @property integer $crm_user_id
 * @property string $qualitycontrol
 * @property string $direct_invoive
 * @property string $sales_module
 * @property string $purchase_module
 * @property string $create_date_time
 */
/**
 * MasCompanySettings
 * 
 * @package 
 * @author gencyolcu
 * @copyright 2017
 * @version $Id$
 * @access public
 */
class MasCompanySettings extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{company_settings}}';
        //return 'xmsqzevu_cumulus_erp.{{company_settings}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            
            array('crm_user_id', 'numerical', 'integerOnly' => true),
            array('purchase_invoice', 'length', 'max' => 5),            
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('crm_company_id, crm_user_id, qualitycontrol,direct_invoive,sales_lead, sales_quotation, sales_order, sales_contract, 
                    sales_invoice,sales_creditnote,execution_assignment_master,execution_assignment,include_vat,
                    inventory_service,create_by,create_date_time', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'crm_company_id'=>'crm_company_id',            
            'crm_user_id' => 'Crm User',
            'qualitycontrol' => 'Quality Control',
            'direct_invoive' => 'Direct Invoice',
            'sales_lead' => 'Sales Lead',
            'sales_quotation' => 'Sales Quotation',
            'sales_order' => 'Sales Order',
            'sales_contract' => 'Sales Contract',
            'sales_invoice' => 'Sales Invoice',
            'sales_creditnote' => 'Sales Creditnote',
            'execution_assignment_master' => 'Execution Assignment Master',
            'execution_assignment' => 'Execution Assignment',
            'inventory_service' => 'Inventory Service',
            'create_by' => 'Create By',
            'create_date_time' => 'Create Date',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id, true);
        $criteria->compare('crm_company_id', $this->crm_company_id);
        $criteria->compare('crm_user_id', $this->crm_user_id);
        $criteria->compare('qualitycontrol', $this->qualitycontrol, true);
        $criteria->compare('direct_invoive', $this->direct_invoive, true);
        $criteria->compare('sales_lead', $this->sales_lead, true);
        $criteria->compare('sales_quotation', $this->sales_quotation, true);
        $criteria->compare('sales_order', $this->sales_order, true);
        $criteria->compare('sales_contract', $this->sales_contract, true);
        $criteria->compare('sales_invoice', $this->sales_invoice, true);
        $criteria->compare('sales_creditnote', $this->sales_creditnote, true);
        $criteria->compare('execution_assignment_master', $this->execution_assignment_master, true);
        $criteria->compare('execution_assignment', $this->execution_assignment, true);
        $criteria->compare('inventory_service', $this->inventory_service, true);
        $criteria->compare('create_by', $this->create_by, true);
        $criteria->compare('create_date_time', $this->create_date_time, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }
    /**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return PurchasingInvoiceItemDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

}
