<?php
class SiteController extends Controller {
    /**
     * Declares class-based actions.
     */
    public function actions() {
        return array(
			// captcha action renders the CAPTCHA image displayed on the contact page
            'captcha' => array(
                'class' => 'CCaptchaAction',
                'backColor' => 0xFFFFFF,
            ),
            // page action renders "static" pages stored under 'protected/views/site/pages'
			// They can be accessed via: index.php?r=site/page&view=FileName
            'page' => array(
                'class' => 'CViewAction',
            ),
        );
    }
        public function accessRules() {

        return array(

                array('allow', // allow all users to perform 'index' and 'view' actions

                  'actions' => array('login', 'error', 'logout','newlogin'),

                  'users' => array('*'),

                  ),

                array('allow', // allow authenticated user to perform 'create' and 'update' actions

                  'actions' => array('Index','ChangePassword','UpdatePassword','Menu','GetAllDetailsForProduct','Pos','Getposdata','Addtocart','GetServiceemployees'),

                  'expression' => '$user->isMember()',

                  ),

                array('deny', // deny all users

                  'users' => array('*'),

                  ),

                );

    }


    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
//    public function actionIndex() {
//            $this->render('index');
//    }
        public function actionIndex() {
            //$this->render('index');
        if(Yii::app()->user->authorised_user == 1)
        {
           $this->render('index');
        }else{
            if(Yii::app()->user->level == 2){
                $this->layout='main';
                $this->render('employee');    
                    
            }else{
                if(isset(Yii::app()->user->haveHrPermissionOn['hr_dashboard_as_default_menu'])){
                    $this->render('../hrdashboard/index');
                }else
                $this->render('index');
            }
        }
    }
    public function actionChangePassword() {
        $this->render('changepassword');
    }
    public function actionNewLogin() {
        $model = new LoginForm;
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('login_new',array('model'=>$model));
    }
    public function actionUpdatePassword() {
        $curr_pwd      = $_POST['user_current_password'];
        $new_pwd       = $_POST['user_new_password'];
        $rep_pwd       = $_POST['user_reenter_password'];
        $login_user_id = Yii::app()->user->id;
        $arr_user_details= User::model()->findByPk($login_user_id);
        $salt       = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
        $password   = crypt($_POST['user_current_password'], $salt);
        if($arr_user_details->password == $password){
            $new_password   = crypt($_POST['user_new_password'], $salt);
            $arr_user_details->password=$new_password;
            $arr_user_details->save(false);
            $json['status'] = "success";
        }
        else
        {  
            $json['status'] = "fail";
        }
        echo CJSON::encode($json);
    }
    public function actionMenu()
    {        
        $this->render('menu');
    }
    
     public function actionGetAllDetailsForProduct(){
        $product_id     = $_POST['product_id'];
        $customer_id    = $_POST['customer_id'];
        $modelStore = new Store();
        $product_details = $modelStore->findByPk($product_id);
        
        $brand_class_id=$product_details->brand_class_id;
        
        $modelCustomerPricing = new CustomerPricingGroup();
        $arr_customer_pricing_details = $modelCustomerPricing->find(array('condition'=>'customer_id='.$customer_id." AND brand_id=".$brand_class_id));
        
        
        
        $sales_pricing_group_id = (int) $arr_customer_pricing_details->pricing_group_id;
        
        $model = new SalesPriceGroup();
        $arr_price_details = $model->find(array('condition'=>'product_id='.$product_id));
        
        
        $price = 0;
        if($sales_pricing_group_id==1){
            $price = $arr_price_details->base_sales_price;
        }
        elseif($sales_pricing_group_id==2){
            $price = $arr_price_details->sales_price1;
        }
        elseif($sales_pricing_group_id==3){
            $price = $arr_price_details->sales_price2;
        }
        elseif($sales_pricing_group_id==4){
            $price = $arr_price_details->sales_price3;
        }
        elseif($sales_pricing_group_id==5){
            $price = $arr_price_details->sales_price4;
        }
        elseif($sales_pricing_group_id==6){
            $price = $arr_price_details->sales_price5;
        }
        elseif($sales_pricing_group_id==7){
            $price = $arr_price_details->sales_price6;
        }
        elseif($sales_pricing_group_id==8){
            $price = $arr_price_details->sales_price7;
        }
        else
        {
           $price = $arr_price_details->sales_price1; 
        }
        
        $jsonData['price'] = number_format(floatval($price), 2, '.', '');
        echo CJSON::encode($jsonData);
        Yii::app()->end();
        
    }
    
    public function actionGetServiceemployees(){
        
        $searchTerm = trim($_GET['term']);
        $condition = 'employee_name LIKE "%' . $searchTerm . '%" OR designation LIKE "%' . $searchTerm . '%"';
        $model = new ServiceEmployee();
        $model = $model->findAll(array('select' => 'id,employee_name', 'condition' => $condition));
        foreach ( $model as $i => $eachModel ) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->employee_name;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionError()
    {
        if ($error = Yii::app()->errorHandler->error) {
            $this->layout = '//layouts/error'; 
            if ($error['code'] == 404) {
                $this->render('404');
            } else {
                $this->render('error', $error);
            }
        }
    }
    

       
    
}
