<?php

class ReportsController extends Controller {

    public function accessRules() {



        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'getFixedAssetNumbers', 'FixedAssetReportExcel', 'FixedAssetReportPDF', 'MasterReport', 'LoadMasterReportFilter', 'GetMachineNo',
                    'PrintLeadReport', 'PrintSalesDaybookReport', 'PrintQuoteReport', 'PrintLeadExcel', 'PrintDeliveryReport', 'excelLeadList', 'PrintexcelLeadList', 'PrintDeliveryListExcel', 'PrintCreditnoteExcel',
                    'PrintOrderReport', 'PrintContractReport', 'PrintLeadReportPDF', 'PrintQuoteReportPDF', 'PrintOrderReportPDF', 'PrintexcelInvoiceList', 'PrintDirectsale',
                    'PrintQuoteExcel', 'PrintOrderExcel', 'PrintContractExcel', 'PrintServiceExcel', 'PrintNetsaleList', 'PrintGrossprofitList', 'CustomerbrandsaleExcel',
                    'PrintRegistrationInvoiceRequest', 'PrintInvoiceReport', 'PrintDeliveryReportPDF', 'Customersalesreport', 'Customernosalesreport',
                    'PrinRegistrationInvoiceReportPDF', 'PrintMaterialRegistrationInvoiceExcel', 'Report', 'PrintInvoiceExcel', 'PrintInvoiceReportPDF',
                    'PrintJobsheetOverwise', 'PrintOverViewReportPDF', 'PrintDailySchedule', 'PrintdailySchedulePDF', 'PrintTimeSchedule', 'PrintInventoryReport', 'PrintRequistionReportPDF', 'PrintJoborderReport',
                    'PrintCustomerReport', 'PrintCustomerContactReportPDF', 'PrintCustomerContactReport', 'PrintCustomerNoSalesReportPDF', 'PrintVendorContactListExcel', 'PrintEnquiryReport', 'IndexReport', 'PrintCustomerReportPDF', 'PrintCustomerExcel',
                    'PrintInventoryReportPDF', 'JoborderReportPDF', 'PrintQuoteReport1', 'PrintGLReport', 'PrintGLStatementReport', 'PrintGLSummaryReport', 'Printexcelinvreport',
                    'PrintAgeingReport', 'report', 'PrintDayBook', 'PrintTrialBalance', 'PrintProfitLoss', 'PrintPurchaseOrderReport',
                    'PrintPurchaseOrderReportPDF', 'PrintPurchaseOrderPendingReport', 'PrintMaterialReceiptsReport', 'PrintFinishedInventoryReport',
                    'PrintInvoiceListReport', 'PrintPurchaseRegisterReport', 'PrintPurchaseDebitNotesReport', 'PrintPurchaseOrderPendingReportPDF',
                    'PrintMaterialReceiptsReportPDF', 'PrintNetPurchaseReportPDF', 'PrintInvoiceListReportPDF', 'PrintUninvoiceListReportPDF', 'PrintPurchaseRegisterReportPDF', 'PrintPurchaseDebitNotesReportPDF', 'PendingPurchaseDetail'
                    , 'SearchPurchaseOrderNo', 'PrintInventoryReceiveReport', 'PrintInventorytransferReceiveReportPDF', 'PrintActivityList', 'PrintProvisionalList', 'PrintProvisionalDetailedList', 'ProvisionalListExcel', 'PrintProvisionalPdf','PrintProvisionaldetailedPdf','ProvisionaldetailedListExcel',
                    'PrintDirectTransferReport', 'PrintDirectTransferReportPDF', 'PrintDamagedReport', 'PrintInTransistReport', 'PrintInTransistReportPDF'
                    , 'PrintCreditNoteReport', 'PrintNetSalesReport', 'PrintCreditNoteReportPDF', 'PrintCreditReport', 'PrintCreditReportPDF', 'PrintCreditExcel', 'PrintNetSalesReportPDF', 'PrintVatSummary'
                    , 'PrintVatFinalSummary', 'PrintDirectSalesReport', 'PrintZeroBasePriceProductPDF', 'PrintCustomerSalesReport', 'PrintCustomerSalesReportPDF',
                    'PrintCustomerNoSalesReport', 'PrintNoCustomerNoSalesReport', 'PrintListItemsOrdered', 'PrintCustomerBrandSalesReport', 'PrintGrossProfitReport', 'PrintUnInvoiceReport', 'PrintGrossProfitNew', 'PrintDirectSalesReportPDF', 'PrintGrossProfitReportPDF'
                    , 'PrintPurchaseOrderExcel', 'PrintPurchaseInvoiceExcel', 'PrintZeroBasePriceProductExcel', 'PrintPurchaseMaterialReceiptsExcel', 'PrintPurchaseDebiteNoteExcel', 'PrintPurchaseOrderedListItemsExcel', 'PrintNetPurchaseExcel', 'PrintPurchaseRegisterExcel', 'PrintPurchaseOrderPendingExcel'
                    , 'PrintInventoryListExcel', 'PrintJoborderListExcel', 'PrintInventoryMinStockExcel', 'CustomerNoSalesExcel', 'PrintIntransistExcel', 'PrintCommissionIncentiveReport', 'PrintCommissionIncentiveReportPDF', 'PrintInvoiceCommissionIncentiveReport', 'PrintInvoiceCommissionIncentiveReportPDF', 'PrintVendorList', 'PrintVendorListPDF', 'PrintVendorExcel'
                    , 'PrintVendorContactList', 'PrintCommissionInvoiceIncentiveExcel', 'PrintServiceStoreExcel', 'PrintVendorContactListPDF', 'PrintPaymentTerms', 'PrintLeadReportPrint', 'PrintPaymentTermsPDF', 'BalanceSheetViewPdf', 'PrintOrdersToBeDeliveredPDF',
                    'PrintDeliveryToBeInvoiced', 'PrintOrdersToBeDelivered', 'PrintDeliverytoInvoiceList', 'PrintOrdersToBeDeliveredDetailed', 'SalesDaybookReportPDF', 'PrintZeroBaseCostPriceProduct', 'PrintOrdersToBeDeliveredPDF', 'PrintReorderLevelList', 'PrintReorderLevelExcel', 'PrintMinimumOrderList',
                    'PrintInvPriceListReport', 'PrintInvPriceListReportPDF', 'PrintInvPriceListReportList', 'PrintReorderLevelPdf', 'PrintMinimumOrderPdf',
                    'PrintInvInternalPriceListReport', 'PrintActivityPdf', 'PrintCustomerContactExcel', 'PrintMinimumOrderExcel', 'PrintInvPriceListExcel', 'InvPriceListExcel', 'PrintInvInternalPriceListReportPDF', 'PrintInvInternalPriceExcel', 'ActivityListExcel', 'PrintGrossProfitExcel',
                    'PrintQuoteProbabilityReport', 'PrintQuoteProbabilityReportPDF', 'PrintQuoteProbabilityReportExcel', 'Materialtomaterial', 'MaterialtomaterialPDF', 'MaterialtomaterialExcel',
                    'Printinventoryserialno', 'printinventorysampletracking', 'PrintStockTrackingReport', 'PrintReverseTrackingReport', 'PrintStokTrackingPDF', 'PrintReverseTrackingPDF', 'PrintInvSerialNoPDF', 'PrintInvsampletrackingPDF', 'Printexcelinvreport_detailed', 'PrintOrdersToBeDeliveredExecel', 'PrintOrdersToBeDeliveredDetailedPdf', 'PrintDeliverytoInvoiceList', 'PrintDeliverytobeInvoicedpdf'
                    , 'PrintSalesDaybookReportexcel', 'PrintCommissionIncentiveReportexcel', 'PrintNetPurchaseReport', 'PrintInvoiceCommissionInvoiceIncentiveExcel', 'PrintServiceStore', 'PrintservicestorePDF', 'PrintStokTrackingExcel', 'PrintMOQReport', 'PrintMOQReportPdf', 'PrintMOQReportExcel', 'PrintMOQReportAll', 'PrintMOQReportAllPdf', 'PrintMOQReportAllExcel',
                    'Getinventorylist', 'GetJobOrderList', 'Getstockstateasof', 'Printstockstate', 'PrintPurchaseUninvoiceExcel', 'GetStockStateAsOfDetailed', 'PrintStockStateAsofDetailed', 'GetFinishedinventorylist', 'PrintInventoryFinishedReportPDF', 'PrintFinishedInventoryListExcel',
                    //hrreports
                    'PrintAttendanceList', 'PrintMonthlyAttendanceReport', 'PrintEmployeeLeaveHistory', 'PrintAttendanceYearlyLeaveList', 'PrintBranchReport', 'PrintinoutDocumentReport', 'PrintEosReport', 'Printleavehistorylist', 'PrintAttendanceOverTimeList', 'PrintEOSPDF',
                    'PrintEmployeeLeaveListReport', 'Printsalarybefore', 'Printsalaryslip', 'Printsalaryincrement', 'PrintEmployeeAttendancePDF', 'PrintMonthlyAttendanceReportPDF', 'PrintMonthlyAttendanceReportPDF', 'PrintEmployeeworkingHoursPDF', 'PrintEmpWeeklyWorkinhHoursPDF', 'PrintEmpMonthlyWorkingHoursPDF', 'PrintLeaveHistoryReportPDF',
                    'PrintEmployeeListReportPDF', 'PrintEmployeeBlockListReportPDF', 'PrintSalaryBeforeReportPDF', 'PrintEmployeeDesignationListReportPDF', 'PrintEmployeeLeavelistReportPDF', 'PrintEmployeeDepartmentListReportPDF', 'PrintEmployeeAssetReportPDF', 'PrintEmployeeDocumentListReportPDF',
                    'PrintbranchlistReportPDF', 'PrintEmployeeLeaveSettlementReportPDF', 'PrintEmployeeGratuityReportPDF', 'PrintInOutDocumentReportPDF', 'PrintEmployeeExpiredDocumentReportPDF', 'PrintEmployeeSalaryReportPDF', 'PrintEmployeeLoanReportPDF', 'PrintEmployeeTicketReportPDF',
                    'PrintSalarySlipReportPDF', 'PrintSalaryincrementReportPDF', 'PrintEmployeeNewHirelistReportPDF', 'PrintEOSReportPDF', 'PrintOvertimeReportPDF', 'PrintDetailedQuoteReportPDF', 'PrintDetailedQuoteListReportPDF', 'SalesPendingItem', 'PrintPendingSalesReportPDF', 'PrintpendingsaleListExcel', 'PrintStockLedgerReportAll', 'PrintStockLedgerReportExcel',
                    'PrintInventoryExternalReport', 'PrintInventoryTransferExternalReportPDF', 'PrintInventoryTransferExternalReportExcel', 'PrintNetsaleListNew', 'PrintInvPPEListReport',
                    //movement list
                    'PrintMovementList', 'PrintMovementListPdf', 'PrintMovementListExcel', 'PrintPaymentTermsExcel', 'PrintListItemsOrderedPDF', 'PrintListItemsOrderedExcel', 'PrintCustomerDocumentReport', 'PrintCustomerDocumentReportPDF', 'PrintCustomerDocumentExcel', 'PrintStockPurchaseQuantity', 'PrintStockPurchaseQuantityExcel','PrintQuotationReport','PrintQuotationReportPDF','PrintQuotationExcel',
                    'PrintInvCBMReport','PrintProvisionalJobOrderList','PrintProvisionalInvoiceList','PrintProvisionaljoborderPdf','ProvisionalJoborderListExcel','PrintProvisionalInvoicePdf','PrintProvisionalInvoiceExcel','getracks','PrintRackBin','PrintRackBinReportPDF','PrintRackBinInvoiceList','PrintQuotationSummaryReport','PrintQuotationSummaryExcel','PrintQuotationSummaryReportPDF'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {

        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {


             // code added Lidiya 15-09-2023
        // $ModelShowExpiryModel= new ShowExpiryModel();
        // $days=$ModelShowExpiryModel->ExpiryDateShow();
        // if($days[0]<(-2)){
        //     throw new CHttpException(403, ' Reports Available Only After The Successful Payment');
        //     return false;
        // } 
        //////////
//        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false );

        $frm = Yii::app()->request->getParam('frm');

        $this->render('master_report', array('frm' => $frm));
    }

    public function actionPrintGrossProfitNew() {



//        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false );

        $frm = Yii::app()->request->getParam('frm');

        $this->render('gross_profit_list', array('frm' => $frm));
    }

    public function actionIndexReport() {

        $report_from = Yii::app()->request->getParam('report_from');

        $pagetitle = Yii::app()->request->getParam('pagetitle');

        $id = Yii::app()->request->getParam('id');



        if ($id == 1) {

            $frm = $report_from;

            $title = 'Lead List';
        } else if ($id == 2) {

            $frm = $report_from;

            $title = 'Quotation List';
        } else if ($id == 3) {

            $frm = $report_from;

            $title = 'Order List';
        } else if ($id == 4) {

            $frm = $report_from;

            $title = 'Delivery Note List';
        } else if ($id == 5) {

            $frm = $report_from;

            $title = 'Invoice List';
        } else if ($id == 6) {

            $frm = $report_from;

            $title = 'Inventory List';
        }



        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->render('master_report_1', array('frm' => $frm, 'title' => $title));
    }

//    public function actionMasterReport() {
//         Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
//        $this->render('master_report');
//    }

    public function actionReport() {

        $id = Yii::app()->request->getParam('id');

        if ($id == 1) {

            $frm = 'leadlist';

            $title = 'Lead List';
        } else if ($id == 2) {

            $frm = 'quotelist';

            $title = 'Quotation List';
        } else if ($id == 3) {

            $frm = 'orderlist';

            $title = 'Order List';
        } else if ($id == 4) {

            $frm = 'contractlist';

            $title = 'Contract List';
        } else if ($id == 5) {

            $frm = 'invoicelist';

            $title = 'Invoice List';
        }



        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->render('master_report_1', array('frm' => $frm, 'title' => $title));
    }

    public function actionLoadMasterReportFilter() {

        $report_from = Yii::app()->request->getparam('report_from');



        if ($report_from == 'leadlist') {



            $this->renderPartial('//reports/filter_leadlist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'inventoryindirecttransferlist') {



            $this->renderPartial('//reports/filter_inventorytransferlist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'directtransferlist') {



            $this->renderPartial('//reports/filter_directtransferlist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'damagedlist') {



            $this->renderPartial('//reports/filter_damagedlist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'sales_daybook_report') {



            $this->renderPartial('//reports/filter_sales_daybook', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'intransistlist') {



            $this->renderPartial('//reports/filter_intransistlist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'item_history') {
            $this->renderPartial('//reports/filter_item_history', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'inventorystockledgerlist') {



            $this->renderPartial('//reports/filter_invstockledgerlist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'hiringledgerlist') {



            $this->renderPartial('//reports/filter_hiringtransactionledger', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'inventoryreportlist') {



            $this->renderPartial('//reports/filter_invreportlist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'inventoryledgerlist') {



            $this->renderPartial('//reports/filter_invledgerlist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'inventorystockmovsummarylist') {



            $this->renderPartial('//reports/filter_invstockmovsummarylist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'inventorystockmovhislist') {



            $this->renderPartial('//reports/print_invstockstate_report', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'inventorystockstateasof') {



            $this->renderPartial('//reports/print_invstockstate_detailed_report', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'inventorywarehouse') {



            $this->renderPartial('//reports/filter_invwarehouse', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'inventoryrack') {



            $this->renderPartial('//reports/filter_invrack', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'ordertodeliver') {



            $this->renderPartial('//reports/filter_ordertodeliver', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'deliverytoinvoice') {



            $this->renderPartial('//reports/filter_deliverytoinvoice', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'customerlist') {



            $this->renderPartial('//reports/filter_customerlist', array('report_from' => $report_from), false, true);
        }



        if ($report_from == 'customercontactlist') {



            $this->renderPartial('//reports/filter_customercontactlist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'customerdocumentlist') {



            $this->renderPartial('//reports/filter_customerdocumentlist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'vendorlist') {



            $this->renderPartial('//reports/filter_vendorlist', array('report_from' => $report_from), false, true);
        }



        if ($report_from == 'vendorcontactlist') {



            $this->renderPartial('//reports/filter_vendorcontactlist', array('report_from' => $report_from), false, true);
        }



        if ($report_from == 'enquirylist') {



            $this->renderPartial('//reports/filter_enquirylist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'inventorylist') {



            $this->renderPartial('//reports/print_inventory_list', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'joborder_list') {



            $this->renderPartial('//reports/print_joborder_list', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'quotelist') {



            $this->renderPartial('//reports/filter_quotelist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'quotelist1') {



            $this->renderPartial('//reports/filter_quotelist1', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'orderlist') {



            $this->renderPartial('//reports/filter_orderlist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'contractlist') {



            $this->renderPartial('//reports/filter_contractlist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'invoicelist') {



            $this->renderPartial('//reports/filter_invoicelist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'creditnote_list') {



            $this->renderPartial('//reports/filter_credit_note_list', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'deliverynotelist') {



            $this->renderPartial('//reports/filter_deliverylist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'projectdetailslist') {



            $this->renderPartial('//reports/filter_projectdetailslist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'grossprofit') {



            $this->renderPartial('//reports/filter_grossprofit', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'gl_report') {



            $this->renderPartial('//reports/filter_gllist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'gl_statement_report') {



            $this->renderPartial('//reports/filter_gl_statement_list', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'gl_summary') {



            $this->renderPartial('//reports/filter_gl_summary_list', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'ageing_report') {



            $this->renderPartial('//reports/filter_ageing_list', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'vat_report') {



            $this->renderPartial('//reports/filter_vat_report', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'vat_summary') {



            $this->renderPartial('//reports/filter_vat_summary', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'daybook_report') {



            $this->renderPartial('//reports/filter_daybook_list', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'trial_balance_report') {



            $this->renderPartial('//reports/filter_trial_balance', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'trial_balance_report_ex') {



            $this->renderPartial('//reports/filter_trial_balance_ex', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'balance_sheet') {



            $this->renderPartial('//reports/filter_balance', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'profit_loss') {



            $this->renderPartial('//reports/filter_profit_loss', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'creditnotelist') {



            $this->renderPartial('//reports/filter_creditnotelist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'directsaleslist') {



            $this->renderPartial('//reports/filter_directsaleslist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'netsaleslist') {



            $this->renderPartial('//reports/filter_netsaleslist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'purchaseorderlist') {



            $this->renderPartial('//reports/filter_purchaseorderlist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'purchaseorderpendinglist') {



            $this->renderPartial('//reports/filter_purchaseorderpendinglist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'materialreceiptslist') {



            $this->renderPartial('//reports/filter_materialreceiptslist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'invoicereportlist') {



            $this->renderPartial('//reports/filter_purchaseinvoicelist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'purchaseregisterlist') {



            $this->renderPartial('//reports/filter_purchaseregisterlist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'purchasedebitnoteslist') {



            $this->renderPartial('//reports/filter_purchasedebitnoteslist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'customersalereport') {



            $this->renderPartial('//reports/filter_customer_sales_report', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'customernosalereport') {



            $this->renderPartial('//reports/filter_customer_no_sales_report', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'item_to_order') {



            $this->renderPartial('//reports/filter_items_to_order', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'customeryearlybrandsalereport') {



            $this->renderPartial('//reports/filter_customer_brandsales_report', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'commissionincentive') {



            $this->renderPartial('//reports/filter_commissionincentive_list', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'invoicecommissionincentive') {



            $this->renderPartial('//reports/filter_invoicecommissionincentive', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'uninvoice_list') {



            $this->renderPartial('//reports/filter_uninvoice_list', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'paymentterms') {



            $this->renderPartial('//reports/filter_payment_terms', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'activity_list') {



            $this->renderPartial('//reports/filter_activitylist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'zerobasecostpriceproduct') {



            $this->renderPartial('//reports/filter_zero_base_cost_price_product', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'reorderlevel') {
            $this->renderPartial('//reports/filter_reorderlevel', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'movementlist') {
            $this->renderPartial('//reports/filter_inventorymovementlist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'minimumorderqty') {

            $this->renderPartial('//reports/filter_minimumorderqty', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'inventoryppelist') {



            $this->renderPartial('//reports/filter_inventory_ppe', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'inventorypricelist') {



            $this->renderPartial('//reports/filter_inventory_pricelist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'inventoryinternalpricelist') {



            $this->renderPartial('//reports/filter_inventory_internal_pricelist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'quoteprobabilitylist') {



            $this->renderPartial('//reports/filter_quotes_probability_list', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'm2m') {

            $this->renderPartial('//reports/filter_m2m', array('report_from' => $report_from), false, true);
        }





        if ($report_from == 'invserialno') {

            $this->renderPartial('//reports/filter_inventory_serialno', array('report_from' => $report_from), false, true);
        }



        if ($report_from == 'sampletracking') {

            $this->renderPartial('//reports/filter_inventory_sampletracking', array('report_from' => $report_from), false, true);
        }





        if ($report_from == 'netpurchase') {



            $this->renderPartial('//reports/filter_net_purchase', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'servicestorelist') {

            $this->renderPartial('//reports/filter_servicestore', array('report_from' => $report_from), false, true);
        }



        if ($report_from == 'stock_tracking') {

            $this->renderPartial('//reports/filter_stock_tracking', array('report_from' => $report_from), false, true);
        }



        if ($report_from == 'normal_reverse') {



            $this->renderPartial('//reports/filter_reverse', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'moqreport') {



            $this->renderPartial('//reports/filter_moq_list', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'moqreportall') {



            $this->renderPartial('//reports/filter_moq_list_all', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'inventoryfinishedlist') {



            $this->renderPartial('//reports/print_finished_inventory_list', array('report_from' => $report_from), false, true);
        }


        if ($report_from == 'stockledger_list') {

            $this->renderPartial('//reports/filter_stockledger_list', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'employee_list') {

            $this->renderPartial('//reports/filter_employee_list', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'salespendingorderlist') {

            $this->renderPartial('//reports/filter_inventory_sales_pending_list', array('report_from' => $report_from), false, true);
        }



        /*         * ***********************    HR Module Report by Arul on 14/3/2018 ********************************** */

        if ($report_from == 'attendanceList') {

            $this->renderPartial('//hrreports/filter_attendance_list', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'attendanceOverTimeList') {

            $this->renderPartial('//hrreports/filter_attendance_overtime_list', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'attendanceMonthlylist') {

            $this->renderPartial('//hrreports/filter_attendance_monthly_list', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'monthlyattendance') {

            $this->renderPartial('//hrreports/filter_monthlyattendance', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'attendanceWorkingHourslist') {

            $this->renderPartial('//hrreports/filter_attendance_workinghours_list', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'attendanceWeekendLeavelist') {

            $this->renderPartial('//hrreports/filter_attendance_weekend_leave_list', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'attendanceLogReport') {

            $this->renderPartial('//hrreports/filter_attendance_log_report', array('report_from' => $report_from), false, true);
        }

        /* if($report_from == 'attendanceLeaveHistory')

          {

          $this->renderPartial('//hrreports/filter_attendance_leave_history', array('report_from' => $report_from), false, true);

          } */

        if ($report_from == 'attendanceYearlyLeaveReport') {

            $this->renderPartial('//hrreports/filter_attendance_yearly_leave_list', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'leaveencashment') {
            $this->renderPartial('//hrreports/filter_leaveencashment', array('report_from' => $report_from), false, true);
        }


        if ($report_from == 'showEmployee') {

            $this->renderPartial('//employeereports/filter_employee_list', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'showEmployeeBranch') {

            $this->renderPartial('//employeereports/filter_employeebranch_list', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'showEmployeeBlock') {

            $this->renderPartial('//employeereports/filter_employee_blocklist', array('report_from' => $report_from), false, true);
        }



        if ($report_from == 'showEmployeeDepartment') {

            $this->renderPartial('//employeereports/filter_employee_departmentlist', array('report_from' => $report_from), false, true);
        }



        if ($report_from == 'showEmployeeDesignation') {

            $this->renderPartial('//employeereports/filter_employee_designationlist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'showEmployeeDocument') {

            $this->renderPartial('//employeereports/filter_employee_documentlist', array('report_from' => $report_from), false, true);
        }



        if ($report_from == 'showEmployeeExpireDocument') {

            $this->renderPartial('//employeereports/filter_employee_expiredocumentlist', array('report_from' => $report_from), false, true);
        }



        if ($report_from == 'showEmployeeasset') {

            $this->renderPartial('//employeereports/filter_employee_assetlist', array('report_from' => $report_from), false, true);
        }



        if ($report_from == 'showEmployeesalary') {

            $this->renderPartial('//employeereports/filter_employee_salary', array('report_from' => $report_from), false, true);
        }



        if ($report_from == 'showEmployeeloan') {

            $this->renderPartial('//employeereports/filter_employee_loan', array('report_from' => $report_from), false, true);
        }



        if ($report_from == 'employee_ticket') {

            $this->renderPartial('//employeereports/filter_employee_ticket', array('report_from' => $report_from), false, true);
        }



        if ($report_from == 'gratuity_list') {

            $this->renderPartial('//employeereports/filter_employee_gratuitylist', array('report_from' => $report_from), false, true);
        }



        if ($report_from == 'leave_settlement_list') {

            $this->renderPartial('//employeereports/filter_employee_leavesettlement', array('report_from' => $report_from), false, true);
        }





        if ($report_from == 'new_hire_list') {

            $this->renderPartial('//employeereports/filter_new_hirelist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'branchList') {
            $this->renderPartial('//reports/filter_Branch_Report', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'companydocument') {
            $this->renderPartial('//hrreports/filter_companydocument', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'inoutdocumentlist') {
            $this->renderPartial('//reports/filter_inout_Document', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'salarybefore') {
            $this->renderPartial('//hrreports/filter_salary_before', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'salaryslip') {
            $this->renderPartial('//hrreports/filter_salary_slip', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'salaryincrement') {
            $this->renderPartial('//hrreports/filter_salary_increment', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'new_eos_report') {
            $this->renderPartial('//hrreports/filter_eos_report', array('report_from' => $report_from), false, true);
        }



        if ($report_from == 'showEmployeeleavelist') {

            $this->renderPartial('//hrreports/filter_leavelist_report', array('report_from' => $report_from), false, true);
        }



        if ($report_from == 'leavehistorylist') {

            $this->renderPartial('//hrreports/filter_leavehistorylist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'leaveledgerlist') {

            $this->renderPartial('//hrreports/filter_leaveledgerlist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'probationary_list') {

            $this->renderPartial('//hrreports/filter_probationarylist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'ticket_encashment') {
            $this->renderPartial('//hrreports/filter_ticket_encashment', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'ticket_entitlement') {
            $this->renderPartial('//hrreports/filter_ticket_entitlement', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'leaveledger') {
            $this->renderPartial('//hrreports/filter_leaveledger', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'salaryadvance') {
            $this->renderPartial('//hrreports/filter_salaryadvance_report', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'leavebalance') {
            $this->renderPartial('//hrreports/filter_leavebalance_report', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'showemployeetraining') {
            $this->renderPartial('//hrreports/filter_training_report', array('report_from' => $report_from), false, true);
        }
        /*         * ***********************   End HR Module Report  ********************************** */
        /*         * ***********************   sTAR hIRING Module Report  ********************************** */
        if ($report_from == 'consumablelist') {
            $this->renderPartial('//hiringreports/filter_consumable_report', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'hiringstockstateasof') {
            $this->renderPartial('//hiringreports/print_hiring_stockas_report', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'operatorlist') {
            $this->renderPartial('//hiringreports/filter_operatorlist_report', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'operatortimesheet') {
            $this->renderPartial('//hiringreports/filter_operatortimesheet_report', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'operatorwagesheet') {
            $this->renderPartial('//hiringreports/filter_operatorwagesheet_report', array('report_from' => $report_from), false, true);
        }
        /*         * ************************ Fixed Asset ***************************** */
        if ($report_from == 'fixedasset') {
            $fixed_asset_master = Yii::app()->db->createCommand()
                    ->select('em.id, em.fixed_asset_name')
                    ->from('erp_fixed_asset_master as em')
                    ->where("em.isActive = :active ", array(':active' => 1))
                    ->queryAll();
            $fixed_asset_master_array = array();
            foreach ($fixed_asset_master as $number) {
                $fixed_asset_master_array[] = array(
                    'id' => $number['id'],
                    'value' => $number['fixed_asset_name']
                );
            }

            $this->renderPartial('//reports/filter_fixedassetlist', array('report_from' => $report_from, 'fixed_asset_master' => $fixed_asset_master_array), false, true);
        }
        /*         * *********************Flyer Report************************************** */
        if ($report_from == 'flyer_report') {
            $this->renderPartial('//reports/filter_flyer_report', array('report_from' => $report_from, 'fixed_asset_master' => $fixed_asset_master_array), false, true);
        }
        if ($report_from == 'flyer_report_send') {
            $this->renderPartial('//reports/filter_flyer_report_send', array('report_from' => $report_from, 'fixed_asset_master' => $fixed_asset_master_array), false, true);
        }

        if ($report_from == 'inventoryexternaltransferlist') {
            $this->renderPartial('//reports/filter_external_transfer_list', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'purchasestocklist') {
            $this->renderPartial('//reports/filter_stock_purchase_list', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'inventorycbm') {
            $this->renderPartial('//reports/filter_inv_cbm', array('report_from' => $report_from), false, true);
        }
        
        if ($report_from == 'provisional_list') {
            $this->renderPartial('//reports/filter_provisional_list', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'provisional_job_order_list') {
            $this->renderPartial('//reports/filter_provisional_job_order_list', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'provisional_invoice_list') {
            $this->renderPartial('//reports/filter_provisional_invoice_list', array('report_from' => $report_from), false, true);
        }
         if ($report_from == 'quotationlist') {
            $this->renderPartial('//reports/filter_quotationlist', array('report_from' => $report_from), false, true);
        }
        
        
         if ($report_from == 'rackbinlist') {
            $this->renderPartial('//reports/filter_rack_bin_report', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'quotationlistsummary') {
            $this->renderPartial('//reports/filter_quotationsummarylist', array('report_from' => $report_from), false, true);
        }

    }

    public function actionPrintDeliveryReport() {



        $model = new DeliveryNote();



        $del_from_date = $_POST['del_from_date'];

        $del_to_date = $_POST['del_to_date'];

        // $type_of_contract = $_POST['type_of_contract'];

        $customer_id = $_POST['customer_id'];

        $sales_group_id = $_POST['sales_group_id'];

        $status = $_POST['status'];

        $created_by = $_POST['created_by'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_delivery_list', array('model' => $model, 'del_from_date' => $del_from_date, 'del_to_date' => $del_to_date, 'sales_group_id' => $sales_group_id, 'customer_id' => $customer_id, 'status' => $status, 'title' => $title, 'created_by' => $created_by), false, true);
    }

    public function actiongetFixedAssetNumbers() {
        $fixed_asset_number = Yii::app()->db->createCommand()
                ->select('er.fixed_asset_register_number')
                ->from('erp_fixed_asset_register as er')
                ->where("er.isActive = :active and er.fixed_asset_master_number = :master", array(':active' => 'Y', 'master' => $_GET['fixed_asset_type']))
                ->queryAll();
        $fixed_asset_number_array = array();
        foreach ($fixed_asset_number as $number) {
            $fixed_asset_number_array[] = array(
                'id' => $number['fixed_asset_register_number'],
                'value' => $number['fixed_asset_register_number']
            );
        }
        $data = CHtml::listData($fixed_asset_number_array, 'id', 'value');
        echo CHtml::dropDownList('fixed_asset_number', '', $data, array('class' => 'tooltipster', 'data-label' => 'Fixed Asset Number', 'prompt' => 'Fixed Asset Number'));
    }

    /** PDF Generator for Fixed Asset */
    public function actionFixedAssetReportPDF() {

        $status = Yii::app()->request->getParam('status');
        $order_from_date = DateTime::createFromFormat('d/m/Y', $_GET['order_from_date']);
        $order_from_date = date_format($order_from_date, 'Y-m-d');

        $order_to_date = DateTime::createFromFormat('d/m/Y', $_GET['order_to_date']);
        $order_to_date = date_format($order_to_date, 'Y-m-d');

        $fixed_asset = $_GET['fixed_asset'];
        $fixed_asset_master = $_GET['fixed_asset_master'];
        $fixed_asset_condition = !empty($fixed_asset) ? ' and erd.fixed_asset_register = ' . $fixed_asset : '';
        $fixed_asset_master_condition = !empty($fixed_asset_master) ? ' and erd.fixed_asset_type = ' . $fixed_asset_master : '';
        $condition = " where erd.date_from >= '" . $order_from_date . "' and erd.date_to <= '" . $order_to_date . "' and erd.isActive = 'Y' $fixed_asset_condition $fixed_asset_master_condition ";

        $template = '';
        $filename = '';
        if ($status == 'S') {
            $report = Yii::app()->db->createCommand(
                            "select erm.fixed_asset_name, erd.fixed_asset_type, format(SUM(erd.depreciated_by), 2) as total_book_value, monthname(erd.date_from) as month_name, year(erd.date_from) as year
                                                        from erp_fixed_asset_depreciation as erd 
                                                        join erp_fixed_asset_master as erm on erd.fixed_asset_type = erm.id 
                                                        $condition
                                                        group by erd.fixed_asset_type, month(erd.date_from)
                                                        order by month(erd.date_from) asc, erm.fixed_asset_name asc  "
                    )
                    ->queryAll();
            $template = 'application.views.front.reports.pdf.fixedassetreport';
            $filename = "FixedAssetSummary.pdf";
        }

        if ($status == 'D') {
            $report = Yii::app()->db->createCommand(
                            "select  format(ei.rate, 2) as original_book_value, erd.fixed_asset_register, er.depreciation_start_date, er.description, format (erd.depreciated_by, 2) as depreciated_by , format (erd.current_book_value, 2) as current_book_value, CONCAT_WS(' ', MONTHNAME (erd.date_from), YEAR (erd.date_from)) as month, erd.updated_at, SUBSTR(em.fixed_asset_name, 1, 4) as fixed_asset_name
                                                        from erp_fixed_asset_depreciation as erd 
                                                        join erp_fixed_asset_master as em on erd.fixed_asset_type = em.id 
                                                        join erp_fixed_asset_register as er on erd.fixed_asset_register = er.fixed_asset_register_number and erd.fixed_asset_type = er.fixed_asset_master_number
                                                        join erp_purchasinginvoice_item as ei on er.invoice_id = ei.purchasing_invoice_id and er.product_id = ei.product_id
                                                        $condition
                                                        order by MONTHNAME (erd.date_from) desc, YEAR (erd.date_from) desc
                                                        "
                    )
                    ->queryAll();
            $template = 'application.views.front.reports.pdf.fixedassetreportdetails';
            $filename = "FixedAssetDetails.pdf";
        }

        try {
            $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
            $mpdf->WriteHTML($stylesheet, 1);
            $mpdf->WriteHTML($this->renderPartial($template, array('reports' => $report, 'order_from_date' => $order_from_date, 'order_to_date' => $order_to_date, 'status' => $status), true));
            $mpdf->Output($filename, 'I');
        } catch (\Mpdf\MpdfException $e) { // Note: safer fully qualified exception name used for catch
            // Process the exception, log, print etc.
            echo $e->getMessage();
        }
    }

    /** CSV Generator for Fixed Asset */
    public function actionFixedAssetReportExcel() {

        $status = Yii::app()->request->getParam('status');
        $order_from_date = DateTime::createFromFormat('d/m/Y', $_GET['order_from_date']);
        $order_from_date = date_format($order_from_date, 'Y-m-d');

        $order_to_date = DateTime::createFromFormat('d/m/Y', $_GET['order_to_date']);
        $order_to_date = date_format($order_to_date, 'Y-m-d');

        $fixed_asset = $_GET['fixed_asset'];
        $fixed_asset_master = $_GET['fixed_asset_master'];
        $fixed_asset_condition = !empty($fixed_asset) ? ' and erd.fixed_asset_register = ' . $fixed_asset : '';
        $fixed_asset_master_condition = !empty($fixed_asset_master) ? ' and erd.fixed_asset_type = ' . $fixed_asset_master : '';
        $condition = " where erd.date_from >= '" . $order_from_date . "' and erd.date_to <= '" . $order_to_date . "' and erd.isActive = 'Y' $fixed_asset_condition $fixed_asset_master_condition ";

        $template = '';
        $filename = '';
        if ($status == 'S') {
            $report = Yii::app()->db->createCommand(
                            "select erm.fixed_asset_name, erd.fixed_asset_type, SUM(erd.depreciated_by) as total_book_value, monthname(erd.date_from) as month_name, year(erd.date_from) as year
                                                        from erp_fixed_asset_depreciation as erd 
                                                        join erp_fixed_asset_master as erm
                                                        on erd.fixed_asset_type = erm.id 
                                                        $condition
                                                        group by erd.fixed_asset_type, month(erd.date_from)"
                    )
                    ->queryAll();

            $file = fopen("uploads/csvs/test.csv", "w");

            $j = 0;
            $list[$j++] = 'No!Month!Fixed Asset Type!Depreciated Book Value';

            foreach ($report as $i => $row) {
                $list[$j++] = ($i + 1) . '!' . $row['month_name'] . '!' . $row['fixed_asset_name'] . '!' . $row['total_book_value'];
            }

            $j++;

            foreach ($list as $line) {
                fputcsv($file, explode('!', $line));
            }

            fclose($file);
            $filename = 'uploads/csvs/test.csv';
            $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
            header('Content-Type: application/csv');
            header("Content-disposition: attachment; filename=\"FixedAssetSummary.csv\"");
            readfile($filename);
            Yii::app()->end();
            return;
        }

        if ($status == 'D') {
            $report = Yii::app()->db->createCommand(
                            "select erd.id, erd.fixed_asset_register, erd.depreciated_date, erd.depreciated_by, erd.current_book_value, erd.date_from, erd.date_to, erd.updated_at, em.fixed_asset_name
                                                        from erp_fixed_asset_depreciation as erd 
                                                        join erp_fixed_asset_master as em
                                                        on erd.fixed_asset_type = em.id 
                                                        $condition
                                                        "
                    )
                    ->queryAll();

            $file = fopen("uploads/csvs/test.csv", "w");
            $j = 0;
            $list[$j++] = 'No!Fixed Asset Number!Fixed Asset Type!Depreciated Date!Depreciated By!C.B.V!Depreciated from';

            foreach ($report as $i => $row) {
                $list[$j++] = ($i + 1) . '!' . $report['fixed_asset_register'] . '!' . $row['fixed_asset_name'] . '!' . $row['depreciated_date'] . '!' . $row['depreciated_by'] . '!' . $row['current_book_value'] . '!' . date("d M Y", strtotime($row['date_from'])) . ' to ' . date("d M Y", strtotime($row['date_to']));
            }

            $j++;

            foreach ($list as $line) {
                fputcsv($file, explode('!', $line));
            }

            fclose($file);
            $filename = 'uploads/csvs/test.csv';
            $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
            header('Content-Type: application/csv');
            header("Content-disposition: attachment; filename=\"FixedAssetDetails.csv\"");
            readfile($filename);
            Yii::app()->end();
            return;
        }
    }

    public function actionPrintDeliveryReportPDF() {



        $model = new DeliveryNote();



        $del_from_date = Yii::app()->request->getParam('del_from_date');

        $del_to_date = Yii::app()->request->getParam('del_to_date');

        $customer_id = Yii::app()->request->getParam('customer_id');

        $sales_group_id = $_GET["sales_group_id"]; //Yii::app()->request->getParam('sales_group_id');
        $created_by = Yii::app()->request->getParam('created_by');
        $status = Yii::app()->request->getParam('status');
        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.deliverynote_list', array('model' => $model, 'del_from_date' => $del_from_date, 'del_to_date' => $del_to_date, 'sales_group_id' => $sales_group_id, 'status' => $status, 'customer_id' => $customer_id, 'title' => $title, 'created_by' => $created_by), true));



        $mpdf->Output("DeliveryReport.pdf", 'I');
    }

    public function actionPrintInvoiceReport() {

        $model = new Invoice();

        $invoice_from_date = $_POST['invoice_from_date'];

        $invoice_to_date = $_POST['invoice_to_date'];

        $leadowner_id = $_POST['leadowner_id'];

        $customer_id = $_POST['customer_id'];

        $sales_group = $_POST['sales_group'];

        $brand_id = $_POST['brand'];

        $product_id = $_POST['product_id'];

        $invoce_country = $_POST['invoce_country'];

        $invoce_location = $_POST['invoce_location'];

        $inv_type = $_POST['type'];

        $created_by = $_POST['created_by'];

        //  $type = Yii::app()->request->getParam('type');

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_invoice_list', array('model' => $model, 'invoice_from_date' => $invoice_from_date, 'invoice_to_date' => $invoice_to_date, 'sales_group' => $sales_group, 'leadowner_id' => $leadowner_id, 'customer_id' => $customer_id, 'product_id' => $product_id, 'brand_id' => $brand_id, 'invoce_country' => $invoce_country, 'invoce_location' => $invoce_location, 'title' => $title, 'inv_type' => $inv_type, 'created_by' => $created_by), false, true);
    }

    /*

      public function actionPrintInvoiceReport() {



      $model = new Invoice();



      $invoice_from_date = $_POST['invoice_from_date'];

      $invoice_to_date = $_POST['invoice_to_date'];

      // $type_of_contract = $_POST['type_of_contract'];

      $customer_id = $_POST['customer_id'];

      $sales_group = $_POST['sales_group'];

      $brand_id = $_POST['brand'];

      $product_id = $_POST['product_id'];



      $invoce_country = $_POST['invoce_country'];

      $invoce_location = $_POST['invoce_location'];



      Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



      $this->render('//reports/print_invoice_list', array('model' => $model, 'invoice_from_date' => $invoice_from_date, 'invoice_to_date' => $invoice_to_date, 'sales_group' => $sales_group,

      'customer_id' => $customer_id, 'product_id' => $product_id, 'brand_id' => $brand_id,

      'invoce_country' => $invoce_country, 'invoce_location' => $invoce_location, 'title' => $title), false, true);

      }

     */

    public function actionPrintInvoiceReportPDF() {



        $model = new Invoice();



        $invoice_from_date = Yii::app()->request->getParam('invoice_from_date');

        $invoice_to_date = Yii::app()->request->getParam('invoice_to_date');

        $customer_id = Yii::app()->request->getParam('customer_id');

        $leadowner_id = Yii::app()->request->getParam('leadowner_id');

        $sales_group = Yii::app()->request->getParam('sales_group');

        $brand_id = Yii::app()->request->getParam('brand_id');

        $invoce_country = Yii::app()->request->getParam('invoce_country');

        $invoce_location = Yii::app()->request->getParam('invoce_location');

        $type = Yii::app()->request->getParam('type');

        $created_by = Yii::app()->request->getParam('created_by');

//        $enquiry_id = Yii::app()->request->getParam('enquiry_id');



        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.invoice_list', array('model' => $model, 'sales_group' => $sales_group, 'invoice_from_date' => $invoice_from_date, 'invoice_to_date' => $invoice_to_date, 'sales_group' => $sales_group, 'customer_id' => $customer_id, 'leadowner_id' => $leadowner_id,
                    'invoce_country' => $invoce_country, 'invoce_location' => $invoce_location, 'title' => $title, 'inv_type' => $type, 'brand_id' => $brand_id, 'created_by' => $created_by), true));



        $mpdf->Output("InvoiceReport.pdf", 'I');
    }

    public function actionPrintInvoiceExcel() {



        $invoice_from_date = Yii::app()->request->getParam('invoice_from_date');

        $invoice_to_date = Yii::app()->request->getParam('invoice_to_date');

        $type_of_contract = Yii::app()->request->getParam('type_of_contract');

        $customer_id = Yii::app()->request->getParam('customer_id');

        $sales_group_id = Yii::app()->request->getParam('sales_group_id');

        $payment_terms = Yii::app()->request->getParam('payment_terms'); //print_r($payment_terms);die();



        $file = fopen("uploads/csvs/test.csv", "w");

        $criteria = new CDbCriteria;



        if (!empty($invoice_from_date)) {

            $invoice_from_date = str_replace('/', '-', $invoice_from_date);

            $invoice_from_date = date('Y-m-d', strtotime($invoice_from_date));

            $criteria->addCondition('t.invoice_date>="' . $invoice_from_date . '"', 'AND');
        }

        if (!empty($invoice_to_date)) {

            $invoice_to_date = str_replace('/', '-', $invoice_to_date);

            $invoice_to_date = date('Y-m-d', strtotime($invoice_to_date));

            $criteria->addCondition('t.invoice_date<="' . $invoice_to_date . '"', 'AND');
        }



        if (!empty($customer_id))
            $criteria->addCondition('t.customer_id="' . $customer_id . '"', 'AND');

        if (!empty($sales_group_id))
            $criteria->addCondition('t.sales_group_id="' . $sales_group_id . '"', 'AND');

        if ($payment_terms != '')
            $criteria->addCondition('t.payment_terms="' . $payment_terms . '"', 'AND');

        if (!empty($type_of_contract))
            $criteria->addCondition('t.type_of_contract="' . $type_of_contract . '"', 'AND');

//        print_r($criteria);

        $invoice = Invoice::model()->findAll($criteria); //print_r($invoice);die();

        $j = 0;



        $list[$j++] = 'No!Customer Name!Order Date!Currency!Net Amount!Grand Total!Sales Group!Payment Term!Type of Contract!Contact Name!Mobile!Email';



        foreach ($invoice as $i => $row) {

            if ($row->invoice_date != '0000-00-00') {

                $d1 = date("d/m/Y", strtotime($row->invoice_date));
            } else {

                $d1 = " ";
            }



            $list[$j++] = ($i + 1) . '!' . $row->customer->customer_name . '!' . $d1 . '!' . $row->currencyname->currency_code
                    . '!' . $row->net_amount . '!' . $row->grand_total . '!' . $row->salesgroup->group_name
                    . '!' . $row->paymentTerm->payment_term . '!' . $row->typedetail->service_group_name . '!' . $row->customercontact->person_name . '!' . $row->mobile . '!' . $row->email;
        }

        $j++;

        foreach ($list as $line) {

            fputcsv($file, explode('!', $line));
        }

        fclose($file);

        $filename = 'uploads/csvs/test.csv';

        //$filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';

        header('Content-Type: application/csv');

        header("Content-disposition: attachment; filename=\"invoicelist.csv\"");

        readfile($filename);

        Yii::app()->end();

        return;
    }

    public function actionPrintPurchaseOrderReport() {



        $model = new PurchasingOrder();



        $order_from_date = $_POST['order_from_date'];

        $order_to_date = $_POST['order_to_date'];

        $vendor_id = $_POST['vendor_id'];

        $completed = $_POST['completed'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_purchaseorder_list', array('model' => $model, 'order_from_date' => $order_from_date, 'order_to_date' => $order_to_date, 'vendor_id' => $vendor_id, 'completed' => $completed), false, true);
    }

    public function actionPrintOrderReport() {



        $model = new Order();



        $order_from_date = $_POST['order_from_date'];

        $delivery_from_date = $_POST['delivery_from_date'];

        $order_to_date = $_POST['order_to_date'];

        $delivery_to_date = $_POST['delivery_to_date'];

        $customer_id = $_POST['customer_id'];

        $sales_group = $_POST['sales_group'];

        $payment_terms = $_POST['payment_terms'];

        $type_of_contract = $_POST['type_of_contract'];

        $leadowner_id = $_POST['leadowner_id'];

        $leadowner_country = $_POST['ord_leadowner_country'];

        $brand = $_POST['brand'];

        $value_from = $_POST['value_from'];

        $value_to = $_POST['value_to'];

        $status = $_POST['status'];

        $probability = $_POST['probability'];



        $leadowner_country = $_POST['ord_leadowner_country'];

        $leadowner_location = $_POST['ord_leadowner_location'];

        $order_part_no_id = $_POST['order_part_no_id'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_order_list', array('model' => $model, 'leadowner_id' => $leadowner_id, 'order_from_date' => $order_from_date, 'delivery_from_date' => $delivery_from_date, 'order_to_date' => $order_to_date, 'delivery_to_date' => $delivery_to_date, 'sales_group' => $sales_group, 'payment_terms' => $payment_terms, 'type_of_contract' => $type_of_contract, 'customer_id' => $customer_id,
            'leadowner_country' => $leadowner_country, 'leadowner_location' => $leadowner_location, 'order_part_no_id' => $order_part_no_id,
            'brand' => $brand, 'value_from' => $value_from, 'value_to' => $value_to, 'status' => $status, 'probability' => $probability,
            'title' => $title), false, true);
    }

    public function actionPrintPurchaseOrderReportPDF() {



        $model = new PurchasingOrder();



        $order_from_date = Yii::app()->request->getParam('order_from_date');

        $order_to_date = Yii::app()->request->getParam('order_to_date');

        $vendor_id = Yii::app()->request->getParam('vendor_id');

        $completed = Yii::app()->request->getParam('completed');



        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.purchaseorder_list', array('model' => $model, 'order_from_date' => $order_from_date, 'order_to_date' => $order_to_date, 'vendor_id' => $vendor_id, 'completed' => $completed), true));



        $mpdf->Output("PurchaseOrderReport.pdf", 'I');
    }

    public function actionPrintOrderReportPDF() {



        $model = new Order();



        $order_from_date = Yii::app()->request->getParam('order_from_date');

        $order_to_date = Yii::app()->request->getParam('order_to_date');

        $delivery_from_date = Yii::app()->request->getParam('delivery_from_date');

        $delivery_to_date = Yii::app()->request->getParam('delivery_to_date');

        $customer_id = Yii::app()->request->getParam('customer_id');

        $sales_group = Yii::app()->request->getParam('sales_group');

        $leadowner_id = Yii::app()->request->getParam('leadowner_id');

        $type_of_contract = Yii::app()->request->getParam('type_of_contract');

        $country_id = Yii::app()->request->getParam('country_id');

        $status = Yii::app()->request->getParam('status');

        $brand = Yii::app()->request->getParam('brand');

        $value_from = Yii::app()->request->getParam('value_from');

        $value_to = Yii::app()->request->getParam('value_to');

//        $enquiry_id = Yii::app()->request->getParam('enquiry_id');

        $param = array('model' => $model,
            'leadowner_id' => $leadowner_id,
            'order_from_date' => $order_from_date,
            'delivery_from_date' => $delivery_from_date,
            'order_to_date' => $order_to_date,
            'delivery_to_date' => $delivery_to_date,
            'sales_group' => $sales_group,
            'payment_terms' => $payment_terms,
            'type_of_contract' => $type_of_contract,
            'customer_id' => $customer_id,
            'country_id' => $country_id,
            'value_from' => $value_from,
            'value_to' => $value_to,
            'brand' => $brand,
            'status' => $status,
            'title' => $title);

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.order_list', $param, true));



        $mpdf->Output("Orderlist.pdf", 'I');
    }

    public function actionPrintOrderExcel() {

        $order_from_date = Yii::app()->request->getParam('order_from_date');

        $order_to_date = Yii::app()->request->getParam('order_to_date');

        $delivery_from_date = Yii::app()->request->getParam('delivery_from_date');

        $delivery_to_date = Yii::app()->request->getParam('delivery_to_date');

        $customer_id = Yii::app()->request->getParam('customer_id');

        $sales_group = Yii::app()->request->getParam('sales_group');

        $payment_terms = Yii::app()->request->getParam('payment_terms');

        $type_of_contract = Yii::app()->request->getParam('type_of_contract');

        $status = Yii::app()->request->getParam('status');



        $file = fopen("uploads/csvs/test.csv", "w");

        $criteria = new CDbCriteria;



        if (!empty($order_from_date)) {

            $order_from_date = str_replace('/', '-', $order_from_date);

            $order_from_date = date('Y-m-d', strtotime($order_from_date));

            $criteria->addCondition('t.order_date>="' . $order_from_date . '"', 'AND');
        }

        if (!empty($order_to_date)) {

            $order_to_date = str_replace('/', '-', $order_to_date);

            $order_to_date = date('Y-m-d', strtotime($order_to_date));

            $criteria->addCondition('t.order_date<="' . $order_to_date . '"', 'AND');
        }

        if ($delivery_from_date != '') {
            $delivery_from_date = str_replace('/', '-', $delivery_from_date);
            $delivery_from_date = date('Y-m-d', strtotime($delivery_from_date));
            $criteria->addCondition('t.delivery_date<="' . $delivery_from_date . '"', 'AND');
        }
        if ($delivery_to_date != '') {
            $delivery_to_date = str_replace('/', '-', $delivery_to_date);
            $delivery_to_date = date('Y-m-d', strtotime($delivery_to_date));
            $criteria->addCondition('t.delivery_date<="' . $delivery_to_date . '"', 'AND');
        }
        if ($sales_group != '') {
            $criteria->addCondition('t.sales_group ="' . $sales_group . '"', 'AND');
        }
        if ($customer_id != '') {

            $criteria->addCondition('t.customer_id ="' . $customer_id . '"', 'AND');
        }
        if ($country_id != '') {

            $criteria->addCondition('customer.customer_country ="' . $country_id . '"', 'AND');
        }


        if ($status > 1) {
            $criteria->addCondition('file.current_process_status IN("PI","PD")', 'AND');
        }
        if ($status == 1) {
            $criteria->addCondition('file.current_process_status = "O"', 'AND');
        }
        if ($status == 2) {
            $criteria->addCondition('file.current_process_status IN("PI","PD")', 'AND');
        }







        $order = Order::model()->findAll($criteria);

        $j = 0;

        $list[$j++] = 'No!Order No!File No!Customer Name!Account Manager!Status!Order Date!Delivery Date!Sales Group!Currency!Grand Total!VAT!Grand Total(BC)';



        foreach ($order as $i => $row) {
            $service_amount = 0.00;
            $service_tax_vat_amount = 0.00;
            /* $modelOrderServiceItem = OrderServiceItem::model()->find(array('select' => 'sum(net_amount) as net_amount,sum(tax_vat_amount) as tax_vat_amount', 'condition' => 'order_id="' . $row->id . '"'));
              if ($modelOrderServiceItem->net_amount > 0) {
              $service_amount = $modelOrderServiceItem->net_amount;
              $service_tax_vat_amount = $modelOrderServiceItem->tax_vat_amount;
              } */

            $status = " ";
            switch ($row->file->current_process_status) {
                case 'PI':
                    $status = "Partially Invoiced";
                    break;
                case 'PD':
                    $status = "Partially Delivered";
                    break;
                case 'I':
                    $status = "Invoiced";
                    break;
                case 'D':
                    $status = "Delivered";
                    break;
                case 'O':
                    $status = "Order";
                    break;
            }
            if ($row->order_date != '0000-00-00') {

                $d1 = date("d/m/Y", strtotime($row->order_date));
            } else {

                $d1 = " ";
            }

            if ($row->delivery_date != '0000-00-00') {

                $d2 = date("d/m/Y", strtotime($row->delivery_date));
            } else {

                $d2 = " ";
            }

            $model_currency = MasCurrency::model()->findByPk($row->currency);

            $total_bc = ($row->grand_total + $service_amount + $service_tax_vat_amount) * $model_currency->exchange_rate;

            $list[$j++] = ($i + 1) . '!' . $row->id . '!'
                    . $row->file_id . '!' . $row->customer->customer_name . '!' . $row->file->leadowner->first_name . " " . $row->file->leadowner->last_name . '!' . $status . "!"
                    . $d1 . '!' . $d2 . '!'
                    . $row->salesgroup->group_name . '!' . $model_currency->currency_code . '!' . ($row->grand_total + $service_amount + $service_tax_vat_amount) . '!' . ($row->total_tax_amount + $service_tax_vat_amount) . '!'
                    . $total_bc;
        }

        $j++;

        foreach ($list as $line) {

            fputcsv($file, explode('!', $line));
        }

        fclose($file);

        $filename = 'uploads/csvs/test.csv'; //Yii::app()->getBaseUrl(true) .

        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';

        header('Content-Type: application/csv');

        header("Content-disposition: attachment; filename=\"orderlist.csv\"");

        readfile($filename);

        Yii::app()->end();

        return;
    }

    public function actionPrintQuoteReport() {



        $model = new Quotation();

        $qtn_start_from_date = $_POST['start_from_date'];

        $qtn_start_to_date = $_POST['start_to_date'];

        

        $customer_id = $_POST['customer_id'];

        $qtn_shipper_id = $_POST['qtn_shipper_id'];

        $qtn_consignee_id = $_POST['qtn_consignee_id'];



        $qtn_origin_id = $_POST['qtn_origin_id'];

        $qtn_destination_id = $_POST['qtn_destination_id'];

        $filter_quotation_transport_type = $_POST['filter_quotation_transport_type'];

        $qtn_status = $_POST['qtn_status'];

        $brand = $_POST['brand'];

        $value_from = $_POST['value_from'];

        $value_to = $_POST['value_to'];

        $created_by = $_POST['created_by'];

        $quotes_type = $_POST['quotes_type'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_quote_list', array('model' => $model,'qtn_start_from_date' => $qtn_start_from_date, 'qtn_start_to_date' => $qtn_start_to_date,
         'customer_id' => $customer_id, 'qtn_shipper_id' => $qtn_shipper_id, 'qtn_consignee_id' => $qtn_consignee_id, 'qtn_origin_id' => $qtn_origin_id,
            'qtn_destination_id' => $qtn_destination_id, 'filter_quotation_transport_type' => $filter_quotation_transport_type, 'qtn_status' => $qtn_status, 'brand' => $brand, 'created_by' => $created_by,
            'value_from' => $value_from, 'value_to' => $value_to, 'title' => $title, 'quotes_type' => $quotes_type), false, true);
    }

    /* public function actionPrintQuoteReport1() {



      $model = new Quotes();

      $description = $_POST['description'];

      $no_char = $_POST['no_char'];

      $start = $_POST['qtn_start_from_date'];

      $end = $_POST['qtn_start_to_date'];

      $customer_id = $_POST['customer_id'];

      $description1 = explode(',', $description);

      $no_char = explode(',', $no_char);

      $data1 = '';

      $des = '';

      $pre = '';

      foreach ($description1 as $i => $each) {

      $des_check = '';

      $length = $no_char[$i];

      $data = $_POST[$each];

      $des_check = $each;

      $des_check = str_replace("_", " ", $des_check);

      if (empty($data)) {

      if ($pre != '%') {

      $data1 .= '%';
      }

      $pre = '%';
      } else {

      $data1 .= $data;

      $pre = '';

      $len = strlen($data);

      if ($length > $len) {

      $add = '';

      $bal = $length - $len;

      for ($j = 0; $j < $bal; $j++) {

      $add .= 'X';
      }

      $data1 .= $add;
      }
      }
      }

      Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

      $this->render('//reports/print_quote_list1', array('model' => $model, 'data' => $data1, 'start' => $start, 'end' => $end, 'customer_id' => $customer_id), false, true);
      } */

    public function actionPrintQuoteReportPDF() {



        $model = new Quotation();



        $qtn_start_from_date = Yii::app()->request->getParam('qtn_start_from_date');

        $qtn_start_to_date = Yii::app()->request->getParam('qtn_start_to_date');

        $customer_id = Yii::app()->request->getParam('customer_id');

        $qtn_shipper_id = Yii::app()->request->getParam('qtn_shipper_id');

        $qtn_consignee_id = Yii::app()->request->getParam('qtn_consignee_id');

        $qtn_origin_id = Yii::app()->request->getParam('qtn_origin_id');

        $qtn_destination_id = Yii::app()->request->getParam('qtn_destination_id');

        $filter_quotation_transport_type = Yii::app()->request->getParam('filter_quotation_transport_type');

        $qtn_status = Yii::app()->request->getParam('qtn_status');

        $qtn_location = Yii::app()->request->getParam('qtn_location');

        $qtn_part_no_id = Yii::app()->request->getParam('qtn_part_no_id');

        $brand = Yii::app()->request->getParam('brand');

        $status = Yii::app()->request->getParam('status');

        $created_by = Yii::app()->request->getParam('created_by');
        $quotes_type = Yii::app()->request->getParam('quotes_type');



        $param = array('model' => $model,
            'qtn_start_from_date' => $qtn_start_from_date, 'qtn_start_to_date' => $qtn_start_to_date,
            'customer_id' => $customer_id, 'qtn_shipper_id' => $qtn_shipper_id, 'qtn_consignee_id' => $qtn_consignee_id,
            'qtn_origin_id' => $qtn_origin_id,'qtn_destination_id' => $qtn_destination_id, 
            'filter_quotation_transport_type' => $filter_quotation_transport_type, 'qtn_status' => $qtn_status
        );



        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.quote_list', $param, true));



        $mpdf->Output("Quotelist.pdf", 'I');
    }

    public function actionPrintQuoteExcel() {

        $qtn_start_from_date = Yii::app()->request->getParam('qtn_start_from_date');

        $qtn_start_to_date = Yii::app()->request->getParam('qtn_start_to_date');

        $customer_id = Yii::app()->request->getParam('customer_id');

        $qtn_shipper_id = Yii::app()->request->getParam('qtn_shipper_id');

        $qtn_consignee_id = Yii::app()->request->getParam('qtn_consignee_id');

        $qtn_origin_id = Yii::app()->request->getParam('qtn_origin_id');

        $qtn_destination_id = Yii::app()->request->getParam('qtn_destination_id');

        $filter_quotation_transport_type = Yii::app()->request->getParam('filter_quotation_transport_type');

        $qtn_status = Yii::app()->request->getParam('qtn_status');

        $file = fopen("uploads/csvs/test.csv", "w");

        $criteria = new CDbCriteria;



        if ($qtn_start_from_date != '') {
            
            $qtn_start_from_date = str_replace('/', '-', $qtn_start_from_date);
                        
            $qtn_start_from_date = date('Y-m-d', strtotime($qtn_start_from_date));
            
            $criteria->addCondition('t.quotation_date >="' . $qtn_start_from_date . '"', 'AND');
        }

        if ($qtn_start_to_date != '') {
             
            $qtn_start_to_date = str_replace('/', '-', $qtn_start_to_date);
                        
            $qtn_start_to_date = date('Y-m-d', strtotime($qtn_start_to_date));
            
            $criteria->addCondition('t.quotation_date <="' . $qtn_start_to_date . '"', 'AND');
        }

        if ($customer_id != '') {

            $criteria->addCondition('t.customer_id ="' . $customer_id . '"', 'AND');
        }



        if ($qtn_shipper_id != '') {

            $criteria->addCondition('t.shipper_id ="' . $qtn_shipper_id . '"', 'AND');
        }
         if ($qtn_consignee_id != '') {

            $criteria->addCondition('t.consignee_id ="' . $qtn_consignee_id . '"', 'AND');
        }

        if ($qtn_origin_id != '') {
            $criteria->addCondition('t.origin_id ="' . $qtn_origin_id . '"', 'AND');
        }
         if ($qtn_destination_id != '') {
            $criteria->addCondition('t.destination_id ="' . $qtn_destination_id . '"', 'AND');
        }
        
         if ($filter_quotation_transport_type != '') {
            $criteria->addCondition('t.transport_type ="' . $filter_quotation_transport_type . '"', 'AND');
        }
        
         if ($qtn_status != '') {
            $criteria->addCondition('t.quotation_status ="' . $qtn_status . '"', 'AND');
        }
        //print_r($criteria);echo '<pre>';

        $quote = Quotation::model()->with('customer', 'transporttype')->findAll($criteria);

        $j = 0;



        $list[$j++] = 'No!Qtn #!Qtn Date!Customer!Origin!Cnee!Destination!Service Type!Status';



        foreach ($quote as $i => $row) {
            
            
             $destination_id = '';
            if ((int) $row['destination_id'] > 0) {
                $destination_id = MasCountry::model()->findByPk($row['destination_id'])->country_name;
            }
            $origin_id = '';
            if ((int) $row['origin_id'] > 0) {
                $origin_id = MasCountry::model()->findByPk($row['origin_id'])->country_name;
            }

            if ($row->quotation_date != '0000-00-00') {

                $d1 = date("d/m/Y", strtotime($row->quotation_date));
            } else {

                $d1 = " ";
            }

           /* if ($row->qtn_close_date != '0000-00-00') {

                $d2 = date("d/m/Y", strtotime($row->qtn_close_date));
            } else {

                $d2 = " ";
            }

            if ($row->qtn_delivery_date != '0000-00-00') {

                $d3 = date("d/m/Y", strtotime($row->qtn_delivery_date));
            } else {

                $d3 = " ";
            }

            if ($row->qtn_validity != '0000-00-00') {

                $d4 = date("d/m/Y", strtotime($row->qtn_validity));
            } else {

                $d4 = " ";
            }*/

            if ($row->quotation_date != '0000-00-00') {

                $d5 = date("d/m/Y", strtotime($row->quotation_date));
            } else {

                $d5 = " ";
            }

             if ($row->quotation_status == '0')
                $state = "Open";
            if ($row->quotation_status == 'CL')
                $state = "Closed";
            if ($row->quotation_status == 'A')
                $state = "Awaiting";
            if ($row->quotation_status == 'CO')
                $state = "Confirmed";

           

            $list[$j++] = ($i + 1) .  '!' . $row->id . '!' . $d5 . '!' . $row->customer->customer_name . '!' . $origin_id . "!" . $row->consignee_id
                    . '!' . $destination_id .  '!' . $row->transporttype->transport_type . '!' . $state;
        }

        $j++;

        foreach ($list as $line) {

            fputcsv($file, explode('!', $line));
        }

        fclose($file);

        $filename = 'uploads/csvs/test.csv';

        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';

        header('Content-Type: application/csv');

        header("Content-disposition: attachment; filename=\"quotelist.csv\"");

        readfile($filename);

        Yii::app()->end();

        return;
    }

    public function actionPrintInventoryReport() {



        $model = new Inventory();

        $type = $_POST['type'];

        $part_number = $_POST['part_number'];

        $generic_name = $_POST['generic_name'];

        $tax_code = $_POST['tax_code'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_inventory_list', array('model' => $model, 'type' => $type, 'part_number' => $part_number, 'generic_name' => $generic_name, 'tax_code' => $tax_code, 'title' => $title), false, true);
    }

    public function actionPrintJoborderReport() {



        $model = new JobOrder();

        $filter_job_order_priority = $_POST['filter_job_order_priority'];

        $filter_job_order_no = $_POST['filter_job_order_no'];

        $filter_job_order_shipper = $_POST['filter_job_order_shipper'];

        $filter_job_order_agent = $_POST['filter_job_order_agent'];

        $filter_job_order_awb_no = $_POST['filter_job_order_awb_no'];

        $filter_job_order_transport_type = $_POST['filter_job_order_transport_type'];

        $filter_job_order_status = $_POST['filter_job_order_status'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_joborder_list', array('model' => $model, 'filter_job_order_priority' => $filter_job_order_priority, 'filter_job_order_no' => $filter_job_order_no, 'filter_job_order_shipper' => $filter_job_order_shipper, 'filter_job_order_agent' => $filter_job_order_agent, 'filter_job_order_status' => $filter_job_order_status, 'filter_job_order_awb_no' => $filter_job_order_awb_no, 'filter_job_order_transport_type' => $filter_job_order_transport_type, 'title' => $title), false, true);
    }

    public function actionPrintFinishedInventoryReport() {



        $model = new Inventory();

        $machine_no = $_POST['machine_no'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_finished_inventory_list', array('model' => $model, 'machine_no' => $machine_no, 'title' => $title), false, true);
    }

    public function actionPrintLeadReport() {



        $model = new Lead();

        $enq_from_date = $_POST['enq_from_date'];

        $enq_to_date = $_POST['enq_to_date'];

        $closing_from_date = $_POST['closing_from_date'];

        $closing_to_date = $_POST['closing_to_date'];

        $customer_id = $_POST['customer_id'];

        $status = $_POST['status'];

        $lead_owner_id = $_POST['leadowner_id'];

        $sales_group_id = $_POST['sales_group_id'];

        $source_of_lead = $_POST['source_of_lead'];
        $lead_type = $_POST['lead_type'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_lead_list', array('model' => $model, 'enq_from_date' => $enq_from_date, 'enq_to_date' => $enq_to_date, 'closing_from_date' => $closing_from_date, 'closing_to_date' => $closing_to_date, 'customer_id' => $customer_id, 'status' => $status, 'lead_owner_id' => $lead_owner_id, 'sales_group_id' => $sales_group_id, 'source_of_lead' => $source_of_lead, 'lead_type' => $lead_type, 'title' => $title), false, true);
    }

    public function actionPrintLeadReportPDF() {



        $model = new Lead();

        $enq_from_date = Yii::app()->request->getParam('enq_from_date');

        $enq_to_date = Yii::app()->request->getParam('enq_to_date');

        $closing_from_date = Yii::app()->request->getParam('closing_from_date');

        $closing_to_date = Yii::app()->request->getParam('closing_to_date');

        $customer_id = Yii::app()->request->getParam('customer_id');

        $status = Yii::app()->request->getParam('status');

        $lead_owner_id = Yii::app()->request->getParam('lead_owner_id');

        $sales_group_id = Yii::app()->request->getParam('sales_group_id');

        $source_of_lead = (int) Yii::app()->request->getParam('source_of_lead');
        $lead_type = Yii::app()->request->getParam('lead_type');


//        $enquiry_id = Yii::app()->request->getParam('enquiry_id');



        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.lead_list', array('model' => $model, 'enq_from_date' => $enq_from_date, 'enq_to_date' => $enq_to_date, 'closing_from_date' => $closing_from_date, 'closing_to_date' => $closing_to_date, 'customer_id' => $customer_id, 'status' => $status, 'lead_owner_id' => $lead_owner_id, 'sales_group_id' => $sales_group_id, 'source_of_lead' => $source_of_lead, 'lead_type' => $lead_type, 'title' => $title), true));

        $mpdf->Output('LeadList.pdf', 'I');
    }

    public function actionPrintLeadReportPrint() {



        $model = new Lead();

        $enq_from_date = Yii::app()->request->getParam('enq_from_date');

        $enq_to_date = Yii::app()->request->getParam('enq_to_date');

        $closing_from_date = Yii::app()->request->getParam('closing_from_date');

        $closing_to_date = Yii::app()->request->getParam('closing_to_date');

        $customer_id = Yii::app()->request->getParam('customer_id');

        $status = Yii::app()->request->getParam('status');

        $lead_owner_id = Yii::app()->request->getParam('lead_owner_id');

        $sales_group_id = Yii::app()->request->getParam('sales_group_id');



//        $enquiry_id = Yii::app()->request->getParam('enquiry_id');



        $param = array('model' => $model,
            'enq_from_date' => $enq_from_date,
            'enq_to_date' => $enq_to_date,
            'closing_from_date' => $closing_from_date,
            'closing_to_date' => $closing_to_date,
            'customer_id' => $customer_id,
            'status' => $status,
            'lead_owner_id' => $lead_owner_id,
            'sales_group_id' => $sales_group_id,
            'title' => $title);

        echo $this->renderPartial('application.views.front.reports.pdf.lead_list', $param, true);
    }

    public function actionPrintInventoryReportPDF() {



        $type = (int) Yii::app()->request->getParam('type');

        $active = Yii::app()->request->getParam('active');

        $part_no = Yii::app()->request->getParam('part_no');

        $generic_id = (int) Yii::app()->request->getParam('generic_id');

        $tax_code = Yii::app()->request->getParam('tax_code');

        $brand_id = (int) Yii::app()->request->getParam('brand_id');

        $having_stock = (int) Yii::app()->request->getParam('having_stock');


        $condition = '1=1';

        if ($active != "") {
            $condition .= " AND isActive = '{$active}' ";
        }
        if ($type > 0)
            $condition .= ' AND type =' . $type;

        if ($generic_id > 0)
            $condition .= ' AND generic_id=' . $generic_id;

        if ($tax_code != "")
            $condition .= ' AND tax_code=' . $tax_code;

        if ($brand_id > 0)
            $condition .= ' AND brand=' . $brand_id;

        if ($part_no != '')
            $condition .= ' AND part_number LIKE "%' . $part_no . '%"';

//print_r($condition);

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.inventory_list', array('condition' => $condition, 'having_stock' => $having_stock), true));

        $mpdf->Output("inventorylist" . date('dmYhis') . ".pdf", 'I');
    }

    public function actionJoborderReportPDF() {

        $model = new JobOrder();

        $filter_start_date = Yii::app()->request->getParam('filter_start_date');

        $filter_job_no = Yii::app()->request->getParam('filter_job_no');

        $filter_customer = Yii::app()->request->getParam('filter_customer');

        $filter_agent = Yii::app()->request->getParam('filter_agent');

        $filter_job_order_priority = Yii::app()->request->getParam('filter_job_order_priority');

        $filter_end_date = Yii::app()->request->getParam('filter_end_date');

        $filter_job_order_status = Yii::app()->request->getParam('filter_job_order_status');

        $filter_job_order_transport_type = Yii::app()->request->getParam('filter_job_order_transport_type');


        $condition = "1=1";
        if(isset($filter_job_order_status) && $filter_job_order_status!="")
        {
            $condition.=" AND job_order_status='".$filter_job_order_status."'";
        }
         if($filter_job_order_transport_type!="")
        {
            $condition.=" AND transport_type='".$filter_job_order_transport_type."'";
        }
        if (((int) Yii::app()->user->havePermissionOn["job_order_view_all"]) == 0) {
            $condition .= ' AND lead_owner_id= "' . Yii::app()->user->id . '"';
        }
        if ($filter_start_date != '') {

            $filter_start_date = str_replace('/', '-', $filter_start_date);

            $filter_start_date = date('Y-m-d', strtotime($filter_start_date));

            $condition .= ' AND job_date >="' . $filter_start_date . '"';
        }
        if ($filter_end_date != '') {

            $filter_end_date = str_replace('/', '-', $filter_end_date);

            $filter_end_date = date('Y-m-d', strtotime($filter_end_date));

            $condition .= ' AND job_date <="' . $filter_end_date . '"';
        }
        if ($filter_job_order_priority != "") {
            $condition .= " AND job_priority='{$filter_job_order_priority}'";
        }
        if ($filter_job_no != "") {
            $condition .= ' AND job_order_id =' . $filter_job_no;
        }
        if ($filter_customer != "") {
            //$condition .= ' AND customer_name =' . $filter_customer;
            $condition .= " AND customer_name = '{$filter_customer}' ";
        }

        if ($filter_agent != "") {
            $condition .= " AND agent = '{$filter_agent}' ";
        }
        /* if ($filter_job_order_awb_no != "") {

          $condition .= " AND awb_no = '{$filter_job_order_awb_no}' ";
          }
          if ($filter_job_order_last_updated_status != "") {

          $condition .= " current_status = '{$filter_job_order_last_updated_status}' ";
          } */


//print_r($condition);

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.joborder_list', array('condition' => $condition), true));

        $mpdf->Output("joborderlist" . date('dmYhis') . ".pdf", 'I');
    }

    /* public function actionPrintLeadExcel() {

      $enq_from_date = Yii::app()->request->getParam('enq_from_date');

      $enq_to_date = Yii::app()->request->getParam('enq_to_date');

      $closing_from_date = Yii::app()->request->getParam('closing_from_date');

      $closing_to_date = Yii::app()->request->getParam('closing_to_date');

      $customer_id = Yii::app()->request->getParam('customer_id');

      $status = Yii::app()->request->getParam('status');



      $file = fopen("uploads/csvs/test.csv", "w");

      $criteria = new CDbCriteria;



      if (!empty($enq_from_date)) {

      $enq_from_date = str_replace('/', '-', $enq_from_date);

      $enq_from_date = date('Y-m-d', strtotime($enq_from_date));

      $criteria->addCondition('t.enq_date>="' . $enq_from_date . '"', 'AND');
      }

      if (!empty($enq_to_date)) {

      $enq_to_date = str_replace('/', '-', $enq_to_date);

      $enq_to_date = date('Y-m-d', strtotime($enq_to_date));

      $criteria->addCondition('t.enq_date<="' . $enq_to_date . '"', 'AND');
      }

      if (!empty($closing_from_date)) {

      $closing_from_date = str_replace('/', '-', $closing_from_date);

      $closing_from_date = date('Y-m-d', strtotime($closing_from_date));

      $criteria->addCondition('t.closing_date>="' . $closing_from_date . '"', 'AND');
      }

      if (!empty($closing_to_date)) {

      $closing_to_date = str_replace('/', '-', $closing_to_date);

      $closing_to_date = date('Y-m-d', strtotime($closing_to_date));

      $criteria->addCondition('t.closing_date<="' . $closing_to_date . '"', 'AND');
      }

      if (!empty($customer_id))
      $criteria->addCondition('t.customer_id="' . $customer_id . '"', 'AND');

      if (!empty($status))
      $criteria->addCondition('t.status="' . $status . '"', 'AND');



      $lead = Lead::model()->findAll($criteria);

      //          echo '<pre>'; print_r($criteria);

      $j = 0;



      $list[$j++] = 'No,Enquiry,Customer Name,Enquiry Date,Closing Date,Contact Name,Mobile,Email,Status';



      foreach ($lead as $i => $row) {

      if ($row->source_type_id == 1)
      $source = "Web";

      else if ($row->source_type_id == 2)
      $source = "Facebook";

      else if ($row->source_type_id == 3)
      $source = "Email";

      else if ($row->source_type_id == 4)
      $source = "Referral From Mouth";



      $list[$j++] = ($i + 1) . ',' . $row->title . ',' . $row->customer->customer_name . ',' . date_format(date_create($row->enq_date), 'd/m/Y') . ',' . date_format(date_create($row->closing_date), 'd/m/Y') . ',' . $row->file->leadowner->first_name . " " . $row->file->leadowner->last_name . ',' . $row->lead_reason . ',' . $row->salesgroup->group_name . ',' . $source . ',' . $row->lead_currency->currency_code . ',' . $row->amount . ',' . $row->probability->probability . ',' . $row->customercontact->person_name . ',' . $row->mobile1 . ',' . $row->email1;
      }

      $j++;

      foreach ($list as $line) {

      fputcsv($file, explode(',', $line));
      }

      fclose($file);

      $filename = 'uploads/csvs/test.csv';

      //$filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

      $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';

      header('Content-Type: application/csv');

      header("Content-disposition: attachment; filename=\"nittygritty_leadlist.csv\"");

      readfile($filename);

      Yii::app()->end();

      return;
      } */

    public function actionPrintCustomerReport() {



        $model = new Customer();



        $arr_customer_details['customer_name'] = $_POST['customer_name'];

        $arr_customer_details['country'] = $_POST['country'];

        $arr_customer_details['industry'] = $_POST['industry'];

        $arr_customer_details['create_from_date'] = $_POST['create_from_date'];

        $arr_customer_details['create_to_date'] = $_POST['create_to_date'];

        $arr_customer_details['update_from_date'] = $_POST['update_from_date'];

        $arr_customer_details['update_to_date'] = $_POST['update_to_date'];

        $arr_customer_details['customer_phoneno'] = $_POST['customer_phoneno'];

        $arr_customer_details['customer_email'] = $_POST['customer_email'];
        $arr_customer_details['leadowner_id'] = $_POST['leadowner_id'];




        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_customer_list', array('model' => $model, 'customer_details' => $arr_customer_details, 'title' => $title, 'user' => $user), false, true);
    }

    public function actionPrintCustomerContactReport() {



        $model = new CustomerContact();



        $arr_customer_details['customer_name'] = $_POST['customer_name'];

        $arr_customer_details['country'] = $_POST['country'];

        $arr_customer_details['industry'] = $_POST['industry'];

        $arr_customer_details['create_from_date'] = $_POST['create_from_date'];

        $arr_customer_details['create_to_date'] = $_POST['create_to_date'];

        $arr_customer_details['update_from_date'] = $_POST['update_from_date'];

        $arr_customer_details['update_to_date'] = $_POST['update_to_date'];

        $arr_customer_details['customer_phoneno'] = $_POST['customer_phoneno'];

        $arr_customer_details['customer_email'] = $_POST['customer_email'];
        $arr_customer_details['lead_owner'] = $_POST['leadowner_id'];


//        $customer_country = $_POST['customer_country']; ,'customer_name'=>$customer_name,'customer_country'=>$customer_country
        // print_r($arr_customer_details);

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_customercontact_list', array('model' => $model, 'customer_details' => $arr_customer_details, 'title' => $title), false, true);
    }

    public function actionPrintCustomerDocumentReport() {



        $model = new CustomerDocs();



        $arr_customer_details['customer_name'] = $_POST['customer_name'];

        $arr_customer_details['document_type'] = $_POST['document_type'];

        $arr_customer_details['document_no'] = $_POST['document_no'];

        $arr_customer_details['create_from_date'] = $_POST['create_from_date'];

        $arr_customer_details['create_to_date'] = $_POST['create_to_date'];


//        $customer_country = $_POST['customer_country']; ,'customer_name'=>$customer_name,'customer_country'=>$customer_country
        // print_r($arr_customer_details);

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_customerdocument_list', array('model' => $model, 'customer_details' => $arr_customer_details, 'title' => $title), false, true);
    }

    public function actionPrintEnquiryReport() {



        $model = new PurchasingEnquiry();



        $enquiry_start_date = $_POST['enquiry_start_date'];



        $enquiry_end_date = $_POST['enquiry_end_date'];



        $enquiry_status = $_POST['enquiry_status'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_enquiry_list', array('model' => $model, 'enquiry_start_date' => $enquiry_start_date, 'enquiry_end_date' => $enquiry_end_date,
            'enquiry_status' => $enquiry_status, 'title' => $title), false, true);
    }

    public function actionPrintEnquiryReportPDF() {



        $model = new Enquiry();



        $enquiry_start_date = Yii::app()->request->getParam('enquiry_start_date');



        $enquiry_end_date = Yii::app()->request->getParam('enquiry_end_date');



        $enquiry_status = Yii::app()->request->getParam('enquiry_status');



        $enquiry_id = Yii::app()->request->getParam('enquiry_id');



        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');



        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');



        $mpdf->WriteHTML($stylesheet, 1);



        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.enquiry_list', array('model' => $model, 'enquiry_id' => $enquiry_id, 'enquiry_start_date' => $enquiry_start_date, 'enquiry_end_date' => $enquiry_end_date, 'enquiry_status' => $enquiry_status, 'title' => $title), true));



        $mpdf->Output("EnquiryReport.pdf", 'I');
    }

    public function actionPrintEnquiryExcel() {

        $start_date = Yii::app()->request->getParam('start_date');

        $end_date = Yii::app()->request->getParam('end_date');

        $status = Yii::app()->request->getParam('status');

        $file = fopen("uploads/csvs/test.csv", "w");

        $criteria = new CDbCriteria;



        if (!empty($start_date))
            $criteria->addCondition('t.enquiry_date>="' . $start_date . '"', 'AND');



        if (!empty($end_date))
            $criteria->addCondition('t.closing_date<="' . $end_date . '"', 'AND');



        $enquiry = Enquiry::model()->findAll($criteria);

        $j = 0;

        $list[$j++] = 'No,Enquiry,Customer Name,Contact Name,Mobile,Email,Enquiry Date,Closing Date';



        foreach ($enquiry as $i => $row) {

            $list[$j++] = ($i + 1) . ',' . $row->file_title . ',' . $row->customer->customer_name . ',' . $row->contact->person_name . ',' . $row->mobile_no . ',' . $row->email_id . ',' . date_format(date_create($row->enquiry_date), 'd/m/Y') . ',' . date_format(date_create($row->closing_date), 'd/m/Y');
        }

        $j++;

        foreach ($list as $line) {

            fputcsv($file, explode(',', $line));
        }

        fclose($file);

        $filename = 'uploads/csvs/test.csv';

        //$filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';

        header('Content-Type: application/csv');

        header("Content-disposition: attachment; filename=\"enquiry.csv\"");

        readfile($filename);

        Yii::app()->end();

        return;
    }

    public function actionPrintexcelLeadList() {

        $enq_from_date = Yii::app()->request->getParam('enq_from_date');

        $enq_to_date = Yii::app()->request->getParam('enq_to_date');

        $closing_from_date = Yii::app()->request->getParam('closing_from_date');

        $closing_to_date = Yii::app()->request->getParam('closing_to_date');

        $customer_id = Yii::app()->request->getParam('customer_id');

        $status = Yii::app()->request->getParam('status');

        $lead_owner_id = Yii::app()->request->getParam('lead_owner_id');

        $sales_group_id = Yii::app()->request->getParam('sales_group_id');

        $lead_type = Yii::app()->request->getParam('lead_type');

        $file = fopen("uploads/csvs/test.csv", "w");





        $condition = '1=1';

        ;

        if ($enq_from_date != '') {

            $enq_from_date = str_replace('/', '-', $enq_from_date);

            $enq_from_date = date('Y-m-d', strtotime($enq_from_date));

            $condition .= ' AND t.enq_date >="' . $enq_from_date . '"';
        }

        if ($enq_to_date != '') {

            $enq_to_date = str_replace('/', '-', $enq_to_date);

            $enq_to_date = date('Y-m-d', strtotime($enq_to_date));

            $condition .= ' AND t.enq_date <="' . $enq_to_date . '"';
        }

        if ($closing_from_date != '') {

            $closing_from_date = str_replace('/', '-', $closing_from_date);

            $closing_from_date = date('Y-m-d', strtotime($closing_from_date));

            $condition .= ' AND t.closing_date >="' . $closing_from_date . '"';
        }

        if ($closing_to_date != '') {

            $closing_to_date = str_replace('/', '-', $closing_to_date);

            $closing_to_date = date('Y-m-d', strtotime($closing_to_date));

            $condition .= ' AND t.closing_date <="' . $closing_to_date . '"';
        }

        if ($customer_id != '') {

            $condition .= ' AND t.customer_id ="' . $customer_id . '"';
        }

        if ($sales_group_id != '') {

            $condition .= ' AND t.sales_group_id ="' . $sales_group_id . '"';
        }



        if ($lead_owner_id != '') {

            $condition .= ' AND t.lead_owner_id ="' . $lead_owner_id . '"';
        }

        if ($status != '') {

            $condition .= ' AND t.status ="' . $status . '"';
        }
        if ($lead_type != '') {
            $condition .= ' AND t.lead_type ="' . $lead_type . '"';
        }
        $total = 0;

        $enquiry = Lead::model()->with('leadowner')->findAll(array('condition' => $condition));

        $j = 0;

        $list[$j++] = 'No,Lead No,File No,Contact Name,Account Manager,Enquiry Date,Closing Date,Sales Group,Currency,Value,Value(BC)';



        foreach ($enquiry as $i => $row) {

            $model_currency = MasCurrency::model()->findByPk($row->currency);

            $total_bc = $row->value * $model_currency->exchange_rate;

            $list[$j++] = ($i + 1) . ',' . $row->id . ',' . $row->file_id . ',' . $row->customer->customer_name . ',' . $row->leadowner->first_name . " " . $row->leadowner->last_name . ',' . date("d/m/Y", strtotime($row->enq_date)) . ',' . date("d/m/Y", strtotime($row->closing_date)) .
                    ',' . $row->salesgroup->group_name . ',' . $row->currencyname->currency_code . ',' . $row->value . ',' . $total_bc;
        }

        $j++;



        foreach ($list as $line) {

            fputcsv($file, explode(',', $line));
        }

        fclose($file);

        $filename = 'uploads/csvs/test.csv'; //PrintexcelLeadList

        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';

        header('Content-Type: application/csv');

        header("Content-disposition: attachment; filename=\"lead_list.csv\"");

        readfile($filename);

        Yii::app()->end();

        return;
    }

    public function actionPrintEnquiryExcelId() {



        $enquiry_id = Yii::app()->request->getParam('enquiry_id');

        $start_date = Yii::app()->request->getParam('start_date');

        $end_date = Yii::app()->request->getParam('end_date');

        $status = Yii::app()->request->getParam('status');

        $file = fopen("uploads/csvs/test.csv", "w");



        $criteria = new CDbCriteria;



        if (!empty($enquiry_id))
            $criteria->addCondition('t.id=' . $enquiry_id, 'AND');



        if (!empty($start_date))
            $criteria->addCondition('t.enquiry_date<=' . $start_date, 'AND');



        if (!empty($end_date))
            $criteria->addCondition('t.closing_date>=' . $end_date, 'AND');



        $enquiry = Enquiry::model()->findAll($criteria);

        $j = 0;

        $list[$j++] = 'No,Enquiry,Customer Name,Contact Name,Mobile,Email,Enquiry Date,Closing Date';



        foreach ($enquiry as $i => $row) {

            $list[$j++] = ($i + 1) . ',' . $row->file_title . ',' . $row->customer->customer_name . ',' . $row->contact->person_name . ',' . $row->mobile_no . ',' . $row->email_id . ',' . date_format(date_create($row->enquiry_date), 'd/m/Y') . ',' . date_format(date_create($row->closing_date), 'd/m/Y');
        }

        $j++;



        foreach ($list as $line) {

            fputcsv($file, explode(',', $line));
        }

        fclose($file);

        $filename = 'uploads/csvs/test.csv';

        //$filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';

        header('Content-Type: application/csv');

        header("Content-disposition: attachment; filename=\"customer_enquiry.csv\"");

        readfile($filename);

        Yii::app()->end();

        return;
    }

    public function actionPrintCustomerContactReportPDF() {

        $model = new CustomerContact();





        $arr_customer_details['customer_name'] = $_GET['customer_details']['customer_name'];

        $arr_customer_details['country'] = $_GET['customer_details']['country'];

        $arr_customer_details['industry'] = $_GET['customer_details']['industry'];

        $arr_customer_details['create_from_date'] = $_GET['customer_details']['create_from_date'];

        $arr_customer_details['create_to_date'] = $_GET['customer_details']['create_to_date'];

        $arr_customer_details['update_from_date'] = $_GET['customer_details']['update_from_date'];

        $arr_customer_details['update_to_date'] = $_GET['customer_details']['update_to_date'];

        $arr_customer_details['customer_phoneno'] = $_GET['customer_details']['customer_phoneno'];

        $arr_customer_details['customer_email'] = $_GET['customer_details']['customer_email'];

        $arr_customer_details['lead_owner'] = $_GET['customer_details']['lead_owner'];


        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.customercontact_list', array('model' => $model, 'customer_details' => $arr_customer_details, 'title' => $title), true));

        $mpdf->Output("CustomerContactReport.pdf", 'I');
    }

    public function actionPrintCustomerDocumentReportPDF() {

        $model = new CustomerDocs();

        $arr_customer_details['customer_name'] = $_GET['customer_details']['customer_name'];

        $arr_customer_details['document_type'] = $_GET['customer_details']['document_type'];

        $arr_customer_details['document_no'] = $_GET['customer_details']['document_no'];

        $arr_customer_details['create_from_date'] = $_GET['customer_details']['create_from_date'];

        $arr_customer_details['create_to_date'] = $_GET['customer_details']['create_to_date'];


        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.customerdocument_list', array('model' => $model, 'customer_details' => $arr_customer_details, 'title' => $title), true));

        $mpdf->Output("CustomerContactReport.pdf", 'I');
    }

    public function actionPrintCustomerReportPDF() {

        $model = new Customer();

//        $customer_name = Yii::app()->request->getParam('customer_name');
//        $country = Yii::app()->request->getParam('country');
        //print_r($_GET['customer_details']);
        //die();



        $arr_customer_details['customer_name'] = $_GET['customer_details']['customer_name'];

        $arr_customer_details['country'] = $_GET['customer_details']['country'];

        $arr_customer_details['industry'] = $_GET['customer_details']['industry'];

        $arr_customer_details['create_from_date'] = $_GET['customer_details']['create_from_date'];

        $arr_customer_details['create_to_date'] = $_GET['customer_details']['create_to_date'];

        $arr_customer_details['update_from_date'] = $_GET['customer_details']['update_from_date'];

        $arr_customer_details['update_to_date'] = $_GET['customer_details']['update_to_date'];

        $arr_customer_details['customer_phoneno'] = $_GET['customer_details']['customer_phoneno'];

        $arr_customer_details['customer_email'] = $_GET['customer_details']['customer_email'];

        $arr_customer_details['lead_owner'] = $_GET['customer_details']['lead_owner'];


        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.customer_list', array('model' => $model, 'customer_details' => $arr_customer_details, 'title' => $title), true));

        $mpdf->Output("CustomerReport.pdf", 'I');
    }

    public function actionPrintCustomerExcel() {

        $customer_name = Yii::app()->request->getParam('customer_name');
        $create_from_date = Yii::app()->request->getParam('create_from_date');
        $create_to_date = Yii::app()->request->getParam('create_to_date');
        $industry = Yii::app()->request->getParam('industry');
        $country = Yii::app()->request->getParam('country');
        $leadowner_id = Yii::app()->request->getParam('leadowner_id');
        $file = fopen("uploads/csvs/test.csv", "w");
        $criteria = new CDbCriteria;
        if (!empty($create_from_date)) {
            $create_from_date = str_replace('/', '-', $create_from_date);
            $create_from_date = date('Y-m-d', strtotime($create_from_date));
            $criteria->addCondition('t.created_date_time>="' . $create_from_date . '"', 'AND');
        }
        if (!empty($create_to_date)) {
            $create_to_date = str_replace('/', '-', $create_to_date);
            $create_to_date = date('Y-m-d 24:00:00', strtotime($create_to_date));
            $criteria->addCondition('t.created_date_time<="' . $create_to_date . '"', 'AND');
        }
        if (!empty($customer_name))
            $criteria->addCondition('t.customer_name like "%' . $customer_name . '%"', 'AND');
        if (!empty($industry))
            $criteria->addCondition('t.customer_industry  ="' . $industry . '"', 'AND');
        if (!empty($country))
            $criteria->addCondition('t.customer_country ="' . $country . '"', 'AND');
        if (!empty($leadowner_id))
            $criteria->addCondition('t.lead_owner_id ="' . $leadowner_id . '"', 'AND');
        if (User::isSalesman() == 'Y') {
            $condition .= ' AND t.lead_owner_id= "' . Yii::app()->user->id . '"';
        }
        //print_r($condition)
//print_r($criteria);
        $customer = Customer::model()->with('country', 'currency_detail', 'industry_details')->findAll($criteria);
        $j = 0;

        $list[$j++] = 'No/Customer Name/Credit Limit/Address/City/Postal Code/State/Country/Currency/Industry/LeadOwner/Created Date Time/Last Updated Date Time';
        foreach ($customer as $i => $row) {
            $list[$j++] = ($i + 1) . '/' . $row->customer_name . '/' . $row->customer_credit_limit . '/' . $row->customer_address . '/' . $row->customer_city . '/' . $row->customer_postal_code . '/' . $row->customer_state . '/' . $row->country->country_name . '/' . $row->currency_detail->currency . '/' . $row->industry_details->name . '/' . $row->user->fullname . '/' . date("d-m-Y h:i:s", strtotime($row->created_date_time)) . '/' . date("d-m-Y h:i:s", strtotime($row->updated_date_time));
        }
        $j++;
        foreach ($list as $line) {
            fputcsv($file, explode('/', $line));
        }
        fclose($file);
        $filename = 'uploads/csvs/test.csv';
        //$filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"customer.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    public function actionPrintCustomerContactExcel() {

        $customer_name = Yii::app()->request->getParam('customer_name');
        $industry = Yii::app()->request->getParam('industry');
        $contact_no = Yii::app()->request->getParam('contact_no');
        $country = Yii::app()->request->getParam('country');
        $leadowner_id = Yii::app()->request->getParam('leadowner_id');
        $created_from_date = Yii::app()->request->getParam('created_from_date');
        $created_to_date = Yii::app()->request->getParam('created_to_date');
        $leadowner_id = Yii::app()->request->getParam('leadowner_id');


        // print_r($customer_name);die();



        $file = fopen("uploads/csvs/test.csv", "w");

        $criteria = new CDbCriteria;

        $condition = '1=1';

        if (!empty($created_from_date)) {

            $created_from_date = str_replace('/', '-', $created_from_date);

            $created_from_date = date('Y-m-d', strtotime($created_from_date));

            $condition .= ' AND t.created_date_time >="' . $created_from_date . '%"';
        }

        if (!empty($created_to_date)) {
            $created_to_date = str_replace('/', '-', $created_to_date);

            $created_to_date = date('Y-m-d 24:00:00', strtotime($created_to_date));

            $condition .= ' AND t.created_date_time >="' . $created_from_date . '%"';
        }

        if (!empty($customer_name)) {

            $condition .= ' AND customer.customer_name like "%' . $customer_name . '%"';
        }
        if (!empty($leadowner_id)) {

            $condition .= ' AND customer.lead_owner_id like "%' . $leadowner_id . '%"';
        }

        if (!empty($industry)) {

            $condition .= ' AND customer.customer_industry like "%' . $industry . '%"';
        }
        if (!empty($contact_no)) {

            $condition .= ' AND customer.customer_phone_no like "%' . $contact_no . '%"';
        }

        if (!empty($country)) {

            $condition .= ' AND customer.customer_country ="' . $country . '"';
        }
        if (!empty($leadowner_id))
            $condition .= ' AND customer.lead_owner_id ="' . $leadowner_id . '"';
        //print_r($condition);

        $model_customer_contact = CustomerContact::model()->with('customer')->findAll(array('condition' => $condition, 'order' => 'customer_name asc,person_name asc'));

        $j = 0;

        $list[$j++] = 'No ! Customer ! Customer Phone Number ! Customer Email! Customer Email 2! Contact Name ! Designation ! Contact Phone Number ! Contact Email ! Country ! LeadOwner';



        foreach ($model_customer_contact as $i => $row) {



            $list[$j++] = ($i + 1) . '!' . $row->customer->customer_name . '!' . $row->customer->customer_phone_no . '!' . $row->customer->customer_email_id . '!' . $row->customer->nick_name . '!' . $row->person_name . '!' . $row->designation . '!' . $row->contact_mobile_no . '!' . $row->contact_email_id . '!' . $row->customer->country->country_name . '!' . $row->customer->user->fullname;
        }





        $j++;

//die();

        foreach ($list as $line) {

            fputcsv($file, explode('!', $line));
        }



        fclose($file);



        $filename = 'uploads/csvs/test.csv';



        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';



        header('Content-Type: application/csv');



        header("Content-disposition: attachment; filename=\"customercontactlist.csv\"");



        readfile($filename);



        Yii::app()->end();



        return;
    }

    public function actionPrintCustomerDocumentExcel() {



        $customer_name = Yii::app()->request->getParam('customer_name');
        $document_type = Yii::app()->request->getParam('document_type');
        $document_no = Yii::app()->request->getParam('document_no');
        $created_from_date = Yii::app()->request->getParam('created_from_date');
        $created_to_date = Yii::app()->request->getParam('created_to_date');
        $file = fopen("uploads/csvs/test.csv", "w");

        $criteria = new CDbCriteria;

        $condition = '1=1';

        if (!empty($customer_name)) {
            $condition .= ' AND  cus_details.customer_name like "%' . $customer_name . '%"';
        }
        if (!empty($document_type)) {
            $condition .= ' AND t.document_type ="' . $country . '"';
        }
        if (!empty($document_no)) {
            $condition .= ' AND t.document_no ="' . $leadowner_id . '"';
        }
        $model_customer_contact = CustomerDocs::model()->with('cus_details')->findAll(array('condition' => $condition, 'order' => 'customer_name asc'));

        $j = 0;

        $list[$j++] = 'No ! Customer ! Document Type ! Document No! Expiry Date';



        foreach ($model_customer_contact as $i => $row) {



            $list[$j++] = ($i + 1) . '!' . $row->cus_details->customer_name . '!' . $row->doctype->document_type . '!' . $row->document_no . '!' . date('d-m-Y', strtotime($row->to_date));
        }





        $j++;

//die();

        foreach ($list as $line) {

            fputcsv($file, explode('!', $line));
        }



        fclose($file);



        $filename = 'uploads/csvs/test.csv';



        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';



        header('Content-Type: application/csv');



        header("Content-disposition: attachment; filename=\"customercontactlist.csv\"");



        readfile($filename);



        Yii::app()->end();



        return;
    }

    public function actionPrintVendorContactListExcel() {

        $vendor_name = Yii::app()->request->getParam('vendor_name');

        $vendor_phoneno = Yii::app()->request->getParam('vendor_phoneno');

        $vendor_email = Yii::app()->request->getParam('vendor_email');





        $file = fopen("uploads/csvs/test.csv", "w");

        $criteria = new CDbCriteria;

        $condition = '1=1';

        if ($vendor_name != '') {

            $condition .= " AND vendor.vendor_name Like '%" . $vendor_name . "%'";
        }

        if ($vendor_phoneno != '') {

            $condition .= " AND contact_phone_no Like '%" . $vendor_phoneno . "%'";
        }

        if ($vendor_email != '') {

            $condition .= " AND contact_email_id Like '%" . $vendor_email . "%'";
        }

        $model_vendor_contact = VendorContact::model()->with('vendor')->findAll(array('condition' => $condition, 'order' => 'vendor_name asc,person_name asc'));

        $j = 0;

        $list[$j++] = 'No ! Supplier ! Contact ! E-mail  ! Designation ! Department ! Phone Number';



        foreach ($model_vendor_contact as $i => $row) {

            $list[$j++] = ($i + 1) . '!' . $row->vendor->vendor_name .
                    '!' . $row->person_name . '!' .
                    $row->contact_email_id . '!' . $row->designation .
                    '!' . $row->department . '!' . $row->contact_phone_no;
        }



        $j++;



        foreach ($list as $line) {

            fputcsv($file, explode('!', $line));
        }



        fclose($file);



        $filename = 'uploads/csvs/test.csv';



        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';



        header('Content-Type: application/csv');



        header("Content-disposition: attachment; filename=\"vendorcontactlist.csv\"");



        readfile($filename);



        Yii::app()->end();



        return;
    }

    public function actionPrintRegistrationInvoiceRequest() {





        $model = new RegistrationInvoice();



        $invoice_no = $_POST['invoice_no'];

        $invoice_start_date = $_POST['invoice_start_date'];

        $invoice_end_date = $_POST['invoice_end_date'];

        $customer_id = $_POST['customer_id'];

        $payment_terms = $_POST['payment_terms'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_registration_invoice_list', array(
            'model' => $model,
            'invoice_no' => $invoice_no,
            'invoice_start_date' => $invoice_start_date,
            'invoice_end_date' => $invoice_end_date,
            'customer_id' => $customer_id,
            'payment_terms' => $payment_terms,
            'title' => $title), false, true);
    }

    public function actionPrinRegistrationInvoiceReportPDF() {



        $model = new RegistrationInvoice();



        $invoice_no = Yii::app()->request->getParam('invoice_no');

        $invoice_start_date = Yii::app()->request->getParam('invoice_start_date');

        $invoice_end_date = Yii::app()->request->getParam('invoice_end_date');

        $customer_id = Yii::app()->request->getParam('customer_id');

        $payment_terms = Yii::app()->request->getParam('payment_terms');





        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');



        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');



        $mpdf->WriteHTML($stylesheet, 1);



        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.material_registration_invoice_list', array('model' => $model,
                    'invoice_no' => $invoice_no,
                    'invoice_start_date' => $invoice_start_date,
                    'invoice_end_date' => $invoice_end_date,
                    'customer_id' => $customer_id,
                    'payment_terms' => $payment_terms,
                    'title' => $title), true));



        $mpdf->Output("RegistrationInvoiceReport.pdf", 'I');
    }

    public function actionPrintMaterialRegistrationInvoiceExcel() {

        $customer_id = Yii::app()->request->getParam('customer_id');

        $invoice_start_date = Yii::app()->request->getParam('invoice_start_date');

        $invoice_end_date = Yii::app()->request->getParam('invoice_end_date');

        $invoice_no = Yii::app()->request->getParam('invoice_no');

        $payment_terms = Yii::app()->request->getParam('payment_terms');



        $file = fopen("uploads/csvs/test.csv", "w");



        $condition = '1=1';

        if ($customer_id != '') {

            $condition .= ' AND t.customer_id ="' . $customer_id . '"';
        }

        if ($invoice_start_date != '') {

            $invoice_start_date = str_replace('/', '-', $invoice_start_date);

            $invoice_start_date = date('Y-m-d', strtotime($invoice_start_date));

            $condition .= ' AND t.invoice_date >="' . $invoice_start_date . '"';
        }

        if ($invoice_end_date != '') {

            $invoice_end_date = str_replace('/', '-', $invoice_end_date);

            $invoice_end_date = date('Y-m-d', strtotime($invoice_end_date));

            $condition .= ' AND t.invoice_date <="' . $invoice_end_date . '"';
        }

        if ($invoice_no != '') {

            $condition .= ' AND t.file_id ="' . $invoice_no . '"';
        }

        if ($payment_terms != '') {

            $condition .= ' AND t.payment_terms ="' . $payment_terms . '"';
        }





        $model_registration_invoice = RegistrationInvoice::model()->findAll(array('condition' => $condition));



        $j = 0;

        $list[$j++] = 'No,File No,Customer Name,Invoice Date,Payment Term,Grand Total';



        foreach ($model_registration_invoice as $i => $row) {

            $list[$j++] = ($i + 1) . ',' . $row->file_id . ',' . $row->customers->customer_name . ',' . $row->invoice_date . ',' . $row->paymentname->payment_term . ',' . $row->grand_total;
        }

        $j++;

        foreach ($list as $line) {

            fputcsv($file, explode(',', $line));
        }

        fclose($file);

        $filename = 'uploads/csvs/test.csv';

        //$filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';

        header('Content-Type: application/csv');

        header("Content-disposition: attachment; filename=\"material_Registration_Invoice.csv\"");

        readfile($filename);

        Yii::app()->end();

        return;
    }

    public function actionPrintGLReport() {

        $account_no = $_REQUEST['ledger_id'];

        $company_id = $_REQUEST['subledger_id'];

        $rp_from_date = $_REQUEST['from_date'];

        $rp_to_date = $_REQUEST['to_date'];

        $rp_from_date = str_replace('/', '-', $rp_from_date);

        $rp_from_date = date("Y-m-d", strtotime($rp_from_date));

        $rp_to_date = str_replace('/', '-', $rp_to_date);

        $rp_to_date = date("Y-m-d", strtotime($rp_to_date));

        $item_type = $_REQUEST['item_type'];

        $item_id = $_REQUEST['item_id'];

        ini_set("memory_limit", "-1");

//        ini_set('max_execution_time', 1000);





        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $mpdf->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);

        $mpdf->showWatermarkImage = true;

        $mpdf->watermarkImageAlpha = 0.09;

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_list.css');



        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial("application.views.front.pdf.generalledger", array('account_no' => $account_no, 'company_id' => $company_id, 'date_from' => $rp_from_date, 'date_to' => $rp_to_date, 'item_id' => $item_id, 'item_type' => $item_type), true));

        $mpdf->Output('GL Report.pdf', 'I');
    }

    public function actionPrintGLStatementReport() {

        $date = str_replace('/', '-', $_REQUEST['statement_start_date']);

        $searchstartdate = date("Y-m-d", strtotime($date));

        $searchstartdate = '2015-01-01';

        $date1 = str_replace('/', '-', $_REQUEST['to_date']);

        $searchenddate = date("Y-m-d", strtotime($date1));

        $company_id = $_REQUEST['subledger_id'];

        $account_id = $_REQUEST['ledger_id'];

        if ($searchstartdate == null) {

            $searchstartdate = date('Y') . '-01-01';
        }

        if ($searchenddate == null) {

            $searchenddate = date('Y') . '-12-31';
        }

        if (!empty($company_id) && !empty($searchstartdate) && !empty($searchenddate) && !empty($account_id)) {

            $rp_to_date = $_POST['rp_to_date'];

            ini_set("memory_limit", "-1");

            $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

            $mpdf->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);

            $mpdf->showWatermarkImage = true;

            $mpdf->watermarkImageAlpha = 0.09;

            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');

            $mpdf->WriteHTML($stylesheet, 1);



            $mpdf->WriteHTML($this->renderPartial("application.views.front.pdf.statement_of_account", array('subledger' => $company_id, 'date_to' => $searchenddate, 'date_from' => $searchstartdate, 'account' => $account_id), true));

            $mpdf->Output('Statement.pdf', 'I');
        } else {

            echo "Please Select Account";
        }
    }

    public function actionPrintGLSummaryReport() {

        $account_no = $_REQUEST['ledger_id'];

        if ($account_no == 'value') {

            $account_no = "";
        }

        if ($account_no != '') {

            $rp_to_date = $_REQUEST['to_date'];

            $rp_to_date = str_replace('/', '-', $rp_to_date);

            $rp_to_date = date("Y-m-d", strtotime($rp_to_date));

            ini_set("memory_limit", -1);

            ini_set('max_execution_time', 1000);

            $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

            $mpdf->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);

            $mpdf->showWatermarkImage = true;

            $mpdf->watermarkImageAlpha = 0.09;

            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');

            $mpdf->WriteHTML($stylesheet, 1);



            $mpdf->WriteHTML($this->renderPartial("application.views.front.pdf.generalledger_summary", array('account_no' => $account_no, 'date_to' => $rp_to_date), true));

            $mpdf->Output('GL Summary.pdf', 'I');
        } else {

            echo "Please Select Account";
        }
    }

    public function actionPrintAgeingReport() {

        $date1 = str_replace('/', '-', $_REQUEST['to_date']);

        $searchenddate = date("Y-m-d", strtotime($date1));

        $company_id = (int) $_REQUEST['subledger_id'];

        $account_id = $_REQUEST['ledger_id'];

        if ($searchenddate == null) {

            $searchenddate = date('Y-m-d');
        }

        if (!empty($searchenddate) && !empty($account_id)) {

            if (!empty($company_id)) {

                $opening_bal = FinOpeningBalance::model()->find(array('condition' => 'account_id=' . $company_id . ' AND mainacc=' . $account_id));

                $trs = array();

                $tds = array();

                $total_amt = 0;

                $total_pend = 0;

                $total_columns = 11;

                $pend1 = 0;

                $pend2 = 0;

                $pend3 = 0;

                $pend4 = 0;

                $pend5 = 0;

                $pend6 = 0;

                $pend7 = 0;

                $tot_pend = 0;

                $trs[] = '<tr>

                            <th width="15%" class="bgblack">Ledger Name</th>

                            <th width="10%"> 0-30 Days</th>

                            <th width="10%"> 31-60 Days</th>

                            <th width="10%"> 61-90 Days</th>

                            <th width="10%"> 91-120 Days</th>

                            <th width="10%"> 121-150 Days</th>

                            <th width="10%"> 151-180 Days</th>

                            <th width="10%"> >180 Days</th>

                            <th width="10%">Total</th>

                        </tr>';



                $no_days_30 = date('Y-m-d', strtotime($searchenddate . ' -30 day'));

                $no_days_60 = date('Y-m-d', strtotime($searchenddate . ' -60 day'));

                $no_days_90 = date('Y-m-d', strtotime($searchenddate . ' -90 day'));

                $no_days_120 = date('Y-m-d', strtotime($searchenddate . ' -120 day'));

                $no_days_150 = date('Y-m-d', strtotime($searchenddate . ' -150 day'));

                $no_days_180 = date('Y-m-d', strtotime($searchenddate . ' -180 day'));

                Yii::app()->db->createCommand("TRUNCATE TABLE ageing")->execute();

                $SQL11 = "INSERT INTO ageing (SELECT A.id,A.subledger,A.date,A.voucher_no,A.debit,A.credit,(A.debit-sum(B.debit_allocate_amount)) as db,(A.credit-sum(B.credit_allocate_amount)) as cr FROM `erp_fin_general_ledger` A left join erp_fin_voucher_allocation B ON A.id=B.invoice_id where A.account_id=$account_id AND A.isAllocated='Y' AND (A.date between '2014-01-01' AND '$searchenddate') AND (B.allocate_date between '2014-01-01' AND '$searchenddate') group by B.invoice_id) UNION (SELECT A.id,A.subledger,A.date,A.voucher_no,A.debit,A.credit,(A.debit) as db,(A.credit) as cr FROM `erp_fin_general_ledger` A left join erp_fin_voucher_allocation B ON A.id=B.invoice_id where A.account_id=$account_id AND A.isAllocated='Y' AND (A.date between '2014-01-01' AND '$searchenddate') AND (B.allocate_date NOT between '2014-01-01' AND '$searchenddate') group by A.id) UNION (SELECT id,subledger,date,voucher_no,debit,credit,debit as db,credit as cr from erp_fin_general_ledger  where account_id=$account_id AND allocation_amount =0 AND isAllocated='Y' AND (date between '2014-01-01' AND '$searchenddate')) order by date ASC";

                Yii::app()->db->createCommand($SQL11)->execute();

                Yii::app()->db->createCommand("CREATE OR REPLACE VIEW ss AS select * from ageing group by invoice_id order by db DESC,cr DESC")->execute();

                $SQL1 = "select subledger,sum(db)-sum(cr) as amt from ss where date >= '$no_days_30' AND subledger like '$company_id'";

                $arr_sum_amount1 = Yii::app()->db->createCommand($SQL1)->queryAll();

                $SQL2 = "select subledger,sum(db)-sum(cr) as amt from ss where date >= '$no_days_60' AND date < '$no_days_30' AND subledger=$company_id";

                $arr_sum_amount2 = Yii::app()->db->createCommand($SQL2)->queryAll();

                $SQL3 = "select subledger,sum(db)-sum(cr) as amt from ss where date >= '$no_days_90' AND date < '$no_days_60' AND subledger=$company_id";

                $arr_sum_amount3 = Yii::app()->db->createCommand($SQL3)->queryAll();

                $SQL4 = "select subledger,sum(db)-sum(cr) as amt from ss where date >= '$no_days_120' AND date < '$no_days_90' AND subledger=$company_id";

                $arr_sum_amount4 = Yii::app()->db->createCommand($SQL4)->queryAll();

                $SQL5 = "select subledger,sum(db)-sum(cr) as amt from ss where date >= '$no_days_150' AND date < '$no_days_120' AND subledger=$company_id";

                $arr_sum_amount5 = Yii::app()->db->createCommand($SQL5)->queryAll();

                $SQL6 = "select subledger,sum(db)-sum(cr) as amt from ss where date >= '$no_days_180' AND date < '$no_days_150' AND subledger=$company_id";

                $arr_sum_amount6 = Yii::app()->db->createCommand($SQL6)->queryAll();

                $SQL7 = "select subledger,sum(db)-sum(cr) as amt from ss where date < '$no_days_180' AND subledger=$company_id";

                $arr_sum_amount7 = Yii::app()->db->createCommand($SQL7)->queryAll();

                $total_inv_amnt = 0;

                $total_pend_amnt = 0;

                $tot = 0;

                $due1 = 0;

                $due2 = 0;

                $due3 = 0;

                $due4 = 0;

                $due5 = 0;

                $due6 = 0;

                $due7 = 0;

                foreach ($arr_sum_amount1 as $eachInvoice1) {

                    $due1 += $eachInvoice1['amt'];
                }

                foreach ($arr_sum_amount2 as $eachInvoice2) {

                    $due2 = $eachInvoice2['amt'];
                }

                foreach ($arr_sum_amount3 as $eachInvoice3) {

                    $due3 = $eachInvoice3['amt'];
                }

                foreach ($arr_sum_amount4 as $eachInvoice4) {

                    $due4 = $eachInvoice4['amt'];
                }

                foreach ($arr_sum_amount5 as $eachInvoice5) {

                    $due5 = $eachInvoice5['amt'];
                }

                foreach ($arr_sum_amount6 as $eachInvoice6) {

                    $due6 = $eachInvoice6['amt'];
                }

                foreach ($arr_sum_amount7 as $eachInvoice7) {

                    if ($opening_bal->type == 1) {

                        $amt7 = $opening_bal->statement_op + $eachInvoice7['amt'];

                        $due7 += $opening_bal->statement_op + $eachInvoice7['amt'];
                    } else if ($opening_bal->type == 2) {

                        $amt7 = $eachInvoice7['amt'] - $opening_bal->statement_op;

                        $due7 += $eachInvoice7['amt'] - $opening_bal->statement_op;
                    } else {

                        $amt7 = $eachInvoice7['amt'];

                        $due7 += $eachInvoice7['amt'];
                    }
                }

                $pend1 += $due1;

                $pend2 += $due2;

                $pend3 += $due3;

                $pend4 += $due4;

                $pend5 += $due5;

                $pend6 += $due6;

                $pend7 += $due7;

                $pnd = $due1 + $due2 + $due3 + $due4 + $due5 + $due6 + $due7;

                if ($pnd != 0) {

                    $company = Subledger::model()->findByPk($company_id);

                    $tds = '<td class="cell-left"><b>' . $company->description . '</b></td>';

                    if ($due1 < 0) {

                        $due1 = Yii::app()->numberFormatter->formatCurrency(abs($due1), "") . ' Cr';
                    } else {

                        $due1 = Yii::app()->numberFormatter->formatCurrency($due1, "") . ' Dr';
                    }

                    if ($due2 < 0) {

                        $due2 = Yii::app()->numberFormatter->formatCurrency(abs($due2), "") . ' Cr';
                    } else {

                        $due2 = Yii::app()->numberFormatter->formatCurrency($due2, "") . ' Dr';
                    }

                    if ($due3 < 0) {

                        $due3 = Yii::app()->numberFormatter->formatCurrency(abs($due3), "") . ' Cr';
                    } else {

                        $due3 = Yii::app()->numberFormatter->formatCurrency($due3, "") . ' Dr';
                    }

                    if ($due4 < 0) {

                        $due4 = Yii::app()->numberFormatter->formatCurrency(abs($due4), "") . ' Cr';
                    } else {

                        $due4 = Yii::app()->numberFormatter->formatCurrency($due4, "") . ' Dr';
                    }

                    if ($due5 < 0) {

                        $due5 = Yii::app()->numberFormatter->formatCurrency(abs($due5), "") . ' Cr';
                    } else {

                        $due5 = Yii::app()->numberFormatter->formatCurrency($due5, "") . ' Dr';
                    }

                    if ($due6 < 0) {

                        $due6 = Yii::app()->numberFormatter->formatCurrency(abs($due6), "") . ' Cr';
                    } else {

                        $due6 = Yii::app()->numberFormatter->formatCurrency($due6, "") . ' Dr';
                    }

                    if ($due7 < 0) {

                        $due7 = Yii::app()->numberFormatter->formatCurrency(abs($due7), "") . ' Cr';
                    } else {

                        $due7 = Yii::app()->numberFormatter->formatCurrency($due7, "") . ' Dr';
                    }

                    if ($pnd < 0) {

                        $pnd = Yii::app()->numberFormatter->formatCurrency(abs($pnd), "") . ' Cr';
                    } else {

                        $pnd = Yii::app()->numberFormatter->formatCurrency($pnd, "") . ' Dr';
                    }

                    $tds .= '<td class="cell-right">' . $due1 . '</td>';

                    $tds .= '<td class="cell-right">' . $due2 . '</td>';

                    $tds .= '<td class="cell-right">' . $due3 . '</td>';

                    $tds .= '<td class="cell-right">' . $due4 . '</td>';

                    $tds .= '<td class="cell-right">' . $due5 . '</td>';

                    $tds .= '<td class="cell-right">' . $due6 . '</td>';

                    $tds .= '<td class="cell-right">' . $due7 . '</td>';

                    $tds .= '<td class="cell-right litegray">' . $pnd . '</td>';

                    $trs[] = '<tr>' . $tds . '</tr>';

                    $total_amt += $total_inv_amnt;

                    $total_pend += $total_pend_amnt;

                    $tot_pend += $pnd;
                }



                $html_prepared = implode(' ', $trs);

                $html_prepared .= '<tr><td><b>Grand Total</b></td><td class="cell-right"><b>' . $due1 . '</b></td><td class="cell-right"><b>' . $due2 . '</b></td><td class="cell-right"><b>' . $due3 . '</b></td><td class="cell-right"><b>' . $due4 . '</b></td><td class="cell-right"><b>' . $due5 . '</b></td><td class="cell-right"><b>' . $due6 . '</b></td><td class="cell-right"><b>' . $due7 . '</b></td><td class="cell-right"><b>' . $pnd . '</b></td></tr>';

                $page_type = "L";

                $this->report('', 'ageing-list', 'pdf_for_single', $html_prepared, 'LEDGER AGEING REPORT', $page_type);
            } else {

                $SQL = "(SELECT sub.id,sub.description as description,sub.id as account_no FROM `erp_fin_general_ledger` as ledger left join erp_fin_subledger as sub on ledger.subledger=sub.id WHERE account_id=$account_id group by account_id,subledger order by sub.description) "
                        . " order by description";

//            echo $SQL;die;

                $company = Yii::app()->db->createCommand($SQL)->queryAll();





                $trs = array();

                $tds = array();

                $total_amt = 0;

                $total_pend = 0;

                $total_columns = 11;

                $pend1 = 0;

                $pend2 = 0;

                $pend3 = 0;

                $pend4 = 0;

                $pend5 = 0;

                $pend6 = 0;

                $pend7 = 0;

                $tot_pend = 0;

                $no_days_30 = date('Y-m-d', strtotime($searchenddate . ' -30 day'));

                $no_days_60 = date('Y-m-d', strtotime($no_days_30 . ' -30 day'));

                $no_days_90 = date('Y-m-d', strtotime($no_days_60 . ' -30 day'));

                $no_days_120 = date('Y-m-d', strtotime($no_days_90 . ' -30 day'));

                $no_days_150 = date('Y-m-d', strtotime($no_days_120 . ' -30 day'));

                $no_days_180 = date('Y-m-d', strtotime($no_days_150 . ' -30 day'));

                $trs[] = '<tr>

                            <th width="15%" class="bgblack" >Customer Name</th>

                            <th width="10%" class="cell-right bgblack"> 0-30 Days</th>

                            <th width="10%" class="cell-right bgblack"> 31-60 Days</th>

                            <th width="10%" class="cell-right bgblack"> 61-90 Days</th>

                            <th width="10%" class="cell-right bgblack"> 91-120 Days</th>

                            <th width="10%" class="cell-right bgblack"> >120 Days</th>

                            <th width="10%" class="cell-right bgblack">Total</th>

                        </tr>';



//$SQL10="DROP VIEW IF EXISTS q1, q2,q3,q4,q5,q6,q7";
//Yii::app()->db->createCommand($SQL10)->execute();

                Yii::app()->db->createCommand("TRUNCATE TABLE ageing")->execute();

//$SQL11="CREATE OR REPLACE VIEW q1 AS (SELECT A.subledger,A.date,A.voucher_no,A.debit,A.credit,(A.debit-sum(B.debit_allocate_amount)) as db,(A.credit-sum(B.credit_allocate_amount)) as cr FROM `crm_fin_general_ledger` A left join crm_fin_voucher_allocation B ON A.id=B.invoice_id where A.account_id=$account_id AND A.isAllocated='Y' AND (A.date between '2014-01-01' AND '$searchenddate') AND (B.allocate_date between '2014-01-01' AND '$searchenddate') group by B.invoice_id) UNION (SELECT A.subledger,A.date,A.voucher_no,A.debit,A.credit,(A.debit) as db,(A.credit) as cr FROM `crm_fin_general_ledger` A left join crm_fin_voucher_allocation B ON A.id=B.invoice_id where A.account_id=$account_id AND A.isAllocated='Y' AND (A.date between '2014-01-01' AND '$searchenddate') AND (B.allocate_date NOT between '2014-01-01' AND '$searchenddate') group by A.id) UNION (SELECT subledger,date,voucher_no,debit,credit,debit as db,credit as cr from crm_fin_general_ledger  where account_id=$account_id AND allocation_amount =0 AND isAllocated='Y' AND (date between '2014-01-01' AND '$searchenddate')) order by date ASC";

                $SQL11 = "INSERT INTO ageing (SELECT A.id,A.subledger,A.date,A.voucher_no,A.debit,A.credit,(A.debit-sum(B.debit_allocate_amount)) as db,(A.credit-sum(B.credit_allocate_amount)) as cr FROM `erp_fin_general_ledger` A left join erp_fin_voucher_allocation B ON A.id=B.invoice_id where A.account_id=$account_id AND A.isAllocated='Y' AND (A.date between '2014-01-01' AND '$searchenddate') AND (B.allocate_date between '2014-01-01' AND '$searchenddate') group by B.invoice_id) UNION (SELECT A.id,A.subledger,A.date,A.voucher_no,A.debit,A.credit,(A.debit) as db,(A.credit) as cr FROM `erp_fin_general_ledger` A left join erp_fin_voucher_allocation B ON A.id=B.invoice_id where A.account_id=$account_id AND A.isAllocated='Y' AND (A.date between '2014-01-01' AND '$searchenddate') AND (B.allocate_date NOT between '2014-01-01' AND '$searchenddate') group by A.id) UNION (SELECT id,subledger,date,voucher_no,debit,credit,debit as db,credit as cr from erp_fin_general_ledger  where account_id=$account_id AND allocation_amount =0 AND isAllocated='Y' AND (date between '2014-01-01' AND '$searchenddate')) order by date ASC";

//echo $SQL11;die;

                Yii::app()->db->createCommand($SQL11)->execute();

//$SQL100="select subledger,sum(db)-sum(cr) as amt from q1 group by subledger";
//$arr_sum_amount100  = Yii::app()->db->createCommand($SQL100)->queryAll();
//print_r($arr_sum_amount100);die;

                Yii::app()->db->createCommand("CREATE OR REPLACE VIEW ss AS select * from ageing group by invoice_id order by db DESC,cr DESC")->execute();

                $SQL1 = "select subledger,sum(db)-sum(cr) as amt from ss where date >= '$no_days_30' group by subledger";

                $arr_sum_amount1 = Yii::app()->db->createCommand($SQL1)->queryAll();

                $SQL2 = "select subledger,sum(db)-sum(cr) as amt from ss where date >= '$no_days_60' AND date < '$no_days_30' group by subledger";

                $arr_sum_amount2 = Yii::app()->db->createCommand($SQL2)->queryAll();

                $SQL3 = "select subledger,sum(db)-sum(cr) as amt from ss where date >= '$no_days_90' AND date < '$no_days_60' group by subledger";

                $arr_sum_amount3 = Yii::app()->db->createCommand($SQL3)->queryAll();

                $SQL4 = "select subledger,sum(db)-sum(cr) as amt from ss where date >= '$no_days_120' AND date < '$no_days_90' group by subledger";

                $arr_sum_amount4 = Yii::app()->db->createCommand($SQL4)->queryAll();

//$SQL5="select subledger,sum(db)-sum(cr) as amt from q1 where date >= '$no_days_150' AND date < '$no_days_120' group by subledger";
//$arr_sum_amount5  = Yii::app()->db->createCommand($SQL5)->queryAll();
//$SQL6="select subledger,sum(db)-sum(cr) as amt from q1 where date >= '$no_days_180' AND date < '$no_days_150' group by subledger";
//$arr_sum_amount6  = Yii::app()->db->createCommand($SQL6)->queryAll();

                $SQL7 = "select subledger,sum(db)-sum(cr) as amt from ss where date < '$no_days_120' group by subledger";

                $arr_sum_amount7 = Yii::app()->db->createCommand($SQL7)->queryAll();

                $tot = 0;

                $due1 = 0;

                $due2 = 0;

                $due3 = 0;

                $due4 = 0;

                $due5 = 0;

                $due6 = 0;

                $due7 = 0;



                $pnd = 0;

                foreach ($company as $rowCompany) {

                    $amt = 0;

                    $amt1 = 0;

                    $amt2 = 0;

                    $amt3 = 0;

                    $amt4 = 0;

                    $amt5 = 0;

                    $amt6 = 0;

                    $amt7 = 0;

                    $amt8 = 0;

                    if ($rowCompany['account_no'] != '') {

                        $opening_bal = FinOpeningBalance::model()->find(array('condition' => 'company_id=' . $rowCompany['account_no'] . ' AND mainacc=' . $account_id));
                    } else {

                        $opening_bal->type = 0;

                        $opening_bal->statement_op = 0;
                    }



                    $tds = '<td class="cell-left"><b>' . $rowCompany['description'] . '(' . $rowCompany['account_no'] . ')' . '</b></td>';

                    foreach ($arr_sum_amount1 as $eachInvoice1) {

                        $amt8 = $opening_bal->statement_op;

                        if ($rowCompany['id'] == $eachInvoice1['subledger']) {

                            $amt1 = $eachInvoice1['amt'];

                            $due1 += $eachInvoice1['amt'];

                            $amt8 = $opening_bal->statement_op;
                        }
                    }

                    if ($amt1 < 0) {

                        $tds .= '<td class="cell-right">' . Yii::app()->numberFormatter->formatCurrency(abs($amt1), "") . ' Cr</td>';
                    } else {

                        $tds .= '<td class="cell-right">' . Yii::app()->numberFormatter->formatCurrency($amt1, "") . ' Dr</td>';
                    }

                    foreach ($arr_sum_amount2 as $eachInvoice2) {

                        if ($rowCompany['id'] == $eachInvoice2['subledger']) {

                            $amt2 = $eachInvoice2['amt'];

                            $due2 += $eachInvoice2['amt'];

                            $amt8 = $opening_bal->statement_op;
                        }
                    }

                    if ($amt2 < 0) {

                        $tds .= '<td class="cell-right">' . Yii::app()->numberFormatter->formatCurrency(abs($amt2), "") . ' Cr</td>';
                    } else {

                        $tds .= '<td class="cell-right">' . Yii::app()->numberFormatter->formatCurrency($amt2, "") . ' Dr</td>';
                    }

                    foreach ($arr_sum_amount3 as $eachInvoice3) {

                        if ($rowCompany['id'] == $eachInvoice3['subledger']) {

                            $amt3 = $eachInvoice3['amt'];

                            $due3 += $eachInvoice3['amt'];

                            $amt8 = $opening_bal->statement_op;
                        }
                    }

                    if ($amt3 < 0) {

                        $tds .= '<td class="cell-right">' . Yii::app()->numberFormatter->formatCurrency(abs($amt3), "") . ' Cr</td>';
                    } else {

                        $tds .= '<td class="cell-right">' . Yii::app()->numberFormatter->formatCurrency($amt3, "") . ' Dr</td>';
                    }

                    foreach ($arr_sum_amount4 as $eachInvoice4) {

                        if ($rowCompany['id'] == $eachInvoice4['subledger']) {

                            $amt4 = $eachInvoice4['amt'];

                            $due4 += $eachInvoice4['amt'];

                            $amt8 = $opening_bal->statement_op;
                        }
                    }

                    if ($amt4 < 0) {

                        $tds .= '<td class="cell-right">' . Yii::app()->numberFormatter->formatCurrency(abs($amt4), "") . ' Cr</td>';
                    } else {

                        $tds .= '<td class="cell-right">' . Yii::app()->numberFormatter->formatCurrency($amt4, "") . ' Dr</td>';
                    }

                    foreach ($arr_sum_amount7 as $eachInvoice7) {



                        if ($rowCompany['id'] == $eachInvoice7['subledger']) {

                            $amt7 = $eachInvoice7['amt'];

                            $due7 += $eachInvoice7['amt'];

                            $amt8 = $opening_bal->statement_op;
                        }
                    }

                    if ($opening_bal->type == 1) {

                        $amt7 = $amt7 + $amt8;

                        $due7 += $amt8;
                    } else if ($opening_bal->type == 2) {



                        $amt7 = $amt7 - $amt8;

                        $due7 = $due7 - $amt8;
                    }

                    if ($amt7 < 0) {

                        $tds .= '<td class="cell-right">' . Yii::app()->numberFormatter->formatCurrency(abs($amt7), "") . ' Cr</td>';
                    } else {

                        $tds .= '<td class="cell-right">' . Yii::app()->numberFormatter->formatCurrency($amt7, "") . ' Dr</td>';
                    }

                    $amt = $amt1 + $amt2 + $amt3 + $amt4 + $amt5 + $amt6 + $amt7;

                    if ($amt < 0) {

                        $tds .= '<td class="cell-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($amt), "") . ' Cr</b></td>';
                    } else {

                        $tds .= '<td class="cell-right"><b>' . Yii::app()->numberFormatter->formatCurrency($amt, "") . ' Dr</b></td>';
                    }

                    if ($amt != 0) {

                        $pnd += $amt;

                        $trs[] = '<tr>' . $tds . '</tr>';
                    }
                }



                $pend1 += $due1;

                $pend2 += $due2;

                $pend3 += $due3;

                $pend4 += $due4;

//            $pend5+=$due5;
//            $pend6+=$due6;

                $pend7 += $due7;



                if ($pend1 < 0) {

                    $pend1 = Yii::app()->numberFormatter->formatCurrency(abs($pend1), "") . ' Cr';
                } else {

                    $pend1 = Yii::app()->numberFormatter->formatCurrency($pend1, "") . ' Dr';
                }

                if ($pend2 < 0) {

                    $pend2 = Yii::app()->numberFormatter->formatCurrency(abs($pend2), "") . ' Cr';
                } else {

                    $pend2 = Yii::app()->numberFormatter->formatCurrency($pend2, "") . ' Dr';
                }

                if ($pend3 < 0) {

                    $pend3 = Yii::app()->numberFormatter->formatCurrency(abs($pend3), "") . ' Cr';
                } else {

                    $pend3 = Yii::app()->numberFormatter->formatCurrency($pend3, "") . ' Dr';
                }

                if ($pend4 < 0) {

                    $pend4 = Yii::app()->numberFormatter->formatCurrency(abs($pend4), "") . ' Cr';
                } else {

                    $pend4 = Yii::app()->numberFormatter->formatCurrency($pend4, "") . ' Dr';
                }

                if ($pend7 < 0) {

                    $pend7 = Yii::app()->numberFormatter->formatCurrency(abs($pend7), "") . ' Cr';
                } else {

                    $pend7 = Yii::app()->numberFormatter->formatCurrency($pend7, "") . ' Dr';
                }

                if ($pnd < 0) {

                    $pnd = Yii::app()->numberFormatter->formatCurrency(abs($pnd), "") . ' Cr';
                } else {

                    $pnd = Yii::app()->numberFormatter->formatCurrency($pnd, "") . ' Dr';
                }

                $html_prepared = implode(' ', $trs);

                $html_prepared .= '<tr><th class="bgblack"><b>Grand Total</b></th><th class="cell-right br-top"><b>' . $pend1 . '</b></th><th class="cell-right br-top bgblack"><b>' . $pend2 . '</b></th><th class="cell-right br-top bgblack"><b>' . $pend3 . '</b></th><th class="cell-right br-top bgblack"><b>' . $pend4 . '</b></th><th class="cell-right br-top bgblack"><b>' . $pend7 . '</b></th><th class="cell-right br-top bgblack"><b>' . $pnd . '</b></th></tr>';

                ini_set("memory_limit", "-1");

                $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

                // $mpdf->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);
                //$mpdf->showWatermarkImage = true;
                // $mpdf->watermarkImageAlpha = 0.09;

                $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');

                $mpdf->AddPage('L');

                $mpdf->WriteHTML($stylesheet, 1);

                $mpdf->WriteHTML($this->renderPartial("application.views.front.pdf.ageing", array('content' => $html_prepared, 'date_to' => $searchenddate, 'account_no' => $account_id), true));

                $mpdf->Output('Ageing Report.pdf', 'I');



//        $this->report('', 'ledger-all', 'pdf_for_single', $html_prepared, 'Ageing Report');
//             $this->layout = 'pdf';
//    		$this->render('//pdf/ageing_report_html', array('date_to'=>$searchenddate,'account'=>$account_id,'content'=>$html_prepared), false, true);
            }
        } else {

            echo "Please Select Account";
        }
    }

    public function report($model, $htmlTemplate, $css, $html_prepared = null, $title = null) {

        ini_set("memory_limit", "128G");

        ini_set('max_execution_time', 1000);

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/' . $css . '.css');

        $mpdf->WriteHTML($stylesheet, 1);

        //print_r($this->renderPartial('application.views.front.pdf.reports.' . $htmlTemplate, array('model' => $model, 'product_items' => $html_prepared, 'title' => $title),true));

        $mpdf->WriteHTML($this->renderPartial('application.views.front.pdf.' . $htmlTemplate, array('model' => $model, 'product_items' => $html_prepared, 'title' => $title), true));

        $mpdf->Output($htmlTemplate, 'I');
    }

    public function actionPrintDayBook() {

        $date_from = $_REQUEST['from_date'];

        $date_to = $_REQUEST['to_date'];

        $date_from = str_replace('/', '-', $date_from);

        $date_from = date("Y-m-d", strtotime($date_from));

        $date_to = str_replace('/', '-', $date_to);

        $date_to = date("Y-m-d", strtotime($date_to));

        ini_set("memory_limit", -1);

        ini_set('max_execution_time', 1000);

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $mpdf->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);

        $mpdf->showWatermarkImage = true;

        $mpdf->watermarkImageAlpha = 0.09;

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial("application.views.front.pdf.daybook_new", array('date_from' => $date_from, 'date_to' => $date_to), true));

        $mpdf->Output('Day Book.pdf', 'I');
    }

    public function actionPrintVatSummary() {

        $date_from = $_REQUEST['from_date'];

        $date_to = $_REQUEST['to_date'];

        $date_from = str_replace('/', '-', $date_from);

        $date_from = date("Y-m-d", strtotime($date_from));

        $date_to = str_replace('/', '-', $date_to);

        $date_to = date("Y-m-d", strtotime($date_to));

        ini_set("memory_limit", -1);

        ini_set('max_execution_time', 1000);

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $mpdf->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);

        $mpdf->showWatermarkImage = true;

        $mpdf->watermarkImageAlpha = 0.09;

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial("application.views.front.pdf.vat_summary", array('date_from' => $date_from, 'date_to' => $date_to), true));

        $mpdf->Output('VAT.pdf', 'I');
    }

    public function actionPrintVatFinalSummary() {

        $date_from = $_REQUEST['from_date'];

        $date_to = $_REQUEST['to_date'];

        $date_from = str_replace('/', '-', $date_from);

        $date_from = date("Y-m-d", strtotime($date_from));

        $date_to = str_replace('/', '-', $date_to);

        $date_to = date("Y-m-d", strtotime($date_to));

        ini_set("memory_limit", -1);

        ini_set('max_execution_time', 1000);

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $mpdf->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);

        $mpdf->showWatermarkImage = true;

        $mpdf->watermarkImageAlpha = 0.09;

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial("application.views.front.pdf.vat_final_summary", array('date_from' => $date_from, 'date_to' => $date_to), true));

        $mpdf->Output('VATSUMMARY.pdf', 'I');
    }

    public function actionPrintTrialBalance() {

        $date_from = $_REQUEST['to_date'];

        $date_from = str_replace('/', '-', $date_from);

        $date_from = date("Y-m-d", strtotime($date_from));

        ini_set("memory_limit", "256M");

        //  ini_set('max_execution_time', 1000);

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $mpdf->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);

        $mpdf->showWatermarkImage = true;

        $mpdf->watermarkImageAlpha = 0.09;

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');

        $mpdf->WriteHTML($stylesheet, 1);



        $mpdf->WriteHTML($this->renderPartial("application.views.front.pdf.trial_bal", array('date_from' => $date_from), true));

        $mpdf->Output('Trial Balance.pdf', 'I');
    }

    public function actionPrintTrialBalanceEx() {

        $date_from = $_REQUEST['to_date'];

        $date_from = str_replace('/', '-', $date_from);

        $date_from = date("Y-m-d", strtotime($date_from));

        ini_set("memory_limit", "256M");

        //  ini_set('max_execution_time', 1000);

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $mpdf->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);

        $mpdf->showWatermarkImage = true;

        $mpdf->watermarkImageAlpha = 0.09;

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');

        $mpdf->WriteHTML($stylesheet, 1);



        $mpdf->WriteHTML($this->renderPartial("application.views.front.pdf.trial_bal_ex", array('date_from' => $date_from), true));

        $mpdf->Output('Trial Balance.pdf', 'I');
    }

    public function actionPrintProfitLoss() {

        $date_from = $_REQUEST['from_date'];

        $date_to = $_REQUEST['to_date'];

        $date_from = str_replace('/', '-', $date_from);

        $date_from = date("Y-m-d", strtotime($date_from));

        $date_to = str_replace('/', '-', $date_to);

        $date_to = date("Y-m-d", strtotime($date_to));

        ini_set("memory_limit", "256M");

        //  ini_set('max_execution_time', 1000);

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $mpdf->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);

        $mpdf->showWatermarkImage = true;

        $mpdf->watermarkImageAlpha = 0.09;

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');

        $mpdf->WriteHTML($stylesheet, 1);



        $mpdf->WriteHTML($this->renderPartial("application.views.front.pdf.profit_loss", array('date_from' => $date_from, 'date_to' => $date_to), true));

        $mpdf->Output('profit&loss.pdf', 'I');
    }

    public function actionPrintMaterialReceiptsReport() {



        $model = new PurchasingMaterialreceipt();



        $order_from_date = $_POST['order_from_date'];

        $order_to_date = $_POST['order_to_date'];

        $vendor_id = $_POST['vendor_id'];

        $project_id = $_POST['project_id'];

        $qcchecked = $_POST['qcchecked'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_material_rece_list', array('model' => $model, 'order_from_date' => $order_from_date, 'order_to_date' => $order_to_date, 'project_id' => $project_id, 'vendor_id' => $vendor_id, 'qcchecked' => $qcchecked), false, true);
    }

    public function actionPrintInvoiceListReport() {



        $model = new PurchasingInvoice();



        $order_from_date = $_POST['order_from_date'];

        $order_to_date = $_POST['order_to_date'];

        $vendor_id = $_POST['vendor_id'];

        $project_id = $_POST['project_id'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_invoice_report_list', array('model' => $model, 'order_from_date' => $order_from_date, 'order_to_date' => $order_to_date, 'project_id' => $project_id, 'vendor_id' => $vendor_id), false, true);
    }

    public function actionPrintPurchaseRegisterReport() {



        $model = new PurchasingOrder();



        $order_from_date = $_POST['order_from_date'];

        $order_to_date = $_POST['order_to_date'];

        $po_id = $_POST['po_id'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_purchase_reg_list', array('model' => $model, 'order_from_date' => $order_from_date, 'order_to_date' => $order_to_date, 'po_id' => $po_id), false, true);
    }

    public function actionPrintPurchaseDebitNotesReport() {



        $model = new Purchasingdebitnote();



        $order_from_date = $_POST['order_from_date'];

        $order_to_date = $_POST['order_to_date'];

        $vendor_id = $_POST['vendor_id'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_purchasedebitnoteslist', array('model' => $model, 'order_from_date' => $order_from_date, 'order_to_date' => $order_to_date, 'vendor_id' => $vendor_id), false, true);
    }

    public function actionPrintPurchaseOrderPendingReportPDF() {



        $model = new PurchasingOrder();



        $order_from_date = Yii::app()->request->getParam('order_from_date');

        $order_to_date = Yii::app()->request->getParam('order_to_date');

        $vendor_id = Yii::app()->request->getParam('vendor_id');

        $project_id = Yii::app()->request->getParam('project_id');





        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.purchase_order_pending_list', array('model' => $model, 'order_from_date' => $order_from_date, 'order_to_date' => $order_to_date, 'vendor_id' => $vendor_id, 'project_id' => $project_id), true));



        $mpdf->Output("PurchaseOrderPendingReport.pdf", 'I');
    }

    public function actionPrintMaterialReceiptsReportPDF() {



        $model = new PurchasingMaterialreceipt();



        $order_from_date = Yii::app()->request->getParam('order_from_date');

        $order_to_date = Yii::app()->request->getParam('order_to_date');

        $vendor_id = Yii::app()->request->getParam('vendor_id');

        // $project_id = Yii::app()->request->getParam('project_id');

        $qcchecked = Yii::app()->request->getParam('qcchecked');



        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.purchase_material_rec_list', array('model' => $model, 'order_from_date' => $order_from_date, 'order_to_date' => $order_to_date, 'vendor_id' => $vendor_id, 'project_id' => $project_id, 'qcchecked' => $qcchecked), true));



        $mpdf->Output("MaterialReceiptsReport.pdf", 'I');
    }

    public function actionPrintInvoiceListReportPDF() {



        $model = new PurchasingInvoice();



        $order_from_date = Yii::app()->request->getParam('order_from_date');

        $order_to_date = Yii::app()->request->getParam('order_to_date');

        $vendor_id = Yii::app()->request->getParam('vendor_id');



        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.purchase_invoice_list', array('model' => $model, 'order_from_date' => $order_from_date, 'order_to_date' => $order_to_date, 'vendor_id' => $vendor_id, 'project_id' => $project_id), true));



        $mpdf->Output("InvoiceListReport.pdf", 'I');
    }

    public function actionPrintUninvoiceListReportPDF() {



        $model = new PurchasingInvoice();



        $from_date = Yii::app()->request->getParam('from_date');

        $to_date = Yii::app()->request->getParam('to_date');

        $vendor_id = Yii::app()->request->getParam('vendor_id');



        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.purchase_uninvoice_list', array('model' => $model, 'from_date' => $from_date, 'to_date' => $to_date, 'vendor_id' => $vendor_id), true));



        $mpdf->Output("UninvoiceListReport.pdf", 'I');
    }

    public function actionPrintPurchaseUninvoiceExcel() {

        $from_date = Yii::app()->request->getParam('order_from_date');

        $to_date = Yii::app()->request->getParam('order_to_date');



        $vendor_id = Yii::app()->request->getParam('vendor_id');

        //print_r($vendor_id);die();

        $file = fopen("uploads/csvs/test.csv", "w");

        $criteria = new CDbCriteria;



        $condition = '';
        ;

        $condition1 = '';
        ;

        if ($from_date != '') {

            $from_date = str_replace('/', '-', $from_date);

            $from_date = date('Y-m-d', strtotime($from_date));

            ///$condition .= ' AND t.order_date >="'.$from_date.'"';
        }

        if ($to_date != '') {

            $to_date = str_replace('/', '-', $to_date);

            $to_date = date('Y-m-d', strtotime($to_date));

            //$condition .= ' AND t.order_date <="'.$to_date.'"';
        }

        if ($vendor_id != '') {

            $condition .= ' AND MR.vendor_id="' . $vendor_id . '"';

            $condition1 .= ' AND MR.vendor_name="' . $vendor_id . '"';
        }





        $model_order = Yii::app()->db->createCommand('SELECT MR.id,MR.file_id,MR.po_id,MR.vendor_id FROM erp_purchasing_material_receipt AS MR

                                                                WHERE MR.file_id NOT IN ( SELECT  PI.file_id FROM  erp_purchasinginvoice AS PI ) ' . $condition . '')->queryAll();



        $j = 0;

        $list[$j++] = 'No!File No!PO No!Supplier name!Invoice Date!Grand Total!Grand Total(BC)';



        $tot = 0;

        foreach ($model_order as $i => $model) {





            $vendor_id = $model['vendor_id'];

            $po_id = $model['po_id'];

            $model_vendor = Vendor::model()->findByPK($vendor_id);

            $model_purchase_order = PurchasingOrder::model()->findByPK($po_id);





            if ($model->invoice_date != '0000-00-00') {

                $invoicedate = date("d/m/Y", strtotime($model->invoice_date));
            } else {

                $invoicedate = " ";
            }



            $grand_total = $model->currencyname->currency_code . " " . Yii::app()->numberFormatter->formatCurrency($model['grand_total'], "");



            $model_currency = MasCurrency::model()->findByPk($model->currencyname->id);

            $grand_total = $model['grand_total'];

            $total_bc = $grand_total * $model_currency['exchange_rate'];

            $total += $total_bc;



            // $tot += $total_bc;



            Yii::app()->numberFormatter->formatCurrency($model_purchase_order['stock_grand_total'], " ");

            $model_currency = MasCurrency::model()->findByPk($model_purchase_order['currency']);

            $total_bc = $model_purchase_order['stock_grand_total'] * $model_currency->exchange_rate;

            $total += $total_bc;

            //   $total_bc = Yii::app()->numberFormatter->formatCurrency($total_bc, " ");

            $grand_total = Yii::app()->numberFormatter->formatCurrency($model_purchase_order['stock_grand_total'], " ");





            //$tot =   Yii::app()->numberFormatter->formatCurrency($total_bc, " ");



            $list[$j++] = ($i + 1) . '!' . $model['file_id'] . '!' . $model['po_id'] . '!' . $model_vendor['vendor_name'] . '!' . date("d/m/Y", strtotime($model_purchase_order['created_datetime'])) . '!' . $grand_total . '!' . $total_bc;
        }



        $list[$j++] = " " . '!' . " " . '!' . " " . '!' . " " . '!' . " " . '!' . " " . '!' . " Total " . '!' . $total;









        $j++;

        foreach ($list as $line) {

            fputcsv($file, explode('!', $line));
        }

        fclose($file);

        $filename = 'uploads/csvs/test.csv';

        //$filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';

        header('Content-Type: application/csv');

        header("Content-disposition: attachment; filename=\"purchaseUninvoiceList.csv\"");

        readfile($filename);

        Yii::app()->end();

        return;
    }

    public function actionPrintPurchaseRegisterReportPDF() {



        $model = new Order();



        $order_from_date = Yii::app()->request->getParam('order_from_date');

        $order_to_date = Yii::app()->request->getParam('order_to_date');

        $po_id = Yii::app()->request->getParam('po_id');

        $project_id = Yii::app()->request->getParam('project_id');





        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.purchase_register_list', array('model' => $model, 'order_from_date' => $order_from_date, 'order_to_date' => $order_to_date, 'po_id' => $po_id, 'project_id' => $project_id), true));



        $mpdf->Output("PurchaseRegisterReport.pdf", 'I');
    }

    public function actionPrintPurchaseDebitNotesReportPDF() {



        $model = new Purchasingdebitnote();



        $order_from_date = Yii::app()->request->getParam('order_from_date');

        $order_to_date = Yii::app()->request->getParam('order_to_date');

        $vendor_id = Yii::app()->request->getParam('vendor_id');



        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.purchase_debitnote_list', array('model' => $model, 'order_from_date' => $order_from_date, 'order_to_date' => $order_to_date, 'vendor_id' => $vendor_id), true));



        $mpdf->Output("PurchaseDebitNotesReport.pdf", 'I');
    }

    public function actionSearchPurchaseOrderNo() {

        $data_array = array();

        if (isset($_GET['term'])) {

            $condition = ' (t.po_id like "%' . $_GET['term'] . '%")';

            $model = PurchasingInvoice::model()->with('purchaseorder')->findAll(array('condition' => $condition, 'order' => 't.id DESC', 'group' => 't.po_id'));

            $i = 0;

            foreach ($model as $eachModel) {

                $data_array[$i]['value'] = $eachModel->po_id;

                $data_array[$i]['label'] = $eachModel->po_id;

                $i++;
            }
        }

        echo CJSON::encode($data_array);

        Yii::app()->end();
    }

    public function actionPendingPurchaseDetail() {



        $model = new PurchasingOrderStockItem();

        $order_id = Yii::app()->request->getParam('id');

        $this->render('single_order_details', array('model' => $model, 'id' => $order_id), false, true);
    }

    public function actionPrintInventoryReceiveReport() {

        $model = new InventoryIndirectReceivedItems();

        $type = $_POST['type'];

        $from_warehouse = $_POST['from_warehouse'];

        $to_warehouse = $_POST['to_warehouse'];

        $transfer_from_date = $_POST['transfer_from_date'];

        $transfer_to_date = $_POST['transfer_to_date'];

        $transfer_no = $_POST['transfer_no'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_inventoryreceive_list', array('model' => $model, 'type' => $type, 'from_warehouse' => $from_warehouse, 'to_warehouse' => $to_warehouse, 'transfer_from_date' => $transfer_from_date, 'transfer_to_date' => $transfer_to_date, 'transfer_no' => $transfer_no, 'title' => $title), false, true);
    }

    public function actionPrintDirectTransferReport() {

        $model = new InventoryDirectTransfer();

        $from_warehouse = $_POST['from_warehouse'];

        $to_warehouse = $_POST['to_warehouse'];

        $transfer_from_date = $_POST['transfer_from_date'];

        $transfer_to_date = $_POST['transfer_to_date'];

        $transfer_no = $_POST['transfer_no'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_directtransfer_list', array('model' => $model, 'from_warehouse' => $from_warehouse, 'to_warehouse' => $to_warehouse, 'transfer_from_date' => $transfer_from_date, 'transfer_to_date' => $transfer_to_date, 'transfer_no' => $transfer_no, 'title' => $title), false, true);
    }

    public function actionPrintDirectTransferReportPDF() {

        $model = new InventoryDirectTransfer();

        $from_warehouse = Yii::app()->request->getParam('from_warehouse');

        $to_warehouse = Yii::app()->request->getParam('to_warehouse');

        $transfer_from_date = Yii::app()->request->getParam('transfer_from_date');

        $transfer_to_date = Yii::app()->request->getParam('transfer_to_date');

        $transfer_no = Yii::app()->request->getParam('transfer_no');





        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.directtransfer_list', array('model' => $model, 'type' => $type, 'from_warehouse' => $from_warehouse, 'to_warehouse' => $to_warehouse, 'transfer_from_date' => $transfer_from_date, 'transfer_to_date' => $transfer_to_date, 'transfer_no' => $transfer_no), true));



        $mpdf->Output("DirectTransferReport.pdf", 'I');
    }

    public function actionPrintDamagedReport() {

        $model = new InventoryIndirectReceivedItems();

        $from_warehouse = $_POST['from_warehouse'];

        $to_warehouse = $_POST['to_warehouse'];

        $transfer_from_date = $_POST['transfer_from_date'];

        $transfer_to_date = $_POST['transfer_to_date'];

        $transfer_no = $_POST['transfer_no'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_damaged_list', array('model' => $model, 'from_warehouse' => $from_warehouse, 'to_warehouse' => $to_warehouse, 'transfer_from_date' => $transfer_from_date, 'transfer_to_date' => $transfer_to_date, 'transfer_no' => $transfer_no, 'title' => $title), false, true);
    }

    public function actionPrintInTransistReport() {

        $model = new InventoryIndirectTransfer();

        $from_warehouse = Yii::app()->request->getParam('from_warehouse');

        $transfer_from_date = Yii::app()->request->getParam('transfer_from_date');

        $transfer_to_date = Yii::app()->request->getParam('transfer_to_date');

        $transfer_no = Yii::app()->request->getParam('transfer_no');



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_intransist_list', array('model' => $model, 'from_warehouse' => $from_warehouse, 'transfer_from_date' => $transfer_from_date, 'transfer_to_date' => $transfer_to_date, 'transfer_no' => $transfer_no, 'title' => $title), false, true);
    }

    public function actionPrintInTransistReportPDF() {

        $model = new InventoryIndirectTransfer();

        $from_warehouse = Yii::app()->request->getParam('from_warehouse');

        $transfer_from_date = Yii::app()->request->getParam('transfer_from_date');

        $transfer_to_date = Yii::app()->request->getParam('transfer_to_date');

        $transfer_no = Yii::app()->request->getParam('transfer_no');



        $arrayparam = array('model' => $model, 'from_warehouse' => $from_warehouse, 'transfer_from_date' => $transfer_from_date, 'transfer_to_date' => $transfer_to_date, 'transfer_no' => $transfer_no, 'title' => $title);



        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.intransist_list', $arrayparam, true));



        $mpdf->Output("InTransistReport.pdf", 'I');
    }

    public function actionPrintInventorytransferReceiveReportPDF() {

        $model = new InventoryIndirectReceivedItems();

        $type = Yii::app()->request->getParam('type');

        $from_warehouse = Yii::app()->request->getParam('from_warehouse');

        $to_warehouse = Yii::app()->request->getParam('to_warehouse');

        $transfer_from_date = Yii::app()->request->getParam('transfer_from_date');

        $transfer_to_date = Yii::app()->request->getParam('transfer_to_date');

        $transfer_no = Yii::app()->request->getParam('transfer_no');



        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.inventoryreceive_list', array('model' => $model, 'type' => $type, 'from_warehouse' => $from_warehouse, 'to_warehouse' => $to_warehouse, 'transfer_from_date' => $transfer_from_date, 'transfer_to_date' => $transfer_to_date, 'transfer_no' => $transfer_no), true));



        $mpdf->Output("Inventorytransfer.pdf", 'I');
    }

    public function actionPrintCreditNoteReport() {



        $model = new Creditnote();



        $from_date = $_POST['from_date'];

        $to_date = $_POST['to_date'];

        $customer_id = $_POST['customer_id'];

        $leadowner_id = $_POST['leadowner_id'];

        $inv_type = $_POST['inv_type'];

        $created_by = $_POST['created_by'];


        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_creditnote_list', array('model' => $model, 'leadowner_id' => $leadowner_id, 'from_date' => $from_date, 'to_date' => $to_date, 'customer_id' => $customer_id, 'title' => $title, 'inv_type' => $inv_type, 'created_by' => $created_by), false, true);
    }

    public function actionPrintCreditReport() {







        $from_date = $_POST['from_date'];

        $to_date = $_POST['to_date'];

        $customer_id = $_POST['customer_id'];

        $leadowner_id = $_POST['leadowner_id'];

        $inv_no = $_POST['inv_no'];

        $file_no = $_POST['file_no'];

        $created_by = $_POST['created_by'];


        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_credit_note_list', array('leadowner_id' => $leadowner_id, 'from_date' => $from_date, 'to_date' => $to_date, 'customer_id' => $customer_id, 'title' => $title, 'inv_no' => $inv_no, 'file_no' => $file_no, 'created_by' => $created_by), false, true);
    }

    public function actionPrintCreditReportPDF() {




        $from_date = Yii::app()->request->getParam('from_date');

        $to_date = Yii::app()->request->getParam('to_date');

        $customer_id = Yii::app()->request->getParam('customer_id');

        $leadowner_id = $_POST['leadowner_id'];

        $inv_no = Yii::app()->request->getParam('inv_no');

        $file_no = Yii::app()->request->getParam('file_no');

        $created_by = Yii::app()->request->getParam('created_by');


        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.creditnote_report_list', array('leadowner_id' => $leadowner_id, 'from_date' => $from_date, 'to_date' => $to_date, 'customer_id' => $customer_id, 'inv_no' => $inv_no, 'file_no' => $file_no, 'title' => $title, 'created_by' => $created_by), true));



        $mpdf->Output("CreditnoteList.pdf", 'I');
    }

    public function actionPrintCreditExcel() {



        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $customer_id = Yii::app()->request->getParam('customer_id');
        $leadowner_id = Yii::app()->request->getParam('leadowner_id');
        $inv_no = Yii::app()->request->getParam('inv_no');
        $file_no = Yii::app()->request->getParam('file_no');
        $created_by = Yii::app()->request->getParam('created_by');




        $filename = 'creditnote_report' . date('dmYhis') . '.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderpartial('application.views.front.reports.excel.creditnote_report', array('from_date' => $from_date, 'to_date' => $to_date, 'customer_id' => $customer_id, 'leadowner_id' => $leadowner_id, 'created_by' => $created_by, 'inv_no' => $inv_no, 'file_no' => $file_no, 'title' => $title), false, true);
        Yii::app()->end();


        return;
    }

    public function actionPrintDirectSalesReport() {



        $model = new DirectOrder();



        $from_date = $_POST['from_date'];

        $to_date = $_POST['to_date'];

        $customer_id = $_POST['customer_id'];

        $leadowner_id = $_POST['leadowner_id'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_directsales_list', array('model' => $model, 'leadowner_id' => $leadowner_id, 'from_date' => $from_date, 'to_date' => $to_date, 'customer_id' => $customer_id, 'title' => $title), false, true);
    }

    public function actionPrintDirectSalesReportPDF() {



        $model = new DirectOrder();



        $from_date = $_GET['from_date'];

        $to_date = $_GET['to_date'];

        $customer_id = $_GET['customer_id'];

        $leadowner_id = $_GET['leadowner_id'];





        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.Direct_Sales_Report', array('model' => $model, 'leadowner_id' => $leadowner_id, 'from_date' => $from_date, 'to_date' => $to_date, 'customer_id' => $customer_id, 'title' => $title), true));



        $mpdf->Output("DirectSalesReport.pdf", 'I');



        //Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        //  $this->render('//reports/print_directsales_list', array('model' => $model, 'leadowner_id' => $leadowner_id,'from_date' => $from_date, 'to_date' => $to_date,  'customer_id' => $customer_id, 'title' => $title), false, true);
    }

//-----------------

    public function actionPrintCreditNoteReportPDF() {



        $model = new Creditnote();



        $from_date = Yii::app()->request->getParam('from_date');

        $to_date = Yii::app()->request->getParam('to_date');

        $customer_id = Yii::app()->request->getParam('customer_id');

        $leadowner_id = $_POST['leadowner_id'];

        $inv_type = Yii::app()->request->getParam('inv_type');

        $created_by = Yii::app()->request->getParam('created_by');


        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.creditnote_list', array('model' => $model, 'leadowner_id' => $leadowner_id, 'from_date' => $from_date, 'to_date' => $to_date, 'customer_id' => $customer_id, 'inv_type' => $inv_type, 'title' => $title, 'created_by' => $created_by), true));



        $mpdf->Output("CreditnoteList.pdf", 'I');
    }

    public function actionPrintNetSalesReport() {



        $model = new Invoice();

        $from_date = $_POST['from_date'];

        $to_date = $_POST['to_date'];

        $customer_id = $_POST['customer_id'];

        $leadowner_id = $_POST['leadowner_id'];

        $inv_type = Yii::app()->request->getParam('inv_type');





        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_netsales_list', array('model' => $model, 'leadowner_id' => $leadowner_id, 'from_date' => $from_date, 'to_date' => $to_date, 'customer_id' => $customer_id, 'title' => $title, 'inv_type' => $inv_type), false, true);
    }

    public function actionPrintZeroBasePriceProductPDF() {



        $model = new Inventory();



        $part_no = $_GET['part_no'];





        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.zero_base_costpricepdf', array('model' => $model, 'part_no' => $part_no, 'title' => $title), true));



        $mpdf->Output("Zerobasecostprice.pdf", 'I');



        //Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        //  $this->render('//reports/print_directsales_list', array('model' => $model, 'leadowner_id' => $leadowner_id,'from_date' => $from_date, 'to_date' => $to_date,  'customer_id' => $customer_id, 'title' => $title), false, true);
    }

    public function actionPrintGrossProfitReport() {



        $model = new Invoice();

        $from_date = $_POST['from_date'];

        $to_date = $_POST['to_date'];

        $customer_id = $_POST['customer_id'];

        $leadowner_id = $_POST['leadowner_id'];

        $salesgroup = $_POST['salesgroup'];

        $inv_type = $_POST['inv_type'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_grossprofit_list', array('model' => $model, 'sales_group' => $salesgroup, 'leadowner_id' => $leadowner_id, 'from_date' => $from_date, 'to_date' => $to_date, 'customer_id' => $customer_id, 'title' => $title, 'inv_type' => $inv_type), false, true);
    }

    public function actionPrintGrossProfitExcel() {

        $model = new Invoice();

        $heading = 'No,Invoice No ,Invoice Date ,Customer Name ,Currency ,Invoice Value ,Value(BC) ,Cost ,Profit ,Profit (%) ,Account Manager,Sales Group';

        $from_date = Yii::app()->request->getParam('from_date');

        $to_date = Yii::app()->request->getParam('to_date');

        $customer_id = Yii::app()->request->getParam('customer_id');

        $leadowner_id = Yii::app()->request->getParam('leadowner_id');

        $salesgroup = Yii::app()->request->getParam('salesgroup');

        $inv_type = Yii::app()->request->getParam('inv_type');

        $condition = "1=1";

        if ($from_date != '') {

            $from_date = str_replace('/', '-', $from_date);

            $from_date = date('Y-m-d', strtotime($from_date));

            $condition .= ' AND I.invoice_date >="' . $from_date . '"';
        }

        if ($to_date != '') {

            $to_date = str_replace('/', '-', $to_date);

            $to_date = date('Y-m-d', strtotime($to_date));

            $condition .= ' AND I.invoice_date <="' . $to_date . '"';
        }

        if ($customer_id != '') {

            $condition .= ' AND C.id ="' . $customer_id . '"';
        }

        if ($sales_group > 0) {

            $condition .= ' AND I.sales_group = "' . $sales_group . '"';
        }

        if ($leadowner_id > 0) {

            $condition .= ' AND (F.lead_owner_id = "' . $leadowner_id . '" OR I.lead_owner_id = "' . $leadowner_id . '")';
        }

        if ($inv_type > 0) {

            $condition .= ' AND I.invoice_type = "' . $inv_type . '"';
        }

        $total_invoice_val = $total_profit = $total_cost = 0;

        $query = 'SELECT

                        SUM(IT.rate) AS selling_price,

                        I.invoice_date AS invoice_date,

                        I.delivery_ids AS delivery_note_ids,
                        
                        I.id AS invoiceid,
                        
                        I.exchange_rate AS exchange_rate,

                        CONCAT(IC.inv_code,"-",I.invoice_no) AS invoice_no,

                        C.customer_name AS customer,I.sales_group,F.lead_owner_id AS file_lead_owner_id,I.lead_owner_id AS invoice_lead_owner_id,

                        (I.grand_total-I.total_tax_amount) AS  invoice_amt,

                        (I.grand_total-I.total_tax_amount) * I.exchange_rate AS invoice_value_bc,

                        CR.currency_code AS currency_name

                        FROM erp_invoice_item IT

                        LEFT JOIN {{invoice}} I ON I.id = IT.invoice_id

                        LEFT JOIN erp_master_file F ON F.id = I.file_id

                        LEFT JOIN erp_customer C ON I.customer_id = C.id

                        LEFT JOIN erp_mas_currency CR ON I.currency = CR.id

                        LEFT JOIN erp_mas_invoice_type IC ON I.invoice_type = IC.id

                        WHERE ' . $condition . '

                        GROUP BY I.id

                        ORDER BY I.id DESC';

        $items = Yii::app()->db->createCommand($query)->queryAll();

        $no = 0;

        $list[$no++] = $heading;

        foreach ($items as $i => $model) {

            //$total_selling_price = $model['invoice_value_bc'];
            $exchange_rate = $model['exchange_rate'];

            /*             * *************  check credit note amt ************** */
            $credit_note_amt = 0;
            $creditNote = Yii::app()->db->createCommand()
                    ->select('sum(credited_amount) as credited_amount')
                    ->from('erp_creditnote')
                    ->where('invoice_id = ' . $model['invoiceid'])
                    ->queryRow();
            if ($creditNote['credited_amount'] > 0) {
                $credit_note_amt = $creditNote['credited_amount'];
            }
            /*             * **********************   end credit Note amt ***************** */
            /*             * *************   check credit note actual cost  ********************** */
            $cn_cost = 0;
            $model_credit_note = CreditnoteItem::model()->with('parent')->findAll(array('condition' => 'parent.invoice_id IN (' . $model['invoiceid'] . ')'));
            if (!empty($model_credit_note)) {
                foreach ($model_credit_note as $each) {
                    //$cost += ($each->quantity * $each->cost_price);
                    $cn_product_id = $each['product_id'];
                    //$cn_quantity    = $each['returned_quantity'];
                    $model_cn_cost = StockLedger::model()->find(array('condition' => 'header_id IN (' . $model['delivery_note_ids'] . ') AND product_id="' . $cn_product_id . '"'));
                    if (empty($model_cn_cost['cost_price']) OR $model_cn_cost['cost_price'] <= 0) {
                        $model_cn_cost['cost_price'] = 0;
                    }
                    $cn_cost += (($each['returned_quantity'] + $each['returned_bonus_qty']) * $model_cn_cost['cost_price']);
                }
            }
            /*             * **********************   end credit note actual cost ***************** */

            $actual_invoice_amt = $model['invoice_amt'] - $credit_note_amt;
            $invoice_value_bc = $actual_invoice_amt * $exchange_rate;

            //$total_selling_price = $model['invoice_value_bc'];
            $total_selling_price = $invoice_value_bc;

            $line = '';

            $cost = 0;

            $ledger = StockLedger::model()->findAll(array('condition' => 'header_id IN (' . $model['delivery_note_ids'] . ')'));

            if (!empty($ledger))
                foreach ($ledger as $each) {

                    $cost += ($each->quantity * $each->cost_price);
                }

            $line .= $model['delivery_note_ids'];

            $line .= ',' . $model['invoiceid'];

            $date = $model['invoice_date'];

            if ($date != '0000-00-00') {

                $newdate = date("d/m/Y", strtotime($date));

                $line .= ',' . $newdate;
            } else {

                $line .= ',' . '';
            } $line .= ',' . $model['customer'];

            $line .= ',' . $model['currency_name'];

            $line .= ',' . $actual_invoice_amt;

            $line .= ',' . $total_selling_price;

            $total_invoice_val += ($total_selling_price);

            $line .= ',' . $cost;

            $total_cost += $cost;



            $line .= ',' . ($total_selling_price + $cost);

            $total_profit += ($total_selling_price + $cost);

            //if ($cost > 0) {

            if ($total_selling_price != 0) {

                $profit_in_percentage = (($total_selling_price + $cost) / $total_selling_price) * 100;
            } else {

                $profit_in_percentage = '';
            }

            //} else {
            // $profit_in_percentage = 0;
            //}
            //Yii::app()->numberFormatter->formatCurrency($profit_in_percentage, " ");

            $line .= ',' . $profit_in_percentage;



            if ($model['invoice_lead_owner_id'] > 0) {

                $lead_owner_id = $model['invoice_lead_owner_id'];
            } else {

                $lead_owner_id = $model['file_lead_owner_id'];
            }

            $l = User::model()->findByPK($lead_owner_id);



            $line .= ',' . $l->fullname;



            $line .= ',' . MasSalesGroup::model()->findByPk($model['sales_group'])->group_name;

            $list[$no++] = $line;
        }

        $file = fopen("uploads/csvs/test.csv", "w");

        foreach ($list as $line) {

            fputcsv($file, explode(',', $line));
        }



        fclose($file);



//$filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $filename = 'uploads/csvs/test.csv';



        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';



        header('Content-Type: application/csv;');



        header("Content-disposition: attachment; filename=\"gross_profit_list.csv\"");



        readfile($filename);



        Yii::app()->end();



        return;
    }

    public function actionPrintGrossProfitReportPDF() {



        $model = new Invoice();

        $from_date = Yii::app()->request->getParam('from_date');

        $to_date = Yii::app()->request->getParam('to_date');

        $customer_id = Yii::app()->request->getParam('customer_id');

        $leadowner_id = Yii::app()->request->getParam('leadowner_id');

        $salesgroup = Yii::app()->request->getParam('salesgroup');

        $inv_type = Yii::app()->request->getParam('inv_type');



        $param = array('model' => $model,
            'sales_group' => $salesgroup,
            'leadowner_id' => $leadowner_id,
            'from_date' => $from_date,
            'to_date' => $to_date,
            'customer_id' => $customer_id,
            'title' => $title,
            'inv_type' => $inv_type);



        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.printgrossprofit', $param, true));



        $mpdf->Output("GrossProfitReport.pdf", 'I');
    }

    public function actionPrintNetSalesReportPDF() {



        $model = new Invoice();



        $from_date = Yii::app()->request->getParam('from_date');

        $to_date = Yii::app()->request->getParam('to_date');

        $customer_id = Yii::app()->request->getParam('customer_id');

        $leadowner_id = Yii::app()->request->getParam('leadowner_id');

        $inv_type = Yii::app()->request->getParam('inv_type');



        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.netsales_list', array('model' => $model, 'from_date' => $from_date, 'to_date' => $to_date, 'customer_id' => $customer_id, 'leadowner_id' => $leadowner_id, 'title' => $title, 'inv_type' => $inv_type), true));



        $mpdf->Output("NetSales.pdf", 'I');
    }

    public function actionPrintNetPurchaseReportPDF() {



        $model = new Invoice();



        $from_date = Yii::app()->request->getParam('from_date');

        $to_date = Yii::app()->request->getParam('to_date');

        $vendor_id = Yii::app()->request->getParam('vendor_id');



        $inv_type = Yii::app()->request->getParam('inv_type');



        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.net_purchase_reportpdf', array('model' => $model, 'from_date' => $from_date, 'to_date' => $to_date, 'vendor_id' => $vendor_id, 'inv_type' => $inv_type,), true));



        $mpdf->Output("NetPurchaseReport.pdf", 'I');
    }

    public function actionPrintCustomerSalesReport() {

        $arr_customer_details['customer_id'] = $_POST['customer_id'];

        $from_date = $_POST['sale_fromdate'];

        $to_date = $_POST['sale_todate'];

        //$arr_customer_details['sale_fromdate']              = $_POST['sale_fromdate'];
        //$arr_customer_details['sale_todate']              = $_POST['sale_todate'];
        //$arr_customer_details['includes_zero']              = $_POST['includes_zero'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_customer_sale_report', array('customer_details' => $arr_customer_details, 'from_date' => $from_date, 'to_date' => $to_date, 'title' => $title), false, true);
    }

    public function actionPrintCustomerBrandSalesReport() {

        $customer_id = $_POST['customer_id'];

        $brand = $_POST['brand'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_customer_brandsale_report', array('customer_id' => $customer_id, 'brand' => $brand, 'title' => $title), false, true);
    }

    public function actionPrintCustomerSalesReportPDF() {



        $arr_customer_details['customer_id'] = (int) Yii::app()->request->getParam('customer_id');

        $from_date = Yii::app()->request->getParam('from_date');

        $to_date = Yii::app()->request->getParam('to_date');



        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.pdf_customer_sale_report', array('customer_details' => $arr_customer_details, 'from_date' => $from_date, 'to_date' => $to_date, 'title' => $title), true));



        $mpdf->Output("CustomerSalesReport.pdf", 'I');
    }

    public function actionPrintCustomerNoSalesReport() {

        $arr_customer_details['customer_id'] = $_POST['customer_id'];

        $from_date = $_POST['no_sale_fromdate'];

        $to_date = $_POST['no_sale_todate'];

        //$arr_customer_details['includes_zero']              = $_POST['includes_zero'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_customer_no_sale_report', array('customer_details' => $arr_customer_details, 'from_date' => $from_date, 'to_date' => $to_date, 'title' => $title), false, true);
    }

    public function actionPrintCustomerNoSalesReportPDF() {

        $from_date = Yii::app()->request->getParam('str_from_date');
        $to_date = Yii::app()->request->getParam('str_to_date');
        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.pdf_customer_no_sale_report', array('str_from_date' => $from_date, 'str_to_date' => $to_date, 'title' => $title), true));

        $mpdf->Output("CustomerNoSalesReport.pdf", 'I');
    }

    public function actionPrintListItemsOrdered() {

        $model = new Order();
        $brand_id = (int) $_POST['brand'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_list_items_ordered', array('model' => $model, 'brand_id' => $brand_id), false, true);
    }

    public function actionPrintListItemsOrderedPDF() {

        $brand_id = Yii::app()->request->getParam('brand_id');
        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.print_list_items_ordered', array('brand_id' => $brand_id), true));

        $mpdf->Output("print_list_items_ordered.pdf", 'I');
    }

    public function actionPrintListItemsOrderedExcel() {

        $brand_id = Yii::app()->request->getParam('brand_id');
        $filename = 'list_items_ordered' . date('dmYhis') . '.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('application.views.front.reports.excel.print_list_items_ordered', array('brand_id' => $brand_id), false, true);
        Yii::app()->end();
    }

    public function actionPrintUnInvoiceReport() {



        $vendor = $_POST['vendor'];

        $from_date = $_POST['from_date'];

        $to_date = $_POST['to_date'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_uninvoice_list', array('vendor' => $vendor, 'from_date' => $from_date, 'to_date' => $to_date), false, true);
    }

    /*    arul on 3-1-2018 */

    public function actionPrintPurchaseOrderExcel() {

        $order_from_date = Yii::app()->request->getParam('order_from_date');

        $order_to_date = Yii::app()->request->getParam('order_to_date');

        $vendor_id = Yii::app()->request->getParam('vendor_id');

        $completed = Yii::app()->request->getParam('po_status');



        $file = fopen("uploads/csvs/test.csv", "w");

        $criteria = new CDbCriteria;



        if (!empty($order_from_date)) {

            $order_from_date = str_replace('/', '-', $order_from_date);

            $order_from_date = date('Y-m-d', strtotime($order_from_date));

            $criteria->addCondition('t.order_date>="' . $order_from_date . '"', 'AND');
        }

        if (!empty($order_to_date)) {

            $order_to_date = str_replace('/', '-', $order_to_date);

            $order_to_date = date('Y-m-d', strtotime($order_to_date));

            $criteria->addCondition('t.order_date<="' . $order_to_date . '"', 'AND');
        }

        if (!empty($vendor_id)) {

            $criteria->addCondition('t.vendor_id="' . $vendor_id . '"', 'AND');
        }

        if (!empty($completed)) {

            $criteria->addCondition('t.completed="' . $completed . '"', 'AND');
        }



        $model_order = PurchasingOrder::model()->with('vendor_details', 'file')->findAll($criteria);



        $j = 0;

        $list[$j++] = 'No!PO No!File No!Title!Supplier!Order Date!Status!Grand Total!Grand Total(BC)';



        $tot = 0;

        foreach ($model_order as $i => $model) {



            $status = '';

            if ($model->file->current_process_status == 'P_O') {

                $status = 'Order';
            } else if ($model->file->current_process_status == 'M_R') {

                $status = 'MR';
            } else if ($model->file->current_process_status == 'Q_C') {

                $status = 'QC';
            } else if ($model->file->current_process_status == 'P_I') {

                $status = 'Invoice';
            } else {

                $status = '';
            }

            if ($model->completed == 'P') {

                $status = 'MR(P)';
            }

            if ($model->completed == 'C') {

                $status = 'SC';
            }



            if ($model->order_date != '0000-00-00') {

                $orderdate = date("d/m/Y", strtotime($model->order_date));
            } else {

                $orderdate = " ";
            }



            $grand_total = $model->currencyname->currency_code . " " . Yii::app()->numberFormatter->formatCurrency($model->stock_grand_total + $model->nonstock_grandtotal, "");



            $model_currency = MasCurrency::model()->findByPk($model->currencyname->id);

            $grand_total = $model->stock_grand_total + $model->nonstock_grandtotal;

            $total_bc = $grand_total * $model_currency->exchange_rate;

            $total += $total_bc;



            $tot += $total_bc;



            $grand_total = Yii::app()->numberFormatter->formatCurrency($grand_total, " ");

            $total_bc = Yii::app()->numberFormatter->formatCurrency($total_bc, " ");



            $list[$j++] = ($i + 1) . '!' . $model->id . '!' . $model->file_id . '!' . $model->title . '!' . $model->vendor_details->vendor_name . '!' . $orderdate . '!' . $status . '!' . $grand_total . '!' . $total_bc;
        }

        $tot = Yii::app()->numberFormatter->formatCurrency($tot, " ");

        $list[$j++] = " " . '!' . " " . '!' . " " . '!' . " " . '!' . " " . '!' . " " . '!' . " " . '!' . " Total " . '!' . $tot;

        $j++;

        foreach ($list as $line) {

            fputcsv($file, explode('!', $line));
        }

        fclose($file);

        $filename = 'uploads/csvs/test.csv';

        //$filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';

        header('Content-Type: application/csv');

        header("Content-disposition: attachment; filename=\"purchaseOrderList.csv\"");

        readfile($filename);

        Yii::app()->end();

        return;
    }

    public function actionPrintIntransistExcel() {


        $model = new InventoryIndirectTransferItem();
        $from_warehouse = Yii::app()->request->getParam('from_warehouse');
        $transfer_from_date = Yii::app()->request->getParam('transfer_from_date');
        $transfer_to_date = Yii::app()->request->getParam('transfer_to_date');
        $transfer_no = Yii::app()->request->getParam('transfer_no');

        $file = fopen("uploads/csvs/test.csv", "w");

        $criteria = new CDbCriteria;
        $condition = 'parent.is_complete!="Y" ';
        ;
        if ($transfer_from_date != '') {
            $transfer_from_date = str_replace('/', '-', $transfer_from_date);
            $transfer_from_date = date('Y-m-d', strtotime($transfer_from_date));
            $condition .= ' AND parent.transfer_date >="' . $transfer_from_date . '"';
        }
        if ($transfer_to_date != '') {
            $transfer_to_date = str_replace('/', '-', $transfer_to_date);
            $transfer_to_date = date('Y-m-d', strtotime($transfer_to_date));
            $condition .= ' AND parent.transfer_date <="' . $transfer_to_date . '"';
        }
        if ($from_warehouse != '') {
            $condition .= ' AND parent.from_warehouse_id ="' . $from_warehouse . '"';
        }
        if ($transfer_no != '') {
            $condition .= ' AND parent.id ="' . $transfer_no . '"';
        }


        $total = 0;
        $model_order = InventoryIndirectTransferItem::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.id DESC'));

        $j = 0;

        $list[$j++] = 'No!Transfer No!From Warehouse!Intermediate Location!Transfer Date!Item!Description!Qty';

        foreach ($model_order as $i => $model) {

            $transferred_qty = $model->transfer_qty;
            $received_qty = $model->damaged_qty + $model->transferred_qty;
            $qty = $transferred_qty - $received_qty;
            if ($qty > 0) {
                if ($from_warehouse == '') {
                    $from_wh = $model->parent->warehouseFrom->warehouse_name;
                }

                if ($model->parent->transfer_date != '0000-00-00') {
                    $transfer_date = date("d/m/Y", strtotime($model->parent->transfer_date));
                }


                $list[$j++] = ($i + 1) . '!' . $model->parent->id . '!' . $from_wh . '!' . $model->parent->intermediate_location . '!' . $transfer_date . '!' . $model->item_name . '!' . $model->item_description . '!' . $qty;
            }
        }

        $j++;
        foreach ($list as $line) {
            fputcsv($file, explode('!', $line));
        }
        fclose($file);
        $filename = 'uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"intransistlist.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    public function actionCustomerNoSalesExcel() {




        $str_from_date = Yii::app()->request->getParam('str_from_date');
        $str_to_date = Yii::app()->request->getParam('str_to_date');
        //echo "$str_from_date";

        $file = fopen("uploads/csvs/test.csv", "w");
        //$criteria = new CDbCriteria;
        if ($str_to_date != '' && $str_from_date != '') {



            $query = 'CREATE OR REPLACE VIEW
                    view_customer_sale_report  AS  
                    SELECT
                    C.id AS customer_id,
                    C.customer_name AS customer_name
                    FROM
                    erp_customer C LEFT JOIN erp_invoice I ON C.id = I.company_id
                    WHERE invoice_date NOT BETWEEN "' . $str_from_date . '" AND "' . $str_to_date . '" AND C.isActive="Y" GROUP BY C.id';
            Yii::app()->db->createCommand($query)->execute();

            $SQL_current_year = "SELECT customer_id,customer_name FROM view_customer_sale_report ORDER BY customer_name";

            $model = Yii::app()->db->createCommand($SQL_current_year)->queryAll();
        } else {
            $model = array();
        }



        $count = count($model);

        $j = 0;
        $list[$j++] = 'No!Customer ID!Customer Name';

        if ($count > 0) {
            foreach ($model as $i => $model) {






                $list[$j++] = ($i + 1) . '!' . $model['customer_id'] . '!' . $model['customer_name'];
            }
        }


        $j++;
        foreach ($list as $line) {
            fputcsv($file, explode('!', $line));
        }
        fclose($file);
        $filename = 'uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"Customer_no_sales.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    public function actionPrintPurchaseInvoiceExcel() {

        $order_from_date = Yii::app()->request->getParam('order_from_date');

        $order_to_date = Yii::app()->request->getParam('order_to_date');

        $project_id = Yii::app()->request->getParam('project_id');

        $vendor_id = Yii::app()->request->getParam('vendor_id');



        $file = fopen("uploads/csvs/test.csv", "w");

        $criteria = new CDbCriteria;



        if (!empty($order_from_date)) {

            $order_from_date = str_replace('/', '-', $order_from_date);

            $order_from_date = date('Y-m-d', strtotime($order_from_date));

            $criteria->addCondition('t.invoice_date>="' . $order_from_date . '"', 'AND');
        }

        if (!empty($order_to_date)) {

            $order_to_date = str_replace('/', '-', $order_to_date);

            $order_to_date = date('Y-m-d', strtotime($order_to_date));

            $criteria->addCondition('t.invoice_date<="' . $order_to_date . '"', 'AND');
        }

        if (!empty($vendor_id)) {

            $criteria->addCondition('t.vendor_id="' . $vendor_id . '"', 'AND');
        }



        $model_invoice = PurchasingInvoice::model()->with('vendor_details')->findAll($criteria);



        $j = 0;

        $list[$j++] = 'No!File No!PO No!Inv No!Supplier!Invoice Date!Value!Value(BC)';



        $tot = 0;

        foreach ($model_invoice as $i => $model) {







            if ($model->invoice_date != '0000-00-00') {

                $invoicedate = date("d/m/Y", strtotime($model->invoice_date));
            } else {

                $invoicedate = " ";
            }



            $grand_total = $model->currencyname->currency_code . " " . Yii::app()->numberFormatter->formatCurrency($model->grand_total, "");



            $model_currency = MasCurrency::model()->findByPk($model->currencyname->id);

            $grand_total = $model->grand_total;

            $total_bc = $grand_total * $model_currency->exchange_rate;

            $total += $total_bc;



            $tot += $total_bc;



            $total_bc = Yii::app()->numberFormatter->formatCurrency($total_bc, " ");

            $grand_total = Yii::app()->numberFormatter->formatCurrency($grand_total, " ");



            $list[$j++] = ($i + 1) . '!' . $model->file_id . '!' . $model->po_id . '!' . $model->id . '!' . $model->vendor_details->vendor_name . '!' . $invoicedate . '!' . $grand_total . '!' . $total_bc;
        }

        $tot = Yii::app()->numberFormatter->formatCurrency($tot, " ");

        $list[$j++] = " " . '!' . " " . '!' . " " . '!' . " " . '!' . " " . '!' . " " . '!' . " Total " . '!' . $tot;

        $j++;

        foreach ($list as $line) {

            fputcsv($file, explode('!', $line));
        }

        fclose($file);

        $filename = 'uploads/csvs/test.csv';

        //$filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';

        header('Content-Type: application/csv');

        header("Content-disposition: attachment; filename=\"purchaseInvoiceList.csv\"");

        readfile($filename);

        Yii::app()->end();

        return;
    }

    public function actionPrintPurchaseMaterialReceiptsExcel() {

        $order_from_date = Yii::app()->request->getParam('order_from_date');

        $order_to_date = Yii::app()->request->getParam('order_to_date');

        //$project_id = Yii::app()->request->getParam('project_id');

        $vendor_id = Yii::app()->request->getParam('vendor_id');

        $qcchecked = Yii::app()->request->getParam('qcchecked');



        $file = fopen("uploads/csvs/test.csv", "w");

        $criteria = new CDbCriteria;



        if (!empty($order_from_date)) {

            $order_from_date = str_replace('/', '-', $order_from_date);

            $order_from_date = date('Y-m-d', strtotime($order_from_date));

            $criteria->addCondition('purchaseorder.order_date>="' . $order_from_date . '"', 'AND');
        }

        if (!empty($order_to_date)) {

            $order_to_date = str_replace('/', '-', $order_to_date);

            $order_to_date = date('Y-m-d', strtotime($order_to_date));

            $criteria->addCondition('purchaseorder.order_date<="' . $order_to_date . '"', 'AND');
        }

        if (!empty($vendor_id)) {

            $criteria->addCondition('t.vendor_id="' . $vendor_id . '"', 'AND');
        }

        if (!empty($project_id)) {

            $criteria->addCondition('t.project_id="' . $project_id . '"', 'AND');
        }

        if (!empty($qcchecked)) {

            $criteria->addCondition('t.qcchecked="' . $qcchecked . '"');
        }



        $model_met_receipt = PurchasingMaterialreceipt::model()->with('vendor_details', 'purchaseorder')->findAll($criteria);



        $j = 0;

        $list[$j++] = 'No!File No!PO No!MRV. No!MRV Date!Supplier Name!QC';



        foreach ($model_met_receipt as $i => $model) {







            if ($model->mrv_receipt_date != '0000-00-00') {

                $mrv_date = date("d/m/Y", strtotime($model->mrv_receipt_date));
            } else {

                $mrv_date = " ";
            }



            if ($model->qcchecked == 'Y') {

                $qc_status = "Completed";
            } else {

                $qc_status = "Partial";
            }



            $list[$j++] = ($i + 1) . '!' . $model->file_id . '!' . $model->po_id . '!' . $model->id . '!' . $mrv_date . '!' . $model->vendor_details->vendor_name . '!' . $qc_status;
        }

        $j++;

        foreach ($list as $line) {

            fputcsv($file, explode('!', $line));
        }

        fclose($file);

        $filename = 'uploads/csvs/test.csv';

        //$filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';

        header('Content-Type: application/csv');

        header("Content-disposition: attachment; filename=\"PurchaseMaterialReceiptsList.csv\"");

        readfile($filename);

        Yii::app()->end();

        return;
    }

    public function actionPrintZeroBasePriceProductExcel() {









        $part_no = Yii::app()->request->getParam('partno');





        //print_r($part_no);



        $file = fopen("uploads/csvs/test.csv", "w");

        $criteria = new CDbCriteria;



        $condition = '';
        ;

        if ($part_no != '') {



            $condition .= 'AND store.part_number LIKE "%' . $part_no . '%"';
        }





        $sql_query = "SELECT store.id,store.part_number,store.description FROM `erp_store` AS store 

                            LEFT JOIN erp_product_location_details AS loc ON store.id=loc.product_id 

                            WHERE store.rate= 0 AND store.inventory_item_type = 1 AND store.isActive = 'Y' $condition group by loc.product_id";



        $total = 0;

        $model = Yii::app()->db->createCommand($sql_query)->queryAll();

        $count = count(Yii::app()->db->createCommand($sql_query)->queryAll());



        $j = 0;

        $list[$j++] = 'No!Product!Description';



        if ($count > 0) {

            foreach ($model as $i => $model) {













                $list[$j++] = ($i + 1) . '!' . $model['part_number'] . '!' . $model['description'];
            }
        }





        $j++;

        foreach ($list as $line) {

            fputcsv($file, explode('!', $line));
        }

        fclose($file);

        $filename = 'uploads/csvs/test.csv';

        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';

        header('Content-Type: application/csv');

        header("Content-disposition: attachment; filename=\"Zero_base_costprice.csv\"");

        readfile($filename);

        Yii::app()->end();

        return;
    }

    /*    arul on 3-1-2018 end */

    /*    arul on 4-1-2018 */

    public function actionPrintPurchaseDebiteNoteExcel() {

        $order_from_date = Yii::app()->request->getParam('order_from_date');

        $order_to_date = Yii::app()->request->getParam('order_to_date');

        $vendor_id = Yii::app()->request->getParam('vendor_id');



        $file = fopen("uploads/csvs/test.csv", "w");

        $criteria = new CDbCriteria;



        if (!empty($order_from_date)) {

            $order_from_date = str_replace('/', '-', $order_from_date);

            $order_from_date = date('Y-m-d', strtotime($order_from_date));

            $criteria->addCondition('purchaseorder.order_date>="' . $order_from_date . '"', 'AND');
        }

        if (!empty($order_to_date)) {

            $order_to_date = str_replace('/', '-', $order_to_date);

            $order_to_date = date('Y-m-d', strtotime($order_to_date));

            $criteria->addCondition('purchaseorder.order_date<="' . $order_to_date . '"', 'AND');
        }

        if (!empty($vendor_id)) {

            $criteria->addCondition('t.vendor_id="' . $vendor_id . '"', 'AND');
        }



        //$model_met_receipt = PurchasingMaterialreceipt::model()->with('vendor_details','purchaseorder')->findAll($criteria);

        $model_debitnote = Purchasingdebitnote::model()->with('vendor_details', 'purchaseinvoice.purchaseorder')->findAll($criteria);



        $j = 0;



        $grand_total = 0;

        $list[$j++] = 'No!File No!Inv.No!CRN.No.!Supplier!Reason!Dbt.Date!Value!Value(BC)';



        foreach ($model_debitnote as $i => $model) {







            if ($model->debited_date != '0000-00-00') {

                $debitnote_date = date("d/m/Y", strtotime($model->debited_date));
            } else {

                $debitnote_date = " ";
            }



            $tot = Yii::app()->numberFormatter->formatCurrency($model->debited_amount, "");



            $model_currency = MasCurrency::model()->findByPk($model->currency);

            $total_bc = $model->debited_amount * $model_currency->exchange_rate;

            $total += $total_bc;



            $grand_total += $total_bc;



            $total_bc = Yii::app()->numberFormatter->formatCurrency($total_bc, " ");





            $list[$j++] = ($i + 1) . '!' . $model->file_id . '!' . $model->purchasing_invoice_id . '!' . $model->id . '!' . $model->vendor_details->vendor_name . '!' . $model->reason . '!' . $debitnote_date . '!' . $tot . '!' . $total_bc;
        }

        $grand_total = Yii::app()->numberFormatter->formatCurrency($grand_total, " ");

        $list[$j++] = " " . '!' . '!' . " " . '!' . " " . '!' . " " . '!' . " " . '!' . " " . '!' . " Total " . '!' . $grand_total;



        $j++;

        foreach ($list as $line) {

            fputcsv($file, explode('!', $line));
        }

        fclose($file);

        $filename = 'uploads/csvs/test.csv';

        //$filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';

        header('Content-Type: application/csv');

        header("Content-disposition: attachment; filename=\"PurchaseDebiteNoteList.csv\"");

        readfile($filename);

        Yii::app()->end();

        return;
    }

    public function actionPrintPurchaseOrderedListItemsExcel() {



        $brand_id = Yii::app()->request->getParam('brand_id');



        $file = fopen("uploads/csvs/test.csv", "w");

        $criteria = new CDbCriteria;



        $condition = "file.current_process_status = 'Q' OR file.current_process_status = 'O' OR file.current_process_status = 'PD' OR file.current_process_status = 'PI'";

        ;

        $model_order_item = new OrderItem();

        if ($brand_id > 0) {

            $condition .= ' AND product.brand_class_id ="' . $brand_id . '"';
        }



        $model_order_item = $model_order_item->with('order', 'product', 'parent.file')->findAll(array('select' => 'SUM(quantity) AS quantity,SUM(received) AS received,product_id,product.part_number AS product_name,product.description AS descripion', 'condition' => $condition, 'group' => 't.product_id', 'order' => 'product_name ASC'));



        $j = 0;



        $grand_total = 0;

        $list[$j++] = 'No!Part no!Description!Tot.Ordered.!Tot.Delivered!Tot.Required!In Stock!Op.PurchaseOrder!To Be Purchased';



        foreach ($model_order_item as $i => $model) {







            $rem_qty = $model->quantity - $model->received;

            $model_store = new ProductLocation();

            $stk_qty = $model_store->find(array('select' => 'SUM(quantity) AS quantity', 'condition' => 'stock_id = ' . $model->product_id))->quantity;

            $po_qty = 0;

            $qty_purchased = $rem_qty - $stk_qty - $po_qty;





            if ($qty_purchased > 0) {



                $total_order = number_format((float) $model->quantity, 2, '.', '');

                $total_delivered = number_format((float) $model->received, 2, '.', '');

                $total_required = number_format((float) $rem_qty, 2, '.', '');

                $Stock = number_format((float) $stk_qty, 2, '.', '');

                $purchase_order = number_format((float) $po_qty, 2, '.', '');

                $to_be_purchased = number_format((float) $qty_purchased, 2, '.', '');



                $list[$j++] = ($i + 1) . '!' . $model->product->part_number . '!' . $model->product->description . '!' . $total_order . '!' . $total_delivered . '!' . $total_required . '!' . $Stock . '!' . $purchase_order . '!' . $to_be_purchased;
            }
        }

        $j++;

        foreach ($list as $line) {

            fputcsv($file, explode('!', $line));
        }

        fclose($file);

        $filename = 'uploads/csvs/test.csv';

        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';

        header('Content-Type: application/csv');

        header("Content-disposition: attachment; filename=\"Purchase_Listof_Items.csv\"");

        readfile($filename);

        Yii::app()->end();

        return;
    }

    public function actionPrintNetPurchaseExcel() {

        $from_date = Yii::app()->request->getParam('from_date');

        $to_date = Yii::app()->request->getParam('to_date');

        $inv_type = Yii::app()->request->getParam('inv_type');

        $vendor_id = Yii::app()->request->getParam('vendor_id');



        $filename = 'netpurchase.xls';



        $condition = '1=1';

        ;

        if ($from_date != '') {

            $from_date = str_replace('/', '-', $from_date);

            $from_date = date('Y-m-d', strtotime($from_date));

            $condition .= ' AND t.invoice_date >="' . $from_date . '"';
        }

        if ($to_date != '') {

            $to_date = str_replace('/', '-', $to_date);

            $to_date = date('Y-m-d', strtotime($to_date));

            $condition .= ' AND t.invoice_date <="' . $to_date . '"';
        }



        if ($vendor_id != '') {

            $condition .= ' AND t.vendor_id ="' . $vendor_id . '"';
        }

        if ($inv_type != '') {



            $condition .= ' AND t.invoice_type ="' . $inv_type . '"';
        }



        $model_invoice = PurchasingInvoice::model()->with('vendor_details')->findAll(array('condition' => $condition, 'order' => 't.id DESC'));



        $total = 0;

        $without_vat = 0;

        $net_totalamt = 0;



        $data = '<html>

                    <head>

                        <style>

                            table{

                                width:100%;

                            }

                            .head{

                                background-color : yellow;

                                font-weight: bold;

                                font-size: 14px;

                            }

                            .total{

                                text-align: right;

                                font-weight: bold;

                                font-size: 14px;

                            }

                        </style>

                    </head>

                    <body>

                        <table border=1>

                            <thead>

                                <tr>

                                    <th class="head">No</th>

                                    <th class="head">Inv.Date</th>

                                    <th class="head">Inv.No</th>

                                    <th class="head">File No</th>

                                    <th class="head">Supplier</th>

                                    <th class="head">Inv.VAT(BC)</th>

                                    <th class="head">Inv.Amt w/o VAT(BC)</th>

                                    <th class="head">Inv.Amt(BC)</th>

                                    <th class="head">DN VAT(BC)</th>

                                    <th class="head">DN Amt(BC)</th>

                                    <th class="head">Net VAT(BC)</th>

                                    <th class="head">Net Amount(BC)</th>

                                </tr>

                            </thead>

                            <tbody>';



        foreach ($model_invoice as $i => $model) {


            //$model_debit = Purchasingdebitnote::model()->find(array('select'=>'IFNULL(SUM(debited_amount),0)as debited_amount,IFNULL(SUM(total_tax_amount),0)as total_tax_amount','condition'=>'t.purchasing_invoice_id='.$model->id));

            $exchange_rate = $model->exchange_rate;

            $amount = $model->grand_total;

            $without_vat += ($model->grand_total - $model->total_tax_amount) * $exchange_rate;

            $debit = ($model_debit->debited_amount) * $exchange_rate;

            $total_bc = $amount * $exchange_rate;

            $tax = $model->total_tax_amount * $exchange_rate;

            $total_tax += $tax;

            $net_tax = $tax - ($model_debit->total_tax_amount * $exchange_rate);
            $total_cn_tax += ($model_debit->total_tax_amount * $exchange_rate);

            $total += $total_bc;

            $cn_total += $debit;

            $net_amount = $total_bc - (float) ($model_debit->debited_amount * $exchange_rate);



            $data .= '<tr>

                            <td>' . ($i + 1) . '</td>

                            <td>' . date("d/m/Y", strtotime($model->invoice_date)) . '</td>

                            <td>' . $model->id . '</td>

                            <td>' . $model->file_id . '</td>

                            <td class="nw">' . $model->vendor_details->vendor_name . '</td>

                            <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($tax, " ") . '</td>

                            <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(($model->grand_total - $model->total_tax_amount) * $exchange_rate, " ") . '</td>

                            <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($total_bc, " ") . '</td>

                            <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($model_debit->total_tax_amount * $exchange_rate, " ") . '</td>

                            <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>

                            <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($net_tax, " ") . '</td>

                            <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($net_amount, " ") . '</td>



                        </tr>';



            $net_totalamt += $net_amount;

            $tot_tax += $tax;
        }







        $data .= ' <tr>

                        <td></td><td></td><td></td><td></td><td></td>

                        <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency($total_tax, " ") . '</b> </td>

                        <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency($without_vat, " ") . '</b> </td>

                        <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency($total, " ") . '</b> </td>

                        <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency($total_cn_tax, " ") . '</b> </td>

                        <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency($cn_total, " ") . '</b> </td>

                        <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency($tot_tax - $total_cn_tax, " ") . '</b> </td>

                        <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency($net_totalamt, " ") . '</b> </td>

                    </tr>';



        $data .= '      </tbody>

                    </table>

                </body>

            </html>';

        header("Content-type: application/vnd.ms-excel");

        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");

        echo $data;

        Yii::app()->end();

        return;
    }

    public function actionPrintServiceStoreExcel() {

        $model = new ServiceStoreDetails();

        $reference = Yii::app()->request->getParam('reference');
        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');

        $file = fopen("uploads/csvs/test.csv", "w");

        $criteria = new CDbCriteria;
        $condition = ' 1=1 ';
        if ($reference != '') {
            $condition .= " AND servicestore_details.reference LIKE '%" . $reference . "%' ";
        }
        if ($from_date != '' && $to_date != '') {
            $from_date = str_replace('/', '-', $from_date);
            $from_date = date('Y-m-d', strtotime($from_date));

            $to_date = str_replace('/', '-', $to_date);
            $to_date = date('Y-m-d', strtotime($to_date));

            $condition .= " AND servicestore_details.transfer_date >= '" . $from_date . "' ";
            $condition .= " AND servicestore_details.transfer_date <= '" . $to_date . "' ";
        }
        $model_order = ServiceStoreDetails::model()->with('servicestore_details')->findAll(array(
            'condition' => $condition
        ));

        $j = 0;

        $list[$j++] = 'No!Transfer No!Transfer Date!Reference!Item!Description!Qty!Unit!';

        foreach ($model_order as $i => $model) {

            // $date1=date('d-m-Y', strtotime($model->servicestore_details->transfer_date));
            // if ($model->netStockQuantity + $model->netnonStockQuantity > $model->file->receivedQuantity) {
            $list[$j++] = ($i + 1) . '!' . $model->servicestore_details->id . '!' . $model->date('d-m-Y', strtotime($model->servicestore_details->transfer_date)) . '!' . $model->servicestore_details->reference . '!' . $model->product->part_number . '!' . $model->product->description . '!' . number_format((float) $model->quantity, 2, '.', '') . '!' . $model->unitdetails->name;
            //}*/
        }

        $j++;
        foreach ($list as $line) {
            fputcsv($file, explode('!', $line));
        }
        fclose($file);
        $filename = 'uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"servicestorelist.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    public function actionPrintPurchaseRegisterExcel() {

        $order_from_date = Yii::app()->request->getParam('order_from_date');

        $order_to_date = Yii::app()->request->getParam('order_to_date');

        $po_id = Yii::app()->request->getParam('po_id');

        $project_id = Yii::app()->request->getParam('project_id');



        $file = fopen("uploads/csvs/test.csv", "w");

        $criteria = new CDbCriteria;



        if ($project_id > 0) {

            $arr_proj = MasProject::model()->findAll(array('condition' => 'isActive =  "Y" AND id=' . $project_id));
        } else {

            $arr_proj = MasProject::model()->findAll(array('condition' => 'isActive =  "Y"'));
        }

        $condition = '1=1';

        if ($order_from_date != '') {

            $order_from_date = str_replace('/', '-', $order_from_date);

            $order_from_date = date('Y-m-d', strtotime($order_from_date));

            $condition .= ' AND t.invoice_date >="' . $order_from_date . '"';
        }

        if ($order_to_date != '') {

            $order_to_date = str_replace('/', '-', $order_to_date);

            $order_to_date = date('Y-m-d', strtotime($order_to_date));

            $condition .= ' AND t.invoice_date <="' . $order_to_date . '"';
        }



        if ($po_id != '') {

            $condition .= ' AND t.po_id ="' . $po_id . '"';
        }

        $j = 0;



        if (!empty($arr_proj)) {

            foreach ($arr_proj as $i => $eachproject) {

                $listinvoice = PurchasingInvoice::model()->findAll(array('condition' => 'project_id="' . $eachproject->id . '" AND ' . $condition));

                $grand_total = 0;

                $list[$j++] = $eachproject->project_title . '!' . '!' . " " . '!' . " " . '!' . " " . '!';



                if (!empty($listinvoice)) {

                    foreach ($listinvoice as $each_invoice) {

                        $proj_inv_total = 0;



                        $list[$j++] = "File No : " . $each_invoice->file_id . '!' . '!' . " " . '!' . " " . '!' . " " . '!';

                        $list[$j++] = "Purchase Order No : " . $each_invoice->po_id . '!' . '!' . " " . '!' . " " . '!' . " " . '!';

                        $list[$j++] = "Purchase Invoice No : " . $each_invoice->id . '!' . '!' . " " . '!' . " " . '!' . " " . '!';

                        $list[$j++] = "Purchase Invoice Date : " . $each_invoice->invoice_date . '!' . '!' . " " . '!' . " " . '!' . " " . '!';

                        $list[$j++] = "Vendor : " . $each_invoice->vendor_details->vendor_name . '!' . '!' . " " . '!' . " " . '!' . " " . '!';





                        $arr_items = PurchasingInvoiceItem::model()->findAll(array('condition' => 'purchasing_invoice_id=' . $each_invoice->id));

                        $list[$j++] = 'Items!Description!Quantity!Rate.!Amount';

                        foreach ($arr_items as $each_item) {



                            $rate = $each_item->rate * $each_invoice->exchange_rate;

                            $amount = $rate * $each_item->quantity;

                            $proj_inv_total += $amount;

                            $grand_total += $amount;



                            $list[$j++] = $each_item->product->part_number . '!' . $each_item->description . '!' . $each_item->quantity . '!' . $rate . '!' . $amount;
                        }

                        $list[$j++] = " " . '!' . '!' . " " . '!' . " " . " Total " . '!' . Yii::app()->numberFormatter->formatCurrency($proj_inv_total, "");

                        if ($grand_total > 0) {



                            $list[$j++] = " " . '!' . '!' . " " . '!' . " " . " Grand Total " . '!' . Yii::app()->numberFormatter->formatCurrency($grand_total, "");
                        }
                    }
                }
            }



            $grand_total = 0;

            $listinvoice = PurchasingInvoice::model()->findAll(array('condition' => $condition . ' AND project_id=0 '));

            if (!empty($listinvoice)) {



                $list[$j++] = "No Project Title" . '!' . '!' . " " . '!' . " " . '!' . " " . '!';



                foreach ($listinvoice as $each_invoice) {



                    $proj_inv_total = 0;

                    $list[$j++] = "File No : " . $each_invoice->file_id . '!' . '!' . " " . '!' . " " . '!' . " " . '!';

                    $list[$j++] = "Purchase Order No : " . $each_invoice->po_id . '!' . '!' . " " . '!' . " " . '!' . " " . '!';

                    $list[$j++] = "Purchase Invoice No : " . $each_invoice->id . '!' . '!' . " " . '!' . " " . '!' . " " . '!';

                    $list[$j++] = "Purchase Invoice Date : " . $each_invoice->invoice_date . '!' . '!' . " " . '!' . " " . '!' . " " . '!';

                    $list[$j++] = "Vendor : " . $each_invoice->vendor_details->vendor_name . '!' . '!' . " " . '!' . " " . '!' . " " . '!';



                    $arr_items = PurchasingInvoiceItem::model()->findAll(array('condition' => 'purchasing_invoice_id=' . $each_invoice->id));



                    $list[$j++] = 'Items!Description!Quantity!Rate.!Amount';



                    foreach ($arr_items as $each_item) {

                        $rate = $each_item->rate * $each_invoice->exchange_rate;

                        $amount = $rate * $each_item->quantity;

                        $proj_inv_total += $amount;

                        $grand_total += $amount;



                        $list[$j++] = $each_item->product->part_number . '!' . $each_item->description . '!' . $each_item->quantity . '!' . $rate . '!' . $amount;
                    }

                    $list[$j++] = " " . '!' . '!' . " " . '!' . " " . " Total " . '!' . Yii::app()->numberFormatter->formatCurrency($proj_inv_total, "");

                    if ($grand_total > 0) {



                        $list[$j++] = " " . '!' . '!' . " " . '!' . " " . " Grand Total " . '!' . Yii::app()->numberFormatter->formatCurrency($grand_total, "");
                    }
                }
            }
        } else {



            $grand_total = 0;

            $listinvoice = PurchasingInvoice::model()->findAll(array('condition' => $condition . ' AND project_id=0 '));

            if (!empty($listinvoice)) {



                $list[$j++] = "No Project Title" . '!' . '!' . " " . '!' . " " . '!' . " " . '!';

                foreach ($listinvoice as $each_invoice) {

                    $proj_inv_total = 0;



                    $list[$j++] = "File No : " . $each_invoice->file_id . '!' . '!' . " " . '!' . " " . '!' . " " . '!';

                    $list[$j++] = "Purchase Order No : " . $each_invoice->po_id . '!' . '!' . " " . '!' . " " . '!' . " " . '!';

                    $list[$j++] = "Purchase Invoice No : " . $each_invoice->id . '!' . '!' . " " . '!' . " " . '!' . " " . '!';

                    $list[$j++] = "Purchase Invoice Date : " . $each_invoice->invoice_date . '!' . '!' . " " . '!' . " " . '!' . " " . '!';

                    $list[$j++] = "Vendor : " . $each_invoice->vendor_details->vendor_name . '!' . '!' . " " . '!' . " " . '!' . " " . '!';



                    $arr_items = PurchasingInvoiceItem::model()->findAll(array('condition' => 'purchasing_invoice_id=' . $each_invoice->id));



                    $list[$j++] = 'Items!Description!Quantity!Rate.!Amount';



                    foreach ($arr_items as $each_item) {

                        $rate = $each_item->rate * $each_invoice->exchange_rate;

                        $amount = $rate * $each_item->quantity;

                        $proj_inv_total += $amount;

                        $grand_total += $amount;



                        $list[$j++] = $each_item->product->part_number . '!' . $each_item->description . '!' . $each_item->quantity . '!' . $rate . '!' . $amount;
                    }

                    $list[$j++] = " " . '!' . '!' . " " . '!' . " " . " Total " . '!' . Yii::app()->numberFormatter->formatCurrency($proj_inv_total, "");

                    if ($grand_total > 0) {



                        $list[$j++] = " " . '!' . '!' . " " . '!' . " " . " Grand Total " . '!' . Yii::app()->numberFormatter->formatCurrency($grand_total, "");
                    }
                }
            }
        }



        if (empty($list)) {

            $list[$j++] = " No Details " . '!' . '!' . " " . '!' . " " . " " . '!';
        }



        $j++;

        foreach ($list as $line) {

            fputcsv($file, explode('!', $line));
        }

        fclose($file);

        $filename = 'uploads/csvs/test.csv';

        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';

        header('Content-Type: application/csv');

        header("Content-disposition: attachment; filename=\"PurchaseRegisterList.csv\"");

        readfile($filename);

        Yii::app()->end();

        return;
    }

    public function actionPrintPurchaseOrderPendingReport() {



        $model = new PurchasingOrder();



        $order_from_date = Yii::app()->request->getParam('order_from_date');

        $order_to_date = Yii::app()->request->getParam('order_to_date');

        $vendor_id = Yii::app()->request->getParam('vendor_id');



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_purchasependingorder_list', array('model' => $model, 'order_from_date' => $order_from_date, 'order_to_date' => $order_to_date, 'vendor_id' => $vendor_id), false, true);
    }

    public function actionPrintPurchaseOrderPendingExcel() {

        $order_from_date = Yii::app()->request->getParam('order_from_date');

        $order_to_date = Yii::app()->request->getParam('order_to_date');

        $vendor_id = Yii::app()->request->getParam('vendor_id');

        $project_id = Yii::app()->request->getParam('project_id');



        $file = fopen("uploads/csvs/test.csv", "w");



        $criteria = new CDbCriteria;

        $condition = 't.completed != "Y"';

        ;

        if ($order_from_date != '') {

            $order_from_date = str_replace('/', '-', $order_from_date);

            $order_from_date = date('Y-m-d', strtotime($order_from_date));

            $condition .= ' AND t.order_date >="' . $order_from_date . '"';
        }

        if ($order_to_date != '') {

            $order_to_date = str_replace('/', '-', $order_to_date);

            $order_to_date = date('Y-m-d', strtotime($order_to_date));

            $condition .= ' AND t.order_date <="' . $order_to_date . '"';
        }



        if ($vendor_id != '') {

            $condition .= ' AND t.vendor_id ="' . $vendor_id . '"';
        }

        // if ($project_id != '') {
        // $condition .= ' AND t.project_id ="' . $project_id . '"';
        //}



        $total = 0;

        $model_order = PurchasingOrder::model()->with('vendor_details', 'file')->findAll(array('condition' => $condition));



        $j = 0;



        $list[$j++] = 'No!PO No!File No!Supplier!Order Date!Req Date!Exp Del Date!Ordered(Value)!Recieved(Value)!Pending(Value)! ';



        foreach ($model_order as $i => $model) {



            if ($model->order_date != '0000-00-00') {

                $order_date = date("d/m/Y", strtotime($model->order_date));
            } else {

                $order_date = " ";
            }

            if ($model->required_date != '0000-00-00') {

                $required_date = date("d/m/Y", strtotime($model->required_date));
            } else {

                $required_date = " ";
            }

            if ($model->expected_delivery_date != '0000-00-00') {

                $expected_date = date("d/m/Y", strtotime($model->expected_delivery_date));
            } else {

                $expected_date = " ";
            }

            $need_quantity = $model->stock_grand_total * $model->exchange_rate;



            $sql = 'SELECT SUM(`exchange_rate` *`grand_total` ) FROM `erp_purchasinginvoice` WHERE `file_id` = ' . $model->file_id;

            $receivedQuantity = Yii::app()->db->createCommand($sql)->queryScalar();

            $pendinQuantity = $need_quantity - $receivedQuantity;



            // if ($model->netStockQuantity + $model->netnonStockQuantity > $model->file->receivedQuantity) {

            $list[$j++] = ($i + 1) . '!' . $model->id . '!' . $model->file_id . '!' . $model->vendor_details->vendor_name . '!' . $order_date . '!' . $required_date . '!' . $expected_date . '!' . number_format((float) $need_quantity, 2, '.', '') . '!' . number_format((float) $receivedQuantity, 2, '.', '') . '!' . number_format((float) $pendinQuantity, 2, '.', '');

            //}*/
        }



        $j++;

        foreach ($list as $line) {

            fputcsv($file, explode('!', $line));
        }

        fclose($file);

        $filename = 'uploads/csvs/test.csv';

        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';

        header('Content-Type: application/csv');

        header("Content-disposition: attachment; filename=\"PurchasePendingOrderList.csv\"");

        readfile($filename);

        Yii::app()->end();

        return;
    }

    public function actionPrintInventoryListExcel() {



        $type = (int) Yii::app()->request->getParam('type');

        $active = Yii::app()->request->getParam('active');

        $part_no = Yii::app()->request->getParam('part_no');

        $generic_id = (int) Yii::app()->request->getParam('generic_id');

        $tax_code = Yii::app()->request->getParam('tax_code');

        $brand_id = (int) Yii::app()->request->getParam('brand_id');

        $having_stock = (int) Yii::app()->request->getParam('having_stock');

        $stockFlag = ( $having_stock == 1 ) ? true : false;

        $condition = '1=1';
        if ($active != "") {
            $condition .= " AND isActive = '{$active}' ";
        }
        if ($type > 0)
            $condition .= ' AND type =' . $type;

        if ($generic_id > 0)
            $condition .= ' AND generic_id=' . $generic_id;

        if ($tax_code != "")
            $condition .= ' AND tax_code=' . $tax_code;

        if ($brand_id > 0)
            $condition .= ' AND brand=' . $brand_id;

        if ($part_no != '')
            $condition .= ' AND part_number LIKE "%' . $part_no . '%"';


        $model = Yii::app()->db->createCommand('SELECT * FROM view_all_stock_items WHERE ' . $condition . ' ORDER BY part_number')->queryAll();
        $total = Yii::app()->db->createCommand('SELECT (SUM(in_qty)-SUM(out_qty))*rate AS total FROM view_all_stock_items WHERE ' . $condition)->queryScalar();


        $filename = 'inventorylist' . date('dmYhis') . '.xls';

        $data = '<html>

                    <head>

                        <style>

                            table{

                                width:100%;

                            }

                            .head{

                                background-color : yellow;

                                font-weight: bold;

                                font-size: 14px;

                            }

                            .total{

                                text-align: right;

                                font-weight: bold;

                                font-size: 14px;

                            }

                        </style>

                    </head>

                    <body>

                        <table border=1>

                            <thead>

                                <th>No</th>

                                <th>Part Number</th>

                                <th>Description</th>

                                <th>Generic</th>

                                <th>Brand /Class</th>

                                <th>Type</th>

                                <th>Tax Code</th>
                                

                                <th>Quantity</th>

                                <th>Unit</th>

                                <th>Rate</th>

                                <th>Value</th>

                            </thead>

                            <tbody>';

        foreach ($model as $i => $row) {
            $qty =$row['in_qty']-$row['out_qty'];


            if (!$stockFlag) {

                if ($row['type'] == 'I') {

                    $type = "Stock";
                } else if ($row['type'] == 'S') {

                    $type = "Service";
                }

                $eachValue = round(( $qty * $row['rate']), 4);

                $data .= '<tr>

                                <td>' . ($i + 1) . '</td>

                                <td>' . $row['part_number'] . '</td>

                                <td>' . $row['description'] . '</td>

                                <td>' . $row['generic_name'] . '</td>

                                <td>' . $row['brand'] . '</td>

                                <td>' . $type . '</td>

                                <td>' . $row['tax_code'] . '%</td>
                               
                                <td class="text-right">' . $qty . '</td>

                                <td>' . $row['unit'] . '</td>

                                <td class="text-right">' . $row['rate'] . '</td>

                                <td class="text-right">' . number_format((float) $eachValue, 4, '.', '') . '</td>

                            </tr>';
            } else {

                if ($qty > 0) {
                    $eachValue = round(( $qty * $row['rate']), 4);
                    $data .= '<tr>

                                    <td>' . ($i + 1) . '</td>

                                    <td>' . $row['part_number'] . '</td>

                                    <td>' . $row['description'] . '</td>

                                    <td>' . $row['generic_name'] . '</td>

                                    <td>' . $row['brand'] . '</td>

                                    <td>' . $type . '</td>

                                    <td>' . $row['tax_code'] . '%</td>

                                    
                                    <td class="text-right">' . $row['quantity'] . '</td>

                                    <td>' . $row['unit'] . '</td>

                                    <td class="text-right">' . $row['rate'] . '</td>

                                    <td class="text-right">' . number_format((float) $eachValue, 4, '.', '') . '</td>

                                </tr>';
                }
            }
        }



        $data .= '      </tbody>

                        </table>

                    </body>

                </html>';



        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");

        echo $data;

        Yii::app()->end();

        return;
    }

    public function actionPrintJoborderListExcel() {

        $model = new JobOrder();

        $filter_start_date = Yii::app()->request->getParam('filter_start_date');

        $filter_job_no = Yii::app()->request->getParam('filter_job_no');

        $filter_customer = Yii::app()->request->getParam('filter_customer');

        $filter_agent = Yii::app()->request->getParam('filter_agent');

        $filter_job_order_priority = Yii::app()->request->getParam('filter_job_order_priority');

        $filter_end_date = Yii::app()->request->getParam('filter_end_date');

        $filter_job_order_status = Yii::app()->request->getParam('filter_job_order_status');
        
         $filter_job_order_transport_type = Yii::app()->request->getParam('filter_job_order_transport_type');

        $filename = 'job_order' . date('dmYhis') . '.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderpartial('application.views.front.reports.excel.job_order', array('filter_start_date' => $filter_start_date, 'filter_end_date' => $filter_end_date, 'filter_job_no' => $filter_job_no, 'filter_customer' => $filter_customer, 'filter_agent' => $filter_agent, 'filter_job_order_priority' => $filter_job_order_priority, 'filter_job_order_transport_type' => $filter_job_order_transport_type,'filter_job_order_status'=>$filter_job_order_status,'filter_job_order_transport_type' =>$filter_job_order_transport_type, 'model' => $model, 'title' => $title), false, true);
        Yii::app()->end();


        return;
    }

    public function actionPrintInventoryMinStockExcel() {

        $brand_name = Yii::app()->request->getParam('brand_name');

        $generic_name = Yii::app()->request->getParam('generic_name');



        $file = fopen("uploads/csvs/test.csv", "w");

        $condition = '1=1';

        ;



        if ($generic_name != '') {

            $condition .= ' AND t.generic_name LIKE "%' . $generic_name . '%"';
        }

        if ($brand_name != '') {

            $condition .= ' AND t.brand_class_id LIKE "%' . $brand_name . '%"';
        }

        $model_inventory = Store::model()->findAll(array('condition' => $condition, 'order' => 'description asc'));



        $j = 0;



        $list[$j++] = 'No!Part Number!Description!Generic Name!Brand!Unit!Total Quantity!Re Order Level';



        foreach ($model_inventory as $i => $model) {





            $total_quantity = $model->total_quantity;

            $re_order_level = $model->re_order_level;

            if ($total_quantity != '0') {

                if ($total_quantity <= $re_order_level) {



                    $model_generic = MasGeneric::model()->find(array('condition' => 't.id="' . $model->generic_name . '"'));

                    $list[$j++] = ($i + 1) . '!' . $model->part_number . '!' . $model->description . '!' . $model->generic_name . '!' . $model->brand_detail->product_class . '!' . $model->unit->symbol . '!' . $model->total_quantity . '!' . $model->re_order_level;
                }
            }
        }



        $j++;

        foreach ($list as $line) {

            fputcsv($file, explode('!', $line));
        }

        fclose($file);

        $filename = 'uploads/csvs/test.csv';

        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';

        header('Content-Type: application/csv');

        header("Content-disposition: attachment; filename=\"InventoryMinimumStockList.csv\"");

        readfile($filename);

        Yii::app()->end();

        return;
    }

    /*    arul on 4-1-2018 end */



    /* adharsh 1-3-2018 start */

    public function actionPrintexcelinvreport() {

        $part_no = Yii::app()->request->getParam('part_no');

        //echo $del_from_date;
        //die();

        $type = Yii::app()->request->getParam('type');

        $tax_code = Yii::app()->request->getParam('tax_code');

        $inv_type = Yii::app()->request->getParam('inv_type');

        $generic_name = Yii::app()->request->getParam('generic_name');

        $brand_name = Yii::app()->request->getParam('brand_name');

        $file = fopen("uploads/csvs/test.csv", "w");





        $criteria = new CDbCriteria;

        $criteria->addCondition(' t.inventory_item_type="1"', 'AND');

        if (!empty($part_no))
            $criteria->addCondition('t.id = ' . $part_no, 'AND');



        if (!empty($tax_code))
            $criteria->addCondition('t.tax_code = "' . $tax_code . '"', 'AND');



        if ($inv_type > "0")
            $criteria->addCondition('t.inventory_item_type = "' . $inv_type . '"', 'AND');





        if (!empty($brand_name))
            $criteria->addCondition('t.brand_class_id="' . $brand_name . '"', 'AND');



        $model_stock = Store::model()->with('opening')->findAll($criteria);

        $j = 0;





        $list[$j++] = 'No,Part No,Generic Name,Brand,Description,Tax %,Total Qty,Unit,Rate,Total Value';

        $total_value = 0;

        $m = 1;

        foreach ($model_stock as $i => $model) {







            $cur_qty = 0;

            $total = 0;

            $mod_stock_till = new StockLedger();

            $condition1 = ' t.product_id ="' . $model->id . '"';

            if ($ware_house_id > 0) {

                $condition1 .= ' AND t.	warehouse_id = "' . $ware_house_id . '"';
            }

            $mod_stock_till = $mod_stock_till->find(array('select' => 'SUM(in_qty)-SUM(out_qty) AS net_qty,SUM(in_qty) AS in_qty,SUM(out_qty) AS out_qty,cost_rate', 'condition' => $condition1, 'group' => 't.product_id', 'order' => 't.transaction_date DESC'));



            $cur_qty = (int) $mod_stock_till->net_qty + (int) $model->opening->opening_quantity;

            $zero_flag = 0;

            if ($type == 'N') {

                if ($cur_qty == 0) {

                    $zero_flag = 1;
                }
            } else {

                $zero_flag = 0;
            }



            if ($zero_flag == '0') {

                $model_generic = MasGeneric::model()->find(array('condition' => 't.id="' . $model->generic_name . '"'));

                $total = ((int) $cur_qty) * $model->rate;

                $total_value += $total;



                $list[$j++] = $m++ . ',' . $model->part_number . ',' . $model_generic->generic_name . ',' . $model->brand_detail->product_class . ',' . $model->description . ',' . $model->tax->percentage . ',' . $cur_qty . ',' . $model->unit->symbol . ',' . $model->rate
                        . ',' . $total;
            }
        }



        $j++;



        foreach ($list as $line) {

            fputcsv($file, explode(',', $line));
        }



        fclose($file);



        $filename = 'uploads/csvs/test.csv';



        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';



        header('Content-Type: application/csv');



        header("Content-disposition: attachment; filename=\"print_inv_report.csv\"");



        readfile($filename);



        Yii::app()->end();



        return;
    }

    public function actionPrintexcelinvreport_detailed() {



        $part_no = Yii::app()->request->getParam('part_no');

        $type = Yii::app()->request->getParam('type');

        $tax_code = Yii::app()->request->getParam('tax_code');

        $inv_type = Yii::app()->request->getParam('inv_type');

        $generic_name = Yii::app()->request->getParam('generic_name');

        $brand_name = Yii::app()->request->getParam('brand_name');

        $file = fopen("uploads/csvs/test.csv", "w");





        $criteria = new CDbCriteria;

        $criteria->addCondition(' t.inventory_item_type="1"', 'AND');

        if (!empty($part_no))
            $criteria->addCondition('t.id = ' . $part_no, 'AND');



        if (!empty($tax_code))
            $criteria->addCondition('t.tax_code = "' . $tax_code . '"', 'AND');



        if ($inv_type > "0")
            $criteria->addCondition('t.inventory_item_type = "' . $inv_type . '"', 'AND');





        if (!empty($brand_name))
            $criteria->addCondition('t.brand_class_id="' . $brand_name . '"', 'AND');



        $model_stock = Store::model()->with('opening')->findAll($criteria);

        $j = 0;





        $list[$j++] = 'No$Part No$Description$Brand$Free Qty$Alloc Qty$File ID$Total Qty$Unit$Rate$Total Value';

        $total_value = 0;

        $m = 1;

        foreach ($model_stock as $i => $model) {







            $cur_qty = 0;

            $total = 0;

            $mod_stock_till = new StockLedger();

            $condition1 = ' t.product_id ="' . $model->id . '"';

            if ($ware_house_id > 0) {

                $condition1 .= ' AND t.	warehouse_id = "' . $ware_house_id . '"';
            }

            $mod_stock_till = $mod_stock_till->find(array('select' => 'SUM(in_qty)-SUM(out_qty) AS net_qty,SUM(in_qty) AS in_qty,SUM(out_qty) AS out_qty,cost_rate', 'condition' => $condition1, 'group' => 't.product_id', 'order' => 't.transaction_date DESC'));

            $query = "SELECT SUM(quantity) AS qty, GROUP_CONCAT(file_id SEPARATOR ':') AS file_ids from  erp_allocated_materials WHERE product_id = " . $model->id;  //make it select * from

            $allocated = Yii::app()->db->createCommand($query)->queryAll();

            $alloc_qty = $allocated[0]['qty'];

            $file_ids = $allocated[0]['file_ids'];

            $cur_qty = (float) $mod_stock_till->net_qty + (float) $model->opening->opening_quantity;

            $zero_flag = 0;

            if ($type == 'N') {

                if ($cur_qty == 0) {

                    $zero_flag = 1;
                }
            } else {

                $zero_flag = 0;
            }



            if ($zero_flag == '0') {



                $total = ((float) $cur_qty) * $model->rate;

                $total_value += $total;



                $list[$j++] = $m++ . '$' . $model->part_number . '$' . $model->description . '$' . $model->brand_detail->product_class . '$' . ($cur_qty - $alloc_qty ) . '$' . $alloc_qty . '$' . $file_ids . '$' . $cur_qty . '$' . $model->unit->symbol . '$' . $model->rate . '$' . $total;
            }
        }



        $j++;



        foreach ($list as $line) {

            fputcsv($file, explode('$', $line));
        }



        fclose($file);



        $filename = 'uploads/csvs/test.csv';



        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';



        header('Content-Type: application/csv');



        header("Content-disposition: attachment; filename=\"print_inv_report.csv\"");



        readfile($filename);



        Yii::app()->end();



        return;
    }

    public function actionPrintDeliveryListExcel() {

        $del_from_date = Yii::app()->request->getParam('del_from_date');

        $del_to_date = Yii::app()->request->getParam('del_to_date');

        $customer_id = Yii::app()->request->getParam('customer_id');

        $status = Yii::app()->request->getParam('status');
        $created_by = Yii::app()->request->getParam('created_by');

        $file = fopen("uploads/csvs/test.csv", "w");

        $criteria = new CDbCriteria;

        if (!empty($del_from_date))
            $del_from_date = str_replace('/', '-', $del_from_date);

        $del_from_date = date('Y-m-d', strtotime($del_from_date));

        $criteria->addCondition('t.delivery_date >="' . $del_from_date . '"', 'AND');



        if (!empty($del_to_date))
            $del_to_date = str_replace('/', '-', $del_to_date);

        $del_to_date = date('Y-m-d', strtotime($del_to_date));

        $criteria->addCondition('t.delivery_date <="' . $del_to_date . '"', 'AND');



        if (!empty($customer_id))
            $criteria->addCondition('t.customer_id ="' . $customer_id . '"', 'AND');

        if ($status == 0) {

            $criteria->addCondition('file.current_process_status IN ("PD","PI")', 'AND');
        }

        if ($status == 1) {

            $criteria->addCondition('file.current_process_status IN ("D","I")', 'AND');
        }
        if ($created_by != "") {
            $criteria->addCondition('t.created_by = ' . $created_by, 'AND');
        }



        $model_delivery = DeliveryNote::model()->with('customer', 'file')->findAll($criteria);

        $j = 0;

        $list[$j++] = 'No/Delivery No/File No/Order No/Customer Name/Created By/Account Manager/Delivery Date/Status';



        foreach ($model_delivery as $i => $row) {

            switch ($row['file']['current_process_status']) {

                case 'I':

                    $fstatus = 'Invoiced';

                    break;

                case 'D':

                    $fstatus = 'Delivered';

                    break;

                case 'PD':

                    $fstatus = 'Partially Delivered';

                    break;

                case 'PI':

                    $fstatus = 'Partially Invoiced';

                    break;
            }

            $delivery_date = '';

            if ($row->delivery_date != '0000-00-00') {

                $delivery_date = date("d-m-Y", strtotime($row->delivery_date));
            }

            $leadowner = $row->order->leadowner->fullname;

            $list[$j++] = ($i + 1) . '/' . $row->id . '/' . $row->file_id . '/' . $row->order_id . '/' . $row->customer->customer_name . '/' . $row->getCreated_user() . "/" . $leadowner . '/' . $delivery_date . '/' . $fstatus;
        }



        $j++;



        foreach ($list as $line) {

            fputcsv($file, explode('/', $line));
        }



        fclose($file);



        $filename = 'uploads/csvs/test.csv';



        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';



        header('Content-Type: application/csv');



        header("Content-disposition: attachment; filename=\"Deliverylist.csv\"");



        readfile($filename);



        Yii::app()->end();



        return;
    }

    public function actionPrintexcelInvoiceList() {

        $invoice_from_date = Yii::app()->request->getParam('invoice_from_date');

        //echo $del_from_date;
        //die();

        $invoice_to_date = Yii::app()->request->getParam('invoice_to_date');

        $customer_id = Yii::app()->request->getParam('customer_id');

        $sales_group = Yii::app()->request->getParam('sales_group');

        $brand_id = Yii::app()->request->getParam('brand_id');

        $inv_type = Yii::app()->request->getParam('inv_type');

        $created_by = Yii::app()->request->getParam('created_by');
        $leadowner_id = Yii::app()->request->getParam('leadowner_id');
        $file = fopen("uploads/csvs/test.csv", "w");

        $criteria = new CDbCriteria;
        $criteria->addCondition('t.invoice_status !="C"', 'AND');


        if (!empty($invoice_from_date)) {

            $invoice_from_date = str_replace('/', '-', $invoice_from_date);

            $invoice_from_date = date('Y-m-d', strtotime($invoice_from_date));

            $criteria->addCondition('t.invoice_date >="' . $invoice_from_date . '"', 'AND');
        }



        if (!empty($invoice_to_date)) {

            $invoice_to_date = str_replace('/', '-', $invoice_to_date);

            $invoice_to_date = date('Y-m-d', strtotime($invoice_to_date));

            $criteria->addCondition('t.invoice_date <="' . $invoice_to_date . '"', 'AND');
        }

        if ($created_by != "") {
            $criteria->addCondition('t.created_by ="' . $created_by . '"', 'AND');
        }

        if ($customer_id != '') {



            $criteria->addCondition('t.customer_id ="' . $customer_id . '"');
        }

        if ($brand_id != '') {

            $criteria->addCondition('brand.brand_id ="' . $brand_id . '"');
        }

        if ($inv_type != '') {

            $criteria->addCondition('t.invoice_type ="' . $inv_type . '"');
        }
        if ($leadowner_id > 0) {
            $criteria->addCondition('t.lead_owner_id ="' . $leadowner_id . '"');
            //OR order_details.lead_owner_id ="' . $leadowner_id.'"
        }
        if (!empty($sales_group)) {
            $criteria->addCondition(" t.sales_group =  {$sales_group}");
        }
        $criteria->order = 't.id DESC';

        $total = 0;

        $total_tax = 0;

        $customer = Invoice::model()->with('customer', 'currencyname', 'salesgroup', 'leadowner')->findAll($criteria);

        $j = 0;

        $list[$j++] = 'No###Invoice No###Date###File No###Order No###Customer Name###Created By###Currency###Sales Group###Account Manager###Net Amt###VAT###Grand Total###Net Amt(BC)###VAT(BC)###Grand Total(BC)###';


        $total_net_amt = 0;
        foreach ($customer as $i => $row) {

            if ($row->invoice_date != '0000-00-00') {

                $invoice_date = date("d-m-Y", strtotime($row->invoice_date));
            } else {

                $invoice_date = "";
            }

            $leadowner = $row->leadowner->first_name . ' ' . $row->leadowner->last_name;


            $Sales_Group = $row->salesgroup->group_name;

            $Currency = $row->currencyname->currency_code;


            $net_amount = $row->grand_total - $row->total_tax_amount;


            $amount = $row->grand_total;

            $model_currency = MasCurrency::model()->findByPk($row->currency);

            $total_bc = $amount * $model_currency->exchange_rate;

            $tax = $row->total_tax_amount * $model_currency->exchange_rate;

            $net_amt_bc = $net_amount * $model_currency->exchange_rate;

            $total_tax += $tax;

            $total += $total_bc;
            $total_net_amt += $net_amt_bc;


            $invoice_no = $row->invoice_no;

            $invoice_type = $row->invoice_type;

            if ((int) $invoice_type > 0) {

                $modelInvoiceType = new MasInvoiceType();

                $arr_invoice_type_details = $modelInvoiceType->findByPk((int) $invoice_type);

                $inv_code = $arr_invoice_type_details->inv_code;

                $invoice_no = $inv_code . '-' . $invoice_no;
            }
            $invoice_no = $row->id;


            $list[$j++] = ($i + 1) . '###' . $invoice_no . '###' . $invoice_date . '###' . $row->file_id . '###' . $row->order_id . '###' . $row->customer->customer_name . '###' . $row->getCreated_user() . '###' . $Currency . '###' . $Sales_Group . '###' . $leadowner . '###' . $net_amount . '###' . $row->total_tax_amount . '###' . $amount . '###' . $net_amt_bc . '###' . $tax . '###' . $total_bc;
        }

        $list[$j++] = "#######################################{$total_net_amt}###{$total_tax}###{$total}";

        $j++;



        foreach ($list as $line) {

            fputcsv($file, explode('###', $line));
        }



        fclose($file);





        //$filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $filename = 'uploads/csvs/test.csv';



        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';



        header('Content-Type: application/csv');



        header("Content-disposition: attachment; filename=\"invoice.csv\"");



        readfile($filename);



        Yii::app()->end();



        return;
    }

    public function actionPrintCreditnoteExcel() {

        $from_date = Yii::app()->request->getParam('from_date');

        //echo $del_from_date;
        //die();

        $to_date = Yii::app()->request->getParam('to_date');

        $customer_id = Yii::app()->request->getParam('customer_id');

        $inv_type = Yii::app()->request->getParam('inv_type');

        $created_by = Yii::app()->request->getParam('created_by');

        $file = fopen("uploads/csvs/test.csv", "w");

        $criteria = new CDbCriteria;

        if (!empty($from_date))
            $from_date = str_replace('/', '-', $from_date);

        $from_date = date('Y-m-d', strtotime($from_date));

        $criteria->addCondition(' t.credited_date >="' . $from_date . '"', 'AND');



        if (!empty($to_date))
            $to_date = str_replace('/', '-', $to_date);

        $to_date = date('Y-m-d', strtotime($to_date));

        $criteria->addCondition('t.credited_date <="' . $to_date . '"', 'AND');



        if (!empty($customer_id))
            $criteria->addCondition('t.customer_id ="' . $customer_id . '"', 'AND');



        if (!empty($inv_type))
            $criteria->addCondition('invoice.invoice_type ="' . $inv_type . '"', 'AND');
        if (!empty($created_by)) {
            $criteria->addCondition('t.created_by = ' . $created_by, "AND");
        }
        $criteria->addCondition('t.isActive="Y"', "AND");
        $criteria->addCondition('t.invoice_id!=""', "AND");

        $customer = Creditnote::model()->with('customer', 'file', 'invoice')->findAll($criteria);

        $j = 0;



        $list[$j++] = 'No/CN Date/File No/Inv.No/CN No/Customer Name/Created By/Reason/Inv.Amount/VAT/Credit Amount/Grand Total(BC';



        foreach ($customer as $i => $row) {

            $model_currency = MasCurrency::model()->findByPk($row->currency);

            $total_bc = $row->credited_amount * $model_currency->exchange_rate;



            $invoice_type = $row->invoice->invoice_type;

            /* $invoice_no = $row->invoice->invoice_no;

              if ((int) $invoice_type > 0) {

              $modelInvoiceType = new MasInvoiceType();

              $arr_invoice_type_details = $modelInvoiceType->findByPk((int) $invoice_type);

              $inv_code = $arr_invoice_type_details->inv_code;

              $invoice_no = $inv_code . '-' . $invoice_no;

              } */
            $invoice_no = $row->invoice->id;



            $list[$j++] = ($i + 1) . '/' . date("d-m-Y", strtotime($row->credited_date)) . '/' . $row->file_id . '/' . $invoice_no . '/' . $row->id . '/' . $row->customer->customer_name
                    . '/' . $row->getCreated_user() . "/" . $row->reason . '/' . $row->invoice->grand_total . '/' . $row->total_tax_amount . '/' . $row->credited_amount . '/' . $total_bc;
        }



        $j++;







        foreach ($list as $line) {

            fputcsv($file, explode('/', $line));
        }



        fclose($file);



        //$filename = Yii::app()->getBaseUrl(true) . 'uploads/csvs/test.csv';

        $filename = 'uploads/csvs/test.csv';



        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';



        header('Content-Type: application/csv');



        header("Content-disposition: attachment; filename=\"creditnote_list.csv\"");



        readfile($filename);



        Yii::app()->end();



        return;
    }

    public function actionPrintDirectsale() {

        $from_date = Yii::app()->request->getParam('from_date');

        //echo $del_from_date;
        //die();

        $to_date = Yii::app()->request->getParam('to_date');

        $customer_id = Yii::app()->request->getParam('customer_id');



        $file = fopen("uploads/csvs/test.csv", "w");

        $criteria = new CDbCriteria;

        if (!empty($from_date))
            $from_date = str_replace('/', '-', $from_date);

        $from_date = date('Y-m-d', strtotime($from_date));

        $criteria->addCondition(' t.order_date >="' . $from_date . '"', 'AND');



        if (!empty($to_date))
            $to_date = str_replace('/', '-', $to_date);

        $to_date = date('Y-m-d', strtotime($to_date));

        $criteria->addCondition('t.order_date <="' . $to_date . '"', 'AND');



        if (!empty($customer_id))
            $criteria->addCondition('t.customer_id ="' . $customer_id . '"', 'AND');







        $customer = DirectOrder::model()->with('customer_details')->findAll($criteria);

        $j = 0;













        $list[$j++] = 'No/Date/Order No/Inv.No/Customer Name/Currency/Total/VAT/Grand Total(BC)';



        foreach ($customer as $i => $row) {

            $model_invoice = new Invoice();

            $model_invoice = $model_invoice->find('order_id="' . $row->id . '"');

            $model_currency = MasCurrency::model()->findByPk($row->currency);

            $total_bc = $row->grand_total * $row->currency_details->exchange_rate;



            $list[$j++] = ($i + 1) . '/' . date("d-m-Y", strtotime($row->order_date)) . '/' . $row->id . '/' . $model_invoice->id . '/' . $row->customer_details->customer_name . '/' . $row->currency_details->currency_code
                    . '/' . $row->grand_total . '/' . $row->total_tax_amount . '/' . $total_bc;
        }



        $j++;



        foreach ($list as $line) {

            fputcsv($file, explode('/', $line));
        }



        fclose($file);



        $filename = 'uploads/csvs/test.csv';

        //Yii::app()->getBaseUrl(true) .



        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';



        header('Content-Type: application/csv');



        header("Content-disposition: attachment; filename=\"directsale.csv\"");



        readfile($filename);



        Yii::app()->end();



        return;
    }

    public function actionPrintNetsaleListNew() {

        $from_date = Yii::app()->request->getParam('from_date');

        //echo $del_from_date;
        //die();

        $to_date = Yii::app()->request->getParam('to_date');

        $customer_id = Yii::app()->request->getParam('customer_id');

        $leadowner_id = Yii::app()->request->getParam('leadowner_id');

        $inv_type = Yii::app()->request->getParam('invoice_type');
        $file = fopen("uploads/csvs/test.xls", "w");
        $html = $this->renderPartial('application.views.front.reports.excel.net_sale_list', array('model' => $model, 'from_date' => $from_date, 'to_date' => $to_date, 'customer_id' => $customer_id, 'leadowner_id' => $leadowner_id, 'title' => $title, 'inv_type' => $inv_type), true);


        fwrite($file, $html);
        fclose($file);
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"netsales.xls\"");
        readfile("uploads/csvs/test.xls");

        Yii::app()->end();
    }

    public function actionPrintNetsaleList() {

        $from_date = Yii::app()->request->getParam('from_date');

        //echo $del_from_date;
        //die();

        $to_date = Yii::app()->request->getParam('to_date');

        $customer_id = Yii::app()->request->getParam('customer_id');

        $leadowner_id = Yii::app()->request->getParam('leadowner_id');

        $invoice_type = Yii::app()->request->getParam('invoice_type');

        $file = fopen("uploads/csvs/test.csv", "w");

        $criteria = new CDbCriteria;

        $criteria->addCondition('t.invoice_status ="Y"', 'AND');

        if (!empty($from_date))
            $from_date = str_replace('/', '-', $from_date);

        $from_date = date('Y-m-d', strtotime($from_date));

        $criteria->addCondition('t.invoice_date >="' . $from_date . '"', 'AND');



        if (!empty($to_date))
            $to_date = str_replace('/', '-', $to_date);

        $to_date = date('Y-m-d', strtotime($to_date));

        $criteria->addCondition(' t.invoice_date <="' . $to_date . '"', 'AND');



        if ($leadowner_id > 0)
            $criteria->addCondition(' t.lead_owner_id ="' . $leadowner_id . '"', 'AND');

        if ($customer_id > 0)
            $criteria->addCondition(' t.customer_id ="' . $customer_id . '"', 'AND');



        $list = array();

        $total = 0;

        $cn_total = 0;

        $total_tax = 0;

        $total_cn_tax = 0;

        $tot_net_tax = 0;

        $total_net_sales = 0;

        $total_net_sales_bc = 0;

        $total_net_vat_bc = 0;
        $criteria->order = 't.invoice_date,t.id';
        $customer = Invoice::model()->with('customer', 'file')->findAll($criteria);

        $j = 0;

        $list[$j++] = 'No/Invoice Date/Invoice No/File No/Customer Name/Account Manager/Sales Group/Inv.VAT/Inv.Amt/CN VAT/CN Amt/Net VAT/Sale without VAT/Net VAT(AED)/Net Amount(AED)/Total(AED)';



        foreach ($customer as $i => $row) {

            $model_credit = Creditnote::model()->find(array('select' => 'IFNULL(SUM(credited_amount),0)as credited_amount,IFNULL(SUM(total_tax_amount),0)as total_tax_amount', 'condition' => 't.invoice_id=' . $row->id));

            if ($row->invoice_date != '0000-00-00') {

                $invoice_date = date("d-m-Y", strtotime($row->invoice_date));
            } else {

                $invoice_date = "";
            }



            $invoice_no = $row->id;

            $invoice_type = $row->invoice_type;

            if ((int) $invoice_type > 0) {

                $modelInvoiceType = new MasInvoiceType();

                $arr_invoice_type_details = $modelInvoiceType->findByPk((int) $invoice_type);

                $inv_code = $arr_invoice_type_details->inv_code;

                // $invoice_no = $inv_code . '-' . $invoice_no;
            }



            $model_currency = MasCurrency::model()->findByPk($row->currency);

            $invoice_amt_with_vat = round(($row->grand_total), 2);

            $credit_amnt_with_vat = round(($model_credit->credited_amount), 2);

            $tax = round($row->total_tax_amount, 2);

            $cn_tax = round($model_credit->total_tax_amount, 2);



            $net_vat = $tax - $cn_tax;

            $net_total = $invoice_amt_with_vat - $credit_amnt_with_vat;

            $net_sales = $net_total - $net_vat;

            $net_total_bc = round(($net_total * $row->exchange_rate), 2);

            $net_vat_bc = round(($net_vat * $row->exchange_rate), 2);

            $net_sales_bc = round(($net_sales * $row->exchange_rate), 2);



            $total_tax += $tax;

            $total += $invoice_amt_with_vat;

            $total_cn_tax += $cn_tax;

            $cn_total += $credit_amnt_with_vat;

            $tot_net_tax += $net_vat;

            $total_net_sales += $net_sales;

            $total_net_sales_bc += $net_sales_bc;

            $total_net_vat_bc += $net_vat_bc;



            $list[$j++] = ($i + 1) . '/' . $invoice_date . '/' . $invoice_no . '/' . $row->file_id . '/' . $row->customer->customer_name . '/' . $row->leadowner->fullname . '/' . $row->salesgroup->group_name . '/'
                    . $tax . '/' . $invoice_amt_with_vat . '/' . $cn_tax . '/' . $credit_amnt_with_vat . '/' . $net_vat . '/' . $net_sales . '/' . $net_vat_bc . '/' . $net_sales_bc . '/' . ($net_sales_bc + $net_vat_bc);
        }

        $list[$j++] = '/ / / / / / /' . $total_tax . '/' . $total . '/' . $total_cn_tax . '/' . $cn_total . '/' . $tot_net_tax . '/' . $total_net_sales . '/' . $total_net_vat_bc . '/' . $total_net_sales_bc . '/' . ($total_net_sales_bc + $total_net_vat_bc);

        $j++;



        foreach ($list as $line) {

            //print_r(explode('/', $line));

            fputcsv($file, explode('/', $line));
        }



        fclose($file);



        $filename = 'uploads/csvs/test.csv';



        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';



        header('Content-Type: application/csv');



        header("Content-disposition: attachment; filename=\"netsales_list.csv\"");



        readfile($filename);

        Yii::app()->end();



        return;
    }

    public function actionPrintGrossprofitList() {

        $from_date = Yii::app()->request->getParam('from_date');

        //echo $del_from_date;
        //die();

        $to_date = Yii::app()->request->getParam('to_date');

        $customer_id = Yii::app()->request->getParam('customer_id');

        $leadowner_id = Yii::app()->request->getParam('leadowner_id');

        $sales_group = Yii::app()->request->getParam('sales_group');

        $actual_cost = Yii::app()->request->getParam('actual_cost');

        $file = fopen("uploads/csvs/test.csv", "w");

        $criteria = new CDbCriteria;



        if (!empty($from_date))
            $from_date = str_replace('/', '-', $from_date);

        $from_date = date('Y-m-d', strtotime($from_date));

        $criteria->addCondition('t.invoice_date >="' . $from_date . '"', 'AND');



        if (!empty($to_date))
            $to_date = str_replace('/', '-', $to_date);

        $to_date = date('Y-m-d', strtotime($to_date));

        $criteria->addCondition(' t.invoice_date <="' . $to_date . '"', 'AND');





        $total = 0;

        $total_tax = 0;

        $customer = Grossprofit::model()->findAll($criteria);

        $j = 0;

        $list[$j++] = 'No/Invoice No/Invoice Date/Customer Name/Currency/Invoice Value/Value(BC)/Cost/Profit/Profit (%)/';



        foreach ($customer as $i => $row) {

            $total_cost_rate = $row->total_cost_rate;

            $invoice_value_bc = $row->invoice_value_bc;

            $profit_value = ($invoice_value_bc - $total_cost_rate);

            $profit += $profit_value;



            $profit_in_percentage = (($invoice_value_bc) > 0) ? round(($profit_value / $invoice_value_bc) * 100, 2) : 0;





            if ($row->invoice_date != '0000-00-00') {

                $invoice_date = date("d-m-Y", strtotime($row->invoice_date));
            } else {

                $invoice_date = "";
            }



            if (!empty($actual_cost)) {

                $cost = $actual_cost;
            } else {

                $cost = "0";
            }





            $list[$j++] = ($i + 1) . '/' . $row->invoice_no . '/' . $invoice_date . '/' . $row->customer_name . '/' . $row->currency_name . '/'
                    . $row->invoice_value . '/' . $row->invoice_value_bc . '/' . $cost . '/' . $profit_value . '/' . $profit_in_percentage;
        }



        $j++;



        foreach ($list as $line) {

            fputcsv($file, explode('/', $line));
        }



        fclose($file);

        $filename = 'uploads/csvs/test.csv';



        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';



        header('Content-Type: application/csv');



        header("Content-disposition: attachment; filename=\"grossprofitlist.csv\"");



        readfile($filename);



        Yii::app()->end();



        return;
    }

    /* adharsh 1-3-2018 ends */

    /* jisha 8-1-17 starts */

    public function actionPrintInvoiceCommissionIncentiveReport() {



        $model = new Customer();



        $arr_details['customer_id'] = $_POST['customer_id'];

        $arr_details['leadowner_id'] = $_POST['leadowner_id'];

        $arr_details['from_date'] = $_POST['from_date'];

        $arr_details['to_date'] = $_POST['to_date'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_invcommisionincentive_list', array('model' => $model, 'arr_details' => $arr_details), false, true);
    }

    public function actionPrintInvoiceCommissionIncentiveReportPDF() {



        $model = new Customer();



        $arr_details['customer_id'] = $_GET['customer_id'];

        $arr_details['leadowner_id'] = $_GET['leadowner_id'];

        $arr_details['from_date'] = $_GET['from_date'];

        $arr_details['to_date'] = $_GET['to_date'];



        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.print_invcommisionincentive_pdf', array('model' => $model, 'arr_details' => $arr_details), true));



        $mpdf->Output("invcommisionincentive_list", 'I');
    }

    public function actionPrintCommissionInvoiceIncentiveExcel() {

        $from_date = Yii::app()->request->getParam('from_date');

        $to_date = Yii::app()->request->getParam('to_date');

        $customer_id = Yii::app()->request->getParam('customer_id');

        $leadowner_id = Yii::app()->request->getParam('leadowner_id');

        $file = fopen("uploads/csvs/test.csv", "w");

        $criteria = new CDbCriteria;

        $condition = "1=1 ";

        if ($customer_id > 0) {

            $condition .= " AND t.company_id=" . $customer_id; // //customer_id
        }

        if ($from_date != '') {

            $str_from_date = str_replace('/', '-', $from_date);

            $str_from_date = date("Y-m-d", strtotime($str_from_date));

            $condition .= ' AND t.invoice_date >="' . $str_from_date . '"';
        }

        if ($to_date != '') {

            $str_to_date = str_replace('/', '-', $to_date);

            $str_to_date = date("Y-m-d", strtotime($str_to_date));

            $condition .= ' AND t.invoice_date <="' . $str_to_date . '"';
        }

        if ($leadowner_id > 0) {

            $condition .= " AND file.lead_owner_id=" . $leadowner_id;
        }



        $files = Invoice::model()->with('items', 'returnedAmount', 'file')->findAll(array('condition' => $condition, 'order' => 't.company_id ASC'));

        $grand_total = 0;

        $cnt = 0;

        $total_net_sale = 0;

        $total_net_cost_rate = 0;

        $total_profit = 0;

        $j = 0;

        $list[$j++] = 'File No/Invoice No/Invoice Date/Customer/Account Manager/Net Sale/Cost Rate/Profit/Profit (%)/';

        foreach ($files as $i => $eachFile) {

            $cost_rate = 0;

            $net_cost_rate = 0;

            foreach ($eachFile->items as $products) {

                $query = "SELECT cost_value_per_unit,total_cost_value FROM {{profit_calc}} AS PC

                          INNER JOIN {{profit_calc_item}} AS PCI ON PC.id=PCI.profit_calc_id

                          WHERE PC.file_id=" . $eachFile->file_id . " AND PCI.product_id=" . $products->product_id;

                $arr_cost_rate = Yii::app()->db->createCommand($query)->queryAll();



                $quantity = $products->quantity;

                if (count($arr_cost_rate) > 0) {

                    //$cost_rate = number_format(round($arr_cost_rate[0]['total_cost_value'], 2), 2, '.', '');

                    $cost_rate = number_format(round($arr_cost_rate[0]['cost_value_per_unit'], 2), 2, '.', '');

                    $cost_rate = $cost_rate * $quantity;

                    $net_cost_rate += $cost_rate;
                }
            }

            //$invoice_total = $eachFile->grand_total;

            $invoice_total = ($eachFile->grand_total - $eachFile->total_tax_amount);

            //$credit_total = $eachFile->returnedAmount;

            $credit_total = ($eachFile->returnedAmount - $eachFile->returnedVATAmount);

            $net_total = (($invoice_total - $credit_total) * $eachFile->file->order->exchange_rate);

            $grand_total = $grand_total + $net_total;

            $profit = 0;

            if ($net_total > 0)
                $profit = $net_total - $net_cost_rate;

            $profit_in_percentage = ($net_total > 0) ? round(($profit / $net_total) * 100, 2) : 0;





            $invoice_no = $eachFile->invoice_no;

            $invoice_type = $eachFile->invoice_type;

            if ((int) $invoice_type > 0) {

                $modelInvoiceType = new MasInvoiceType();

                $arr_invoice_type_details = $modelInvoiceType->findByPk((int) $invoice_type);

                $inv_code = $arr_invoice_type_details->inv_code;

                $invoice_no = $inv_code . '-' . $invoice_no;
            }



            $leadOwnerName = "";

            if (isset($eachFile->file->leadowner->first_name))
                $leadOwnerName = $eachFile->file->leadowner->first_name . " " . $eachFile->file->leadowner->last_name;

            if ($eachFile->invoice_date != '0000-00-00') {

                $invoice_date = date("d-m-Y", strtotime($eachFile->invoice_date));
            } else {

                $invoice_date = "";
            }



            $list[$j++] = $eachFile->file_id . '/' . $invoice_no . '/' . $invoice_date . '/' . $eachFile->customer->customer_name . '/' . $leadOwnerName . '/'
                    . Yii::app()->numberFormatter->formatCurrency($net_total, "") . '/' . Yii::app()->numberFormatter->formatCurrency($net_cost_rate, "") . '/' . Yii::app()->numberFormatter->formatCurrency($profit, "") . '/' . Yii::app()->numberFormatter->formatCurrency($profit_in_percentage, "");

            $total_net_sale += $net_total;

            $total_net_cost_rate += $net_cost_rate;

            $total_profit += $profit;

            $cnt++;
        }



        $j++;



        foreach ($list as $line) {

            fputcsv($file, explode('/', $line));
        }



        fclose($file);



        //$filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $filename = 'uploads/csvs/test.csv';



        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';



        header('Content-Type: application/csv');



        header("Content-disposition: attachment; filename=\"invoiceincentivelist.csv\"");



        readfile($filename);



        Yii::app()->end();



        return;
    }

    public function actionPrintCommissionIncentiveReport() {



        $model = new Customer();



        $arr_details['customer_id'] = $_POST['customer_id'];

        $arr_details['leadowner_id'] = $_POST['leadowner_id'];

        $arr_details['from_date'] = $_POST['from_date'];

        $arr_details['to_date'] = $_POST['to_date'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_commisionincentive_list', array('model' => $model, 'arr_details' => $arr_details), false, true);
    }

    /* jisha 8-1-17 starts */

    public function actionPrintCommissionIncentiveReportPDF() {



        $model = new Customer();



        $arr_details['customer_id'] = $_GET['customer_id'];

        $arr_details['leadowner_id'] = $_GET['leadowner_id'];

        $arr_details['from_date'] = $_GET['from_date'];

        $arr_details['to_date'] = $_GET['to_date'];



        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.print_commisionincentive_list', array('model' => $model, 'arr_details' => $arr_details), true));



        $mpdf->Output("IncentiveReport.pdf", 'I');
    }

    public function actionPrintVendorList() {



        $arr_details['vendor_name'] = Yii::app()->request->getParam('vendor_name');

        $arr_details['vendor_phoneno'] = Yii::app()->request->getParam('vendor_phoneno');

        $arr_details['vendor_email'] = Yii::app()->request->getParam('vendor_email');





        $this->render('//reports/print_vendorlist', array('model' => $model, 'vendor_details' => $arr_details), false, true);
    }

    public function actionPrintVendorListPDF() {



        $arr_details['vendor_name'] = Yii::app()->request->getParam('vendor_name');

        $arr_details['vendor_phoneno'] = Yii::app()->request->getParam('vendor_phoneno');

        $arr_details['vendor_email'] = Yii::app()->request->getParam('vendor_email');





        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.print_vendorlist', array('model' => $model, 'vendor_details' => $arr_details), true));



        $mpdf->Output("vendorlist.pdf", 'I');
    }

    public function actionPrintVendorExcel() {

        $vendor_name = Yii::app()->request->getParam('vendor_name');

        $vendor_phoneno = Yii::app()->request->getParam('vendor_phoneno');

        $vendor_email = Yii::app()->request->getParam('vendor_email');





        $file = fopen("uploads/csvs/test.csv", "w");

        $criteria = new CDbCriteria;

        $condition = '1=1';

        if ($vendor_name != '') {

            $condition .= " AND t.vendor_name Like '%" . $vendor_name . "%'";
        }

        if ($vendor_phoneno != '') {

            $condition .= " AND t.vendor_phone_no Like '%" . $vendor_phoneno . "%'";
        }

        if ($vendor_email != '') {

            $condition .= " AND t.vendor_email_id Like '%" . $vendor_email . "%'";
        }

        $model_vendor_contact = Vendor::model()->with('country')->findAll(array('condition' => $condition, 'order' => 'vendor_name asc'));

        $j = 0;

        $list[$j++] = 'No ! Name!Email! Address ! Phone No ! City ! Postal Code ! State!Country';



        foreach ($model_vendor_contact as $i => $row) {

            $list[$j++] = ($i + 1) . '!' . $row->vendor_name .
                    '!' . $row->vendor_email_id . '!' .
                    $row->vendor_phone_no . '!' . $row->vendor_address .
                    '!' . $row->vendor_city . '!' . $row->vendor_postal_code .
                    '!' . $row->vendor_state . '!' . $row->country->country_name;
        }



        $j++;



        foreach ($list as $line) {

            fputcsv($file, explode('!', $line));
        }



        fclose($file);



        $filename = 'uploads/csvs/test.csv';



        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';



        header('Content-Type: application/csv');



        header("Content-disposition: attachment; filename=\"vendorlist.csv\"");



        readfile($filename);



        Yii::app()->end();



        return;
    }

    public function actionPrintVendorContactList() {



        $arr_details['vendor_name'] = Yii::app()->request->getParam('vendor_name');

        $arr_details['vendor_phoneno'] = Yii::app()->request->getParam('vendor_phoneno');

        $arr_details['vendor_email'] = Yii::app()->request->getParam('vendor_email');





        $this->render('//reports/print_vendorcontact_list', array('model' => $model, 'vendor_details' => $arr_details), false, true);

        // print_vendorlist
    }

    public function actionPrintVendorContactListPDF() {



        $arr_details['vendor_name'] = Yii::app()->request->getParam('vendor_name');

        $arr_details['vendor_phoneno'] = Yii::app()->request->getParam('vendor_phoneno');

        $arr_details['vendor_email'] = Yii::app()->request->getParam('vendor_email');







        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.print_vendorcontact_list', array('model' => $model, 'vendor_details' => $arr_details), true));



        $mpdf->Output("VendorContactList", 'I');
    }

    /* arul on 18-1-2018 */

    public function actionPrintPaymentTerms() {



        $customer_id = Yii::app()->request->getParam('customer_id');

        $payment_terms = Yii::app()->request->getParam('payment_terms');



        $param = array(
            'customer_id' => $customer_id,
            'payment_terms' => $payment_terms
        );



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_payment_terms', array('customer_id' => $customer_id, 'payment_terms' => $payment_terms), false);
    }

    /*    arul on 18-1-2018 end */

    public function actionPrintPaymentTermsPDF() {



        $customer_id = Yii::app()->request->getParam('customer_id');

        $payment_terms = Yii::app()->request->getParam('payment_terms');



        $param = array(
            'customer_id' => $customer_id,
            'payment_terms' => $payment_terms
        );







        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.payment_terms.', $param, true));



        $mpdf->Output("VendorContactList", 'I');
    }

    public function actionBalanceSheetViewPdf() {

//            $date_from=$_POST['rp_from_date'];

        $date_to = $_POST['rp_to_date'];

        ini_set("memory_limit", "256M");

        //  ini_set('max_execution_time', 1000);

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $mpdf->SetTitle('Balance Sheet');

        $mpdf->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);

        $mpdf->showWatermarkImage = true;

        $mpdf->watermarkImageAlpha = 0.09;

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');

        $mpdf->WriteHTML($stylesheet, 1);



        $mpdf->WriteHTML($this->renderPartial("application.views.front.pdf.balance_sheet", array('date_to' => $date_to), true));

        $mpdf->Output('Balance Sheet.pdf', 'I');
    }

    public function actionPrintActivityList() {
        $customer_id = $_POST['customer_id'];
        $activity_type = $_POST['activity_type'];
        $activity = $_POST['activity'];
        $added_from = $_POST['added_from'];
        $activity_closing_from_date = $_POST['activity_closing_from_date'];
        $activity_closing_to_date = $_POST['activity_closing_to_date'];
        $activity_user = $_POST['activity_user'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_activity', array('customer_id' => $customer_id, 'activity_closing_from_date' => $activity_closing_from_date, 'activity_closing_to_date' =>
            $activity_closing_to_date, 'activity_user' => $activity_user,
            'activity_type' => $activity_type, 'added_from' => $added_from, 'activity' => $activity), false, true);
    }

    public function actionPrintActivityPdf() {
        $model = new Activity();
        $customer_id = Yii::app()->request->getParam('customer_id');
        $activity_type = Yii::app()->request->getParam('activity_type');
        $activity = Yii::app()->request->getParam('activity');
        $added_from = Yii::app()->request->getParam('added_from');
        $activity_closing_from_date = Yii::app()->request->getParam('activity_closing_from_date');
        $activity_closing_to_date = Yii::app()->request->getParam('activity_closing_to_date');
        $activity_user = Yii::app()->request->getParam('activity_user');


        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.print_activity', array('model' => $model, 'customer_id' => $customer_id,
                    'activity_closing_from_date' => $activity_closing_from_date,
                    'activity_closing_to_date' => $activity_closing_to_date,
                    'activity_user' => $activity_user,
                    'activity_type' => $activity_type, 'added_from' => $added_from, 'activity' => $activity), true));
        $mpdf->Output("ActivityList", 'I');
    }

    public function actionPrintProvisionalList() {

        $provisional_from_date = $_POST['provisional_from_date'];
        $provisional_to_date = $_POST['provisional_to_date'];
        $provisional_customer_id = $_POST['provisional_customer_id'];
        $provisional_leadowner_id = $_POST['provisional_leadowner_id'];
        $job_order_id = $_POST['job_order_id'];
        $type = $_POST['type'];
        $transport_type = $_POST['transport_type'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_provisional', array('provisional_from_date' => $provisional_from_date, 'provisional_to_date' => $provisional_to_date, 'provisional_customer_id' => $provisional_customer_id, 'provisional_leadowner_id' => $provisional_leadowner_id, 'type' => $type, 'job_order_id' => $job_order_id,'transport_type' =>$transport_type), false, true);
    }

    public function actionPrintProvisionalDetailedList() {

        $provisional_from_date = $_POST['provisional_from_date'];
        $provisional_to_date = $_POST['provisional_to_date'];
        $provisional_customer_id = $_POST['provisional_customer_id'];
        $provisional_leadowner_id = $_POST['provisional_leadowner_id'];
        $job_order_id = $_POST['job_order_id'];
        $provisional_vendor_id = $_POST['provisional_vendor_id'];
        $provisional_awb_no = $_POST['provisional_awb_no'];
        $provisional_transport_type = $_POST['provisional_transport_type'];
        $transport_type = $_POST['transport_type'];
        $type = $_POST['type'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_provisional_detailed', array('provisional_from_date' => $provisional_from_date, 'provisional_to_date' => $provisional_to_date, 'provisional_customer_id' => $provisional_customer_id, 'provisional_leadowner_id' => $provisional_leadowner_id, 'type' => $type, 'job_order_id' => $job_order_id,'provisional_transport_type' => $provisional_transport_type,'provisional_awb_no' => $provisional_awb_no,'provisional_vendor_id' => $provisional_vendor_id,'transport_type' =>$transport_type), false, true);
    }

    public function actionPrintProvisionalPdf() {
        $model = new JobOrder();
        $provisional_from_date = Yii::app()->request->getParam('provisional_from_date');
        $provisional_customer_id = Yii::app()->request->getParam('provisional_customer_id');
        $provisional_leadowner_id = Yii::app()->request->getParam('provisional_leadowner_id');
        $provisional_to_date = Yii::app()->request->getParam('provisional_to_date');
        $job_order_id = Yii::app()->request->getParam('job_order_id');
        $type = Yii::app()->request->getParam('type');
        $transport_type = Yii::app()->request->getParam('transport_type');

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.print_provisional', array('model' => $model, 'provisional_from_date' => $provisional_from_date, 'provisional_to_date' => $provisional_to_date, 'provisional_customer_id' => $provisional_customer_id, 'provisional_leadowner_id' => $provisional_leadowner_id,'job_order_id'=>$job_order_id,'type' => $type,'transport_type' =>$transport_type), true));
        $mpdf->Output("ProvisionalReport", 'I');
    }
     public function actionPrintProvisionaldetailedPdf() {
        $model = new JobOrderAgentDetails();
        $provisional_from_date = Yii::app()->request->getParam('provisional_from_date'); 
        $provisional_customer_id = Yii::app()->request->getParam('provisional_customer_id');
        $provisional_leadowner_id = Yii::app()->request->getParam('provisional_leadowner_id');
        $provisional_to_date = Yii::app()->request->getParam('provisional_to_date');
        $job_order_id = Yii::app()->request->getParam('job_order_id');
        $type = Yii::app()->request->getParam('type');
        $provisional_vendor_id = Yii::app()->request->getParam('provisional_vendor_id');
        $provisional_awb_no = Yii::app()->request->getParam('provisional_awb_no');
        $provisional_transport_type = Yii::app()->request->getParam('provisional_transport_type');
        $transport_type = Yii::app()->request->getParam('transport_type');
        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.print_provisional_detailed', array('model' => $model, 'provisional_from_date' => $provisional_from_date, 'provisional_to_date' => $provisional_to_date, 'provisional_customer_id' => $provisional_customer_id, 'provisional_leadowner_id' => $provisional_leadowner_id,'job_order_id' => $job_order_id,'type' => $type ,'title' => $title,'provisional_transport_type' => $provisional_transport_type,'provisional_awb_no' => $provisional_awb_no,'provisional_vendor_id' => $provisional_vendor_id,'transport_type' => $transport_type), true));
        $mpdf->Output("ProvisionalDetailedReport", 'I');
    }
    
    public function actionProvisionalListExcel() {



        $provisional_from_date = Yii::app()->request->getParam('provisional_from_date');
        $provisional_customer_id = Yii::app()->request->getParam('provisional_customer_id');
        $provisional_leadowner_id = Yii::app()->request->getParam('provisional_leadowner_id');
        $provisional_to_date = Yii::app()->request->getParam('provisional_to_date');
        $job_order_id = Yii::app()->request->getParam('job_order_id');
        $type = Yii::app()->request->getParam('type');
        $transport_type = Yii::app()->request->getParam('transport_type');


        $filename = 'provisional_report' . date('dmYhis') . '.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderpartial('application.views.front.reports.excel.provisional_report', array('provisional_from_date' => $provisional_from_date, 'provisional_to_date' => $provisional_to_date, 'provisional_customer_id' => $provisional_customer_id, 'provisional_leadowner_id' => $provisional_leadowner_id,'job_order_id' => $job_order_id,'type' => $type,'transport_type' => $transport_type ,'title' => $title), false, true);
        Yii::app()->end();


        return;
    }
     public function actionProvisionaldetailedListExcel() {
        $model = new JobOrderAgentDetails();
        $provisional_from_date = Yii::app()->request->getParam('provisional_from_date');
        $provisional_customer_id = Yii::app()->request->getParam('provisional_customer_id');
        $provisional_leadowner_id = Yii::app()->request->getParam('provisional_leadowner_id');
        $provisional_to_date = Yii::app()->request->getParam('provisional_to_date');
        $job_order_id = Yii::app()->request->getParam('job_order_id');
        $type = Yii::app()->request->getParam('type');
        $provisional_vendor_id = Yii::app()->request->getParam('provisional_vendor_id');
        $provisional_awb_no = Yii::app()->request->getParam('provisional_awb_no');
        $provisional_transport_type = Yii::app()->request->getParam('provisional_transport_type');
        $transport_type = Yii::app()->request->getParam('transport_type');

        $filename = 'provisional_detailed_report' . date('dmYhis') . '.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderpartial('application.views.front.reports.excel.provisional_detailed_report', array('provisional_from_date' => $provisional_from_date, 'provisional_to_date' => $provisional_to_date, 'provisional_customer_id' => $provisional_customer_id, 'provisional_leadowner_id' => $provisional_leadowner_id,'job_order_id' => $job_order_id,'type' => $type ,'title' => $title,'provisional_transport_type' => $provisional_transport_type,'provisional_awb_no' => $provisional_awb_no,'provisional_vendor_id' => $provisional_vendor_id,'transport_type' => $transport_type), false, true);
        Yii::app()->end();
    }
    
    public function actionPrintDeliveryToBeInvoiced() {

        $customer_id = $_POST['customer_id'];
        $country = $_POST['country'];
        $from_date = $_POST['from_date'];
        $to_date = $_POST['to_date'];
        $shipped_by = $_POST['shipped_by'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_delivery_to_invoice', array('customer_id' => $customer_id, 'country' => $country, 'shipped_by' => $shipped_by, 'from_date' => $from_date, 'to_date' => $to_date), false, true);
    }

    public function actionPrintDeliverytobeInvoicedpdf() {

        $customer_id = Yii::app()->request->getParam('customer_id');

        $country = Yii::app()->request->getParam('country');

        $from_date = Yii::app()->request->getParam('from_date');

        $to_date = Yii::app()->request->getParam('to_date');

        $shipped_by = Yii::app()->request->getParam('shipped_by');



        $param = array(
            'customer_id' => $customer_id,
            'country' => $country,
            'from_date' => $from_date,
            'to_date' => $to_date,
            'shipped_by' => $shipped_by,
        );



        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.print_delivery_to_invoice', $param, true));



        $mpdf->Output("reorder_level_list", 'I');
    }

    public function actionPrintOrdersToBeDelivered() {



        $customer_id = $_POST['customer_id'];

        $country = $_POST['country'];

        $from_date = $_POST['from_date'];

        $to_date = $_POST['to_date'];

        $leadowner_id = $_POST['leadowner_id'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_order_to_deliver', array('customer_id' => $customer_id, 'country' => $country, 'leadowner_id' => $leadowner_id, 'from_date' => $from_date, 'to_date' => $to_date), false, true);
    }

    public function actionPrintOrdersToBeDeliveredExecel() {

        $customer_id = Yii::app()->request->getParam('customer_id');

        $country = Yii::app()->request->getParam('country');

        $from_date = Yii::app()->request->getParam('from_date');

        $to_date = Yii::app()->request->getParam('to_date');

        $leadowner_id = Yii::app()->request->getParam('leadowner_id');





        $heading = 'File/Order No.!Curr.Status!Order Date!Delivery Date!Customer!L.Owner!Ordered(No.s)!Delivered(No.s)!Pending(No.s)!Pending Amount';

        $list = array();

        $m = 0;

        $list[$m++] = $heading;



        $model = new Order;



        if ($customer_id > 0)
            $condition .= ' AND F.customer_id="' . $customer_id . '"';

        if ($country > 0)
            $condition .= ' AND C.customer_country="' . $country . '"';

        if ($leadowner_id > 0)
            $condition .= ' AND F.lead_owner_id=' . $leadowner_id;

        if ($from_date != '') {

            $from_date = str_replace('/', '-', $from_date);

            $from_date = date('Y-m-d', strtotime($from_date));

            $condition .= ' AND O.order_date >="' . $from_date . '"';
        }

        if ($to_date != '') {

            $to_date = str_replace('/', '-', $to_date);

            $to_date = date('Y-m-d', strtotime($to_date));

            $condition .= ' AND O.order_date <="' . $to_date . '"';
        }



        /* $sql = '      SElECT A.*,B.deliveredQuantity

          FROM(

          (SELECT O.id,O.file_id,F.file_title,IFNULL(SUM(OI.quantity),0)AS netQuantity ,F.current_process_status,

          O.lead_owner_id,C.customer_name,

          O.order_date,O.delivery_date

          FROM crm_order  O

          LEFT JOIN crm_master_file F

          ON F.id=O.file_id

          LEFT JOIN crm_customer C

          ON F.customer_id=C.id

          LEFT JOIN crm_order_item OI

          ON OI.order_id=O.id

          WHERE (F.current_process_status="O" OR F.current_process_status="PD" OR F.current_process_status="PI")' . $condition . '

          GROUP BY O.id)A

          LEFT JOIN

          (SELECT O.id,IFNULL(SUM(DNI.picked_qty),0) AS deliveredQuantity

          FROM crm_order  O

          LEFT JOIN crm_master_file F

          ON F.id=O.file_id

          LEFT JOIN crm_customer C

          ON F.customer_id=C.id

          LEFT JOIN crm_delivery_note DN

          ON DN.order_id=O.id

          LEFT JOIN crm_delivery_item DNI

          ON DNI.delivery_note_id=DN.id

          WHERE F.current_process_status in ("O","PD","PI") ' . $condition . '

          GROUP BY O.id)B

          ON A.id=B.id)



          '; // WHERE A.netQuantity > B.deliveredQuantity */





        $sql = ' SElECT A.*,B.deliveredQuantity,B.deliveredAmount

                    FROM(

                        (SELECT O.id,O.file_id,F.file_title,IFNULL(SUM(OI.quantity),0)AS netQuantity,IFNULL(SUM(OI.quantity * store.rate),0) AS netAmount,F.current_process_status,

                        O.lead_owner_id,C.customer_name,

                        O.order_date,O.delivery_date

                        FROM erp_order  O

                        LEFT JOIN erp_master_file F

                        ON F.id=O.file_id

                        LEFT JOIN erp_customer C

                        ON F.customer_id=C.id

                        LEFT JOIN erp_order_item OI

                        ON OI.order_id=O.id

                        INNER JOIN erp_store AS store ON OI.product_id=store.id

                        WHERE (F.current_process_status="O" OR F.current_process_status="PD" OR F.current_process_status="PI")' . $condition . '

                        GROUP BY O.id)A

                        LEFT JOIN

                        (SELECT O.id,IFNULL(SUM(DNI.picked_qty),0) AS deliveredQuantity,IFNULL(SUM(DNI.picked_qty * store.rate),0)AS deliveredAmount

                        FROM erp_order  O

                        LEFT JOIN erp_master_file F

                        ON F.id=O.file_id

                        LEFT JOIN erp_customer C

                        ON F.customer_id=C.id

                        LEFT JOIN erp_delivery_note DN

                        ON DN.order_id=O.id

                        LEFT JOIN erp_delivery_item DNI

                        ON DNI.delivery_note_id=DN.id

                        LEFT JOIN erp_order_item AS OI on DNI.order_item_id=OI.id

                        INNER JOIN erp_store AS store ON DNI.product_id=store.id

                        WHERE F.current_process_status in ("O","PD","PI") ' . $condition . '

                        GROUP BY O.id)B

                        ON A.id=B.id)';





        $orders = Yii::app()->db->createCommand($sql)->queryAll();

        if (!empty($orders)) {

            foreach ($orders as $i => $eachItem) {

                $line = "";

                $user = User::model()->findBypk($eachItem['lead_owner_id']);

                $line .= $eachItem['file_id'] . '/' . $eachItem['id'];

                $line .= "!" . (($eachItem['current_process_status'] == 'O') ? "Order" : "Partial Delivery");

                $line .= "!" . date("d/m/Y", strtotime($eachItem['order_date']));

                $line .= "!" . date("d/m/Y", strtotime($eachItem['delivery_date']));

                $line .= "!" . $eachItem['customer_name'];

                $line .= "!" . $user->first_name . ' ' . $user->last_name;

                $line .= "!" . $eachItem['netQuantity'];

                $line .= "!" . number_format((float) ($eachItem['deliveredQuantity']), 3, '.', '');

                $line .= "!" . number_format((float) (($eachItem['netQuantity'] - $eachItem['deliveredQuantity'])), 3, '.', '');

                $line .= "!" . Yii::app()->numberFormatter->formatCurrency(($eachItem['netAmount'] - $eachItem['deliveredAmount']), "");



                $list[$m++] = $line;
            }
        }



        $file = fopen("uploads/csvs/test.csv", "w");

        foreach ($list as $line) {

            fputcsv($file, explode('!', $line));
        }



        fclose($file);



        $filename = 'uploads/csvs/test.csv';



        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';



        header('Content-Type: application/csv');



        header("Content-disposition: attachment; filename=\"Orders_to_be_Delivered.csv\"");



        readfile($filename);



        Yii::app()->end();



        return;
    }

    public function actionPrintOrdersToBeDeliveredPDF() {



        $customer_id = Yii::app()->request->getParam('customer_id');

        $country = Yii::app()->request->getParam('country');

        $from_date = Yii::app()->request->getParam('from_date');

        $to_date = Yii::app()->request->getParam('to_date');

        $leadowner_id = Yii::app()->request->getParam('leadowner_id');

        $param = array('customer_id' => $customer_id,
            'country' => $country,
            'leadowner_id' => $leadowner_id,
            'from_date' => $from_date,
            'to_date' => $to_date);

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.order_to_deliver', array('model' => $model, 'params' => $param), true));



        $mpdf->Output("OrdersToBeDelivered", 'I');
    }

    public function actionPrintOrdersToBeDeliveredDetailed() {



        $customer_id = $_POST['customer_id'];

        $country = $_POST['country'];

        $from_date = $_POST['from_date'];

        $to_date = $_POST['to_date'];

        $leadowner_id = $_POST['leadowner_id'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_order_to_deliver_detailed', array('vendor' => $vendor, 'country' => $country, 'leadowner_id' => $leadowner_id, 'from_date' => $from_date, 'to_date' => $to_date), false, true);
    }

    public function actionPrintOrdersToBeDeliveredDetailedPdf() {

        ini_set('max_execution_time', 900);

        $customer_id = Yii::app()->request->getParam('customer_id');

        $country = Yii::app()->request->getParam('country');

        $from_date = Yii::app()->request->getParam('from_date');

        $to_date = Yii::app()->request->getParam('to_date');

        $leadowner_id = Yii::app()->request->getParam('leadowner_id');



        $param = array(
            'customer_id' => $customer_id,
            'country' => $country,
            'from_date' => $from_date,
            'to_date' => $to_date,
            'leadowner_id' => $leadowner_id,
        );

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.order_to_deliver_detailed', $param, true));



        $mpdf->Output("reorder_level_list", 'I');
    }

    public function actionPrintOrdersToBeDeliveredDetailedExcel() {
        
    }

    public function actionPrintDeliverytoInvoiceList() {

        $from_date = Yii::app()->request->getParam('from_date');

        //echo $del_from_date;
        //die();

        $to_date = Yii::app()->request->getParam('to_date');

        $customer_id = Yii::app()->request->getParam('customer_id');

        $leadowner_id = Yii::app()->request->getParam('leadowner_id');

        $shipped_by = Yii::app()->request->getParam('shipped_by');

        $country = Yii::app()->request->getParam('country');

        $file = fopen("uploads/csvs/test.csv", "w");

        $condition = 't.isActive="Y" AND (file.current_process_status IN  ("D","PD") OR t.invoiced = "N" ) ';

        $model = new DeliveryNote();

        if ($customer_id > 0)
            $condition .= ' AND t.customer_id="' . $customer_id . '"';

        if ($country > 0)
            $condition .= ' AND customer.customer_country="' . $country . '"';

        if ($shipped_by > 0)
            $condition .= ' AND t.shipped_by=' . $shipped_by;

        if ($from_date != '') {

            $from_date = str_replace('/', '-', $from_date);

            $from_date = date('Y-m-d', strtotime($from_date));

            $condition .= ' AND t.delivery_date >="' . $from_date . '"';
        }

        if ($to_date != '') {

            $to_date = str_replace('/', '-', $to_date);

            $to_date = date('Y-m-d', strtotime($to_date));

            $condition .= ' AND t.delivery_date <="' . $to_date . '"';
        }

        $customer = $model->with('file', 'file.customer')->findAll(array('condition' => $condition));

        $j = 0;















        $list[$j++] = 'No/File-Order-Dly.No./Delivery Date/File Title/Customer/';



        foreach ($customer as $i => $row) {





            $list[$j++] = ($i + 1) . '/' . $row->file->id . '-' . $row->order_id . '-' . $row->id . '/' . date("d-m-Y", strtotime($row->delivery_date)) . '/' . $row->file->file_title . '/' . $row->file->customer->customer_name;
        }



        $j++;



        foreach ($list as $line) {

            fputcsv($file, explode('/', $line));
        }



        fclose($file);



        $filename = 'uploads/csvs/test.csv';







        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';



        header('Content-Type: application/csv');



        header("Content-disposition: attachment; filename=\"invoice.csv\"");



        readfile($filename);



        Yii::app()->end();



        return;
    }

    public function actionPrintSalesDaybookReport() {







        $day_book_type = Yii::app()->request->getParam('day_book_type');



        $day_book_start_date = Yii::app()->request->getParam('day_book_start_date');



        $day_book_end_date_time_stamp = strtotime(date("Y-m-d", strtotime($day_book_start_date)) . " +1 day");

        $day_book_end_date = strftime('%Y-%m-%d', $day_book_end_date_time_stamp);



        $day_book_start_date_display = strftime('%d/%m/%Y', strtotime($day_book_start_date));







        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_SalesDaybookReport', array('day_book_start_date' => $day_book_start_date, 'day_book_type' => $day_book_type), false, true);
    }

    public function actionPrintSalesDaybookReportexcel() {

        $day_book_type = Yii::app()->request->getParam('day_book_type');



        $day_book_start_date = Yii::app()->request->getParam('day_book_start_date');





        $day_book_start_date_display = strftime('%d/%m/%Y', strtotime($day_book_start_date));



        $heading = " Type!File No!No!Customer/Supplier!Currency!Amount!Amount(BC)";

        $m = 0;

        $list[$m++] = $heading;





        //echo $day_book_type;



        $arr_day_book_start_date = explode("/", $day_book_start_date);

        $day_book_start_date = $arr_day_book_start_date[2] . "-" . $arr_day_book_start_date[1] . "-" . $arr_day_book_start_date[0];





        $day_book_end_date_time_stamp = strtotime(date("Y-m-d", strtotime($day_book_start_date)) . " +1 day");

        $day_book_end_date = strftime('%Y-%m-%d', $day_book_end_date_time_stamp);







        $arr_day_book_report = array();

        $query = "";



        $condition_quotes = "WHERE Q.isActive='Y'";

        if ($day_book_start_date != "" && $day_book_end_date != "")
            $condition_quotes .= " AND Q.qtn_start_date >= '" . $day_book_start_date . "' AND Q.qtn_start_date < '" . $day_book_end_date . "'";





        if ($day_book_start_date != "" && $day_book_end_date != "")
            $condition_order .= " AND O.order_date >= '" . $day_book_start_date . "' AND O.order_date < '" . $day_book_end_date . "'";



        $condition_delivery_note = "WHERE DL.isActive='Y'";

        if ($day_book_start_date != "" && $day_book_end_date != "")
            $condition_delivery_note .= " AND DL.delivery_date >= '" . $day_book_start_date . "' AND DL.delivery_date < '" . $day_book_end_date . "'";



        $condition_invoice = "WHERE I.isActive='Y'  AND I.invoice_status!='C' ";

        if ($day_book_start_date != "" && $day_book_end_date != "")
            $condition_invoice .= " AND I.invoice_date >= '" . $day_book_start_date . "' AND I.invoice_date < '" . $day_book_end_date . "'";



        $condition_credit_note = "WHERE CN.isActive='Y'";

        if ($day_book_start_date != "" && $day_book_end_date != "")
            $condition_credit_note .= " AND CN.credited_date >= '" . $day_book_start_date . "' AND CN.credited_date < '" . $day_book_end_date . "'";



        $condition_purchase_enquiry = "WHERE PE.isActive='Y'";

        if ($day_book_start_date != "" && $day_book_end_date != "")
            $condition_purchase_enquiry .= " AND PE.enquiry_date >= '" . $day_book_start_date . "' AND PE.enquiry_date < '" . $day_book_end_date . "'";



        $condition_purchase_order = "";

        if ($day_book_start_date != "" && $day_book_end_date != "")
            $condition_purchase_order .= " WHERE PO.order_date >= '" . $day_book_start_date . "' AND PO.order_date < '" . $day_book_end_date . "'";



        $condition_material_receipt = "WHERE MR.qcchecked='Y' AND MF.current_process_status='P_MR'";

        if ($day_book_start_date != "" && $day_book_end_date != "")
            $condition_material_receipt .= " AND MR.mrv_receipt_date >= '" . $day_book_start_date . "' AND MR.mrv_receipt_date < '" . $day_book_end_date . "'";



        $condition_quality_check = "WHERE QC.qcchecked='N' AND MF.current_process_status='P_MR'";

        if ($day_book_start_date != "" && $day_book_end_date != "")
            $condition_quality_check .= " AND QC.mrv_receipt_date >= '" . $day_book_start_date . "' AND QC.mrv_receipt_date < '" . $day_book_end_date . "'";



        $condition_purchase_invoice = "";

        if ($day_book_start_date != "" && $day_book_end_date != "")
            $condition_purchase_invoice .= " WHERE PI.invoice_date >= '" . $day_book_start_date . "' AND PI.invoice_date < '" . $day_book_end_date . "'";



        $condition_debit_note = "WHERE DN.isActive='Y'";

        if ($day_book_start_date != "" && $day_book_end_date != "")
            $condition_debit_note .= " AND DN.debited_date >= '" . $day_book_start_date . "' AND DN.debited_date < '" . $day_book_end_date . "'";





        if ($day_book_type == 'Q') {

            $query = "SELECT 'Quotes' AS type,file_id,Q.id AS action_id,customer_name,currency_code,Q.exchange_rate,grand_total AS amount FROM {{quotes}} AS Q

        			INNER JOIN {{master_file}} AS MF ON Q.file_id=MF.id

        			INNER JOIN {{customer}} AS CP ON Q.customer_id=CP.id

        			INNER JOIN {{mas_currency}} AS CR ON Q.currency=CR.id " . $condition_quotes;
        } elseif ($day_book_type == 'O') {

            $query = "SELECT 'Order' AS type,file_id,O.id AS action_id,customer_name,currency_code,O.exchange_rate,grand_total AS amount FROM {{order}} AS O

        			INNER JOIN {{master_file}} AS MF ON O.file_id=MF.id

        			INNER JOIN {{customer}} AS CP ON O.customer_id=CP.id

        			INNER JOIN {{mas_currency}} AS CR ON O.currency=CR.id " . $condition_order;
        } elseif ($day_book_type == 'DL') {

            $query = "SELECT 'Delivery Note' AS type,file_id,DL.id AS action_id,customer_name,'' AS currency_code,'0.00' AS exchange_rate,'0.00' AS amount FROM {{delivery_note}} AS DL

        			INNER JOIN {{master_file}} AS MF ON DL.file_id=MF.id

        			INNER JOIN {{customer}} AS CP ON DL.customer_id=CP.id " . $condition_delivery_note;
        } elseif ($day_book_type == 'I') {

            $query = "SELECT 'Invoice' AS type,file_id,I.id AS action_id,customer_name,currency_code,I.exchange_rate,grand_total AS amount FROM {{invoice}} AS I

        			INNER JOIN {{master_file}} AS MF ON I.file_id=MF.id

        			INNER JOIN {{customer}} AS CP ON I.customer_id=CP.id

        			INNER JOIN {{mas_currency}} AS CR ON I.currency=CR.id " . $condition_invoice;
        } elseif ($day_book_type == 'CN') {

            $query = "SELECT 'Credit Note' AS type,file_id,CN.id AS action_id,customer_name,currency_code,CN.exchange_rate,(SELECT SUM(net_amount+tax_vat_amount) FROM {{creditnote_item}} AS CI WHERE CI.creditnote_id=CN.id) AS amount FROM {{creditnote}} AS CN

        			INNER JOIN {{master_file}} AS MF ON CN.file_id=MF.id

        			INNER JOIN {{customer}} AS CP ON CN.customer_id=CP.id

        			LEFT JOIN {{mas_currency}} AS CR ON CN.currency=CR.id " . $condition_credit_note;
        } elseif ($day_book_type == 'PE') {

            $query = "SELECT 'Purchase Enquiry' AS type,'0' AS file_id,PE.id AS action_id,CP.vendor_name AS customer_name,'' AS currency_code,'0.00' AS exchange_rate,'0.00' AS amount FROM {{purchasing_enquiry}} AS PE

        			INNER JOIN {{vendor}} AS CP ON PE.vendor_id=CP.id " . $condition_purchase_enquiry;
        } elseif ($day_book_type == 'PO') {

            $query = "SELECT 'Purchase Order' AS type,file_id,PO.id AS action_id,CP.vendor_name AS customer_name,currency_code,PO.exchange_rate,(SELECT SUM(stock_item_amount+tax_amount) FROM {{purchasing_order_stock_item}} AS POI WHERE POI.purchasing_order_id=PO.id) AS amount FROM {{purchasing_order}} AS PO

					INNER JOIN {{master_file}} AS MF ON PO.file_id=MF.id

        			INNER JOIN {{vendor}} AS CP ON PO.vendor_id=CP.id

        			INNER JOIN {{mas_currency}} AS CR ON PO.currency=CR.id " . $condition_purchase_order;
        } elseif ($day_book_type == 'MR') {

            $query = "SELECT 'Material Receipt' AS type,file_id,MR.id AS action_id,CP.vendor_name AS customer_name,'' AS currency_code,'0.00' AS exchange_rate,'0.00' AS amount FROM {{purchasing_material_receipt}} AS MR

        			INNER JOIN {{master_file}} AS MF ON MR.file_id=MF.id

        			INNER JOIN {{vendor}} AS CP ON MR.vendor_id=CP.id " . $condition_material_receipt;
        } elseif ($day_book_type == 'QC') {

            $query = "SELECT 'Quality Check' AS type,file_id,QC.id AS action_id,CP.vendor_name AS customer_name,'' AS currency_code,'0.00' AS exchange_rate,'0.00' AS amount FROM {{purchasing_material_receipt}} AS QC

        			INNER JOIN {{master_file}} AS MF ON QC.file_id=MF.id

        			INNER JOIN {{vendor}} AS CP ON QC.vendor_id=CP.id " . $condition_quality_check;
        } elseif ($day_book_type == 'PI') {

            $query = "SELECT 'Purchase Invoice' AS type,file_id,PI.id AS action_id,CP.vendor_name AS customer_name,currency_code,PI.exchange_rate,(SELECT SUM(net_amount+tax_amount) FROM {{purchasinginvoice_item}} AS PII WHERE PII.purchasing_invoice_id=PI.id) AS amount FROM {{purchasinginvoice}} AS PI

					INNER JOIN {{master_file}} AS MF ON PI.file_id=MF.id

        			INNER JOIN {{vendor}} AS CP ON PI.vendor_id=CP.id

        			INNER JOIN {{mas_currency}} AS CR ON PI.currency=CR.id " . $condition_purchase_invoice;
        } elseif ($day_book_type == 'DN') {

            $query = "SELECT 'Debit Note' AS type,file_id,DN.id AS action_id,CP.vendor_name AS customer_name,currency_code,DN.exchange_rate,(SELECT SUM(net_amount+tax_vat_amount) FROM {{purchasing_debit_note_item}} AS PCI WHERE PCI.purchasing_debitnote_id=DN.id) AS amount FROM {{purchasing_debit_note}} AS DN

        			INNER JOIN {{master_file}} AS MF ON DN.file_id=MF.id

        			INNER JOIN {{vendor}} AS CP ON DN.vendor_id=CP.id

        			LEFT JOIN {{mas_currency}} AS CR ON DN.currency=CR.id " . $condition_debit_note;
        } else {

            $query = "SELECT 'Quotes' AS type,file_id,Q.id AS action_id,customer_name,currency_code,Q.exchange_rate,grand_total AS amount FROM {{quotes}} AS Q

        			INNER JOIN {{master_file}} AS MF ON Q.file_id=MF.id

        			INNER JOIN {{customer}} AS CP ON Q.customer_id=CP.id

        			INNER JOIN {{mas_currency}} AS CR ON Q.currency=CR.id " . $condition_quotes;



            $query .= " UNION ";



            $query .= "SELECT 'Order' AS type,file_id,O.id AS action_id,customer_name,currency_code,O.exchange_rate,grand_total AS amount FROM {{order}} AS O

        			INNER JOIN {{master_file}} AS MF ON O.file_id=MF.id

        			INNER JOIN {{customer}} AS CP ON O.customer_id=CP.id

        			INNER JOIN {{mas_currency}} AS CR ON O.currency=CR.id " . $condition_order;



            $query .= " UNION ";



            $query .= "SELECT 'Delivery Note' AS type,file_id,DL.id AS action_id,customer_name,'' AS currency_code,'0.00' AS exchange_rate,'0.00' AS amount FROM {{delivery_note}} AS DL

        			INNER JOIN {{master_file}} AS MF ON DL.file_id=MF.id

        			INNER JOIN {{customer}} AS CP ON DL.customer_id=CP.id " . $condition_delivery_note;



            $query .= " UNION ";



            $query .= "SELECT 'Invoice' AS type,file_id,I.id AS action_id,customer_name,currency_code,I.exchange_rate,grand_total AS amount FROM {{invoice}} AS I

        			INNER JOIN {{master_file}} AS MF ON I.file_id=MF.id

        			INNER JOIN {{customer}} AS CP ON I.customer_id=CP.id

        			INNER JOIN {{mas_currency}} AS CR ON I.currency=CR.id " . $condition_invoice;





            $query .= " UNION ";



            $query .= "SELECT 'Credit Note' AS type,file_id,CN.id AS action_id,customer_name,currency_code,CN.exchange_rate,(SELECT SUM(net_amount+tax_vat_amount) FROM {{creditnote_item}} AS CI WHERE CI.creditnote_id=CN.id) AS amount FROM {{creditnote}} AS CN

        			INNER JOIN {{master_file}} AS MF ON CN.file_id=MF.id

        			INNER JOIN {{customer}} AS CP ON CN.customer_id=CP.id

        			LEFT JOIN {{mas_currency}} AS CR ON CN.currency=CR.id " . $condition_credit_note;





            $query .= " UNION ";



            $query .= "SELECT 'Purchase Enquiry' AS type,'0' AS file_id,PE.id AS action_id,CP.vendor_name AS customer_name,'' AS currency_code,'0.00' AS exchange_rate,'0.00' AS amount FROM {{purchasing_enquiry}} AS PE

        			INNER JOIN {{vendor}} AS CP ON PE.vendor_id=CP.id " . $condition_purchase_enquiry;



            $query .= " UNION ";



            $query .= "SELECT 'Purchase Order' AS type,file_id,PO.id AS action_id,CP.vendor_name AS customer_name,currency_code,PO.exchange_rate,(SELECT SUM(stock_item_amount+tax_amount) FROM {{purchasing_order_stock_item}} AS POI WHERE POI.purchasing_order_id=PO.id) AS amount FROM {{purchasing_order}} AS PO

					INNER JOIN {{master_file}} AS MF ON PO.file_id=MF.id

        			INNER JOIN {{vendor}} AS CP ON PO.vendor_id=CP.id

        			INNER JOIN {{mas_currency}} AS CR ON PO.currency=CR.id " . $condition_purchase_order;



            $query .= " UNION ";



            $query .= "SELECT 'Material Receipt' AS type,file_id,MR.id AS action_id,CP.vendor_name AS customer_name,'' AS currency_code,'0.00' AS exchange_rate,'0.00' AS amount FROM {{purchasing_material_receipt}} AS MR

        			INNER JOIN {{master_file}} AS MF ON MR.file_id=MF.id

        			INNER JOIN {{vendor}} AS CP ON MR.vendor_id=CP.id " . $condition_material_receipt;



            $query .= " UNION ";



            $query .= "SELECT 'Quality Check' AS type,file_id,QC.id AS action_id,CP.vendor_name AS customer_name,'' AS currency_code,'0.00' AS exchange_rate,'0.00' AS amount FROM {{purchasing_material_receipt}} AS QC

        			INNER JOIN {{master_file}} AS MF ON QC.file_id=MF.id

        			INNER JOIN {{vendor}} AS CP ON QC.vendor_id=CP.id " . $condition_quality_check;



            $query .= " UNION ";



            $query .= "SELECT 'Purchase Invoice' AS type,file_id,PI.id AS action_id,CP.vendor_name AS customer_name,currency_code,PI.exchange_rate,(SELECT SUM(net_amount+tax_amount) FROM {{purchasinginvoice_item}} AS PII WHERE PII.purchasing_invoice_id=PI.id) AS amount FROM {{purchasinginvoice}} AS PI

					INNER JOIN {{master_file}} AS MF ON PI.file_id=MF.id

        			INNER JOIN {{vendor}} AS CP ON PI.vendor_id=CP.id

        			INNER JOIN {{mas_currency}} AS CR ON PI.currency=CR.id " . $condition_purchase_invoice;







            $query .= " UNION ";



            $query .= "SELECT 'Debit Note' AS type,file_id,DN.id AS action_id,CP.vendor_name AS customer_name,currency_code,DN.exchange_rate,(SELECT SUM(net_amount+tax_vat_amount) FROM {{purchasing_debit_note_item}} AS PCI WHERE PCI.purchasing_debitnote_id=DN.id) AS amount FROM {{purchasing_debit_note}} AS DN

        			INNER JOIN {{master_file}} AS MF ON DN.file_id=MF.id

        			INNER JOIN {{vendor}} AS CP ON DN.vendor_id=CP.id

        			LEFT JOIN {{mas_currency}} AS CR ON DN.currency=CR.id " . $condition_debit_note;
        }









        //echo $query;
        //die();













        $arr_day_book_report = Yii::app()->db->createCommand($query)->queryAll();









        foreach ($arr_day_book_report as $eachItem) {



            $net_amount = $eachItem['amount'];

            if ($eachItem['exchange_rate'] != '0.00' && $eachItem['exchange_rate'] != 0)
                $net_amount = $eachItem['amount'] * $eachItem['exchange_rate'];



            $class = $class == "odd" ? "even" : "odd";

            $list[$m++] = $eachItem['type'] . "!" . $eachItem['file_id'] . "!" . $eachItem['action_id'] . "!" . $eachItem['customer_name']
                    . "!" . $eachItem['currency_code'] . "!" . $eachItem['amount'] . "!" . $net_amount;
        }



        $file = fopen("uploads/csvs/test.csv", "w");

        foreach ($list as $line) {

            fputcsv($file, explode('!', $line));
        }



        fclose($file);



//$filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $filename = 'uploads/csvs/test.csv';



        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';



        header('Content-Type: application/csv;');



        header("Content-disposition: attachment; filename=\"SalesDaybookReport.csv\"");



        readfile($filename);



        Yii::app()->end();



        return;
    }

    public function actionSalesDaybookReportPDF() {







        $day_book_type = Yii::app()->request->getParam('day_book_type');



        $day_book_start_date = Yii::app()->request->getParam('day_book_start_date');



        $day_book_end_date_time_stamp = strtotime(date("Y-m-d", strtotime($day_book_start_date)) . " +1 day");

        $day_book_end_date = strftime('%Y-%m-%d', $day_book_end_date_time_stamp);



        $day_book_start_date_display = strftime('%d/%m/%Y', strtotime($day_book_start_date));



        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $mpdf->SetTitle('Day Book Report');

        $mpdf->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);

        $mpdf->showWatermarkImage = true;

        $mpdf->watermarkImageAlpha = 0.09;

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $param = array('day_book_start_date' => $day_book_start_date,
            'day_book_type' => $day_book_type);

        $mpdf->WriteHTML($this->renderPartial("application.views.front.reports.pdf.SalesDaybookReport", $param, true));

        $mpdf->Output('Balance Sheet.pdf', 'I');
    }

    /*     * ********   arul 12-2-2018  ************************ */

    public function actionPrintZeroBaseCostPriceProduct() {



        $part_no = $_POST['part_no'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_zero_base_costprice_product', array('part_no' => $part_no), false, true);
    }

    /*     * ********   arul 20-2-2018  ************************ */

    public function actionPrintReorderLevelList() {

        $model = new Inventory();

        $brand_id = $_POST['brand_id'];

        $part_no = $_POST['part_no'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_reorder_level_list', array('model' => $model, 'brand_id' => $brand_id, 'part_no' => $part_no), false, true);
    }

    public function actionPrintReorderLevelExcel() {

        $model = new Inventory();

        $brand_id = Yii::app()->request->getParam('brand_id');

        $part_no = Yii::app()->request->getParam('part_no');



        $j = 0;

        $list[$j++] = 'Part Number,Description,Brand,Reorder Level,Reorder Lot,Total Qty,Alloc.Qty,Free Qty,PO. Qty';



        $toalval = 0;

        $type_id = "";

        $sl = 0;

        $condition = 're_order_level > 0 AND inventory_item_type=1 AND isActive="Y"';

        if ($part_no != '') {

            $condition .= ' AND t.part_number LIKE "%' . $part_no . '%"';
        }

        if ($brand_id != '') {

            $condition .= ' AND t.brand_class_id=' . $brand_id;
        }

        $model_inventory = Store::model()->findAll(array('condition' => $condition, 'order' => 'part_number,description asc'));

        foreach ($model_inventory as $i => $model) {



            $model_temp = StockLedger::model()->find(array(
                'select' => 'SUM(quantity) AS quantity', 'condition' => 'product_id = ' . $model->id
            ));

            $indirect_model = new InventoryIndirectTransferItem();

            $available_qty = $indirect_model->with('parent', 'unitdetails')->find(array('select' => '(SUM(transfer_qty-damaged_qty-transferred_qty)) * unitdetails.factor AS available_qty', 'condition' => 'parent.is_complete!="Y" AND t.item_id="' . $model->id . '"', 'group' => 't.item_id'))->available_qty;

            $damaged_qty1 = $indirect_model->with('parent', 'unitdetails')->find(array('select' => '(SUM(t.damaged_qty)) * unitdetails.factor AS damaged_qty', 'condition' => 't.item_id="' . $model->id . '" AND t.damaged_qty !="0"', 'group' => 't.item_id'))->damaged_qty;

            $creditnote_model = new CreditnoteItem();

            $damaged_qty2 = $creditnote_model->with('parent', 'orderunit')->find(array('select' => '(SUM(t.returned_quantity)) * orderunit.factor AS returned_quantity', 'condition' => 'parent.sales_return="DA" AND t.product_id="' . $model->id . '" AND t.returned_quantity !="0"', 'group' => 't.product_id'))->returned_quantity;

            $damaged_qty = $damaged_qty1 + $damaged_qty2;



            $quantity = $model_temp->quantity + $damaged_qty + $available_qty;





            $total_allocated_quantity = $model->total_allocated_quantity;



            $total_free_quantity = $quantity - $total_allocated_quantity;









            $product_id = $row['id'];

            $purchase_sql = 'SELECT SUM(stock_item_quantity) AS stock_item_quantity

                                        FROM erp_purchasing_order_stock_item POI

                                        LEFT JOIN erp_purchasing_order PO

                                            ON POI.purchasing_order_id=PO.id

                                        LEFT JOIN erp_master_file F

                                            ON PO.file_id=F.id

                                        WHERE POI.stock_item_id=' . $model->id . ' AND (F.current_process_status="P_O" OR F.current_process_status="M_R")';

            $po_qty = Yii::app()->db->createCommand($purchase_sql)->queryScalar();



            $total_po_qty = preg_replace('/\s\d+\.00/', '', floatval($po_qty));





            $reorder_checking_qty = $total_free_quantity + $total_po_qty;



            //if ($reorder_checking_qty < $model->re_order_level) {

            $sl++;

            $list[$j++] = $model->part_number . ',' . $model->description . ',' . $model->brand_detail->product_class . ',' . $model->re_order_level . ',' . $model->re_order_lot . ',' . $quantity . ',' . $total_allocated_quantity . ',' . $total_free_quantity . ',' . $total_po_qty;
            //}
        }









        $file = fopen("uploads/csvs/test.csv", "w");

        foreach ($list as $line) {

            fputcsv($file, explode(',', $line));
        }



        fclose($file);





        $filename = 'uploads/csvs/test.csv';



        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';



        header('Content-Type: application/csv;');



        header("Content-disposition: attachment; filename=\"ReorderLevelExcel.csv\"");



        readfile($filename);



        Yii::app()->end();



        return;
    }

    public function actionPrintReorderLevelPdf() {

        $model = new Inventory();

        $brand_id = Yii::app()->request->getParam('brand_id');

        $part_no = Yii::app()->request->getParam('part_no');



        $param = array(
            'brand_id' => $brand_id,
            'part_no' => $part_no
        );

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.reorder_level_list', $param, true));



        $mpdf->Output("reorder_level_list", 'I');
    }

    public function actionPrintMinimumOrderList() {

        $model = new Inventory();

        $brand_id = $_POST['brand_id'];

        $part_no = $_POST['part_no'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_minimum_order_qty_list', array('model' => $model, 'brand_id' => $brand_id, 'part_no' => $part_no), false, true);
    }

    public function actionPrintMinimumOrderExcel() {

        $model = new Inventory();

        $brand_id = Yii::app()->request->getParam('brand_id');

        $part_no = Yii::app()->request->getParam('part_no');

        //$heading = 'Part Number,Description,Brand,Reorder Level,Reorder Lot,Total Qty,Alloc.Qty,Free Qty,PO. Qty ';

        $heading = 'Part Number,Description,Brand,Reorder Level';

        $j = 0;

        $list[$j++] = $heading;

        $toalval = 0;

        $type_id = "";

        $condition = 're_order_level > 0 AND inventory_item_type=1 AND isActive="Y"';

        if ($part_no != '') {

            $condition .= ' AND t.part_number LIKE "%' . $part_no . '%"';
        }

        if ($brand_id != '') {

            $condition .= ' AND t.brand_class_id=' . $brand_id;
        }

        $model_inventory = Store::model()->findAll(array('condition' => $condition, 'order' => 'part_number,description asc'));

        foreach ($model_inventory as $i => $model) {



            /* $model_temp = ProductLocation::model()->find(array(
              'select' => 'SUM(quantity) AS quantity', 'condition' => 'stock_id = ' . $model->id
              ));

              $indirect_model = new InventoryIndirectTransferItem();

              $available_qty = $indirect_model->with('parent', 'unitdetails')->find(array('select' => '(SUM(transfer_qty-damaged_qty-transferred_qty)) * unitdetails.factor AS available_qty', 'condition' => 'parent.is_complete!="Y" AND t.item_id="' . $model->id . '"', 'group' => 't.item_id'))->available_qty;

              $damaged_qty1 = $indirect_model->with('parent', 'unitdetails')->find(array('select' => '(SUM(t.damaged_qty)) * unitdetails.factor AS damaged_qty', 'condition' => 't.item_id="' . $model->id . '" AND t.damaged_qty !="0"', 'group' => 't.item_id'))->damaged_qty;

              $creditnote_model = new CreditnoteItem();

              $damaged_qty2 = $creditnote_model->with('parent', 'orderunit')->find(array('select' => '(SUM(t.returned_quantity)) * orderunit.factor AS returned_quantity', 'condition' => 'parent.sales_return="DA" AND t.product_id="' . $model->id . '" AND t.returned_quantity !="0"', 'group' => 't.product_id'))->returned_quantity;

              $damaged_qty = $damaged_qty1 + $damaged_qty2;



              $quantity = $model_temp->quantity + $damaged_qty + $available_qty;





              $total_allocated_quantity = $model->total_allocated_quantity;



              $total_free_quantity = $quantity - $total_allocated_quantity;





              $product_id = $row['id'];

              $purchase_sql = 'SELECT SUM(stock_item_quantity) AS stock_item_quantity

              FROM erp_purchasing_order_stock_item POI

              LEFT JOIN erp_purchasing_order PO

              ON POI.purchasing_order_id=PO.id

              LEFT JOIN erp_master_file F

              ON PO.file_id=F.id

              WHERE POI.stock_item_id=' . $model->id . ' AND (F.current_process_status="P_O" OR F.current_process_status="M_R")';

              $po_qty = Yii::app()->db->createCommand($purchase_sql)->queryScalar();



              $total_po_qty = preg_replace('/\s\d+\.00/', '', floatval($po_qty)); */

            //$list[$j] = $model->part_number . ',' . $model->description . ',' . $model->brand_detail->product_class . ',' . $model->re_order_level . ',' . $model->re_order_lot . ',' . $quantity . ',' . $total_allocated_quantity . ',' . $total_free_quantity . ',' . $total_po_qty;

            $list[$j] = $model->part_number . ',' . $model->description . ',' . $model->brand_detail->product_class . ',' . $model->re_order_level;

            $j++;
        }



        $file = fopen("uploads/csvs/test.csv", "w");

        foreach ($list as $line) {

            fputcsv($file, explode(',', $line));
        }



        fclose($file);



//$filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $filename = 'uploads/csvs/test.csv';



        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';



        header('Content-Type: application/csv;');



        header("Content-disposition: attachment; filename=\"MinimumOrder.csv\"");



        readfile($filename);



        Yii::app()->end();



        return;
    }

    public function actionPrintMinimumOrderPdf() {

        $model = new Inventory();

        $brand_id = Yii::app()->request->getParam('brand_id');

        $part_no = Yii::app()->request->getParam('part_no');

        $param = array('brand_id' => $brand_id,
            'part_no' => $part_no);



        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.minimum_order_qty_list.', $param, true));



        $mpdf->Output("minimum_order_qty_list", 'I');
    }

    public function actionPrintInvPriceListReport() {



        $brand = $_POST['brand'];

        $product_id = $_POST['product_id'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_inventory_pricelist', array('brand' => $brand, 'product_id' => $product_id), false, true);
    }

    /*



     */

    public function actionPrintInvInternalPriceListReport() {



        $type = $_POST['type'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_inventory_internal_pricelist', array('type' => $type), false, true);
    }

    public function actionPrintInvInternalPriceExcel() {

        ini_set('memory_limit', '1024M');

        set_time_limit(1200);

        $type = Yii::app()->request->getParam('type');

        $param = array('type' => $type);



        $sql = "SELECT rate,part_number,brand_class_id,id

                            FROM erp_store where isActive='Y' AND inventory_item_type='1' ORDER BY id ASC";

        $model_group = Yii::app()->db->createCommand($sql)->queryAll();



        $heading = 'Part Number,Rate';

        $j = 0;

        $list[$j++] = $heading;



        if (!empty($model_group)) {

            foreach ($model_group AS $model_group) {



                $actual_rate = $model_group['rate'];

                $product_class_id = $model_group['brand_class_id'];





                $arr_master_settings = ProfitSettings::model()->find('product_class_id=' . $product_class_id);

                $landing_cost_percentage = $arr_master_settings['landing_cost_percentage'];

                $internal_cost_percentage = $arr_master_settings->internal_cost_percentage;

                $landing_cost_price = ($actual_rate + ($actual_rate * ($landing_cost_percentage / 100)));

                $incentive_cost_price = ($landing_cost_price + ($landing_cost_price * ($internal_cost_percentage / 100)));





                $model_cost_price = CostPriceGroup::model()->find('product_id=' . $model_group['id']);



                if ($type == 'LCP') {

                    $rate = $landing_cost_price;
                } else if ($type == 'BCP') {

                    $rate = $actual_rate;
                } else if ($type == 'ICP') {

                    $rate = $incentive_cost_price;
                } else if ($type == 'INCP') {

                    $rate = $model_cost_price->cost_price1;
                }

                $list[$j++] = $model_group['part_number'] . ',' . $rate;
            }
        }

        $file = fopen("uploads/csvs/test.csv", "w");

        foreach ($list as $line) {

            fputcsv($file, explode(',', $line));
        }



        fclose($file);



//$filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $filename = 'uploads/csvs/test.csv';



        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';



        header('Content-Type: application/csv;');



        header("Content-disposition: attachment; filename=\"MinimumOrder.csv\"");



        readfile($filename);



        Yii::app()->end();



        return;
    }

    public function actionPrintInvInternalPriceListReportPDF() {

        ini_set('memory_limit', '1024M');

        set_time_limit(1200);

        $type = Yii::app()->request->getParam('type');

        $param = array('type' => $type);

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.inventory_internal_pricelist', $param, true));



        $mpdf->Output("inventory_internal_pricelist", 'I');
    }

    public function actionPrintInvPriceListReportPDF() {

        ini_set('memory_limit', '1024M');

        set_time_limit(1200);

        $brand = Yii::app()->request->getParam('brand');

        $product_id = Yii::app()->request->getParam('product_id');



        $param = array('brand' => $brand,
            'product_id' => $product_id);



        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.inventory_pricelist.', $param, true));



        $mpdf->Output("inventory_pricelist", 'I');
    }

    public function actionPrintInvPriceListReportList() {



        $brand = Yii::app()->request->getParam('brand');

        $model_group_name = SalesPriceGroupName::model()->findAll();



        $file = fopen("uploads/csvs/test1.csv", "w");





        //$model_group       = SalesPriceGroup::model()->with('brand_detail')->findAll(array('condition'=>''));
        //$model_group       = SalesPriceGroup::model()->findAll(array('condition'=>''));



        $sql = "SELECT S.id,S.part_number,SPG.base_sales_price,SPG.sales_price1,SPG.sales_price2,SPG.sales_price3,SPG.sales_price4,SPG.sales_price5,SPG.sales_price6,SPG.sales_price7

                            FROM erp_sales_price_group SPG

                            INNER JOIN erp_store S

                                ON S.id=SPG.product_id

                            where S.brand_class_id=" . $brand . "

                ORDER BY SPG.id ASC ";

        $model_group = Yii::app()->db->createCommand($sql)->queryAll();

        $count = COUNT($model);

        $heading = 'No/Part no';

        foreach ($model_group_name AS $model_group_name) {

            if ($model_group_name['id'] != '7' AND $model_group_name['id'] != '8') {

                $heading .= '/' . $model_group_name['pricing_group_name'];
            }
        }

        $j = 0;















        $list[$j++] = $heading;



        $sno = 1;



        if (!empty($model_group)) {

            foreach ($model_group AS $model_group) {

                $list[$j++] = $sno . '/' . $model_group['part_number'] . '/' . $model_group['base_sales_price'] . '/' . $model_group['sales_price1'] . '/' . $model_group['sales_price2'] . '/' . $model_group['sales_price3'] . '/' . $model_group['sales_price4'] . '/' . $model_group['sales_price5'];

                $sno++;
            }
        }

        $j++;



        foreach ($list as $line) {

            fputcsv($file, explode('/', $line));
        }



        fclose($file);



        //$filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $filename = 'uploads/csvs/test.csv';



        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';



        header('Content-Type: application/csv;');



        header("Content-disposition: attachment; filename=\"Pricelist.csv\"");



        readfile($filename);



        Yii::app()->end();



        return;
    }

    public function actionInvPriceListExcel() {

        $brand = Yii::app()->request->getParam('brand');

        $product_id = Yii::app()->request->getParam('product_id');



        $model_group_name = SalesPriceGroupName::model()->findAll();

        $condition = '1=1';

        if ($brand != '') {

            $condition .= ' AND S.brand_class_id ="' . $brand . '"';
        }

        if ($product_id != '') {

            $condition .= ' AND S.part_number LIKE "%' . $product_id . '%"';
        }



        $sql = "SELECT S.rate,S.brand_class_id,S.id,S.part_number,SPG.base_sales_price,SPG.sales_price1,SPG.sales_price2,SPG.sales_price3,SPG.sales_price4,SPG.sales_price5,SPG.sales_price6,SPG.sales_price7

                            FROM erp_sales_price_group SPG

                            INNER JOIN erp_store S

                                ON S.id=SPG.product_id

                            where " . $condition . "

                ORDER BY SPG.id ASC";





        $model_group = Yii::app()->db->createCommand($sql)->queryAll();

        $heading = 'Part no,BASE SALES PRICE,LANDING COST PRICE,INCENTIVES COST PRICE';



        foreach ($model_group_name AS $model_group_name) {

            if ($model_group_name['id'] != '1' AND $model_group_name['id'] != '7' AND $model_group_name['id'] != '8') {



                $heading .= ',' . $model_group_name['pricing_group_name'];
            }
        }

        $j = 0;



        $list[$j] = $heading;

        $j++;

        if (!empty($model_group)) {

            foreach ($model_group AS $model_group) {



                $actual_rate = $model_group['rate'];

                $product_class_id = $model_group['brand_class_id'];

                $arr_master_settings = ProfitSettings::model()->find('product_class_id=' . $product_class_id);

                $landing_cost_percentage = $arr_master_settings['landing_cost_percentage'];

                $internal_cost_percentage = $arr_master_settings->internal_cost_percentage;

                $landing_cost_price = ($actual_rate + ($actual_rate * ($landing_cost_percentage / 100)));

                $incentive_cost_price = ($landing_cost_price + ($landing_cost_price * ($internal_cost_percentage / 100)));



                $list[$j++] = $model_group['part_number'] . ',' . $model_group['base_sales_price'] . ',' . $actual_rate . ',' . $incentive_cost_price . ',' . $model_group['sales_price1'] . ',' . $model_group['sales_price2'] . ',' . $model_group['sales_price3'] . ',' . $model_group['sales_price4'] . ',' . $model_group['sales_price5'];
            }
        }

        $file = fopen("uploads/csvs/test.csv", "w");

        foreach ($list as $line) {

            fputcsv($file, explode(',', $line));
        }



        fclose($file);



//$filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $filename = 'uploads/csvs/test.csv';



        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';



        header('Content-Type: application/csv;');



        header("Content-disposition: attachment; filename=\"PriceList.csv\"");



        readfile($filename);



        Yii::app()->end();



        return;
    }

    public function actionActivityListExcel() {

        $customer_id = Yii::app()->request->getParam('customer_id');
        $activity_type = Yii::app()->request->getParam('activity_type');
        $activity = Yii::app()->request->getParam('activity');
        $added_from = Yii::app()->request->getParam('added_from');
        $activity_closing_from_date = Yii::app()->request->getParam('activity_closing_from_date');
        $activity_closing_to_date = Yii::app()->request->getParam('activity_closing_to_date');
        $activity_user = Yii::app()->request->getParam('activity_user');
        $header = 'No,From,Customer,Ref#,Type,Date of Activity,Assigned,Follow Up Date,Notes,Activity';
        $j = 0;
        $list[$j++] = $header;
        $condition = '1=1';
        if ($activity_closing_from_date != '') {
            $activity_closing_from_date = str_replace('/', '-', $activity_closing_from_date);
            $activity_closing_from_date = date('Y-m-d', strtotime($activity_closing_from_date));
            $condition .= ' AND t.task_date_time >="' . $activity_closing_from_date . '"';
        }

        if ($activity_closing_to_date != '') {

            $activity_closing_to_date = str_replace('/', '-', $activity_closing_to_date);

            $activity_closing_to_date = date('Y-m-d', strtotime("+1 day", strtotime($activity_closing_to_date)));

            $condition .= ' AND t.task_date_time <="' . $activity_closing_to_date . '"';
        }
        if ($customer_id > 0) {
            $condition .= ' AND t.customer_id ="' . $customer_id . '"';
        }
        if ($activity != '') {
            $condition .= ' AND t.added_from ="' . $activity . '"';
        }
        if ($activity_type != '') {
            $condition .= ' AND t.task_type ="' . $activity_type . '"';
        }
        if ($added_from != '') {
            $condition .= ' AND t.added_from ="' . $added_from . '"';
        }
        if ($activity_user != '') {
            $condition .= ' AND t.assigned_to ="' . $activity_user . '"';
        }
        if (((int) Yii::app()->user->havePermissionOn["activity_view_all"]) == 0) {
            $condition .= ' AND (t.assigned_from="' . Yii::app()->user->id . '" OR t.assigned_to="' . Yii::app()->user->id . '")';
        }
        $model_delivery = Activity::model()->with('customer', 'assignedTo', 'tasktype')->findAll(array('condition' => $condition, 'order' => 't.task_date_time DESC'));

        $userid = "";
        foreach ($model_delivery as $i => $model) {
            $display_added_from = ActivityMasAddedFrom::getActivityFromByCode($model['added_from']);
            // $display_added_from =ActivityMasAddedFrom::getActivityFromByCode($model['added_from']);
            if ($model['added_from'] == 'DI') {

                $type = "Dispute";
            } else if ($model['added_from'] == 'TA') {

                $type = "Task";
            }


            $line = '';

            $customer_name = $model->customer->customer_name;

            if ($model['added_from'] == 'LE') {
                $customer_name = $model['customer_name'];
            }
            $line = $i + 1;
            $line .= ',' . $display_added_from;
            $line .= ',' . $customer_name;

            $line .= ',' . $model->header_id;
            $line .= ',' . $model->tasktype->type;



            if ($model->task_date_time != '0000-00-00 00:00:00') {
                $line .= ',' . date("d/m/Y", strtotime($model->task_date_time));
            } else {
                $line .= ',';
            }
            $line .= ',' . $model->assignedTo->FullName;
            if ($model->task_date_time != '0000-00-00') {

                $line .= ',' . date("d/m/Y H:i:s", strtotime($model->task_date_time));
            } else {

                $line .= ',';
            }
            $line .= ',' . $model->notes;
            $line .= ',' . $type;


            $list[$j++] = $line;
        }
        $file = fopen("uploads/csvs/test.csv", "w");
        foreach ($list as $line) {
            fputcsv($file, explode(',', $line));
        }
        fclose($file);
        $filename = 'uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv;');
        header("Content-disposition: attachment; filename=\"activity.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    public function actionPrintQuoteProbabilityReport() {



        $model = new Quotes();

        $qtn_start_from_date = $_POST['start_from_date'];

        $qtn_start_to_date = $_POST['start_to_date'];

        $probability = $_POST['probability'];

        $customer_id = $_POST['customer_id'];
        $leadowner_id = $_POST['leadowner_id'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_quote_probablity_list', array('model' => $model, 'probability' => $probability, 'qtn_start_from_date' => $qtn_start_from_date,
            'qtn_start_to_date' => $qtn_start_to_date, 'customer_id' => $customer_id, 'leadowner_id' => $leadowner_id, 'title' => $title), false, true);
    }

    public function actionPrintQuoteProbabilityReportPDF() {

        ini_set('memory_limit', '-1');

        $qtn_start_from_date = Yii::app()->request->getParam('qtn_start_from_date');

        $qtn_start_to_date = Yii::app()->request->getParam('qtn_start_to_date');

        $probability = Yii::app()->request->getParam('probability');

        $customer_id = Yii::app()->request->getParam('customer_id');

        $leadowner_id = Yii::app()->request->getParam('leadowner_id');




        $param = array('probability' => $probability,
            'qtn_start_from_date' => $qtn_start_from_date,
            'qtn_start_to_date' => $qtn_start_to_date,
            'customer_id' => $customer_id,
            'leadowner_id' => $leadowner_id);

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.quote_probablity_list', $param, true));



        $mpdf->Output("QuoteProbabilityReport", 'I');
    }

    public function actionPrintQuoteProbabilityReportExcel() {

        ini_set('memory_limit', '-1');

        $qtn_start_from_date = Yii::app()->request->getParam('start_from_date');

        $qtn_start_to_date = Yii::app()->request->getParam('start_to_date');

        $probability = Yii::app()->request->getParam('probability');

        $customer_id = Yii::app()->request->getParam('customer_id');

        $leadowner_id = Yii::app()->request->getParam('leadowner_id');
        $param = array('probability' => $probability,
            'qtn_start_from_date' => $qtn_start_from_date,
            'qtn_start_to_date' => $qtn_start_to_date,
            'customer_id' => $customer_id,
            'leadowner_id' => $leadowner_id);
        $heading = 'No,Qtn No,File No,Company Name,Account Manager,Quotation Date,Validity Date,Sales Group,Probability,Status,Currency,Grand Total(BC)';

        $j = 0;

        $list[$j++] = $heading;

        $condition = '1=1';

        ;

        if ($qtn_start_from_date != '') {

            $qtn_start_from_date = str_replace('/', '-', $qtn_start_from_date);

            $qtn_start_from_date = date('Y-m-d', strtotime($qtn_start_from_date));

            $condition .= ' AND t.qtn_date >="' . $qtn_start_from_date . '"';
        }

        if ($qtn_start_to_date != '') {

            $qtn_start_to_date = str_replace('/', '-', $qtn_start_to_date);

            $qtn_start_to_date = date('Y-m-d', strtotime($qtn_start_to_date));

            $condition .= ' AND t.qtn_date <="' . $qtn_start_to_date . '"';
        }

        if ($customer_id != '') {

            $condition .= ' AND t.company_id ="' . $customer_id . '"';
        }



        if ($probability != '') {

            $condition .= ' AND t.probability ="' . $probability . '"';
        }
        if ($leadowner_id != '') {
            $condition .= ' AND t.lead_owner_id ="' . $leadowner_id . '"';
        }




        $total = 0;

        $model_quote = Quotes::model()->with('file', 'customer', 'probability_details', 'customercontact', 'items.product')->findAll(array('condition' => $condition));

        //print_r($model_quote);echo '<pre>';

        foreach ($model_quote as $i => $model) {

            $single_line = '';



            $single_line = $model->id . ',' . $model->file_id . ',' . $model->customer->customer_name . ',' . $model->file->leadowner->first_name . "," . $model->file->leadowner->last_name;





            if ($model->qtn_date != '0000-00-00') {

                $single_line .= ',' . date("d/m/Y", strtotime($model->qtn_date));
            } else {

                $single_line .= ',';
            }

            if ($model->qtn_validity != '0000-00-00') {

                $single_line .= ',' . date("d/m/Y", strtotime($model->qtn_validity));
            } else {

                $single_line .= ',';
            }



            $single_line .= ',' . $model->salesgroup->group_name . ',' . $model->probability;

            $state = "";

            if ($model->status == 'Y') {

                $state = "Open";
            } else if ($model->status == 'C') {

                $state = "Closed";
            } else if ($model->status == 'O') {

                $state = "Others";
            } elseif ($model->status == 'L') {

                $state = "Lost";
            }





            $single_line .= ',' . $state;



            $single_line .= ',' . $model->currencyname->currency_code;



            $model_currency = MasCurrency::model()->findByPk($model->currency);

            $total_bc = $model->grand_total * $model_currency->exchange_rate;

            $total += $total_bc;



            $single_line .= ',' . $total_bc;

            $list[$j++] = $single_line;
        }



        $file = fopen("uploads/csvs/test.csv", "w");

        foreach ($list as $line) {

            fputcsv($file, explode(',', $line));
        }



        fclose($file);



//$filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $filename = 'uploads/csvs/test.csv';



        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';



        header('Content-Type: application/csv;');



        header("Content-disposition: attachment; filename=\"activity.csv\"");



        readfile($filename);



        Yii::app()->end();



        return;
    }

    public function actionMaterialtomaterial() {

        $part_num = Yii::app()->request->getParam('part_num');

        $brand = Yii::app()->request->getParam('brand');

        $to_date = Yii::app()->request->getParam('to_date');

        $from_date = Yii::app()->request->getParam('from_date');

        $param = array('part_num' => $part_num,
            'brand' => $brand,
            'to_date' => $to_date,
            'from_date' => $from_date);



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_Materialtomaterial', $param, false, true);
    }

    public function actionMaterialtomaterialPDF() {

        $part_num = Yii::app()->request->getParam('part_num');

        $brand = Yii::app()->request->getParam('brand');

        $to_date = Yii::app()->request->getParam('to_date');

        $from_date = Yii::app()->request->getParam('from_date');

        $param = array('part_num' => $part_num,
            'brand' => $brand,
            'to_date' => $to_date,
            'from_date' => $from_date);



        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.materialtomaterial', $param, true));



        $mpdf->Output("Materialtomaterial", 'I');
    }

    public function actionMaterialtomaterialExcel() {

        $part_num = Yii::app()->request->getParam('part_num');

        $brand = Yii::app()->request->getParam('brand');

        $to_date = Yii::app()->request->getParam('to_date');

        $from_date = Yii::app()->request->getParam('from_date');



        $header = 'Date,Movement.No.,From Part.No,To Part.No,From Qty.,To Qty.,Done By';

        $j = 0;

        $list[$j++] = $header;





//-------------------------------



        $condition = '1=1 ';



        if ($brand != '') {

            $condition .= ' AND  ( toproduct.brand_class_id = ' . $brand . ' OR fromproduct.brand_class_id = ' . $brand . ')';
        }

        if ($part_num != '') {

            $condition .= ' AND  ( t.from_product = ' . $part_num . ' OR  t.to_product = ' . $part_num . ')';
        }



        if ($from_date != '') {

            $from_date = str_replace('/', '-', $from_date);

            $from_date = date("Y-m-d", strtotime($from_date));







            $condition .= " AND t.transfer_date>'" . $from_date . "'";
        }

        if ($to_date != '') {

            $to_date = str_replace('/', '-', $to_date);

            $to_date = date("Y-m-d", strtotime($to_date));







            $condition .= " AND t.transfer_date<'" . $to_date . "'";
        }

        $total = 0;



        $model_order = MtomTransfer::model()->with('fromproduct', 'toproduct')->findAll(array('condition' => $condition));



        foreach ($model_order as $i => $data) {

            $model_user = user::model()->findByPk($data->created_by);

            $list[$j++] = $data->transfer_date . ',' . $data->id . ',' . $data->fromproduct->part_number . ',' . $data->toproduct->part_number . ',' . $data->from_qty . ',' . $data->to_qty . ',' . $model_user->username;
        }



//------------------------



        $file = fopen("uploads/csvs/test.csv", "w");

        foreach ($list as $line) {

            fputcsv($file, explode(',', $line));
        }



        fclose($file);



//$filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $filename = 'uploads/csvs/test.csv';



        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';



        header('Content-Type: application/csv;');



        header("Content-disposition: attachment; filename=\"MaterialtomaterialExcel.csv\"");



        readfile($filename);



        Yii::app()->end();



        return;
    }

    public function actionPrintinventoryserialno() {



        $part_num = $_POST['part_num'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_inventory_serialno_list', array('part_num' => $part_num, 'title' => $title), false, true);
    }

    public function actionprintinventorysampletracking() {



        $part_number = $_POST['part_number'];

        $customer_id = $_POST['customer_id'];

        $reference = $_POST['reference'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/printinventorysampletracking', array('part_number' => $part_number, 'reference' => $reference, 'customer_id' => $customer_id, 'title' => $title), false, true);
    }

    public function actionPrintStockTrackingReport() {



        $model = new DeliveryMaterialDetails();





        $stock_tracking = $_POST['stock_tracking'];

        $normal_or_reverse = $_POST['normal_or_reverse'];

        $bill_exit = $_POST['bill_exit'];

        $bill_entry = $_POST['bill_entry'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_bill_of_stocktracking', array('model' => $model, 'normal_or_reverse' => $normal_or_reverse, 'stock_tracking' => $stock_tracking, 'bill_exit' => $bill_exit, 'bill_entry' => $bill_entry), false, true);
    }

    public function actionPrintStokTrackingPDF() {



        $model = new DeliveryMaterialDetails();



        $bill_entry = Yii::app()->request->getParam('bill_entry');

        $bill_exit = Yii::app()->request->getParam('bill_exit');

        $stock_tracking = Yii::app()->request->getParam('stock_tracking');







        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.stock_tracking', array('model' => $model, 'bill_entry' => $bill_entry, 'bill_exit' => $bill_exit, 'stock_tracking' => $stock_tracking, 'title' => $title), true));



        $mpdf->Output($htmlTemplate, 'I');
    }

    public function actionPrintReverseTrackingPDF() {



        $model = new DeliveryMaterialDetails();



        $reverse_tracking = Yii::app()->request->getParam('reverse_tracking');

        $bill_entry = Yii::app()->request->getParam('bill_entry');

        $bill_exit = Yii::app()->request->getParam('bill_exit');

        $product_name = Yii::app()->request->getParam('product_name');







        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.reverse_tracking', array('model' => $model, 'reverse_tracking' => $reverse_tracking, 'bill_entry' => $bill_entry, 'bill_exit' => $bill_exit, 'product_name' => $product_name, 'title' => $title), true));



        $mpdf->Output($htmlTemplate, 'I');
    }

    public function actionPrintReverseTrackingReport() {

        $model = new DeliveryMaterialDetails();





        $reverse_tracking = $_POST['reverse_tracking'];

        $normal_or_reverse = $_POST['normal_or_reverse'];

        $product_name = $_POST['product_name'];

        $bill_exit = $_POST['bill_exit'];

        $bill_entry = $_POST['bill_entry'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_Reversetracking', array('model' => $model, 'normal_or_reverse' => $normal_or_reverse, 'reverse_tracking' => $reverse_tracking, 'product_name' => $product_name, 'bill_exit' => $bill_exit, 'bill_entry' => $bill_entry), false, true);
    }

    public function actionPrintInvsampletrackingPDF() {

        $part_number = Yii::app()->request->getParam('part_number');

        $customer_id = Yii::app()->request->getParam('customer_id');

        $reference = Yii::app()->request->getParam('reference');

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.inventory_sample_tracking', array('part_number' => $part_number, 'reference' => $reference, 'customer_id' => $customer_id), true));



        $mpdf->Output("Materialtomaterial", 'I');
    }

    public function actionPrintInvSerialNoPDF() {

        $part_num = Yii::app()->request->getParam('part_num');

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.inventory_serial_no', array('part_num' => $part_num), true));

        $mpdf->Output("InventorySerialNoReport ", 'I');
    }

    public function actionPrintNetPurchaseReport() {



        $model = new PurchasingInvoice();

        $from_date = $_POST['from_date'];

        $to_date = $_POST['to_date'];

        $vendor_id = $_POST['vendor_id'];

        $inv_type = $_POST['inv_type'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_netpurchase_list', array('model' => $model, 'inv_type' => $inv_type, 'from_date' => $from_date, 'to_date' => $to_date, 'vendor_id' => $vendor_id, 'title' => $title), false, true);
    }

    public function actionPrintInvoiceCommissionInvoiceIncentiveExcel() {

        $customer_id = $_GET['customer_id'];

        $leadowner_id = $_GET['leadowner_id'];

        $from_date = $_GET['from_date'];

        $to_date = $_GET['to_date'];



        $condition = "1=1 ";

        if ($customer_id > 0) {

            $condition .= " AND t.customer_id=" . $customer_id; // //customer_id
        }

        if ($from_date != '') {

            $str_from_date = str_replace('/', '-', $from_date);

            $str_from_date = date("Y-m-d", strtotime($str_from_date));

            $condition .= ' AND t.invoice_date >="' . $str_from_date . '"';
        }

        if ($to_date != '') {

            $str_to_date = str_replace('/', '-', $to_date);

            $str_to_date = date("Y-m-d", strtotime($str_to_date));

            $condition .= ' AND t.invoice_date <="' . $str_to_date . '"';
        }

        if ($leadowner_id > 0) {

            $condition .= " AND file.lead_owner_id=" . $leadowner_id;
        }

        $files = Invoice::model()->with('items', 'returnedAmount', 'file')->findAll(array('condition' => $condition, 'order' => 't.invoice_no ASC'));

        $grand_total = 0;

        $cnt = 0;

        $total_net_sale = 0;

        $total_net_cost_rate = 0;

        $total_profit = 0;



        $filename = 'invoice_incentive';



        $data = '<html>

                    <head>

                        <style>

                            table{

                                width:100%;

                            }

                            .head{

                                background-color : yellow;

                                font-weight: bold;

                                font-size: 14px;

                            }

                            .total{

                                text-align: right;

                                font-weight: bold;

                                font-size: 14px;

                            }

                        </style>

                    </head>

                    <body>

                        <table border=1>

                <thead>

                    <tr>

                        <th class="head">File No</th>

                        <th class="head">Invoice No</th>

                        <th class="head">Invoice Date</th>

                        <th class="head">Customer</th>

                        <th class="head">Account Manager</th>

                        <th class="head">Net Sale</th>

                        <th class="head">Cost Rate</th>

                        <th class="head">Profit</th>

                        <th class="head">Profit(%)</th>

                    </tr>

                </thead>

                <tbody>';

        foreach ($files as $i => $eachFile) {

            $cost_rate = 0;

            $net_cost_rate = 0;

            foreach ($eachFile->items as $products) {

                $quantity = $products->quantity;



                $modelProduct = new Inventory();

                $product_details = $modelProduct->findbypk($products->product_id);



                $actual_rate = $product_details->rate;



                $product_class_id = $product_details->brand_class_id;



                $arr_master_settings = ProfitSettings::model()->find('product_class_id=' . $product_class_id);





                $landing_cost_percentage = $arr_master_settings->landing_cost_percentage;

                $internal_cost_percentage = $arr_master_settings->internal_cost_percentage;



                $landing_cost_price = ($actual_rate + ($actual_rate * ($landing_cost_percentage / 100)));

                $incentive_cost_price = ($landing_cost_price + ($landing_cost_price * ($internal_cost_percentage / 100)));





                $cost_rate = $incentive_cost_price * $quantity;

                $net_cost_rate += $cost_rate;
            }

            //$invoice_total		= $eachFile->grand_total;

            $invoice_total = ($eachFile->grand_total - $eachFile->total_tax_amount);

            //$credit_total 		= $eachFile->returnedAmount;

            $credit_total = ($eachFile->returnedAmount - $eachFile->returnedVATAmount);

            $net_total = (($invoice_total - $credit_total) * $eachFile->file->order->exchange_rate);

            $grand_total = $grand_total + $net_total;

            $profit = 0;

            if ($net_total > 0)
                $profit = $net_total - $net_cost_rate;

            $profit_in_percentage = ($net_total > 0) ? round(($profit / $net_total) * 100, 2) : 0;





            $invoice_no = $eachFile->invoice_no;

            $invoice_type = $eachFile->invoice_type;

            if ((int) $invoice_type > 0) {

                $modelInvoiceType = new MasInvoiceType();

                $arr_invoice_type_details = $modelInvoiceType->findByPk((int) $invoice_type);

                $inv_code = $arr_invoice_type_details->inv_code;

                $invoice_no = $inv_code . '-' . $invoice_no;
            }



            $leadOwnerName = "";

            if (isset($eachFile->file->leadowner->first_name))
                $leadOwnerName = $eachFile->file->leadowner->first_name . " " . $eachFile->file->leadowner->last_name;



            $data .= '<tr>

                    <td class = "cell-left">' . $eachFile->file_id . '</td>

                    <td class = "cell-left">' . $invoice_no . '</td>

                    <td>' . date("d/m/Y", strtotime($eachFile->invoice_date)) . '</td>

                    <td class = "cell-left">' . $eachFile->customer->customer_name . '</td>

                    <td class = "cell-left">' . $leadOwnerName . '</td>

                    <td  class="text-right">' . Yii::app()->numberFormatter->formatCurrency($net_total, "") . '</td>

                    <td  class="text-right">' . Yii::app()->numberFormatter->formatCurrency($net_cost_rate, "") . '</td>

                    <td  class="text-right">' . Yii::app()->numberFormatter->formatCurrency($profit, "") . '</td>

                    <td  class="text-right">' . Yii::app()->numberFormatter->formatCurrency($profit_in_percentage, "") . '</td>

                </tr>';

            $total_net_sale += $net_total;

            $total_net_cost_rate += $net_cost_rate;

            $total_profit += $profit;

            $cnt++;
        }



        $data .= '<tr>

                        <td></td>

                        <td></td>

                        <td></td>

                        <td></td>

                        <td></td>

                        <td class="total"><b>' . Yii::app()->numberFormatter->formatCurrency($total_net_sale, "") . '</b></td>

                        <td class="total"><b>' . Yii::app()->numberFormatter->formatCurrency($total_net_cost_rate, "") . '</b></td>

                        <td class="total"><b>' . Yii::app()->numberFormatter->formatCurrency($total_profit, "") . '</b></td>

                        <td></td>

                    </tr>';



        $data .= '      </tbody>

                    </table>

                </body>

            </html>';

        header("Content-type: application/vnd.ms-excel");

        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");

        echo $data;

        Yii::app()->end();

        return;
    }

    public function actionPrintServiceInventory() {

        $warehouse = Yii::app()->request->getParam('warehouse');

        $reference = Yii::app()->request->getParam('reference');

        $from_date = Yii::app()->request->getParam('from_date');

        $to_date = Yii::app()->request->getParam('to_date');

        $param = array(
            'warehouse' => $warehouse,
            'reference' => $reference,
            'from_date' => $from_date,
            'to_date' => $to_date,
        );

        $this->render('//reports/print_service_store', $param
                , false, true);
    }

    public function actionPrintservicestorePDF() {

        $warehouse = Yii::app()->request->getParam('warehouse');

        $reference = Yii::app()->request->getParam('reference');

        $from_date = Yii::app()->request->getParam('from_date');

        $to_date = Yii::app()->request->getParam('to_date');

        $param = array(
            'warehouse' => $warehouse,
            'reference' => $reference,
            'from_date' => $from_date,
            'to_date' => $to_date,
        );

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.service_store', $param, true));



        $mpdf->Output("Materialtomaterial", 'I');
    }

    public function actionPrintStokTrackingExcel() {

        $stock_tracking = Yii::app()->request->getParam('stock_tracking');

        $bill_entry = Yii::app()->request->getParam('bill_entry');

        $bill_exit = Yii::app()->request->getParam('bill_exit');



        if ($stock_tracking == '1') {

            $header = 'Item,Description,Receipt ID,Qty,Balance,Unit';
        } else {

            $header = 'Date,Product,Description,Qty,Unit';
        }

        $j = 0;

        $list[$j++] = $header;





//-------------------------------







        if ($stock_tracking == '1') {



            $condition = '1=1 AND t.received_quantity>0';



            if (!empty($bill_entry)) {

                $condition .= " AND (purchasingmatrialreceipt.tracking_no='" . $bill_entry . "' OR purchasingmatrialreceipt.id ='" . $bill_entry . "')";
            }



            $modelMaterialStockDetails = PurchasingMaterialreceiptItem::model()->with('purchasingmatrialreceipt')->findAll(array('condition' => $condition));

            if (!empty($modelMaterialStockDetails)) {

                foreach ($modelMaterialStockDetails as $i => $model) {



                    $mr_id = MaterialReceiptStockDetails::model()->find(array('condition' => 'material_receipt_id=' . $model->purchasing_materialreceipt_id . ' AND product_id=' . $model->product_id . ' AND transaction_type="Purchase Order"'));



                    $qty = 0;

                    if ($mr_id->id > 0) {

                        $qty = DeliveryMaterialDetails::model()->find(array('select' => '(SUM(t.received_qty)) AS received_qty', 'condition' => 'material_receipt_id=' . $mr_id->id))->received_qty;
                    }



                    $total_received = $model->received_quantity;

                    $balance_qty = $total_received - $qty;







                    $list[$j++] = $model->product_name . ',' . $model->description . ',' . $model->purchasingmatrialreceipt->id . ',' . $model->received_quantity . ',' . $balance_qty . ',' . $model->unit;
                }
            }
        } else {







            $condition = 'picked_qty > 0';

            if (!empty($bill_exit)) {



                $condition .= " AND ( tracking_no LIKE '" . $bill_exit . "')";
            }

            $modelDeliveryMaterialDetails = DeliveryNoteItem::model()->with('deliveryNote')->findall(array('condition' => $condition));



            foreach ($modelDeliveryMaterialDetails as $i => $model) {





                $list[$j++] = date('d/m/Y', strtotime($model->deliveryNote->delivery_date)) . ',' . $model->product->part_number . ',' . $model->product->description . ',' . $model->picked_qty . ',' . $model->unitdetails->name;
            }
        }







//------------------------



        $file = fopen("uploads/csvs/test.csv", "w");

        foreach ($list as $line) {

            fputcsv($file, explode(',', $line));
        }



        fclose($file);



//$filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $filename = 'uploads/csvs/test.csv';



        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';



        header('Content-Type: application/csv;');



        header("Content-disposition: attachment; filename=\"Stocktracking.csv\"");



        readfile($filename);



        Yii::app()->end();



        return;
    }

    public function actionPrintMOQReport() {

        $model = new Inventory();

        $brand_id = $_POST['brand_id'];

        $part_no = $_POST['part_no'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_moq_report', array('model' => $model, 'brand_id' => $brand_id, 'part_no' => $part_no), false, true);
    }

    public function actionPrintMOQReportPdf() {

        $brand_id = Yii::app()->request->getParam('brand_id');

        $part_no = Yii::app()->request->getParam('part_no');

        $param = array(
            'brand_id' => $brand_id,
            'part_no' => $part_no
        );



        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.printMOQReport', $param, true));



        $mpdf->Output("Materialtomaterial", 'I');
    }

    public function actionPrintMOQReportExcel() {



        $part_no = Yii::app()->request->getParam('part_no');

        $brand_id = Yii::app()->request->getParam('brand_id');



        $header = 'No!Part Number!Description!Brand!Reorder Level!Reorder Lot!Total Qty!Alloc.Qty!Free Qty!Total PO. Qty!PO. Qty!MR. Qty!QC. Qty!MOQ. Qty';



        //$header = 'No,Part Number!Description!Brand!Reorder Level!Reorder Lot!Total Qty!Alloc.Qty!Free Qty!Total PO. Qty!PO. Qty!MR. Qty!QC. Qty!MOQ. Qty';

        $j = 0;

        $list[$j++] = $header;





//-------------------------------





        $toalval = 0;

        $type_id = "";

        $sl = 0;

        $condition = 're_order_level > 0 AND inventory_item_type=1 AND isActive="Y"';

        if ($part_no != '') {

            $condition .= ' AND t.part_number LIKE "%' . $part_no . '%"';
        }

        if ($brand_id != '') {

            $condition .= ' AND t.brand_class_id=' . $brand_id;
        }

        $model_inventory = Store::model()->findAll(array('condition' => $condition, 'order' => 'part_number,description asc'));





        foreach ($model_inventory as $i => $model) {



            $model_temp = ProductLocation::model()->find(array(
                'select' => 'SUM(quantity) AS quantity', 'condition' => 'product_id = ' . $model->id
            ));

            $indirect_model = new InventoryIndirectTransferItem();

            $available_qty = $indirect_model->with('parent', 'unitdetails')->find(array('select' => '(SUM(transfer_qty-damaged_qty-transferred_qty)) * unitdetails.factor AS available_qty', 'condition' => 'parent.is_complete!="Y" AND t.item_id="' . $model->id . '"', 'group' => 't.item_id'))->available_qty;

            $damaged_qty1 = $indirect_model->with('parent', 'unitdetails')->find(array('select' => '(SUM(t.damaged_qty)) * unitdetails.factor AS damaged_qty', 'condition' => 't.item_id="' . $model->id . '" AND t.damaged_qty !="0"', 'group' => 't.item_id'))->damaged_qty;

            $creditnote_model = new CreditnoteItem();

            $damaged_qty2 = $creditnote_model->with('parent', 'orderunit')->find(array('select' => '(SUM(t.returned_quantity)) * orderunit.factor AS returned_quantity', 'condition' => 'parent.sales_return="DA" AND t.product_id="' . $model->id . '" AND t.returned_quantity !="0"', 'group' => 't.product_id'))->returned_quantity;

            $damaged_qty = $damaged_qty1 + $damaged_qty2;



            $quantity = $model_temp->quantity + $damaged_qty + $available_qty;





            $total_allocated_quantity = $model->total_allocated_quantity;



            $total_free_quantity = $quantity - $total_allocated_quantity;







            $purchaseOrder = PurchasingOrderStockItem::model()->findAll(array('condition' => 'stock_item_id = ' . $model->id));

            $total_po_qty = $total_mr_qty = $total_qc_qty = 0;

            if (!empty($purchaseOrder)) {

                foreach ($purchaseOrder as $i => $each) {

                    $state = $each->purchaseorder->file->current_process_status;

                    if ($each->purchaseorder->file->is_approved == "Y" && ( $state == 'P_O' || $state == 'M_R' || $state == 'Q_C' || ( $state == 'P_I' && $each->purchaseorder->convert_status == "Y" ) )) {

                        $total_mr_qty += ( $state == 'M_R' ) ? Yii::app()->db->createCommand('SELECT SUM(received_quantity) FROM  erp_purchasing_material_receipt_item WHERE order_item_id=' . $each->id)->queryScalar() : 0;

                        $total_qc_qty += ( $state == 'Q_C' ) ? Yii::app()->db->createCommand('SELECT SUM(qcchecked_quantity) FROM  erp_purchasing_material_receipt_item WHERE order_item_id=' . $each->id)->queryScalar() : 0;

                        $total_po_qty += ( $state == 'P_O') ? $each->stock_item_quantity : 0;

                        $total_po_qty += ( $state == 'P_I' && $each->purchaseorder->convert_status == "Y" ) ? $each->stock_item_quantity - Yii::app()->db->createCommand('SELECT SUM(II.quantity) FROM  erp_purchasinginvoice_item II LEFT JOIN erp_purchasinginvoice I ON I.id = II.purchasing_invoice_id WHERE II.product_id=' . $each->stock_item_id . ' AND I.po_id =' . $each->purchasing_order_id)->queryScalar() : 0;
                    }
                }
            }







            $grand_total_po_qty = $total_po_qty + $total_mr_qty + $total_qc_qty;

            $reorder_checking_qty = $total_free_quantity + $grand_total_po_qty;



            if ($reorder_checking_qty < $model->re_order_level) {

                $sl++;

                $moq_qty = $model->re_order_level - $total_free_quantity - $grand_total_po_qty;





                $list[$j++] = $sl . '!' . $model->part_number . '!' . $model->description . '!' . $model->brand_detail->product_class . '!' . $model->re_order_level . '!' . $model->re_order_lot
                        . '!' . $quantity . '!' . $total_allocated_quantity . '!' . $total_free_quantity . '!' . $grand_total_po_qty . '!'
                        . $total_po_qty . '!' . $total_mr_qty . '!' . $total_qc_qty . '!' . $moq_qty;



                $sl++;
            }
        }



//------------------------



        $file = fopen("uploads/csvs/test.csv", "w");

        foreach ($list as $line) {

            fputcsv($file, explode('!', $line));
        }



        fclose($file);



//$filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $filename = 'uploads/csvs/test.csv';



        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';



        header('Content-Type: application/csv;');



        header("Content-disposition: attachment; filename=\"MOQExcel.csv\"");



        readfile($filename);



        Yii::app()->end();



        return;
    }

    public function actionPrintMOQReportAll() {

        $model = new Inventory();

        $brand_id = $_POST['brand_id'];

        $part_no = $_POST['part_no'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_all_moq_report', array('model' => $model, 'brand_id' => $brand_id, 'part_no' => $part_no), false, true);
    }

    public function actionPrintMOQReportAllPdf() {

        $brand_id = Yii::app()->request->getParam('brand_id');

        $part_no = Yii::app()->request->getParam('part_no');

        $param = array(
            'brand_id' => $brand_id,
            'part_no' => $part_no
        );



        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.print_pdf_MOQ_report_all', $param, true));



        $mpdf->Output("Materialtomaterial", 'I');
    }

    public function actionPrintMOQReportAllExcel() {



        $part_no = Yii::app()->request->getParam('part_no');

        $brand_id = Yii::app()->request->getParam('brand_id');



        $header = 'No!Part Number!Description!Brand!Reorder Level!Reorder Lot!Total Qty!Alloc.Qty!Free Qty!Total PO. Qty!PO. Qty!MR. Qty!QC. Qty!MOQ. Qty';



        //$header = 'No,Part Number!Description!Brand!Reorder Level!Reorder Lot!Total Qty!Alloc.Qty!Free Qty!Total PO. Qty!PO. Qty!MR. Qty!QC. Qty!MOQ. Qty';

        $j = 0;

        $list[$j++] = $header;





//-------------------------------





        $toalval = 0;

        $type_id = "";

        $sl = 1;

        $condition = 'inventory_item_type=1 AND isActive="Y"';

        if ($part_no != '') {

            $condition .= ' AND t.part_number LIKE "%' . $part_no . '%"';
        }

        if ($brand_id != '') {

            $condition .= ' AND t.brand_class_id=' . $brand_id;
        }



        $model_inventory = Store::model()->findAll(array('condition' => $condition, 'order' => 'part_number,description asc'));



        foreach ($model_inventory as $i => $model) {



            $model_temp = ProductLocation::model()->find(array(
                'select' => 'SUM(quantity) AS quantity', 'condition' => 'product_id = ' . $model->id
            ));

            $indirect_model = new InventoryIndirectTransferItem();

            $available_qty = $indirect_model->with('parent', 'unitdetails')->find(array('select' => '(SUM(transfer_qty-damaged_qty-transferred_qty)) * unitdetails.factor AS available_qty', 'condition' => 'parent.is_complete!="Y" AND t.item_id="' . $model->id . '"', 'group' => 't.item_id'))->available_qty;

            $damaged_qty1 = $indirect_model->with('parent', 'unitdetails')->find(array('select' => '(SUM(t.damaged_qty)) * unitdetails.factor AS damaged_qty', 'condition' => 't.item_id="' . $model->id . '" AND t.damaged_qty !="0"', 'group' => 't.item_id'))->damaged_qty;

            $creditnote_model = new CreditnoteItem();

            $damaged_qty2 = $creditnote_model->with('parent', 'orderunit')->find(array('select' => '(SUM(t.returned_quantity)) * orderunit.factor AS returned_quantity', 'condition' => 'parent.sales_return="DA" AND t.product_id="' . $model->id . '" AND t.returned_quantity !="0"', 'group' => 't.product_id'))->returned_quantity;

            $damaged_qty = $damaged_qty1 + $damaged_qty2;



            $quantity = $model_temp->quantity + $damaged_qty + $available_qty;





            $total_allocated_quantity = $model->total_allocated_quantity;



            $total_free_quantity = $quantity - $total_allocated_quantity;







            $purchaseOrder = PurchasingOrderStockItem::model()->findAll(array('condition' => 'stock_item_id = ' . $model->id));

            $total_po_qty = $total_mr_qty = $total_qc_qty = 0;

            if (!empty($purchaseOrder)) {

                foreach ($purchaseOrder as $i => $each) {

                    $state = $each->purchaseorder->file->current_process_status;

                    if ($each->purchaseorder->file->is_approved == "Y" && ( $state == 'P_O' || $state == 'M_R' || $state == 'Q_C' || ( $state == 'P_I' && $each->purchaseorder->convert_status == "Y" ) )) {

                        $total_mr_qty += ( $state == 'M_R' ) ? Yii::app()->db->createCommand('SELECT SUM(received_quantity) FROM  erp_purchasing_material_receipt_item WHERE order_item_id=' . $each->id)->queryScalar() : 0;

                        $total_qc_qty += ( $state == 'Q_C' ) ? Yii::app()->db->createCommand('SELECT SUM(qcchecked_quantity) FROM  erp_purchasing_material_receipt_item WHERE order_item_id=' . $each->id)->queryScalar() : 0;

                        $total_po_qty += ( $state == 'P_O') ? $each->stock_item_quantity : 0;

                        $total_po_qty += ( $state == 'P_I' && $each->purchaseorder->convert_status == "Y" ) ? $each->stock_item_quantity - Yii::app()->db->createCommand('SELECT SUM(II.quantity) FROM  erp_purchasinginvoice_item II LEFT JOIN erp_purchasinginvoice I ON I.id = II.purchasing_invoice_id WHERE II.product_id=' . $each->stock_item_id . ' AND I.po_id =' . $each->purchasing_order_id)->queryScalar() : 0;
                    }
                }
            }







            $grand_total_po_qty = $total_po_qty + $total_mr_qty + $total_qc_qty;

            $reorder_checking_qty = $total_free_quantity + $grand_total_po_qty;



            //if($reorder_checking_qty < $model->re_order_level){

            $moq_qty = $model->re_order_level - $total_free_quantity - $grand_total_po_qty;





            $list[$j++] = $sl . '!' . $model->part_number . '!' . $model->description . '!' . $model->brand_detail->product_class . '!' . $model->re_order_level . '!' . $model->re_order_lot
                    . '!' . $quantity . '!' . $total_allocated_quantity . '!' . $total_free_quantity . '!' . $grand_total_po_qty . '!'
                    . $total_po_qty . '!' . $total_mr_qty . '!' . $total_qc_qty . '!' . $moq_qty;



            $sl++;









            //}
        }



//------------------------



        $file = fopen("uploads/csvs/test.csv", "w");

        foreach ($list as $line) {

            fputcsv($file, explode('!', $line));
        }



        fclose($file);



//$filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $filename = 'uploads/csvs/test.csv';



        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';



        header('Content-Type: application/csv;');



        header("Content-disposition: attachment; filename=\"MOQExcelAll.csv\"");



        readfile($filename);



        Yii::app()->end();



        return;
    }

    public function actionGetinventorylist() {



        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $searchString = trim($_POST['search']['value']);



        $condition = '1=1';
        if ($_POST['active'] != "") {
            $condition .= " AND isActive ='{$_POST['active']}' ";
        }
        if ($_POST['type'] > 0) {
            $condition .= ' AND type =' . $_POST['type'];
        }

        if ($_POST['generic_id'] > 0) {
            $condition .= ' AND generic_id=' . $_POST['generic_id'];
        }
        if ($_POST['tax_code'] != '') {
            $condition .= ' AND tax_code=' . $_POST['tax_code'];
        }

        if ($_POST['brand_id'] > 0) {
            $condition .= ' AND brand=' . $_POST['brand_id'];
        }

        if ($searchString != '') {
            $condition .= ' AND (part_number LIKE "%' . $searchString . '%"    OR description LIKE "%' . $searchString . '%") ';
        }

        $stockFlag = ( $_POST['having_stock'] == 1 ) ? true : false;
        if ($stockFlag) {
            $condition .= ' AND quantity >0 ';
        }
        $count = Yii::app()->db->createCommand('SELECT COUNT(id) AS count FROM view_all_stock_items WHERE ' . $condition)->queryScalar();

        $model = Yii::app()->db->createCommand('SELECT * FROM view_all_stock_items WHERE ' . $condition . ' ORDER BY part_number LIMIT ' . $limit . ' OFFSET ' . $offset)->queryAll();

        /* if (!Yii::app()->user->hasState("total_value")) {

          $total = Yii::app()->db->createCommand('SELECT SUM(quantity*rate)  AS total FROM view_all_stock_items WHERE ' . $condition)->queryScalar();

          Yii::app()->user->setState("total_value", $total);

          } else {

          $total = Yii::app()->user->getState("total_value");

          } */

        $total = Yii::app()->db->createCommand('SELECT (SUM(in_qty)-SUM(out_qty))*rate AS total FROM view_all_stock_items WHERE ' . $condition)->queryScalar();

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $rowData = array();

        function getItemtype($type) {

            $arr_types = array('I' => 'Stock', 'S' => 'Service');

            return $arr_types[$type];
        }

        $rowData = array();

        foreach ($model as $i => $row) {

            $qty =$row['in_qty']-$row['out_qty'];
            $rowData[] = array($i + 1, $row['part_number'], $row['description'], $row['generic_name'], $row['brand'], getItemtype($row['type']), $row['tax_code'] . '%', $qty, $row['unit'], $row['rate'], number_format(round(($qty * $row['rate']), 4), 4, '.', ''));
        }



        $data['draw'] = $draw;

        $data['total'] = (float) $total;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $data['data'] = $rowData;

        echo json_encode($data);
    }

    public function actionGetJobOrderList() {
        $model = new JobOrder();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];




        //$condition= " job_order_status ! = 'CN' ";
        //$condition= " job_order_status IN('O','D','PD') ";
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];

        if ($_POST['order'][0]['column'] == 0) {
            $filterColumn = 'job_order_id';
            $filterOrder = 'DESC';
        }
        $orderBy = $filterColumn . " " . $filterOrder;

        //$condition="job_order_status!='CN'";
        $condition = "1=1";
        /* if(isset($_POST['filter_job_order_status']) && $_POST['filter_job_order_status']!="")
          {
          $condition =" job_order_status='".$_POST['filter_job_order_status']."'";
          } */
        $filter_start_date = $_POST['filter_start_date'];
        $filter_end_date = $_POST['filter_end_date'];
        if (!empty($filter_start_date)) {
            $filter_start_date = str_replace('/', '-', $filter_start_date);
            $filter_start_date = date('Y-m-d', strtotime($filter_start_date));
            $condition .= ' AND job_date >="' . $filter_start_date . '"';
        }
        if (!empty($filter_end_date)) {
            $filter_end_date = str_replace('/', '-', $filter_end_date);
            $filter_end_date = date('Y-m-d', strtotime($filter_end_date));
            $condition .= " AND job_date <= '" . $filter_end_date . "' ";
        }



        if ($_POST['filter_job_no'] != "") {
            $condition .= " AND job_order_id LIKE'%" . $_POST['filter_job_no'] . "%'";
        }
        if ($_POST['filter_customer'] != "") {
            $condition .= " AND customer_name LIKE'%" . $_POST['filter_customer'] . "%'";
        }

        if ($_POST['filter_agent'] != "") {
            $condition .= " AND agent LIKE'%" . $_POST['filter_agent'] . "%'";
        }


        if ($_POST['filter_job_order_priority'] != "") {
            $condition .= " AND job_priority='" . $_POST['filter_job_order_priority'] . "'";
        }
        
        if(isset($_POST['filter_job_order_status']) && $_POST['filter_job_order_status']!="")
        {
            $condition.=" AND job_order_status='".$_POST['filter_job_order_status']."'";
        }
         if(isset($_POST['filter_job_order_transport_type']) && $_POST['filter_job_order_transport_type']!="")
            {
            	$condition.=" AND transport_type='".$_POST['filter_job_order_transport_type']."'";
            }

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];
            $condition = " (job_order_id LIKE '%" . $searchString . "%' OR customer_name LIKE '%" . $searchString . "%' OR file_id LIKE '%" . $searchString . "%' OR origin LIKE '%" . $searchString . "%'  OR destination LIKE '%" . $searchString . "%' OR transport_type LIKE '%" . $searchString . "%')";

            if (((int) Yii::app()->user->havePermissionOn["job_order_view_all"]) == 0) {
                $condition .= ' AND lead_owner_id= "' . Yii::app()->user->id . '"';
            }
        }



        $SQL1 = "SELECT * FROM view_job_order_list WHERE $condition ORDER BY " . $orderBy . " LIMIT $offset,$limit";
        //echo $SQL1;
        $model = Yii::app()->db->createCommand($SQL1)->queryAll();

        //print_r($model);

        $SQL_CNT = "SELECT COUNT(*) as clients FROM view_job_order_list WHERE $condition";
        $count = Yii::app()->db->createCommand($SQL_CNT)->queryScalar();

        //$count = $model->with('file','leadowner','customer','transporttype')->count(array('condition'=>$condition));
        //$model = $model->with('file','leadowner','customer','transporttype')->findAll(array('condition'=>$condition,'order' => 't.id DESC','limit'=>$limit,'offset'=>$offset));

        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $j => $row) {

            $div = '';


            $destination = '';
            if ((int) $row['destination'] > 0) {
                $destination = MasCountry::model()->findByPk($row['destination'])->country_name;
            }
            $origin = '';
            if ((int) $row['origin'] > 0) {
                $origin = MasCountry::model()->findByPk($row['origin'])->country_name;
            }
            switch ($row['job_order_status']) {
                case 'PD':
                    $row_job_order_status = "Partially Delivered";
                    break;
                case 'D':
                    $row_job_order_status = "Delivered";
                    break;
                case 'C':
                    $row_job_order_status = "Completed";
                    break;
                case 'I':
                    $row_job_order_status = "Invoiced";
                    break;
                case 'CN':
                    $row_job_order_status = "Cancel";
                    break;
                default:
                    $row_job_order_status = "Open";
                    break;
            }
            $rowData[] = array($m, $row['job_order_id'], date("d/m/Y", strtotime($row['job_date'])), $row['customer_name'], $origin, $row['consignee_id'], $destination, $row['agent'],$row['transport_type_name'], $row['awb_no'],$row_job_order_status/* ,$row['transport_type_name'],$row_job_order_status,'<div title="'.$row['status_description'].'">'.$row['status_description'].'</div>',($row['status_last_updated_date']!="0000-00-00 00:00:00")?$row['status_last_updated_date']:"",$row['job_order_status'],$row['customer_id'],$row['file_id'],$row['job_priority'] */);
            $m++;
        }
        $data['data'] = $rowData;

        echo json_encode($data);
    }

    public function actionGetstockstateasof() {

        $model = new Inventory();



        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $searchString = trim($_POST['search']['value']);



        $to_date = ( count(explode('/', $_POST['to_date'])) == 3 ) ? date('Y-m-d', strtotime(str_replace('/', '-', $_POST['to_date']))) : date('Y-m-d');

        $generic_id = (int) $_POST['generic_id'];

        $brand_id = (int) $_POST['brand_id'];

        $warehouse = (int) $_POST['warehouse'];



        $condition = "1=1";
        if ($generic_id > 0)
            $condition .= ' AND generic_id=' . $generic_id;

        if ($brand_id > 0)
            $condition .= ' AND brand=' . $brand_id;

        if ($searchString != '')
            $condition .= ' AND part_number LIKE "%' . $searchString . '%"';


    $stock_state_as_of_query = "CREATE OR REPLACE VIEW view_stock_state_as_of AS 
                                SELECT
                                    customer_id,
                                    customer_name,
                                    S.id AS product_id,
                                    S.part_number AS part_number,
                                    S.description AS description,
                                    B.product_class AS brand,
                                    G.generic_name AS generic_name,
                                    (
                                        SELECT
                                            IFNULL(SUM(quantity),
                                            0)
                                        FROM
                                            ".MasCompany::subMainDB.".`erp_stock_ledger` `isl`
                                        WHERE
                                            isl.product_id = S.id AND isl.transaction_type = 'IN' AND isl.transaction_date <= '" . $to_date . "'
                                    ) AS in_qty,
                                    (
                                        SELECT
                                            IFNULL(SUM(quantity),
                                            0)
                                        FROM
                                            ".MasCompany::subMainDB.".`erp_stock_ledger` `osl`
                                        WHERE
                                            osl.product_id = S.id AND osl.transaction_type = 'OUT' AND osl.transaction_date <= '" . $to_date . "'
                                    ) AS out_qty,
                                    S.brand AS brand_id,
                                    S.generic_id AS generic_id,
                                    S.rate
                                FROM
                                    erp_inventory S
                                LEFT JOIN erp_product_class B ON
                                    S.brand = B.id
                                LEFT JOIN erp_inventory_generic_name G ON
                                    S.generic_id = G.id
                                LEFT JOIN erp_customer AS customer
                                ON
                                    customer.id = customer_id
                                WHERE
                                    S.type IN('I')
                                GROUP BY
                                    S.id
                                ORDER BY
                                    S.part_number";

        Yii::app()->db->createCommand($stock_state_as_of_query)->execute();



        $count = Yii::app()->db->createCommand('SELECT COUNT(product_id) AS count FROM view_stock_state_as_of WHERE ' . $condition)->queryScalar();

        $model = Yii::app()->db->createCommand('SELECT * FROM view_stock_state_as_of WHERE ' . $condition . ' ORDER BY part_number LIMIT ' . $limit . ' OFFSET ' . $offset)->queryAll();

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $rowData = array();


        $totalValue = 0;
        foreach ($model as $i => $row) {

            //$out_quantity = Yii::app()->db->createCommand('SELECT SUM(quantity) FROM erp_stock_ledger WHERE transaction_type="OUT" AND in_stockledger_id=' . $row['stock_ledger_id'])->queryScalar();
            $total_qty = $row['in_qty'] -$row['out_qty'];
            $total = number_format(round(($total_qty * $row['rate']), 4), 2, '.', '');
            $totalValue += ($total_qty * $row['rate']);
            $rowData[] = array($i + 1, $row['customer_name'], $row['part_number'], $row['description'], $row['generic_name'], $row['brand'], $total_qty, $row['rate'], $total);
        }

        $totalValue = number_format(round(($totalValue), 4), 2, '.', '');

        $data['draw'] = $draw;

        $data['total'] = $totalValue;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $data['data'] = $rowData;

        echo json_encode($data);
    }

    public function actionPrintstockstate() {



        $to_date = ( count(explode('/', $_GET['to_date'])) == 3 ) ? date('Y-m-d', strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-d');

        $generic_id = (int) $_GET['generic_id'];

        $brand_id = (int) $_GET['brand_id'];

        $searchString = $_GET['part_no'];

        $type = $_GET['type'];



        $condition = '1=1';

        if ($generic_id > 0)
            $condition .= ' AND generic_id=' . $generic_id;

        if ($brand_id > 0)
            $condition .= ' AND brand_id=' . $brand_id;

        if ($searchString != '')
            $condition .= ' AND part_number LIKE "%' . $searchString . '%"';



            $stock_state_as_of_query = "CREATE OR REPLACE VIEW view_stock_state_as_of AS 
            SELECT
                customer_id,
                customer_name,
                S.id AS product_id,
                S.part_number AS part_number,
                S.description AS description,
                B.product_class AS brand,
                G.generic_name AS generic_name,
                (
                    SELECT
                        IFNULL(SUM(quantity),
                        0)
                    FROM
                        ".MasCompany::subMainDB.".`erp_stock_ledger` `isl`
                    WHERE
                        isl.product_id = S.id AND isl.transaction_type = 'IN' AND isl.transaction_date <= '" . $to_date . "'
                ) AS in_qty,
                (
                    SELECT
                        IFNULL(SUM(quantity),
                        0)
                    FROM
                        ".MasCompany::subMainDB.".`erp_stock_ledger` `osl`
                    WHERE
                        osl.product_id = S.id AND osl.transaction_type = 'OUT' AND osl.transaction_date <= '" . $to_date . "'
                ) AS out_qty,
                S.brand AS brand_id,
                S.generic_id AS generic_id,
                S.rate
            FROM
                erp_inventory S
            LEFT JOIN erp_product_class B ON
                S.brand = B.id
            LEFT JOIN erp_inventory_generic_name G ON
                S.generic_id = G.id
            LEFT JOIN erp_customer AS customer
            ON
                customer.id = customer_id
            WHERE
                S.type IN('I')
            GROUP BY
                S.id
            ORDER BY
                S.part_number";

        Yii::app()->db->createCommand($stock_state_as_of_query)->execute();



        $model = Yii::app()->db->createCommand('SELECT * FROM view_stock_state_as_of WHERE ' . $condition . ' ORDER BY part_number')->queryAll();

        if ($type == 'excel') {

            $filename = 'stockstate_as_of_' . date('dmYhis') . '.xls';

            $data = '<html>

                        <head>

                            <style>

                                table{

                                    width:100%;

                                }

                                .head{

                                    background-color : yellow;

                                    font-weight: bold;

                                    font-size: 14px;

                                }

                                .total{

                                    text-align: right;

                                    font-weight: bold;

                                    font-size: 14px;

                                }

                            </style>

                        </head>

                        <body>

                            <table border=1>

                                <thead>

                                    <th>No</th>
                                    <th> customer</th>
                                    <th>Part Number</th>

                                    <th>Description</th>

                                    <th>Generic</th>

                                    <th>Brand /Class</th>

                                    <th>Quantity</th>

                                    <th>Rate</th>

                                    <th>Value</th>

                                </thead>

                                <tbody>';



            foreach ($model as $i => $row) {

                $total_qty = $row['in_qty'] -$row['out_qty'];
            $total = number_format(round(($total_qty * $row['rate']), 4), 2, '.', '');
            $totalValue += ($total_qty * $row['rate']);

                $data .= '<tr>

                                                    <td>' . ($i + 1) . '</td>
                                                        
                                                     <td>' . $row['customer_name'] . '</td>

                                                    <td>' . $row['part_number'] . '</td>

                                                    <td>' . $row['description'] . '</td>

                                                    <td>' . $row['generic_name'] . '</td>

                                                    <td>' . $row['brand'] . '</td>

                                                    <td>' . $total_qty . '</td>

                                                    <td>' . $row['rate'] . '</td>

                                                    <td>' . $total . '</td>

                                                </tr>';
            }



            $data .= '</tbody>

                        </table>

                    </body>

                </html>';



            header("Content-type: application/vnd.ms-excel");

            header("Content-Disposition: attachment; filename=\"" . $filename . "\"");

            echo $data;

            Yii::app()->end();

            return;
        } else {

            $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

            $mpdf->WriteHTML($stylesheet, 1);

            $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.inv_stockstateasof', array('to_date' => $to_date, 'model' => $model, 'generic_id' => $generic_id, 'brand_id' => $brand_id), true));

            $mpdf->Output("stock_state_as_of_" . date('dmYhis') . ".pdf", 'I');
        }
    }

    // start hrreports

    public function actionPrintAttendanceList() {

        $from_date = $_POST['from_date'];

        $to_date = $_POST['to_date'];

        $attend_emp_sponsor = $_POST['branch_id'];

        $emp_id = trim($_POST['employee_id']);

        $status = $_POST['status'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->renderPartial('//reports/print_employee_attendance_list', array('model' => $model, 'from_date' => $from_date, 'to_date' => $to_date, 'attend_code' => $attend_code, 'month_id' => $month_id, 'emp_id' => $emp_id, 'attend_emp_sponsor' => $attend_emp_sponsor, 'title' => $title), false, true);
    }

    public function actionPrintMonthlyAttendanceReport() {



        $attend_emp_sponsor = $_POST['branch_id'];

        $month = $_POST['month'];



        $year = $_POST['year'];





        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->renderPartial('//reports/print_employee_monthly_attendance_list', array('model' => $model, 'year' => $year, 'month' => $month, 'attend_emp_sponsor' => $attend_emp_sponsor, 'title' => $title), false, true);
    }

    public function actionPrintEmployeeLeaveHistory() {

        $employee_id = $_POST['employee_id'];

        $leave_type = $_POST['leave_id'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->renderPartial('//reports/print_employee_leave_history', array('model' => $model, 'employee_id' => $employee_id, 'employee_code' => $employee_code, 'leave_type' => $leave_type), false, true);
    }

    public function actionPrintAttendanceYearlyLeaveList() {

        //$model = new Employeeleave();

        $branch_id = $_POST['branch_id'];

        $employee_id = $_POST['employee_id'];

        $leave_type = $_POST['leave_id'];

        $year = $_POST['year'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->renderPartial('//reports/print_leave_yearly_report', array('model' => $model, 'branch_id' => $branch_id, 'employee_id' => $employee_id, 'leave_type' => $leave_type, 'year' => $year), false, true);
    }

    public function actionPrintBranchReport() {

        $branchname = $_POST['branchname'];

        $location = $_POST['location'];

        $currency = $_POST['currency'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->renderPartial('//reports/print_branch_report', array('branchname' => $branchname, 'location' => $location, 'currency' => $currency), false, true);
    }

    public function actionPrintinoutDocumentReport() {



        $employee_id = $_POST['employee_id'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->renderPartial('//reports/print_inout_document', array('employee_id' => $employee_id), false, true);
    }

    public function actionPrintEosReport() {

        $branch_id = $_POST['branch_id'];

        $employee_id = $_POST['employee_id'];

        $department_name = $_POST['department_name'];

        $designation_name = $_POST['designation_name'];

        $from_date = $_POST['from_date'];

        $to_date = $_POST['to_date'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->renderPartial('//hrreports/Print_eos_report', array('branch_id' => $branch_id, 'employee_id' => $employee_id, 'department_name' => $department_name, 'designation_name' => $designation_name, 'from_date' => $from_date, 'to_date' => $to_date), false, true);
    }

    public function actionPrintleavehistorylist() {

        $leave_id = $_POST['leave_id'];

        $employee_id = $_POST['employee_id'];

        $from_date = $_POST['from_date'];

        $to_date = $_POST['to_date'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->renderPartial('//hrreports/print_leavehistorylist', array('leave_id' => $leave_id, 'employee_id' => $employee_id, 'from_date' => $from_date, 'to_date' => $to_date), false, true);
    }

    public function actionPrintAttendanceOverTimeList() {

        $overtime_from_date = $_POST['from_date'];

        $overtime_to_date = $_POST['to_date'];

        $overtime_emp_sponsor = $_POST['branch_id'];

        $emp_id = $_POST['employee_id'];

        $overtime_type = $_POST['status'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->renderPartial('//hrreports/print_employee_overtime_list', array('model' => $model, 'emp_id' => $emp_id, 'overtime_from_date' => $overtime_from_date, 'overtime_to_date' => $overtime_to_date, 'overtime_emp_sponsor' => $overtime_emp_sponsor, 'overtime_type' => $overtime_type, 'title' => $title), false, true);
    }

    public function actionPrintEOSPDF() {

        $id = Yii::app()->request->getParam('emp_id');

        $eos_id = Yii::app()->request->getparam("eos_id");

        $date_leave = Yii::app()->request->getParam('date_leave');

        $leaving_date = str_replace('/', '-', $date_leave);

        $leaving_date = date("Y-m-d", strtotime($leaving_date));

        $modelemployee = Employee::model()->findbyPK($id);

        $branch_or_sponsor_id = $modelemployee->branch_or_sponsor_id;

        $model_eos = EmployeeEOS::model()->findByPk($eos_id);

        $model_eos_details = EmployeeEOSDetails::model()->findAll(array('condition' => 'eos_id="' . $eos_id . '"'));

        $eos_clearance = HrEmployeeEosClearanceDetails::model()->findAll(array('condition' => 'eos_id="' . $eos_id . '"'));

        $date1 = new DateTime($modelemployee->date_join);

        $date2 = new DateTime($leaving_date);

        $dd = date_diff($date1, $date2);

        $service_period = "$dd->y Yrs $dd->m Month $dd->d Day";

        $join_date = $modelemployee->date_join;

        $d1 = strtotime($join_date);

        $d2 = strtotime($leaving_date);

        $datediff = $d2 - $d1;

        $service_days = $datediff / (60 * 60 * 24);

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $mPDF1->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);

        $mPDF1->showWatermarkImage = true;

        $mPDF1->watermarkImageAlpha = 0.09;

        //$stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_list.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial("application.views.front.pdf.Eos_details", array('service_days' => $service_days, 'model_eos' => $model_eos, 'service_period' => $service_period, 'model_eos_details' => $model_eos_details, 'model_eos' => $model_eos, 'modelemployee' => $modelemployee, 'branch_or_sponsor_id' => $branch_or_sponsor_id, 'emp_id' => $id, 'date_leave' => $date_leave, 'title' => $title, 'eos_clearance' => $eos_clearance), true));

        $mPDF1->Output('EOS.pdf', 'I');
    }

    public function actionPrintEmployeeLeaveListReport() {

        $branch_id = $_POST['branch_id'];

        $employee_id = $_POST['employee_id'];

        $leave_name = $_POST['leave_name'];

        $from_date = $_POST['from_date'];

        $to_date = $_POST['to_date'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->renderPartial('//hrreports/Print_employee_leavelist_report', array('branch_id' => $branch_id, 'employee_id' => $employee_id, 'leave_name' => $leave_name, 'from_date' => $from_date, 'to_date' => $to_date), false, true);
    }

    public function actionPrintsalarybefore() {

        $branch = $_POST['branch'];

        $month = $_POST['month'];

        $year = $_POST['year'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->renderPartial('//hrreports/Print_salary_before', array('branch' => $branch, 'month' => $month, 'year' => $year), false, true);
    }

    public function actionPrintsalaryslip() {

        $branch = $_POST['branch'];

        $month = $_POST['month'];

        $year = $_POST['year'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->renderPartial('//hrreports/Print_salary_slip', array('branch' => $branch, 'month' => $month, 'year' => $year), false, true);
    }

    public function actionPrintsalaryincrement() {

        $branch = $_POST['branch'];

        $employee_id = $_POST['employee_id'];

        $salary_type = $_POST['salary_type'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->renderPartial('//hrreports/Print_salary_increment', array('branch' => $branch, 'employee_id' => $employee_id, 'salary_type' => $salary_type), false, true);
    }

    public function actionPrintEmployeeAttendancePDF() {



        $model = new Employee();



        $from_date = Yii::app()->request->getParam('from_date');

        $to_date = Yii::app()->request->getParam('to_date');

        $emp_id = Yii::app()->request->getParam('emp_id');

        $attend_emp_sponsor = Yii::app()->request->getParam('attend_emp_sponsor');









        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.employee_attendence_list', array('model' => $model, 'from_date' => $from_date, 'to_date' => $to_date, 'emp_id' => $emp_id, 'attend_emp_sponsor' => $attend_emp_sponsor, 'title' => $title), true));



        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintMonthlyAttendanceReportPDF() {



        $model = new Employee();



        $branch_id = Yii::app()->request->getParam('branch_id');

        $month = Yii::app()->request->getParam('month');

        $year = Yii::app()->request->getParam('year');



        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.employee_monthlyattendence_list', array('model' => $model, 'branch_id' => $branch_id, 'month' => $month, 'emp_id' => $emp_id, 'year' => $year, 'title' => $title), true));



        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintEmployeeworkingHoursPDF() {



        $model = new EmployeeAttendance();



        $branch_id = Yii::app()->request->getParam('branch_id');

        $month = Yii::app()->request->getParam('month');

        $year = Yii::app()->request->getParam('year');

        $employee_id = Yii::app()->request->getParam('employee_id');

        $working_report_type = Yii::app()->request->getParam('working_report_type');



        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.employee_workhours_daily_list', array('model' => $model, 'branch_id' => $branch_id, 'month' => $month, 'emp_id' => $emp_id, 'year' => $year, 'employee_id' => $employee_id, 'working_report_type' => $working_report_type, 'title' => $title), true));



        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintEmpWeeklyWorkinhHoursPDF() {



        $model = new EmployeeAttendance();



        $branch_id = Yii::app()->request->getParam('branch_id');

        $month = Yii::app()->request->getParam('month');

        $year = Yii::app()->request->getParam('year');

        $employee_id = Yii::app()->request->getParam('employee_id');

        $working_report_type = Yii::app()->request->getParam('working_report_type');



        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.employee_workhours_weekly_list', array('model' => $model, 'branch_id' => $branch_id, 'month' => $month, 'emp_id' => $emp_id, 'year' => $year, 'employee_id' => $employee_id, 'working_report_type' => $working_report_type, 'title' => $title), true));



        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintEmpMonthlyWorkingHoursPDF() {



        $model = new EmployeeAttendance();



        $branch_id = Yii::app()->request->getParam('branch_id');

        $month = Yii::app()->request->getParam('month');

        $year = Yii::app()->request->getParam('year');

        $employee_id = Yii::app()->request->getParam('employee_id');

        $working_report_type = Yii::app()->request->getParam('working_report_type');



        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.employee_workhours_monthly_list', array('model' => $model, 'branch_id' => $branch_id, 'month' => $month, 'emp_id' => $emp_id, 'year' => $year, 'employee_id' => $employee_id, 'working_report_type' => $working_report_type, 'title' => $title), true));



        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintLeaveHistoryReportPDF() {



        $model = new EmployeeLeaveDetail();



        $leave_id = Yii::app()->request->getParam('leave_id');

        $employee_id = Yii::app()->request->getParam('employee_id');

        $from_date = Yii::app()->request->getParam('from_date');

        $to_date = Yii::app()->request->getParam('to_date');





        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.employee_leave_historypdf', array('model' => $model, 'leave_id' => $leave_id, 'employee_id' => $employee_id, 'from_date' => $from_date, 'to_date' => $to_date, 'working_report_type' => $working_report_type, 'title' => $title), true));



        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintEmployeeListReportPDF() {

        $model = new Employee();

        $Branch = Yii::app()->request->getParam('Branch');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $department_id = Yii::app()->request->getParam('department_id');
        $designation_id = Yii::app()->request->getParam('designation_id');
        $reportmanager_id = Yii::app()->request->getParam('reportmanager_id');
        $status = Yii::app()->request->getParam('status');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.employee_list_pdf', array('model' => $model, 'Branch' => $Branch, 'employee_id' => $employee_id, 'department_id' => $department_id, 'designation_id' => $designation_id, 'reportmanager_id' => $reportmanager_id, 'status' => $status), true));

        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintEmployeeBlockListReportPDF() {



        $model = new Employee();



        $Branch = Yii::app()->request->getParam('Branch');

        $employee_name = Yii::app()->request->getParam('employee_name');





        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.employee_blocklist_pdf', array('model' => $model, 'Branch' => $Branch, 'employee_name' => $employee_name, 'title' => $title), true));



        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintSalaryBeforeReportPDF() {



        $model = new SalarySlip();



        $branch = Yii::app()->request->getParam('branch');

        $month = Yii::app()->request->getParam('month');

        $year = Yii::app()->request->getParam('year');







        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.salarybefore_locked_pdf', array('model' => $model, 'branch' => $branch, 'month' => $month, 'year' => $year, 'title' => $title), true));



        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintEmployeeDesignationListReportPDF() {

        $model = new Employee();

        $Branch = Yii::app()->request->getParam('Branch');
        $employee_name = Yii::app()->request->getParam('employee_name');
        $designation_name = Yii::app()->request->getParam('designation_name');
        $report_id = Yii::app()->request->getParam('report_id');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.employee_designationlist_pdf', array('model' => $model, 'Branch' => $Branch, 'employee_name' => $employee_name, 'designation_name' => $designation_name, 'report_id' => $report_id, 'title' => $title), true));

        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintEmployeeLeavelistReportPDF() {

        $model = new EmployeeLeaveDetail();

        $branch_id = Yii::app()->request->getParam('branch_id');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $department_name = Yii::app()->request->getParam('department_name');
        $designation_name = Yii::app()->request->getParam('designation_name');
        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $leave_name = Yii::app()->request->getParam('leave_name');


        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.employee_leavelist_pdf', array('model' => $model, 'branch_id' => $branch_id, 'employee_id' => $employee_id, 'department_name' => $department_name, 'designation_name' => $designation_name, 'from_date' => $from_date, 'to_date' => $to_date, 'title' => $title, 'leave_name' => $leave_name), true));

        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintEmployeeDepartmentListReportPDF() {

        $model = new Employee();

        $Branch = Yii::app()->request->getParam('Branch');
        $employee_name = Yii::app()->request->getParam('employee_name');
        $department_name = Yii::app()->request->getParam('department_name');
        $reportman_id = Yii::app()->request->getParam('reportman_id');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.employee_departmentlist_pdf', array('model' => $model, 'Branch' => $Branch, 'employee_name' => $employee_name, 'department_name' => $department_name, 'reportman_id' => $reportman_id, 'title' => $title), true));

        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintEmployeeAssetReportPDF() {
        $branch_id = Yii::app()->request->getParam('branch_id');
        $employee_id = Yii::app()->request->getParam('employee_name');
        $asset_status = Yii::app()->request->getParam('asset_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.employee_assetlist_pdf', array('branch_id' => $branch_id, 'employee_id' => $employee_id, 'asset_status' => $asset_status, 'title' => $title), true));

        $mPDF1->Output('assetlist.pdf', 'I');
    }

    public function actionPrintEmployeeDocumentListReportPDF() {



        $model = new MasDocument();



        $document_id = Yii::app()->request->getParam('document_id');

        $employee_name = Yii::app()->request->getParam('employee_name');





        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.employee_documentlist_pdf', array('model' => $model, 'document_id' => $document_id, 'employee_name' => $employee_name, 'title' => $title), true));



        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintbranchlistReportPDF() {



        $model = new MasCompanyBranchSponsor();



        $branchname = Yii::app()->request->getParam('branchname');

        $location = Yii::app()->request->getParam('location');

        $currency = Yii::app()->request->getParam('currency');





        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.branch_list_pdf', array('model' => $model, 'branchname' => $branchname, 'location' => $location, 'currency' => $currency, 'title' => $title), true));



        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintEmployeeLeaveSettlementReportPDF() {



        $model = new HrEmployeeLeavesettlement();



        $employee_id = Yii::app()->request->getParam('employee_id');





        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.employee_leavesettlment_pdf', array('model' => $model, 'employee_id' => $employee_id, 'title' => $title), true));



        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintEmployeeGratuityReportPDF() {



        $model = new Employee();



        $employee_id = Yii::app()->request->getParam('employee_id');









        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.employee_gratuity_pdf', array('model' => $model, 'employee_id' => $employee_id, 'title' => $title), true));



        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintInOutDocumentReportPDF() {



        $model = new EmployeeInoutDocument();



        $employee_id = Yii::app()->request->getParam('employee_id');





        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.InOut_document_pdf', array('model' => $model, 'employee_id' => $employee_id, 'title' => $title), true));



        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintEmployeeExpiredDocumentReportPDF() {



        $model = new MasDocument();



        $document_id = Yii::app()->request->getParam('document_id');

        $employee_name = Yii::app()->request->getParam('employee_name');





        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.employee_expireddocument_pdf', array('model' => $model, 'document_id' => $document_id, 'employee_name' => $employee_name, 'title' => $title), true));



        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintEmployeeSalaryReportPDF() {



        $model = new EmployeeSalary();



        $branch_id = Yii::app()->request->getParam('branch_id');

        $employee_id = Yii::app()->request->getParam('employee_id');







        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.employee_salary_pdf', array('model' => $model, 'branch_id' => $branch_id, 'employee_id' => $employee_id, 'title' => $title), true));



        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintEmployeeLoanReportPDF() {
        $branch_id = Yii::app()->request->getParam('branch_id');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $status = Yii::app()->request->getParam('status');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.employee_loan_pdf', array('status' => $status, 'branch_id' => $branch_id, 'employee_id' => $employee_id), true));
        $mPDF1->Output('loandetails.pdf', 'I');
    }

    public function actionPrintEmployeeTicketReportPDF() {

        $model = new EmployeeTicket();
        $employee_id = Yii::app()->request->getParam('employee_id');
        $year = Yii::app()->request->getParam('year');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.employee_ticket_pdf', array('year' => $year, 'employee_id' => $employee_id, 'title' => $title), true));
        $mPDF1->Output('ticketdetails.pdf', 'I');
    }

    public function actionPrintSalarySlipReportPDF() {



        $model = new SalarySlip();



        $branch = Yii::app()->request->getParam('branch');

        $month = Yii::app()->request->getParam('month');

        $year = Yii::app()->request->getParam('year');







        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4-L');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.salaryslip_pdf', array('model' => $model, 'branch' => $branch, 'month' => $month, 'year' => $year, 'title' => $title), true));



        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintSalaryincrementReportPDF() {
        $model = new EmployeeSalary();
        $branch = Yii::app()->request->getParam('branch');
        $month = Yii::app()->request->getParam('month');
        $year = Yii::app()->request->getParam('year');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.salaryincrement_pdf', array('model' => $model, 'branch' => $branch, 'month' => $month, 'year' => $year, 'title' => $title), true));
        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintEmployeeNewHirelistReportPDF() {

        $model = new Employee();

        $employee_id = Yii::app()->request->getParam('employee_id');

        $param = $_REQUEST;
        //print_r($param); die();
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.employee_newhire_pdf', $param, true));

        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintEOSReportPDF() {



        $model = new EmployeeEOS();



        $employee_id = Yii::app()->request->getParam('employee_id');

        $branch_id = Yii::app()->request->getParam('branch_id');

        $department_name = Yii::app()->request->getParam('department_name');

        $designation_name = Yii::app()->request->getParam('designation_name');

        $from_date = Yii::app()->request->getParam('from_date');

        $to_date = Yii::app()->request->getParam('to_date');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.eos_report_pdf', array('model' => $model, 'employee_id' => $employee_id, 'branch_id' => $branch_id, 'department_name' => $department_name, 'designation_name' => $designation_name, 'from_date' => $from_date, 'to_date' => $to_date, 'title' => $title), true));



        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintOvertimeReportPDF() {



        $model = new EmployeeEOS();



        $overtime_from_date = Yii::app()->request->getParam('overtime_from_date');

        $overtime_to_date = Yii::app()->request->getParam('overtime_to_date');

        $emp_id = Yii::app()->request->getParam('emp_id');

        $overtime_emp_sponsor = Yii::app()->request->getParam('overtime_emp_sponsor');



        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.employee_overtime_report_pdf', array('model' => $model, 'overtime_from_date' => $overtime_from_date, 'overtime_to_date' => $overtime_to_date, 'emp_id' => $emp_id, 'overtime_emp_sponsor' => $overtime_emp_sponsor, 'title' => $title), true));



        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintDetailedQuoteReportPDF() {



        $model = new Quotes();



        $qtn_start_from_date = Yii::app()->request->getParam('qtn_start_from_date');

        $qtn_start_to_date = Yii::app()->request->getParam('qtn_start_to_date');

        $qtn_validity_from_date = Yii::app()->request->getParam('qtn_validity_from_date');

        $qtn_validity_to_date = Yii::app()->request->getParam('qtn_validity_to_date');

        $exp_from_date = Yii::app()->request->getParam('exp_from_date');

        $exp_to_date = Yii::app()->request->getParam('exp_to_date');

        $customer_id = Yii::app()->request->getParam('customer_id');

        $leadowner_id = Yii::app()->request->getParam('leadowner_id');

        $sales_group = Yii::app()->request->getParam('sales_group');

        $probability = Yii::app()->request->getParam('probability');

        $value_from = Yii::app()->request->getParam('value_from');

        $value_to = Yii::app()->request->getParam('value_to');

        $qtn_country = Yii::app()->request->getParam('qtn_country');

        $qtn_location = Yii::app()->request->getParam('qtn_location');

        $qtn_part_no_id = Yii::app()->request->getParam('qtn_part_no_id');

        $brand = Yii::app()->request->getParam('brand');

        $status = Yii::app()->request->getParam('status');

        $quotes_type = Yii::app()->request->getParam('quotes_type');

        $param = array('model' => $model,
            'exp_from_date' => $exp_from_date,
            'exp_to_date' => $exp_to_date,
            'qtn_start_from_date' => $qtn_start_from_date,
            'qtn_start_to_date' => $qtn_start_to_date,
            'probability' => $probability,
            'qtn_validity_from_date' => $qtn_validity_from_date,
            'qtn_validity_to_date' => $qtn_validity_to_date,
            'customer_id' => $customer_id,
            'leadowner_id' => $leadowner_id,
            'sales_group' => $sales_group,
            'status' => $status,
            'title' => $title,
            'value_from' => $value_from,
            'value_to' => $value_to,
            'qtn_country' => $qtn_country,
            'qtn_location' => $qtn_location,
            'qtn_part_no_id' => $qtn_part_no_id,
            'brand' => $brand,
            'quotes_type' => $quotes_type,
        );



        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.quote_individual_detailed_list', $param, true));



        $mpdf->Output("Quotelist.pdf", 'I');
    }

    public function actionPrintDetailedQuoteListReportPDF() {



        $model = new Quotes();



        $qtn_start_from_date = Yii::app()->request->getParam('qtn_start_from_date');

        $qtn_start_to_date = Yii::app()->request->getParam('qtn_start_to_date');

        $qtn_validity_from_date = Yii::app()->request->getParam('qtn_validity_from_date');

        $qtn_validity_to_date = Yii::app()->request->getParam('qtn_validity_to_date');

        $exp_from_date = Yii::app()->request->getParam('exp_from_date');

        $exp_to_date = Yii::app()->request->getParam('exp_to_date');

        $customer_id = Yii::app()->request->getParam('customer_id');

        $leadowner_id = Yii::app()->request->getParam('leadowner_id');

        $sales_group = Yii::app()->request->getParam('sales_group');

        $probability = Yii::app()->request->getParam('probability');

        $value_from = Yii::app()->request->getParam('value_from');

        $value_to = Yii::app()->request->getParam('value_to');

        $qtn_country = Yii::app()->request->getParam('qtn_country');

        $qtn_location = Yii::app()->request->getParam('qtn_location');

        $qtn_part_no_id = Yii::app()->request->getParam('qtn_part_no_id');

        $brand = Yii::app()->request->getParam('brand');

        $status = Yii::app()->request->getParam('status');

        $quotes_type = Yii::app()->request->getParam('quotes_type');

        $param = array('model' => $model,
            'exp_from_date' => $exp_from_date,
            'exp_to_date' => $exp_to_date,
            'qtn_start_from_date' => $qtn_start_from_date,
            'qtn_start_to_date' => $qtn_start_to_date,
            'probability' => $probability,
            'qtn_validity_from_date' => $qtn_validity_from_date,
            'qtn_validity_to_date' => $qtn_validity_to_date,
            'customer_id' => $customer_id,
            'leadowner_id' => $leadowner_id,
            'sales_group' => $sales_group,
            'status' => $status,
            'title' => $title,
            'value_from' => $value_from,
            'value_to' => $value_to,
            'qtn_country' => $qtn_country,
            'qtn_location' => $qtn_location,
            'qtn_part_no_id' => $qtn_part_no_id,
            'brand' => $brand,
            'quotes_type' => $quotes_type,
        );



        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/quotation_report_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.quote_detailed_list', $param, true));



        $mpdf->Output("Quotelist.pdf", 'I');
    }

    //end hrreports
    //Get stock state as of detailed report
    public function actionGetStockStateAsOfDetailed() {

        $model = new Inventory();



        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $searchString = trim($_POST['search']['value']);



        $to_date = ( count(explode('/', $_POST['to_date'])) == 3 ) ? date('Y-m-d', strtotime(str_replace('/', '-', $_POST['to_date']))) : date('Y-m-d');

        $generic_id = (int) $_POST['generic_id'];

        $brand_id = (int) $_POST['brand_id'];

        $warehouse = (int) $_POST['warehouse'];
        $machine_type = $_POST['machine_type'];
        $have_stock = $_POST['have_stock'];

        $condition = 'quantity != 0';

        if ($generic_id > 0)
            $condition .= ' AND generic_id=' . $generic_id;

        if ($brand_id > 0)
            $condition .= ' AND brand_id=' . $brand_id;

        if ($searchString != '')
            $condition .= ' AND part_number LIKE "%' . $searchString . '%"';

        if ($machine_type != '') {
            $condition .= ' AND machine_type="' . $machine_type . '"';
        }
        if ($have_stock == 'Y') {
            $condition .= ' AND quantity>0';
        }

        /*
          SELECT S.id AS product_id, S.part_number AS part_number, S.description AS description,

          S.alias_name AS alias_name, B.product_class AS brand, G.generic_name AS generic_name,

          S.brand_class_id AS brand_id, S.generic_id AS generic_id ,SUM(L.quantity) AS quantity,

          SUBSTRING_INDEX( GROUP_CONCAT(CAST(L.cost_price AS CHAR) ORDER BY L.transaction_date DESC), ",", 1 ) AS rate

          FROM erp_stock_ledger L

          LEFT JOIN erp_store S ON S.id = L.product_id LEFT JOIN erp_product_class B ON S.brand_class_id = B.id

          LEFT JOIN erp_inventory_generic_name G ON S.generic_id = G.id WHERE S.inventory_item_type IN (1,3) AND L.transaction_date <= "' . $to_date . '"

          GROUP BY S.id ORDER BY S.part_number
          $stock_state_as_of_query = 'CREATE OR REPLACE VIEW view_stock_state_as_of_ AS

          SELECT S.id AS product_id, S.part_number AS part_number, S.description AS description,

          S.alias_name AS alias_name, B.product_class AS brand, G.generic_name AS generic_name,

          S.brand_class_id AS brand_id, S.generic_id AS generic_id ,SUM(L.quantity) AS quantity,

          SUBSTRING_INDEX( GROUP_CONCAT(CAST(L.cost_price AS CHAR) ORDER BY L.transaction_date DESC), ",", 1 ) AS rate

          FROM erp_stock_ledger L

          LEFT JOIN erp_store S ON S.id = L.product_id LEFT JOIN erp_product_class B ON S.brand_class_id = B.id

          LEFT JOIN erp_inventory_generic_name G ON S.generic_id = G.id WHERE S.inventory_item_type IN (1,3) AND L.transaction_date <= "' . $to_date . '"

          GROUP BY S.id ORDER BY S.part_number'; */

        $stock_state_as_of_query = 'CREATE OR REPLACE VIEW view_stock_state_as_of_detailed AS

                                        SELECT customer_vendor_id,S.id AS product_id, S.part_number AS part_number, S.description AS description,

                                        B.product_class AS brand, G.generic_name AS generic_name,

                                        S.brand AS brand_id, S.generic_id AS generic_id ,

                                        S.rate,L.batch_no AS batch_no,L.expiry_date AS expiry_date,L.serial_no AS serial_no 

                                        FROM erp_stock_ledger L

                                        LEFT JOIN erp_inventory S ON S.id = L.product_id 
                                        
                                        LEFT JOIN erp_product_class B ON S.brand = B.id

                                        LEFT JOIN erp_inventory_generic_name G ON S.generic_id = G.id 
                                        
                                                                               
                                        WHERE S.type IN ("I")  AND L.transaction_date <= "' . $to_date . '"											
                                        GROUP BY product_id,customer_vendor_id 
										
                                        ORDER BY S.part_number';



        //AND S.part_number='74007'                                  

        Yii::app()->db->createCommand($stock_state_as_of_query)->execute();



        $count = Yii::app()->db->createCommand('SELECT COUNT(product_id) AS count FROM view_stock_state_as_of_detailed WHERE ' . $condition)->queryScalar();

        $model = Yii::app()->db->createCommand('SELECT * FROM view_stock_state_as_of_detailed WHERE ' . $condition . ' ORDER BY part_number LIMIT ' . $limit . ' OFFSET ' . $offset)->queryAll();

        $totalValue = Yii::app()->db->createCommand('SELECT SUM(quantity*rate)  AS total FROM view_stock_state_as_of_detailed WHERE ' . $condition)->queryScalar();

        $totalValue = number_format(round(($totalValue), 4), 2, '.', '');

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $rowData = array();


        $product_id = "";
        $row_no = 0;
        foreach ($model as $i => $row) {

            //$modelBatchDetails = ProductLocationDetails::model()->findAll(array('condition'=>''));

            $class_repeat = "no";
            $part_number = "";
            $description = "";
            $generic_name = "";
            $brand_name = "";
            $row_show_no = "";
            if ($product_id == $row['product_id']) {
                $class_repeat = 'yes';
                $product_id = $row['product_id'];
                $part_number = "";
                $description = "";
                $generic_name = "";
                $brand_name = "";
                $row_show_no = "";
            } else {
                $product_id = $row['product_id'];

                $part_number = $row['part_number'];
                $description = $row['description'];
                $generic_name = $row['generic_name'];
                $brand_name = $row['brand'];
                $row_no = $row_no + 1;
                $row_show_no = $row_no;
            }

            //$total=number_format(round(($row['quantity'] * $row['rate']), 4), 4, '.', '');
            $total = number_format(round(($row['quantity'] * $row['rate']), 4), 2, '.', '');

            $rowData[] = array($row_show_no, $part_number, $description, $generic_name, $brand_name, $row['serial_no'], $row['batch_no'], ($row['expiry_date'] != "0000-00-00") ? date("d/m/Y", strtotime($row['expiry_date'])) : "", Yii::app()->numberFormatter->formatCurrency($row['quantity'], ""), Yii::app()->numberFormatter->formatCurrency(round($row['rate'], 2), ""), $total, $class_repeat);
        }



        $data['draw'] = $draw;

        $data['total'] = (float) $totalValue;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $data['data'] = $rowData;

        echo json_encode($data);
    }

    //end



    public function actionPrintStockStateAsofDetailed() {
        $type = $_GET['type'];
        if ($type == 'excel') {
            Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
            $filename = 'stockstate_as_of_detailed' . date('dmYhis') . '.xls';
            header("Content-type: application/vnd.ms-excel");
            header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
            $this->renderPartial('excel/stock_state_as_of_detailed', $_GET, false, true);
            Yii::app()->end();
            return;
        } else {
            $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
            $mpdf->WriteHTML($stylesheet, 1);
            $mpdf->WriteHTML($this->renderPartial("application.views.front.reports.pdf.stock_state_as_of_detailed", $_GET, true));
            $mpdf->Output("stock_state_as_of_" . date('dmYhis') . ".pdf", 'I');
        }
    }

    public function actionGetMachineNo() {
        // $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = 'part_number LIKE "%' . $searchTerm . '%"';

        $model = new Inventory();
        $model = $model->findAll(array('select' => 'id, machine_id, description', 'condition' => $condition, 'group' => 'machine_id', 'limit' => 200));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->machine_id;
            $data[$i]['label'] = $eachModel->machine_id;
            // $data[$i]['product_id'] = $eachModel->id;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionGetFinishedinventorylist() {



        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $searchString = trim($_POST['search']['value']);



        $condition = '1=1 and type=1';

        if (!empty($_POST['brand_id']))
            $condition .= ' AND brand_id ="' . $_POST['brand_id'] . '"';

        if ($searchString != '')
            $condition .= ' AND part_number LIKE "%' . $searchString . '%"';

        $stockFlag = ( $_POST['having_stock'] == 1 ) ? true : false;
        if ($stockFlag)
            $condition .= ' AND quantity >0 ';

        $query = "SELECT * FROM view_all_stock_items WHERE " . $condition;
        $query1 = "SELECT SUM(quantity*rate) FROM view_all_stock_items WHERE " . $condition;
        $count = Yii::app()->db->createCommand($query)->queryScalar();

        $model = Yii::app()->db->createCommand($query . ' ORDER BY part_number LIMIT ' . $limit . ' OFFSET ' . $offset)->queryAll();
        $count = count($model);

        /* if (!Yii::app()->user->hasState("total_value")) {

          $total = Yii::app()->db->createCommand('SELECT SUM(quantity*rate)  AS total FROM view_all_stock_items WHERE ' . $condition)->queryScalar();

          Yii::app()->user->setState("total_value", $total);

          } else {

          $total = Yii::app()->user->getState("total_value");

          } */

        $total = Yii::app()->db->createCommand($query1)->queryScalar();

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $rowData = array();

        function getItemtype($type) {

            $arr_types = array(1 => 'Stock', 2 => 'Service', 3 => 'Raw Material');

            return $arr_types[$type];
        }

        $rowData = array();

        foreach ($model as $i => $row) {

            $arr_check_box = "<input type='checkbox' name='chk_finished_product[]' id='chk_finished_product_" . $i . "' value='" . $row['id'] . "' class='checkBoxClass' onclick='selProductCheckBox();'>";
            $rowData[] = array($arr_check_box, $i + 1, $row['part_number'], $row['description'], $row['generic_name'], $row['brand'], $row['quantity']);
        }



        $data['draw'] = $draw;

        $data['total'] = (float) $total;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $data['data'] = $rowData;

        echo json_encode($data);
    }

    public function actionPrintInventoryFinishedReportPDF() {



        $machine_number = Yii::app()->request->getParam('machine_number');

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];



        //$condition = '1=1';
        $condition = '1=1 and VSI.type=1';

        if (!empty($machine_number))
            $condition .= ' AND S.machine_id ="' . $machine_number . '"';


        if ($searchString != '')
            $condition .= ' AND VSI.part_number LIKE "%' . $searchString . '%"';


        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.inventory_finished_list', array('condition' => $condition, 'having_stock' => $having_stock), true));

        $mpdf->Output("inventorylist" . date('dmYhis') . ".pdf", 'I');
    }

    public function actionPrintFinishedInventoryListExcel() {



        $machine_number = Yii::app()->request->getParam('machine_number');




        $stockFlag = ( $having_stock == 1 ) ? true : false;

        $condition = '1=1 and VSI.type=1';

        if (!empty($machine_number))
            $condition .= ' AND S.machine_id ="' . $machine_number . '"';


        $query = "SELECT * FROM view_all_stock_items AS VSI INNER JOIN erp_store AS S ON S.id=VSI.id where " . $condition;
        $model = Yii::app()->db->createCommand($query . ' ORDER BY S.part_number')->queryAll();






        $filename = 'inventorylist' . date('dmYhis') . '.xls';

        $data = '<html>

                    <head>

                        <style>

                            table{

                                width:100%;

                            }

                            .head{

                                background-color : yellow;

                                font-weight: bold;

                                font-size: 14px;

                            }

                            .total{

                                text-align: right;

                                font-weight: bold;

                                font-size: 14px;

                            }

                        </style>

                    </head>

                    <body>

                        <table border=1>

                            <thead>

                                <th>No</th>

                                <th>Part Number</th>

                                <th>Description</th>

                                <th>Generic</th>

                                <th>Brand /Class</th>
                              
                                 <th>Quantity</th>

                                

                            </thead>

                            <tbody>';

        foreach ($model as $i => $row) :



            if (!$stockFlag) {

                if ($row['type'] == 1) {

                    $type = "Stock";
                } else if ($row['type'] == 2) {

                    $type = "Service";
                } else if ($row['type'] == 3) {

                    $type = "Raw Material";
                }

                $eachValue = round(( $row['quantity'] * $row['rate']), 4);

                $data .= '<tr>

                                <td>' . ($i + 1) . '</td>

                                <td>' . $row['part_number'] . '</td>

                                <td>' . $row['description'] . '</td>

                                <td>' . $row['generic_name'] . '</td>

                                <td>' . $row['brand'] . '</td>

                                

                                

                                <td class="text-right">' . $row['quantity'] . '</td>

                               

                            </tr>';
            } else {

                if ($each->totalQuantity > 0)
                    $data .= '<tr>

                                    <td>' . ($i + 1) . '</td>

                                    <td>' . $row['part_number'] . '</td>

                                    <td>' . $row['description'] . '</td>

                                    <td>' . $row['generic_name'] . '</td>

                                    <td>' . $row['brand'] . '</td>

                                    <td>' . $type . '</td>

                                    <td>' . $row['tax_code'] . '%</td>

                                    <td class="text-right">' . $row['quantity'] . '</td>

                                    <td>' . $row['unit'] . '</td>

                                    <td class="text-right">' . $row['rate'] . '</td>

                                    <td class="text-right">' . number_format((float) $eachValue, 4, '.', '') . '</td>

                                </tr>';
            }

        endforeach;



        $data .= '      </tbody>

                        </table>

                    </body>

                </html>';



        header("Content-type: application/vnd.ms-excel");

        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");

        echo $data;

        Yii::app()->end();

        return;
    }

    //code by sherlin

    public function actionSalesPendingItem() {

        $model = new OrderItem();

        $file_id = $_POST['file_id'];
        //echo 'ok'.$file_id;exit;

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/sales_pending_list', array('model' => $model, 'file_id' => $file_id), false, true);
    }

    public function actionPrintPendingSalesReportPDF() {



        $file_id = Yii::app()->request->getParam('file_id');


        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.sales_pending_listpdf', array('file_id' => $file_id), true));

        $mPDF1->Output("OrdersToBeDelivered.pdf", 'I');
    }

    public function actionPrintpendingsaleListExcel() {

        $file_id = Yii::app()->request->getParam('file_id');
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'receipt_list.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('application.views.front.reports.excel.sales_pending_listexcel', array('file_id' => $file_id), false, true);
        Yii::app()->end();
    }

    public function actionPrintStockLedgerReportAll() {
        $from_date = $_POST['stockledger_list_from_date'];
        $to_date = $_POST['stockledger_list_to_date'];
        $product_id = $_POST['stockledger_list_part_no'];
        $type = $_POST['type'];
        //$customer = $_POST['stockledger_customer_id'];
        //$vendor = $_POST['stockledger_vendor_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_stockledger_list', array('product_id' => $product_id, 'from_date' => $from_date, 'to_date' => $to_date, 'type' => $type), false, true); //, 'customer' => $customer, 'vendor' => $vendor
    }

    public function actionPrintStockLedgerReportExcel() {

        $from_date = $_REQUEST['from_date'];
        $to_date = $_REQUEST['to_date'];
        $product_id = $_REQUEST['product_id'];
        $type = $_REQUEST['type'];
        //$customer = $_REQUEST['stockledger_customer_id'];
        //$vendor = $_REQUEST['stockledger_vendor_id'];
        $filename = 'stockledger_report_' . date('dmYhis') . '.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('application.views.front.reports.excel.stockledger_list', array('from_date' => $from_date, 'to_date' => $to_date, 'product_id' => $product_id, 'type' => $type), false, true); //, 'customer' => $customer, 'vendor' => $vendor
        Yii::app()->end();
    }

    //code added by mereena on 31/03/2020 for extenal tansfer
    public function actionPrintInventoryExternalReport() {

        $model = new InventoryIndirectTransferItem();

        $type = $_POST['type'];

        $from_warehouse = $_POST['from_warehouse'];

        $to_warehouse = $_POST['to_warehouse'];

        $transfer_from_date = $_POST['transfer_from_date'];

        $transfer_to_date = $_POST['transfer_to_date'];

        $transfer_no = $_POST['transfer_no'];



        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



        $this->render('//reports/print_external_transfer_list', array('model' => $model, 'type' => $type, 'from_warehouse' => $from_warehouse, 'to_warehouse' => $to_warehouse, 'transfer_from_date' => $transfer_from_date, 'transfer_to_date' => $transfer_to_date, 'transfer_no' => $transfer_no, 'title' => $title), false, true);
    }

    public function actionPrintInventoryTransferExternalReportPDF() {
        $model = new InventoryIndirectTransferItem();

        $type = Yii::app()->request->getParam('type');

        $from_warehouse = Yii::app()->request->getParam('from_warehouse');

        $to_warehouse = Yii::app()->request->getParam('to_warehouse');

        $transfer_from_date = Yii::app()->request->getParam('transfer_from_date');

        $transfer_to_date = Yii::app()->request->getParam('transfer_to_date');

        $transfer_no = Yii::app()->request->getParam('transfer_no');



        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.inventory_external_transfer_list', array('model' => $model, 'type' => $type, 'from_warehouse' => $from_warehouse, 'to_warehouse' => $to_warehouse, 'transfer_from_date' => $transfer_from_date, 'transfer_to_date' => $transfer_to_date, 'transfer_no' => $transfer_no), true));

        $mpdf->Output("Inventorytransfer.pdf", 'I');
    }

    public function actionPrintInventoryTransferExternalReportExcel() {

        $model = new InventoryIndirectTransferItem();

        $type = Yii::app()->request->getParam('type');

        $from_warehouse = Yii::app()->request->getParam('from_warehouse');

        $to_warehouse = Yii::app()->request->getParam('to_warehouse');

        $transfer_from_date = Yii::app()->request->getParam('transfer_from_date');

        $transfer_to_date = Yii::app()->request->getParam('transfer_to_date');

        $transfer_no = Yii::app()->request->getParam('transfer_no');
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'external_transfer_list.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('application.views.front.excel.print_external_transfer_excel', array('model' => $model, 'type' => $type, 'from_warehouse' => $from_warehouse, 'to_warehouse' => $to_warehouse, 'transfer_from_date' => $transfer_from_date, 'transfer_to_date' => $transfer_to_date, 'transfer_no' => $transfer_no), false, true);
        Yii::app()->end();
    }

    public function actionPrintInvPPEListReport() {
        $from = $_POST['from'];
        $to = $_POST['to'];
        $employee = $_POST['employee'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_inventory_ppe', array('from' => $from, 'to' => $to, 'employee' => $employee), false, true);
    }

    //end
    /* Inventory Movement List start */
    public function actionPrintMovementList() {

        $model = new Inventory();

        $brand_id = $_POST['brand_id'];

        $part_no = $_POST['part_no'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_inventory_movement_list', array('model' => $model, 'brand_id' => $brand_id, 'part_no' => $part_no), false, true);
    }

    public function actionPrintMovementListPdf() {

        $brand_id = Yii::app()->request->getParam('brand_id');

        $part_no = Yii::app()->request->getParam('part_no');

        $param = array(
            'brand_id' => $brand_id,
            'part_no' => $part_no
        );

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.inventory_movement_list', $param, true));

        $mpdf->Output("inventory_movement_list", 'I');
    }

    public function actionPrintMovementListExcel() {
        $brand_id = Yii::app()->request->getParam('brand_id');
        $part_no = Yii::app()->request->getParam('part_no');

        $param = array(
            'brand_id' => $brand_id,
            'part_no' => $part_no
        );

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'inventory_movement_list.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('application.views.front.reports.excel.inventory_movement_list', $param, false, true);
        Yii::app()->end();
    }

    /* Inventory Movement List end */

    public function actionPrintPaymentTermsExcel() {

        $customer_id = Yii::app()->request->getParam('customer_id');
        $payment_terms = Yii::app()->request->getParam('payment_terms');

        $heading = 'Customer ID!Customer Name!Credit Amount!Payment Terms!TRN No';

        $m = 0;
        $list[$m++] = $heading;

        $condition = '1=1';

        if ($customer_id != '') {
            $condition .= ' AND t.id ="' . $customer_id . '"';
        }
        if ($payment_terms != '') {
            $condition .= ' AND t.customer_payment_term ="' . $payment_terms . '"';
        }
        $total = 0;


        $model_customer = Customer::model()->findAll(array('condition' => $condition));

        foreach ($model_customer as $i => $model) {

            $payment_terms_model = MasPaymentTerm::model()->findByPK($model['customer_payment_term']);
            $list[$m++] = $model->id . "!" . $model->customer_name . "!" . $model->customer_credit_limit
                    . "!" . $payment_terms_model->payment_terms
                    . "!" . $model->customer_trn_no;
        }

        $file = fopen("uploads/csvs/test.csv", "w");
        foreach ($list as $line) {
            fputcsv($file, explode('!', $line));
        }

        fclose($file);

        $filename = 'uploads/csvs/test.csv';

        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';

        header('Content-Type: application/csv');

        header("Content-disposition: attachment; filename=\"Payment_Terms.csv\"");

        readfile($filename);

        Yii::app()->end();

        return;
    }

    public function actionPrintStockPurchaseQuantity() {
        $product_id = $_POST['product_id'];
        $to_date = $_POST['to_date'];
        $generic_id = $_POST['generic_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_stock_purchase_quantity', array('product_id' => $product_id, 'to_date' => $to_date, 'generic_id' => $generic_id), false, true);
    }

    public function actionPrintStockPurchaseQuantityExcel() {
        $product_id = Yii::app()->request->getParam('product_id');
        $to_date = Yii::app()->request->getParam('to_date');
        $generic_id = Yii::app()->request->getParam('generic_id');

        $param = array(
            'product_id' => $product_id,
            'to_date' => $to_date,
            'generic_id' => $generic_id
        );

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'New_Order_Movement_Analysis.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('application.views.front.reports.excel.excel_stock_purchase_list', $param, false, true);
        Yii::app()->end();
    }
    public function actionPrintInvCBMReport() {
        $customer_id = $_POST['customer_id'];
        $to_date = $_POST['to_date'];
        $from_date = $_POST['from_date'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_inv_cbm', array('customer_id' => $customer_id, 'to_date' => $to_date, 'from_date' => $from_date), false, true);
    }
    
    public function actionPrintProvisionalJobOrderList(){
         $provisional_from_date = $_POST['provisional_from_date'];
        $provisional_to_date = $_POST['provisional_to_date'];
        $provisional_customer_id = $_POST['provisional_customer_id'];
        $provisional_leadowner_id = $_POST['provisional_leadowner_id'];
        $job_order_id = $_POST['job_order_id'];
        $provisional_vendor_id = $_POST['provisional_vendor_id'];
        $provisional_awb_no = $_POST['provisional_awb_no'];
        $provisional_transport_type = $_POST['provisional_transport_type'];
        $type = $_POST['type'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_provisional_job_order_list', array('provisional_from_date' => $provisional_from_date, 'provisional_to_date' => $provisional_to_date, 'provisional_customer_id' => $provisional_customer_id, 'provisional_leadowner_id' => $provisional_leadowner_id, 'type' => $type, 'job_order_id' => $job_order_id,'provisional_transport_type' => $provisional_transport_type,'provisional_awb_no' => $provisional_awb_no,'provisional_vendor_id' => $provisional_vendor_id), false, true);
    }
    public function actionPrintProvisionaljoborderPdf() {
        $model = new JobOrderAgentDetails();
        $provisional_from_date = Yii::app()->request->getParam('provisional_from_date'); 
        $provisional_customer_id = Yii::app()->request->getParam('provisional_customer_id');
        $provisional_leadowner_id = Yii::app()->request->getParam('provisional_leadowner_id');
        $provisional_to_date = Yii::app()->request->getParam('provisional_to_date');
        $job_order_id = Yii::app()->request->getParam('job_order_id');
        $type = Yii::app()->request->getParam('type');
        $provisional_vendor_id = Yii::app()->request->getParam('provisional_vendor_id');
        $provisional_awb_no = Yii::app()->request->getParam('provisional_awb_no');
        $provisional_transport_type = Yii::app()->request->getParam('provisional_transport_type');
        
        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.print_provisional_job_order', array('model' => $model, 'provisional_from_date' => $provisional_from_date, 'provisional_to_date' => $provisional_to_date, 'provisional_customer_id' => $provisional_customer_id, 'provisional_leadowner_id' => $provisional_leadowner_id,'job_order_id' => $job_order_id,'type' => $type ,'title' => $title,'provisional_transport_type' => $provisional_transport_type,'provisional_awb_no' => $provisional_awb_no,'provisional_vendor_id' => $provisional_vendor_id), true));
        $mpdf->Output("ProvisionalJoborderReport", 'I');
    }

 public function actionProvisionalJoborderListExcel() {
        $model = new JobOrderAgentDetails();
        $provisional_from_date = Yii::app()->request->getParam('provisional_from_date');
        $provisional_customer_id = Yii::app()->request->getParam('provisional_customer_id');
        $provisional_leadowner_id = Yii::app()->request->getParam('provisional_leadowner_id');
        $provisional_to_date = Yii::app()->request->getParam('provisional_to_date');
        $job_order_id = Yii::app()->request->getParam('job_order_id');
        $type = Yii::app()->request->getParam('type');
        $provisional_vendor_id = Yii::app()->request->getParam('provisional_vendor_id');
        $provisional_awb_no = Yii::app()->request->getParam('provisional_awb_no');
        $provisional_transport_type = Yii::app()->request->getParam('provisional_transport_type');


        $filename = 'provisional_joborder_report' . date('dmYhis') . '.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderpartial('application.views.front.reports.excel.provisional_job_order_report', array('provisional_from_date' => $provisional_from_date, 'provisional_to_date' => $provisional_to_date, 'provisional_customer_id' => $provisional_customer_id, 'provisional_leadowner_id' => $provisional_leadowner_id,'job_order_id' => $job_order_id,'type' => $type ,'title' => $title,'provisional_transport_type' => $provisional_transport_type,'provisional_awb_no' => $provisional_awb_no,'provisional_vendor_id' => $provisional_vendor_id), false, true);
        Yii::app()->end();
    }

    public function actionPrintProvisionalInvoiceList(){
    $provisional_from_date = $_POST['provisional_from_date'];
        $provisional_to_date = $_POST['provisional_to_date'];
        $provisional_customer_id = $_POST['provisional_customer_id'];
        $provisional_leadowner_id = $_POST['provisional_leadowner_id'];
        $job_order_id = $_POST['job_order_id'];
        $provisional_vendor_id = $_POST['provisional_vendor_id'];
        $provisional_awb_no = $_POST['provisional_awb_no'];
        $provisional_transport_type = $_POST['provisional_transport_type'];
        $type = $_POST['type'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_provisional_invoice', array('provisional_from_date' => $provisional_from_date, 'provisional_to_date' => $provisional_to_date, 'provisional_customer_id' => $provisional_customer_id, 'provisional_leadowner_id' => $provisional_leadowner_id, 'type' => $type, 'job_order_id' => $job_order_id,'provisional_transport_type' => $provisional_transport_type,'provisional_awb_no' => $provisional_awb_no,'provisional_vendor_id' => $provisional_vendor_id), false, true);
    }
    
      public function actionPrintProvisionalInvoicePdf(){
         $model = new JobOrderAgentDetails();
        $provisional_from_date = Yii::app()->request->getParam('provisional_from_date'); 
        $provisional_customer_id = Yii::app()->request->getParam('provisional_customer_id');
        $provisional_leadowner_id = Yii::app()->request->getParam('provisional_leadowner_id');
        $provisional_to_date = Yii::app()->request->getParam('provisional_to_date');
        $job_order_id = Yii::app()->request->getParam('job_order_id');
        $type = Yii::app()->request->getParam('type');
        $provisional_vendor_id = Yii::app()->request->getParam('provisional_vendor_id');
        $provisional_awb_no = Yii::app()->request->getParam('provisional_awb_no');
        $provisional_transport_type = Yii::app()->request->getParam('provisional_transport_type');
        
        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.print_provisional_invoice_list', array('model' => $model, 'provisional_from_date' => $provisional_from_date, 'provisional_to_date' => $provisional_to_date, 'provisional_customer_id' => $provisional_customer_id, 'provisional_leadowner_id' => $provisional_leadowner_id,'job_order_id' => $job_order_id,'type' => $type ,'title' => $title,'provisional_transport_type' => $provisional_transport_type,'provisional_awb_no' => $provisional_awb_no,'provisional_vendor_id' => $provisional_vendor_id), true));
        $mpdf->Output("ProvisionalInvoiceReport", 'I');
    }
    public function actionPrintProvisionalInvoiceExcel() {
         $model = new JobOrderAgentDetails();
        $provisional_from_date = Yii::app()->request->getParam('provisional_from_date'); 
        $provisional_customer_id = Yii::app()->request->getParam('provisional_customer_id');
        $provisional_leadowner_id = Yii::app()->request->getParam('provisional_leadowner_id');
        $provisional_to_date = Yii::app()->request->getParam('provisional_to_date');
        $job_order_id = Yii::app()->request->getParam('job_order_id');
        $type = Yii::app()->request->getParam('type');
        $provisional_vendor_id = Yii::app()->request->getParam('provisional_vendor_id');
        $provisional_awb_no = Yii::app()->request->getParam('provisional_awb_no');
        $provisional_transport_type = Yii::app()->request->getParam('provisional_transport_type');


        $filename = 'provisional_invoice_report' . date('dmYhis') . '.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderpartial('application.views.front.reports.excel.provisional_invoice_report', array('model' => $model,'provisional_from_date' => $provisional_from_date, 'provisional_to_date' => $provisional_to_date, 'provisional_customer_id' => $provisional_customer_id, 'provisional_leadowner_id' => $provisional_leadowner_id,'job_order_id' => $job_order_id,'type' => $type ,'title' => $title,'provisional_transport_type' => $provisional_transport_type,'provisional_awb_no' => $provisional_awb_no,'provisional_vendor_id' => $provisional_vendor_id), false, true);
        Yii::app()->end();
    }
     public function actionPrintQuotationReport() {



        $model = new QuotationItems();

        $qtn_start_from_date = $_POST['start_from_date'];

        $qtn_start_to_date = $_POST['start_to_date'];

        

        $customer_id = $_POST['customer_id'];
        $qtn_leadowner_id = $_POST['qtn_leadowner_id'];
        $qtn_created_by = $_POST['qtn_created_by'];

        $qtn_shipper_id = $_POST['qtn_shipper_id'];

        $qtn_consignee_id = $_POST['qtn_consignee_id'];



        $qtn_origin_id = $_POST['qtn_origin_id'];

        $qtn_destination_id = $_POST['qtn_destination_id'];

        $filter_quotation_transport_type = $_POST['filter_quotation_transport_type'];

        $qtn_status = $_POST['qtn_status'];

        $brand = $_POST['brand'];

        $value_from = $_POST['value_from'];

        $value_to = $_POST['value_to'];

       

        $quotes_type = $_POST['quotes_type'];
        
        $provisional_vendor_id = $_POST['provisional_vendor_id'];
         
        $provisional_transport_type = $_POST['provisional_transport_type'];
        $quotation_id =  $_POST['quotation_id'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_quotation_list', array('model' => $model,'qtn_start_from_date' => $qtn_start_from_date, 'qtn_start_to_date' => $qtn_start_to_date,
         'customer_id' => $customer_id, 'qtn_shipper_id' => $qtn_shipper_id, 'qtn_consignee_id' => $qtn_consignee_id, 'qtn_origin_id' => $qtn_origin_id,
            'qtn_destination_id' => $qtn_destination_id, 'filter_quotation_transport_type' => $filter_quotation_transport_type, 'qtn_status' => $qtn_status, 'brand' => $brand, 'qtn_created_by' => $qtn_created_by,'qtn_leadowner_id' =>$qtn_leadowner_id,
            'value_from' => $value_from, 'value_to' => $value_to, 'title' => $title, 'quotes_type' => $quotes_type,'provisional_transport_type' =>$provisional_transport_type,'provisional_vendor_id' =>$provisional_vendor_id,'quotation_id' => $quotation_id), false, true);
    }
    public function actionPrintQuotationReportPDF() {



        $model = new QuotationItems();



        $qtn_start_from_date = Yii::app()->request->getParam('qtn_start_from_date');

        $qtn_start_to_date = Yii::app()->request->getParam('qtn_start_to_date');

        $customer_id = Yii::app()->request->getParam('customer_id');
        
        $qtn_leadowner_id = Yii::app()->request->getParam('qtn_leadowner_id');
         
        $qtn_created_by = Yii::app()->request->getParam('qtn_created_by');

        $qtn_shipper_id = Yii::app()->request->getParam('qtn_shipper_id');

        $qtn_consignee_id = Yii::app()->request->getParam('qtn_consignee_id');

        $qtn_origin_id = Yii::app()->request->getParam('qtn_origin_id');

        $qtn_destination_id = Yii::app()->request->getParam('qtn_destination_id');

        $filter_quotation_transport_type = Yii::app()->request->getParam('filter_quotation_transport_type');

        $qtn_status = Yii::app()->request->getParam('qtn_status');

        $qtn_location = Yii::app()->request->getParam('qtn_location');

        $qtn_part_no_id = Yii::app()->request->getParam('qtn_part_no_id');

        $quotation_id = Yii::app()->request->getParam('quotation_id');

        $provisional_vendor_id = Yii::app()->request->getParam('provisional_vendor_id');

        $provisional_transport_type = Yii::app()->request->getParam('provisional_transport_type');
        $quotes_type = Yii::app()->request->getParam('quotes_type');



        $param = array('model' => $model,
            'qtn_start_from_date' => $qtn_start_from_date, 'qtn_start_to_date' => $qtn_start_to_date,
         'customer_id' => $customer_id, 'qtn_shipper_id' => $qtn_shipper_id, 'qtn_consignee_id' => $qtn_consignee_id, 'qtn_origin_id' => $qtn_origin_id,
            'qtn_destination_id' => $qtn_destination_id, 'filter_quotation_transport_type' => $filter_quotation_transport_type, 'qtn_status' => $qtn_status, 'brand' => $brand, 'qtn_created_by' => $qtn_created_by,'qtn_leadowner_id' =>$qtn_leadowner_id,
            'value_from' => $value_from, 'value_to' => $value_to, 'title' => $title, 'quotes_type' => $quotes_type,'provisional_transport_type' =>$provisional_transport_type,'provisional_vendor_id' =>$provisional_vendor_id,'quotation_id' => $quotation_id
        );



        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.quotation_list', $param, true));



        $mpdf->Output("Quotationlist.pdf", 'I');
    }

    public function actionPrintQuotationExcel() {

        $start_from_date = Yii::app()->request->getParam('start_from_date');

        $start_to_date = Yii::app()->request->getParam('start_to_date');

        $customer_id = Yii::app()->request->getParam('customer_id');
        
        $qtn_leadowner_id = Yii::app()->request->getParam('qtn_leadowner_id');
         
        $qtn_created_by = Yii::app()->request->getParam('qtn_created_by');

        $qtn_shipper_id = Yii::app()->request->getParam('qtn_shipper_id');

        $qtn_consignee_id = Yii::app()->request->getParam('qtn_consignee_id');

        $qtn_origin_id = Yii::app()->request->getParam('qtn_origin_id');

        $qtn_destination_id = Yii::app()->request->getParam('qtn_destination_id');

        $filter_quotation_transport_type = Yii::app()->request->getParam('filter_quotation_transport_type');

        $qtn_status = Yii::app()->request->getParam('qtn_status');
        
        $quotation_id = Yii::app()->request->getParam('quotation_id');

        $provisional_vendor_id = Yii::app()->request->getParam('provisional_vendor_id');

        $provisional_transport_type = Yii::app()->request->getParam('provisional_transport_type');

        $file = fopen("uploads/csvs/test.csv", "w");

        $criteria = new CDbCriteria;



        if ($start_from_date != '') {
            
            $start_from_date = str_replace('/', '-', $start_from_date);
                        
            $start_from_date = date('Y-m-d', strtotime($start_from_date));
            
            $criteria->addCondition('quotation.quotation_date >="' . $start_from_date . '"', 'AND');
        }

        if ($start_to_date != '') {
             
            $start_to_date = str_replace('/', '-', $start_to_date);
                        
            $start_to_date = date('Y-m-d', strtotime($start_to_date));
            
            $criteria->addCondition('quotation.quotation_date <="' . $start_to_date . '"', 'AND');
        }

        if ($customer_id != '') {

            $criteria->addCondition('quotation.customer_id ="' . $customer_id . '"', 'AND');
        }
        if ($qtn_created_by != '') {

            $criteria->addCondition('quotation.created_by ="' . $qtn_created_by . '"', 'AND');
        }
         if ($qtn_leadowner_id != '') {

            $criteria->addCondition('quotation.lead_owner_id ="' . $qtn_leadowner_id . '"', 'AND');
        }


        if ($qtn_shipper_id != '') {

            $criteria->addCondition('quotation.shipper_id = "' . $qtn_shipper_id . '"', 'AND');
        }
         if ($qtn_consignee_id != '') {

            $criteria->addCondition('quotation.consignee_id LIKE "%' . $qtn_consignee_id . '%"', 'AND');
        }

        if ($qtn_origin_id != '') {
            $criteria->addCondition('quotation.origin_id ="' . $qtn_origin_id . '"', 'AND');
        }
         if ($qtn_destination_id != '') {
            $criteria->addCondition('quotation.destination_id ="' . $qtn_destination_id . '"', 'AND');
        }
        
         if ($filter_quotation_transport_type != '') {
            $criteria->addCondition('quotation.transport_type ="' . $filter_quotation_transport_type . '"', 'AND');
        }
        
         if ($qtn_status != '') {
            $criteria->addCondition('quotation.quotation_status ="' . $qtn_status . '"', 'AND');
        }
        if ($provisional_vendor_id != '') {

            $criteria->addCondition('t.forwarder_id ="' . $provisional_vendor_id . '"', 'AND');
        }
         if ($provisional_transport_type != '') {

            $criteria->addCondition('t.activity_type ="' . $provisional_transport_type . '"', 'AND');
        }
         if ($quotation_id != '') {

            $criteria->addCondition('t.quotation_id ="' . $quotation_id . '"', 'AND');
        }
        //print_r($criteria);echo '<pre>';

        $quote = QuotationItems::model()->with('quotation','vendordetails','activitytype')->findAll($criteria);

        $j = 0;



        $list[$j++] = 'No!Qtn #!Qtn Date!Customer!Contact Person!Account Manager!Created By!Origin!Destination!Agent!Cnee!Ch.Wt! Type! Satus!Selling!Cost!Profit';



        foreach ($quote as $i => $row) {
            
            
             $destination_id = '';
            if ((int) $row['quotation']['destination_id'] > 0) {
                $destination_id = MasCountry::model()->findByPk($row['quotation']['destination_id'])->country_name;
            }
            $origin_id = '';
            if ((int) $row['quotation']['origin_id'] > 0) {
                $origin_id = MasCountry::model()->findByPk($row['quotation']['origin_id'])->country_name;
            }

            if ($row->quotation->quotation_date != '0000-00-00') {

                $d1 = date("d/m/Y", strtotime($row->quotation->quotation_date));
            } else {

                $d1 = " ";
            }

           /* if ($row->qtn_close_date != '0000-00-00') {

                $d2 = date("d/m/Y", strtotime($row->qtn_close_date));
            } else {

                $d2 = " ";
            }

            if ($row->qtn_delivery_date != '0000-00-00') {

                $d3 = date("d/m/Y", strtotime($row->qtn_delivery_date));
            } else {

                $d3 = " ";
            }

            if ($row->qtn_validity != '0000-00-00') {

                $d4 = date("d/m/Y", strtotime($row->qtn_validity));
            } else {

                $d4 = " ";
            }*/

            if ($row->quotation->quotation_date != '0000-00-00') {

                $d5 = date("d/m/Y", strtotime($row->quotation->quotation_date));
            } else {

                $d5 = " ";
            }
            
            
             
                         switch($row->quotation->quotation_status){

                          case 'CL':
                          $row_quotation_status="Closed";
                          break;
                          case 'A':
                          $row_quotation_status="Awaiting";
                          break;
                          case 'CO':
                          $row_quotation_status="Confirmed";
                          break;
                          break;
                          case 'CA':
                          $row_quotation_status="Cancel";
                          break;
                          default:
                          $row_quotation_status="Open";
                          break;
                          } 
                        
            

             if ($row->quotation->quotation_status == '0')
                $state = "Open";
            if ($row->quotation->quotation_status == 'CL')
                $state = "Closed";
            if ($row->quotation->quotation_status == 'A')
                $state = "Awaiting";
            if ($row->quotation->quotation_status == 'CO')
                $state = "Confirmed";

        $planned_profit = $row->planned_selling_price- $row->planned_cost;
        $total_planned_cost += $row->planned_cost;

        $total_selling_price += $row->planned_selling_price;
        $total_planned_profit+=$planned_profit;
         if($row->quotation->contact_ids!=""){
                               
                              $contact = explode(",", $row->quotation->contact_ids); 
                              if(count ($contact) >1){
                                   $contactdet = array();
                                foreach ($contact as $model){
                                   
                                  $contactdetails = CustomerContact::model()->findByPK($model);
                                  $contactdet[]= $contactdetails->person_name; 
                                  
                                }
                               
                                if(!empty($contactdet)) {
                                $detailscontact =  implode(",", $contactdet);  
                                }
                               }
                                else {
                                    $contactdetails = CustomerContact::model()->findByPK($row->quotation->contact_ids);
                                   
                                    $detailscontact = $contactdetails->person_name;
                                }
                            }

            $list[$j++] = ($i + 1) .  '!' . $row->quotation->id . '!' . $d5 . '!' . $row->quotation->customer->customer_name . '!'. $detailscontact . '!' . $row->quotation->leadowner->fullName . '!'  . $row->quotation->createdby->fullName. '!'. $origin_id . "!" . 
                     $destination_id .  '!' . $row->vendordetails->vendor_name . '!'.$row->quotation->consignee_id.'!'. $row->quotation->chargeable_weight . '!' . $row->activitytype->activity_type. '!' . $row_quotation_status. '!' .$row->planned_selling_price. '!' . $row->planned_cost . '!' .  $planned_profit  ;
        }
        $list[$j++] ="!!!!!!!!!!!!!!{$total_selling_price}!{$total_planned_cost}!{$total_planned_profit}";

        $j++;

        foreach ($list as $line) {

            fputcsv($file, explode('!', $line));
        }

        fclose($file);

        $filename = 'uploads/csvs/test.csv';

        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';

        header('Content-Type: application/csv');

        header("Content-disposition: attachment; filename=\"quotationlist.csv\"");

        readfile($filename);

        Yii::app()->end();

        return;
    }
    
    
     public function actionPrintRackBin() {

        $model = new StockLedger();
        $rackbin_part_no = $_POST['rackbin_part_no'];
        $rackbin_warehouse_warehouse = $_POST['rackbin_warehouse_warehouse'];
        $rack_id = $_POST['rack_id'];
        $bin_id = $_POST['bin_id'];
     Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_rack_bin_list', array('model' => $model,'rackbin_part_no' => $rackbin_part_no, 'rackbin_warehouse_warehouse' => $rackbin_warehouse_warehouse,
         'rack_id' => $rack_id, 'bin_id' => $bin_id), false, true);
    }
     public function actionPrintRackBinReportPDF() {

        $model = new StockLedger();

        $rackbin_part_no = Yii::app()->request->getParam('rackbin_part_no');

        $rackbin_warehouse_warehouse = Yii::app()->request->getParam('rackbin_warehouse_warehouse');

        $rack_id = Yii::app()->request->getParam('rack_id');
        
        $bin_id = Yii::app()->request->getParam('bin_id');
        
        $param = array('model' => $model,'rackbin_part_no' => $rackbin_part_no, 'rackbin_warehouse_warehouse' => $rackbin_warehouse_warehouse,
         'rack_id' => $rack_id, 'bin_id' => $bin_id);

      $mpdf = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.rackbin_list', $param, true));



        $mpdf->Output("RackBinlist.pdf", 'I');
    }
    public function actionPrintRackBinInvoiceList() {

        $rackbin_part_no = Yii::app()->request->getParam('rackbin_part_no');

        $rackbin_warehouse_warehouse = Yii::app()->request->getParam('rackbin_warehouse_warehouse');

        $rack_id = Yii::app()->request->getParam('rack_id');
        
        $bin_id = Yii::app()->request->getParam('bin_id');

        $condition = 'D.type!="OB"';
                    if ($rackbin_part_no != '') {

                        $condition .= ' AND product_id ="' . $rackbin_part_no . '"';
                    }


                    if ($rackbin_warehouse_warehouse != '') {

                        $condition .= ' AND warehouse_id ="' . $rackbin_warehouse_warehouse . '"';
                    }
                    if ($rack_id != '') {

                        $condition .= ' AND rack_id ="' . $rack_id . '"';
                    }
                    if ($bin_id != '') {

                        $condition .= ' AND bin_id ="' . $bin_id . '"';
                    }

        $sql = "SELECT D.bin_name,D.rack_name,D.product_id,D.warehouse_name,SUM(D.quantity) as Qunatity,I.part_number FROM view_stock_ledger_details D INNER JOIN erp_inventory I on I.id=D.product_id

                            where " . $condition . "

                GROUP BY product_id,rack_name";





       $model_stockledger = Yii::app()->db->createCommand($sql)->queryAll();

        $heading = 'No,Part No,Warehouse,Rack,Bin,Quantity';



       
        $j = 0;



        $list[$j] = $heading;

        $j++;

        

            foreach ($model_stockledger as $i => $row) {



               



                $list[$j++] = ($i + 1) . ',' . $row['part_number'] . ',' . $row['warehouse_name']. ',' . $row['rack_name'] . ',' . $row['bin_name'] . ',' . $row['Qunatity'];
            }
        

        $file = fopen("uploads/csvs/test.csv", "w");

        foreach ($list as $line) {

            fputcsv($file, explode(',', $line));
        }



        fclose($file);



//$filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $filename = 'uploads/csvs/test.csv';



        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';



        header('Content-Type: application/csv;');



        header("Content-disposition: attachment; filename=\"rackbinlist.csv\"");



        readfile($filename);



        Yii::app()->end();



        return;
    }
    
    
     public function actiongetracks(){
        $id=$_POST['rack_id'];
        $arr_sub=array();
        if($id>0)
        $arr_sub=MasInvBin ::getBins_rackwise($id);
        $drop = array();
        $drop['drop'] = CHtml::dropDownList('bin_id', 'bin_id',$arr_sub, array('class' => 'tooltipster', 'data-label' => 'Bin', 'empty' => 'Select','data-search'=>true));
        echo CJSON::encode($drop);
    }
    
     public function actionPrintQuotationSummaryReport() {



        $model = new QuotationItems();

        $qtn_start_from_date = $_POST['start_from_date'];

        $qtn_start_to_date = $_POST['start_to_date'];

        

        $customer_id = $_POST['customer_id'];
        $qtn_leadowner_id = $_POST['qtn_leadowner_id'];
        $qtn_created_by = $_POST['qtn_created_by'];

        $qtn_shipper_id = $_POST['qtn_shipper_id'];

        $qtn_consignee_id = $_POST['qtn_consignee_id'];



        $qtn_origin_id = $_POST['qtn_origin_id'];

        $qtn_destination_id = $_POST['qtn_destination_id'];

        $filter_quotation_transport_type = $_POST['filter_quotation_transport_type'];

        $qtn_status = $_POST['qtn_status'];

        $brand = $_POST['brand'];

        $value_from = $_POST['value_from'];

        $value_to = $_POST['value_to'];

       

        $quotes_type = $_POST['quotes_type'];
        
        $provisional_vendor_id = $_POST['provisional_vendor_id'];
         
        $provisional_transport_type = $_POST['provisional_transport_type'];
        $quotation_id =  $_POST['quotation_id'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_quotation_summary_list', array('model' => $model,'qtn_start_from_date' => $qtn_start_from_date, 'qtn_start_to_date' => $qtn_start_to_date,
         'customer_id' => $customer_id, 'qtn_shipper_id' => $qtn_shipper_id, 'qtn_consignee_id' => $qtn_consignee_id, 'qtn_origin_id' => $qtn_origin_id,
            'qtn_destination_id' => $qtn_destination_id, 'filter_quotation_transport_type' => $filter_quotation_transport_type, 'qtn_status' => $qtn_status, 'brand' => $brand, 'qtn_created_by' => $qtn_created_by,'qtn_leadowner_id' =>$qtn_leadowner_id,
            'value_from' => $value_from, 'value_to' => $value_to, 'title' => $title, 'quotes_type' => $quotes_type,'provisional_transport_type' =>$provisional_transport_type,'provisional_vendor_id' =>$provisional_vendor_id,'quotation_id' => $quotation_id), false, true);
    }
// code added by abin on 19-07-23 to get quotation summary list pdf
    public function actionPrintQuotationSummaryReportPDF() {
        $model = new Quotation();
        $start_from_date = Yii::app()->request->getParam('start_from_date');
        $start_to_date = Yii::app()->request->getParam('start_to_date');
        $customer_id = Yii::app()->request->getParam('customer_id');
        $qtn_leadowner_id = Yii::app()->request->getParam('qtn_leadowner_id');
        $qtn_created_by = Yii::app()->request->getParam('qtn_created_by');
        $qtn_shipper_id = Yii::app()->request->getParam('qtn_shipper_id');
        $qtn_consignee_id = Yii::app()->request->getParam('qtn_consignee_id');
        $qtn_origin_id = Yii::app()->request->getParam('qtn_origin_id');
        $qtn_destination_id = Yii::app()->request->getParam('qtn_destination_id');
        $qtn_status = Yii::app()->request->getParam('qtn_status');
        $quotation_id = Yii::app()->request->getParam('quotation_id');
        $quotes_type = Yii::app()->request->getParam('quotes_type');
        $param = array('model' => $model,
            'qtn_start_from_date' => $start_from_date, 'qtn_start_to_date' => $start_to_date,
         'customer_id' => $customer_id, 'qtn_shipper_id' => $qtn_shipper_id, 'qtn_consignee_id' => $qtn_consignee_id, 'qtn_origin_id' => $qtn_origin_id,
            'qtn_destination_id' => $qtn_destination_id, 'qtn_status' => $qtn_status, 'qtn_created_by' => $qtn_created_by,'qtn_leadowner_id' =>$qtn_leadowner_id,
            'title' => $title, 'quotes_type' => $quotes_type,'quotation_id' => $quotation_id
        );
        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('application.views.front.reports.pdf.quotation_summary_list', $param, true));
        $mpdf->Output("Quotationlist.pdf", 'I');
    }
    //end of code
    public function actionPrintQuotationSummaryExcel() {
        $start_from_date = Yii::app()->request->getParam('start_from_date');
        $start_to_date = Yii::app()->request->getParam('start_to_date');
        $customer_id = Yii::app()->request->getParam('customer_id');
        $qtn_leadowner_id = Yii::app()->request->getParam('qtn_leadowner_id');
        $qtn_created_by = Yii::app()->request->getParam('qtn_created_by');
        $qtn_shipper_id = Yii::app()->request->getParam('qtn_shipper_id');
        $qtn_consignee_id = Yii::app()->request->getParam('qtn_consignee_id');
        $qtn_origin_id = Yii::app()->request->getParam('qtn_origin_id');
        $qtn_destination_id = Yii::app()->request->getParam('qtn_destination_id');
        $qtn_status = Yii::app()->request->getParam('qtn_status');
        $quotation_id = Yii::app()->request->getParam('quotation_id');
        $file = fopen("uploads/csvs/test.csv", "w");
        $condition ='1=1 ';
        if ($start_from_date != '') {
            $start_from_date = str_replace('/', '-', $start_from_date);
            $start_from_date = date('Y-m-d', strtotime($start_from_date));
            $condition .=' AND t.quotation_date >="' . $start_from_date . '"';
        }
        if ($start_to_date != '') {
            $start_to_date = str_replace('/', '-', $start_to_date);
            $start_to_date = date('Y-m-d', strtotime($start_to_date));
            $condition .=' AND t.quotation_date <="' . $start_to_date . '"';
        }
        if ($customer_id != '') {
            $condition .=' AND t.customer_id ="' . $customer_id . '"';
        }
        if ($qtn_created_by != '') {
            $condition .=' AND t.created_by ="' . $qtn_created_by . '"';
        }
        if ($qtn_leadowner_id != '') {
            $condition .=' AND t.lead_owner_id ="' . $qtn_leadowner_id . '"';
        }
        if ($qtn_shipper_id != '') {
            $condition .=' AND t.shipper_id ="' . $qtn_shipper_id . '"';
        }
        if ($qtn_consignee_id != '') {
            $condition .=' AND t.consignee_id LIKE "%' . $qtn_consignee_id . '%"';
        }
        if ($qtn_origin_id != '') {
            $condition .=' AND t.origin_id ="' . $qtn_origin_id . '"';
        }
        if ($qtn_destination_id != '') {
             $condition .=' AND t.destination_id ="' . $qtn_destination_id . '"';
        }
        if ($qtn_status != '') {
            $condition .=' AND t.quotation_status ="' . $qtn_status . '"';
        }
        if ($quotation_id != '') {
            $condition .=' AND id ="' . $quotation_id . '"';
        }
        $sql = "SELECT * FROM view_quotation_details t where ".$condition;
        $quote = Yii::app()->db->createCommand($sql)->queryAll();
        $j = 0;
        $list[$j++] = 'No!Qtn #!Qtn Date!Customer!Contact Person!Account Manager!Created By!Origin!Destination!Consignee!Satus!Ch.Wt!Selling!Cost!Profit';
        foreach ($quote as $i => $row) {
            if ($row->quotation_date != '0000-00-00') {
                $quotation_date = date("d/m/Y", strtotime($row['quotation_date']));
            } else {
                $quotation_date = " ";
            }
            switch($row['quotation_status']){
                  case 'CL':
                      $row_quotation_status="Closed";
                  break;
                  case 'A':
                    $row_quotation_status="Awaiting";
                  break;
                  case 'CO':
                    $row_quotation_status="Confirmed";
                  break;
                  case 'CA':
                    $row_quotation_status="Cancel";
                  break;
                  default:
                    $row_quotation_status="Open";
                  break;
            }
            $total_selling_price+=$row['selling_price'];
            $total_planned_cost+=$row['cost_price'];
            $total_planned_profit+=$row['profit'];
            $list[$j++] = ($i + 1) .  '!' . $row['id'] . '!' . $quotation_date . '!' . $row['customer_name'] . '!'. $row['contact_names'] . '!' . $row['leadowner'] . '!'  .$row['created_user']. '!'. $row['origin'] . "!" . 
            $row['destination'] .  '!' . $row['consignee_id'] .  '!' .$row_quotation_status . '!' .$row['chargeable_weight']. '!' .$row['selling_price']. '!' . $row['cost_price'] . '!' .  $row['profit']  ;
        }
        $list[$j++] ="!!!!!!!!!!!!{$total_selling_price}!{$total_planned_cost}!{$total_planned_profit}";
        $j++;
        foreach ($list as $line) {
            fputcsv($file, explode('!', $line));
        }
        fclose($file);
        $filename = 'uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"quotationsummarylist.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

  


}
