<?php

class QuotationpricelistController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'Save', 'Disable','DownloadQuotationPriceList','uploadIndex','UploadQuotationpricelist',
                 'SaveUploadQuotationpricelist','DownloadQuotationpricelistFormat','GetOriginCountrylist','UplodQuotationPriceList','UpdatePriceList'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

    // Uncomment the following methods and override them if needed

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

     public function actionGetList() {
        $model = new QuotationPriceList();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.agent',
            2 => 'country_ref.country_id',
            3 => 'dest_country_ref.destination_country_id',
            4=> 't.weight',
            5 => 't.price',
            6 => 't.transport_type',
            7 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1 AND t.isActive="Y"';
        if ($_POST['agent']!='') {
            $condition .= " AND agent ='{$_POST['agent']}' ";
        }
        if ($_POST['country_id'] != '') { 
            $condition .= ' AND t.country_id=' . $_POST['country_id'];
        }
        if ($_POST['destination_country_id'] != '') { 
            $condition .= ' AND t.destination_country_id=' . $_POST['destination_country_id'];
        }
         if ($_POST['transport_type'] != '') { 
           $condition .= " AND t.transport_type = '" . $_POST['transport_type'] . "'";

        }
        
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition  .= " AND (t.agent LIKE '%" . $searchString . "%' OR country_ref.country_name LIKE '%" . $searchString . "%' OR dest_country_ref.country_name LIKE '%" . $searchString . "%'  OR t.weight LIKE '%" . $searchString . "%' OR t.price LIKE '%" . $searchString . "%' OR t.transport_type LIKE '%" . $searchString . "%' OR t.comment LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('country_ref','dest_country_ref')->count(array('condition' => $condition));
        $model = $model->with('country_ref','dest_country_ref')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' =>'agent asc,country_id asc, destination_country_id asc,weight asc, price asc'));
        // $count = $model->count(array('condition' => $condition));
        // $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
       // echo $condition;
        
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = '';
            $rowData[] = array($m,
               $row['agent'],
                $row->country_ref->country_name,
                $row->dest_country_ref->country_name,
                '<div class="text-right">' . Yii::app()->numberFormatter->formatCurrency($row['weight'], "") . '</div>',
                '<div class="text-right">' . Yii::app()->numberFormatter->formatCurrency($row['price'], "") . '</div>',
                $type = ($row['transport_type'] === 'E') ? 'Export' : 'Import',
                '<div class="btn-wrap text-center">' . $div . '</div>',
                array('id' => $row['id'],'code'=> 'Edit Price List ', 'status' => $row->isActive, 'type' => $row->transport_type));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new QuotationPriceList();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('quotation_form', array('model' => $model), false, false);
    }


    public function actionSave() {
        
        $other_errors = array();
        $valid=TRUE;
        
        
        $agent_id               = $_POST['QuotationPriceList']['agent_id'];
        $country_id      = $_POST['QuotationPriceList']['country_id'];
        $destination_country_id = $_POST['QuotationPriceList']['destination_country_id'];
        //$destination_country_array = implode(',', $destination_country_id);//for multiple
        $weight                 = $_POST['QuotationPriceList']['weight'];
        $price                  = $_POST['QuotationPriceList']['price'];
        if($_POST['QuotationPriceList']['transport_type']=='E'){
            $arr_export_import_countries = $destination_country_id;//implode(",",$destination_country_id);
        }
        else{
            $arr_export_import_countries = $country_id;//implode(",",$country_id); 
        }
        
        if(empty($agent_id)){
            $other_errors[]='Please select Agent';
            $valid=false;
        }
        
        if(empty($country_id)){
            $other_errors[]='Please select Origin';
            $valid=false;
        }
        
        if(empty($destination_country_id)){
            $other_errors[]='Please select Destination';
            $valid=false;
        }
        
        if(empty($_POST['QuotationPriceList']['transport_type'])){
            $other_errors[]='Please select Type';
            $valid=false;
        }
        
        if(empty($_POST['QuotationPriceList']['price_type'])){
            $other_errors[]='Please select Price Type';
            $valid=false;
        }
        
        
        
        if($valid){
        
        //echo '<pre>';
       // print_r($arr_export_import_countries);
       
        foreach($arr_export_import_countries as $each_country_id){

            //echo $each_country_id;exit;
            $modelVendor                                = Vendor::model()->findByPk($agent_id);
            $modelQuotationPriceList[$p]                    = new QuotationPriceList(); 
            $modelQuotationPriceList[$p]->attributes      = $_POST['QuotationPriceList'];
            $modelQuotationPriceList[$p]->agent_id          =   $agent_id;
            $modelQuotationPriceList[$p]->agent             =   $modelVendor->vendor_name;
            $modelQuotationPriceList[$p]->transport_type    =   $_POST['QuotationPriceList']['transport_type'];
            $modelQuotationPriceList[$p]->price_type        =   $_POST['QuotationPriceList']['price_type'];
            if($_POST['QuotationPriceList']['transport_type']=='E'){
                 $modelQuotationPriceList[$p]->country_id = $country_id;
                 $modelQuotationPriceList[$p]->destination_country_id = $each_country_id;
            }
            else{
                $modelQuotationPriceList[$p]->country_id = $each_country_id;
                $modelQuotationPriceList[$p]->destination_country_id = $destination_country_id;
           
            }
            //echo$country_exist_count; destid, editid 
            
            
            
            /*$SQL= "SELECT id FROM erp_quotation_price_list WHERE 
                agent_id = $agent_id AND 
                price_type='".$_POST['QuotationPriceList']['price_type']."' AND 
                transport_type='".$_POST['QuotationPriceList']['transport_type']."' AND 
                weight = '".$modelQuotationPriceList[$p]->weight."'  AND  
                price = '".$modelQuotationPriceList[$p]->price."'  AND 
                destination_country_id=".$modelQuotationPriceList[$p]->destination_country_id." AND 
                country_id =".$modelQuotationPriceList[$p]->country_id;*/
                
            $SQL= "SELECT id FROM erp_quotation_price_list WHERE 
                agent_id = $agent_id AND 
                price_type='".$_POST['QuotationPriceList']['price_type']."' AND 
                transport_type='".$_POST['QuotationPriceList']['transport_type']."' AND 
                weight = '".$modelQuotationPriceList[$p]->weight."'  AND  
                destination_country_id=".$modelQuotationPriceList[$p]->destination_country_id." AND 
                country_id =".$modelQuotationPriceList[$p]->country_id;    
                
            $quotation_price_id = (int) Yii::app()->db->createCommand($SQL)->queryScalar();
            
            $valid = $modelQuotationPriceList[$p]->validate() && $valid;
            $p++;
            
            if($quotation_price_id > 0){
                $other_errors[]='Price already added for ['.$modelVendor->vendor_name.']'; 
                $valid=false;
            }
           

        }
        }
        if($valid && !empty($modelQuotationPriceList )){

            foreach($modelQuotationPriceList as $eachItem){
                $eachItem->created_by = Yii::app()->user->id;
                $eachItem->created_date_time = date('Y-m-d h:i:s');
                $eachItem->save(false);
            }
             echo CJSON::encode( array('status' => 'success' ));
        }   
        else{
           
            $error1=array();
            $error1 = json_decode(CActiveForm::validateTabular($modelQuotationPriceList, '', false), true);

             $error = CJSON::encode(array_merge_recursive($error1, $other_errors));
                if ($error != '[]')
                    echo $error;
        }
 
            
    }
    
    public function actionUpdatePriceList() {
        
        $other_errors = array();
        $valid=TRUE;
        
        
        $id                     = (int) $_POST['QuotationPriceList']['id'];
        $agent_id               = $_POST['QuotationPriceList']['agent_id']; 
        
        $modelQuotationPriceList = new QuotationPriceList(); 
        $modelQuotationPriceList->attributes                = $_POST['QuotationPriceList'];
        
        if($id > 0){
            $modelQuotationPriceList = $modelQuotationPriceList->findByPk($id);
        }
        
        if($agent_id > 0){ 
            $modelVendor                                    = Vendor::model()->findByPk($agent_id);
            $modelQuotationPriceList->agent                 =   $modelVendor->vendor_name;
        }
        $modelQuotationPriceList->agent_id                  = $agent_id;
        $modelQuotationPriceList->country_id                = $_POST['QuotationPriceList']['country_id'];
        $modelQuotationPriceList->destination_country_id    = $_POST['QuotationPriceList']['destination_country_id'];
        $modelQuotationPriceList->weight                    = $_POST['QuotationPriceList']['weight'];
        $modelQuotationPriceList->price                     = $_POST['QuotationPriceList']['price'];
        $modelQuotationPriceList->transport_type            = $_POST['QuotationPriceList']['transport_type'];
        $modelQuotationPriceList->price_type                = $_POST['QuotationPriceList']['price_type'];
        $modelQuotationPriceList->comment                   = $_POST['QuotationPriceList']['comment'];
        
        $valid = $modelQuotationPriceList->validate();
        
        if(!empty($id) && !empty($agent_id) && 
        !empty($_POST['QuotationPriceList']['price_type']) && 
        !empty($_POST['QuotationPriceList']['transport_type']) && 
        !empty($_POST['QuotationPriceList']['destination_country_id']) && 
        !empty($_POST['QuotationPriceList']['country_id']) && 
        !empty($_POST['QuotationPriceList']['weight']) && 
        !empty($_POST['QuotationPriceList']['price'])
        ){
         /*$SQL= "SELECT id FROM erp_quotation_price_list WHERE 
                    agent_id = $agent_id AND 
                    price_type='".$_POST['QuotationPriceList']['price_type']."' AND 
                    transport_type='".$_POST['QuotationPriceList']['transport_type']."' AND  
                    weight = '".$_POST['QuotationPriceList']['weight']."'  AND  
                    price = '".$_POST['QuotationPriceList']['price']."'  AND 
                    destination_country_id=".$_POST['QuotationPriceList']['destination_country_id']." AND 
                    country_id =".$_POST['QuotationPriceList']['country_id'].' AND id<>'.$id;*/
            $SQL= "SELECT id FROM erp_quotation_price_list WHERE 
                    agent_id = $agent_id AND 
                    price_type='".$_POST['QuotationPriceList']['price_type']."' AND 
                    transport_type='".$_POST['QuotationPriceList']['transport_type']."' AND 
                    weight = '".$_POST['QuotationPriceList']['weight']."'  AND  
                    destination_country_id=".$_POST['QuotationPriceList']['destination_country_id']." AND 
                    country_id =".$_POST['QuotationPriceList']['country_id'].' AND id<>'.$id;        
                
            $quotation_price_id = (int) Yii::app()->db->createCommand($SQL)->queryScalar();
            
            if($quotation_price_id > 0){
                $other_errors[]='Price already added for ['.$modelVendor->vendor_name.']';
                $valid=false;
            }
        }

    
        if($valid){
               
                $modelQuotationPriceList->updated_by = Yii::app()->user->id;
                $modelQuotationPriceList->updated_date_time = date('Y-m-d h:i:s');
                $modelQuotationPriceList->save(false);
                echo CJSON::encode( array('status' => 'success' ));
        }   
        else{
            $error1 = json_decode(CActiveForm::validate($modelQuotationPriceList, '', false),true);
            $error = CJSON::encode(array_merge_recursive($error1, $other_errors));
                if ($error != '[]')
                    echo $error;
        }
 
            
    }


     
     public function actionUplodQuotationPriceList() {
        
        $other_errors = array();
        $valid=TRUE;
        $agent_id= $_POST['QuotationPriceList']['agent_id'];
        $country_id= $_POST['QuotationPriceList']['country_id'];
        $destination_country_id= $_POST['QuotationPriceList']['destination_country_id'];
        //$destination_country_array = implode(',', $destination_country_id);//for multiple
        
        
        if($_POST['QuotationPriceList']['transport_type']=='E'){
            $arr_export_import_countries = $destination_country_id;//implode(",",$destination_country_id);
        }
        else{
            $arr_export_import_countries = $country_id;//implode(",",$country_id); 
        }
        
        if(empty($agent_id)){
            $other_errors[]='Please select Agent';
            $valid=false;
        }
        
        if(empty($country_id)){
            $other_errors[]='Please select Origin';
            $valid=false;
        }
        
        if(empty($destination_country_id)){
            $other_errors[]='Please select Destination';
            $valid=false;
        }
        
        if(empty($_POST['QuotationPriceList']['transport_type'])){
            $other_errors[]='Please select Type';
            $valid=false;
        }
        
        if(empty($_POST['QuotationPriceList']['price_type'])){
            $other_errors[]='Please select Price Type';
            $valid=false;
        }
        
        
        
        if($valid){
        
            $price_list_file = $_POST['UploadQuotationPriceList']['upload_file'];
           
            
            //echo '<pre>';
            //print_r($arr_export_import_countries);
            $arr_file_data          = $this->readCSV("upload/quotationpricelist_csv/$price_list_file", "r");
            
            $p=0;
            
            foreach (array_slice($arr_file_data, 1) as $i => $eachItem) {
                                
            $weight           = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[0]), '"'));
            $rate            = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[1]), '"'));
            
            if(!empty($weight) && !empty($rate)){
                
                    if($weight < 0){
                        $other_errors[]='Weight Should be greater than zero';
                        $valid=false;
                        break;
                    }
                    if($rate<0){
                         $other_errors[]='Rate Should be greater than zero';
                         $valid=false;
                         break;
                    }
                
                    foreach($arr_export_import_countries as $each_country_id){
                        //echo $weight;
                       
                        //echo $each_country_id;exit;
                        
                        $modelVendor                                    =   Vendor::model()->findByPk($agent_id);
                        
                        $modelQuotationPriceList[$p]                    =   new QuotationPriceList(); 
                        $modelQuotationPriceList[$p]->attributes        =   $_POST['QuotationPriceList'];
                        $modelQuotationPriceList[$p]->agent_id          =   $agent_id;
                        $modelQuotationPriceList[$p]->agent             =   $modelVendor->vendor_name;
                        $modelQuotationPriceList[$p]->transport_type    =   $_POST['QuotationPriceList']['transport_type'];
                        $modelQuotationPriceList[$p]->price_type        =   $_POST['QuotationPriceList']['price_type'];
                        $modelQuotationPriceList[$p]->weight            =   round($weight, 2);;
                        $modelQuotationPriceList[$p]->price             =   round($rate,2);
                        
                        
                        if($_POST['QuotationPriceList']['transport_type']=='E'){
                             $modelQuotationPriceList[$p]->country_id = $country_id;
                             $modelQuotationPriceList[$p]->destination_country_id = $each_country_id;
                        }
                        else{
                            $modelQuotationPriceList[$p]->country_id = $each_country_id;
                            $modelQuotationPriceList[$p]->destination_country_id = $destination_country_id;
                        }
                        
                        
                        $valid = $modelQuotationPriceList[$p]->validate() && $valid;
                       
                        $p++;
                        
                        
                    }
                }
            }
        }
        
        
       // echo '<pre>';
      //  print_r($modelQuotationPriceList);
        
        
        
        
        //if(!empty($modelQuotationPriceList)){
        if($valid && !empty($modelQuotationPriceList)){
            
            foreach($modelQuotationPriceList as $eachItem){
                
                /*$SQL= "SELECT id FROM erp_quotation_price_list WHERE 
                agent_id = $agent_id AND 
                price_type='".$_POST['QuotationPriceList']['price_type']."' AND 
                transport_type='".$_POST['QuotationPriceList']['transport_type']."' AND 
                weight = '".$eachItem->weight."'  AND  
                price = '".$eachItem->price."'  AND 
                destination_country_id=".$eachItem->destination_country_id." AND 
                country_id =".$eachItem->country_id;*/
                
                $SQL= "SELECT id FROM erp_quotation_price_list WHERE 
                agent_id = $agent_id AND 
                price_type='".$_POST['QuotationPriceList']['price_type']."' AND 
                transport_type='".$_POST['QuotationPriceList']['transport_type']."' AND 
                weight = '".$eachItem->weight."' AND 
                destination_country_id=".$eachItem->destination_country_id." AND 
                country_id =".$eachItem->country_id;
                
                $quotation_price_id = (int) Yii::app()->db->createCommand($SQL)->queryScalar();
          
                if ($quotation_price_id > 0) {
                    $modelQuotationPriceListEdit    =   new QuotationPriceList(); 
                    $modelQuotationPriceListEdit = $modelQuotationPriceListEdit->findByPk($quotation_price_id);
                    
                    $modelQuotationPriceListEdit->agent_id = $agent_id;
                    $modelQuotationPriceListEdit->price_type = $_POST['QuotationPriceList']['price_type'];
                    $modelQuotationPriceListEdit->transport_type = $_POST['QuotationPriceList']['transport_type'];
                    $modelQuotationPriceListEdit->weight = $eachItem->weight;
                    $modelQuotationPriceListEdit->price = $eachItem->price;
                    $modelQuotationPriceListEdit->destination_country_id = $eachItem->destination_country_id;
                    $modelQuotationPriceListEdit->country_id = $eachItem->country_id;
                    $modelQuotationPriceListEdit->updated_by = Yii::app()->user->id;
                    $modelQuotationPriceListEdit->updated_date_time = date('Y-m-d h:i:s');
                    $modelQuotationPriceListEdit->save(false);
                }
                else{
                    $eachItem->created_by = Yii::app()->user->id;
                    $eachItem->created_date_time = date('Y-m-d h:i:s');
                    $eachItem->save(false);
                }
            }
            
             echo CJSON::encode( array('status' => 'success' ));
            
            
        }   
        else{
            $error1=array();
            if(!empty($modelQuotationPriceList)){
                $error1 = json_decode(CActiveForm::validateTabular($modelQuotationPriceList, '', false), true);
            }
             $error = CJSON::encode(array_merge_recursive($error1, $other_errors));
                if ($error != '[]')
                    echo $error;
        }
     }

  
    
    
     public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new QuotationPriceList();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }


    
    public function actionDownloadQuotationPriceList()
    {
        //$filename = 'MasAuditScopeUpload.csv';
        $file = fopen("upload/quotationpricelist_csv/quotationpricelist.csv", "w");
        $model = QuotationPriceList::model()->findAll(array('condition'=>'isActive="Y"'));
         $j = 0;
        $list[$j++] = 'id ! agent_id ! agent ! country_id ! destination_country_id! weight! price_2024 ! price ! price_type ! comment ! isActive';
        foreach ($model as $i => $row) {
            
          $list[$j++] = $row->id. '!'.$row->agent_id . '!'. $row->agent .'!' . $row->country_id . '!'. $row->destination_country_id .'!' . $row->weight . '!'. $row->price_2024 .'!' . $row->price . '!'. $row->price_type .'!' . $row->comment . '!'. $row->isActive;
        }
        $j++;
        foreach ($list as $line) {
            fputcsv($file, explode('!', $line));
        }
        fclose($file);
        $filename = 'upload/quotationpricelist_csv/quotationpricelist.csv'; //Yii::app()->getBaseUrl(true) .
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"quotationpricelist.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }
    
    public function actionuploadIndex()
    {
        $model = new QuotationPriceList();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('upload_index', array('model' => $model), false, false);
    }


    public function actionDownloadQuotationpricelistFormat() {
    	$data = array();    
    	$data[0][0]     = 'Weight';
    	$data[0][1]     = 'Rate';
    	$this->array_to_csv_download($data,"quotation_price_list.csv");
    
    }
    
    public function actionUploadQuotationpricelist($folder = null)
    {
        Yii::import("ext.EAjaxUpload.qqFileUploader");
        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
        // Check if directory exists or create it
        if (!is_dir($folder)) {
            mkdir($folder, 0777, true);
        }

        // Define allowed extensions and size limit
        $allowedExtensions = array();
        $sizeLimit = 2 * 1024 * 1024; // 2MB

        // Handle file upload
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        // Return JSON response
        echo htmlspecialchars(json_encode($result), ENT_NOQUOTES);
    }


    public function readCSV($csvFile) {
        $file_handle = fopen($csvFile, 'r');
        if (!$file_handle) {
            throw new Exception("Failed to open file: $csvFile");
        }

        $line_of_text = [];
        while (!feof($file_handle)) {
            $contents = fgetcsv($file_handle, 1024, ',');
            if ($contents[1] == "")
                $contents = explode(';', $contents[0]);
            $line_of_text[] = $contents;
        }

        fclose($file_handle);
        return $line_of_text;
    }

    
    public function actionSaveUploadQuotationpricelist() {

        $model= new QuotationPriceList();
        if(isset($_POST['UploadQuotationPriceList'])){
                    $file_name   = $_POST['UploadQuotationPriceList']['upload_file'];
                    $from_file = $this->readCSV("upload/quotationpricelist_csv/".$file_name);
                    $jsonData = array();
                    foreach (array_slice($from_file, 1) as $i => $eachItem) {
                        $agent_id      = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[0]), '"'));
                        $agent            = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[1]), '"'));
                        $country_id              = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[2]), '"'));
                        $destination_country_id              = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[3]), '"'));
                        $weight            = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[4]), '"'));
                        $price              = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[5]), '"'));
                        $price_type              = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[6]), '"'));
                        $transport_type            = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[7]), '"'));
                        $comment              = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[8]), '"'));
                        /**********   find Generic ******************************/
                        if (strlen($country_id) > 0 && strlen($destination_country_id) > 0 && strlen($agent_id) > 0 && strlen($price) > 0 && strlen($weight) > 0 && strlen($transport_type) > 0) {
					    $quotation_price_count = Yii::app()->db->createCommand("SELECT COUNT(*) FROM erp_quotation_price_list WHERE agent_id = $agent_id AND weight = ".$weight."  AND destination_country_id=".$destination_country_id." AND country_id =".$country_id)->queryScalar();
                            if ($quotation_price_count == 0) {
                                $modelQuotationPriceList= new QuotationPriceList();
                                $modelQuotationPriceList->agent_id= $agent_id;
                                $modelQuotationPriceList->agent= $agent;   
                                $modelQuotationPriceList->country_id  = $country_id;           
                                $modelQuotationPriceList->destination_country_id = $destination_country_id;         
                                $modelQuotationPriceList->weight = $weight;          
                                $modelQuotationPriceList->price= $price;         
                                $modelQuotationPriceList->price_type= $price_type;                      
                                $modelQuotationPriceList->transport_type= $transport_type; 
                                $modelQuotationPriceList->comment  = $comment;                                   
                                $modelQuotationPriceList->isActive  = 'Y';              
                                $modelQuotationPriceList->created_by = Yii::app()->user->id;             
                                $modelQuotationPriceList->created_date_time = date('Y-m-d h:i:s');  
                                $modelQuotationPriceList->save(false);
                                $arr_quotationpricelist_updated_agent[] = $modelQuotationPriceList->id;
                            }else{ 
                                $arr_quotationpricelist_not_updated_agent[]=$i." ".$agent;
                            }
                       }
                       else{
                        $arr_quotationpricelist_not_updated_agent[]=$i." ".$agent;
                       }
            }
             
                  
                    $jsonData['errors']=array();
                	
                	$jsonData['msg']=array();
                	if (!empty($arr_quotationpricelist_updated_agent) && is_array($arr_quotationpricelist_updated_agent)) {
                
                		$jsonData['msg']=ltrim("The following QuotationPriceList(s) ".implode(",", $arr_quotationpricelist_updated_agent)." are added!");
                	}
                   	if (!empty($arr_quotationpricelist_not_updated_agent) ) {
                  	   $jsonData['errors'] = "Price already added for the following ". implode(",", $arr_quotationpricelist_not_updated_agent) . " agent(s)!";
                	//$jsonData['errors']=ltrim("Please add country_id,destination_country_id for the following agent(s) ".implode(",", $arr_quotationpricelist_not_updated_agent)." are not added!");
                  	}
                	$jsonData['model'] = $modelQuotationPriceList;
                	$jsonData['status'] = "success";
                
                	echo CJSON::encode($jsonData);
             
        }
        else{
            $jsonData['status'] = "fail";
             echo CJSON::encode($jsonData);
        }      
            
    }

    public function actionGetOriginCountrylist() {
        $id = (int) $_POST['id'];
        $transport_type = $_POST['transport_type'];
        $country_id=143;//uae
        if($transport_type=="E"){
              $model_Org_Country = MasCountry::getCountryNameByOrigin($country_id);
              $model_Dest_Country= MasCountry::getCountryNameByDestination($country_id);
        }
        else{
             $model_Org_Country = MasCountry::getCountryNameByDestination($country_id);
             $model_Dest_Country= MasCountry::getCountryNameByOrigin($country_id);
        }
        $model = new QuotationPriceList();
        
        $drop = '<div class="material"> ';
        $drop1 = '<div class="material"> ';
        if($transport_type=="E"){
          $drop .= CHtml::activedropDownList($model, 'country_id', $model_Org_Country,  array('class' => 'tooltipster','data-label' => 'Origin <span style="color:red;"> *</span>', 'data-search' => 'true'));
          
          if($id > 0){
                $drop1 .= CHtml::activedropDownList($model, 'destination_country_id', $model_Dest_Country,  array('class' => 'tooltipster', 'data-label' => 'Destination <span style="color:red;"> *</span>', 'data-search' => 'true'));
          }
          else{
                $drop1 .= CHtml::activedropDownList($model, 'destination_country_id', $model_Dest_Country,  array('class' => 'tooltipster', 'data-label' => 'Destination <span style="color:red;"> *</span>', 'data-search' => 'true','multiple'=>true));
          }
        }else{
        if($id > 0){
                $drop .= CHtml::activedropDownList($model, 'country_id', $model_Org_Country,  array('class' => 'tooltipster','data-label' => 'Origin <span style="color:red;"> *</span>', 'data-search' => 'true'));
          }
          else{
                $drop .= CHtml::activedropDownList($model, 'country_id', $model_Org_Country,  array('class' => 'tooltipster','data-label' => 'Origin <span style="color:red;"> *</span>', 'data-search' => 'true','multiple'=>true));
          }    
          
          $drop1 .= CHtml::activedropDownList($model, 'destination_country_id', $model_Dest_Country,  array('class' => 'tooltipster', 'data-label' => 'Destination <span style="color:red;"> *</span>', 'data-search' => 'true'));
        }
        $drop .= '</div>';
        $drop1 .= '</div>';
        
        echo CJSON::encode(['origin' => $drop,'destination' => $drop1]);
        
    }

    
}
