<?php

class ProbabilityController extends Controller
{
//	public function actionIndex()
//	{
//		$this->render('index');
//	}

        public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                  'actions' => array('login', 'error', 'logout'),
                  'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                  'actions' => array('Index','Create','GetProbabilityList','SaveProbability','DeleteProbability','DirectAdd','Disable'),
                  'expression' => '$user->isMember()',
                  ),
                array('deny', // deny all users
                  'users' => array('*'),
                  ),
                );
        }
	public function actionIndex()
	{
                
		$this->render('index');
	}

	// Uncomment the following methods and override them if needed
	
	public function filters()
        {
            return array(
                'accessControl', // perform access control for CRUD operations
                );
        }
        public function actionGetProbabilityList()
        {
                $model=new MasProbability();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'id',
                   1 =>'probability',
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition =" (probability LIKE '%".$searchString."%' )";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                foreach ($model as $row)
                {
                    $div = '';
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["sales_master_probabilities_edit"])){
                       // $div .=   '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'probability/create&id='.$row['id'].'\',\'Edit Probability\',\'lg\')"><i class="fa fa-pencil"></i></button>';
                    }
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["sales_master_probabilities_delete"])){
                      //  $div .=  ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteProbability('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
                    }
                    $rowData[]=array($m,
                        $row['probability'].'% Probability',
                        '<div class="btn-wrap text-center">'.$div.'</div>',
                    array('id' => $row['id'],'code'=>'Edit Probability', 'status' => $row->isActive));

                    
                    $m++;
                }
//                foreach ($model as $row)
//                {
//                    $rowData[]=array($m,$row['probability'].'% Probability',
//              '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'probability/create&id='.$row['id'].'\',\'Edit Probability\',\'lg\')"><i class="fa fa-pencil"></i></button> '
//             .'<a href ="#" class="btn btn-danger btn-xs" onclick="deleteProbability('.$row['id'].')"><i class="fa fa-trash-o "></i></a></div>');
//                    $m++;
//                }
                $data['data'] = $rowData;
                echo json_encode($data);
        }
         public function actionCreate()
        {
            $model=new MasProbability();
             $id = (int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
            }
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('create', array('model' => $model), false, true);
        }
  
  
        public function actionSaveProbability()
        {
            $model = new MasProbability();
            if (isset($_POST['MasProbability']))
            {
                $model->created_by = Yii::app()->user->id;
                $model->created_datetime =date('Y-m-d h:i:s');
    		
    		if ((int) @$_POST['MasProbability']['id'] > 0)
                {   $model->updated_by = Yii::app()->user->id;
                    $model->updated_datetime =date('Y-m-d h:i:s');
                    $id= (int) @$_POST['MasProbability']['id'];
                    $model=$model->findByPk($id);  
                    $audit_type = 'UPDATED';     
                }else{
                  $audit_type = 'CREATED';
                }
                $model->attributes=$_POST['MasProbability'];
                if($model->save())
                {
                        // inserting to audit log
                        AuditLog::saveAuditLogs(
                          'PROBABILITIES',
                          Yii::app()->user->id,
                          $audit_type,
                          " with probability : - {$model->probability} %  "
                      );
                      // end audit log
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['probability_form'];
                        $jsonData['id'] = $model->id;
	                echo CJSON::encode($jsonData);
                      //  $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('index'));
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }

            }
        }
        public function actionDeleteProbability()
    {
		$id = $_POST['id'];
                $model=new MasProbability();
                $del = $model->findByPk($id);
                $model->deleteByPk($id);
                // inserting to audit log
                AuditLog::saveAuditLogs(
                  'PROBABILITIES',
                  Yii::app()->user->id,
                  'DELETED',
                  " with probability : - {$del->probability} %  "
              );
              // end audit log
                echo "success";
    }
    public function actionDirectAdd(){
           $from = $_POST['from'];
           $name = $_POST['name'];
           if($name != ''){
               $modelProbability = new MasProbability;
               $modelProbability->created_by = Yii::app()->user->id;
               $modelProbability->created_datetime =date('Y-m-d h:i:s');   
               $modelProbability->probability = $name;
               $modelProbability->save(false);
           }
           $data  =  MasProbability::getProbability();
           if($from == 'quote'){
               $model = new Quotes;
               $field_name = 'probability';
           }
           $model->$field_name = $modelProbability->id;
           $drop=CHtml::activedropDownList($model,$field_name, $data,  array('class' => 'tooltipster','data-label'=>'Probability'));  
           $status=array("status" =>"success","drop" => $drop);    
           echo CJSON::encode($status);
            
         }
        
        
	// Uncomment the following methods and override them if needed
	/*
	public function filters()
	{
		// return the filter configuration for this controller, e.g.:
		return array(
			'inlineFilterName',
			array(
				'class'=>'path.to.FilterClass',
				'propertyName'=>'propertyValue',
			),
		);
	}

	public function actions()
	{
		// return external action classes, e.g.:
		return array(
			'action1'=>'path.to.ActionClass',
			'action2'=>array(
				'class'=>'path.to.AnotherActionClass',
				'propertyName'=>'propertyValue',
			),
		);
	}
	*/
                     public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasProbability();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }

}