<?php

class MasdocumentController extends Controller {

//	public function actionIndex()
//	{
//		$this->render('index');
//	}

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'deleteDocument', 'SaveDocument', 'GetList', 'DirectAdd' , 'Disable'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
    }

    public function actionGetList() {

        $model = new MasDocument();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'document_name',
            1 => 'renewal_remainder',
            2 => 'master_type',
            3 => 'document_type',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "  (document_name LIKE '%" . $searchString . "%' OR renewal_remainder LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            if ($row['id'] != '1') {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_doc_type_edit']) || Yii::app()->user->authorised_user == 1) {
                    $button_string = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'masdocument/create&id=' . $row['id'] . '\',\'Edit Document  \',\'md\')"><i class="fa fa-edit"></i></button>';
                }
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_doc_type_delete']) || Yii::app()->user->authorised_user == 1) {
                    $button_string .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteDocument(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a>';
                }
            }
            $master_type = "";
            $type = "";
            if ($row['document_type'] == '1') {
                $type = "With Date";
            } else if ($row['document_type'] == '2') {
                $type = "Without Date";
            }
            if ($row['master_type'] == '1') {
                $master_type = "Employee Document";
            } else if ($row['master_type'] == '2') {
                $master_type = "Company Document";
            }

            $rowData[] = array($m, $row['document_name'], $row['renewal_remainder'], $master_type, $type, array('id' => $row['id'], 'status' => $row->isActive));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new MasDocument();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }


        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('document_form', array('model' => $model), false, true);
    }

    public function actionSaveDocument() {
        $model = new MasDocument();
        if (isset($_POST['MasDocument'])) {
            $model->isActive = "Y";

            if ((int) @$_POST['MasDocument']['id'] > 0) {
                $id = (int) @$_POST['MasDocument']['id'];
                $model = $model->findByPk($id);
                $audit_type = 'UPDATED';
            } else {
                $audit_type = 'CREATED';
            }
            $model->attributes = $_POST['MasDocument'];
            if ($model->save()) {
                // inserting to audit log
                AuditLog::saveAuditLogs(
                        'DOCUMENT', Yii::app()->user->id, $audit_type, " with name: - {$model->document_name}  "
                );
                // end audit log 

                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['bank_form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
                // $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('index'));
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actiondeleteDocument() {

        $id = $_POST['id'];
        if ($id > 0) {

            $model = new MasDocument();
            $del = $model->findByPk($id);
            $model->deleteByPk($id);
            // inserting to audit log
            AuditLog::saveAuditLogs(
                    'DOCUMENT', Yii::app()->user->id, 'DELETED', " with name: - {$del->document_name}  "
            );
            // end audit log 
            echo "success";
        } else {
            echo "fail";
        }
    }
        public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasDocument();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }

    /* public function actionDirectAdd(){
      $from = $_POST['from'];
      $name = $_POST['name'];
      $status =  array();
      $drop = '';
      if($name != ''){
      $modelBank = new MasBank;
      $modelBank->bank_name = $name;
      if($modelBank->save()){
      $status['status']= "success";
      $data  = MasBank::getBanks();
      if($from == 'vendor'){
      $model = new Vendor;
      $field_name = 'vendor_bank_name';
      }
      $model->$field_name = $modelBank->id;
      $drop=CHtml::activedropDownList($model,$field_name, $data,  array('class' => 'tooltipster','data-label'=>'Bank'));
      $status['drop']= $drop;
      echo CJSON::encode($status);
      }else{
      $error = CActiveForm::validate($modelBank, '', false);
      if ($error != '[]')
      echo $error;
      }
      }
      } */
}
