<?php

class MasclienttypeController extends Controller {

    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','GetList', 'Create','Save','Block','UnBlock'),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }
    /*
     * ajax function to list all brand datatable
     * modified by jisha on 19-6-20. 
     */

      public function actionGetList() {
        $model  = new MasClientType();
        $draw   = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $brand = $_POST['brand'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.type_name',
            2 => 't.id',
        );
        $filterColumn   = $columns[$_POST['order'][0]['column']];
        $filterOrder    = $_POST['order'][0]['dir'];
        $orderBy        = $filterColumn . " " . $filterOrder;
        $condition      = '1=1';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" AND (t.type_name LIKE '%" . $searchString . "%' )";
        }
        $count          = $model->count(array('condition' => $condition));
        $model          = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal   = $count;
        $recordsFiltered        = $count;
        $data['draw']   = $draw;
        $data['recordsTotal']   = $recordsTotal;
        $data['recordsFiltered']= $recordsFiltered;
        $rowData                = array();
        $m=1;
        foreach ($model as $row)
        {
            if ((isset(Yii::app()->user->havePermissionOn['client_type_edit']) || Yii::app()->user->authorised_user == 1) )
           {
           $div= '<button class="btn btn-primary btn-xs" title ="Edit" onclick="loadPopupModal(\'masclienttype/create&id='.$row['id'].'\',\'Edit - '.$row['type_name'].'\',\'lg\')"><i class="fa fa-edit" aria-hidden="true"></i></button>';
           }
           if(isset(Yii::app()->user->havePermissionOn['client_type_block']) ||  Yii::app()->user->authorised_user == 1)
           {
               if ($row->isActive == "Y") 
               {
               $div .= ' <a href ="javascript:void(0);" class="btn btn-success btn-xs" onclick="disable(' . $row['id'] . ')"><i class="fa fa-toggle-on"></i></a>';
               }
               if ($row->isActive == 'N') 
               {
                   $div .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="enable(' . $row['id'] . ')"><i class="fa fa-ban"></i></a>';
               }
           }
            $rowData[]  = array($m,$row['type_name'],$div,$row['isActive']);
            $m++;
        } 
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    /*
     * function to create brand details
     * modified by jisha on 19-6-20. 
     */
    public function actionCreate() {
       $id = (int) Yii::app()->request->getParam('id');
        $model = new MasClientType;
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('create', array('model' => $model));
    }
    public function actionSave() {
        $model          = new MasClientType();
        if (isset($_POST['MasClientType'])) {

            if ($_POST['MasClientType']['id'] > 0) {
                $id =  $_POST['MasClientType']['id'];
                $model = $model->findByPK($id);
                $scene = 'update';
                $change_type = 'UPDATED';
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
                $scene = 'new';
                $change_type = 'CREATED';                
            }
            $model->updated_by = Yii::app()->user->id;
            $model->updated_date_time =date('Y-m-d H:i:s');
            $model->attributes = $_POST['MasClientType'];
            $model->type_name = trim($_POST['MasClientType']['type_name']);
            $valid=$model->validate();
        }
        if($valid){
            $model->save();
             
            // inserting to audit log
                // AuditLog::saveAuditLogs(
                //     $modelformmaster->id,
                //     Yii::app()->user->id,
                //     $change_type,
                //     " with ID - {$model->id} "
                // );
                // end audit log
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }else {
            $error1 = json_decode(CActiveForm::validate($model, '', false), true);
            $error = CJSON::encode(array_merge_recursive($error1));
            if ($error != '[]'){
                echo $error;    
            }
        }
    }
    public function actionBlock() {
        $id = $_POST['id'];
        if ($id > 0) {
            MasClientType::model()->updateByPK($id, array('isActive' => "N"));
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }
    
    public function actionUnBlock() {
        $id = $_POST['id'];
        if ($id > 0) {
            MasClientType::model()->updateByPK($id, array('isActive' => "Y"));
             
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }
}
