<?php

class FuelsubchargesController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'Save', 'Disable'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

    // Uncomment the following methods and override them if needed

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

     public function actionGetList() {
        $model = new FuelSubCharges();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'from_date',
            1 => 'to_date',
            2 => 'fuel_sur_charge',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition  = " (from_date LIKE '%" . $searchString . "%' OR to_date LIKE '%" . $searchString . "%' OR fuel_sur_charge LIKE '%" . $searchString . "%' OR vendor_name LIKE '%" . $searchString . "%')";
        }
        if ($_POST['agent']!='') {
            $condition .= " AND agent_id ='{$_POST['agent']}' ";
        }

        $from_date = (count(explode('/', $_POST['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to_date']))) : date('Y-m-t');
        $condition .= ' AND from_date <= "'.$to_date.'" AND to_date >= "'.$from_date.'"';

        // echo $co

        $count = $model->with('agent')->count(array('condition' => $condition));
        $model = $model->with('agent')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = '';
            $rowData[] = array($m,
                $row['agent']['vendor_name'],
                date("d/m/Y", strtotime($row['from_date'])),
                date("d/m/Y", strtotime($row['to_date'])),
                $row['fuel_sur_charge'],
                '<div class="btn-wrap text-center">' . $div . '</div>',
                array('id' => $row['id'],'code'=>'Edit Sur Charge', 'status' => $row->isActive));

            $m++;
        }
        //print_r($rowData);
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new FuelSubCharges();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('fuel_form', array('model' => $model), false, false);
    }

    public function actionSave() {
        $model = new FuelSubCharges();
        if(isset($_POST['FuelSubCharges'])) {
           
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date('Y-m-d h:i:s');
            if ((int) @$_POST['FuelSubCharges']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
                $id = (int) @$_POST['FuelSubCharges']['id'];
                $model = $model->findByPk($id);
            }
            $model->attributes = $_POST['FuelSubCharges'];
            $from_date = str_replace("/", "-", $_POST['FuelSubCharges']['from_date']);
            $model->from_date = date('Y-m-d', strtotime($from_date));
            $to_date = str_replace("/", "-", $_POST['FuelSubCharges']['to_date']);
            $model->to_date = date('Y-m-d', strtotime($to_date));
           
            $valid = $model->validate();
            if($valid){
                $model->save();
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['fuel_form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            }else{
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

  
    public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new FuelSubCharges();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }

}
