<?php

class BinController extends Controller
{
        public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                  'actions' => array('login', 'error', 'logout'),
                  'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                  'actions' => array('Index','Create','GetList','SaveBin','DeleteBin','DirectAdd', 'Getbins', 'Disable'),
                  'expression' => '$user->isMember()',
                  ),
                array('deny', // deny all users
                  'users' => array('*'),
                  ),
                );
        }
	public function actionIndex()
	{
		$this->render('index');
	}

	
	
	public function filters()
        {
            return array(
                'accessControl', // perform access control for CRUD operations
                );
        }
        public function actionGetList()
        {
                $model=new MasInvBin();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                0 =>'name',
                1 =>'name',
                2 =>'rack_id',
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition ="  (name LIKE '%".$searchString."%' OR rack_id LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m = 1;
                 
                foreach ($model as $row)
                {
                    $div = '';
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_inv_bin_edit"])){
                      //  $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'bin/create&id='.$row['id'].'\',\'Edit Bin\',\'lg\')"><i class="fa fa-pencil"></i></button> ';
                    }
                    $rowData[]=array($m,
                        $row['name'],
                        $row['rack']['name'],
                        '<div class="btn-wrap text-center">'.$div.'</div>',
                        $row['is_base_bin'],
                        array('id' => $row['id'],'code'=>$row['name'], 'status' => $row->isActive));    
                
                    $m++;
                    
                }
                
                $data['data'] = $rowData;
                echo json_encode($data);
        }
         public function actionCreate()
        {
            $model=new MasInvBin();
            $id = (int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
            }
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('bin_form', array('model' => $model), false, false);
        }
  
  
        public function actionSaveBin()
        {
            $model = new MasInvBin();
            if (isset($_POST['MasInvBin']))
            {
    		$model->created_by = Yii::app()->user->id;
                $model->created_datetime =date('Y-m-d h:i:s');
    		if ((int) @$_POST['MasInvBin']['id'] > 0)
                {   $model->updated_by = Yii::app()->user->id;
                    $model->updated_datetime =date('Y-m-d h:i:s');
                    $id= (int) @$_POST['MasInvBin']['id'];
                    $model=$model->findByPk($id);  
                    $audit_type = 'UPDATED';
                    $edit_flag=1;
                }else{
                    $audit_type = 'CREATED';
                }
                if($_POST['MasInvBin']['is_base_bin'] == "Y"){
                	MasInvBin::model()->updateAll(array( 'is_base_bin' => 'N' ), 'is_base_bin = "Y"' );
            	}
                $model->attributes=$_POST['MasInvBin'];
                if ($model->save())
                {    
                    // inserting to audit log
                        AuditLog::saveAuditLogs(
                            'BIN_MASTER',
                            Yii::app()->user->id,
                            $audit_type,
                            " with name: - {$model->name}  "
                        );
                        // end audit log
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['bin_form'];
                        $jsonData['id'] = $model->id;
	                echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
          
            }
        }
        public function actionDeleteBin(){
		$id = $_POST['id'];
                $model=new MasInvBin();
                $del = $model->findByPk($id); // audit log changes
                $model->deleteByPk($id);
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'BIN_MASTER',
                    Yii::app()->user->id,
                    'DELETED',
                    " with name: - {$del->name}  "
                );
                // end audit log
                echo "success";
    }
    
     public function actionDirectAdd(){
           $from = $_POST['from'];
           $name = $_POST['name'];
           $rack = $_POST['rack'];
           if($name != ''){
               $modelBin = new MasInvBin;
               $modelBin->name = $name;
               $modelBin->rack_id = $rack;
               if($modelBin->save()){
                    $data  = MasInvBin::getBins();
                    if($from == 'inventory'){
                        $model = new ProductLocation;
                        $field_name = 'bin';
                    }
                    $model->$field_name = $modelBin->id;
                    $drop=CHtml::activedropDownList($model,$field_name, $data,  array('class' => 'tooltipster','data-label'=>'Bin'));  
                    $status=array("status" =>"success","drop" => $drop);    
                    echo CJSON::encode($status);
               }else{
                    $error = CActiveForm::validate($modelBin, '', false);
                        if ($error != '[]')
		               echo $error;
               }
           }
           
            
         }
    public function actionGetbins(){
        $model = $_POST['model'];
        $field_id = $_POST['field_id'];
        $id = (int) $_POST['id'];
        echo CHtml::activedropDownList(new $model, $field_id,MasInvBin::getBins_rackwise($id), array('data-label'=>'Bin'));
    }
    public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasInvBin();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
}