<?php

class ApiloginController extends Controller {

    public $round_off = '2';

    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array(
                    'logout', 'error', 'LoginSuccess', 'login'
                ),
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function beforeAction($action) {
        $company_db_name = "bluelogistics_infinity";
        Yii::app()->db->setActive(false);
        Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=' . $company_db_name;
        Yii::app()->db->tablePrefix = 'erp_';
        Yii::app()->db->setActive(true);
        return parent::beforeAction($action);
    }

    public function actionLogin() {

        $this->layout = '';

        try {

            $username = trim($_REQUEST['username']);
            $password = trim($_REQUEST['password']);

            if (empty($username)) {
                $data['status'] = 'failed';
                $data['message'] = 'Username cannot be blank';
            } else if (empty($password)) {
                $data['status'] = 'failed';
                $data['message'] = 'Password cannot be blank';
            } else {
                $salt = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
                $password = crypt($password, $salt);
                $modelCustomer = Customer::model()->find('LOWER(username)=? AND isActive=?', array($username, 'Y'));
                if (!empty($modelCustomer)) {

                    $customer_id = $modelCustomer->id;
                    $customer_name = $modelCustomer->customer_name;

                    $modelCustomer->get_generate_token();

                    header("HTTP/1.1 200 OK");
                    header('Content-Type: application/json');
                    $data = array('status' => "success", "data" => ["user_id" => $customer_id, "customer_name" => $customer_name, "message" => "User authorized"]);
                } else {
                    header("HTTP/1.1 401 Unauthorized");
                    header('Content-Type: application/json');
                    $data['status'] = 'failed';
                    $data['message'] = 'Unauthorized user';
                }
            }
        } catch (Exception $e) {
            header("HTTP/1.1 404 not found");
//            header('Content-Type: application/json');
            print_r($e);
            $data = array('status' => "error", "message" => "Unexpected Server error");
        }

        echo json_encode($data);
    }

    /* public function actionLogin() {

      try {

      $input = file_get_contents('php://input');
      $variables = json_decode($input, true);
      $code = trim($variables['code']);
      $username = trim($variables['username']);
      $password = trim($variables['password']);
      $model = new LoginForm;
      $model->company_code = $code;
      $model->username = $username;
      $model->password = $password;
      $isLogin = $model->validate() && $model->login();
      $user_id = "";
      $name = "";
      $user = new User();
      if ($isLogin) {

      $condition = "t.username = '" . $username . "' ";
      $user = User::model()->find(array('condition' => $condition));

      // $user->_generate_token;
      $user_id = $user->id;
      $name = $user->first_name.' '.$user->last_name;
      //echo $name;exit;
      header("HTTP/1.1 200 OK");
      header('Content-Type: application/json');
      $data = array('status' => "success", "data" => ["user_id" => $user_id, "name" => $name,"message"=>"User authorized"]);
      }else{
      header("HTTP/1.1 401 Unauthorized");
      header('Content-Type: application/json');
      $data['status'] = 'failed';
      $data['message'] = 'Unauthorized user';
      }
      }
      catch(Exception $e) {
      header("HTTP/1.1 404 not found");
      header('Content-Type: application/json');
      $data = array('status' => "error", "message"=>"Unexpected Server error");
      }

      echo json_encode($data);
      } */

    public function connectMainDB($company_db_name) {
        Yii::app()->db->setActive(false);
        if (empty($company_db_name)) {
            $company_db_name = '=bluelogistics_infinity';
        }
        Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=bluelogistics_infinity';
        Yii::app()->db->username = 'bluelogistics_infinity';
        Yii::app()->db->password = 'Dd9Yb[N&ro2R';
        Yii::app()->db->tablePrefix = 'erp_';
        Yii::app()->db->setActive(true);
    }

    /*
      public function beforeAction($action) {
      $company_db_name = "bluelogistics_infinity";
      Yii::app()->db->setActive(false);
      Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=' . $company_db_name;
      Yii::app()->db->tablePrefix = 'erp_';
      Yii::app()->db->setActive(true);
      return true;
      }
     */
}
