<?php

class ApiSalesController extends Controller {

    public $round_off = '2';

    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array(
                    'logout', 'error', 'Login', 'GetCustomerStatement', 'GetEditionList', 'GetUpComingJobList', 'GetInvDataList', 'GetJobList', 'GetJobListPDF', 'GetJobPdf', 'GetCustomerStatementPDF', 'GetInvoicePDF', 'GetCountryList', 'SaveQuotation', 'GetOpenJobListByAgent'
                ),
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function beforeAction($action) {
//        error_log("ApiSales / " . $action->getId(), 3, "php_errors.log");
//        error_log(file_get_contents('php://input'), 3, "php_errors.log");
//        error_log(PHP_EOL, 3, "php_errors.log");

        $this->ChangeDB();
        if (Yii::app()->request->isAjaxRequest)
            $this->layout = false;
        return parent::beforeAction($action);
    }

    public function actionGetCustomerStatement() {

        // $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        // $userModel = User::model()->findBytoken($token);
        // if ($userModel->id > 0) {
        $input = file_get_contents('php://input');
        $variables = json_decode($input, true);

        $customer = trim($variables['customer_id']);
        $to = date('Y-m-d');
        $type = 'customer';
        if ($type == 'customer') {
            $amountType = 'VI.amount > 0';
        }
        $ledger = 11;
        if ($level == 'C') {//if customer
            $subledger = FinanceSubledger::model()->find(array('condition' => 'subledger_type_id=1 AND parent_id=' . $customer))->id;
        } else {
            $subledger = FinanceSubledger::model()->find(array('condition' => 'subledger_type_id=1'))->id;
        }


        $items = array();
        $query = 'CREATE OR REPLACE VIEW {{finance_statement}} AS SELECT
                                        V.id AS voucher_id,
                                        V.voucher_date AS voucher_date,
                                        V.due_date AS due_date,
                                        V.voucher_type AS type,
                                        V.header_table_id AS head_id,
                                        V.reference_no AS reference_no,
                                        VI.narration AS narration,
                                        VI.id AS voucher_item_id,
                                        V.voucher_no,
                                        ROUND(ABS(VI.amount*VI.exchange_rate), 4) AS amount,
                                        ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS allocated,
                                        ROUND(ABS(VI.amount*VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS balance
                                    FROM {{finance_voucher_items}} VI
                                    LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
                                    LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
                                    WHERE V.is_posted ="Y" AND ' . $amountType . ' AND VI.ledger_id = ' . $ledger . ' AND VI.subledger_id = ' . $subledger . '
                                    GROUP BY VI.id';
        if ($ledger > 0 && $subledger > 0) {
            Yii::app()->db->createCommand($query)->execute();
            $items = Yii::app()->db->createCommand('SELECT * FROM {{finance_statement}} where voucher_date<="' . $to . '" order by voucher_date DESC')->queryAll();
        }
        if (empty($items)) {
            $data = [];
        } else {
            foreach ($items as $each) {
                if ($each['balance'] > 0) {
                    $date1 = strtotime($each['due_date']);
                    $date2 = strtotime(date('Y-m-d'));
                    $days = ($date2 - $date1) / 60 / 60 / 24;
                    if ($days > 0) {
                        $date_disp = $days;
                    } else {
                        $date_disp = 0;
                    }
                    $data[] = [
                        "voucher_no" => $each['voucher_no'],
                        "voucher_date" => $each['voucher_date'],
                        "due_date" => $each['due_date'],
                        "over_due" => $date_disp,
                        "invoice_value" => $each['amount'],
                        "paid" => $each['allocated'],
                        "balance" => $each['balance'],
                    ];
                }
            }
        }
        header("HTTP/1.1 200 OK");
        header('Content-Type: application/json');
        // } else {
        //     header("HTTP/1.1 401 Unauthorized");
        //     header('Content-Type: application/json');
        //     $data = array('status' => "failed", "msg" => "Unauthorized user");
        // }
        echo json_encode($data);
    }

    public function actionGetJobList() {
        // $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        // $userModel = User::model()->findBytoken($token);
        // if ($userModel->id > 0) {
        $input = file_get_contents('php://input');
        $variables = json_decode($input, true);
        $from_date = trim($variables['fromDate']);
        $to_date = trim($variables['toDate']);
        $status = trim($variables['status']);
        $customer_id = trim($variables['customer_id']);
        $level = trim($variables['level']);
        $filter_job_from_date = str_replace('/', '-', $from_date);
        $filter_job_from_date = date("Y-m-d", strtotime($filter_job_from_date));
        $filter_job_to_date = str_replace('/', '-', $to_date);
        $filter_job_to_date = date("Y-m-d", strtotime($filter_job_to_date));

        $condition = "job_date >= '" . $filter_job_from_date . "' AND job_date   <= '" . $filter_job_to_date . "' ";
        //$condition.=" AND (job_order_status!='C' AND job_order_status!='I')";

        if ($level == 'C') {//if customer
            $condition .= " AND customer_id ='" . $customer_id . "'";
        }
        if (!empty($status)) {
            //$status="O";
            $condition .= " AND job_order_status='" . $status . "'";
        } else {
            $condition .= " AND job_order_status!='I'";
        }

        $orderBy = " ORDER BY job_order_id DESC";
        $SQL1 = "SELECT * FROM view_job_order_list WHERE $condition $orderBy ";
//        echo $SQL1;
        $items = Yii::app()->db->createCommand($SQL1)->queryAll();
        if (empty($items)) {
            $data = [];
        } else {
            foreach ($items as $i => $each) {
                if ((int) $each['origin'] > 0) {
                    $origin = MasCountry::model()->findByPk($each['origin'])->country_name;
                }
                if ((int) $each['destination'] > 0) {
                    $dest = MasCountry::model()->findByPk($each['destination'])->country_name;
                }
                $model_job = JobOrder::model()->find(array('condition' => 'id="' . $each['job_order_id'] . '"'));
                switch ($each['job_order_status']) {
                    case 'PD':
                        $row_job_order_status = "Partially Delivered";
                        break;
                    case 'D':
                        $row_job_order_status = "Delivered";
                        break;
                    case 'C':
                        $row_job_order_status = "Completed";
                        break;
                    case 'I':
                        $row_job_order_status = "Invoiced";
                        break;

                    case 'CN':
                        $row_job_order_status = "Cancel";
                        break;

                    default:
                        $row_job_order_status = "Open";
                        break;
                }
                $data[] = [
                    "id" => $each['job_order_id'] . "",
                    "book_date" => $each['job_date'],
                    "customer_name" => $each['customer_name'],
                    "consignee_id" => $each['consignee_id'] . "",
                    "agent" => $each['agent'],
                    "awb_no" => $each['awb_no'],
                    "job_order_status" => $row_job_order_status,
                    "origin" => $origin,
                    "destination" => $dest,
                    "shipper" => $each['shipper_name'],
                    "weight(kg)" => $model_job['weight'] . "",
                    "volume(cbm)" => $model_job['volume'] . "",
                    "customer_reference" => $each['customer_id'] . ""
                ];
            }
        }
        header("HTTP/1.1 200 OK");
        header('Content-Type: application/json');
        // } else {
        //     header("HTTP/1.1 401 Unauthorized");
        //     header('Content-Type: application/json');
        //     $data = array('status' => "failed", "msg" => "Unauthorized user");
        // }
        echo json_encode($data);
    }

    public function actionGetJobListPDF() {
        // $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        // $userModel = User::model()->findBytoken($token);
        // if ($userModel->id > 0) {
        $job_order_id = $_GET['jobid'];
        $pdf_name = "JobOrder_" . $job_order_id . "_" . '.pdf';
        $file_path = 'uploads/apppdf/' . $pdf_name;
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.modules.logistics.views.pdf.print_job_order_new_app', array('id' => $job_order_id), true));
        //user_id=>$userModel->id

        $mPDF1->Output($file_path, 'F');

        header('Content-Type: application/json');
        $data = array('status' => "success", "pdflink" => $file_path, "file_name" => $pdf_name);
        // } else {
        //     header("HTTP/1.1 401 Unauthorized");
        //     header('Content-Type: application/json');
        //     $data = array('status' => "failed", "msg" => "Unauthorized user");
        // }
        echo json_encode($data);
    }

    public function actionGetUpComingJobList() {
        // $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        // $userModel = User::model()->findBytoken($token);
        // if ($userModel->id > 0) {
        $input = file_get_contents('php://input');
        $variables = json_decode($input, true);
        $customer_id = trim($variables['customer_id']);
        // $date=date('Y-m-d');
        // $condition="job_date >= '". $date."' ";
        $condition = "customer_id ='" . $customer_id . "'";
        $orderBy = " ORDER BY job_order_id DESC LIMIT 1";
        $SQL1 = "SELECT * FROM view_job_order_list WHERE $condition $orderBy ";

        $items = Yii::app()->db->createCommand($SQL1)->queryAll();
        if (empty($items)) {
            $data = [];
        } else {
            foreach ($items as $i => $each) {
                if ((int) $each['origin'] > 0) {
                    $origin = MasCountry::model()->findByPk($each['origin'])->country_name;
                }
                switch ($each['job_order_status']) {
                    case 'PD':
                        $row_job_order_status = "Partially Delivered";
                        break;
                    case 'D':
                        $row_job_order_status = "Delivered";
                        break;
                    case 'C':
                        $row_job_order_status = "Completed";
                        break;
                    case 'I':
                        $row_job_order_status = "Invoiced";
                        break;
                    case 'CN':
                        $row_job_order_status = "Cancel";
                        break;
                    default:
                        $row_job_order_status = "Open";
                        break;
                }
                $data[] = [
                    "id" => $each['job_order_id'] . "",
                    "book_date" => $each['job_date'],
                    "customer_name" => $each['customer_name'],
                    "consignee_id" => $each['consignee_id'] . "",
                    "agent" => $each['agent'],
                    "awb_no" => $each['awb_no'],
                    "job_order_status" => $row_job_order_status,
                    "origin" => $origin
                ];
            }
        }
        header("HTTP/1.1 200 OK");
        header('Content-Type: application/json');
        // } else {
        //     header("HTTP/1.1 401 Unauthorized");
        //     header('Content-Type: application/json');
        //     $data = array('status' => "failed", "msg" => "Unauthorized user");
        // }
        echo json_encode($data);
    }

    public function actionGetInvDataList() {
        // $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        // $userModel = User::model()->findBytoken($token);
        // if ($userModel->id > 0) {
        $input = file_get_contents('php://input');
        $variables = json_decode($input, true);
        $customer_id = trim($variables['customer_id']);
        $inv_date = trim($variables['inv_date']);
        $model = new Invoice();
        $condition = 't.isActive="Y"';
        if ($level == 'C') {//if customer
            $condition .= ' AND t.customer_id= "' . $customer_id . '"';
        }
        $filter_inv_date = str_replace('/', '-', $inv_date);
        $filter_inv_date = date("Y-m-d", strtotime($filter_inv_date));
        if ($inv_date) {
            $condition .= " AND invoice_date = '" . $filter_inv_date . "' ";
        }
        $items = $model->with('customer', 'file')->findAll(array('condition' => $condition, 'order' => 't.id DESC'));
        if (empty($items)) {
            $data = [];
        } else {
            foreach ($items as $i => $each) {
                $data[] = [
                    "id" => $each['id'] . "",
                    "file_id" => $each['file_id'] . "",
                    "order_id" => $each['order_id'] . "",
                    "awb_no" => $each['awb_no'] . "",
                    "customer" => $each['customer']['customer_name'],
                    "lead" => $each->leadowner->fullname,
                    "currency" => $each['currencyname']['currency_code'],
                    "total_tax_amount" => $each['total_tax_amount'],
                    "grand_total" => $each['grand_total'],
                    "invoice_date" => date("d/m/Y", strtotime($each['invoice_date']))
                ];
            }
        }
        header("HTTP/1.1 200 OK");
        header('Content-Type: application/json');
        // } else {
        //     header("HTTP/1.1 401 Unauthorized");
        //     header('Content-Type: application/json');
        //     $data = array('status' => "failed", "msg" => "Unauthorized user");
        // }
        echo json_encode($data);
    }

    public function actionGetInvoicePDF() {
        // $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        // $userModel = User::model()->findBytoken($token);
        // if ($userModel->id > 0) {
        $invoice_id = (int) trim($_GET['invoice_id']);
        $company_id = (int) trim($_GET['company_id']);

        $modelInvoice = new Invoice();
        $modelInvoice = $modelInvoice->findByPk($invoice_id);

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        if ($modelInvoice->invoice_status == 'C') {
            $mPDF1->SetWatermarkText('CANCELLED');
            $mPDF1->showWatermarkText = true;
        }
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.modules.logistics.views.pdf.invoice_list_individual_tax', array('model' => $modelInvoice, 'id' => $invoice_id, 'c_id' => $c_id, 'title' => $title, 'barcode' => $barcode, 'from' => $frm, 'company_id' => $company_id), true));

        $pdf_file_name = $invoice_id . ".pdf";
        if ((int) $modelInvoice->customer_id > 0) {
            $modelCustomer = Customer::model()->findByPk((int) $modelInvoice->customer_id);
            $pdf_file_name = $invoice_id . "_" . $modelCustomer->customer_name . ".pdf";
        }


        $file_path = 'uploads/apppdf/' . $pdf_file_name;
        $mPDF1->Output($file_path, 'F');
        header('Content-Type: application/json');
        $data = array('status' => "success", "pdflink" => $file_path, "file_name" => $pdf_file_name);
        // } else {
        //     header("HTTP/1.1 401 Unauthorized");
        //     header('Content-Type: application/json');
        //     $data = array('status' => "failed", "msg" => "Unauthorized user");
        // }
        echo json_encode($data);
    }

    public function actionGetCountryList() {

        $customer_id = trim($_REQUEST['customer_id']);
        if ($customer_id > 0) {

            $modelMasCountry = new MasCountry();
            $condition = 't.isActive="Y"';
            $arr_country_list = $modelMasCountry->findAll(array('condition' => $condition, 'order' => 'country_name ASC'));
            if (empty($arr_country_list)) {
                $data = [];
            } else {
                foreach ($arr_country_list as $i => $eachItem) {
                    $data[] = [
                        "id" => $eachItem->id,
                        "country_name" => $eachItem->country_name,
                    ];
                }
            }
            header("HTTP/1.1 200 OK");
            header('Content-Type: application/json');
            //$data = array('status' => "success", "msg" => "success");
        } else {

            header("HTTP/1.1 401 Unauthorized");

            header('Content-Type: application/json');

            $data = array('status' => "failed", "msg" => "Unauthorized user");
        }
        echo json_encode($data);
    }

    public function actionSaveQuotation() {
        // $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        // $userModel = User::model()->findBytoken($token);
        // if ($userModel->id > 0) {

        $customer_id = (int) trim($_REQUEST['customer_id']);
        $origin_id = (int) trim($_REQUEST['origin_id']);
        $destination_id = (int) trim($_REQUEST['destination_id']);
        $contents = trim($_REQUEST['contents']);
        $weight = trim($_REQUEST['weight']);
        $volume = trim($_REQUEST['volume']);

        if ($customer_id > 0) {
            //save data into master file
            $modelMasterFile = new MasterFile();
            $modelMasterFile->customer_id = $customer_id;
            $modelMasterFile->current_process_status = "Q";
            $modelMasterFile->crm_user_id = 0;
            $modelMasterFile->created_by = $customer_id;
            $modelMasterFile->created_datetime = date('Y-m-d h:i:s');
            $modelMasterFile->file_title = "";
            $modelMasterFile->lead_owner_id = 0;
            $modelMasterFile->save(false);
            //end
            //save data into quotation
            $modelQuotation = new Quotation();
            $modelQuotation->file_id = (int) $modelMasterFile->id;
            $modelQuotation->customer_id = $customer_id;
            $modelQuotation->contact_ids = '';
            $modelQuotation->quotation_date = date('Y-m-d');
            $modelQuotation->origin_id = $origin_id;
            $modelQuotation->destination_id = $destination_id;
            $modelQuotation->shipper_id = '';
            $modelQuotation->consignee_id = '';
            $modelQuotation->weight = $weight;
            $modelQuotation->volume = $volume;
            $modelQuotation->currency_id = 1;
            $modelQuotation->exchange_rate = 1;
            $modelQuotation->booking_reference = 0;
            $modelQuotation->customer_reference_no = 0;
            $modelQuotation->selling_price = 0;
            $modelQuotation->remarks = $contents;
            $modelQuotation->terms_and_conditions = '';
            $modelQuotation->lead_owner_id = 0;
            $modelQuotation->transport_type = 5;
            $modelQuotation->payment_terms_id = 0;
            $modelQuotation->quotation_status = '';
            $modelQuotation->qtn_close_reason = '';
            $modelQuotation->total_planned_weight = 0;
            $modelQuotation->total_planned_volume = 0;
            $modelQuotation->total_planned_cost = 0;
            $modelQuotation->isActive = 'Y';
            $modelQuotation->quotation_priority = 'N';
            $modelQuotation->chargeable_weight = 0;
            $modelQuotation->no_of_pieces = 0;
            $modelQuotation->job_order_id = 0;
            $modelQuotation->transit_time = 0;
            $modelQuotation->created_by = $customer_id;
            $modelQuotation->created_date_time = date('Y-m-d H:i:s');
            $modelQuotation->updated_by = 0;
            $modelQuotation->updated_date_time = '0000-00-00 00:00:00';
            $modelQuotation->save(false);
            //end
            header("HTTP/1.1 200 OK");
            header('Content-Type: application/json');
            $data = array('status' => "success", "msg" => "success");
        } else {

            header("HTTP/1.1 401 Unauthorized");

            header('Content-Type: application/json');

            $data = array('status' => "failed", "msg" => "Unauthorized user");
        }

        echo json_encode($data);
    }

    public function actionGetOpenJobListByAgent() {
        $input = file_get_contents('php://input');
        $variables = json_decode($input, true);

        $user_id = trim($variables['user_id']);
        $level = trim($variables['level']);
        $agent_id = trim($variables['agent_id']);
        //$agent_id       = $_GET['agent_id'];

        $condition = " job_order_status='O'";
        if ($level == 'C') {//if customer
            $condition .= " AND customer_id ='" . $user_id . "'";
        }
        $agent_name = '';

        if (!is_numeric($agent_id)) {

            $arr_agent_id = explode(",", $agent_id);

            foreach ($arr_agent_id as $i => $each_agent_id) {

                if ($i > 0) {
                    $condition1 = " AND FIND_IN_SET('" . $each_agent_id . "',agent_ids)";
                    $SQL1 .= " UNION ALL ";
                    $SQL1 .= "SELECT job_order_id,job_date,customer_name,consignee_id,agent,awb_no,job_order_status,origin,destination,shipper_name,customer_email_id,customer_id FROM view_job_order_list WHERE $condition $condition1 $orderBy ";
                } else {
                    $condition1 = " AND FIND_IN_SET('" . $each_agent_id . "',agent_ids)";
                    $SQL1 = "SELECT job_order_id,job_date,customer_name,consignee_id,agent,awb_no,job_order_status,origin,destination,shipper_name,customer_email_id,customer_id FROM view_job_order_list WHERE $condition $condition1 $orderBy ";
                }
            }

            $arr_job_order_list = Yii::app()->db->createCommand($SQL1)->queryAll();

            //echo $SQL1;
        } else {


            if ($agent_id > 0) {
                $condition .= " AND FIND_IN_SET('" . $agent_id . "',agent_ids)";

                $modelAgentDetails = new Vendor();
                $modelAgentDetails = $modelAgentDetails->findByPk((int) $agent_id);
                $agent_name = $modelAgentDetails->vendor_name;
            }

            $orderBy = " ORDER BY job_order_id DESC";
            $SQL1 = "SELECT job_order_id,job_date,customer_name,consignee_id,agent,awb_no,job_order_status,origin,destination,shipper_name,customer_email_id,customer_id FROM view_job_order_list WHERE $condition $orderBy ";
            $arr_job_order_list = Yii::app()->db->createCommand($SQL1)->queryAll();
        }
        $data = [];
        if (!empty($arr_job_order_list)) {

            foreach ($arr_job_order_list as $i => $each) {


                $lead_owner_id = (int) $modelJobOrder->lead_owner_id;
                $arr_lead_owner_details = User::model()->findByPk($lead_owner_id);
                $lead_owner_email = trim($arr_lead_owner_details->email);

                if (!empty($lead_owner_email)) {
                    $lead_owner_email = '{"email":"rumaise@gmail.com"}';
                    $arr_email_id[] = $lead_owner_email;
                }


                //$arr_email_id[] = '{"email":"updates@infinitylogisticsme.com"}';
                //$arr_email_id[] = '{"email":"aswanth@infinitylogisticsme.com"}';

                $model_job = JobOrder::model()->find(array('condition' => 'id="' . $each['job_order_id'] . '"'));
                if ((int) $each['origin'] > 0) {
                    $origin = MasCountry::model()->findByPk($each['origin'])->country_name;
                }
                if ((int) $each['destination'] > 0) {
                    $dest = MasCountry::model()->findByPk($each['destination'])->country_name;
                }
                if ($model_job['weight'] > 0) {
                    $weight = $model_job['weight'] . " Kg";
                } else {
                    $weight = "";
                }
                if ($model_job['volume'] > 0) {
                    $volume = $model_job['volume'] . " Cbm";
                } else {
                    $volume = "";
                }

                if ($model_job->contact_ids != "") {

                    $contact = explode(",", $model_job->contact_ids);
                    if (count($contact) > 1) {
                        $contatdet = array();
                        foreach ($contact as $row) {

                            $contactdetails = CustomerContact::model()->findByPK($row);
                            $contatdet[] = $contactdetails->person_name;
                        }

                        if (!empty($contatdet)) {
                            $contact_person = implode(",", $contatdet);
                        }
                    } else {
                        $contactdetails = CustomerContact::model()->findByPK($model_job->contact_ids);

                        $contact_person = $contactdetails->person_name;
                    }
                }

                switch ($each['job_order_status']) {
                    case 'PD':
                        $row_job_order_status = "Partially Delivered";
                        break;
                    case 'D':
                        $row_job_order_status = "Delivered";
                        break;
                    case 'C':
                        $row_job_order_status = "Completed";
                        break;
                    case 'I':
                        $row_job_order_status = "Invoiced";
                        break;

                    case 'CN':
                        $row_job_order_status = "Cancel";
                        break;

                    default:
                        $row_job_order_status = "Open";
                        break;
                }
                $email = [];
                $arr_email_id = [];
                $contact_mail = explode(",", $model_job->contact_ids);

                /* if($contact_mail){
                  foreach ($contact_mail as $mail_id) {
                  $contactemail = CustomerContact::model()->findByPK($mail_id);

                  if($contactemail->contact_email_id){

                  $email[] = '{"email":"'.$contactemail->contact_email_id.'"}';
                  }
                  }
                  } */

                if ($contact_mail) {
                    $contact_mail = $contact_mail[0];
                    $contactemail = CustomerContact::model()->findByPK($contact_mail);
                    if ($contactemail->contact_email_id) {
                        $email = '{"email":"' . $contactemail->contact_email_id . '"}';
                        $contact_person = $contactemail->person_name;
                    }
                }

                //$arr_email_id[] = '{"email":"puthumannilrumaiz@gmail.com"}';
                //$arr_email_id[] = '{"email":"nipin@infinitylogisticsme.com"}';
                $arr_email_id[] = '{"email":"updates@infinitylogisticsme.com"}';
                $arr_email_id[] = '{"email":"tracking@infinitylogisticsme.com"}';
                $arr_email_id[] = $email;
                if ($email) {


                    /* if(empty($agent_name)){
                      $agent_name = $each['agent'];
                      } */

                    $data[] = [
                        "id" => $each['job_order_id'] . "",
                        "book_date" => $each['job_date'] . "",
                        "customer_id" => $each['customer_id'] . "",
                        "customer_name" => $each['customer_name'],
                        "customer_email" => $each['customer_email_id'],
                        "consignee_id" => $each['consignee_id'] . "",
                        "agent" => $each['agent'], //$agent_name,
                        "awb_no" => $each['awb_no'] . "",
                        "job_order_status" => $row_job_order_status,
                        "origin" => $origin,
                        "email_ids" => $arr_email_id,
                        "destination" => $dest,
                        "shipper" => $each['shipper_name'],
                        "weight" => $weight,
                        "volume" => $volume,
                        "customer_reference" => $each['customer_id'] . "",
                        "contact_person" => $contact_person,
                    ];
                }
            }

            $data = array('status' => "success", "msg" => "Success", 'item' => $data);
        } else {
            $data = array('status' => "failed", "msg" => "No Data Available", 'item' => $data);
        }
        header("HTTP/1.1 200 OK");
        header('Content-Type: application/json');
        echo json_encode($data);
    }

}
