<?php

class ApiController extends Controller {

    public $round_off = '2';

    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array(
                    'logout', 'error', 'LoginSuccess', 'login'
                ),
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function beforeAction($action) {
        $this->ChangeDB();
        if (Yii::app()->request->isAjaxRequest)
            $this->layout = false;
        return parent::beforeAction($action);
    }

    public function actionLogin() {
        header("HTTP/1.1 200 OK");
        try {

            $username = trim($_REQUEST['username']);
            $password = trim($_REQUEST['password']);
            $company_id = 1; //default one it will chnage when integrate multiple company

            if (empty($username)) {
                $data['status'] = 'failed';
                $data['message'] = 'Username cannot be blank';
            } elseif (empty($password)) {
                $data['status'] = 'failed';
                $data['message'] = 'Password cannot be blank';
            } else {

                $salt = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
                $password = crypt($password, $salt);
                $modelCustomer = new Customer();
                $modelCustomer = $modelCustomer->find(array('condition' => 'LOWER(username)="' . $username . '" AND isActive="Y"'));

                //code modified by mereena on 23/02/2023
                if (empty($modelCustomer)) {
                    $modelUser = new User();
                    $modelUser = $modelUser->find(array('condition' => 'LOWER(username)="' . $username . '" AND password="' . $password . '" AND isActive="Y"'));
                }

                //end
                //code added by mereena on 21/08/2024 to pass agent password
                $modelMasCompanySettings = new MasCompanySettings();
                $modelMasCompanySettings = $modelMasCompanySettings->find();
                $agent_password = $modelMasCompanySettings['agent_password'];
                //end


                if (!empty($modelCustomer)) {

                    $customer_id = $modelCustomer->id;
                    $customer_name = $modelCustomer->customer_name;

                    if ((int) $customer_id > 0) {
                        $modelCustomer->_generate_token;
                    }

                    header("HTTP/1.1 200 OK");
                    header('Content-Type: application/json');
                    $data = array('status' => "success", "data" => ["user_id" => $customer_id, "customer_name" => $customer_name, "company_id" => $company_id, 'level' => 'C', 'agent_password' => $agent_password, "message" => "User authorized"]);
                } else if (!empty($modelUser)) {

                    $customer_id = $modelUser->id;
                    $customer_name = $modelUser->fullName;

                    if ((int) $customer_id > 0) {
                        $modelCustomer->_generate_token;
                    }

                    header("HTTP/1.1 200 OK");
                    header('Content-Type: application/json');
                    $data = array('status' => "success", "data" => ["user_id" => $customer_id . "", "customer_name" => $customer_name, "company_id" => $company_id . "", 'level' => 'A', 'agent_password' => $agent_password, "message" => "User authorized"]);
                } else {
                    header("HTTP/1.1 401 Unauthorized");
                    header('Content-Type: application/json');
                    $data['status'] = 'failed';
                    $data['message'] = 'Unauthorized user';
                }
            }
        } catch (Exception $e) {
            header("HTTP/1.1 404 not found");
            header('Content-Type: application/json');
            $data = array('status' => "error", "message" => "Unexpected Server error");
        }

        echo json_encode($data);
    }

}
