<?php

// uncomment the following to define a path alias
// Yii::setPathOfAlias('local','path/to/local-folder');
// This is the main Web application configuration. Any writable
// CWebApplication properties can be configured here.
Yii::setPathOfAlias('bootstrap', dirname(__FILE__) . '/../extensions/bootstrap');
Yii::setPathOfAlias('editable', dirname(__FILE__) . '/../extensions/editable');
return array(
    'basePath' => dirname(__FILE__) . DIRECTORY_SEPARATOR . '..',
    'name' => 'Cumulus ERP',
    // preloading 'log' component
    'preload' => array('log'),
    // autoloading model and component classes
    'import' => array(
         'application.extensions.*',
        'application.models.*',
        'application.modules.profitcalculation.models.*',
        'application.modules.finance.models.*',
        'application.modules.service.models.*',
        'application.modules.logistics.models.*',
        'application.modules.activity.models.*',
        'editable.*',
        'application.components.*',
        'application.extensions.yii-mail.YiiMailMessage',
        'application.vendors.*',
       // 'application.extensions.CJuiDateTimePicker.CJuiDateTimePicker'
    ),
    'modules' => array(
        // uncomment the following to enable the Gii tool

        'gii' => array(
            'class' => 'system.gii.GiiModule',
            'password' => '@habibi',
            // If removed, Gii defaults to localhost only. Edit carefully to taste.
            'ipFilters' => array('*'),
        ),
    	//new module for profit calculation
        'profitcalculation',
        'finance',
        'fixedasset',
        'cheque',
        'service',
        'workspace', 
        'logistics', 
        'activity', 
    ),
    // application components
    'components' => array(
        'clientScript' => array(
            //'class' => 'application.extensions.CClientScriptMinify',
            //'minifyController' => '/minify',
            'packages' => array(
                'jquery' => array(
                    'baseUrl' => '',
                    'js' => array('js/jquery.min.js'),
                    'coreScriptPosition' => CClientScript::POS_HEAD
                ),
                'jquery.ui' => array(
                    'baseUrl' => '',
                    'js' => array('js/jquery-ui.min.js'),
                    'depends' => array('jquery'),
                    'coreScriptPosition' => CClientScript::POS_END
                ),
            ),
        ),
        'ePdf' => array(
            'class' => 'ext.yii-pdf.EYiiPdf',
            'params' => array(
                 'mpdf' => array(
                    'librarySourcePath' => 'application.vendors.vendor.mpdf.mpdf.*',
                    'constants' => array(
                        '_MPDF_TEMP_PATH' => Yii::getPathOfAlias('application.runtime'),
                    ),
                    'class' => 'Mpdf\Mpdf', // the literal class filename to be loaded from the vendors folder
                /* 'defaultParams'     => array( // More info: http://mpdf1.com/manual/index.php?tid=184
                  'mode'              => '', //  This parameter specifies the mode of the new document.
                  'format'            => 'A4', // format A4, A5, ...
                  'default_font_size' => 0, // Sets the default document font size in points (pt)
                  'default_font'      => '', // Sets the default font-family for the new document.
                  'mgl'               => 15, // margin_left. Sets the page margins for the new document.
                  'mgr'               => 15, // margin_right
                  'mgt'               => 16, // margin_top
                  'mgb'               => 16, // margin_bottom
                  'mgh'               => 9, // margin_header
                  'mgf'               => 9, // margin_footer
                  'orientation'       => 'P', // landscape or portrait orientation
                  ) */
                ),
            /* 'HTML2PDF' => array(
              'librarySourcePath' => 'application.vendors.html2pdf.*',
              'classFile' => 'html2pdf.class.php', // For adding to Yii::$classMap
              'defaultParams'     => array( // More info: http://wiki.spipu.net/doku.php?id=html2pdf:en:v4:accueil
              'orientation' => 'P', // landscape or portrait orientation
              'format'      => 'A4', // format A4, A5, ...
              'language'    => 'en', // language: fr, en, it ...
              'unicode'     => true, // TRUE means clustering the input text IS unicode (default = true)
              'encoding'    => 'UTF-8', // charset encoding; Default is UTF-8
              'marges'      => array(5, 5, 5, 8), // margins by default, in order (left, top, right, bottom)
              )
              ) */
            ),
        ),
        'currency_formator' => array(
            'class' => 'ext.yii-extension-INRCurrencyFormator.INRCurrencyFormator',
            'params' => array(
                'postfix'  => 'only',
                'currency' => '₹'
            )
        ),
        'session' => array(
            'autoStart' => true,
        ),
        'phpThumb' => array(
            'class' => 'ext.EPhpThumb.EPhpThumb',
        //'options'=>array(optional phpThumb specific options are added here)
        ),
        'dateTimePicker' => array(
            'class' => 'ext.CJuiDateTimePicker.CJuiDateTimePicker'
        ),
        'timePicker' => array(
            'class' => 'ext.timepicker.timepicker'
        ),
        'mail' => array(
            'class' => 'application.extensions.yii-mail.YiiMail',
            //'transportType' => 'php',
            'transportType' => 'smtp',
            'transportOptions' => array(
                //'host'=>'dlinkmea.com',
                'host' => 'infinitylogisticsme.com',
                //'encryption'=>'tls',
                //'username' => 'updates@infinitylogisticsme.com',
                //'password' => '1Nf1n1ty8954@',
                  'username' => 'tracking@infinitylogisticsme.com',
                 //'password' => '1Nf1n1ty8954@',
                 'password' => 'g.Umo2!CAoft',
                
                /*'host' => 'cumuluscrm.us',
                'username' => 'noreply@cumuluscrm.us',
                'password' => 'peterpan122',*/
                
                
                
                //'port' => 25,
            'port'=>25
            ),
            'viewPath' => 'application.views.mail',
            'logging' => true,
            'dryRun' => false
        ),
        'user' => array(
            'class' => 'application.components.EWebUser',
            'loginRequiredAjaxResponse' => 'YII_LOGIN_REQUIRED',
            // enable cookie-based authentication
            'allowAutoLogin' => true,
        ),
        // uncomment the following to enable URLs in path-format
       /*  'urlManager' => array(
          'urlFormat' => 'path',
          'showScriptName' => false,
          'caseSensitive' => false,
          'rules' => array(
          '<controller:\w+>/<id:\d+>' => '<controller>/view',
          '<controller:\w+>/<action:\w+>/<id:\d+>' => '<controller>/<action>',
          '<controller:\w+>/<action:\w+>' => '<controller>/<action>',
          ),
          ), */
        /* 'db'=>array(
          'connectionString' => 'sqlite:'.dirname(__FILE__).'/../data/testdrive.db',
          ), */


        // uncomment the following to use a MySQL database
        'db' => array(
            'connectionString' => 'mysql:host=localhost;dbname=blskysoftware_infinity_main',
            'emulatePrepare' => true,
            'username' => 'blskysoftware_infinity',
            'password' => 'b*n-M7G%]xeV',
            'charset' => 'utf8',
            'tablePrefix' => 'erp_',
        ),
        'errorHandler' => array(
            // use 'site/error' action to display errors
            'errorAction' => 'site/error',
        ),
        'log' => array(
            'class' => 'CLogRouter',
            'routes' => array(
                array(
                    'class' => 'CFileLogRoute',
                    'levels' => 'error, warning',
                ),
            // uncomment the following to show log messages on web pages
            /* array(
              'class' => 'CWebLogRoute',
              ), */
            ),
        ),
        //X-editable config
        'editable' => array(
            'class' => 'editable.EditableConfig',
            'form' => 'bootstrap', //form style: 'bootstrap', 'jqueryui', 'plain'
            'mode' => 'popup', //mode: 'popup' or 'inline'
            'defaults' => array(//default settings for all editable elements
                'emptytext' => 'Click to edit'
            )
        ),
        'bootstrap' => array(
            'class' => 'bootstrap.components.Bootstrap',
        ),
    ),
    // application-level parameters that can be accessed
    // using Yii::app()->params['paramName']
    'params' => array(
        // this is used in contact page
        'adminEmail' => 'admin@cumuluscrm.us',
        'defaultPageSize' => 5
    ),
    'behaviors' => array(
        'runEnd' => array(
            'class' => 'application.components.WebApplicationEndBehavior',
        ),
    ),
);