<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'userwithdrawal-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
));
?>
<div class="tab-content">
    <div class="tab-pane active">

        <ul class="clearfix form-ul material row">
            <li class="col-sm-3">
                <?php echo $form->hiddenField($model, 'id'); ?>
                <label for="user_id">User <span style="color:red;">*</span></label>
                <?php echo $form->dropDownList($model, 'user_id', User::getAllUsers(), array('class' => 'form-control tooltipster select2', 'data-label' => '', 'data-search' => true, 'empty' => '-Select-', 'onchange' => 'setavailablebalance()')); ?>
            </li>
            <li id="li_total_amount" style="display:none" class="col-sm-4">
                <label for="avaliable_amount">Available Balance</label>
                <?php echo CHtml::textField('avaliable_amount', '', array('data-label' => '','class'=>'form-control tooltipster')); ?>
            </li>
            <li class="col-sm-2">
                <label for="transfer_date">Transfer Date <span style="color:red;">*</span></label>
                <?php echo $form->textField($model, 'transfer_date', array('class' => 'form-control datepicker', 'title' => 'Transfer Date', 'data-label' => 'Transfer Date(dd/mm/yyyy) ')); ?>
  
            </li>
           
            <li class="col-sm-3">
                <label for="transfer_date">Transfer Amount <span style="color:red;">*</span></label>
                <?php echo $form->textField($model, 'transfer_amount', array('data-label' => '','class' => 'form-control tooltipster ')); ?>
                <?php echo $form->error($model, 'transfer_amount'); ?>
            </li>
            <li class="col-sm-12">
                <label for="transfer_date">Remarks <span style="color:red;">*</span></label>
                <?php echo $form->textArea($model, 'remarks', array('data-label' => '','class' => 'form-control tooltipster ')); ?>
                <?php echo $form->error($model, 'remarks'); ?>
            </li>
        </ul>
    </div>

</div>
<div class="modal-footer">
    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
    <?php
    $url = Yii::app()->createUrl('userwithdrawal/Save');
    echo CHtml::ajaxSubmitButton('Save', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
                                    $("#loader").hide();
                                    if(data.status=="success"){
                                         t8.success("Saved Successfully!");
                                         $(".x.close").click();
                                         reloadTable("#tbl_user_withdrawal_details");
                                    } else {
                                        $("#userwithdrawal-form .userwithdrawal-save-btn").prop("disabled", false);
                                        $("#userwithdrawal-form .userwithdrawal-save-btn").addClass("btn-theme").removeClass("btn_loding");
                                        $.each(data, function(key, val) {
                                                $("#userwithdrawal-form #"+key+"_em_").text(val).show();
                                                t8.error(""+val+"");
                                            });
                                    }
                            }',
        'beforeSend' => 'function(){
                                var available_amount = $("#avaliable_amount").val();  
                                if(available_amount<=0){
                                    t8.warning("Available Balance is too Low. Cant Withdraw Now ");
                                    return false;
                                }else{
                                    $("#loader").show();
                                    $("#userwithdrawal-form .userwithdrawal-save-btn").prop("disabled", true);
                                    $("#userwithdrawal-form .userwithdrawal-save-btn").addClass("btn_loding").removeClass("btn-theme");
                                    $(".toast8-error").hide();
                                }
                            }'
    ), array('id' => 'mybtn' . rand(), 'class' => 'userwithdrawal-save-btn btn btn-theme'));
    ?>
</div>
<?php $this->endWidget(); ?>
<?php $cs = Yii::app()->getClientScript();
$cs->registerScript("datepickerfield", "$(document).ready(function() {
    $('#UserCommissionWithdrawal_transfer_date').datepicker('option', 'dateFormat', 'dd/mm/yy')
});", CClientScript::POS_HEAD);

/* * ************** START get selected plan Details***************************** */
$cs->registerScript("setavailablebalance", "function setavailablebalance(){
    var user_id             = $('#UserCommissionWithdrawal_user_id').val(); 
    if(user_id>0){
        var url                 = $('#liveSite').val()+'index.php?r=userwithdrawal/getSelectedUserBalance';
        var pars                = 'user_id='+user_id+'&frm=userwidrawal';
        $.ajax({
            dataType:'json',
            type: 'post',
            url:  url,
            data: pars,
            success: function(data) {
                if(data.status=='Success'){
                    $('#avaliable_amount').val(data.amount);   
                    $('#li_total_amount').show();    
                }
            },            
        });
    }
    return false;
}", CClientScript::POS_END);
/* * ************** END get selected plan Details ***************************** */
?>

<script>
    
    $(document).ready(function(){
    $("#UserCommissionWithdrawal_user_id").select2();
   
    });
        
    </script>